{-# LANGUAGE RebindableSyntax #-}

import Arduino

flashing :: Stream Bool
flashing = clk (period (2 :: Int16)) (phase 1)

longer_and_longer :: Stream Int16
longer_and_longer = counter true $ counter true false `mod` 64 == 0

counter :: Stream Bool -> Stream Bool -> Stream Int16
counter inc reset = cnt
   where
	cnt = if reset
		then 0
		else if inc
			then z + 1
			else z
	z = [0] ++ cnt

main :: IO ()
main = arduino $ do
	buttonpressed <- boolInput (Pin 14)
	led =: buttonpressed || flashing
	delay =: longer_and_longer
