{-# LANGUAGE LambdaCase #-}

import Control.Monad
import System.FilePath
import System.Directory
import System.Process
import System.Exit

main = do
	examples <- filterM doesFileExist
		=<< (map (</> "demo.hs") . map ("examples" </>))
		<$> getDirectoryContents "examples"
	if null examples
		then error "did not find any examples to test"
		else mapM_ shouldCompile examples

shouldCompile :: FilePath -> IO ()
shouldCompile f = do
	let p = (proc "runghc" ["-Wall", "-fno-warn-tabs", takeFileName f])
		{ cwd = Just (takeDirectory f) }
	readCreateProcessWithExitCode p "" >>= \case
		(ExitSuccess, "", "") -> return ()
		v -> error $ "runghc " ++ f ++
			" produced unexpected result: " ++ show v
