-- | Programming the Arduino Nano with Copilot.

{-# LANGUAGE DataKinds #-}

module Copilot.Arduino.Nano (
	module Copilot.Arduino
	-- * Pins
	, pin2
	, pin3
	, pin4
	, pin5
	, pin6
	, pin7
	, pin8
	, pin9
	, pin10
	, pin11
	, pin12
	, pin13
	, a0
	, a1
	, a2
	, a3
	, a4
	, a5
	, a6
	, a7
	, sizeOfEEPROM
) where

import Copilot.Arduino
import Copilot.Arduino.Internals

pin2, pin4, pin7, pin8, pin12, pin13 :: Pin '[ 'DigitalIO ]
pin3, pin5, pin6, pin9, pin10, pin11 :: Pin '[ 'DigitalIO, 'PWM ]
pin2 = Pin (PinId 2)
pin3 = Pin (PinId 3)
pin4 = Pin (PinId 4)
pin5 = Pin (PinId 5)
pin6 = Pin (PinId 6)
pin7 = Pin (PinId 7)
pin8 = Pin (PinId 8)
pin9 = Pin (PinId 9)
pin10 = Pin (PinId 10)
pin11 = Pin (PinId 11)
pin12 = Pin (PinId 12)
-- | This pin is connected to the `led`
pin13 = Pin (PinId 13)

a0, a1, a2, a3, a4, a5 :: Pin '[ 'AnalogInput, 'DigitalIO ]
a0 = Pin (PinId 14)
a1 = Pin (PinId 15)
a2 = Pin (PinId 16)
a3 = Pin (PinId 17)
a4 = Pin (PinId 18)
a5 = Pin (PinId 19)

-- | Limited to analog input.
a6, a7 :: Pin '[ 'AnalogInput ]
a6 = Pin (PinId 20)
a7 = Pin (PinId 21)

-- | Different versions of Arduino Nano have different EEPROM sizes.
-- This is a safe value that will work on all versions.
sizeOfEEPROM :: Word16
sizeOfEEPROM = 512
