{-# LANGUAGE TemplateHaskell,TypeFamilies,StandaloneDeriving #-}
module Options where


import qualified System.Console.Options as Options


data Verbosity
  = Quiet
  | Normal
  | Verbose
  deriving (Show,Eq)

-- This is an example use of the Options.create Template Haskell function.
-- To see what datatypes this generates, load this module in GHCi and type
-- ":browse".
$(
  Options.create "MyConfig" "MySetting"
    [
      ("foo"      ,Options.ConT ''Integer  )
    , ("bar"      ,Options.ConT ''Bool     )
    , ("verbosity",Options.ConT ''Verbosity)
    ]
 )

deriving instance Show MyConfig

defaults :: MyConfig
defaults = MyConfig
  {
    verbosity_  = Normal
  , foo_        = 42
  , bar_        = True
  }
