module System.Console.Internal where


import           Data.Map (Map)
import qualified System.Console.GetOpt  as GetOpt


-- | An @Action@ is an @IO@ action, which may take arguments
-- (\"non-options\") and options from the command line.
data Action
  = Action
  {
    run        :: [String] -> Map Identifier (Maybe String) -> IO ()
  , nonOptions :: [String]
  , options    :: [GetOpt.OptDescr (Identifier,Maybe String)]
  }

data Identifier = Short Char | Long String
  deriving (Eq,Ord)

-- | A value of type @Option a@ describes an option, that delivers a value
-- to the program of type @a@.
data Option a = Option
  Identifier
  (GetOpt.OptDescr (Identifier,Maybe String))
  a
  (Maybe String -> Either String a)


-- | A @Command@ is an action, together with some descriptive information.
-- The description, and lists of applicable options and non-options are
-- used only to show usage information for the command.
data Command
  = Command
    {
      name :: String
      -- ^ This determines which command is executed, depending on the command line.
    , description :: String
      -- ^ For usage info.
    , action :: Action
      -- ^ The actual action performed by this command.
    }
