module System.Console.Internal where


import           Data.Map (Map)
import qualified System.Console.GetOpt  as GetOpt


-- | An @Action@ is an @IO@ action, which may take arguments
-- (\"non-options\") and options from the command line.
data Action
  = Action
  {
    run        :: [String] -> Map Identifier (Maybe String) -> IO ()
  , nonOptions :: [String]
  , options    :: [GetOpt.OptDescr (Identifier,Maybe String)]
  }

data Identifier = Short Char | Long String
  deriving (Eq,Ord)

-- | A value of type @Option a@ describes an option, that delivers a value
-- to the program of type @a@.
data Option a = Option
  Identifier
  (GetOpt.OptDescr (Identifier,Maybe String))
  a
  (Maybe String -> Either String a)


-- | A @Command@ is an action, together with some descriptive information.
data Command
  = Command
    {
      -- | This determines which command is executed.
      name :: String
      -- | For usage info.
    , description :: String
      -- | The actual action performed by this command.
    , action :: Action
    }
