PROXY LIST
----------

Very simple library for downloading a list of proxies from http://proxy-list.org

HOW TO USE
----------

Library exports two functions.
Proxy is represented by a tuple (Host, Port).


```haskell
getProxyList :: Bool -> IO [(String, Int)]
getProxyList ssl
 
Argument indicates if requested proxy servers should have HTTPS support. 
Returns a list of proxy servers.

randomProxy :: [(String, Int)] -> (String, Int)
randomProxy proxyList

Selects random proxy.
```

**Example:**

```haskell
import HTTP.ThirdParty.ProxyList

main = do
    proxyList <- getProxyList True
    proxyServer <- randomProxy proxyList
    print proxyServer
```
