# http-api-data

[![Hackage package](http://img.shields.io/hackage/v/http-api-data.svg)](http://hackage.haskell.org/package/http-api-data)
[![Build Status](https://secure.travis-ci.org/fizruk/http-api-data.png?branch=master)](http://travis-ci.org/fizruk/http-api-data)

This package defines typeclasses used for converting Haskell data types to and from HTTP API data.

### Examples

Booleans:

```
>>> toUrlPiece True
"True"
>>> parseUrlPiece "False" :: Either Text Bool
Right False
>>> parseUrlPiece "something else" :: Either Text Bool
Left "could not parse: `something else'"
```

Numbers:

```
>>> toUrlPiece 45.2
"45.2"
>>> parseUrlPiece "452" :: Either Text Int
Right 452
>>> parseUrlPiece "256" :: Either Text Int8
Left "out of bounds: `256' (should be between -128 and 127)"
```

Strings:

```
>>> toHeader "hello"
"hello"
>>> parseHeader "world" :: Either Text String
Right "world"
```

Calendar day:

```
>>> toQueryParam (fromGregorian 2015 10 03)
"2015-10-03"
>>> toGregorian <$> parseQueryParam "2016-12-01"
Right (2016,12,1)
```

## Contributing

Contributions and bug reports are welcome!

