module PostgreSQLBinary.PTI where

import BasePrelude


-- | A Postgresql type info
data PTI = PTI { oidOf :: !Word32, arrayOIDOf :: !(Maybe Word32) }

abstime         = PTI 702  (Just 1023)
aclitem         = PTI 1033 (Just 1034)
bit             = PTI 1560 (Just 1561)
bool            = PTI 16   (Just 1000)
box             = PTI 603  (Just 1020)
bpchar          = PTI 1042 (Just 1014)
bytea           = PTI 17   (Just 1001)
char            = PTI 18   (Just 1002)
cid             = PTI 29   (Just 1012)
cidr            = PTI 650  (Just 651)
circle          = PTI 718  (Just 719)
cstring         = PTI 2275 (Just 1263)
date            = PTI 1082 (Just 1182)
daterange       = PTI 3912 (Just 3913)
float4          = PTI 700  (Just 1021)
float8          = PTI 701  (Just 1022)
gtsvector       = PTI 3642 (Just 3644)
inet            = PTI 869  (Just 1041)
int2            = PTI 21   (Just 1005)
int2vector      = PTI 22   (Just 1006)
int4            = PTI 23   (Just 1007)
int4range       = PTI 3904 (Just 3905)
int8            = PTI 20   (Just 1016)
int8range       = PTI 3926 (Just 3927)
interval        = PTI 1186 (Just 1187)
json            = PTI 114  (Just 199)
line            = PTI 628  (Just 629)
lseg            = PTI 601  (Just 1018)
macaddr         = PTI 829  (Just 1040)
money           = PTI 790  (Just 791)
name            = PTI 19   (Just 1003)
numeric         = PTI 1700 (Just 1231)
numrange        = PTI 3906 (Just 3907)
oid             = PTI 26   (Just 1028)
oidvector       = PTI 30   (Just 1013)
path            = PTI 602  (Just 1019)
point           = PTI 600  (Just 1017)
polygon         = PTI 604  (Just 1027)
record          = PTI 2249 (Just 2287)
refcursor       = PTI 1790 (Just 2201)
regclass        = PTI 2205 (Just 2210)
regconfig       = PTI 3734 (Just 3735)
regdictionary   = PTI 3769 (Just 3770)
regoper         = PTI 2203 (Just 2208)
regoperator     = PTI 2204 (Just 2209)
regproc         = PTI 24   (Just 1008)
regprocedure    = PTI 2202 (Just 2207)
regtype         = PTI 2206 (Just 2211)
reltime         = PTI 703  (Just 1024)
text            = PTI 25   (Just 1009)
tid             = PTI 27   (Just 1010)
time            = PTI 1083 (Just 1183)
timestamp       = PTI 1114 (Just 1115)
timestamptz     = PTI 1184 (Just 1185)
timetz          = PTI 1266 (Just 1270)
tinterval       = PTI 704  (Just 1025)
tsquery         = PTI 3615 (Just 3645)
tsrange         = PTI 3908 (Just 3909)
tstzrange       = PTI 3910 (Just 3911)
tsvector        = PTI 3614 (Just 3643)
txid_snapshot   = PTI 2970 (Just 2949)
unknown         = PTI 705  Nothing
uuid            = PTI 2950 (Just 2951)
varbit          = PTI 1562 (Just 1563)
varchar         = PTI 1043 (Just 1015)
void            = PTI 2278 Nothing
xid             = PTI 28   (Just 1011)
xml             = PTI 142  (Just 143)

