-- autogenerated from https://www.unicode.org/Public/17.0.0/ucd/Scripts.txt
-- |
-- Module      : Unicode.Internal.Char.ScriptExtensions
-- Copyright   : (c) 2022 Composewell Technologies and Contributors
-- License     : Apache-2.0
-- Maintainer  : streamly@composewell.com
-- Stability   : experimental

{-# OPTIONS_HADDOCK hide #-}

module Unicode.Internal.Char.ScriptExtensions
(scriptExtensions)
where

import Data.Char (ord)
import Data.Int (Int16)
import Data.Word (Word16)
import GHC.Exts (Addr#, Int#, Int(..), Ptr(..), andI#, iShiftL#, iShiftRL#, negateInt#, nullAddr#, (+#), (-#))
import Unicode.Internal.Bits.Scripts (lookupWord16AsInt#)

-- | Script extensions of a character.
--
-- Returns a pair:
--
-- * If first value is negative or zero, then its absolute value is a single script,
--   encoded by its index.
-- * Else the first element is the length and the second is the list of scripts,
--   encoded by their index.
--
-- @since 0.1.0
scriptExtensions :: Char -> (# Int#, Addr# #)
scriptExtensions c = case encodedScriptExtensions c of
    175# -> (# 2#, "\0\3"# #)
    176# -> (# 8#, "\0\3\40\52\105\145\157\172"# #)
    177# -> (# 3#, "\0\3\111"# #)
    178# -> (# 9#, "\0\3\52\85\86\119\128\139\145"# #)
    179# -> (# 11#, "\20\23\26\30\43\45\74\121\145\160\162"# #)
    180# -> (# 7#, "\20\23\43\74\143\145\158"# #)
    181# -> (# 3#, "\20\74\162"# #)
    182# -> (# 2#, "\3\26"# #)
    183# -> (# 7#, "\3\40\52\105\145\157\172"# #)
    184# -> (# 2#, "\3\105"# #)
    185# -> (# 2#, "\3\52"# #)
    186# -> (# 2#, "\3\145"# #)
    187# -> (# 3#, "\3\145\157"# #)
    188# -> (# 2#, "\3\157"# #)
    189# -> (# 3#, "\3\157\172"# #)
    190# -> (# 11#, "\4\30\35\43\45\55\74\114\145\148\160"# #)
    191# -> (# 3#, "\4\41\42"# #)
    192# -> (# 16#, "\5\19\26\35\37\41\42\43\45\47\50\74\81\82\114\134"# #)
    193# -> (# 7#, "\5\19\41\62\81\111\131"# #)
    194# -> (# 2#, "\5\118"# #)
    195# -> (# 3#, "\10\21\144"# #)
    196# -> (# 7#, "\10\30\32\74\79\158\164"# #)
    197# -> (# 2#, "\10\32"# #)
    198# -> (# 23#, "\10\32\34\44\46\47\48\49\63\71\76\82\84\88\102\110\120\138\144\152\153\156\161"# #)
    199# -> (# 21#, "\10\32\34\44\46\47\48\63\71\82\84\88\102\110\120\138\144\152\153\156\161"# #)
    200# -> (# 15#, "\10\32\44\46\48\63\74\84\102\104\120\133\153\156\161"# #)
    201# -> (# 13#, "\10\32\44\46\48\63\74\84\104\120\153\156\161"# #)
    202# -> (# 4#, "\10\32\44\63"# #)
    203# -> (# 11#, "\10\32\44\63\84\102\120\138\156\161\165"# #)
    204# -> (# 4#, "\10\32\104\133"# #)
    205# -> (# 4#, "\10\32\104\156"# #)
    206# -> (# 5#, "\10\32\104\156\161"# #)
    207# -> (# 3#, "\10\32\133"# #)
    208# -> (# 3#, "\10\32\156"# #)
    209# -> (# 3#, "\10\32\165"# #)
    210# -> (# 5#, "\13\50\51\56\64"# #)
    211# -> (# 9#, "\13\50\51\56\64\79\96\159\173"# #)
    212# -> (# 8#, "\13\50\51\56\64\96\126\173"# #)
    213# -> (# 8#, "\13\50\51\56\64\96\159\173"# #)
    214# -> (# 7#, "\13\50\51\56\64\96\173"# #)
    215# -> (# 6#, "\13\50\51\56\64\173"# #)
    216# -> (# 2#, "\13\50"# #)
    217# -> (# 2#, "\13\74"# #)
    218# -> (# 2#, "\16\61"# #)
    219# -> (# 4#, "\17\53\146\147"# #)
    220# -> (# 3#, "\21\99\148"# #)
    221# -> (# 6#, "\19\41\42\80\111\118"# #)
    222# -> (# 4#, "\19\45\93\111"# #)
    223# -> (# 8#, "\23\26\30\45\74\114\143\148"# #)
    224# -> (# 8#, "\23\30\45\74\121\143\148\162"# #)
    225# -> (# 4#, "\23\30\74\121"# #)
    226# -> (# 4#, "\23\30\74\160"# #)
    227# -> (# 6#, "\23\35\64\74\145\160"# #)
    228# -> (# 4#, "\23\35\74\145"# #)
    229# -> (# 3#, "\23\74\145"# #)
    230# -> (# 3#, "\23\74\148"# #)
    231# -> (# 9#, "\26\35\55\74\114\145\148\160\162"# #)
    232# -> (# 6#, "\26\37\42\43\64\74"# #)
    233# -> (# 2#, "\26\45"# #)
    234# -> (# 2#, "\26\74"# #)
    235# -> (# 3#, "\28\29\78"# #)
    236# -> (# 3#, "\28\77\78"# #)
    237# -> (# 2#, "\28\78"# #)
    238# -> (# 2#, "\30\42"# #)
    239# -> (# 5#, "\30\45\74\114\160"# #)
    240# -> (# 2#, "\30\74"# #)
    241# -> (# 3#, "\30\74\145"# #)
    242# -> (# 3#, "\30\74\162"# #)
    243# -> (# 2#, "\30\114"# #)
    244# -> (# 16#, "\32\34\46\48\62\63\70\71\82\84\95\102\133\152\161\165"# #)
    245# -> (# 15#, "\32\34\46\48\62\63\70\71\82\95\102\133\152\161\165"# #)
    246# -> (# 12#, "\32\34\46\48\62\70\71\82\95\133\152\161"# #)
    247# -> (# 11#, "\32\34\46\48\62\70\71\82\95\152\161"# #)
    248# -> (# 4#, "\32\34\62\82"# #)
    249# -> (# 2#, "\32\44"# #)
    250# -> (# 3#, "\32\44\63"# #)
    251# -> (# 4#, "\32\44\63\165"# #)
    252# -> (# 3#, "\32\44\74"# #)
    253# -> (# 6#, "\32\63\84\120\153\156"# #)
    254# -> (# 3#, "\32\102\104"# #)
    255# -> (# 2#, "\32\104"# #)
    256# -> (# 3#, "\32\104\133"# #)
    257# -> (# 3#, "\32\104\161"# #)
    258# -> (# 2#, "\32\133"# #)
    259# -> (# 2#, "\32\153"# #)
    260# -> (# 3#, "\35\74\145"# #)
    261# -> (# 2#, "\39\74"# #)
    262# -> (# 3#, "\41\42\74"# #)
    263# -> (# 5#, "\42\74\143\145\158"# #)
    264# -> (# 2#, "\44\153"# #)
    265# -> (# 4#, "\45\74\114\162"# #)
    266# -> (# 2#, "\46\70"# #)
    267# -> (# 2#, "\48\98"# #)
    268# -> (# 3#, "\50\56\64"# #)
    269# -> (# 2#, "\50\74"# #)
    270# -> (# 2#, "\50\155"# #)
    271# -> (# 2#, "\56\64"# #)
    272# -> (# 3#, "\66\74\99"# #)
    273# -> (# 3#, "\63\102\165"# #)
    274# -> (# 2#, "\74\79"# #)
    275# -> (# 3#, "\74\96\126"# #)
    276# -> (# 2#, "\74\121"# #)
    277# -> (# 2#, "\74\143"# #)
    278# -> (# 3#, "\74\143\145"# #)
    279# -> (# 2#, "\74\145"# #)
    280# -> (# 2#, "\74\160"# #)
    281# -> (# 2#, "\74\158"# #)
    282# -> (# 2#, "\86\119"# #)
    283# -> (# 2#, "\96\126"# #)
    s    -> (# negateInt# s, nullAddr# #)

{-# INLINE encodedScriptExtensions #-}
encodedScriptExtensions :: Char -> Int#
encodedScriptExtensions c
    -- Planes 0-3
    | cp < 0x3347A = lookupEncodedScriptExtensionsBitMap cp#
    -- Planes 4-13: 167
    | cp < 0xE0000 = 167#
    -- Plane 14
    | cp < 0xE01F0 = lookupEncodedScriptExtensionsBitMap (cp# -# 0xACB86#)
    -- Default: 167
    | otherwise = 167#
    where
    !cp@(I# cp#) = ord c

{-# INLINE lookupEncodedScriptExtensionsBitMap #-}
lookupEncodedScriptExtensionsBitMap :: Int# -> Int#
lookupEncodedScriptExtensionsBitMap n =
    lookupWord16AsInt# data# (
        lookupWord16AsInt# offsets1# (
            lookupWord16AsInt# offsets2# (
                n `iShiftRL#` 8#
            ) +# ((n `iShiftRL#` 3#) `andI#` maskOffsets)
        ) +# (n `andI#` maskData)
    )
    where
    maskData = (1# `iShiftL#` 3#) -# 1#
    maskOffsets = (1# `iShiftL#` 5#) -# 1#
    !(Ptr data#) = encodedScriptExtensionsDataBitMap
    !(Ptr offsets1#) = encodedScriptExtensionsOffsets1BitMap
    !(Ptr offsets2#) = encodedScriptExtensionsOffsets2BitMap

encodedScriptExtensionsDataBitMap :: Ptr Int16
encodedScriptExtensionsDataBitMap = Ptr
    "\101\0\101\0\101\0\101\0\101\0\101\0\101\0\101\0\167\0\167\0\167\0\167\0\167\0\167\0\3\0\3\0\167\0\3\0\167\0\167\0\3\0\3\0\3\0\3\0\3\0\3\0\3\0\7\0\7\0\7\0\7\0\7\0\7\0\7\0\7\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\51\0\51\0\51\0\167\0\167\0\167\0\86\0\86\0\
    \\86\0\86\0\86\0\26\1\86\0\86\0\86\0\86\0\167\0\128\0\128\0\128\0\128\0\128\0\128\0\128\0\128\0\167\0\167\0\167\0\167\0\167\0\167\0\25\0\25\0\25\0\25\0\167\0\167\0\167\0\167\0\25\0\25\0\25\0\167\0\167\0\167\0\25\0\25\0\217\0\217\0\217\0\25\0\18\1\25\0\25\0\25\0\25\0\25\0\25\0\
    \\25\0\25\1\167\0\39\0\39\0\39\0\39\0\39\0\39\0\167\0\39\0\39\0\39\0\39\0\167\0\167\0\39\0\39\0\39\0\39\0\39\0\167\0\167\0\167\0\15\1\15\1\15\1\15\1\56\0\56\0\56\0\56\0\56\0\56\0\56\0\167\0\194\0\193\0\25\0\25\0\25\0\25\0\25\0\25\0\35\0\25\0\25\0\25\0\25\0\25\0\
    \\210\0\210\0\25\0\177\0\25\0\238\0\25\0\25\0\25\0\25\0\35\0\25\0\25\0\25\0\74\0\74\0\25\0\25\0\25\0\25\0\25\0\25\0\45\0\25\0\25\0\74\0\74\0\25\0\25\0\25\0\25\0\25\0\25\0\74\0\25\0\1\0\1\0\1\0\1\0\1\0\1\0\1\0\1\0\167\0\167\0\167\0\167\0\33\0\167\0\167\0\
    \\33\0\33\0\33\0\33\0\33\0\33\0\167\0\33\0\249\0\249\0\102\0\167\0\167\0\167\0\167\0\167\0\86\0\86\0\86\0\86\0\86\0\86\0\86\0\167\0\128\0\128\0\128\0\128\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\171\0\189\0\189\0\189\0\189\0\189\0\189\0\189\0\189\0\3\0\3\0\3\0\3\0\3\0\3\0\
    \\167\0\167\0\167\0\167\0\167\0\167\0\25\0\25\0\74\0\167\0\167\0\25\0\25\0\25\0\25\0\25\0\25\0\25\0\167\0\167\0\167\0\25\0\25\0\25\0\25\0\25\0\167\0\167\0\25\0\25\0\25\0\25\0\25\0\25\0\25\0\19\1\135\0\135\0\135\0\135\0\135\0\135\0\135\0\135\0\167\0\167\0\165\0\165\0\167\0\167\0\
    \\167\0\167\0\167\0\167\0\167\0\20\0\14\0\14\0\14\0\14\0\14\0\14\0\14\0\14\0\167\0\167\0\40\0\40\0\40\0\40\0\40\0\40\0\40\0\40\0\167\0\167\0\60\0\60\0\60\0\60\0\60\0\60\0\60\0\60\0\167\0\167\0\5\0\5\0\5\0\5\0\5\0\5\0\5\0\5\0\167\0\167\0\67\0\67\0\67\0\67\0\
    \\67\0\67\0\67\0\67\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\48\0\48\0\48\0\48\0\167\0\48\0\167\0\167\0\167\0\167\0\167\0\167\0\92\0\92\0\92\0\92\0\92\0\92\0\92\0\92\0\47\0\47\0\47\0\47\0\47\0\47\0\47\0\47\0\167\0\47\0\47\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\14\1\
    \\14\1\14\1\14\1\14\1\14\1\14\1\14\1\130\0\130\0\130\0\130\0\130\0\130\0\130\0\130\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\167\0\167\0\167\0\167\0\45\0\25\0\45\0\25\0\215\0\215\0\215\0\215\0\215\0\64\0\64\0\64\0\215\0\15\1\64\0\64\0\64\0\
    \\64\0\64\0\64\0\64\0\64\0\50\0\96\0\96\0\27\1\27\1\96\0\27\1\96\0\96\0\96\0\96\0\96\0\96\0\96\0\96\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\10\0\10\0\167\0\10\0\167\0\167\0\167\0\10\0\10\0\167\0\167\0\10\0\10\0\10\0\10\0\167\0\10\0\10\0\10\0\45\0\167\0\167\0\
    \\167\0\167\0\167\0\167\0\167\0\138\0\167\0\167\0\167\0\167\0\138\0\138\0\138\0\138\0\138\0\138\0\138\0\138\0\167\0\138\0\167\0\167\0\159\0\159\0\159\0\159\0\159\0\159\0\159\0\159\0\167\0\159\0\159\0\22\0\22\0\22\0\22\0\22\0\22\0\22\0\22\0\167\0\167\0\56\0\56\0\56\0\56\0\56\0\56\0\56\0\
    \\56\0\167\0\167\0\64\0\167\0\167\0\235\0\235\0\237\0\167\0\167\0\167\0\167\0\236\0\236\0\236\0\236\0\236\0\236\0\236\0\236\0\167\0\167\0\167\0\237\0\237\0\237\0\237\0\237\0\237\0\237\0\237\0\78\0\78\0\78\0\167\0\78\0\78\0\167\0\78\0\78\0\78\0\78\0\78\0\78\0\167\0\167\0\167\0\167\0\167\0\
    \\167\0\167\0\160\0\160\0\160\0\160\0\160\0\160\0\160\0\160\0\50\0\50\0\216\0\216\0\216\0\216\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\25\0\214\0\212\0\210\0\25\0\50\0\50\0\50\0\167\0\25\0\167\0\167\0\167\0\167\0\58\0\58\0\58\0\58\0\58\0\58\0\30\0\30\0\30\0\30\0\30\0\30\0\
    \\30\0\238\0\44\0\167\0\167\0\44\0\44\0\44\0\44\0\44\0\167\0\167\0\44\0\44\0\44\0\167\0\167\0\44\0\44\0\44\0\44\0\44\0\44\0\44\0\44\0\78\0\78\0\78\0\78\0\78\0\78\0\78\0\78\0\167\0\78\0\78\0\78\0\78\0\78\0\78\0\167\0\167\0\167\0\167\0\167\0\63\0\63\0\167\0\167\0\63\0\
    \\63\0\63\0\63\0\120\0\120\0\167\0\167\0\120\0\120\0\120\0\120\0\120\0\167\0\167\0\120\0\120\0\120\0\167\0\167\0\120\0\120\0\120\0\120\0\120\0\120\0\120\0\120\0\44\0\167\0\44\0\44\0\44\0\44\0\44\0\44\0\44\0\44\0\167\0\167\0\167\0\167\0\167\0\167\0\44\0\44\0\44\0\132\0\132\0\132\0\132\0\
    \\132\0\132\0\132\0\132\0\167\0\167\0\167\0\167\0\167\0\167\0\132\0\132\0\39\0\39\0\39\0\39\0\167\0\39\0\39\0\167\0\158\0\158\0\158\0\158\0\158\0\158\0\158\0\158\0\167\0\167\0\167\0\167\0\25\0\167\0\167\0\25\0\25\0\167\0\45\0\167\0\45\0\167\0\45\0\167\0\45\0\112\0\112\0\112\0\112\0\112\0\
    \\112\0\112\0\112\0\167\0\167\0\167\0\167\0\167\0\112\0\112\0\112\0\9\0\9\0\9\0\9\0\9\0\9\0\9\0\9\0\167\0\167\0\167\0\167\0\9\0\9\0\9\0\9\0\48\0\167\0\167\0\48\0\48\0\48\0\167\0\167\0\48\0\167\0\48\0\48\0\167\0\48\0\48\0\167\0\3\0\3\0\188\0\3\0\3\0\3\0\3\0\
    \\3\0\188\0\3\0\3\0\3\0\3\0\3\0\3\0\184\0\184\0\95\0\95\0\95\0\95\0\95\0\95\0\95\0\95\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\94\0\21\1\242\0\58\0\9\1\58\0\58\0\58\0\58\0\25\0\25\0\58\0\58\0\58\0\58\0\25\0\25\0\25\0\25\0\25\0\25\0\25\0\58\0\167\0\167\0\
    \\28\0\167\0\28\0\28\0\28\0\28\0\28\0\28\0\28\0\28\0\167\0\28\0\151\0\151\0\151\0\151\0\151\0\151\0\151\0\151\0\167\0\167\0\18\0\18\0\18\0\18\0\18\0\18\0\18\0\18\0\167\0\167\0\87\0\87\0\87\0\87\0\87\0\87\0\87\0\167\0\12\0\12\0\12\0\12\0\12\0\12\0\12\0\12\0\167\0\167\0\
    \\167\0\77\0\77\0\77\0\77\0\77\0\77\0\77\0\77\0\167\0\167\0\25\0\159\0\159\0\167\0\167\0\167\0\167\0\167\0\4\0\4\0\4\0\4\0\4\0\4\0\4\0\4\0\167\0\45\0\45\0\58\0\58\0\58\0\58\0\58\0\58\0\74\0\74\0\74\0\74\0\74\0\25\0\74\0\74\0\74\0\74\0\74\0\74\0\74\0\74\0\
    \\25\0\25\0\25\0\25\0\25\0\25\0\25\0\217\0\157\0\157\0\157\0\157\0\157\0\157\0\157\0\157\0\167\0\167\0\167\0\167\0\167\0\167\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\167\0\55\0\167\0\131\0\131\0\131\0\131\0\131\0\131\0\131\0\131\0\167\0\167\0\76\0\76\0\76\0\76\0\76\0\76\0\76\0\
    \\76\0\167\0\148\0\148\0\148\0\148\0\148\0\148\0\167\0\167\0\167\0\149\0\149\0\149\0\149\0\149\0\149\0\149\0\149\0\167\0\167\0\149\0\45\0\45\0\45\0\30\0\74\0\74\0\74\0\74\0\74\0\74\0\74\0\45\0\45\0\45\0\45\0\233\0\233\0\45\0\45\0\74\0\25\0\25\0\25\0\167\0\167\0\167\0\167\0\167\0\
    \\167\0\167\0\156\0\156\0\167\0\160\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\160\0\25\0\25\0\221\0\25\0\25\0\222\0\25\0\25\0\13\0\13\0\25\0\25\0\25\0\25\0\25\0\25\0\25\0\74\0\74\0\74\0\74\0\74\0\74\0\74\0\167\0\167\0\167\0\167\0\167\0\120\0\120\0\120\0\90\0\90\0\90\0\90\0\
    \\90\0\90\0\90\0\90\0\167\0\167\0\167\0\167\0\167\0\167\0\123\0\123\0\123\0\100\0\100\0\100\0\100\0\100\0\100\0\100\0\100\0\167\0\145\0\145\0\145\0\167\0\167\0\167\0\167\0\167\0\67\0\67\0\67\0\67\0\67\0\67\0\67\0\67\0\167\0\67\0\67\0\167\0\86\0\86\0\86\0\86\0\86\0\86\0\86\0\86\0\
    \\167\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\167\0\140\0\140\0\140\0\140\0\140\0\140\0\140\0\140\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\146\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\167\0\71\0\71\0\71\0\167\0\167\0\167\0\167\0\167\0\167\0\11\1\11\1\11\1\11\1\11\1\11\1\
    \\11\1\11\1\27\0\27\0\27\0\27\0\27\0\167\0\167\0\167\0\167\0\167\0\167\0\8\1\8\1\2\0\2\0\2\0\2\0\2\0\2\0\2\0\2\0\167\0\97\0\97\0\97\0\97\0\97\0\97\0\97\0\97\0\167\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\167\0\107\0\107\0\107\0\107\0\107\0\107\0\107\0\107\0\
    \\167\0\167\0\167\0\167\0\107\0\107\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\167\0\25\0\217\0\25\0\25\0\25\0\25\0\25\0\25\0\25\0\25\1\45\0\45\0\26\0\26\0\26\0\26\0\26\0\26\0\26\0\26\0\55\0\55\0\167\0\55\0\55\0\167\0\55\0\55\0\55\0\55\0\55\0\167\0\167\0\167\0\167\0\
    \\55\0\145\0\145\0\145\0\145\0\145\0\145\0\145\0\145\0\167\0\145\0\10\0\167\0\10\0\10\0\10\0\10\0\10\0\10\0\10\0\10\0\167\0\167\0\10\0\167\0\48\0\48\0\48\0\167\0\48\0\48\0\48\0\48\0\48\0\48\0\48\0\48\0\167\0\167\0\167\0\167\0\48\0\167\0\46\0\46\0\46\0\167\0\46\0\46\0\46\0\
    \\46\0\46\0\46\0\46\0\46\0\167\0\46\0\167\0\120\0\120\0\120\0\167\0\120\0\120\0\120\0\120\0\120\0\120\0\120\0\120\0\73\0\73\0\73\0\167\0\73\0\73\0\73\0\73\0\73\0\73\0\73\0\73\0\167\0\73\0\167\0\73\0\73\0\167\0\73\0\167\0\73\0\73\0\41\0\41\0\41\0\167\0\167\0\41\0\41\0\41\0\
    \\6\1\41\0\41\0\41\0\41\0\41\0\41\0\41\0\41\0\167\0\41\0\23\0\23\0\23\0\23\0\23\0\23\0\23\0\23\0\167\0\167\0\146\0\146\0\146\0\146\0\146\0\146\0\146\0\146\0\167\0\167\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\69\0\167\0\167\0\148\0\148\0\148\0\148\0\148\0\148\0\148\0\148\0\167\0\
    \\167\0\103\0\103\0\103\0\103\0\167\0\167\0\167\0\167\0\167\0\167\0\138\0\138\0\138\0\167\0\167\0\167\0\229\0\180\0\58\0\58\0\58\0\58\0\58\0\58\0\58\0\58\0\167\0\167\0\167\0\167\0\120\0\120\0\167\0\120\0\75\0\75\0\167\0\167\0\167\0\75\0\75\0\75\0\75\0\75\0\194\0\193\0\25\0\25\0\25\0\
    \\25\0\25\0\25\0\25\0\234\0\74\0\25\0\25\0\25\0\196\0\25\0\25\0\25\0\50\0\50\0\50\0\50\0\50\0\50\0\50\0\50\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\129\0\173\0\173\0\173\0\173\0\173\0\173\0\173\0\173\0\167\0\167\0\167\0\66\0\66\0\66\0\66\0\66\0\66\0\66\0\66\0\16\1\66\0\
    \\61\0\61\0\61\0\61\0\61\0\61\0\61\0\61\0\167\0\218\0\166\0\166\0\166\0\166\0\166\0\166\0\166\0\166\0\167\0\166\0\115\0\115\0\115\0\115\0\115\0\115\0\115\0\115\0\167\0\167\0\167\0\167\0\63\0\63\0\63\0\167\0\167\0\167\0\167\0\64\0\64\0\64\0\64\0\64\0\64\0\15\1\15\1\122\0\122\0\122\0\
    \\122\0\122\0\122\0\122\0\122\0\167\0\167\0\74\0\167\0\74\0\74\0\74\0\74\0\74\0\74\0\167\0\74\0\28\0\167\0\28\0\28\0\28\0\28\0\28\0\28\0\167\0\167\0\167\0\28\0\167\0\167\0\28\0\57\0\57\0\57\0\57\0\57\0\57\0\57\0\57\0\167\0\57\0\19\0\19\0\19\0\19\0\19\0\19\0\19\0\19\0\
    \\167\0\167\0\167\0\167\0\167\0\167\0\167\0\14\0\14\0\14\0\14\0\14\0\14\0\167\0\167\0\98\0\98\0\98\0\98\0\98\0\98\0\98\0\98\0\167\0\98\0\98\0\98\0\98\0\167\0\98\0\33\0\33\0\33\0\33\0\33\0\33\0\33\0\33\0\167\0\33\0\33\0\167\0\167\0\167\0\167\0\167\0\167\0\118\0\118\0\118\0\
    \\118\0\118\0\118\0\118\0\118\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\102\0\102\0\102\0\102\0\102\0\102\0\102\0\102\0\12\0\167\0\12\0\12\0\12\0\12\0\12\0\12\0\12\0\167\0\98\0\98\0\167\0\167\0\167\0\167\0\167\0\167\0\87\0\87\0\87\0\87\0\87\0\87\0\87\0\87\0\47\0\47\0\167\0\47\0\
    \\47\0\47\0\47\0\47\0\47\0\47\0\47\0\163\0\163\0\163\0\163\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\100\0\65\0\167\0\65\0\65\0\65\0\65\0\65\0\65\0\65\0\65\0\167\0\167\0\167\0\167\0\167\0\8\1\8\1\153\0\8\1\153\0\153\0\153\0\153\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\153\0\
    \\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\167\0\167\0\167\0\36\0\36\0\36\0\36\0\36\0\36\0\36\0\36\0\167\0\167\0\8\0\8\0\8\0\8\0\8\0\8\0\8\0\8\0\167\0\167\0\123\0\123\0\123\0\123\0\123\0\123\0\123\0\123\0\167\0\167\0\68\0\68\0\68\0\68\0\68\0\68\0\68\0\68\0\167\0\
    \\167\0\35\0\35\0\167\0\167\0\35\0\35\0\35\0\35\0\35\0\35\0\35\0\35\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\14\0\50\0\50\0\50\0\50\0\12\1\12\1\50\0\50\0\167\0\50\0\50\0\50\0\50\0\50\0\50\0\50\0\25\0\25\0\25\0\25\0\25\0\25\0\25\0\25\0\167\0\25\0\25\0\25\0\25\0\
    \\167\0\25\0\25\0\149\0\149\0\167\0\167\0\167\0\167\0\167\0\167\0\137\0\137\0\137\0\137\0\137\0\137\0\137\0\137\0\91\0\91\0\91\0\91\0\91\0\91\0\91\0\91\0\167\0\167\0\91\0\0\0\0\0\0\0\0\0\167\0\167\0\167\0\167\0\0\0\0\0\167\0\3\0\167\0\3\0\167\0\3\0\167\0\3\0\3\0\3\0\
    \\3\0\167\0\3\0\167\0\3\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\25\0\25\0\74\0\25\0\25\0\25\0\25\0\25\0\25\0\25\0\192\0\45\0\45\0\45\0\45\0\45\0\167\0\45\0\45\0\45\0\45\0\45\0\45\0\45\0\45\0\167\0\167\0\45\0\45\0\45\0\45\0\25\0\45\0\167\0\3\0\3\0\3\0\167\0\
    \\3\0\3\0\3\0\186\0\186\0\186\0\186\0\186\0\186\0\3\0\3\0\10\0\167\0\167\0\10\0\10\0\10\0\10\0\10\0\10\0\10\0\10\0\167\0\167\0\195\0\195\0\195\0\195\0\195\0\195\0\195\0\195\0\48\0\167\0\167\0\48\0\48\0\48\0\48\0\48\0\48\0\48\0\48\0\46\0\167\0\46\0\46\0\167\0\46\0\46\0\
    \\46\0\46\0\46\0\46\0\167\0\167\0\10\1\10\1\10\1\10\1\10\1\10\1\10\1\10\1\120\0\167\0\120\0\120\0\167\0\120\0\120\0\120\0\120\0\120\0\120\0\153\0\167\0\167\0\167\0\167\0\167\0\167\0\153\0\153\0\167\0\153\0\153\0\153\0\153\0\167\0\167\0\167\0\153\0\153\0\167\0\167\0\167\0\167\0\153\0\153\0\
    \\156\0\167\0\156\0\156\0\156\0\156\0\156\0\156\0\156\0\156\0\167\0\156\0\156\0\167\0\167\0\63\0\167\0\63\0\63\0\63\0\63\0\63\0\63\0\63\0\63\0\167\0\63\0\63\0\63\0\63\0\167\0\167\0\17\1\17\1\17\1\17\1\17\1\17\1\17\1\17\1\84\0\167\0\84\0\84\0\84\0\84\0\84\0\84\0\84\0\84\0\
    \\167\0\84\0\84\0\167\0\159\0\159\0\159\0\159\0\159\0\159\0\159\0\167\0\167\0\167\0\39\0\39\0\39\0\39\0\39\0\39\0\39\0\39\0\167\0\167\0\167\0\167\0\167\0\167\0\40\0\40\0\108\0\108\0\108\0\108\0\108\0\108\0\108\0\108\0\167\0\167\0\167\0\53\0\53\0\53\0\53\0\53\0\53\0\53\0\53\0\219\0\
    \\219\0\167\0\147\0\147\0\147\0\147\0\147\0\147\0\147\0\147\0\167\0\147\0\147\0\76\0\76\0\76\0\76\0\76\0\76\0\76\0\167\0\167\0\167\0\167\0\167\0\74\0\74\0\74\0\74\0\74\0\74\0\74\0\45\0\74\0\74\0\6\0\6\0\6\0\6\0\6\0\6\0\6\0\6\0\167\0\6\0\6\0\30\0\30\0\30\0\30\0\
    \\30\0\30\0\167\0\167\0\167\0\167\0\167\0\75\0\75\0\75\0\75\0\75\0\75\0\75\0\75\0\144\0\144\0\144\0\144\0\144\0\144\0\144\0\144\0\167\0\167\0\167\0\80\0\80\0\80\0\80\0\80\0\80\0\80\0\80\0\167\0\167\0\167\0\67\0\67\0\67\0\67\0\67\0\67\0\167\0\167\0\167\0\167\0\67\0\62\0\62\0\
    \\62\0\167\0\167\0\167\0\167\0\167\0\62\0\167\0\167\0\21\0\21\0\21\0\21\0\21\0\21\0\21\0\21\0\167\0\21\0\21\0\70\0\70\0\167\0\70\0\70\0\70\0\70\0\70\0\70\0\70\0\70\0\44\0\167\0\44\0\44\0\167\0\44\0\44\0\44\0\44\0\44\0\44\0\125\0\125\0\125\0\125\0\125\0\125\0\125\0\125\0\
    \\167\0\167\0\167\0\167\0\167\0\167\0\167\0\102\0\102\0\102\0\102\0\102\0\102\0\167\0\167\0\167\0\205\0\2\1\253\0\32\0\2\1\2\1\32\0\32\0\167\0\167\0\167\0\167\0\167\0\167\0\88\0\167\0\88\0\88\0\167\0\88\0\88\0\88\0\88\0\88\0\88\0\88\0\167\0\167\0\167\0\167\0\167\0\167\0\88\0\88\0\
    \\167\0\88\0\88\0\88\0\88\0\88\0\88\0\88\0\88\0\36\0\36\0\36\0\36\0\36\0\36\0\167\0\167\0\167\0\167\0\167\0\41\0\167\0\167\0\123\0\123\0\167\0\123\0\123\0\123\0\123\0\123\0\123\0\167\0\167\0\11\0\167\0\167\0\11\0\11\0\11\0\11\0\11\0\11\0\11\0\11\0\25\0\167\0\25\0\25\0\25\0\
    \\25\0\25\0\25\0\167\0\25\0\167\0\25\0\25\0\25\0\25\0\25\0\25\0\25\0\175\0\42\0\167\0\167\0\42\0\42\0\42\0\42\0\42\0\42\0\42\0\167\0\167\0\167\0\167\0\167\0\178\0\3\0\3\0\3\0\3\0\3\0\3\0\3\0\167\0\3\0\3\0\3\0\3\0\3\0\3\0\3\0\3\0\167\0\167\0\25\0\64\0\
    \\56\0\56\0\56\0\56\0\56\0\56\0\56\0\25\0\25\0\167\0\167\0\167\0\167\0\167\0\167\0\25\0\25\0\186\0\3\0\3\0\3\0\3\0\3\0\3\0\3\0\185\0\3\0\3\0\3\0\183\0\187\0\3\0\3\0\176\0\85\0\85\0\85\0\85\0\85\0\85\0\85\0\85\0\167\0\167\0\85\0\167\0\46\0\46\0\167\0\46\0\
    \\46\0\46\0\167\0\167\0\46\0\46\0\46\0\46\0\167\0\153\0\153\0\167\0\153\0\167\0\153\0\153\0\153\0\153\0\167\0\167\0\8\1\8\1\8\1\8\1\8\1\8\1\8\1\8\1\153\0\153\0\153\0\153\0\153\0\153\0\153\0\153\0\156\0\167\0\156\0\156\0\156\0\156\0\167\0\167\0\156\0\156\0\156\0\156\0\46\0\46\0\
    \\167\0\167\0\167\0\167\0\167\0\167\0\167\0\84\0\84\0\84\0\84\0\167\0\167\0\84\0\84\0\73\0\73\0\167\0\167\0\73\0\73\0\73\0\73\0\73\0\73\0\73\0\167\0\167\0\17\0\17\0\17\0\17\0\17\0\17\0\17\0\17\0\167\0\167\0\167\0\167\0\147\0\147\0\147\0\147\0\147\0\167\0\147\0\147\0\167\0\167\0\
    \\167\0\167\0\69\0\69\0\69\0\69\0\69\0\69\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\68\0\76\0\167\0\167\0\167\0\76\0\76\0\76\0\76\0\167\0\167\0\167\0\167\0\103\0\103\0\103\0\103\0\103\0\103\0\103\0\103\0\167\0\167\0\167\0\167\0\16\0\16\0\16\0\16\0\16\0\16\0\16\0\16\0\167\0\167\0\
    \\16\0\16\0\167\0\26\0\26\0\26\0\26\0\26\0\26\0\26\0\167\0\167\0\167\0\167\0\215\0\215\0\25\0\210\0\215\0\215\0\215\0\215\0\210\0\210\0\210\0\210\0\15\1\15\1\15\1\15\1\15\1\25\0\210\0\168\0\168\0\168\0\168\0\168\0\168\0\168\0\168\0\167\0\167\0\167\0\167\0\129\0\129\0\129\0\129\0\129\0\
    \\129\0\129\0\129\0\167\0\167\0\167\0\167\0\22\0\22\0\22\0\22\0\22\0\22\0\167\0\167\0\22\0\22\0\22\0\22\0\78\0\78\0\78\0\78\0\78\0\78\0\78\0\167\0\78\0\78\0\167\0\78\0\236\0\236\0\236\0\236\0\236\0\236\0\236\0\236\0\167\0\167\0\167\0\237\0\182\0\182\0\182\0\182\0\182\0\182\0\182\0\
    \\182\0\167\0\167\0\167\0\167\0\122\0\122\0\122\0\122\0\122\0\122\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\30\0\121\0\121\0\121\0\121\0\121\0\121\0\121\0\121\0\167\0\167\0\167\0\167\0\20\0\20\0\20\0\20\0\20\0\20\0\20\0\20\0\167\0\167\0\167\0\167\0\169\0\169\0\169\0\167\0\169\0\169\0\169\0\
    \\169\0\169\0\169\0\169\0\169\0\162\0\162\0\162\0\162\0\162\0\162\0\162\0\162\0\167\0\167\0\167\0\167\0\127\0\127\0\127\0\127\0\127\0\127\0\127\0\127\0\167\0\167\0\167\0\127\0\67\0\67\0\67\0\67\0\167\0\67\0\67\0\67\0\67\0\67\0\67\0\67\0\172\0\172\0\167\0\172\0\172\0\172\0\167\0\167\0\167\0\
    \\167\0\167\0\167\0\151\0\151\0\24\0\24\0\24\0\24\0\24\0\24\0\24\0\24\0\167\0\167\0\167\0\167\0\165\0\165\0\165\0\167\0\165\0\165\0\165\0\165\0\165\0\165\0\165\0\165\0\167\0\165\0\167\0\167\0\165\0\167\0\165\0\104\0\104\0\104\0\104\0\104\0\104\0\104\0\104\0\167\0\104\0\104\0\104\0\34\0\34\0\
    \\34\0\34\0\34\0\34\0\34\0\34\0\167\0\167\0\167\0\167\0\163\0\163\0\163\0\163\0\163\0\163\0\163\0\163\0\167\0\167\0\167\0\167\0\11\0\167\0\167\0\11\0\11\0\11\0\11\0\11\0\167\0\167\0\167\0\167\0\155\0\155\0\155\0\155\0\155\0\155\0\155\0\155\0\167\0\167\0\167\0\167\0\167\0\13\0\13\0\13\0\
    \\13\0\13\0\13\0\13\0\13\0\106\0\106\0\106\0\106\0\106\0\106\0\106\0\106\0\167\0\167\0\167\0\167\0\252\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\137\0\137\0\137\0\137\0\137\0\167\0\167\0\167\0\167\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\167\0\167\0\167\0\167\0\45\0\45\0\45\0\45\0\
    \\45\0\45\0\45\0\45\0\167\0\45\0\167\0\45\0\45\0\30\0\30\0\30\0\30\0\30\0\30\0\30\0\30\0\243\0\238\0\240\0\240\0\238\0\4\0\191\0\4\0\167\0\167\0\4\0\4\0\4\0\4\0\4\0\4\0\4\0\167\0\3\0\3\0\167\0\167\0\167\0\167\0\167\0\3\0\3\0\3\0\3\0\3\0\3\0\183\0\3\0\
    \\3\0\3\0\3\0\3\0\25\0\3\0\3\0\3\0\3\0\3\0\145\0\145\0\145\0\167\0\167\0\145\0\145\0\145\0\145\0\145\0\145\0\167\0\145\0\105\0\105\0\105\0\105\0\105\0\105\0\105\0\105\0\167\0\167\0\105\0\105\0\105\0\32\0\209\0\32\0\3\1\32\0\32\0\32\0\32\0\200\0\201\0\58\0\58\0\32\0\32\0\
    \\32\0\32\0\32\0\32\0\32\0\32\0\199\0\198\0\248\0\248\0\248\0\248\0\248\0\248\0\248\0\248\0\167\0\138\0\138\0\138\0\167\0\138\0\138\0\138\0\138\0\138\0\138\0\138\0\138\0\167\0\167\0\167\0\158\0\158\0\158\0\158\0\158\0\158\0\158\0\158\0\167\0\167\0\167\0\167\0\25\0\246\0\247\0\167\0\167\0\167\0\
    \\167\0\167\0\167\0\150\0\150\0\150\0\150\0\150\0\150\0\150\0\150\0\167\0\167\0\167\0\167\0\167\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\43\0\167\0\167\0\167\0\167\0\167\0\114\0\114\0\114\0\114\0\114\0\114\0\114\0\114\0\167\0\167\0\167\0\167\0\167\0\169\0\169\0\169\0\167\0\169\0\169\0\169\0\169\0\
    \\167\0\169\0\169\0\167\0\169\0\169\0\167\0\167\0\167\0\74\0\74\0\25\0\25\0\167\0\167\0\167\0\167\0\54\0\54\0\54\0\54\0\54\0\54\0\54\0\54\0\167\0\54\0\54\0\167\0\167\0\59\0\59\0\59\0\59\0\59\0\59\0\59\0\59\0\167\0\167\0\167\0\167\0\167\0\83\0\83\0\83\0\83\0\83\0\83\0\83\0\
    \\83\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\111\0\111\0\111\0\111\0\111\0\111\0\111\0\111\0\167\0\167\0\167\0\167\0\167\0\62\0\62\0\62\0\62\0\62\0\62\0\62\0\62\0\167\0\167\0\167\0\167\0\167\0\71\0\71\0\71\0\71\0\71\0\71\0\71\0\71\0\167\0\167\0\167\0\167\0\167\0\44\0\8\1\44\0\
    \\8\1\167\0\44\0\44\0\44\0\44\0\44\0\167\0\167\0\44\0\1\0\1\0\1\0\167\0\167\0\1\0\1\0\1\0\1\0\167\0\167\0\167\0\167\0\171\0\171\0\171\0\171\0\171\0\171\0\171\0\171\0\167\0\167\0\167\0\167\0\167\0\141\0\141\0\141\0\141\0\141\0\141\0\141\0\141\0\167\0\167\0\167\0\167\0\167\0\65\0\
    \\167\0\65\0\65\0\65\0\65\0\65\0\65\0\167\0\167\0\167\0\65\0\65\0\29\0\29\0\29\0\29\0\29\0\29\0\29\0\29\0\167\0\167\0\167\0\167\0\167\0\97\0\97\0\97\0\97\0\97\0\97\0\97\0\167\0\167\0\167\0\167\0\97\0\97\0\154\0\154\0\154\0\154\0\154\0\154\0\154\0\167\0\167\0\167\0\167\0\167\0\
    \\167\0\89\0\89\0\89\0\89\0\89\0\89\0\89\0\89\0\167\0\167\0\167\0\167\0\167\0\94\0\94\0\94\0\94\0\94\0\94\0\94\0\94\0\167\0\167\0\167\0\167\0\94\0\64\0\64\0\64\0\64\0\167\0\64\0\64\0\64\0\64\0\167\0\64\0\64\0\167\0\159\0\159\0\159\0\159\0\159\0\25\0\25\0\25\0\25\0\58\0\
    \\58\0\25\0\25\0\25\0\25\0\25\0\25\0\58\0\58\0\58\0\58\0\58\0\22\1\23\1\58\0\110\0\110\0\110\0\110\0\110\0\110\0\110\0\110\0\167\0\167\0\167\0\167\0\110\0\79\0\79\0\79\0\79\0\79\0\79\0\79\0\79\0\167\0\167\0\167\0\167\0\167\0\167\0\167\0\45\0\45\0\45\0\167\0\45\0\45\0\45\0\
    \\45\0\45\0\26\0\26\0\26\0\26\0\26\0\26\0\48\0\167\0\48\0\48\0\167\0\48\0\48\0\167\0\48\0\48\0\48\0\48\0\48\0\48\0\46\0\167\0\46\0\46\0\167\0\46\0\46\0\46\0\167\0\167\0\46\0\46\0\46\0\46\0\220\0\220\0\220\0\220\0\220\0\220\0\220\0\220\0\99\0\99\0\99\0\99\0\99\0\99\0\
    \\99\0\99\0\167\0\167\0\167\0\167\0\103\0\103\0\103\0\167\0\167\0\167\0\103\0\103\0\167\0\167\0\167\0\167\0\167\0\167\0\32\0\254\0\207\0\255\0\32\0\204\0\32\0\32\0\203\0\249\0\251\0\197\0\197\0\10\0\45\0\45\0\74\0\74\0\74\0\74\0\45\0\45\0\45\0\74\0\74\0\74\0\74\0\74\0\25\0\25\0\
    \\25\0\25\0\25\0\25\0\74\0\25\0\25\0\25\0\167\0\167\0\167\0\167\0\213\0\213\0\211\0\211\0\215\0\215\0\215\0\215\0\25\0\210\0\215\0\215\0\215\0\215\0\132\0\132\0\132\0\132\0\132\0\132\0\167\0\167\0\167\0\167\0\167\0\167\0\132\0\132\0\61\0\61\0\167\0\167\0\167\0\167\0\61\0\61\0\61\0\61\0\
    \\61\0\61\0\167\0\218\0\81\0\81\0\81\0\81\0\81\0\81\0\81\0\81\0\167\0\167\0\167\0\167\0\167\0\81\0\136\0\136\0\136\0\136\0\136\0\136\0\136\0\136\0\167\0\167\0\167\0\167\0\167\0\167\0\52\0\52\0\52\0\52\0\52\0\52\0\52\0\52\0\167\0\167\0\167\0\167\0\167\0\167\0\172\0\172\0\172\0\172\0\
    \\172\0\172\0\172\0\172\0\167\0\172\0\172\0\172\0\167\0\167\0\139\0\139\0\139\0\139\0\139\0\139\0\139\0\139\0\167\0\167\0\167\0\167\0\167\0\167\0\119\0\119\0\119\0\119\0\119\0\119\0\119\0\119\0\167\0\167\0\167\0\167\0\167\0\167\0\70\0\70\0\167\0\70\0\70\0\70\0\70\0\70\0\167\0\167\0\167\0\167\0\
    \\167\0\167\0\44\0\167\0\44\0\44\0\167\0\44\0\44\0\44\0\167\0\8\1\8\1\44\0\44\0\44\0\104\0\104\0\104\0\104\0\167\0\104\0\104\0\104\0\167\0\167\0\167\0\167\0\167\0\167\0\161\0\161\0\161\0\161\0\161\0\161\0\161\0\161\0\167\0\167\0\167\0\167\0\167\0\167\0\152\0\152\0\152\0\152\0\152\0\152\0\
    \\152\0\152\0\167\0\167\0\167\0\167\0\167\0\167\0\143\0\143\0\143\0\143\0\143\0\143\0\143\0\143\0\167\0\167\0\167\0\167\0\167\0\167\0\49\0\49\0\49\0\49\0\49\0\49\0\49\0\49\0\167\0\167\0\167\0\167\0\167\0\167\0\72\0\72\0\72\0\72\0\72\0\72\0\72\0\72\0\167\0\167\0\167\0\167\0\167\0\167\0\
    \\64\0\64\0\64\0\167\0\167\0\167\0\167\0\167\0\56\0\167\0\167\0\167\0\167\0\167\0\42\0\167\0\167\0\42\0\42\0\42\0\42\0\42\0\167\0\42\0\42\0\167\0\42\0\42\0\42\0\42\0\42\0\42\0\42\0\42\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\170\0\167\0\167\0\167\0\167\0\167\0\170\0\155\0\106\0\
    \\50\0\50\0\68\0\167\0\167\0\167\0\3\0\167\0\167\0\167\0\167\0\3\0\167\0\3\0\167\0\3\0\3\0\3\0\20\1\58\0\58\0\58\0\58\0\58\0\181\0\58\0\58\0\45\0\58\0\58\0\45\0\58\0\58\0\58\0\227\0\228\0\23\1\58\0\58\0\2\1\197\0\1\1\32\0\32\0\32\0\32\0\32\0\254\0\207\0\255\0\
    \\32\0\204\0\32\0\32\0\223\0\224\0\226\0\7\1\179\0\232\0\239\0\231\0\190\0\24\1\4\1\225\0\230\0\21\1\5\1\58\0\142\0\142\0\142\0\142\0\142\0\142\0\142\0\142\0\109\0\109\0\109\0\109\0\109\0\109\0\109\0\109\0\202\0\32\0\202\0\250\0\32\0\206\0\208\0\0\1\241\0\58\0\145\0\58\0\58\0\58\0\
    \\58\0\58\0\15\0\15\0\15\0\15\0\15\0\15\0\15\0\15\0\13\1\13\1\13\1\13\1\13\1\13\1\13\1\13\1\244\0\244\0\244\0\245\0\245\0\245\0\247\0\247\0\126\0\126\0\126\0\126\0\126\0\126\0\126\0\126\0\31\0\31\0\31\0\31\0\31\0\31\0\31\0\31\0\134\0\134\0\134\0\134\0\134\0\134\0\134\0\134\0\
    \\37\0\37\0\37\0\37\0\37\0\37\0\37\0\37\0\124\0\124\0\124\0\124\0\124\0\124\0\124\0\124\0\93\0\93\0\93\0\93\0\93\0\93\0\93\0\93\0\117\0\117\0\117\0\117\0\117\0\117\0\117\0\117\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\116\0\116\0\116\0\116\0\116\0\116\0\116\0\116\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\174\0\174\0\174\0\174\0\174\0\174\0\174\0\174\0"#

encodedScriptExtensionsOffsets1BitMap :: Ptr Word16
encodedScriptExtensionsOffsets1BitMap = Ptr
    "\89\7\89\7\89\7\89\7\89\7\89\7\89\7\89\7\91\7\214\1\89\7\169\9\169\9\89\7\89\7\131\4\89\7\89\7\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\96\15\96\15\96\15\96\15\96\15\96\15\96\15\102\15\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\
    \\214\1\214\1\214\1\214\1\214\1\214\1\173\13\173\13\173\13\173\13\173\13\173\13\173\13\173\13\173\13\173\13\173\13\178\13\183\9\183\9\183\9\180\9\183\9\183\9\210\11\214\1\214\1\214\1\214\1\214\1\27\6\27\6\27\6\29\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\
    \\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\214\1\214\1\214\1\214\1\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\99\7\101\7\214\1\
    \\214\1\214\1\214\1\148\10\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\32\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\145\7\145\7\145\7\145\7\
    \\145\7\145\7\145\7\145\7\223\3\224\3\224\3\229\3\223\3\224\3\224\3\229\3\145\7\145\7\145\7\145\7\145\7\220\7\223\7\220\7\224\3\224\3\225\3\224\3\224\3\224\3\225\3\224\3\224\3\224\3\224\3\53\4\48\4\224\3\224\3\224\3\224\3\224\3\54\4\100\14\106\14\224\3\51\4\224\3\224\3\224\3\224\3\224\3\224\3\224\3\
    \\52\4\210\3\239\5\239\5\239\5\239\5\239\5\239\5\254\15\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\29\6\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\
    \\214\1\214\1\214\1\199\13\204\13\14\16\145\7\145\7\145\7\105\4\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\104\4\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\109\4\214\1\214\1\226\8\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\
    \\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\224\3\19\6\232\3\88\0\94\0\35\5\227\3\96\4\145\7\145\7\11\6\145\7\145\7\145\7\136\0\140\0\152\0\145\7\145\7\6\1\214\1\214\1\214\1\214\1\27\6\27\6\27\6\135\7\27\6\27\6\27\6\27\6\27\6\
    \\27\6\27\6\27\6\27\6\27\6\31\6\214\1\107\4\214\1\198\3\249\3\254\3\254\3\255\3\1\4\55\5\254\3\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\27\6\
    \\27\6\27\6\29\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\29\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\33\6\214\1\214\1\214\1\214\1\
    \\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\118\2\214\1\214\1\214\1\3\1\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\69\4\214\1\214\1\145\7\68\4\214\1\214\1\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\
    \\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\7\1\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\71\7\214\1\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\
    \\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\69\7\158\9\147\7\17\1\148\7\148\7\145\7\145\7\145\7\151\7\194\9\3\1\191\9\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\6\1\145\7\
    \\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\11\1\145\7\7\1\145\7\7\1\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\
    \\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\231\4\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\22\9\22\9\22\9\25\9\156\6\156\6\156\6\156\6\156\6\156\6\163\6\214\1\27\11\27\11\27\11\31\11\58\7\58\7\58\7\58\7\
    \\58\7\58\7\58\7\58\7\229\4\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\134\13\134\13\134\13\134\13\134\13\134\13\134\13\134\13\134\13\134\13\134\13\134\13\139\13\214\1\31\2\31\2\31\2\31\2\110\15\214\1\116\15\214\1\
    \\214\1\214\1\36\2\214\1\99\6\214\1\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\243\11\12\5\12\5\12\5\12\5\12\5\15\5\12\5\14\5\12\5\18\5\214\1\214\1\
    \\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\26\5\26\5\26\5\27\5\214\1\214\1\144\15\144\15\144\15\144\15\144\15\144\15\144\15\150\15\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\
    \\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\43\6\46\6\43\6\43\6\43\6\43\6\43\6\43\6\44\6\214\1\250\13\250\13\250\13\250\13\250\13\250\13\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\
    \\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\169\7\4\12\214\1\166\7\168\7\169\7\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\15\13\15\13\15\13\22\13\
    \\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\182\8\182\8\182\8\185\8\151\1\151\1\151\1\151\1\151\1\151\1\151\1\151\1\151\1\151\1\151\1\158\1\58\7\58\7\
    \\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\59\7\228\4\214\1\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\231\4\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\
    \\30\1\30\1\30\1\30\1\30\1\30\1\32\1\30\1\30\1\30\1\30\1\32\1\214\1\214\1\214\1\214\1\145\7\145\7\145\7\145\7\166\0\162\0\220\7\145\7\145\7\177\0\145\7\145\7\224\3\224\3\224\3\224\3\224\3\67\4\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\
    \\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\6\1\214\1\214\1\214\1\214\1\214\1\214\1\250\0\145\7\145\7\145\7\145\7\146\7\4\1\145\7\145\7\145\7\145\7\145\7\145\7\122\3\120\3\145\7\226\13\113\3\118\3\145\7\145\7\145\7\116\3\145\7\145\7\145\7\145\7\
    \\145\7\145\7\145\7\68\4\214\1\214\1\12\12\12\12\12\12\12\12\12\12\12\12\12\12\12\12\12\12\188\7\12\12\190\7\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\4\1\145\7\145\7\145\7\145\7\145\7\145\7\145\7\7\1\214\1\214\1\214\1\
    \\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\0\0\0\0\0\0\0\0\0\0\6\0\4\1\145\7\145\7\145\7\145\7\145\7\145\7\6\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\
    \\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\4\1\145\7\145\7\145\7\145\7\145\7\145\7\145\7\7\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\237\13\237\13\237\13\237\13\
    \\237\13\242\13\185\0\185\0\185\0\82\13\185\0\189\0\185\0\185\0\186\0\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\124\2\239\5\239\5\239\5\239\5\239\5\239\5\239\5\239\5\239\5\239\5\239\5\239\5\239\5\239\5\239\5\
    \\239\5\126\2\198\14\198\14\198\14\198\14\198\14\214\1\198\14\204\14\60\1\60\1\60\1\60\1\62\1\59\1\60\1\60\1\62\1\174\8\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\234\9\234\9\234\9\235\9\212\14\212\14\212\14\212\14\212\14\125\11\129\11\214\1\68\12\214\1\234\9\212\7\
    \\214\1\214\1\214\1\68\12\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\6\1\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\
    \\16\1\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\73\0\3\1\145\7\145\7\70\4\214\1\145\7\145\7\70\4\214\1\147\7\17\1\148\7\148\7\145\7\145\7\145\7\151\7\194\9\3\1\191\9\145\7\145\7\145\7\145\7\145\7\145\7\
    \\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\148\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\148\7\12\3\153\7\145\7\197\9\149\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\
    \\145\7\145\7\145\7\145\7\145\7\145\7\145\7\69\4\145\7\73\0\70\4\214\1\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\29\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\
    \\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\34\6\214\1\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\29\6\214\1\214\1\214\1\143\1\143\1\58\7\58\7\58\7\58\7\
    \\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\59\7\228\4\214\1\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\58\7\229\4\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\
    \\214\1\214\1\214\1\144\3\144\3\144\3\145\3\144\3\144\3\146\3\131\11\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\241\4\242\4\214\1\214\1\214\1\214\1\214\1\214\1\
    \\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\167\8\250\2\166\8\167\8\77\12\72\12\234\9\16\10\234\9\234\9\234\9\234\9\225\9\2\8\5\8\234\9\236\0\242\0\7\10\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\
    \\234\9\234\9\11\10\77\12\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\84\3\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\
    \\234\9\234\9\234\9\234\9\234\9\214\1\214\1\214\1\214\1\75\3\78\3\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\34\0\250\4\250\4\250\4\251\4\250\4\152\13\
    \\3\5\3\5\3\5\3\5\3\5\3\5\3\5\3\5\3\5\4\5\3\5\165\13\79\7\79\7\79\7\81\7\81\7\214\1\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\148\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\148\7\12\3\153\7\145\7\197\9\149\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\
    \\145\7\145\7\145\7\146\7\214\1\27\6\27\6\143\7\70\4\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\171\5\171\5\171\5\171\5\173\5\161\9\90\2\90\2\90\2\90\2\90\2\90\2\90\2\83\2\81\4\83\2\166\8\166\8\167\8\214\1\167\8\167\8\167\8\167\8\167\8\
    \\167\8\167\8\167\8\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\42\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\37\12\200\3\201\3\201\3\201\3\202\3\200\3\201\3\201\3\201\3\201\3\201\3\50\12\253\3\254\3\254\3\
    \\254\3\254\3\254\3\254\3\214\1\254\3\254\3\254\3\63\5\61\5\214\1\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\183\3\184\3\214\1\183\3\183\3\185\3\214\1\183\3\
    \\214\1\214\1\214\1\123\6\224\3\224\3\224\3\224\3\224\3\121\6\111\4\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\223\10\
    \\223\10\227\10\214\1\214\1\37\12\37\12\37\12\37\12\37\12\132\2\37\12\37\12\37\12\37\12\37\12\37\12\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\27\0\214\1\245\9\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\
    \\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\110\15\214\1\116\15\214\1\214\1\214\1\36\2\214\1\99\6\214\1\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\239\11\166\8\166\8\166\8\166\8\166\8\166\8\166\8\166\8\166\8\108\0\167\8\108\0\
    \\166\8\166\8\166\8\166\8\166\8\108\0\166\8\166\8\166\8\166\8\108\0\167\8\108\0\166\8\167\8\166\8\166\8\166\8\166\8\166\8\108\0\166\8\166\8\166\8\166\8\166\8\166\8\166\8\166\8\111\0\166\8\166\8\166\8\116\0\166\8\166\8\166\8\172\8\181\5\181\5\181\5\181\5\181\5\181\5\181\5\181\5\181\5\181\5\183\5\183\5\
    \\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\34\6\214\1\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\27\6\29\6\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\
    \\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\145\7\145\7\145\7\145\7\166\0\162\0\220\7\145\7\145\7\177\0\145\7\145\7\224\3\224\3\224\3\224\3\224\3\67\4\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\217\13\145\7\145\7\145\7\22\1\145\7\
    \\145\7\145\7\202\9\145\7\90\4\148\7\145\7\1\1\100\4\145\7\146\7\224\3\109\4\145\7\145\7\145\7\145\7\69\4\214\1\239\5\239\5\239\5\239\5\251\11\214\1\94\16\94\16\94\16\94\16\94\16\214\1\226\14\226\14\226\14\226\14\226\14\232\14\214\1\214\1\240\14\240\14\240\14\246\14\214\1\214\1\214\1\214\1\139\11\139\11\139\11\
    \\143\11\214\1\214\1\177\4\177\4\178\4\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\234\9\234\9\234\9\235\9\212\14\212\14\212\14\212\14\212\14\125\11\129\11\214\1\68\12\214\1\234\9\212\7\214\1\214\1\214\1\68\12\186\13\186\13\186\13\186\13\186\13\186\13\186\13\186\13\186\13\191\13\186\13\186\13\
    \\186\13\186\13\186\13\186\13\186\13\100\3\186\13\186\13\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\158\15\214\1\28\6\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\173\13\173\13\173\13\173\13\173\13\173\13\173\13\173\13\173\13\173\13\173\13\178\13\183\9\183\9\183\9\180\9\183\9\183\9\210\11\214\1\214\1\214\1\214\1\
    \\214\1\214\15\222\15\108\3\239\5\191\15\229\13\237\5\239\5\185\15\239\5\239\5\178\15\215\3\224\3\59\4\245\7\173\1\29\12\237\7\237\7\234\7\237\7\237\7\237\7\237\7\237\7\237\7\237\7\45\5\47\5\237\7\237\7\71\5\73\5\71\5\71\5\71\5\71\5\71\5\71\5\71\5\88\12\234\9\234\9\234\9\234\9\234\9\234\9\240\3\
    \\240\3\240\3\240\3\240\3\240\3\246\3\214\1\101\12\101\12\101\12\101\12\101\12\101\12\101\12\106\12\9\4\9\4\9\4\9\4\9\4\11\4\9\4\10\4\24\10\24\10\24\10\28\10\71\5\148\4\234\9\234\9\234\9\234\9\63\12\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\80\12\234\9\234\9\234\9\126\12\126\12\126\12\
    \\126\12\126\12\126\12\126\12\126\12\126\12\126\12\121\12\126\12\130\12\136\12\126\12\126\12\233\1\86\5\13\8\83\5\83\5\81\5\223\1\229\1\86\5\230\1\215\1\218\1\20\8\26\8\83\5\84\5\94\5\104\5\34\8\99\5\99\5\97\5\67\3\63\3\104\5\59\3\109\1\104\1\214\4\220\4\100\5\214\1\112\5\119\5\114\5\117\5\117\5\
    \\115\5\45\8\40\10\119\5\36\10\89\10\214\1\52\8\58\8\88\10\116\5\127\5\195\2\192\2\207\2\207\2\130\5\66\8\191\2\195\2\199\2\114\4\247\5\196\2\207\2\207\2\214\1\82\8\88\8\85\8\48\10\91\8\88\8\68\10\94\8\88\8\85\8\77\8\214\1\233\4\60\10\64\10\47\7\104\8\107\8\102\8\104\8\104\8\102\8\104\8\
    \\80\10\107\8\76\10\73\4\109\8\78\10\104\8\71\4\104\8\119\8\122\8\117\8\119\8\119\8\117\8\123\8\183\2\122\8\126\8\178\2\92\6\128\8\134\8\95\6\214\1\144\8\147\8\142\8\144\8\144\8\144\8\144\8\144\8\147\8\142\8\93\10\144\8\97\10\144\8\144\8\144\8\144\12\254\1\255\1\252\1\254\1\254\1\146\12\2\2\255\1\
    \\247\1\1\2\254\1\225\5\254\1\229\5\214\1\1\3\2\3\2\3\2\3\2\3\2\3\2\3\7\3\2\3\2\3\2\3\6\3\214\1\214\1\214\1\214\1\154\5\140\5\144\5\144\5\148\5\144\5\144\5\110\10\147\5\145\5\144\5\105\10\214\1\214\1\214\1\214\1\10\2\10\2\10\2\10\2\10\2\10\2\10\2\10\2\10\2\9\2\10\2\
    \\10\2\10\2\158\8\9\2\10\2\10\2\10\2\10\2\9\2\10\2\10\2\10\2\13\2\10\2\13\2\212\13\193\3\214\1\214\1\214\1\214\1\60\14\60\14\60\14\60\14\60\14\60\14\60\14\60\14\52\14\58\14\60\14\60\14\60\14\60\14\60\14\60\14\60\14\60\14\60\14\60\14\171\5\171\5\171\5\171\5\173\5\161\9\171\5\171\5\171\5\
    \\171\5\171\5\167\5\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\191\5\191\5\193\5\194\4\193\8\193\8\196\8\214\1\118\10\118\10\122\10\214\1\204\8\207\8\134\10\
    \\214\1\201\5\201\5\201\5\201\5\201\5\201\5\201\5\201\5\201\5\201\5\201\5\203\5\201\5\146\10\201\5\146\10\200\1\206\1\206\1\212\1\206\1\206\1\206\1\206\1\206\1\206\1\206\1\206\1\206\1\206\1\206\1\213\1\206\1\206\1\206\1\206\1\206\1\211\1\154\3\154\3\154\3\154\3\154\3\154\3\154\3\154\3\156\3\214\1\19\4\
    \\19\4\19\4\20\4\19\4\218\8\19\4\218\8\156\10\19\4\211\5\211\5\211\5\28\4\29\4\214\1\168\10\168\10\168\10\168\10\168\10\221\5\168\10\168\10\168\10\223\5\168\10\72\14\201\5\201\5\201\5\201\5\180\10\180\10\180\10\184\10\37\4\37\4\37\4\37\4\37\4\37\4\37\4\38\4\37\4\37\4\37\4\40\4\37\4\161\7\37\4\
    \\161\7\37\4\39\4\239\5\239\5\239\5\239\5\239\5\241\5\239\5\243\5\214\1\214\1\237\8\237\8\237\8\237\8\237\8\237\8\237\8\237\8\237\8\240\8\237\8\237\8\237\8\237\8\237\8\237\8\230\15\230\15\230\15\230\15\230\15\230\15\230\15\230\15\43\3\43\3\43\3\43\3\43\3\43\3\47\3\51\3\3\9\3\9\3\9\3\9\3\9\
    \\3\9\3\9\1\6\3\9\255\5\238\15\238\15\238\15\238\15\238\15\238\15\37\12\251\8\171\5\171\5\171\5\171\5\171\5\162\5\230\15\214\1\246\15\112\9\199\15\86\14\92\14\208\0\237\7\237\7\239\7\239\7\237\7\237\7\237\7\237\7\239\7\239\7\237\7\19\3\237\7\237\7\237\7\239\7\237\7\237\7\237\7\237\7\237\7\237\7\231\7\
    \\237\7\231\7\237\7\241\7\232\7\237\7\237\7\7\14\238\7\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\6\16\136\15\136\15\136\15\136\15\136\15\136\15\136\15\136\15\136\15\
    \\136\15\136\15\136\15\224\3\224\3\224\3\224\3\47\5\47\5\47\5\47\5\47\5\47\5\47\5\47\5\47\5\47\5\47\5\47\5\47\5\47\5\196\10\192\10\112\2\128\14\204\10\208\10\26\6\98\2\215\10\129\7\30\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\31\2\128\0\123\0\190\1\191\1\191\1\191\1\191\1\191\1\191\1\
    \\191\1\191\1\191\1\191\1\186\1\226\11\231\11\231\11\231\11\231\11\231\11\165\1\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\166\1\27\6\27\6\231\11\231\11\231\11\231\11\27\6\27\6\27\6\27\6\29\6\136\1\191\1\191\1\104\2\104\2\104\2\166\1\27\6\27\6\27\6\27\6\27\6\145\7\145\7\145\7\104\2\
    \\104\2\104\2\105\2\27\6\27\6\27\6\27\6\27\6\27\6\144\7\145\7\27\6\141\7\191\1\191\1\191\1\191\1\191\1\192\1\191\1\191\1\191\1\191\1\191\1\191\1\191\1\191\1\191\1\191\1\191\1\27\6\27\6\27\6\144\7\24\6\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\27\6\27\6\27\6\
    \\138\7\11\9\11\9\11\9\11\9\11\9\14\9\22\16\173\12\30\16\30\16\30\16\30\16\30\16\30\16\30\16\214\1\234\2\234\2\234\2\234\2\234\2\234\2\234\2\234\2\236\2\242\2\234\2\240\2\126\12\126\12\114\12\126\12\54\6\54\6\54\6\54\6\54\6\56\6\235\10\235\10\235\10\235\10\239\10\35\6\104\2\104\2\104\2\168\1\64\6\
    \\64\6\64\6\64\6\64\6\64\6\64\6\64\6\64\6\66\6\64\6\156\14\60\14\60\14\60\14\61\14\21\2\21\2\21\2\21\2\21\2\21\2\22\2\214\1\21\2\23\2\21\2\251\10\60\14\60\14\60\14\60\14\181\12\181\12\181\12\181\12\181\12\181\12\181\12\181\12\186\12\214\1\214\1\178\12\122\4\122\4\123\4\214\1\102\0\102\0\102\0\
    \\214\1\167\8\167\8\224\3\224\3\224\3\224\3\224\3\220\3\229\8\237\12\181\5\181\5\181\5\181\5\181\5\181\5\181\5\181\5\181\5\181\5\122\4\122\4\122\4\122\4\122\4\124\4\122\4\128\4\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\104\2\169\1\
    \\214\1\104\2\104\2\166\1\163\1\104\2\104\2\104\2\104\2\104\2\169\1\239\5\239\5\145\7\69\4\239\5\126\2\145\7\145\7\145\0\145\7\150\7\145\7\146\7\73\0\228\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\234\9\237\9\4\1\145\7\145\7\145\7\223\3\224\3\224\3\
    \\229\3\223\3\224\3\224\3\229\3\180\1\191\1\190\1\191\1\191\1\191\1\191\1\103\6\104\2\104\2\104\2\166\1\164\1\164\1\164\1\40\0\146\7\146\7\214\1\14\1\163\2\167\2\163\2\163\2\164\2\163\2\163\2\70\2\163\2\77\2\163\2\77\2\214\1\214\1\214\1\214\1\163\2\163\2\163\2\163\2\163\2\163\2\163\2\163\2\163\2\
    \\163\2\163\2\163\2\163\2\163\2\163\2\175\2\44\2\51\2\51\2\51\2\51\2\51\2\55\2\62\2\237\7\237\7\237\7\237\7\237\7\237\7\237\7\237\7\237\7\238\7\145\7\7\1\241\1\214\1\214\1\214\1\214\1\214\1\145\7\145\7\145\7\145\7\145\7\124\3\27\3\27\3\27\3\27\3\31\3\35\3\194\12\194\12\194\12\199\12\207\12\
    \\207\12\207\12\207\12\207\12\212\12\74\6\74\6\74\6\76\6\84\6\84\6\84\6\84\6\88\6\84\6\86\6\214\1\214\1\214\1\214\1\214\1\38\16\38\16\38\16\38\16\38\16\38\16\38\16\38\16\38\16\38\16\46\16\46\16\46\16\46\16\46\16\46\16\111\6\111\6\111\6\113\6\111\6\43\11\53\11\53\11\53\11\53\11\57\11\53\11\53\11\
    \\53\11\53\11\57\11\54\16\54\16\54\16\54\16\54\16\214\1\65\11\65\11\65\11\65\11\65\11\65\11\69\11\42\1\81\11\77\11\81\11\77\11\225\12\81\11\78\11\81\11\78\11\229\12\89\11\89\11\89\11\89\11\89\11\89\11\93\11\214\1\133\6\132\3\134\3\134\3\134\3\134\3\136\3\138\6\146\6\146\6\148\6\146\6\62\16\62\16\62\16\
    \\62\16\139\4\139\4\139\4\140\4\19\7\139\4\214\1\214\1\214\1\214\1\214\1\214\1\245\12\245\12\250\12\242\12\101\11\101\11\101\11\105\11\170\14\170\14\170\14\176\14\184\14\184\14\184\14\190\14\214\1\214\1\214\1\214\1\70\16\70\16\70\16\70\16\117\1\117\1\117\1\113\1\117\1\117\1\115\1\117\1\117\1\117\1\117\1\117\1\160\4\
    \\152\4\113\11\155\4\90\1\90\1\92\1\36\9\90\1\97\1\90\1\97\1\78\16\78\16\78\16\78\16\86\16\86\16\86\16\86\16\214\1\214\1\214\1\214\1\168\4\168\4\168\4\168\4\216\0\45\0\51\0\214\1\80\1\80\1\80\1\80\1\80\1\80\1\82\1\79\1\70\1\70\1\72\1\70\1\2\13\2\13\7\13\2\13\59\0\59\0\65\0\
    \\223\0\214\1\58\0\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\211\6\211\6\211\6\211\6\211\6\211\6\211\6\211\6\211\6\218\6\214\1\214\1\214\1\214\1\214\1\214\1\30\13\30\13\30\13\30\13\30\13\30\13\35\13\214\1\30\13\30\13\30\13\30\13\30\13\30\13\35\13\28\13\50\1\50\1\50\1\50\1\50\1\
    \\50\1\50\1\50\1\50\1\52\1\169\6\50\1\50\1\50\1\52\1\121\7\43\13\43\13\43\13\43\13\43\13\43\13\43\13\43\13\44\9\47\9\186\4\186\4\186\4\193\4\186\4\192\4\55\9\55\9\55\9\55\9\55\9\55\9\58\9\55\9\55\9\214\1\202\4\202\4\202\4\202\4\203\4\214\1\102\16\102\16\102\16\102\16\102\16\102\16\102\16\
    \\102\16\102\16\102\16\102\16\102\16\253\1\254\1\152\12\214\1\69\9\69\9\66\9\69\9\69\9\69\9\69\9\69\9\4\15\214\1\214\1\214\1\214\1\214\1\214\1\214\1\180\6\186\6\179\6\181\6\179\6\244\6\56\13\56\13\56\13\56\13\56\13\56\13\56\13\211\4\56\13\212\4\69\13\143\2\140\2\155\2\155\2\215\2\77\9\18\15\143\2\
    \\147\2\224\2\226\2\144\2\220\2\220\2\214\1\155\11\161\11\155\11\155\11\155\11\155\11\157\11\155\11\162\11\151\11\157\11\41\1\39\1\214\1\214\1\214\1\170\11\170\11\170\11\170\11\170\11\170\11\170\11\170\11\170\11\170\11\170\11\174\11\32\15\214\1\214\1\214\1\40\15\40\15\40\15\40\15\40\15\40\15\40\15\40\15\40\15\214\1\40\15\
    \\46\15\214\1\214\1\214\1\214\1\92\3\92\3\92\3\92\3\92\3\92\3\92\3\92\3\95\3\214\1\92\3\98\3\206\1\209\1\214\1\214\1\54\15\54\15\54\15\54\15\54\15\54\15\54\15\60\15\54\15\60\15\60\14\60\14\64\14\214\1\214\1\214\1\182\11\182\11\182\11\182\11\182\11\182\11\182\11\186\11\214\1\214\1\214\1\214\1\214\1\
    \\214\1\214\1\214\1\214\1\214\1\214\1\214\1\95\13\95\13\95\13\95\13\95\13\95\13\95\13\95\13\95\13\95\13\100\13\228\0\195\6\196\0\198\6\194\6\194\6\194\6\200\0\197\0\195\6\214\1\194\6\203\6\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\226\6\224\6\226\6\226\6\226\6\226\6\226\6\224\6\104\9\214\1\214\1\
    \\214\1\110\16\110\16\110\16\110\16\110\16\110\16\110\16\110\16\110\16\214\1\108\13\108\13\108\13\108\13\108\13\108\13\108\13\108\13\108\13\108\13\113\13\214\1\154\3\154\3\88\9\88\9\88\9\88\9\88\9\88\9\88\9\95\9\126\12\118\9\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\102\16\214\1\214\1\214\1\214\1\
    \\214\1\214\1\214\1\214\1\214\1\214\1\214\1\68\15\68\15\68\15\68\15\74\15\214\1\68\15\74\15\172\3\234\6\172\3\172\3\172\3\172\3\173\3\172\3\174\3\214\1\172\3\172\3\172\3\175\3\252\6\252\6\252\6\252\6\162\3\252\6\252\6\163\3\164\3\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\131\9\128\9\147\9\
    \\147\9\147\9\147\9\131\9\124\9\147\9\214\1\147\9\136\9\127\1\5\7\125\1\125\1\125\1\126\1\4\7\135\1\125\1\134\1\194\11\194\11\194\11\194\11\194\11\15\7\194\11\17\7\214\1\214\1\29\7\29\7\27\7\29\7\29\7\29\7\29\7\126\13\29\7\29\7\29\7\34\7\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\
    \\214\1\1\14\214\1\68\10\68\10\42\7\68\10\68\10\68\10\48\7\50\7\82\15\82\15\82\15\82\15\82\15\82\15\82\15\88\15\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\218\11\218\11\218\11\218\11\218\11\218\11\218\11\
    \\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\219\11\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\218\11\
    \\218\11\218\11\218\11\218\11\218\11\223\11\214\1\113\7\113\7\113\7\113\7\113\7\113\7\113\7\113\7\113\7\113\7\113\7\113\7\113\7\118\7\113\7\116\7\113\7\120\7\113\7\109\7\117\7\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\239\5\239\5\239\5\239\5\239\5\241\5\239\5\239\5\240\5\214\1\145\7\
    \\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\73\0\214\1\214\1\214\1\214\1\214\1\214\1\214\1\237\7\237\7\237\7\237\7\237\7\237\7\237\7\237\7\239\7\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\145\7\145\7\73\0\214\1\145\7\
    \\145\7\73\0\214\1\224\3\224\3\224\3\107\4\222\8\111\4\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\213\9\136\15\136\15\210\9\130\15\217\9\37\12\37\12\37\12\37\12\37\12\37\12\37\12\248\8\214\1\
    \\214\1\214\1\45\11\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\177\7\180\7\177\7\178\7\214\1\214\1\214\1\214\1\214\1\229\9\
    \\234\9\234\9\234\9\13\0\19\0\230\9\209\7\164\15\200\7\13\0\198\7\13\0\230\9\230\9\204\7\234\9\231\9\234\9\246\0\253\7\231\9\234\9\246\0\214\1\214\1\214\1\214\1\214\1\214\1\248\0\214\1\145\7\145\7\145\7\145\7\145\7\73\0\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\73\0\
    \\214\1\145\7\146\7\4\1\145\7\4\1\145\7\4\1\145\7\145\7\145\7\6\1\214\1\252\9\214\1\145\7\145\7\145\7\145\7\145\7\73\0\145\7\70\4\33\6\214\1\6\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\214\1\145\7\73\0\145\7\145\7\145\7\
    \\145\7\145\7\145\7\145\7\214\1\145\7\69\4\145\7\145\7\145\7\145\7\145\7\214\1\145\7\145\7\145\7\6\1\145\7\73\0\69\4\214\1\145\7\70\4\214\1\214\1\214\1\214\1\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\214\1\145\7\6\1\145\7\7\1\145\7\81\0\145\7\145\7\145\7\145\7\145\7\
    \\145\7\146\7\76\0\145\7\15\1\145\7\74\0\145\7\70\4\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\150\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\68\4"#

encodedScriptExtensionsOffsets2BitMap :: Ptr Word16
encodedScriptExtensionsOffsets2BitMap = Ptr
    "\196\0\80\1\89\1\41\10\5\8\31\8\34\7\73\10\105\10\137\10\169\10\201\10\233\10\9\11\41\11\73\11\105\11\137\11\240\8\14\9\232\3\232\3\248\3\169\11\201\11\233\11\9\12\41\12\73\12\227\0\80\1\105\12\139\9\92\4\26\2\26\2\14\2\26\2\26\2\26\2\137\12\26\2\26\2\206\5\169\12\233\7\119\1\128\6\201\12\233\12\
    \\9\13\41\13\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\172\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\
    \\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\
    \\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\116\3\116\3\116\3\116\3\131\3\121\8\148\8\49\1\73\13\105\13\137\13\169\13\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\
    \\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\137\11\201\13\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\164\0\
    \\212\1\151\1\161\1\87\7\233\13\9\14\41\14\73\14\202\2\105\14\137\14\169\14\63\8\89\8\201\14\233\14\9\15\41\15\73\15\122\5\142\5\171\9\105\15\137\15\169\15\201\15\233\15\60\4\9\16\72\5\41\16\73\16\105\16\137\16\169\16\201\16\200\3\233\16\169\2\169\2\169\2\182\2\24\4\234\2\15\1\15\1\15\1\15\1\15\1\15\1\
    \\15\1\15\1\15\1\248\2\71\2\71\2\71\2\71\2\59\2\71\2\71\2\71\2\71\2\71\2\71\2\71\2\71\2\71\2\71\2\71\2\71\2\71\2\71\2\72\2\225\6\225\6\249\6\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\
    \\15\1\15\1\15\1\9\17\15\1\15\1\15\1\15\1\15\1\15\1\119\7\119\7\144\7\0\0\15\1\24\0\48\0\234\9\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\41\17\116\0\122\0\73\17\15\1\15\1\
    \\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\17\1\180\8\24\3\38\3\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\105\17\15\1\15\1\15\1\15\1\15\1\
    \\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\27\2\26\2\221\5\137\17\112\4\150\4\169\17\201\7\19\6\104\2\116\2\195\5\163\3\163\3\178\3\15\1\15\1\15\1\15\1\201\17\233\17\70\3\84\3\15\1\223\4\40\5\193\6\2\7\9\18\182\4\15\1\15\1\200\4\255\4\41\18\15\1\73\18\121\4\105\18\26\2\
    \\26\2\26\2\137\2\44\6\137\18\26\2\169\18\201\18\15\1\15\1\15\1\15\1\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\
    \\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\
    \\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\
    \\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\84\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\80\0\164\0\164\0\164\0\
    \\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\204\1\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\98\6\164\0\164\0\
    \\3\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\15\1\164\0\164\0\11\1\15\1\15\1\15\1\15\1\15\1\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\154\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\
    \\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\164\0\244\1\89\5\108\5"#

