-- autogenerated from https://www.unicode.org/Public/17.0.0/ucd/Scripts.txt
{-# LANGUAGE PatternSynonyms #-}
{-# OPTIONS_HADDOCK hide #-}

-- |
-- Module      : Unicode.Internal.Char.Scripts
-- Copyright   : (c) 2022 Composewell Technologies and Contributors
-- License     : Apache-2.0
-- Maintainer  : streamly@composewell.com
-- Stability   : experimental


module Unicode.Internal.Char.Scripts
  ( Script(..)
  , scriptShortName
  , script
  , scriptDefinition
  , pattern ScriptCharMask
  , pattern ScriptCharMaskComplement )
where

import Data.Char (ord)
import Data.Int (Int8)
import Data.Ix (Ix)
import Data.Word (Word16)
import GHC.Exts (Addr#, Int#, Int(..), Ptr(..), andI#, iShiftL#, iShiftRL#, nullAddr#, (+#), (-#))
import Unicode.Internal.Bits.Scripts (lookupWord16AsInt#, lookupWord8AsInt#)

-- | Unicode [script](https://www.unicode.org/reports/tr24/).
--
-- The constructors descriptions are the original Unicode values
-- (short and long forms).
--
-- There is a total of 175 scripts.
--
-- @since 0.1.0
data Script
  = Adlam -- ^ @Adlm@: @Adlam@
  | Ahom -- ^ @Ahom@: @Ahom@
  | AnatolianHieroglyphs -- ^ @Hluw@: @Anatolian_Hieroglyphs@
  | Arabic -- ^ @Arab@: @Arabic@
  | Armenian -- ^ @Armn@: @Armenian@
  | Avestan -- ^ @Avst@: @Avestan@
  | Balinese -- ^ @Bali@: @Balinese@
  | Bamum -- ^ @Bamu@: @Bamum@
  | BassaVah -- ^ @Bass@: @Bassa_Vah@
  | Batak -- ^ @Batk@: @Batak@
  | Bengali -- ^ @Beng@: @Bengali@
  | BeriaErfe -- ^ @Berf@: @Beria_Erfe@
  | Bhaiksuki -- ^ @Bhks@: @Bhaiksuki@
  | Bopomofo -- ^ @Bopo@: @Bopomofo@
  | Brahmi -- ^ @Brah@: @Brahmi@
  | Braille -- ^ @Brai@: @Braille@
  | Buginese -- ^ @Bugi@: @Buginese@
  | Buhid -- ^ @Buhd@: @Buhid@
  | CanadianAboriginal -- ^ @Cans@: @Canadian_Aboriginal@
  | Carian -- ^ @Cari@: @Carian@
  | CaucasianAlbanian -- ^ @Aghb@: @Caucasian_Albanian@
  | Chakma -- ^ @Cakm@: @Chakma@
  | Cham -- ^ @Cham@: @Cham@
  | Cherokee -- ^ @Cher@: @Cherokee@
  | Chorasmian -- ^ @Chrs@: @Chorasmian@
  | Common -- ^ @Zyyy@: @Common@
  | Coptic -- ^ @Copt@, @Qaac@: @Coptic@
  | Cuneiform -- ^ @Xsux@: @Cuneiform@
  | Cypriot -- ^ @Cprt@: @Cypriot@
  | CyproMinoan -- ^ @Cpmn@: @Cypro_Minoan@
  | Cyrillic -- ^ @Cyrl@: @Cyrillic@
  | Deseret -- ^ @Dsrt@: @Deseret@
  | Devanagari -- ^ @Deva@: @Devanagari@
  | DivesAkuru -- ^ @Diak@: @Dives_Akuru@
  | Dogra -- ^ @Dogr@: @Dogra@
  | Duployan -- ^ @Dupl@: @Duployan@
  | EgyptianHieroglyphs -- ^ @Egyp@: @Egyptian_Hieroglyphs@
  | Elbasan -- ^ @Elba@: @Elbasan@
  | Elymaic -- ^ @Elym@: @Elymaic@
  | Ethiopic -- ^ @Ethi@: @Ethiopic@
  | Garay -- ^ @Gara@: @Garay@
  | Georgian -- ^ @Geor@: @Georgian@
  | Glagolitic -- ^ @Glag@: @Glagolitic@
  | Gothic -- ^ @Goth@: @Gothic@
  | Grantha -- ^ @Gran@: @Grantha@
  | Greek -- ^ @Grek@: @Greek@
  | Gujarati -- ^ @Gujr@: @Gujarati@
  | GunjalaGondi -- ^ @Gong@: @Gunjala_Gondi@
  | Gurmukhi -- ^ @Guru@: @Gurmukhi@
  | GurungKhema -- ^ @Gukh@: @Gurung_Khema@
  | Han -- ^ @Hani@: @Han@
  | Hangul -- ^ @Hang@: @Hangul@
  | HanifiRohingya -- ^ @Rohg@: @Hanifi_Rohingya@
  | Hanunoo -- ^ @Hano@: @Hanunoo@
  | Hatran -- ^ @Hatr@: @Hatran@
  | Hebrew -- ^ @Hebr@: @Hebrew@
  | Hiragana -- ^ @Hira@: @Hiragana@
  | ImperialAramaic -- ^ @Armi@: @Imperial_Aramaic@
  | Inherited -- ^ @Zinh@, @Qaai@: @Inherited@
  | InscriptionalPahlavi -- ^ @Phli@: @Inscriptional_Pahlavi@
  | InscriptionalParthian -- ^ @Prti@: @Inscriptional_Parthian@
  | Javanese -- ^ @Java@: @Javanese@
  | Kaithi -- ^ @Kthi@: @Kaithi@
  | Kannada -- ^ @Knda@: @Kannada@
  | Katakana -- ^ @Kana@: @Katakana@
  | Kawi -- ^ @Kawi@: @Kawi@
  | KayahLi -- ^ @Kali@: @Kayah_Li@
  | Kharoshthi -- ^ @Khar@: @Kharoshthi@
  | KhitanSmallScript -- ^ @Kits@: @Khitan_Small_Script@
  | Khmer -- ^ @Khmr@: @Khmer@
  | Khojki -- ^ @Khoj@: @Khojki@
  | Khudawadi -- ^ @Sind@: @Khudawadi@
  | KiratRai -- ^ @Krai@: @Kirat_Rai@
  | Lao -- ^ @Laoo@: @Lao@
  | Latin -- ^ @Latn@: @Latin@
  | Lepcha -- ^ @Lepc@: @Lepcha@
  | Limbu -- ^ @Limb@: @Limbu@
  | LinearA -- ^ @Lina@: @Linear_A@
  | LinearB -- ^ @Linb@: @Linear_B@
  | Lisu -- ^ @Lisu@: @Lisu@
  | Lycian -- ^ @Lyci@: @Lycian@
  | Lydian -- ^ @Lydi@: @Lydian@
  | Mahajani -- ^ @Mahj@: @Mahajani@
  | Makasar -- ^ @Maka@: @Makasar@
  | Malayalam -- ^ @Mlym@: @Malayalam@
  | Mandaic -- ^ @Mand@: @Mandaic@
  | Manichaean -- ^ @Mani@: @Manichaean@
  | Marchen -- ^ @Marc@: @Marchen@
  | MasaramGondi -- ^ @Gonm@: @Masaram_Gondi@
  | Medefaidrin -- ^ @Medf@: @Medefaidrin@
  | MeeteiMayek -- ^ @Mtei@: @Meetei_Mayek@
  | MendeKikakui -- ^ @Mend@: @Mende_Kikakui@
  | MeroiticCursive -- ^ @Merc@: @Meroitic_Cursive@
  | MeroiticHieroglyphs -- ^ @Mero@: @Meroitic_Hieroglyphs@
  | Miao -- ^ @Plrd@: @Miao@
  | Modi -- ^ @Modi@: @Modi@
  | Mongolian -- ^ @Mong@: @Mongolian@
  | Mro -- ^ @Mroo@: @Mro@
  | Multani -- ^ @Mult@: @Multani@
  | Myanmar -- ^ @Mymr@: @Myanmar@
  | Nabataean -- ^ @Nbat@: @Nabataean@
  | NagMundari -- ^ @Nagm@: @Nag_Mundari@
  | Nandinagari -- ^ @Nand@: @Nandinagari@
  | NewTaiLue -- ^ @Talu@: @New_Tai_Lue@
  | Newa -- ^ @Newa@: @Newa@
  | Nko -- ^ @Nkoo@: @Nko@
  | Nushu -- ^ @Nshu@: @Nushu@
  | NyiakengPuachueHmong -- ^ @Hmnp@: @Nyiakeng_Puachue_Hmong@
  | Ogham -- ^ @Ogam@: @Ogham@
  | OlChiki -- ^ @Olck@: @Ol_Chiki@
  | OlOnal -- ^ @Onao@: @Ol_Onal@
  | OldHungarian -- ^ @Hung@: @Old_Hungarian@
  | OldItalic -- ^ @Ital@: @Old_Italic@
  | OldNorthArabian -- ^ @Narb@: @Old_North_Arabian@
  | OldPermic -- ^ @Perm@: @Old_Permic@
  | OldPersian -- ^ @Xpeo@: @Old_Persian@
  | OldSogdian -- ^ @Sogo@: @Old_Sogdian@
  | OldSouthArabian -- ^ @Sarb@: @Old_South_Arabian@
  | OldTurkic -- ^ @Orkh@: @Old_Turkic@
  | OldUyghur -- ^ @Ougr@: @Old_Uyghur@
  | Oriya -- ^ @Orya@: @Oriya@
  | Osage -- ^ @Osge@: @Osage@
  | Osmanya -- ^ @Osma@: @Osmanya@
  | PahawhHmong -- ^ @Hmng@: @Pahawh_Hmong@
  | Palmyrene -- ^ @Palm@: @Palmyrene@
  | PauCinHau -- ^ @Pauc@: @Pau_Cin_Hau@
  | PhagsPa -- ^ @Phag@: @Phags_Pa@
  | Phoenician -- ^ @Phnx@: @Phoenician@
  | PsalterPahlavi -- ^ @Phlp@: @Psalter_Pahlavi@
  | Rejang -- ^ @Rjng@: @Rejang@
  | Runic -- ^ @Runr@: @Runic@
  | Samaritan -- ^ @Samr@: @Samaritan@
  | Saurashtra -- ^ @Saur@: @Saurashtra@
  | Sharada -- ^ @Shrd@: @Sharada@
  | Shavian -- ^ @Shaw@: @Shavian@
  | Siddham -- ^ @Sidd@: @Siddham@
  | Sidetic -- ^ @Sidt@: @Sidetic@
  | SignWriting -- ^ @Sgnw@: @SignWriting@
  | Sinhala -- ^ @Sinh@: @Sinhala@
  | Sogdian -- ^ @Sogd@: @Sogdian@
  | SoraSompeng -- ^ @Sora@: @Sora_Sompeng@
  | Soyombo -- ^ @Soyo@: @Soyombo@
  | Sundanese -- ^ @Sund@: @Sundanese@
  | Sunuwar -- ^ @Sunu@: @Sunuwar@
  | SylotiNagri -- ^ @Sylo@: @Syloti_Nagri@
  | Syriac -- ^ @Syrc@: @Syriac@
  | Tagalog -- ^ @Tglg@: @Tagalog@
  | Tagbanwa -- ^ @Tagb@: @Tagbanwa@
  | TaiLe -- ^ @Tale@: @Tai_Le@
  | TaiTham -- ^ @Lana@: @Tai_Tham@
  | TaiViet -- ^ @Tavt@: @Tai_Viet@
  | TaiYo -- ^ @Tayo@: @Tai_Yo@
  | Takri -- ^ @Takr@: @Takri@
  | Tamil -- ^ @Taml@: @Tamil@
  | Tangsa -- ^ @Tnsa@: @Tangsa@
  | Tangut -- ^ @Tang@: @Tangut@
  | Telugu -- ^ @Telu@: @Telugu@
  | Thaana -- ^ @Thaa@: @Thaana@
  | Thai -- ^ @Thai@: @Thai@
  | Tibetan -- ^ @Tibt@: @Tibetan@
  | Tifinagh -- ^ @Tfng@: @Tifinagh@
  | Tirhuta -- ^ @Tirh@: @Tirhuta@
  | Todhri -- ^ @Todr@: @Todhri@
  | TolongSiki -- ^ @Tols@: @Tolong_Siki@
  | Toto -- ^ @Toto@: @Toto@
  | TuluTigalari -- ^ @Tutg@: @Tulu_Tigalari@
  | Ugaritic -- ^ @Ugar@: @Ugaritic@
  | Unknown -- ^ @Zzzz@: @Unknown@
  | Vai -- ^ @Vaii@: @Vai@
  | Vithkuqi -- ^ @Vith@: @Vithkuqi@
  | Wancho -- ^ @Wcho@: @Wancho@
  | WarangCiti -- ^ @Wara@: @Warang_Citi@
  | Yezidi -- ^ @Yezi@: @Yezidi@
  | Yi -- ^ @Yiii@: @Yi@
  | ZanabazarSquare -- ^ @Zanb@: @Zanabazar_Square@
  deriving (Enum, Bounded, Eq, Ord, Ix, Show)

-- | Returns the 4-letter ISO 15924 script code as a NUL-terminated CString.
--
-- @since 0.3.0
scriptShortName :: Script -> Addr#
scriptShortName = \case
    Adlam -> "Adlm\0"#
    Ahom -> "Ahom\0"#
    AnatolianHieroglyphs -> "Hluw\0"#
    Arabic -> "Arab\0"#
    Armenian -> "Armn\0"#
    Avestan -> "Avst\0"#
    Balinese -> "Bali\0"#
    Bamum -> "Bamu\0"#
    BassaVah -> "Bass\0"#
    Batak -> "Batk\0"#
    Bengali -> "Beng\0"#
    BeriaErfe -> "Berf\0"#
    Bhaiksuki -> "Bhks\0"#
    Bopomofo -> "Bopo\0"#
    Brahmi -> "Brah\0"#
    Braille -> "Brai\0"#
    Buginese -> "Bugi\0"#
    Buhid -> "Buhd\0"#
    CanadianAboriginal -> "Cans\0"#
    Carian -> "Cari\0"#
    CaucasianAlbanian -> "Aghb\0"#
    Chakma -> "Cakm\0"#
    Cham -> "Cham\0"#
    Cherokee -> "Cher\0"#
    Chorasmian -> "Chrs\0"#
    Common -> "Zyyy\0"#
    Coptic -> "Copt\0"#
    Cuneiform -> "Xsux\0"#
    Cypriot -> "Cprt\0"#
    CyproMinoan -> "Cpmn\0"#
    Cyrillic -> "Cyrl\0"#
    Deseret -> "Dsrt\0"#
    Devanagari -> "Deva\0"#
    DivesAkuru -> "Diak\0"#
    Dogra -> "Dogr\0"#
    Duployan -> "Dupl\0"#
    EgyptianHieroglyphs -> "Egyp\0"#
    Elbasan -> "Elba\0"#
    Elymaic -> "Elym\0"#
    Ethiopic -> "Ethi\0"#
    Garay -> "Gara\0"#
    Georgian -> "Geor\0"#
    Glagolitic -> "Glag\0"#
    Gothic -> "Goth\0"#
    Grantha -> "Gran\0"#
    Greek -> "Grek\0"#
    Gujarati -> "Gujr\0"#
    GunjalaGondi -> "Gong\0"#
    Gurmukhi -> "Guru\0"#
    GurungKhema -> "Gukh\0"#
    Han -> "Hani\0"#
    Hangul -> "Hang\0"#
    HanifiRohingya -> "Rohg\0"#
    Hanunoo -> "Hano\0"#
    Hatran -> "Hatr\0"#
    Hebrew -> "Hebr\0"#
    Hiragana -> "Hira\0"#
    ImperialAramaic -> "Armi\0"#
    Inherited -> "Zinh\0"#
    InscriptionalPahlavi -> "Phli\0"#
    InscriptionalParthian -> "Prti\0"#
    Javanese -> "Java\0"#
    Kaithi -> "Kthi\0"#
    Kannada -> "Knda\0"#
    Katakana -> "Kana\0"#
    Kawi -> "Kawi\0"#
    KayahLi -> "Kali\0"#
    Kharoshthi -> "Khar\0"#
    KhitanSmallScript -> "Kits\0"#
    Khmer -> "Khmr\0"#
    Khojki -> "Khoj\0"#
    Khudawadi -> "Sind\0"#
    KiratRai -> "Krai\0"#
    Lao -> "Laoo\0"#
    Latin -> "Latn\0"#
    Lepcha -> "Lepc\0"#
    Limbu -> "Limb\0"#
    LinearA -> "Lina\0"#
    LinearB -> "Linb\0"#
    Lisu -> "Lisu\0"#
    Lycian -> "Lyci\0"#
    Lydian -> "Lydi\0"#
    Mahajani -> "Mahj\0"#
    Makasar -> "Maka\0"#
    Malayalam -> "Mlym\0"#
    Mandaic -> "Mand\0"#
    Manichaean -> "Mani\0"#
    Marchen -> "Marc\0"#
    MasaramGondi -> "Gonm\0"#
    Medefaidrin -> "Medf\0"#
    MeeteiMayek -> "Mtei\0"#
    MendeKikakui -> "Mend\0"#
    MeroiticCursive -> "Merc\0"#
    MeroiticHieroglyphs -> "Mero\0"#
    Miao -> "Plrd\0"#
    Modi -> "Modi\0"#
    Mongolian -> "Mong\0"#
    Mro -> "Mroo\0"#
    Multani -> "Mult\0"#
    Myanmar -> "Mymr\0"#
    Nabataean -> "Nbat\0"#
    NagMundari -> "Nagm\0"#
    Nandinagari -> "Nand\0"#
    NewTaiLue -> "Talu\0"#
    Newa -> "Newa\0"#
    Nko -> "Nkoo\0"#
    Nushu -> "Nshu\0"#
    NyiakengPuachueHmong -> "Hmnp\0"#
    Ogham -> "Ogam\0"#
    OlChiki -> "Olck\0"#
    OlOnal -> "Onao\0"#
    OldHungarian -> "Hung\0"#
    OldItalic -> "Ital\0"#
    OldNorthArabian -> "Narb\0"#
    OldPermic -> "Perm\0"#
    OldPersian -> "Xpeo\0"#
    OldSogdian -> "Sogo\0"#
    OldSouthArabian -> "Sarb\0"#
    OldTurkic -> "Orkh\0"#
    OldUyghur -> "Ougr\0"#
    Oriya -> "Orya\0"#
    Osage -> "Osge\0"#
    Osmanya -> "Osma\0"#
    PahawhHmong -> "Hmng\0"#
    Palmyrene -> "Palm\0"#
    PauCinHau -> "Pauc\0"#
    PhagsPa -> "Phag\0"#
    Phoenician -> "Phnx\0"#
    PsalterPahlavi -> "Phlp\0"#
    Rejang -> "Rjng\0"#
    Runic -> "Runr\0"#
    Samaritan -> "Samr\0"#
    Saurashtra -> "Saur\0"#
    Sharada -> "Shrd\0"#
    Shavian -> "Shaw\0"#
    Siddham -> "Sidd\0"#
    Sidetic -> "Sidt\0"#
    SignWriting -> "Sgnw\0"#
    Sinhala -> "Sinh\0"#
    Sogdian -> "Sogd\0"#
    SoraSompeng -> "Sora\0"#
    Soyombo -> "Soyo\0"#
    Sundanese -> "Sund\0"#
    Sunuwar -> "Sunu\0"#
    SylotiNagri -> "Sylo\0"#
    Syriac -> "Syrc\0"#
    Tagalog -> "Tglg\0"#
    Tagbanwa -> "Tagb\0"#
    TaiLe -> "Tale\0"#
    TaiTham -> "Lana\0"#
    TaiViet -> "Tavt\0"#
    TaiYo -> "Tayo\0"#
    Takri -> "Takr\0"#
    Tamil -> "Taml\0"#
    Tangsa -> "Tnsa\0"#
    Tangut -> "Tang\0"#
    Telugu -> "Telu\0"#
    Thaana -> "Thaa\0"#
    Thai -> "Thai\0"#
    Tibetan -> "Tibt\0"#
    Tifinagh -> "Tfng\0"#
    Tirhuta -> "Tirh\0"#
    Todhri -> "Todr\0"#
    TolongSiki -> "Tols\0"#
    Toto -> "Toto\0"#
    TuluTigalari -> "Tutg\0"#
    Ugaritic -> "Ugar\0"#
    Unknown -> "Zzzz\0"#
    Vai -> "Vaii\0"#
    Vithkuqi -> "Vith\0"#
    Wancho -> "Wcho\0"#
    WarangCiti -> "Wara\0"#
    Yezidi -> "Yezi\0"#
    Yi -> "Yiii\0"#
    ZanabazarSquare -> "Zanb\0"#

-- | Used to detect single character in ranges.
pattern ScriptCharMask :: Int#
pattern ScriptCharMask = 0x800000# -- 1 << 23

-- | Used to extract single character in ranges.
pattern ScriptCharMaskComplement :: Int#
pattern ScriptCharMaskComplement = 0x7fffff# -- 1 << 23 ^ 0xffffff

-- | Script definition: list of corresponding characters.
--
-- Returned tuple value:
--
-- 1. Minimum codepoint.
-- 2. Maximum codepoint.
-- 3. Bitmap of ranges, without the extrema.
-- 4. Offset of last entry, in bytes.
--
-- Encoding:

-- * A single character is encoded as an LE Word32:
--   codepoint with the 24th bit set.
-- * A range is encoded as two LE Word32: first is lower bound codepoint,
--   second is upper bound codepoint.
--
-- @since 0.1.0
scriptDefinition :: Script -> (# Int#, Int#, Addr#, Int# #)
scriptDefinition = \case
    Adlam -> (# 0x1E900#, 0x1E95F#, "\1\233\1\0\75\233\1\0\80\233\1\0\89\233\1\0\94\233\129\0"#, 16# #)
    Ahom -> (# 0x11700#, 0x11746#, "\1\23\1\0\26\23\1\0\29\23\1\0\43\23\1\0\48\23\1\0\69\23\1\0"#, 20# #)
    AnatolianHieroglyphs -> (# 0x14400#, 0x14646#, nullAddr#, 0# #)
    Arabic -> (# 0x0600#, 0x1EEF1#, "\1\6\0\0\4\6\0\0\6\6\0\0\11\6\0\0\13\6\0\0\26\6\0\0\28\6\0\0\30\6\0\0\32\6\0\0\63\6\0\0\65\6\0\0\74\6\0\0\86\6\0\0\111\6\0\0\113\6\0\0\220\6\0\0\222\6\0\0\255\6\0\0\80\7\0\0\127\7\0\0\112\8\0\0\145\8\0\0\151\8\0\0\225\8\0\0\227\8\0\0\255\8\0\0\80\251\0\0\61\253\0\0\64\253\0\0\207\253\0\0\240\253\0\0\255\253\0\0\112\254\0\0\116\254\0\0\118\254\0\0\252\254\0\0\96\14\1\0\126\14\1\0\194\14\1\0\199\14\1\0\208\14\1\0\216\14\1\0\250\14\1\0\255\14\1\0\0\238\1\0\3\238\1\0\5\238\1\0\31\238\1\0\33\238\1\0\34\238\1\0\36\238\129\0\39\238\129\0\41\238\1\0\50\238\1\0\52\238\1\0\55\238\1\0\57\238\129\0\59\238\129\0\66\238\129\0\71\238\129\0\73\238\129\0\75\238\129\0\77\238\1\0\79\238\1\0\81\238\1\0\82\238\1\0\84\238\129\0\87\238\129\0\89\238\129\0\91\238\129\0\93\238\129\0\95\238\129\0\97\238\1\0\98\238\1\0\100\238\129\0\103\238\1\0\106\238\1\0\108\238\1\0\114\238\1\0\116\238\1\0\119\238\1\0\121\238\1\0\124\238\1\0\126\238\129\0\128\238\1\0\137\238\1\0\139\238\1\0\155\238\1\0\161\238\1\0\163\238\1\0\165\238\1\0\169\238\1\0\171\238\1\0\187\238\1\0\240\238\129\0"#, 376# #)
    Armenian -> (# 0x0531#, 0xFB17#, "\50\5\0\0\86\5\0\0\89\5\0\0\138\5\0\0\141\5\0\0\143\5\0\0\19\251\0\0\22\251\0\0"#, 28# #)
    Avestan -> (# 0x10B00#, 0x10B3F#, "\1\11\1\0\53\11\1\0\57\11\1\0\62\11\1\0"#, 12# #)
    Balinese -> (# 0x1B00#, 0x1B7F#, "\1\27\0\0\76\27\0\0\78\27\0\0\126\27\0\0"#, 12# #)
    Bamum -> (# 0xA6A0#, 0x16A38#, "\161\166\0\0\247\166\0\0\0\104\1\0\55\106\1\0"#, 12# #)
    BassaVah -> (# 0x16AD0#, 0x16AF5#, "\209\106\1\0\237\106\1\0\240\106\1\0\244\106\1\0"#, 12# #)
    Batak -> (# 0x1BC0#, 0x1BFF#, "\193\27\0\0\243\27\0\0\252\27\0\0\254\27\0\0"#, 12# #)
    Bengali -> (# 0x0980#, 0x09FE#, "\129\9\0\0\131\9\0\0\133\9\0\0\140\9\0\0\143\9\0\0\144\9\0\0\147\9\0\0\168\9\0\0\170\9\0\0\176\9\0\0\178\9\128\0\182\9\0\0\185\9\0\0\188\9\0\0\196\9\0\0\199\9\0\0\200\9\0\0\203\9\0\0\206\9\0\0\215\9\128\0\220\9\0\0\221\9\0\0\223\9\0\0\227\9\0\0\230\9\0\0\253\9\0\0"#, 100# #)
    BeriaErfe -> (# 0x16EA0#, 0x16ED3#, "\161\110\1\0\184\110\1\0\187\110\1\0\210\110\1\0"#, 12# #)
    Bhaiksuki -> (# 0x11C00#, 0x11C6C#, "\1\28\1\0\8\28\1\0\10\28\1\0\54\28\1\0\56\28\1\0\69\28\1\0\80\28\1\0\107\28\1\0"#, 28# #)
    Bopomofo -> (# 0x02EA#, 0x31BF#, "\235\2\128\0\5\49\0\0\47\49\0\0\160\49\0\0\190\49\0\0"#, 16# #)
    Brahmi -> (# 0x11000#, 0x1107F#, "\1\16\1\0\77\16\1\0\82\16\1\0\117\16\1\0"#, 12# #)
    Braille -> (# 0x2800#, 0x28FF#, nullAddr#, 0# #)
    Buginese -> (# 0x1A00#, 0x1A1F#, "\1\26\0\0\27\26\0\0\30\26\128\0"#, 8# #)
    Buhid -> (# 0x1740#, 0x1753#, nullAddr#, 0# #)
    CanadianAboriginal -> (# 0x1400#, 0x11ABF#, "\1\20\0\0\127\22\0\0\176\24\0\0\245\24\0\0\176\26\1\0\190\26\1\0"#, 20# #)
    Carian -> (# 0x102A0#, 0x102D0#, nullAddr#, 0# #)
    CaucasianAlbanian -> (# 0x10530#, 0x1056F#, "\49\5\1\0\99\5\1\0"#, 4# #)
    Chakma -> (# 0x11100#, 0x11147#, "\1\17\1\0\52\17\1\0\54\17\1\0\70\17\1\0"#, 12# #)
    Cham -> (# 0xAA00#, 0xAA5F#, "\1\170\0\0\54\170\0\0\64\170\0\0\77\170\0\0\80\170\0\0\89\170\0\0\92\170\0\0\94\170\0\0"#, 28# #)
    Cherokee -> (# 0x13A0#, 0xABBF#, "\161\19\0\0\245\19\0\0\248\19\0\0\253\19\0\0\112\171\0\0\190\171\0\0"#, 20# #)
    Chorasmian -> (# 0x10FB0#, 0x10FCB#, nullAddr#, 0# #)
    Common -> (# 0x0000#, 0xE007F#, "\1\0\0\0\64\0\0\0\91\0\0\0\96\0\0\0\123\0\0\0\169\0\0\0\171\0\0\0\185\0\0\0\187\0\0\0\191\0\0\0\215\0\128\0\247\0\128\0\185\2\0\0\223\2\0\0\229\2\0\0\233\2\0\0\236\2\0\0\255\2\0\0\116\3\128\0\126\3\128\0\133\3\128\0\135\3\128\0\5\6\128\0\12\6\128\0\27\6\128\0\31\6\128\0\64\6\128\0\221\6\128\0\226\8\128\0\100\9\0\0\101\9\0\0\63\14\128\0\213\15\0\0\216\15\0\0\251\16\128\0\235\22\0\0\237\22\0\0\53\23\0\0\54\23\0\0\2\24\0\0\3\24\0\0\5\24\128\0\211\28\128\0\225\28\128\0\233\28\0\0\236\28\0\0\238\28\0\0\243\28\0\0\245\28\0\0\247\28\0\0\250\28\128\0\0\32\0\0\11\32\0\0\14\32\0\0\100\32\0\0\102\32\0\0\112\32\0\0\116\32\0\0\126\32\0\0\128\32\0\0\142\32\0\0\160\32\0\0\193\32\0\0\0\33\0\0\37\33\0\0\39\33\0\0\41\33\0\0\44\33\0\0\49\33\0\0\51\33\0\0\77\33\0\0\79\33\0\0\95\33\0\0\137\33\0\0\139\33\0\0\144\33\0\0\41\36\0\0\64\36\0\0\74\36\0\0\96\36\0\0\255\39\0\0\0\41\0\0\115\43\0\0\118\43\0\0\255\43\0\0\0\46\0\0\93\46\0\0\240\47\0\0\4\48\0\0\6\48\128\0\8\48\0\0\32\48\0\0\48\48\0\0\55\48\0\0\60\48\0\0\63\48\0\0\155\48\0\0\156\48\0\0\160\48\128\0\251\48\0\0\252\48\0\0\144\49\0\0\159\49\0\0\192\49\0\0\229\49\0\0\239\49\128\0\32\50\0\0\95\50\0\0\127\50\0\0\207\50\0\0\255\50\128\0\88\51\0\0\255\51\0\0\192\77\0\0\255\77\0\0\0\167\0\0\33\167\0\0\136\167\0\0\138\167\0\0\48\168\0\0\57\168\0\0\46\169\128\0\207\169\128\0\91\171\128\0\106\171\0\0\107\171\0\0\62\253\0\0\63\253\0\0\16\254\0\0\25\254\0\0\48\254\0\0\82\254\0\0\84\254\0\0\102\254\0\0\104\254\0\0\107\254\0\0\255\254\128\0\1\255\0\0\32\255\0\0\59\255\0\0\64\255\0\0\91\255\0\0\101\255\0\0\112\255\128\0\158\255\0\0\159\255\0\0\224\255\0\0\230\255\0\0\232\255\0\0\238\255\0\0\249\255\0\0\253\255\0\0\0\1\1\0\2\1\1\0\7\1\1\0\51\1\1\0\55\1\1\0\63\1\1\0\144\1\1\0\156\1\1\0\208\1\1\0\252\1\1\0\225\2\1\0\251\2\1\0\160\188\1\0\163\188\1\0\0\204\1\0\252\204\1\0\0\205\1\0\179\206\1\0\186\206\1\0\208\206\1\0\224\206\1\0\240\206\1\0\80\207\1\0\195\207\1\0\0\208\1\0\245\208\1\0\0\209\1\0\38\209\1\0\41\209\1\0\102\209\1\0\106\209\1\0\122\209\1\0\131\209\1\0\132\209\1\0\140\209\1\0\169\209\1\0\174\209\1\0\234\209\1\0\192\210\1\0\211\210\1\0\224\210\1\0\243\210\1\0\0\211\1\0\86\211\1\0\96\211\1\0\120\211\1\0\0\212\1\0\84\212\1\0\86\212\1\0\156\212\1\0\158\212\1\0\159\212\1\0\162\212\129\0\165\212\1\0\166\212\1\0\169\212\1\0\172\212\1\0\174\212\1\0\185\212\1\0\187\212\129\0\189\212\1\0\195\212\1\0\197\212\1\0\5\213\1\0\7\213\1\0\10\213\1\0\13\213\1\0\20\213\1\0\22\213\1\0\28\213\1\0\30\213\1\0\57\213\1\0\59\213\1\0\62\213\1\0\64\213\1\0\68\213\1\0\70\213\129\0\74\213\1\0\80\213\1\0\82\213\1\0\165\214\1\0\168\214\1\0\203\215\1\0\206\215\1\0\255\215\1\0\113\236\1\0\180\236\1\0\1\237\1\0\61\237\1\0\0\240\1\0\43\240\1\0\48\240\1\0\147\240\1\0\160\240\1\0\174\240\1\0\177\240\1\0\191\240\1\0\193\240\1\0\207\240\1\0\209\240\1\0\245\240\1\0\0\241\1\0\173\241\1\0\230\241\1\0\255\241\1\0\1\242\1\0\2\242\1\0\16\242\1\0\59\242\1\0\64\242\1\0\72\242\1\0\80\242\1\0\81\242\1\0\96\242\1\0\101\242\1\0\0\243\1\0\216\246\1\0\220\246\1\0\236\246\1\0\240\246\1\0\252\246\1\0\0\247\1\0\217\247\1\0\224\247\1\0\235\247\1\0\240\247\129\0\0\248\1\0\11\248\1\0\16\248\1\0\71\248\1\0\80\248\1\0\89\248\1\0\96\248\1\0\135\248\1\0\144\248\1\0\173\248\1\0\176\248\1\0\187\248\1\0\192\248\1\0\193\248\1\0\208\248\1\0\216\248\1\0\0\249\1\0\87\250\1\0\96\250\1\0\109\250\1\0\112\250\1\0\124\250\1\0\128\250\1\0\138\250\1\0\142\250\1\0\198\250\1\0\200\250\129\0\205\250\1\0\220\250\1\0\223\250\1\0\234\250\1\0\239\250\1\0\248\250\1\0\0\251\1\0\146\251\1\0\148\251\1\0\250\251\1\0\1\0\142\0\32\0\14\0\126\0\14\0"#, 1268# #)
    Coptic -> (# 0x03E2#, 0x2CFF#, "\227\3\0\0\239\3\0\0\128\44\0\0\243\44\0\0\249\44\0\0\254\44\0\0"#, 20# #)
    Cuneiform -> (# 0x12000#, 0x12543#, "\1\32\1\0\153\35\1\0\0\36\1\0\110\36\1\0\112\36\1\0\116\36\1\0\128\36\1\0\66\37\1\0"#, 28# #)
    Cypriot -> (# 0x10800#, 0x1083F#, "\1\8\1\0\5\8\1\0\8\8\129\0\10\8\1\0\53\8\1\0\55\8\1\0\56\8\1\0\60\8\129\0"#, 28# #)
    CyproMinoan -> (# 0x12F90#, 0x12FF2#, nullAddr#, 0# #)
    Cyrillic -> (# 0x0400#, 0x1E08F#, "\1\4\0\0\132\4\0\0\135\4\0\0\47\5\0\0\128\28\0\0\138\28\0\0\43\29\128\0\120\29\128\0\224\45\0\0\255\45\0\0\64\166\0\0\159\166\0\0\46\254\0\0\47\254\0\0\48\224\1\0\109\224\1\0"#, 60# #)
    Deseret -> (# 0x10400#, 0x1044F#, nullAddr#, 0# #)
    Devanagari -> (# 0x0900#, 0x11B09#, "\1\9\0\0\80\9\0\0\85\9\0\0\99\9\0\0\102\9\0\0\127\9\0\0\224\168\0\0\255\168\0\0\0\27\1\0\8\27\1\0"#, 36# #)
    DivesAkuru -> (# 0x11900#, 0x11959#, "\1\25\1\0\6\25\1\0\9\25\129\0\12\25\1\0\19\25\1\0\21\25\1\0\22\25\1\0\24\25\1\0\53\25\1\0\55\25\1\0\56\25\1\0\59\25\1\0\70\25\1\0\80\25\1\0\88\25\1\0"#, 56# #)
    Dogra -> (# 0x11800#, 0x1183B#, nullAddr#, 0# #)
    Duployan -> (# 0x1BC00#, 0x1BC9F#, "\1\188\1\0\106\188\1\0\112\188\1\0\124\188\1\0\128\188\1\0\136\188\1\0\144\188\1\0\153\188\1\0\156\188\1\0\158\188\1\0"#, 36# #)
    EgyptianHieroglyphs -> (# 0x13000#, 0x143FA#, "\1\48\1\0\85\52\1\0\96\52\1\0\249\67\1\0"#, 12# #)
    Elbasan -> (# 0x10500#, 0x10527#, nullAddr#, 0# #)
    Elymaic -> (# 0x10FE0#, 0x10FF6#, nullAddr#, 0# #)
    Ethiopic -> (# 0x1200#, 0x1E7FE#, "\1\18\0\0\72\18\0\0\74\18\0\0\77\18\0\0\80\18\0\0\86\18\0\0\88\18\128\0\90\18\0\0\93\18\0\0\96\18\0\0\136\18\0\0\138\18\0\0\141\18\0\0\144\18\0\0\176\18\0\0\178\18\0\0\181\18\0\0\184\18\0\0\190\18\0\0\192\18\128\0\194\18\0\0\197\18\0\0\200\18\0\0\214\18\0\0\216\18\0\0\16\19\0\0\18\19\0\0\21\19\0\0\24\19\0\0\90\19\0\0\93\19\0\0\124\19\0\0\128\19\0\0\153\19\0\0\128\45\0\0\150\45\0\0\160\45\0\0\166\45\0\0\168\45\0\0\174\45\0\0\176\45\0\0\182\45\0\0\184\45\0\0\190\45\0\0\192\45\0\0\198\45\0\0\200\45\0\0\206\45\0\0\208\45\0\0\214\45\0\0\216\45\0\0\222\45\0\0\1\171\0\0\6\171\0\0\9\171\0\0\14\171\0\0\17\171\0\0\22\171\0\0\32\171\0\0\38\171\0\0\40\171\0\0\46\171\0\0\224\231\1\0\230\231\1\0\232\231\1\0\235\231\1\0\237\231\1\0\238\231\1\0\240\231\1\0\253\231\1\0"#, 276# #)
    Garay -> (# 0x10D40#, 0x10D8F#, "\65\13\1\0\101\13\1\0\105\13\1\0\133\13\1\0\142\13\129\0"#, 16# #)
    Georgian -> (# 0x10A0#, 0x2D2D#, "\161\16\0\0\197\16\0\0\199\16\128\0\205\16\128\0\208\16\0\0\250\16\0\0\252\16\0\0\255\16\0\0\144\28\0\0\186\28\0\0\189\28\0\0\191\28\0\0\0\45\0\0\37\45\0\0\39\45\128\0"#, 56# #)
    Glagolitic -> (# 0x2C00#, 0x1E02A#, "\1\44\0\0\95\44\0\0\0\224\1\0\6\224\1\0\8\224\1\0\24\224\1\0\27\224\1\0\33\224\1\0\35\224\1\0\36\224\1\0\38\224\1\0\41\224\1\0"#, 44# #)
    Gothic -> (# 0x10330#, 0x1034A#, nullAddr#, 0# #)
    Grantha -> (# 0x11300#, 0x11374#, "\1\19\1\0\3\19\1\0\5\19\1\0\12\19\1\0\15\19\1\0\16\19\1\0\19\19\1\0\40\19\1\0\42\19\1\0\48\19\1\0\50\19\1\0\51\19\1\0\53\19\1\0\57\19\1\0\60\19\1\0\68\19\1\0\71\19\1\0\72\19\1\0\75\19\1\0\77\19\1\0\80\19\129\0\87\19\129\0\93\19\1\0\99\19\1\0\102\19\1\0\108\19\1\0\112\19\1\0\115\19\1\0"#, 108# #)
    Greek -> (# 0x0370#, 0x1D245#, "\113\3\0\0\115\3\0\0\117\3\0\0\119\3\0\0\122\3\0\0\125\3\0\0\127\3\128\0\132\3\128\0\134\3\128\0\136\3\0\0\138\3\0\0\140\3\128\0\142\3\0\0\161\3\0\0\163\3\0\0\225\3\0\0\240\3\0\0\255\3\0\0\38\29\0\0\42\29\0\0\93\29\0\0\97\29\0\0\102\29\0\0\106\29\0\0\191\29\128\0\0\31\0\0\21\31\0\0\24\31\0\0\29\31\0\0\32\31\0\0\69\31\0\0\72\31\0\0\77\31\0\0\80\31\0\0\87\31\0\0\89\31\128\0\91\31\128\0\93\31\128\0\95\31\0\0\125\31\0\0\128\31\0\0\180\31\0\0\182\31\0\0\196\31\0\0\198\31\0\0\211\31\0\0\214\31\0\0\219\31\0\0\221\31\0\0\239\31\0\0\242\31\0\0\244\31\0\0\246\31\0\0\254\31\0\0\38\33\128\0\101\171\128\0\64\1\1\0\142\1\1\0\160\1\129\0\0\210\1\0\68\210\1\0"#, 240# #)
    Gujarati -> (# 0x0A81#, 0x0AFF#, "\130\10\0\0\131\10\0\0\133\10\0\0\141\10\0\0\143\10\0\0\145\10\0\0\147\10\0\0\168\10\0\0\170\10\0\0\176\10\0\0\178\10\0\0\179\10\0\0\181\10\0\0\185\10\0\0\188\10\0\0\197\10\0\0\199\10\0\0\201\10\0\0\203\10\0\0\205\10\0\0\208\10\128\0\224\10\0\0\227\10\0\0\230\10\0\0\241\10\0\0\249\10\0\0\254\10\0\0"#, 104# #)
    GunjalaGondi -> (# 0x11D60#, 0x11DA9#, "\97\29\1\0\101\29\1\0\103\29\1\0\104\29\1\0\106\29\1\0\142\29\1\0\144\29\1\0\145\29\1\0\147\29\1\0\152\29\1\0\160\29\1\0\168\29\1\0"#, 44# #)
    Gurmukhi -> (# 0x0A01#, 0x0A76#, "\2\10\0\0\3\10\0\0\5\10\0\0\10\10\0\0\15\10\0\0\16\10\0\0\19\10\0\0\40\10\0\0\42\10\0\0\48\10\0\0\50\10\0\0\51\10\0\0\53\10\0\0\54\10\0\0\56\10\0\0\57\10\0\0\60\10\128\0\62\10\0\0\66\10\0\0\71\10\0\0\72\10\0\0\75\10\0\0\77\10\0\0\81\10\128\0\89\10\0\0\92\10\0\0\94\10\128\0\102\10\0\0\117\10\0\0"#, 112# #)
    GurungKhema -> (# 0x16100#, 0x16139#, nullAddr#, 0# #)
    Han -> (# 0x2E80#, 0x33479#, "\129\46\0\0\153\46\0\0\155\46\0\0\243\46\0\0\0\47\0\0\213\47\0\0\5\48\128\0\7\48\128\0\33\48\0\0\41\48\0\0\56\48\0\0\59\48\0\0\0\52\0\0\191\77\0\0\0\78\0\0\255\159\0\0\0\249\0\0\109\250\0\0\112\250\0\0\217\250\0\0\226\111\1\0\227\111\1\0\240\111\1\0\246\111\1\0\0\0\2\0\223\166\2\0\0\167\2\0\29\184\2\0\32\184\2\0\173\206\2\0\176\206\2\0\224\235\2\0\240\235\2\0\93\238\2\0\0\248\2\0\29\250\2\0\0\0\3\0\74\19\3\0\80\19\3\0\120\52\3\0"#, 156# #)
    Hangul -> (# 0x1100#, 0xFFDC#, "\1\17\0\0\255\17\0\0\46\48\0\0\47\48\0\0\49\49\0\0\142\49\0\0\0\50\0\0\30\50\0\0\96\50\0\0\126\50\0\0\96\169\0\0\124\169\0\0\0\172\0\0\163\215\0\0\176\215\0\0\198\215\0\0\203\215\0\0\251\215\0\0\160\255\0\0\190\255\0\0\194\255\0\0\199\255\0\0\202\255\0\0\207\255\0\0\210\255\0\0\215\255\0\0\218\255\0\0\219\255\0\0"#, 108# #)
    HanifiRohingya -> (# 0x10D00#, 0x10D39#, "\1\13\1\0\39\13\1\0\48\13\1\0\56\13\1\0"#, 12# #)
    Hanunoo -> (# 0x1720#, 0x1734#, nullAddr#, 0# #)
    Hatran -> (# 0x108E0#, 0x108FF#, "\225\8\1\0\242\8\1\0\244\8\1\0\245\8\1\0\251\8\1\0\254\8\1\0"#, 20# #)
    Hebrew -> (# 0x0591#, 0xFB4F#, "\146\5\0\0\199\5\0\0\208\5\0\0\234\5\0\0\239\5\0\0\244\5\0\0\29\251\0\0\54\251\0\0\56\251\0\0\60\251\0\0\62\251\128\0\64\251\0\0\65\251\0\0\67\251\0\0\68\251\0\0\70\251\0\0\78\251\0\0"#, 64# #)
    Hiragana -> (# 0x3041#, 0x1F200#, "\66\48\0\0\150\48\0\0\157\48\0\0\159\48\0\0\1\176\1\0\31\177\1\0\50\177\129\0\80\177\1\0\82\177\1\0"#, 32# #)
    ImperialAramaic -> (# 0x10840#, 0x1085F#, "\65\8\1\0\85\8\1\0\87\8\1\0\94\8\1\0"#, 12# #)
    Inherited -> (# 0x0300#, 0xE01EF#, "\1\3\0\0\111\3\0\0\133\4\0\0\134\4\0\0\75\6\0\0\85\6\0\0\112\6\128\0\81\9\0\0\84\9\0\0\176\26\0\0\221\26\0\0\224\26\0\0\235\26\0\0\208\28\0\0\210\28\0\0\212\28\0\0\224\28\0\0\226\28\0\0\232\28\0\0\237\28\128\0\244\28\128\0\248\28\0\0\249\28\0\0\192\29\0\0\255\29\0\0\12\32\0\0\13\32\0\0\208\32\0\0\240\32\0\0\42\48\0\0\45\48\0\0\153\48\0\0\154\48\0\0\0\254\0\0\15\254\0\0\32\254\0\0\45\254\0\0\253\1\129\0\224\2\129\0\59\19\129\0\0\207\1\0\45\207\1\0\48\207\1\0\70\207\1\0\103\209\1\0\105\209\1\0\123\209\1\0\130\209\1\0\133\209\1\0\139\209\1\0\170\209\1\0\173\209\1\0\0\1\14\0\238\1\14\0"#, 212# #)
    InscriptionalPahlavi -> (# 0x10B60#, 0x10B7F#, "\97\11\1\0\114\11\1\0\120\11\1\0\126\11\1\0"#, 12# #)
    InscriptionalParthian -> (# 0x10B40#, 0x10B5F#, "\65\11\1\0\85\11\1\0\88\11\1\0\94\11\1\0"#, 12# #)
    Javanese -> (# 0xA980#, 0xA9DF#, "\129\169\0\0\205\169\0\0\208\169\0\0\217\169\0\0\222\169\128\0"#, 16# #)
    Kaithi -> (# 0x11080#, 0x110CD#, "\129\16\1\0\194\16\1\0"#, 4# #)
    Kannada -> (# 0x0C80#, 0x0CF3#, "\129\12\0\0\140\12\0\0\142\12\0\0\144\12\0\0\146\12\0\0\168\12\0\0\170\12\0\0\179\12\0\0\181\12\0\0\185\12\0\0\188\12\0\0\196\12\0\0\198\12\0\0\200\12\0\0\202\12\0\0\205\12\0\0\213\12\0\0\214\12\0\0\220\12\0\0\222\12\0\0\224\12\0\0\227\12\0\0\230\12\0\0\239\12\0\0\241\12\0\0\242\12\0\0"#, 100# #)
    Katakana -> (# 0x30A1#, 0x1B167#, "\162\48\0\0\250\48\0\0\253\48\0\0\255\48\0\0\240\49\0\0\255\49\0\0\208\50\0\0\254\50\0\0\0\51\0\0\87\51\0\0\102\255\0\0\111\255\0\0\113\255\0\0\157\255\0\0\240\175\1\0\243\175\1\0\245\175\1\0\251\175\1\0\253\175\1\0\254\175\1\0\0\176\129\0\32\177\1\0\34\177\1\0\85\177\129\0\100\177\1\0\102\177\1\0"#, 100# #)
    Kawi -> (# 0x11F00#, 0x11F5A#, "\1\31\1\0\16\31\1\0\18\31\1\0\58\31\1\0\62\31\1\0\89\31\1\0"#, 20# #)
    KayahLi -> (# 0xA900#, 0xA92F#, "\1\169\0\0\45\169\0\0"#, 4# #)
    Kharoshthi -> (# 0x10A00#, 0x10A58#, "\1\10\1\0\3\10\1\0\5\10\1\0\6\10\1\0\12\10\1\0\19\10\1\0\21\10\1\0\23\10\1\0\25\10\1\0\53\10\1\0\56\10\1\0\58\10\1\0\63\10\1\0\72\10\1\0\80\10\1\0\87\10\1\0"#, 60# #)
    KhitanSmallScript -> (# 0x16FE4#, 0x18CFF#, "\0\139\1\0\213\140\1\0"#, 4# #)
    Khmer -> (# 0x1780#, 0x19FF#, "\129\23\0\0\221\23\0\0\224\23\0\0\233\23\0\0\240\23\0\0\249\23\0\0\224\25\0\0\254\25\0\0"#, 28# #)
    Khojki -> (# 0x11200#, 0x11241#, "\1\18\1\0\17\18\1\0\19\18\1\0\64\18\1\0"#, 12# #)
    Khudawadi -> (# 0x112B0#, 0x112F9#, "\177\18\1\0\234\18\1\0\240\18\1\0\248\18\1\0"#, 12# #)
    KiratRai -> (# 0x16D40#, 0x16D79#, nullAddr#, 0# #)
    Lao -> (# 0x0E81#, 0x0EDF#, "\130\14\128\0\132\14\128\0\134\14\0\0\138\14\0\0\140\14\0\0\163\14\0\0\165\14\128\0\167\14\0\0\189\14\0\0\192\14\0\0\196\14\0\0\198\14\128\0\200\14\0\0\206\14\0\0\208\14\0\0\217\14\0\0\220\14\0\0\222\14\0\0"#, 68# #)
    Latin -> (# 0x0041#, 0x1DF2A#, "\66\0\0\0\90\0\0\0\97\0\0\0\122\0\0\0\170\0\128\0\186\0\128\0\192\0\0\0\214\0\0\0\216\0\0\0\246\0\0\0\248\0\0\0\184\2\0\0\224\2\0\0\228\2\0\0\0\29\0\0\37\29\0\0\44\29\0\0\92\29\0\0\98\29\0\0\101\29\0\0\107\29\0\0\119\29\0\0\121\29\0\0\190\29\0\0\0\30\0\0\255\30\0\0\113\32\128\0\127\32\128\0\144\32\0\0\156\32\0\0\42\33\0\0\43\33\0\0\50\33\128\0\78\33\128\0\96\33\0\0\136\33\0\0\96\44\0\0\127\44\0\0\34\167\0\0\135\167\0\0\139\167\0\0\220\167\0\0\241\167\0\0\255\167\0\0\48\171\0\0\90\171\0\0\92\171\0\0\100\171\0\0\102\171\0\0\105\171\0\0\0\251\0\0\6\251\0\0\33\255\0\0\58\255\0\0\65\255\0\0\90\255\0\0\128\7\1\0\133\7\1\0\135\7\1\0\176\7\1\0\178\7\1\0\186\7\1\0\0\223\1\0\30\223\1\0\37\223\1\0\41\223\1\0"#, 260# #)
    Lepcha -> (# 0x1C00#, 0x1C4F#, "\1\28\0\0\55\28\0\0\59\28\0\0\73\28\0\0\77\28\0\0\78\28\0\0"#, 20# #)
    Limbu -> (# 0x1900#, 0x194F#, "\1\25\0\0\30\25\0\0\32\25\0\0\43\25\0\0\48\25\0\0\59\25\0\0\64\25\128\0\68\25\0\0\78\25\0\0"#, 32# #)
    LinearA -> (# 0x10600#, 0x10767#, "\1\6\1\0\54\7\1\0\64\7\1\0\85\7\1\0\96\7\1\0\102\7\1\0"#, 20# #)
    LinearB -> (# 0x10000#, 0x100FA#, "\1\0\1\0\11\0\1\0\13\0\1\0\38\0\1\0\40\0\1\0\58\0\1\0\60\0\1\0\61\0\1\0\63\0\1\0\77\0\1\0\80\0\1\0\93\0\1\0\128\0\1\0\249\0\1\0"#, 52# #)
    Lisu -> (# 0xA4D0#, 0x11FB0#, "\209\164\0\0\255\164\0\0"#, 4# #)
    Lycian -> (# 0x10280#, 0x1029C#, nullAddr#, 0# #)
    Lydian -> (# 0x10920#, 0x1093F#, "\33\9\1\0\57\9\1\0"#, 4# #)
    Mahajani -> (# 0x11150#, 0x11176#, nullAddr#, 0# #)
    Makasar -> (# 0x11EE0#, 0x11EF8#, nullAddr#, 0# #)
    Malayalam -> (# 0x0D00#, 0x0D7F#, "\1\13\0\0\12\13\0\0\14\13\0\0\16\13\0\0\18\13\0\0\68\13\0\0\70\13\0\0\72\13\0\0\74\13\0\0\79\13\0\0\84\13\0\0\99\13\0\0\102\13\0\0\126\13\0\0"#, 52# #)
    Mandaic -> (# 0x0840#, 0x085E#, "\65\8\0\0\91\8\0\0"#, 4# #)
    Manichaean -> (# 0x10AC0#, 0x10AF6#, "\193\10\1\0\230\10\1\0\235\10\1\0\245\10\1\0"#, 12# #)
    Marchen -> (# 0x11C70#, 0x11CB6#, "\113\28\1\0\143\28\1\0\146\28\1\0\167\28\1\0\169\28\1\0\181\28\1\0"#, 20# #)
    MasaramGondi -> (# 0x11D00#, 0x11D59#, "\1\29\1\0\6\29\1\0\8\29\1\0\9\29\1\0\11\29\1\0\54\29\1\0\58\29\129\0\60\29\1\0\61\29\1\0\63\29\1\0\71\29\1\0\80\29\1\0\88\29\1\0"#, 48# #)
    Medefaidrin -> (# 0x16E40#, 0x16E9A#, nullAddr#, 0# #)
    MeeteiMayek -> (# 0xAAE0#, 0xABF9#, "\225\170\0\0\246\170\0\0\192\171\0\0\237\171\0\0\240\171\0\0\248\171\0\0"#, 20# #)
    MendeKikakui -> (# 0x1E800#, 0x1E8D6#, "\1\232\1\0\196\232\1\0\199\232\1\0\213\232\1\0"#, 12# #)
    MeroiticCursive -> (# 0x109A0#, 0x109FF#, "\161\9\1\0\183\9\1\0\188\9\1\0\207\9\1\0\210\9\1\0\254\9\1\0"#, 20# #)
    MeroiticHieroglyphs -> (# 0x10980#, 0x1099F#, nullAddr#, 0# #)
    Miao -> (# 0x16F00#, 0x16F9F#, "\1\111\1\0\74\111\1\0\79\111\1\0\135\111\1\0\143\111\1\0\158\111\1\0"#, 20# #)
    Modi -> (# 0x11600#, 0x11659#, "\1\22\1\0\68\22\1\0\80\22\1\0\88\22\1\0"#, 12# #)
    Mongolian -> (# 0x1800#, 0x1166C#, "\1\24\128\0\4\24\128\0\6\24\0\0\25\24\0\0\32\24\0\0\120\24\0\0\128\24\0\0\170\24\0\0\96\22\1\0\107\22\1\0"#, 36# #)
    Mro -> (# 0x16A40#, 0x16A6F#, "\65\106\1\0\94\106\1\0\96\106\1\0\105\106\1\0\110\106\129\0"#, 16# #)
    Multani -> (# 0x11280#, 0x112A9#, "\129\18\1\0\134\18\1\0\136\18\129\0\138\18\1\0\141\18\1\0\143\18\1\0\157\18\1\0\159\18\1\0\168\18\1\0"#, 32# #)
    Myanmar -> (# 0x1000#, 0x116E3#, "\1\16\0\0\159\16\0\0\224\169\0\0\254\169\0\0\96\170\0\0\127\170\0\0\208\22\1\0\226\22\1\0"#, 28# #)
    Nabataean -> (# 0x10880#, 0x108AF#, "\129\8\1\0\158\8\1\0\167\8\1\0\174\8\1\0"#, 12# #)
    NagMundari -> (# 0x1E4D0#, 0x1E4F9#, nullAddr#, 0# #)
    Nandinagari -> (# 0x119A0#, 0x119E4#, "\161\25\1\0\167\25\1\0\170\25\1\0\215\25\1\0\218\25\1\0\227\25\1\0"#, 20# #)
    NewTaiLue -> (# 0x1980#, 0x19DF#, "\129\25\0\0\171\25\0\0\176\25\0\0\201\25\0\0\208\25\0\0\218\25\0\0\222\25\128\0"#, 24# #)
    Newa -> (# 0x11400#, 0x11461#, "\1\20\1\0\91\20\1\0\93\20\1\0\96\20\1\0"#, 12# #)
    Nko -> (# 0x07C0#, 0x07FF#, "\193\7\0\0\250\7\0\0\253\7\0\0\254\7\0\0"#, 12# #)
    Nushu -> (# 0x16FE1#, 0x1B2FB#, "\112\177\1\0\250\178\1\0"#, 4# #)
    NyiakengPuachueHmong -> (# 0x1E100#, 0x1E14F#, "\1\225\1\0\44\225\1\0\48\225\1\0\61\225\1\0\64\225\1\0\73\225\1\0\78\225\129\0"#, 24# #)
    Ogham -> (# 0x1680#, 0x169C#, nullAddr#, 0# #)
    OlChiki -> (# 0x1C50#, 0x1C7F#, nullAddr#, 0# #)
    OlOnal -> (# 0x1E5D0#, 0x1E5FF#, "\209\229\1\0\250\229\1\0"#, 4# #)
    OldHungarian -> (# 0x10C80#, 0x10CFF#, "\129\12\1\0\178\12\1\0\192\12\1\0\242\12\1\0\250\12\1\0\254\12\1\0"#, 20# #)
    OldItalic -> (# 0x10300#, 0x1032F#, "\1\3\1\0\35\3\1\0\45\3\1\0\46\3\1\0"#, 12# #)
    OldNorthArabian -> (# 0x10A80#, 0x10A9F#, nullAddr#, 0# #)
    OldPermic -> (# 0x10350#, 0x1037A#, nullAddr#, 0# #)
    OldPersian -> (# 0x103A0#, 0x103D5#, "\161\3\1\0\195\3\1\0\200\3\1\0\212\3\1\0"#, 12# #)
    OldSogdian -> (# 0x10F00#, 0x10F27#, nullAddr#, 0# #)
    OldSouthArabian -> (# 0x10A60#, 0x10A7F#, nullAddr#, 0# #)
    OldTurkic -> (# 0x10C00#, 0x10C48#, nullAddr#, 0# #)
    OldUyghur -> (# 0x10F70#, 0x10F89#, nullAddr#, 0# #)
    Oriya -> (# 0x0B01#, 0x0B77#, "\2\11\0\0\3\11\0\0\5\11\0\0\12\11\0\0\15\11\0\0\16\11\0\0\19\11\0\0\40\11\0\0\42\11\0\0\48\11\0\0\50\11\0\0\51\11\0\0\53\11\0\0\57\11\0\0\60\11\0\0\68\11\0\0\71\11\0\0\72\11\0\0\75\11\0\0\77\11\0\0\85\11\0\0\87\11\0\0\92\11\0\0\93\11\0\0\95\11\0\0\99\11\0\0\102\11\0\0\118\11\0\0"#, 108# #)
    Osage -> (# 0x104B0#, 0x104FB#, "\177\4\1\0\211\4\1\0\216\4\1\0\250\4\1\0"#, 12# #)
    Osmanya -> (# 0x10480#, 0x104A9#, "\129\4\1\0\157\4\1\0\160\4\1\0\168\4\1\0"#, 12# #)
    PahawhHmong -> (# 0x16B00#, 0x16B8F#, "\1\107\1\0\69\107\1\0\80\107\1\0\89\107\1\0\91\107\1\0\97\107\1\0\99\107\1\0\119\107\1\0\125\107\1\0\142\107\1\0"#, 36# #)
    Palmyrene -> (# 0x10860#, 0x1087F#, nullAddr#, 0# #)
    PauCinHau -> (# 0x11AC0#, 0x11AF8#, nullAddr#, 0# #)
    PhagsPa -> (# 0xA840#, 0xA877#, nullAddr#, 0# #)
    Phoenician -> (# 0x10900#, 0x1091F#, "\1\9\1\0\27\9\1\0"#, 4# #)
    PsalterPahlavi -> (# 0x10B80#, 0x10BAF#, "\129\11\1\0\145\11\1\0\153\11\1\0\156\11\1\0\169\11\1\0\174\11\1\0"#, 20# #)
    Rejang -> (# 0xA930#, 0xA95F#, "\49\169\0\0\83\169\0\0"#, 4# #)
    Runic -> (# 0x16A0#, 0x16F8#, "\161\22\0\0\234\22\0\0\238\22\0\0\247\22\0\0"#, 12# #)
    Samaritan -> (# 0x0800#, 0x083E#, "\1\8\0\0\45\8\0\0\48\8\0\0\61\8\0\0"#, 12# #)
    Saurashtra -> (# 0xA880#, 0xA8D9#, "\129\168\0\0\197\168\0\0\206\168\0\0\216\168\0\0"#, 12# #)
    Sharada -> (# 0x11180#, 0x11B67#, "\129\17\1\0\223\17\1\0\96\27\1\0\102\27\1\0"#, 12# #)
    Shavian -> (# 0x10450#, 0x1047F#, nullAddr#, 0# #)
    Siddham -> (# 0x11580#, 0x115DD#, "\129\21\1\0\181\21\1\0\184\21\1\0\220\21\1\0"#, 12# #)
    Sidetic -> (# 0x10940#, 0x10959#, nullAddr#, 0# #)
    SignWriting -> (# 0x1D800#, 0x1DAAF#, "\1\216\1\0\139\218\1\0\155\218\1\0\159\218\1\0\161\218\1\0\174\218\1\0"#, 20# #)
    Sinhala -> (# 0x0D81#, 0x111F4#, "\130\13\0\0\131\13\0\0\133\13\0\0\150\13\0\0\154\13\0\0\177\13\0\0\179\13\0\0\187\13\0\0\189\13\128\0\192\13\0\0\198\13\0\0\202\13\128\0\207\13\0\0\212\13\0\0\214\13\128\0\216\13\0\0\223\13\0\0\230\13\0\0\239\13\0\0\242\13\0\0\244\13\0\0\225\17\1\0\243\17\1\0"#, 88# #)
    Sogdian -> (# 0x10F30#, 0x10F59#, nullAddr#, 0# #)
    SoraSompeng -> (# 0x110D0#, 0x110F9#, "\209\16\1\0\232\16\1\0\240\16\1\0\248\16\1\0"#, 12# #)
    Soyombo -> (# 0x11A50#, 0x11AA2#, nullAddr#, 0# #)
    Sundanese -> (# 0x1B80#, 0x1CC7#, "\129\27\0\0\191\27\0\0\192\28\0\0\198\28\0\0"#, 12# #)
    Sunuwar -> (# 0x11BC0#, 0x11BF9#, "\193\27\1\0\225\27\1\0\240\27\1\0\248\27\1\0"#, 12# #)
    SylotiNagri -> (# 0xA800#, 0xA82C#, nullAddr#, 0# #)
    Syriac -> (# 0x0700#, 0x086A#, "\1\7\0\0\13\7\0\0\15\7\0\0\74\7\0\0\77\7\0\0\79\7\0\0\96\8\0\0\105\8\0\0"#, 28# #)
    Tagalog -> (# 0x1700#, 0x171F#, "\1\23\0\0\21\23\0\0"#, 4# #)
    Tagbanwa -> (# 0x1760#, 0x1773#, "\97\23\0\0\108\23\0\0\110\23\0\0\112\23\0\0\114\23\128\0"#, 16# #)
    TaiLe -> (# 0x1950#, 0x1974#, "\81\25\0\0\109\25\0\0\112\25\0\0\115\25\0\0"#, 12# #)
    TaiTham -> (# 0x1A20#, 0x1AAD#, "\33\26\0\0\94\26\0\0\96\26\0\0\124\26\0\0\127\26\0\0\137\26\0\0\144\26\0\0\153\26\0\0\160\26\0\0\172\26\0\0"#, 36# #)
    TaiViet -> (# 0xAA80#, 0xAADF#, "\129\170\0\0\194\170\0\0\219\170\0\0\222\170\0\0"#, 12# #)
    TaiYo -> (# 0x1E6C0#, 0x1E6FF#, "\193\230\1\0\222\230\1\0\224\230\1\0\245\230\1\0\254\230\129\0"#, 16# #)
    Takri -> (# 0x11680#, 0x116C9#, "\129\22\1\0\185\22\1\0\192\22\1\0\200\22\1\0"#, 12# #)
    Tamil -> (# 0x0B82#, 0x11FFF#, "\131\11\128\0\133\11\0\0\138\11\0\0\142\11\0\0\144\11\0\0\146\11\0\0\149\11\0\0\153\11\0\0\154\11\0\0\156\11\128\0\158\11\0\0\159\11\0\0\163\11\0\0\164\11\0\0\168\11\0\0\170\11\0\0\174\11\0\0\185\11\0\0\190\11\0\0\194\11\0\0\198\11\0\0\200\11\0\0\202\11\0\0\205\11\0\0\208\11\128\0\215\11\128\0\230\11\0\0\250\11\0\0\192\31\1\0\241\31\1\0"#, 116# #)
    Tangsa -> (# 0x16A70#, 0x16AC9#, "\113\106\1\0\190\106\1\0\192\106\1\0\200\106\1\0"#, 12# #)
    Tangut -> (# 0x16FE0#, 0x18DF2#, "\0\112\1\0\255\138\1\0\0\141\1\0\30\141\1\0\128\141\1\0\241\141\1\0"#, 20# #)
    Telugu -> (# 0x0C00#, 0x0C7F#, "\1\12\0\0\12\12\0\0\14\12\0\0\16\12\0\0\18\12\0\0\40\12\0\0\42\12\0\0\57\12\0\0\60\12\0\0\68\12\0\0\70\12\0\0\72\12\0\0\74\12\0\0\77\12\0\0\85\12\0\0\86\12\0\0\88\12\0\0\90\12\0\0\92\12\0\0\93\12\0\0\96\12\0\0\99\12\0\0\102\12\0\0\111\12\0\0\119\12\0\0\126\12\0\0"#, 100# #)
    Thaana -> (# 0x0780#, 0x07B1#, nullAddr#, 0# #)
    Thai -> (# 0x0E01#, 0x0E5B#, "\2\14\0\0\58\14\0\0\64\14\0\0\90\14\0\0"#, 12# #)
    Tibetan -> (# 0x0F00#, 0x0FDA#, "\1\15\0\0\71\15\0\0\73\15\0\0\108\15\0\0\113\15\0\0\151\15\0\0\153\15\0\0\188\15\0\0\190\15\0\0\204\15\0\0\206\15\0\0\212\15\0\0\217\15\128\0"#, 48# #)
    Tifinagh -> (# 0x2D30#, 0x2D7F#, "\49\45\0\0\103\45\0\0\111\45\0\0\112\45\0\0"#, 12# #)
    Tirhuta -> (# 0x11480#, 0x114D9#, "\129\20\1\0\199\20\1\0\208\20\1\0\216\20\1\0"#, 12# #)
    Todhri -> (# 0x105C0#, 0x105F3#, nullAddr#, 0# #)
    TolongSiki -> (# 0x11DB0#, 0x11DE9#, "\177\29\1\0\219\29\1\0\224\29\1\0\232\29\1\0"#, 12# #)
    Toto -> (# 0x1E290#, 0x1E2AE#, nullAddr#, 0# #)
    TuluTigalari -> (# 0x11380#, 0x113E2#, "\129\19\1\0\137\19\1\0\139\19\129\0\142\19\129\0\144\19\1\0\181\19\1\0\183\19\1\0\192\19\1\0\194\19\129\0\197\19\129\0\199\19\1\0\202\19\1\0\204\19\1\0\213\19\1\0\215\19\1\0\216\19\1\0\225\19\129\0"#, 64# #)
    Ugaritic -> (# 0x10380#, 0x1039F#, "\129\3\1\0\157\3\1\0"#, 4# #)
    Unknown -> (# 0x0378#, 0x10FFFF#, "\121\3\128\0\128\3\0\0\131\3\0\0\139\3\128\0\141\3\128\0\162\3\128\0\48\5\128\0\87\5\0\0\88\5\0\0\139\5\0\0\140\5\0\0\144\5\128\0\200\5\0\0\207\5\0\0\235\5\0\0\238\5\0\0\245\5\0\0\255\5\0\0\14\7\128\0\75\7\0\0\76\7\0\0\178\7\0\0\191\7\0\0\251\7\0\0\252\7\0\0\46\8\0\0\47\8\0\0\63\8\128\0\92\8\0\0\93\8\0\0\95\8\128\0\107\8\0\0\111\8\0\0\146\8\0\0\150\8\0\0\132\9\128\0\141\9\0\0\142\9\0\0\145\9\0\0\146\9\0\0\169\9\128\0\177\9\128\0\179\9\0\0\181\9\0\0\186\9\0\0\187\9\0\0\197\9\0\0\198\9\0\0\201\9\0\0\202\9\0\0\207\9\0\0\214\9\0\0\216\9\0\0\219\9\0\0\222\9\128\0\228\9\0\0\229\9\0\0\255\9\0\0\0\10\0\0\4\10\128\0\11\10\0\0\14\10\0\0\17\10\0\0\18\10\0\0\41\10\128\0\49\10\128\0\52\10\128\0\55\10\128\0\58\10\0\0\59\10\0\0\61\10\128\0\67\10\0\0\70\10\0\0\73\10\0\0\74\10\0\0\78\10\0\0\80\10\0\0\82\10\0\0\88\10\0\0\93\10\128\0\95\10\0\0\101\10\0\0\119\10\0\0\128\10\0\0\132\10\128\0\142\10\128\0\146\10\128\0\169\10\128\0\177\10\128\0\180\10\128\0\186\10\0\0\187\10\0\0\198\10\128\0\202\10\128\0\206\10\0\0\207\10\0\0\209\10\0\0\223\10\0\0\228\10\0\0\229\10\0\0\242\10\0\0\248\10\0\0\0\11\128\0\4\11\128\0\13\11\0\0\14\11\0\0\17\11\0\0\18\11\0\0\41\11\128\0\49\11\128\0\52\11\128\0\58\11\0\0\59\11\0\0\69\11\0\0\70\11\0\0\73\11\0\0\74\11\0\0\78\11\0\0\84\11\0\0\88\11\0\0\91\11\0\0\94\11\128\0\100\11\0\0\101\11\0\0\120\11\0\0\129\11\0\0\132\11\128\0\139\11\0\0\141\11\0\0\145\11\128\0\150\11\0\0\152\11\0\0\155\11\128\0\157\11\128\0\160\11\0\0\162\11\0\0\165\11\0\0\167\11\0\0\171\11\0\0\173\11\0\0\186\11\0\0\189\11\0\0\195\11\0\0\197\11\0\0\201\11\128\0\206\11\0\0\207\11\0\0\209\11\0\0\214\11\0\0\216\11\0\0\229\11\0\0\251\11\0\0\255\11\0\0\13\12\128\0\17\12\128\0\41\12\128\0\58\12\0\0\59\12\0\0\69\12\128\0\73\12\128\0\78\12\0\0\84\12\0\0\87\12\128\0\91\12\128\0\94\12\0\0\95\12\0\0\100\12\0\0\101\12\0\0\112\12\0\0\118\12\0\0\141\12\128\0\145\12\128\0\169\12\128\0\180\12\128\0\186\12\0\0\187\12\0\0\197\12\128\0\201\12\128\0\206\12\0\0\212\12\0\0\215\12\0\0\219\12\0\0\223\12\128\0\228\12\0\0\229\12\0\0\240\12\128\0\244\12\0\0\255\12\0\0\13\13\128\0\17\13\128\0\69\13\128\0\73\13\128\0\80\13\0\0\83\13\0\0\100\13\0\0\101\13\0\0\128\13\128\0\132\13\128\0\151\13\0\0\153\13\0\0\178\13\128\0\188\13\128\0\190\13\0\0\191\13\0\0\199\13\0\0\201\13\0\0\203\13\0\0\206\13\0\0\213\13\128\0\215\13\128\0\224\13\0\0\229\13\0\0\240\13\0\0\241\13\0\0\245\13\0\0\0\14\0\0\59\14\0\0\62\14\0\0\92\14\0\0\128\14\0\0\131\14\128\0\133\14\128\0\139\14\128\0\164\14\128\0\166\14\128\0\190\14\0\0\191\14\0\0\197\14\128\0\199\14\128\0\207\14\128\0\218\14\0\0\219\14\0\0\224\14\0\0\255\14\0\0\72\15\128\0\109\15\0\0\112\15\0\0\152\15\128\0\189\15\128\0\205\15\128\0\219\15\0\0\255\15\0\0\198\16\128\0\200\16\0\0\204\16\0\0\206\16\0\0\207\16\0\0\73\18\128\0\78\18\0\0\79\18\0\0\87\18\128\0\89\18\128\0\94\18\0\0\95\18\0\0\137\18\128\0\142\18\0\0\143\18\0\0\177\18\128\0\182\18\0\0\183\18\0\0\191\18\128\0\193\18\128\0\198\18\0\0\199\18\0\0\215\18\128\0\17\19\128\0\22\19\0\0\23\19\0\0\91\19\0\0\92\19\0\0\125\19\0\0\127\19\0\0\154\19\0\0\159\19\0\0\246\19\0\0\247\19\0\0\254\19\0\0\255\19\0\0\157\22\0\0\159\22\0\0\249\22\0\0\255\22\0\0\22\23\0\0\30\23\0\0\55\23\0\0\63\23\0\0\84\23\0\0\95\23\0\0\109\23\128\0\113\23\128\0\116\23\0\0\127\23\0\0\222\23\0\0\223\23\0\0\234\23\0\0\239\23\0\0\250\23\0\0\255\23\0\0\26\24\0\0\31\24\0\0\121\24\0\0\127\24\0\0\171\24\0\0\175\24\0\0\246\24\0\0\255\24\0\0\31\25\128\0\44\25\0\0\47\25\0\0\60\25\0\0\63\25\0\0\65\25\0\0\67\25\0\0\110\25\0\0\111\25\0\0\117\25\0\0\127\25\0\0\172\25\0\0\175\25\0\0\202\25\0\0\207\25\0\0\219\25\0\0\221\25\0\0\28\26\0\0\29\26\0\0\95\26\128\0\125\26\0\0\126\26\0\0\138\26\0\0\143\26\0\0\154\26\0\0\159\26\0\0\174\26\0\0\175\26\0\0\222\26\0\0\223\26\0\0\236\26\0\0\255\26\0\0\77\27\128\0\244\27\0\0\251\27\0\0\56\28\0\0\58\28\0\0\74\28\0\0\76\28\0\0\139\28\0\0\143\28\0\0\187\28\0\0\188\28\0\0\200\28\0\0\207\28\0\0\251\28\0\0\255\28\0\0\22\31\0\0\23\31\0\0\30\31\0\0\31\31\0\0\70\31\0\0\71\31\0\0\78\31\0\0\79\31\0\0\88\31\128\0\90\31\128\0\92\31\128\0\94\31\128\0\126\31\0\0\127\31\0\0\181\31\128\0\197\31\128\0\212\31\0\0\213\31\0\0\220\31\128\0\240\31\0\0\241\31\0\0\245\31\128\0\255\31\128\0\101\32\128\0\114\32\0\0\115\32\0\0\143\32\128\0\157\32\0\0\159\32\0\0\194\32\0\0\207\32\0\0\241\32\0\0\255\32\0\0\140\33\0\0\143\33\0\0\42\36\0\0\63\36\0\0\75\36\0\0\95\36\0\0\116\43\0\0\117\43\0\0\244\44\0\0\248\44\0\0\38\45\128\0\40\45\0\0\44\45\0\0\46\45\0\0\47\45\0\0\104\45\0\0\110\45\0\0\113\45\0\0\126\45\0\0\151\45\0\0\159\45\0\0\167\45\128\0\175\45\128\0\183\45\128\0\191\45\128\0\199\45\128\0\207\45\128\0\215\45\128\0\223\45\128\0\94\46\0\0\127\46\0\0\154\46\128\0\244\46\0\0\255\46\0\0\214\47\0\0\239\47\0\0\64\48\128\0\151\48\0\0\152\48\0\0\0\49\0\0\4\49\0\0\48\49\128\0\143\49\128\0\230\49\0\0\238\49\0\0\31\50\128\0\141\164\0\0\143\164\0\0\199\164\0\0\207\164\0\0\44\166\0\0\63\166\0\0\248\166\0\0\255\166\0\0\221\167\0\0\240\167\0\0\45\168\0\0\47\168\0\0\58\168\0\0\63\168\0\0\120\168\0\0\127\168\0\0\198\168\0\0\205\168\0\0\218\168\0\0\223\168\0\0\84\169\0\0\94\169\0\0\125\169\0\0\127\169\0\0\206\169\128\0\218\169\0\0\221\169\0\0\255\169\128\0\55\170\0\0\63\170\0\0\78\170\0\0\79\170\0\0\90\170\0\0\91\170\0\0\195\170\0\0\218\170\0\0\247\170\0\0\0\171\0\0\7\171\0\0\8\171\0\0\15\171\0\0\16\171\0\0\23\171\0\0\31\171\0\0\39\171\128\0\47\171\128\0\108\171\0\0\111\171\0\0\238\171\0\0\239\171\0\0\250\171\0\0\255\171\0\0\164\215\0\0\175\215\0\0\199\215\0\0\202\215\0\0\252\215\0\0\255\248\0\0\110\250\0\0\111\250\0\0\218\250\0\0\255\250\0\0\7\251\0\0\18\251\0\0\24\251\0\0\28\251\0\0\55\251\128\0\61\251\128\0\63\251\128\0\66\251\128\0\69\251\128\0\208\253\0\0\239\253\0\0\26\254\0\0\31\254\0\0\83\254\128\0\103\254\128\0\108\254\0\0\111\254\0\0\117\254\128\0\253\254\0\0\254\254\0\0\0\255\128\0\191\255\0\0\193\255\0\0\200\255\0\0\201\255\0\0\208\255\0\0\209\255\0\0\216\255\0\0\217\255\0\0\221\255\0\0\223\255\0\0\231\255\128\0\239\255\0\0\248\255\0\0\254\255\0\0\255\255\0\0\12\0\129\0\39\0\129\0\59\0\129\0\62\0\129\0\78\0\1\0\79\0\1\0\94\0\1\0\127\0\1\0\251\0\1\0\255\0\1\0\3\1\1\0\6\1\1\0\52\1\1\0\54\1\1\0\143\1\129\0\157\1\1\0\159\1\1\0\161\1\1\0\207\1\1\0\254\1\1\0\127\2\1\0\157\2\1\0\159\2\1\0\209\2\1\0\223\2\1\0\252\2\1\0\255\2\1\0\36\3\1\0\44\3\1\0\75\3\1\0\79\3\1\0\123\3\1\0\127\3\1\0\158\3\129\0\196\3\1\0\199\3\1\0\214\3\1\0\255\3\1\0\158\4\1\0\159\4\1\0\170\4\1\0\175\4\1\0\212\4\1\0\215\4\1\0\252\4\1\0\255\4\1\0\40\5\1\0\47\5\1\0\100\5\1\0\110\5\1\0\123\5\129\0\139\5\129\0\147\5\129\0\150\5\129\0\162\5\129\0\178\5\129\0\186\5\129\0\189\5\1\0\191\5\1\0\244\5\1\0\255\5\1\0\55\7\1\0\63\7\1\0\86\7\1\0\95\7\1\0\104\7\1\0\127\7\1\0\134\7\129\0\177\7\129\0\187\7\1\0\255\7\1\0\6\8\1\0\7\8\1\0\9\8\129\0\54\8\129\0\57\8\1\0\59\8\1\0\61\8\1\0\62\8\1\0\86\8\129\0\159\8\1\0\166\8\1\0\176\8\1\0\223\8\1\0\243\8\129\0\246\8\1\0\250\8\1\0\28\9\1\0\30\9\1\0\58\9\1\0\62\9\1\0\90\9\1\0\127\9\1\0\184\9\1\0\187\9\1\0\208\9\1\0\209\9\1\0\4\10\129\0\7\10\1\0\11\10\1\0\20\10\129\0\24\10\129\0\54\10\1\0\55\10\1\0\59\10\1\0\62\10\1\0\73\10\1\0\79\10\1\0\89\10\1\0\95\10\1\0\160\10\1\0\191\10\1\0\231\10\1\0\234\10\1\0\247\10\1\0\255\10\1\0\54\11\1\0\56\11\1\0\86\11\1\0\87\11\1\0\115\11\1\0\119\11\1\0\146\11\1\0\152\11\1\0\157\11\1\0\168\11\1\0\176\11\1\0\255\11\1\0\73\12\1\0\127\12\1\0\179\12\1\0\191\12\1\0\243\12\1\0\249\12\1\0\40\13\1\0\47\13\1\0\58\13\1\0\63\13\1\0\102\13\1\0\104\13\1\0\134\13\1\0\141\13\1\0\144\13\1\0\95\14\1\0\127\14\129\0\170\14\129\0\174\14\1\0\175\14\1\0\178\14\1\0\193\14\1\0\200\14\1\0\207\14\1\0\217\14\1\0\249\14\1\0\40\15\1\0\47\15\1\0\90\15\1\0\111\15\1\0\138\15\1\0\175\15\1\0\204\15\1\0\223\15\1\0\247\15\1\0\255\15\1\0\78\16\1\0\81\16\1\0\118\16\1\0\126\16\1\0\195\16\1\0\204\16\1\0\206\16\1\0\207\16\1\0\233\16\1\0\239\16\1\0\250\16\1\0\255\16\1\0\53\17\129\0\72\17\1\0\79\17\1\0\119\17\1\0\127\17\1\0\224\17\129\0\245\17\1\0\255\17\1\0\18\18\129\0\66\18\1\0\127\18\1\0\135\18\129\0\137\18\129\0\142\18\129\0\158\18\129\0\170\18\1\0\175\18\1\0\235\18\1\0\239\18\1\0\250\18\1\0\255\18\1\0\4\19\129\0\13\19\1\0\14\19\1\0\17\19\1\0\18\19\1\0\41\19\129\0\49\19\129\0\52\19\129\0\58\19\129\0\69\19\1\0\70\19\1\0\73\19\1\0\74\19\1\0\78\19\1\0\79\19\1\0\81\19\1\0\86\19\1\0\88\19\1\0\92\19\1\0\100\19\1\0\101\19\1\0\109\19\1\0\111\19\1\0\117\19\1\0\127\19\1\0\138\19\129\0\140\19\1\0\141\19\1\0\143\19\129\0\182\19\129\0\193\19\129\0\195\19\1\0\196\19\1\0\198\19\129\0\203\19\129\0\214\19\129\0\217\19\1\0\224\19\1\0\227\19\1\0\255\19\1\0\92\20\129\0\98\20\1\0\127\20\1\0\200\20\1\0\207\20\1\0\218\20\1\0\127\21\1\0\182\21\1\0\183\21\1\0\222\21\1\0\255\21\1\0\69\22\1\0\79\22\1\0\90\22\1\0\95\22\1\0\109\22\1\0\127\22\1\0\186\22\1\0\191\22\1\0\202\22\1\0\207\22\1\0\228\22\1\0\255\22\1\0\27\23\1\0\28\23\1\0\44\23\1\0\47\23\1\0\71\23\1\0\255\23\1\0\60\24\1\0\159\24\1\0\243\24\1\0\254\24\1\0\7\25\1\0\8\25\1\0\10\25\1\0\11\25\1\0\20\25\129\0\23\25\129\0\54\25\129\0\57\25\1\0\58\25\1\0\71\25\1\0\79\25\1\0\90\25\1\0\159\25\1\0\168\25\1\0\169\25\1\0\216\25\1\0\217\25\1\0\229\25\1\0\255\25\1\0\72\26\1\0\79\26\1\0\163\26\1\0\175\26\1\0\249\26\1\0\255\26\1\0\10\27\1\0\95\27\1\0\104\27\1\0\191\27\1\0\226\27\1\0\239\27\1\0\250\27\1\0\255\27\1\0\9\28\129\0\55\28\129\0\70\28\1\0\79\28\1\0\109\28\1\0\111\28\1\0\144\28\1\0\145\28\1\0\168\28\129\0\183\28\1\0\255\28\1\0\7\29\129\0\10\29\129\0\55\29\1\0\57\29\1\0\59\29\129\0\62\29\129\0\72\29\1\0\79\29\1\0\90\29\1\0\95\29\1\0\102\29\129\0\105\29\129\0\143\29\129\0\146\29\129\0\153\29\1\0\159\29\1\0\170\29\1\0\175\29\1\0\220\29\1\0\223\29\1\0\234\29\1\0\223\30\1\0\249\30\1\0\255\30\1\0\17\31\129\0\59\31\1\0\61\31\1\0\91\31\1\0\175\31\1\0\177\31\1\0\191\31\1\0\242\31\1\0\254\31\1\0\154\35\1\0\255\35\1\0\111\36\129\0\117\36\1\0\127\36\1\0\68\37\1\0\143\47\1\0\243\47\1\0\255\47\1\0\86\52\1\0\95\52\1\0\251\67\1\0\255\67\1\0\71\70\1\0\255\96\1\0\58\97\1\0\255\103\1\0\57\106\1\0\63\106\1\0\95\106\129\0\106\106\1\0\109\106\1\0\191\106\129\0\202\106\1\0\207\106\1\0\238\106\1\0\239\106\1\0\246\106\1\0\255\106\1\0\70\107\1\0\79\107\1\0\90\107\129\0\98\107\129\0\120\107\1\0\124\107\1\0\144\107\1\0\63\109\1\0\122\109\1\0\63\110\1\0\155\110\1\0\159\110\1\0\185\110\1\0\186\110\1\0\212\110\1\0\255\110\1\0\75\111\1\0\78\111\1\0\136\111\1\0\142\111\1\0\160\111\1\0\223\111\1\0\229\111\1\0\239\111\1\0\247\111\1\0\255\111\1\0\214\140\1\0\254\140\1\0\31\141\1\0\127\141\1\0\243\141\1\0\239\175\1\0\244\175\129\0\252\175\129\0\255\175\129\0\35\177\1\0\49\177\1\0\51\177\1\0\79\177\1\0\83\177\1\0\84\177\1\0\86\177\1\0\99\177\1\0\104\177\1\0\111\177\1\0\252\178\1\0\255\187\1\0\107\188\1\0\111\188\1\0\125\188\1\0\127\188\1\0\137\188\1\0\143\188\1\0\154\188\1\0\155\188\1\0\164\188\1\0\255\203\1\0\253\204\1\0\255\204\1\0\180\206\1\0\185\206\1\0\209\206\1\0\223\206\1\0\241\206\1\0\255\206\1\0\46\207\1\0\47\207\1\0\71\207\1\0\79\207\1\0\196\207\1\0\255\207\1\0\246\208\1\0\255\208\1\0\39\209\1\0\40\209\1\0\235\209\1\0\255\209\1\0\70\210\1\0\191\210\1\0\212\210\1\0\223\210\1\0\244\210\1\0\255\210\1\0\87\211\1\0\95\211\1\0\121\211\1\0\255\211\1\0\85\212\129\0\157\212\129\0\160\212\1\0\161\212\1\0\163\212\1\0\164\212\1\0\167\212\1\0\168\212\1\0\173\212\129\0\186\212\129\0\188\212\129\0\196\212\129\0\6\213\129\0\11\213\1\0\12\213\1\0\21\213\129\0\29\213\129\0\58\213\129\0\63\213\129\0\69\213\129\0\71\213\1\0\73\213\1\0\81\213\129\0\166\214\1\0\167\214\1\0\204\215\1\0\205\215\1\0\140\218\1\0\154\218\1\0\160\218\129\0\176\218\1\0\255\222\1\0\31\223\1\0\36\223\1\0\43\223\1\0\255\223\1\0\7\224\129\0\25\224\1\0\26\224\1\0\34\224\129\0\37\224\129\0\43\224\1\0\47\224\1\0\110\224\1\0\142\224\1\0\144\224\1\0\255\224\1\0\45\225\1\0\47\225\1\0\62\225\1\0\63\225\1\0\74\225\1\0\77\225\1\0\80\225\1\0\143\226\1\0\175\226\1\0\191\226\1\0\250\226\1\0\254\226\1\0\0\227\1\0\207\228\1\0\250\228\1\0\207\229\1\0\251\229\1\0\254\229\1\0\0\230\1\0\191\230\1\0\223\230\129\0\246\230\1\0\253\230\1\0\0\231\1\0\223\231\1\0\231\231\129\0\236\231\129\0\239\231\129\0\255\231\129\0\197\232\1\0\198\232\1\0\215\232\1\0\255\232\1\0\76\233\1\0\79\233\1\0\90\233\1\0\93\233\1\0\96\233\1\0\112\236\1\0\181\236\1\0\0\237\1\0\62\237\1\0\255\237\1\0\4\238\129\0\32\238\129\0\35\238\129\0\37\238\1\0\38\238\1\0\40\238\129\0\51\238\129\0\56\238\129\0\58\238\129\0\60\238\1\0\65\238\1\0\67\238\1\0\70\238\1\0\72\238\129\0\74\238\129\0\76\238\129\0\80\238\129\0\83\238\129\0\85\238\1\0\86\238\1\0\88\238\129\0\90\238\129\0\92\238\129\0\94\238\129\0\96\238\129\0\99\238\129\0\101\238\1\0\102\238\1\0\107\238\129\0\115\238\129\0\120\238\129\0\125\238\129\0\127\238\129\0\138\238\129\0\156\238\1\0\160\238\1\0\164\238\129\0\170\238\129\0\188\238\1\0\239\238\1\0\242\238\1\0\255\239\1\0\44\240\1\0\47\240\1\0\148\240\1\0\159\240\1\0\175\240\1\0\176\240\1\0\192\240\129\0\208\240\129\0\246\240\1\0\255\240\1\0\174\241\1\0\229\241\1\0\3\242\1\0\15\242\1\0\60\242\1\0\63\242\1\0\73\242\1\0\79\242\1\0\82\242\1\0\95\242\1\0\102\242\1\0\255\242\1\0\217\246\1\0\219\246\1\0\237\246\1\0\239\246\1\0\253\246\1\0\255\246\1\0\218\247\1\0\223\247\1\0\236\247\1\0\239\247\1\0\241\247\1\0\255\247\1\0\12\248\1\0\15\248\1\0\72\248\1\0\79\248\1\0\90\248\1\0\95\248\1\0\136\248\1\0\143\248\1\0\174\248\1\0\175\248\1\0\188\248\1\0\191\248\1\0\194\248\1\0\207\248\1\0\217\248\1\0\255\248\1\0\88\250\1\0\95\250\1\0\110\250\1\0\111\250\1\0\125\250\1\0\127\250\1\0\139\250\1\0\141\250\1\0\199\250\129\0\201\250\1\0\204\250\1\0\221\250\1\0\222\250\1\0\235\250\1\0\238\250\1\0\249\250\1\0\255\250\1\0\147\251\129\0\251\251\1\0\255\255\1\0\224\166\2\0\255\166\2\0\30\184\2\0\31\184\2\0\174\206\2\0\175\206\2\0\225\235\2\0\239\235\2\0\94\238\2\0\255\247\2\0\30\250\2\0\255\255\2\0\75\19\3\0\79\19\3\0\122\52\3\0\0\0\14\0\2\0\14\0\31\0\14\0\128\0\14\0\255\0\14\0\240\1\14\0\254\255\16\0"#, 4864# #)
    Vai -> (# 0xA500#, 0xA62B#, nullAddr#, 0# #)
    Vithkuqi -> (# 0x10570#, 0x105BC#, "\113\5\1\0\122\5\1\0\124\5\1\0\138\5\1\0\140\5\1\0\146\5\1\0\148\5\1\0\149\5\1\0\151\5\1\0\161\5\1\0\163\5\1\0\177\5\1\0\179\5\1\0\185\5\1\0\187\5\129\0"#, 56# #)
    Wancho -> (# 0x1E2C0#, 0x1E2FF#, "\193\226\1\0\249\226\1\0"#, 4# #)
    WarangCiti -> (# 0x118A0#, 0x118FF#, "\161\24\1\0\242\24\1\0"#, 4# #)
    Yezidi -> (# 0x10E80#, 0x10EB1#, "\129\14\1\0\169\14\1\0\171\14\1\0\173\14\1\0\176\14\129\0"#, 16# #)
    Yi -> (# 0xA000#, 0xA4C6#, "\1\160\0\0\140\164\0\0\144\164\0\0\197\164\0\0"#, 12# #)
    ZanabazarSquare -> (# 0x11A00#, 0x11A47#, nullAddr#, 0# #)

-- | Script of a character.
--
-- @since 0.1.0
{-# INLINE script #-}
script :: Char -> Int#
script c
    -- Planes 0-1
    | cp < 0x1FBFB = lookupScriptPlanes0To1BitMap cp#
    -- Planes 2-3: Han
    | cp <= 0x33479 && (cp >= 0x2A700 && (cp >= 0x2F800 && (cp >= 0x31350 || (cp >= 0x30000 && cp <= 0x3134A || cp <= 0x2FA1D)) || (cp >= 0x2CEB0 && (cp >= 0x2EBF0 && cp <= 0x2EE5D || cp <= 0x2EBE0) || (cp >= 0x2B820 && cp <= 0x2CEAD || cp <= 0x2B81D))) || (cp >= 0x20000 && cp <= 0x2A6DF)) = 50#
    -- Plane 14: Common
    | cp <= 0xE007F && (cp >= 0xE0020 || cp == 0xE0001) = 25#
    -- Plane 14: Inherited
    | cp <= 0xE01EF && cp >= 0xE0100 = 58#
    -- Default: Unknown
    | otherwise = 167#
    where
    !cp@(I# cp#) = ord c

{-# INLINE lookupScriptPlanes0To1BitMap #-}
lookupScriptPlanes0To1BitMap :: Int# -> Int#
lookupScriptPlanes0To1BitMap n =
    lookupWord8AsInt# data# (
        lookupWord16AsInt# offsets1# (
            lookupWord16AsInt# offsets2# (
                n `iShiftRL#` 8#
            ) +# ((n `iShiftRL#` 3#) `andI#` maskOffsets)
        ) +# (n `andI#` maskData)
    )
    where
    maskData = (1# `iShiftL#` 3#) -# 1#
    maskOffsets = (1# `iShiftL#` 5#) -# 1#
    !(Ptr data#) = scriptPlanes0To1DataBitMap
    !(Ptr offsets1#) = scriptPlanes0To1Offsets1BitMap
    !(Ptr offsets2#) = scriptPlanes0To1Offsets2BitMap

scriptPlanes0To1DataBitMap :: Ptr Int8
scriptPlanes0To1DataBitMap = Ptr
    "\101\101\101\101\101\101\101\101\167\167\167\167\167\167\3\3\3\167\3\3\3\167\167\167\167\167\167\136\136\136\136\136\136\136\136\167\167\167\167\167\167\128\128\128\128\128\128\128\128\167\
    \\167\167\167\167\167\7\7\7\7\7\7\7\7\167\167\167\167\167\167\167\51\51\51\167\167\167\150\150\150\150\150\150\150\150\167\167\167\167\167\58\58\25\25\56\56\56\56\56\56\56\
    \\167\46\46\167\46\46\46\167\167\167\167\167\167\167\138\138\138\167\138\138\138\138\138\138\138\138\167\167\167\50\50\167\50\50\50\50\50\167\167\167\167\26\26\26\26\26\26\26\167\167\
    \\167\167\73\73\167\167\73\73\73\73\73\73\73\167\167\48\167\167\167\167\167\167\84\84\84\84\167\167\84\84\83\83\83\83\83\83\83\83\167\167\167\167\167\167\167\102\102\102\102\102\
    \\102\167\167\167\33\167\167\33\33\33\33\33\33\167\33\58\58\25\167\167\167\167\167\86\86\86\86\86\86\86\167\128\128\128\128\167\167\167\167\167\167\167\153\14\14\14\14\14\14\14\
    \\14\167\167\165\165\167\167\167\167\167\167\167\129\98\98\98\98\98\98\98\98\167\98\98\98\98\167\98\98\167\167\167\167\167\167\14\14\14\14\14\14\167\167\60\60\60\60\60\60\60\
    \\60\167\167\40\40\40\40\40\40\40\40\167\167\67\67\67\67\67\67\67\67\167\167\167\167\167\167\167\5\5\5\5\5\5\5\5\167\167\61\61\61\61\61\61\61\61\167\25\74\167\
    \\167\25\25\25\25\25\25\25\64\64\56\56\56\56\56\56\56\10\167\10\10\10\10\10\10\10\10\167\48\48\48\167\48\48\48\48\48\48\48\48\167\167\167\167\48\47\47\47\47\47\
    \\47\47\47\167\47\47\167\167\167\167\167\167\167\25\25\130\167\167\167\167\167\167\167\51\51\51\51\51\51\51\167\167\167\167\45\25\45\25\64\64\64\64\64\64\64\64\25\25\64\64\
    \\64\64\167\64\64\167\19\19\19\19\19\19\19\19\167\167\167\167\167\167\167\138\167\167\167\167\138\138\138\138\138\138\138\138\167\138\167\167\159\159\159\159\159\159\159\159\167\159\159\22\
    \\22\22\22\22\22\22\22\167\167\56\56\56\56\56\56\56\56\167\167\64\167\167\118\118\118\118\118\118\118\118\167\167\167\167\167\167\167\45\45\45\45\25\45\45\45\26\26\26\26\26\
    \\26\26\26\44\167\167\44\44\44\44\44\167\167\44\44\44\167\167\44\44\44\44\44\44\44\44\78\78\78\78\78\78\78\78\167\78\78\78\78\78\78\167\167\167\167\167\63\63\167\45\
    \\167\45\167\45\167\45\120\120\167\167\120\120\120\120\120\167\167\120\120\120\167\167\120\120\120\120\120\120\120\120\44\44\167\58\44\44\44\44\167\44\44\44\44\44\44\44\44\167\167\167\
    \\167\167\167\44\44\44\132\132\132\132\132\132\132\132\167\167\167\167\167\167\132\132\39\39\39\39\167\39\39\167\158\158\158\158\158\158\158\158\167\167\167\167\25\167\167\25\25\167\112\112\
    \\112\112\112\112\112\112\167\167\167\167\167\112\112\112\9\9\9\9\9\9\9\9\167\167\167\167\9\9\9\9\48\167\167\48\48\48\167\167\48\167\48\48\167\48\48\167\95\95\95\95\
    \\95\95\95\95\167\167\167\167\167\167\167\94\58\58\58\25\25\58\58\58\58\25\25\25\25\25\25\25\58\167\167\56\167\167\167\167\167\28\167\28\28\28\28\28\28\28\28\167\28\151\
    \\151\151\151\151\151\151\151\167\167\18\18\18\18\18\18\18\18\167\167\87\87\87\87\87\87\87\167\12\12\12\12\12\12\12\12\167\167\167\77\77\77\77\77\77\77\77\167\167\50\50\
    \\58\58\58\58\51\51\51\51\51\51\51\51\25\159\159\167\167\167\167\167\4\4\4\4\4\4\4\4\167\45\45\74\74\74\74\45\45\45\74\74\74\74\74\25\74\74\74\74\74\74\
    \\74\74\25\25\25\25\25\25\25\74\25\55\55\167\55\55\167\55\55\55\55\55\55\55\55\167\55\167\3\3\25\3\3\3\3\3\3\3\25\3\3\3\25\131\131\131\131\131\131\131\
    \\131\167\167\10\10\10\10\10\167\167\10\10\10\10\167\10\10\10\153\153\153\153\153\153\153\153\167\167\167\167\167\167\153\153\167\167\167\167\153\153\96\96\25\25\96\25\96\96\96\96\
    \\96\96\96\96\167\167\167\167\167\167\167\167\10\10\167\10\167\167\167\10\10\76\76\76\76\76\76\76\76\167\148\148\148\148\148\148\167\167\167\149\149\149\149\149\149\149\149\167\167\149\
    \\58\25\25\25\25\58\25\25\25\25\25\50\25\50\45\45\45\30\74\74\74\74\74\74\74\45\45\45\74\25\25\25\167\167\167\167\167\167\167\156\156\167\160\167\167\167\167\167\167\167\
    \\160\159\159\159\159\159\25\25\25\74\74\74\74\74\74\74\167\167\167\167\167\120\120\120\90\90\90\90\90\90\90\90\167\167\167\167\167\167\123\123\123\3\3\3\3\3\3\25\25\74\
    \\25\25\25\25\25\25\25\25\167\167\167\25\25\25\25\25\167\167\25\25\25\25\167\167\167\167\25\25\25\100\100\100\100\100\100\100\100\167\157\157\157\157\157\157\157\157\167\167\167\167\
    \\167\167\67\67\67\67\67\67\67\67\167\67\67\167\86\86\86\86\86\86\86\86\167\38\38\38\38\38\38\38\38\167\140\140\140\140\140\140\140\140\167\167\167\167\167\167\167\146\82\82\
    \\82\82\82\82\82\82\167\71\71\71\167\167\167\167\167\167\48\48\48\48\167\48\167\27\27\27\27\27\167\167\167\167\167\167\138\138\138\167\167\167\2\2\2\2\2\2\2\2\167\97\
    \\97\97\97\97\97\97\97\167\154\154\154\154\154\154\154\154\167\107\107\107\107\107\107\107\107\167\167\167\167\107\107\164\164\164\164\164\164\164\164\167\55\55\55\55\55\167\167\167\167\55\
    \\145\145\145\145\145\145\145\145\167\145\167\46\46\46\167\46\46\46\46\46\46\46\46\167\46\167\120\120\120\167\120\120\120\120\120\120\120\120\73\73\73\167\73\73\73\73\73\73\73\73\
    \\167\73\167\73\73\167\73\167\73\73\41\41\41\167\167\41\41\41\25\41\41\41\41\41\41\41\41\167\41\23\23\23\23\23\23\23\23\167\167\146\146\146\146\146\146\146\146\167\167\69\
    \\69\69\69\69\69\69\69\167\167\148\148\148\148\148\148\148\148\167\167\103\103\103\103\167\167\167\167\167\167\167\20\167\3\3\167\3\167\167\3\3\3\3\3\3\58\58\58\58\58\58\
    \\58\58\167\167\167\167\167\167\167\68\75\75\167\167\167\75\75\75\75\75\58\58\58\25\58\58\58\58\58\58\3\3\25\50\50\50\50\50\50\50\50\167\167\167\167\167\167\167\100\173\
    \\173\173\173\173\173\173\173\167\167\167\66\66\66\66\66\66\66\66\25\66\166\166\166\166\166\166\166\166\167\166\115\115\115\115\115\115\115\115\167\167\167\167\120\120\167\120\122\122\122\122\
    \\122\122\122\122\167\167\74\167\74\74\74\74\74\74\167\74\28\167\28\28\28\28\28\28\167\167\167\28\167\167\28\57\57\57\57\57\57\57\57\167\57\145\145\145\167\167\167\167\167\92\
    \\92\92\92\92\92\92\92\135\135\135\135\135\135\135\135\167\167\33\33\33\33\33\33\33\33\167\33\33\167\167\167\167\167\167\99\99\99\99\99\99\99\99\167\167\167\167\102\102\102\102\
    \\102\102\102\102\12\167\12\12\12\12\12\12\12\167\125\125\125\125\125\125\125\125\167\167\167\167\167\167\167\87\87\87\87\87\87\87\87\47\47\167\47\47\47\47\47\47\47\47\163\163\
    \\163\163\167\167\167\167\167\167\40\40\65\167\65\65\65\65\65\65\65\65\167\167\167\167\167\27\27\27\27\27\27\27\27\167\167\167\36\36\36\36\36\36\36\36\167\167\8\8\8\8\
    \\8\8\8\8\167\167\123\123\123\123\123\123\123\123\167\167\68\68\68\68\68\68\68\68\167\167\35\35\167\167\35\35\35\35\35\35\35\35\167\167\167\167\167\167\167\14\25\25\13\13\
    \\25\25\25\25\25\167\25\167\25\25\25\25\25\25\167\25\25\25\25\167\25\25\149\149\167\167\167\167\167\167\137\137\137\137\137\137\137\137\91\91\91\91\91\91\91\91\167\167\91\0\
    \\0\0\0\167\167\167\167\0\0\167\3\167\3\167\3\167\3\3\3\3\167\3\167\3\167\167\167\167\167\167\167\45\45\45\45\45\167\45\45\45\45\45\45\45\45\167\167\45\45\45\
    \\167\45\45\30\30\30\30\30\30\30\30\58\58\30\10\167\167\10\10\10\10\10\10\10\10\48\167\167\48\48\48\48\48\48\48\48\46\167\46\46\167\46\46\46\46\46\46\167\167\46\
    \\46\120\167\120\120\167\120\120\120\120\120\120\32\32\167\167\167\167\167\167\153\153\167\153\153\153\153\167\167\167\153\153\156\167\156\156\156\156\156\156\156\156\167\156\156\167\167\63\167\63\
    \\63\63\63\63\63\63\63\167\63\63\63\63\167\167\63\63\63\63\84\167\84\84\84\84\84\84\84\84\167\84\84\167\159\159\159\159\159\159\159\167\167\167\39\39\39\39\39\39\39\39\
    \\167\167\167\167\167\167\167\171\108\108\108\108\108\108\108\108\167\167\167\53\53\53\53\53\53\53\53\25\25\167\147\147\147\147\147\147\147\147\167\147\147\76\76\76\76\76\76\76\167\167\
    \\167\167\63\63\63\167\167\167\167\64\64\64\64\167\64\64\64\167\167\167\167\167\6\6\6\6\6\6\6\6\167\6\6\30\30\30\30\30\30\167\167\167\167\167\75\75\75\75\75\75\
    \\75\75\144\144\144\144\144\144\144\144\167\167\167\80\80\80\80\80\80\80\80\167\167\167\67\67\67\67\67\67\167\167\167\167\67\62\62\62\167\167\167\167\167\62\167\167\21\21\21\21\
    \\21\21\21\21\167\21\21\70\70\167\70\70\70\70\70\70\70\70\44\167\44\44\167\44\44\44\44\44\44\1\1\1\1\1\1\1\1\167\167\167\167\167\74\74\74\74\74\74\74\45\
    \\74\74\79\79\79\79\79\79\79\79\167\167\167\167\167\167\167\88\167\88\88\167\88\88\88\88\88\88\88\167\167\167\167\167\167\88\88\167\88\88\88\88\88\88\88\88\36\36\36\36\
    \\36\36\167\167\167\167\167\41\167\167\123\123\167\123\123\123\123\123\123\167\167\11\167\167\11\11\11\11\11\11\11\11\42\167\167\42\42\42\42\42\42\42\167\167\167\167\167\58\3\3\
    \\3\3\3\3\3\167\3\3\3\3\3\3\3\3\167\167\25\4\4\4\4\4\4\4\167\167\4\4\4\85\85\85\85\85\85\85\85\167\167\85\167\46\46\167\46\46\46\167\167\46\
    \\46\46\46\167\153\153\167\153\167\153\153\153\153\167\167\156\167\156\156\156\156\167\167\156\156\156\156\17\17\17\17\17\17\17\17\167\167\167\167\147\147\147\147\147\167\147\147\167\167\167\
    \\167\69\69\69\69\69\69\167\167\167\167\167\167\167\30\76\167\167\167\76\76\76\76\167\167\167\167\103\103\103\103\103\103\103\103\167\167\167\167\16\16\16\16\16\16\16\16\167\167\16\
    \\16\25\25\74\74\25\25\25\25\25\25\45\25\168\168\168\168\168\168\168\168\167\167\167\167\129\129\129\129\129\129\129\129\167\167\167\167\22\22\22\22\22\22\167\167\22\22\22\22\78\
    \\78\78\78\78\78\78\167\78\78\167\78\122\122\122\122\122\122\167\167\167\167\167\167\151\151\121\121\121\121\121\121\121\121\167\167\167\167\20\20\20\20\20\20\20\20\167\167\167\167\169\
    \\169\169\167\169\169\169\169\169\169\169\169\162\162\162\162\162\162\162\162\167\167\167\167\127\127\127\127\127\127\127\127\167\167\167\127\67\67\67\67\167\67\67\67\67\67\67\67\172\172\167\
    \\172\172\172\167\167\167\167\167\167\13\13\13\13\13\13\13\13\24\24\24\24\24\24\24\24\167\167\167\167\165\165\165\167\165\165\165\165\165\165\165\165\167\165\167\167\165\167\165\104\104\
    \\104\104\104\104\104\104\167\104\104\104\34\34\34\34\34\34\34\34\167\167\167\167\163\163\163\163\163\163\163\163\167\167\167\167\11\167\167\11\11\11\11\11\167\167\167\167\155\155\155\155\
    \\155\155\155\155\167\167\167\167\167\55\55\55\106\106\106\106\106\106\106\106\167\167\167\167\74\74\25\25\167\167\167\167\137\137\137\137\137\167\167\167\167\0\0\0\0\0\0\0\0\167\
    \\167\167\167\45\45\45\45\45\45\45\45\167\45\167\45\45\145\145\145\167\167\145\145\145\145\145\145\167\145\105\105\105\105\105\105\105\105\167\167\105\105\105\32\58\58\58\58\32\32\32\
    \\32\32\32\32\32\25\25\32\32\158\158\158\158\158\158\158\158\167\167\167\167\25\167\39\39\39\39\39\39\167\39\39\39\39\167\167\39\39\39\39\39\167\167\167\130\130\130\130\130\130\
    \\130\130\25\25\25\130\130\43\43\43\43\43\43\43\43\167\167\167\167\167\114\114\114\114\114\114\114\114\167\167\167\167\167\169\169\169\167\169\169\169\169\167\169\169\167\169\169\167\167\167\
    \\45\167\167\167\167\167\167\167\54\54\54\54\54\54\54\54\167\54\54\167\167\59\59\59\59\59\59\59\59\167\167\167\167\167\155\106\50\50\68\167\167\167\111\111\111\111\111\111\111\111\
    \\167\167\167\167\167\62\62\62\62\62\62\62\62\167\167\167\167\167\71\71\71\71\71\71\71\71\167\167\167\167\167\1\1\1\167\167\1\1\1\1\167\167\167\167\171\171\171\171\171\171\
    \\171\171\167\167\167\167\167\141\141\141\141\141\141\141\141\167\167\167\167\167\65\167\65\65\65\65\65\65\167\167\167\65\65\29\29\29\29\29\29\29\29\167\167\167\167\167\97\97\97\97\
    \\97\97\97\167\167\167\167\97\97\154\154\154\154\154\154\154\167\167\167\167\167\167\89\89\89\89\89\89\89\89\167\167\167\167\167\94\94\94\94\94\94\94\94\167\167\167\167\94\50\50\
    \\50\50\25\25\25\25\58\58\25\25\25\25\25\25\58\58\58\58\58\58\30\30\110\110\110\110\110\110\110\110\167\167\167\167\110\167\3\3\3\167\3\3\3\3\167\167\167\167\167\3\
    \\167\167\167\167\3\45\45\167\45\45\45\45\45\26\26\26\26\26\26\48\167\48\48\167\48\48\167\48\48\48\48\48\48\46\167\46\46\167\46\46\46\167\167\46\46\46\46\103\103\103\
    \\167\167\167\103\103\167\167\167\167\167\167\132\132\132\132\132\132\167\167\167\167\167\167\132\132\61\61\167\167\167\167\61\61\61\61\61\61\167\25\81\81\81\81\81\81\81\81\167\167\167\
    \\167\167\81\52\52\52\52\52\52\52\52\167\167\167\167\167\167\172\172\172\172\172\172\172\172\167\172\172\172\167\167\139\139\139\139\139\139\139\139\167\167\167\167\167\167\119\119\119\119\119\
    \\119\119\119\167\167\167\167\167\167\70\70\167\70\70\70\70\70\167\167\167\167\167\167\104\104\104\104\167\104\104\104\167\167\167\167\167\167\161\161\161\161\161\161\161\161\167\167\167\167\167\
    \\167\152\152\152\152\152\152\152\152\167\167\167\167\167\167\143\143\143\143\143\143\143\143\167\167\167\167\167\167\49\49\49\49\49\49\49\49\167\167\167\167\167\167\72\72\72\72\72\72\72\
    \\72\167\167\167\167\167\167\42\167\167\42\42\42\42\42\167\42\42\167\42\42\42\42\42\42\42\42\170\170\170\170\170\170\170\170\167\167\167\167\167\170\58\25\58\58\58\58\58\58\25\
    \\25\25\25\58\25\25\56\25\25\167\167\167\167\167\167\167\160\160\160\160\160\160\160\160\78\78\78\167\78\78\167\78\78\78\78\78\78\167\167\142\142\142\142\142\142\142\142\109\109\109\
    \\109\109\109\109\109\15\15\15\15\15\15\15\15\126\126\126\126\126\126\126\126\31\31\31\31\31\31\31\31\134\134\134\134\134\134\134\134\37\37\37\37\37\37\37\37\124\124\124\124\124\
    \\124\124\124\93\93\93\93\93\93\93\93\117\117\117\117\117\117\117\117\113\113\113\113\113\113\113\113\116\116\116\116\116\116\116\116\133\133\133\133\133\133\133\133\174\174\174\174\174\174\174\
    \\174"#

scriptPlanes0To1Offsets1BitMap :: Ptr Word16
scriptPlanes0To1Offsets1BitMap = Ptr
    "\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\24\7\26\7\236\3\236\3\236\3\236\3\222\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\
    \\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\125\3\126\3\126\3\131\3\125\3\126\3\126\3\131\3\126\4\126\4\126\4\126\4\126\4\123\4\126\4\123\4\126\3\126\3\127\3\126\3\126\3\126\3\
    \\127\3\126\3\126\3\126\3\126\3\45\4\40\4\126\3\126\3\126\3\126\3\126\3\46\4\111\3\117\3\126\3\43\4\126\3\126\3\126\3\126\3\126\3\126\3\126\3\44\4\214\5\214\5\214\5\214\5\214\5\214\5\214\5\214\5\214\5\214\5\214\5\214\5\214\5\214\5\25\2\23\2\174\1\42\11\145\7\145\7\142\7\145\7\145\7\145\7\145\7\
    \\145\7\145\7\145\7\31\2\33\2\145\7\145\7\147\7\147\7\145\7\145\7\145\7\145\7\147\7\147\7\145\7\86\2\145\7\145\7\145\7\147\7\145\7\145\7\145\7\145\7\145\7\145\7\139\7\145\7\139\7\145\7\149\7\140\7\145\7\145\7\153\7\146\7\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\
    \\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\125\4\126\4\126\4\126\4\126\4\129\3\54\7\126\4\126\4\126\4\126\4\127\4\94\1\126\4\126\4\126\4\126\4\126\4\126\4\3\3\1\3\126\4\139\12\250\2\255\2\126\4\126\4\126\4\253\2\126\4\126\4\
    \\126\4\126\4\126\4\126\4\126\4\55\4\236\3\236\3\85\4\236\3\99\3\244\10\149\3\149\3\150\3\152\3\143\3\149\3\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\
    \\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\255\5\236\3\236\3\236\3\126\4\126\4\126\4\126\4\126\4\56\4\236\3\236\3\126\4\55\4\236\3\236\3\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\
    \\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\129\4\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\252\6\236\3\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\
    \\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\250\6\45\9\66\7\139\4\67\7\67\7\126\4\126\4\126\4\70\7\58\7\93\1\64\7\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\
    \\126\4\126\4\128\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\128\4\236\3\236\3\236\3\236\3\253\5\253\5\253\5\129\0\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\133\0\236\3\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\
    \\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\252\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\111\8\192\1\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\250\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\61\12\61\12\61\12\61\12\61\12\61\12\61\12\61\12\61\12\61\12\61\12\61\12\66\12\236\3\253\1\253\1\
    \\253\1\253\1\116\8\236\3\11\3\236\3\236\3\236\3\2\2\236\3\107\8\236\3\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\0\11\37\5\37\5\37\5\37\5\37\5\40\5\
    \\37\5\39\5\37\5\43\5\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\51\5\51\5\51\5\52\5\236\3\236\3\199\13\199\13\199\13\199\13\199\13\199\13\199\13\205\13\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\
    \\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\13\6\16\6\13\6\13\6\13\6\13\6\13\6\13\6\14\6\236\3\254\8\254\8\254\8\254\8\254\8\254\8\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\
    \\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\88\7\17\11\236\3\85\7\87\7\88\7\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\121\6\121\6\121\6\121\6\121\6\121\6\123\6\121\6\121\6\121\6\
    \\121\6\123\6\236\3\236\3\236\3\236\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\60\8\60\8\60\8\63\8\128\11\128\11\128\11\128\11\128\11\128\11\128\11\128\11\
    \\128\11\133\11\128\11\159\1\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\240\6\249\4\236\3\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\252\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\236\3\165\8\165\8\165\8\168\8\200\1\200\1\200\1\200\1\200\1\200\1\207\1\236\3\2\3\126\4\126\4\144\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\236\3\126\4\56\4\126\4\126\4\126\4\126\4\126\4\236\3\126\4\126\4\126\4\128\4\126\4\144\4\56\4\236\3\126\4\57\4\236\3\236\3\
    \\236\3\236\3\126\4\126\4\126\4\126\4\251\9\247\9\123\4\126\4\126\4\135\3\126\4\126\4\126\3\126\3\126\3\126\3\126\3\54\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\
    \\126\4\126\4\128\4\236\3\236\3\236\3\236\3\236\3\236\3\151\1\126\4\126\4\126\4\126\4\83\4\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\82\4\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\126\3\87\4\236\3\236\3\243\8\126\3\126\3\126\3\85\4\239\8\89\4\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\25\11\25\11\25\11\25\11\25\11\25\11\25\11\25\11\25\11\107\7\25\11\109\7\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\94\1\126\4\126\4\126\4\126\4\126\4\126\4\126\4\129\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\180\0\180\0\180\0\187\0\94\1\126\4\126\4\126\4\
    \\126\4\126\4\126\4\128\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\94\1\126\4\126\4\126\4\126\4\126\4\126\4\126\4\129\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\0\0\0\0\0\0\0\0\0\0\6\0\25\13\25\13\25\13\25\13\25\13\236\3\25\13\31\13\47\1\47\1\47\1\47\1\49\1\46\1\47\1\47\1\49\1\216\6\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\102\9\102\9\102\9\103\9\39\13\39\13\39\13\39\13\39\13\137\10\141\10\236\3\206\5\236\3\102\9\131\7\236\3\236\3\236\3\206\5\144\10\149\10\149\10\149\10\149\10\149\10\166\1\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\167\1\126\4\126\4\149\10\149\10\149\10\149\10\126\4\126\4\126\4\126\4\128\4\
    \\150\1\182\1\182\1\182\1\182\1\182\1\182\1\182\1\182\1\182\1\182\1\182\1\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\128\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\
    \\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\138\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\144\4\93\1\126\4\126\4\57\4\236\3\126\4\126\4\57\4\236\3\66\7\139\4\67\7\67\7\126\4\126\4\126\4\70\7\
    \\58\7\93\1\64\7\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\67\7\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\67\7\178\2\72\7\126\4\61\7\68\7\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\
    \\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\133\4\126\4\129\4\126\4\129\4\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\240\6\249\4\236\3\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\239\6\
    \\239\6\239\6\239\6\250\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\150\12\150\12\150\12\150\12\150\12\155\12\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\
    \\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\10\5\11\5\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\31\3\31\3\31\3\32\3\31\3\31\3\33\3\
    \\57\10\14\7\14\7\14\7\14\7\14\7\14\7\14\7\14\7\16\7\236\3\14\7\56\9\56\9\14\7\14\7\109\4\14\7\14\7\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\165\13\165\13\165\13\165\13\165\13\165\13\165\13\171\13\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\45\8\160\2\44\8\45\8\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\70\3\
    \\70\3\70\3\70\3\70\3\70\3\71\3\236\3\70\3\70\3\72\3\236\3\70\3\236\3\236\3\236\3\72\6\126\3\126\3\126\3\126\3\126\3\70\6\89\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\165\13\165\13\165\13\165\13\165\13\165\13\165\13\171\13\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\100\12\100\12\100\12\100\12\100\12\100\12\100\12\100\12\100\12\100\12\100\12\105\12\70\9\70\9\70\9\67\9\70\9\70\9\228\10\236\3\236\3\236\3\236\3\236\3\165\3\166\3\102\9\167\3\102\9\102\9\102\9\102\9\162\3\211\5\244\5\102\9\102\9\102\9\93\9\102\9\102\9\102\9\102\9\102\9\102\9\
    \\102\9\102\9\102\9\102\9\102\9\102\9\165\3\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\117\4\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\
    \\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\236\3\236\3\236\3\236\3\102\9\102\9\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\62\0\19\5\19\5\19\5\
    \\20\5\19\5\79\12\28\5\28\5\28\5\28\5\28\5\28\5\28\5\28\5\28\5\29\5\28\5\92\12\4\7\4\7\4\7\6\7\6\7\236\3\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\67\7\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\67\7\178\2\72\7\126\4\61\7\68\7\126\4\126\4\126\4\126\4\
    \\126\4\126\4\126\4\126\4\126\4\126\4\127\4\236\3\126\4\126\4\126\4\57\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\139\5\139\5\139\5\139\5\141\5\48\9\238\13\238\13\238\13\238\13\238\13\238\13\238\13\69\4\68\4\69\4\44\8\44\8\45\8\236\3\45\8\45\8\
    \\45\8\45\8\45\8\45\8\45\8\45\8\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\164\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\101\3\102\3\102\3\102\3\103\3\101\3\102\3\102\3\102\3\102\3\102\3\117\9\
    \\148\3\149\3\149\3\149\3\149\3\149\3\149\3\236\3\149\3\149\3\149\3\62\5\60\5\236\3\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\3\10\7\10\236\3\236\3\161\7\
    \\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\161\7\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\55\0\236\3\103\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\
    \\253\1\253\1\253\1\253\1\253\1\116\8\236\3\11\3\236\3\236\3\236\3\2\2\236\3\107\8\236\3\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\252\10\44\8\44\8\44\8\44\8\44\8\44\8\44\8\44\8\44\8\112\11\45\8\112\11\44\8\44\8\44\8\44\8\44\8\
    \\112\11\44\8\44\8\44\8\44\8\112\11\45\8\112\11\44\8\45\8\44\8\44\8\44\8\44\8\44\8\112\11\44\8\44\8\44\8\44\8\44\8\44\8\44\8\44\8\115\11\44\8\44\8\44\8\47\8\44\8\44\8\44\8\50\8\149\5\149\5\149\5\149\5\149\5\149\5\149\5\149\5\149\5\149\5\151\5\151\5\126\4\126\4\126\4\126\4\251\9\
    \\247\9\123\4\126\4\126\4\135\3\126\4\126\4\126\3\126\3\126\3\126\3\126\3\54\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\130\12\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\67\7\126\4\91\1\134\3\126\4\127\4\126\3\87\4\126\4\126\4\126\4\126\4\
    \\56\4\236\3\214\5\214\5\214\5\214\5\221\5\236\3\93\14\93\14\93\14\93\14\93\14\236\3\53\13\53\13\53\13\53\13\53\13\59\13\236\3\236\3\67\13\67\13\67\13\73\13\236\3\236\3\236\3\236\3\157\10\157\10\157\10\161\10\236\3\236\3\199\4\199\4\200\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\102\9\102\9\102\9\103\9\39\13\39\13\39\13\39\13\39\13\137\10\141\10\236\3\206\5\236\3\102\9\131\7\236\3\236\3\236\3\206\5\113\12\113\12\113\12\113\12\113\12\113\12\113\12\113\12\113\12\118\12\113\12\113\12\113\12\113\12\113\12\113\12\113\12\242\2\113\12\113\12\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\218\11\
    \\236\3\254\5\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\100\12\100\12\100\12\100\12\100\12\100\12\100\12\100\12\100\12\100\12\100\12\105\12\70\9\70\9\70\9\67\9\70\9\70\9\228\10\236\3\236\3\236\3\236\3\236\3\70\5\72\5\70\5\70\5\70\5\70\5\70\5\70\5\70\5\50\11\102\9\102\9\102\9\102\9\102\9\102\9\
    \\164\4\164\4\164\4\164\4\164\4\164\4\170\4\236\3\63\11\63\11\63\11\63\11\63\11\63\11\63\11\68\11\175\3\175\3\175\3\175\3\175\3\177\3\175\3\176\3\125\9\125\9\125\9\129\9\70\5\105\6\102\9\102\9\102\9\102\9\170\12\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\160\3\102\9\102\9\102\9\81\11\81\11\
    \\81\11\81\11\81\11\81\11\81\11\81\11\81\11\81\11\76\11\81\11\85\11\81\11\81\11\81\11\192\3\185\3\172\7\113\1\113\1\111\1\245\3\188\3\185\3\189\3\237\3\240\3\186\3\113\1\113\1\114\1\121\1\131\1\183\7\126\1\126\1\124\1\226\2\222\2\131\1\218\2\164\0\241\4\236\4\126\1\127\1\236\3\80\5\87\5\82\5\85\5\
    \\85\5\83\5\194\7\141\9\87\5\101\0\106\0\236\3\201\7\85\5\105\0\84\5\95\5\98\2\95\2\110\2\110\2\98\5\209\7\94\2\98\2\102\2\92\4\52\6\99\2\110\2\110\2\236\3\226\7\232\7\229\7\149\9\211\3\232\7\200\3\214\3\232\7\229\7\207\3\236\3\208\3\200\3\200\3\205\3\242\7\245\7\240\7\242\7\242\7\240\7\
    \\242\7\165\9\245\7\161\9\60\4\247\7\163\9\242\7\58\4\242\7\1\8\4\8\255\7\1\8\1\8\255\7\5\8\12\8\4\8\8\8\79\2\100\8\10\8\1\8\103\8\236\3\22\8\25\8\20\8\22\8\22\8\22\8\22\8\22\8\25\8\20\8\168\0\22\8\172\0\22\8\22\8\22\8\113\0\118\0\221\1\218\1\118\0\118\0\115\0\224\1\
    \\221\1\213\1\223\1\118\0\254\4\118\0\2\5\236\3\167\2\168\2\168\2\168\2\168\2\168\2\168\2\173\2\168\2\168\2\168\2\172\2\236\3\236\3\236\3\236\3\122\5\108\5\112\5\112\5\116\5\112\5\112\5\157\0\115\5\156\0\112\5\152\0\236\3\236\3\236\3\236\3\232\1\232\1\232\1\232\1\232\1\232\1\232\1\232\1\232\1\231\1\
    \\232\1\232\1\232\1\36\8\231\1\232\1\232\1\232\1\232\1\231\1\232\1\232\1\232\1\235\1\232\1\235\1\77\4\94\3\236\3\236\3\236\3\236\3\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\148\6\139\5\139\5\139\5\139\5\141\5\48\9\139\5\139\5\
    \\139\5\139\5\139\5\135\5\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\159\5\159\5\161\5\216\4\71\8\71\8\74\8\236\3\173\9\173\9\177\9\236\3\82\8\85\8\
    \\189\9\236\3\169\5\169\5\169\5\169\5\169\5\169\5\169\5\169\5\169\5\169\5\169\5\171\5\169\5\201\9\169\5\201\9\222\3\228\3\228\3\234\3\228\3\228\3\228\3\228\3\228\3\228\3\228\3\228\3\228\3\228\3\228\3\235\3\228\3\228\3\228\3\228\3\228\3\233\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\41\3\43\3\236\3\
    \\253\3\253\3\253\3\254\3\253\3\96\8\253\3\96\8\211\9\253\3\179\5\179\5\179\5\6\4\7\4\236\3\223\9\223\9\223\9\223\9\223\9\189\5\223\9\223\9\223\9\191\5\223\9\225\12\169\5\169\5\169\5\169\5\235\9\235\9\235\9\239\9\15\4\15\4\15\4\15\4\15\4\15\4\15\4\16\4\15\4\15\4\15\4\18\4\15\4\80\7\
    \\15\4\80\7\15\4\17\4\214\5\214\5\214\5\214\5\214\5\216\5\214\5\218\5\236\3\236\3\124\8\124\8\124\8\124\8\124\8\124\8\124\8\124\8\124\8\127\8\124\8\124\8\124\8\124\8\124\8\124\8\5\14\5\14\5\14\5\14\5\14\5\14\5\14\5\14\202\2\202\2\202\2\202\2\202\2\202\2\206\2\210\2\146\8\146\8\146\8\146\8\
    \\146\8\146\8\146\8\232\5\146\8\230\5\13\14\13\14\13\14\13\14\13\14\13\14\161\7\138\8\139\5\139\5\139\5\139\5\139\5\130\5\5\14\236\3\240\5\214\5\242\5\26\4\27\4\215\0\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\
    \\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\21\14\191\13\191\13\191\13\191\13\191\13\191\13\191\13\191\13\191\13\191\13\191\13\191\13\126\3\126\3\126\3\126\3\33\2\33\2\33\2\33\2\33\2\33\2\33\2\33\2\33\2\33\2\33\2\33\2\33\2\33\2\144\0\140\0\32\4\126\4\126\4\126\4\252\5\80\3\126\4\126\12\
    \\252\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\253\1\93\0\88\0\181\1\182\1\182\1\182\1\182\1\182\1\182\1\182\1\182\1\182\1\182\1\187\1\86\3\86\3\86\3\167\1\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\86\3\86\3\86\3\87\3\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\
    \\182\1\182\1\182\1\182\1\182\1\183\1\154\8\154\8\154\8\154\8\154\8\157\8\126\4\56\4\29\14\29\14\29\14\29\14\29\14\29\14\29\14\236\3\144\2\144\2\144\2\144\2\144\2\144\2\144\2\144\2\146\2\152\2\144\2\150\2\81\11\81\11\81\11\81\11\24\6\24\6\24\6\24\6\24\6\26\6\15\10\15\10\15\10\15\10\19\10\255\0\
    \\86\3\86\3\86\3\169\1\82\1\82\1\82\1\82\1\82\1\82\1\82\1\82\1\82\1\84\1\82\1\253\12\148\6\148\6\148\6\149\6\243\1\243\1\243\1\243\1\243\1\243\1\244\1\236\3\243\1\245\1\243\1\31\10\148\6\148\6\148\6\148\6\76\0\76\0\76\0\76\0\76\0\76\0\76\0\76\0\81\0\236\3\236\3\73\0\100\4\100\4\
    \\101\4\236\3\106\11\106\11\106\11\236\3\45\8\45\8\126\3\126\3\126\3\126\3\126\3\122\3\246\8\8\11\149\5\149\5\149\5\149\5\149\5\149\5\149\5\149\5\149\5\149\5\100\4\100\4\100\4\100\4\100\4\102\4\100\4\106\4\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\86\3\
    \\86\3\86\3\86\3\86\3\170\1\236\3\86\3\86\3\167\1\164\1\86\3\86\3\86\3\86\3\86\3\170\1\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\255\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\253\5\3\6\236\3\236\3\236\3\236\3\214\5\214\5\
    \\126\4\56\4\214\5\142\12\126\4\126\4\126\4\126\4\69\7\126\4\127\4\144\4\96\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\102\9\105\9\94\1\126\4\126\4\126\4\125\3\126\3\126\3\131\3\125\3\126\3\126\3\131\3\96\1\182\1\181\1\182\1\182\1\182\1\182\1\184\1\
    \\86\3\86\3\86\3\167\1\165\1\165\1\165\1\68\0\127\4\127\4\236\3\136\4\64\2\68\2\64\2\64\2\65\2\64\2\64\2\43\10\64\2\73\2\64\2\73\2\236\3\236\3\236\3\236\3\64\2\64\2\64\2\64\2\64\2\64\2\64\2\64\2\64\2\64\2\64\2\64\2\64\2\64\2\64\2\76\2\145\4\126\4\126\4\126\4\126\4\126\4\
    \\130\4\126\4\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\146\7\126\4\129\4\184\11\236\3\236\3\236\3\236\3\236\3\126\4\126\4\126\4\126\4\126\4\5\3\186\2\186\2\186\2\186\2\190\2\194\2\141\11\141\11\141\11\146\11\154\11\154\11\154\11\154\11\154\11\159\11\34\6\34\6\34\6\36\6\44\6\44\6\44\6\44\6\
    \\48\6\44\6\46\6\236\3\236\3\236\3\236\3\236\3\37\14\37\14\37\14\37\14\37\14\37\14\37\14\37\14\37\14\37\14\45\14\45\14\45\14\45\14\45\14\45\14\60\6\60\6\60\6\62\6\60\6\55\10\65\10\65\10\65\10\65\10\69\10\65\10\65\10\65\10\65\10\69\10\53\14\53\14\53\14\53\14\53\14\236\3\77\10\77\10\77\10\77\10\
    \\77\10\77\10\81\10\193\5\93\10\89\10\93\10\89\10\172\11\93\10\90\10\93\10\90\10\176\11\101\10\101\10\101\10\101\10\101\10\101\10\105\10\236\3\82\6\19\3\21\3\21\3\21\3\21\3\23\3\87\6\95\6\95\6\97\6\95\6\61\14\61\14\61\14\61\14\155\4\155\4\155\4\156\4\5\6\155\4\236\3\236\3\236\3\236\3\236\3\236\3\
    \\192\11\192\11\197\11\189\11\113\10\113\10\113\10\117\10\11\13\11\13\11\13\17\13\27\0\27\0\27\0\33\0\236\3\236\3\236\3\236\3\69\14\69\14\69\14\69\14\113\6\113\6\113\6\109\6\113\6\113\6\111\6\113\6\113\6\113\6\113\6\113\6\182\4\174\4\125\10\177\4\57\1\57\1\59\1\179\8\57\1\64\1\57\1\64\1\77\14\77\14\
    \\77\14\77\14\85\14\85\14\85\14\85\14\236\3\236\3\236\3\236\3\190\4\190\4\190\4\190\4\223\0\220\0\223\0\236\3\72\1\72\1\72\1\72\1\72\1\72\1\74\1\71\1\37\1\37\1\39\1\37\1\205\11\205\11\210\11\205\11\41\0\41\0\47\0\230\0\236\3\40\0\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\10\2\10\2\10\2\10\2\10\2\10\2\10\2\10\2\10\2\17\2\236\3\236\3\236\3\236\3\236\3\236\3\226\11\226\11\226\11\226\11\226\11\226\11\231\11\236\3\226\11\226\11\226\11\226\11\226\11\226\11\231\11\224\11\243\0\243\0\243\0\243\0\243\0\243\0\243\0\243\0\243\0\245\0\27\1\243\0\243\0\243\0\245\0\46\7\239\11\239\11\
    \\239\11\239\11\239\11\239\11\239\11\239\11\187\8\190\8\208\4\208\4\208\4\215\4\208\4\214\4\198\8\198\8\198\8\198\8\198\8\198\8\201\8\198\8\198\8\236\3\224\4\224\4\224\4\224\4\225\4\236\3\101\14\101\14\101\14\101\14\101\14\101\14\101\14\101\14\101\14\101\14\101\14\101\14\219\1\118\0\121\0\236\3\212\8\212\8\209\8\212\8\
    \\212\8\212\8\212\8\212\8\87\13\236\3\236\3\236\3\236\3\236\3\236\3\236\3\8\1\14\1\7\1\9\1\7\1\21\1\252\11\252\11\252\11\252\11\252\11\252\11\252\11\233\4\252\11\234\4\122\2\44\2\41\2\56\2\56\2\125\2\220\8\118\2\44\2\48\2\134\2\136\2\45\2\130\2\130\2\236\3\173\10\179\10\173\10\173\10\173\10\173\10\
    \\175\10\173\10\180\10\169\10\175\10\254\0\252\0\236\3\236\3\236\3\188\10\188\10\188\10\188\10\188\10\188\10\188\10\188\10\188\10\188\10\188\10\192\10\101\13\236\3\236\3\236\3\109\13\109\13\109\13\109\13\109\13\109\13\109\13\109\13\109\13\236\3\109\13\115\13\236\3\236\3\236\3\236\3\234\2\234\2\234\2\234\2\234\2\234\2\234\2\234\2\
    \\237\2\236\3\234\2\240\2\228\3\231\3\236\3\236\3\123\13\123\13\123\13\123\13\123\13\123\13\123\13\129\13\123\13\129\13\148\6\148\6\152\6\236\3\236\3\236\3\231\8\231\8\231\8\9\12\231\8\235\8\231\8\231\8\232\8\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\236\3\200\10\200\10\200\10\200\10\200\10\200\10\200\10\204\10\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\22\12\22\12\22\12\22\12\22\12\22\12\22\12\22\12\22\12\22\12\27\12\52\8\132\6\203\0\135\6\131\6\131\6\131\6\207\0\204\0\132\6\236\3\131\6\140\6\
    \\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\160\6\193\0\160\6\160\6\160\6\160\6\160\6\193\0\196\0\236\3\236\3\236\3\109\14\109\14\109\14\109\14\109\14\109\14\109\14\109\14\109\14\236\3\35\12\35\12\35\12\35\12\35\12\35\12\35\12\35\12\35\12\35\12\40\12\236\3\41\3\41\3\178\6\178\6\178\6\178\6\178\6\178\6\
    \\178\6\185\6\81\11\220\7\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\101\14\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\137\13\137\13\137\13\137\13\143\13\236\3\137\13\143\13\59\3\168\6\59\3\59\3\59\3\59\3\60\3\59\3\61\3\236\3\59\3\59\3\59\3\62\3\193\6\193\6\
    \\193\6\193\6\49\3\193\6\193\6\50\3\51\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\18\9\15\9\34\9\34\9\34\9\34\9\18\9\11\9\34\9\236\3\34\9\23\9\141\1\202\6\139\1\139\1\139\1\140\1\201\6\149\1\139\1\148\1\212\10\212\10\212\10\212\10\212\10\212\6\212\10\214\6\236\3\236\3\226\6\226\6\
    \\224\6\226\6\226\6\226\6\226\6\53\12\226\6\226\6\226\6\231\6\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\5\9\236\3\200\3\200\3\200\3\200\3\200\3\200\3\206\3\235\0\151\13\151\13\151\13\151\13\151\13\151\13\151\13\157\13\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\237\10\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\236\10\241\10\236\3\38\7\38\7\38\7\38\7\38\7\38\7\38\7\38\7\38\7\38\7\38\7\38\7\38\7\43\7\38\7\41\7\38\7\45\7\38\7\34\7\144\4\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\214\5\214\5\214\5\214\5\214\5\216\5\214\5\214\5\215\5\236\3\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\144\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\145\7\145\7\145\7\145\7\145\7\145\7\145\7\145\7\147\7\236\3\
    \\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\126\4\126\4\144\4\236\3\126\4\126\4\144\4\236\3\81\9\191\13\191\13\78\9\185\13\85\9\161\7\161\7\161\7\161\7\161\7\161\7\161\7\135\8\236\3\236\3\236\3\203\9\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\
    \\236\3\236\3\236\3\236\3\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\96\7\99\7\96\7\97\7\236\3\236\3\236\3\236\3\236\3\97\9\102\9\102\9\102\9\201\5\101\9\98\9\128\7\175\12\119\7\201\5\117\7\201\5\98\9\
    \\98\9\123\7\102\9\99\9\102\9\168\12\13\0\99\9\102\9\168\12\236\3\236\3\236\3\236\3\236\3\236\3\19\0\236\3\126\4\126\4\126\4\126\4\126\4\144\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\144\4\236\3\126\4\127\4\94\1\126\4\94\1\126\4\94\1\126\4\126\4\126\4\128\4\236\3\
    \\228\13\236\3\126\4\126\4\126\4\126\4\126\4\144\4\126\4\57\4\56\4\236\3\128\4\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\236\3\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\
    \\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\56\4\126\4\144\4\57\4\236\3\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\236\3\126\4\128\4\126\4\129\4\126\4\131\4\126\4\126\4\126\4\126\4\126\4\126\4\127\4\147\4\126\4\137\4\126\4\145\4\126\4\57\4\126\4\126\4\126\4\126\4\
    \\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\69\7\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\126\4\3\3"#

scriptPlanes0To1Offsets2BitMap :: Ptr Word16
scriptPlanes0To1Offsets2BitMap = Ptr
    "\70\0\187\0\196\0\125\0\214\7\240\7\243\6\130\9\162\9\194\9\226\9\2\10\34\10\66\10\98\10\130\10\162\10\194\10\135\8\165\8\38\3\38\3\54\3\226\10\2\11\34\11\66\11\98\11\130\11\101\0\187\0\155\0\228\8\184\3\86\1\86\1\74\1\86\1\86\1\86\1\162\11\86\1\86\1\65\5\194\11\186\7\197\1\44\1\226\11\247\4\
    \\2\12\21\5\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\46\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\
    \\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\
    \\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\38\0\178\2\178\2\178\2\178\2\193\2\16\8\43\8\242\3\34\12\66\12\98\12\130\12\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\
    \\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\194\10\162\12\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\38\0\
    \\194\12\2\1\12\1\40\7\226\12\2\13\34\13\66\13\122\3\98\13\130\13\162\13\137\6\163\6\194\13\226\13\2\14\34\14\66\14\195\4\215\4\4\9\98\14\130\14\162\14\194\14\226\14\6\3\2\15\34\15\66\15\98\15\130\15\162\15\194\15\226\15\90\4\2\16\229\1\229\1\229\1\242\1\86\3\40\2\6\2\6\2\6\2\6\2\6\2\6\2\
    \\6\2\6\2\6\2\54\2\131\1\131\1\131\1\131\1\119\1\131\1\131\1\131\1\131\1\131\1\131\1\131\1\131\1\131\1\131\1\131\1\131\1\131\1\131\1\132\1\0\6\0\6\24\6\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\
    \\6\2\6\2\6\2\34\16\6\2\6\2\6\2\6\2\6\2\6\2\72\7\72\7\97\7\65\6\6\2\89\6\211\6\67\9\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\66\16\0\0\6\0\98\16\6\2\6\2\
    \\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\8\2\75\8\86\2\100\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\130\16\6\2\6\2\6\2\6\2\6\2\
    \\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\6\2\87\1\86\1\80\5\162\16\204\3\226\0\194\16\154\7\134\5\164\1\176\1\54\5\225\2\225\2\240\2\6\2\6\2\6\2\6\2\17\4\226\16\132\2\146\2\6\2\163\4\224\5\33\6\105\6\2\17\49\4\6\2\6\2\67\4\122\4\34\17\6\2\66\17\213\3\98\17\86\1\
    \\86\1\86\1\159\5\130\17\152\3\86\1\162\17\194\17"#


