/*
 * Decompiled with CFR 0.152.
 */
package nanolog;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class NanoLog
extends JFrame {
    private static final String VERSION = "1.2";
    private static final String AUTOSAVE_FILE = "autosave-%s.nanolog";
    private static final String SHORTCUTS_FILE = "nanolog.shortcuts";
    private static final int WAIT_UNTIL_TIMER_RESET = 5000;
    private static final int SHIFT_MODIFIER = 131072;
    private JTextArea logArea;
    private JTextField inputArea;
    private ClockUpdater clock;
    private JList shortcutList;
    private ShortcutListModel shortcutModel;
    private Map<Integer, String> shortcuts;
    private File saveFile;
    private Writer autosave;
    boolean changedSaveName;
    private long fixedTime = 0L;
    private final EmptyDocumentTimer inputTimer = new EmptyDocumentTimer();
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SS");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private static final Date tmpDate = new Date();

    public NanoLog() {
        super("NanoLog 1.2");
        this.loadIcon();
        this.loadShortcuts();
        this.setContentPane(this.createGUI());
        this.pack();
        this.resetAutosaveName();
        this.loadAutosave();
        this.initAutosave(true);
    }

    private void resetAutosaveName() {
        this.saveFile = new File(String.format(AUTOSAVE_FILE, new SimpleDateFormat("yyMMdd").format(new Date())));
        this.changedSaveName = false;
    }

    private JPanel createGUI() {
        this.logArea = new JTextArea();
        this.logArea.setEditable(false);
        this.logArea.setFocusable(false);
        JScrollPane logScroller = new JScrollPane(this.logArea, 20, 31);
        logScroller.setMinimumSize(new Dimension(200, 100));
        this.shortcutModel = new ShortcutListModel();
        this.shortcutList = new JList<String>(this.shortcutModel);
        this.shortcutList.setSelectionMode(0);
        this.shortcutList.setFocusable(false);
        this.shortcutList.addMouseListener(new ShortcutListMouseListener());
        this.shortcutList.setMinimumSize(new Dimension(200, 100));
        JLabel clockLabel = new JLabel("00:00:00.00");
        clockLabel.setBorder(new EmptyBorder(2, 8, 4, 8));
        this.clock = new ClockUpdater(clockLabel);
        new Thread(this.clock).start();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NanoLog.this.clock.stop();
                NanoLog.this.inputTimer.interrupt();
                if (NanoLog.this.autosave != null) {
                    try {
                        NanoLog.this.autosave.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.inputArea = new JTextField();
        Toolkit.getDefaultToolkit().addAWTEventListener(new CtrlKeyListener(), 8L);
        this.inputArea.getDocument().addDocumentListener(new InputDocumentListener());
        this.inputTimer.start();
        JPanel content = new JPanel(new BorderLayout());
        JPanel bottomRow = new JPanel(new BorderLayout());
        JSplitPane splitter = new JSplitPane(1, logScroller, this.shortcutList);
        splitter.setResizeWeight(1.0);
        bottomRow.add((Component)clockLabel, "West");
        bottomRow.add((Component)this.inputArea, "Center");
        content.add((Component)splitter, "Center");
        content.add((Component)bottomRow, "South");
        content.setMinimumSize(new Dimension(400, 300));
        content.setPreferredSize(new Dimension(600, 500));
        return content;
    }

    private void loadIcon() {
        try {
            URL url = this.getClass().getResource("nanolog.png");
            Toolkit kit = Toolkit.getDefaultToolkit();
            Image img = kit.createImage(url);
            this.setIconImage(img);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadShortcuts() {
        this.shortcuts = new TreeMap<Integer, String>();
        File shortcutsFile = new File(SHORTCUTS_FILE);
        try {
            InputStream sis = shortcutsFile.canRead() ? new FileInputStream(shortcutsFile) : this.getClass().getResourceAsStream(SHORTCUTS_FILE);
            if (sis != null) {
                String line;
                Pattern shortcutPattern = Pattern.compile("(\\d+)\\s*=\\s*(.+)");
                BufferedReader r = new BufferedReader(new InputStreamReader(sis, "UTF8"));
                while (r.ready() && (line = r.readLine()) != null) {
                    Matcher matcher = shortcutPattern.matcher(line);
                    if (!matcher.matches()) continue;
                    int code = Integer.parseInt(matcher.group(1));
                    if (code <= 12) {
                        code += 111;
                        if (matcher.group(1).equals("S")) {
                            code += 131072;
                        }
                    }
                    this.shortcuts.put(code, matcher.group(2));
                }
                r.close();
                sis.close();
            } else {
                this.shortcuts.put(112, "Mark");
                this.shortcuts.put(113, "Milestone");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveShortcuts() {
        File shortcutsFile = new File(SHORTCUTS_FILE);
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(shortcutsFile), "UTF8"));
            for (Integer code : this.shortcuts.keySet()) {
                String value = this.shortcuts.get(code);
                if (value == null || value.isEmpty()) continue;
                w.append(String.valueOf(code)).append('=').append(value);
                w.newLine();
            }
            w.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadAutosave() {
        this.logArea.setText("");
        if (this.saveFile.canRead()) {
            try {
                InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(this.saveFile), "UTF8");
                this.logArea.read(r, null);
                this.logArea.setCaretPosition(this.logArea.getDocument().getLength());
                ((Reader)r).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initAutosave(boolean append) {
        this.autosave = null;
        try {
            this.autosave = new OutputStreamWriter((OutputStream)new FileOutputStream(this.saveFile, append), "UTF8");
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.getRootPane(), "Could not open " + this.saveFile.getName() + " for writing, autosave is disabled.", "NanoLog", 0);
        }
    }

    private void moveAutosave(File newFile) {
        boolean append = false;
        if (newFile.exists() && newFile.canWrite() && newFile.length() > 0L) {
            int result = JOptionPane.showConfirmDialog(this.getRootPane(), "File " + newFile.getName() + " exists, append log to it instead of overwriting?", "NanoLog", 1);
            if (result == 2) {
                return;
            }
            append = result == 0;
        }
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile, append), "UTF8");
            this.logArea.write(w);
            ((Writer)w).close();
            this.autosave.close();
            try {
                this.saveFile.delete();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.saveFile = newFile;
            this.changedSaveName = true;
            if (append) {
                this.loadAutosave();
            }
            this.initAutosave(true);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.getRootPane(), "Failed to save log into " + newFile.getName(), "NanoLog", 0);
        }
    }

    private void stopClock(boolean stop) {
        this.fixedTime = stop ? System.currentTimeMillis() : 0L;
    }

    private boolean isClockStopped() {
        return this.fixedTime > 0L;
    }

    private String formatTime(long time) {
        tmpDate.setTime(time);
        String s = timeFormat.format(tmpDate);
        if (s.lastIndexOf(46) == s.length() - 4) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String formatDate(long time) {
        tmpDate.setTime(time);
        return dateFormat.format(tmpDate);
    }

    private void appendLog(long time, String text) {
        if (time <= 0L) {
            time = System.currentTimeMillis();
        }
        if ((text = text.trim()).isEmpty()) {
            return;
        }
        String line = this.formatDate(time) + " " + this.formatTime(time) + "\t" + text + "\n";
        this.logArea.append(line);
        this.logArea.setCaretPosition(this.logArea.getDocument().getLength());
        if (this.autosave != null) {
            try {
                this.autosave.append(line);
                this.autosave.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void appendLog() {
        this.appendLog(this.fixedTime, this.inputArea.getText());
        this.inputArea.setText("");
        this.stopClock(false);
    }

    private void clearLog() {
        if (JOptionPane.showConfirmDialog(this.getRootPane(), this.changedSaveName ? "Start the new log?" : "Clear the current log? It will all be lost, EVERYTHING!", "NanoLog", 0, 3) == 0) {
            this.logArea.setText("");
            if (this.autosave != null) {
                try {
                    this.autosave.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.resetAutosaveName();
                this.initAutosave(false);
            }
        }
    }

    private void editShortcut(int code) {
        StringBuilder result = new StringBuilder();
        if (code > 131072) {
            result.append("Shift-");
        }
        result.append(KeyEvent.getKeyText(code > 131072 ? code - 131072 : code));
        String initial = this.shortcuts.containsKey(code) ? this.shortcuts.get(code) : "";
        String message = JOptionPane.showInputDialog(this.getRootPane(), "Enter a string for " + result.toString() + " shortcut:", initial);
        this.shortcutModel.setShift(false);
        if (message != null) {
            if (message.isEmpty()) {
                message = null;
            }
            this.shortcuts.put(code, message);
            this.saveShortcuts();
            this.shortcutModel.shortcutWasUpdated();
        }
    }

    public static void main(String[] args) {
        NanoLog frame = new NanoLog();
        frame.setDefaultCloseOperation(2);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    private class ShortcutListMouseListener
    extends MouseAdapter {
        private ShortcutListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int pos;
            if (e.getButton() == 1 && (pos = NanoLog.this.shortcutList.locationToIndex(e.getPoint())) >= 0 && pos < 12) {
                int code = NanoLog.this.shortcutModel.getKeyCodeAt(pos, e.isShiftDown());
                NanoLog.this.editShortcut(code);
            }
        }
    }

    private class ShortcutListModel
    extends AbstractListModel<String> {
        private boolean isShift = false;

        private ShortcutListModel() {
        }

        public void setShift(boolean shift) {
            if (this.isShift != shift) {
                this.isShift = shift;
                this.fireContentsChanged(this, 0, 11);
            }
        }

        @Override
        public int getSize() {
            return 12;
        }

        @Override
        public String getElementAt(int index) {
            int code = this.getKeyCodeAt(index, this.isShift);
            String shortcut = NanoLog.this.shortcuts.containsKey(code) ? (String)NanoLog.this.shortcuts.get(code) : "";
            StringBuilder result = new StringBuilder();
            result.append(this.isShift ? (char)'S' : 'F');
            result.append(index + 1);
            if (shortcut != null) {
                result.append(": ").append(shortcut);
            }
            return result.toString();
        }

        public int getKeyCodeAt(int index, boolean shift) {
            return index + 112 + (shift ? 131072 : 0);
        }

        public void shortcutWasUpdated() {
            this.fireContentsChanged(this, 0, 11);
        }
    }

    private class EmptyDocumentTimer
    extends Thread {
        private EmptyDocumentTimer() {
        }

        @Override
        public void run() {
            long whenReset = 0L;
            try {
                while (!EmptyDocumentTimer.interrupted()) {
                    Thread.sleep(500L);
                    if (NanoLog.this.isClockStopped() && NanoLog.this.inputArea.getDocument().getLength() == 0) {
                        if (whenReset == 0L) {
                            whenReset = System.currentTimeMillis() + 5000L;
                        }
                    } else if (whenReset > 0L) {
                        whenReset = 0L;
                    }
                    if (whenReset <= 0L || System.currentTimeMillis() < whenReset) continue;
                    NanoLog.this.stopClock(false);
                    whenReset = 0L;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class InputDocumentListener
    implements DocumentListener {
        private boolean wasEmpty = true;

        private InputDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.documentUpdated(e.getDocument());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.documentUpdated(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.documentUpdated(e.getDocument());
        }

        private void documentUpdated(Document doc) {
            boolean isEmpty;
            boolean bl = isEmpty = doc.getLength() == 0;
            if (this.wasEmpty && !isEmpty && !NanoLog.this.isClockStopped()) {
                NanoLog.this.stopClock(true);
            }
            this.wasEmpty = isEmpty;
        }
    }

    private class Sound {
        private static final float SAMPLE_RATE = 8000.0f;
        private SourceDataLine sdl;
        private TargetDataLine audioLine;

        public Sound() {
            AudioFormat af;
            try {
                af = new AudioFormat(8000.0f, 8, 1, true, false);
                this.sdl = AudioSystem.getSourceDataLine(af);
                this.sdl.open(af);
            }
            catch (LineUnavailableException e) {
                System.err.println("Could not open beeping device: " + e.getMessage());
                this.sdl = null;
            }
            try {
                af = new AudioFormat(11025.0f, 16, 1, true, true);
                this.audioLine = AudioSystem.getTargetDataLine(af);
            }
            catch (LineUnavailableException e) {
                System.err.println("Could not open microphone line: " + e.getMessage());
                this.audioLine = null;
            }
        }

        public void destroy() {
            if (this.sdl != null) {
                this.sdl.close();
            }
            this.stopRecording();
        }

        public void beep(int hz) {
            if (this.sdl != null) {
                new Thread(new Beeper(hz)).start();
            }
        }

        public String startRecording() {
            if (this.audioLine == null || this.isRecording()) {
                return null;
            }
            try {
                String fileName = "record-" + new SimpleDateFormat("yyMMdd-HHmmss").format(new Date()) + ".wav";
                this.audioLine.open();
                this.audioLine.start();
                new Thread(new Recorder(fileName)).start();
                return fileName;
            }
            catch (LineUnavailableException e) {
                return null;
            }
        }

        public void stopRecording() {
            if (this.isRecording()) {
                this.audioLine.flush();
                this.audioLine.stop();
                this.audioLine.close();
            }
        }

        public boolean isRecording() {
            return this.audioLine != null && this.audioLine.isRunning();
        }

        private class Recorder
        implements Runnable {
            private final String fileName;

            public Recorder(String fileName) {
                this.fileName = fileName;
            }

            @Override
            public void run() {
                AudioInputStream stream = new AudioInputStream(Sound.this.audioLine);
                try {
                    AudioSystem.write(stream, AudioFileFormat.Type.WAVE, new File(this.fileName));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private class Beeper
        implements Runnable {
            private final int hz;

            public Beeper(int hz) {
                this.hz = hz;
            }

            @Override
            public void run() {
                byte[] buf = new byte[1];
                Sound.this.sdl.start();
                for (int i = 0; i < 800; ++i) {
                    double angle = (double)((float)i / (8000.0f / (float)this.hz)) * 2.0 * Math.PI;
                    buf[0] = (byte)(Math.sin(angle) * 127.0);
                    Sound.this.sdl.write(buf, 0, 1);
                }
                Sound.this.sdl.drain();
                Sound.this.sdl.flush();
                Sound.this.sdl.stop();
            }
        }
    }

    private class CtrlKeyListener
    implements KeyListener,
    AWTEventListener {
        private static final int DELAY = 1500;
        private static final int AUDIO_MARKER_DELAY = 700;
        private final Sound sound;
        private AudioMarkerAction audioMarker;
        private final Map<Integer, ReleaseAction> codes;

        private CtrlKeyListener() {
            this.sound = new Sound();
            this.codes = new TreeMap<Integer, ReleaseAction>();
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            if (!(e instanceof KeyEvent)) {
                return;
            }
            KeyEvent ke = (KeyEvent)e;
            if (ke.isConsumed()) {
                return;
            }
            if (ke.getID() == 402) {
                ReleaseAction action = new ReleaseAction(ke);
                Timer timer = new Timer(2, action);
                this.codes.put(ke.getKeyCode(), action);
                timer.setRepeats(false);
                timer.start();
            } else if (ke.getID() == 401) {
                ReleaseAction action = this.codes.remove(ke.getKeyCode());
                if (action != null) {
                    action.cancel();
                }
                this.keyPressed(ke);
            }
        }

        private void useShortcut(KeyEvent e) {
            int pos = this.mapNumLockCode(e);
            if (pos <= 0) {
                return;
            }
            if (e.isShiftDown()) {
                pos += 131072;
            }
            if (e.isControlDown()) {
                NanoLog.this.editShortcut(pos);
            } else if (NanoLog.this.shortcuts.containsKey(pos)) {
                NanoLog.this.appendLog(0L, (String)NanoLog.this.shortcuts.get(pos));
                this.sound.beep(1000);
            } else {
                NanoLog.this.appendLog(0L, KeyEvent.getKeyText(pos));
            }
        }

        private int mapNumLockCode(KeyEvent e) {
            if (e.getKeyLocation() != 4) {
                return e.getKeyCode();
            }
            int code = e.getKeyCode();
            if (code == 144) {
                code = 0;
            } else if (code == 127) {
                code = 110;
            } else if (code == 155) {
                code = 96;
            } else if (code == 35) {
                code = 97;
            } else if (code == 225) {
                code = 98;
            } else if (code == 34) {
                code = 99;
            } else if (code == 226) {
                code = 100;
            } else if (code == 65368) {
                code = 101;
            } else if (code == 227) {
                code = 102;
            } else if (code == 36) {
                code = 103;
            } else if (code == 224) {
                code = 104;
            } else if (code == 33) {
                code = 105;
            }
            return code;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JFileChooser fc;
            boolean isTextFieldEmpty;
            boolean bl = isTextFieldEmpty = NanoLog.this.inputArea.getText().length() == 0;
            if (e.getKeyCode() == 16) {
                NanoLog.this.shortcutModel.setShift(true);
            } else if (e.getKeyCode() == 17) {
                NanoLog.this.stopClock(true);
            } else if (e.getKeyCode() == 27) {
                if (NanoLog.this.isClockStopped()) {
                    NanoLog.this.stopClock(false);
                } else if (!isTextFieldEmpty) {
                    NanoLog.this.inputArea.setText("");
                }
            } else if (e.getKeyCode() >= 112 && e.getKeyCode() <= 123) {
                this.useShortcut(e);
            } else if (e.getKeyLocation() == 4) {
                if (this.audioMarker != null) {
                    this.audioMarker.cancel();
                } else if (!this.sound.isRecording()) {
                    String fileName = this.sound.startRecording();
                    NanoLog.this.appendLog(0L, "Audio: " + fileName);
                }
            } else if (e.getKeyCode() == 10) {
                if (!isTextFieldEmpty) {
                    NanoLog.this.appendLog();
                }
            } else if (e.getKeyCode() == 78 && e.isControlDown()) {
                NanoLog.this.clearLog();
            } else if (e.getKeyCode() == 83 && e.isControlDown() && (fc = new JFileChooser(".")).showSaveDialog(NanoLog.this.getRootPane()) == 0) {
                NanoLog.this.moveAutosave(fc.getSelectedFile());
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 16) {
                NanoLog.this.shortcutModel.setShift(false);
            } else if (e.getKeyLocation() == 4 && this.sound.isRecording()) {
                this.audioMarker = new AudioMarkerAction();
                Timer timer = new Timer(700, this.audioMarker);
                timer.setRepeats(false);
                timer.start();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private class AudioMarkerAction
        implements ActionListener {
            private long markerTime = System.currentTimeMillis();

            private AudioMarkerAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (this.markerTime > 0L) {
                    CtrlKeyListener.this.sound.stopRecording();
                    NanoLog.this.appendLog(this.markerTime, "Audio stopped");
                }
                CtrlKeyListener.this.audioMarker = null;
            }

            public void cancel() {
                NanoLog.this.appendLog(this.markerTime, "Audio marker");
                CtrlKeyListener.this.sound.beep(1000);
                this.markerTime = 0L;
                CtrlKeyListener.this.audioMarker = null;
            }
        }

        private class ReleaseAction
        implements ActionListener {
            private KeyEvent event;

            public ReleaseAction(KeyEvent event) {
                this.event = event;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (this.event != null) {
                    CtrlKeyListener.this.keyReleased(this.event);
                    this.cancel();
                }
            }

            public void cancel() {
                CtrlKeyListener.this.codes.remove(this.event.getKeyCode());
                this.event = null;
            }
        }
    }

    private class ClockUpdater
    implements Runnable {
        private boolean stopping = false;
        private final JLabel clock;

        public ClockUpdater(JLabel clock) {
            this.clock = clock;
            this.setTime(System.currentTimeMillis());
        }

        public void stop() {
            this.stopping = true;
        }

        @Override
        public void run() {
            while (!this.stopping) {
                if (this.clock != null) {
                    if (NanoLog.this.fixedTime > 0L) {
                        this.setTime(NanoLog.this.fixedTime);
                        if (this.clock.getForeground() != Color.blue) {
                            this.clock.setForeground(Color.blue);
                        }
                    } else {
                        this.setTime(System.currentTimeMillis());
                        if (this.clock.getForeground() != Color.black) {
                            this.clock.setForeground(Color.black);
                        }
                    }
                }
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void setTime(long time) {
            this.clock.setText(NanoLog.this.formatTime(time));
        }
    }
}

