<?php
/**
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Google\Cloud\Samples\AppEngine\Flexible\WordPress;

use PHPUnit\Framework\TestCase;

class wordpressTest extends TestCase
{
    use RunSetupCommandTrait;

    public function testSetup()
    {
        // these variables aren't actually taken into account, as we are just
        // testing the files get generated appropriately.
        $projectId = 'test-project-id';
        $dbPassword = 'test-db-password';
        $dir = $this->runSetupCommand([
            '--project_id' => $projectId,
            '--db_password' => $dbPassword,
        ]);

        $this->assertTrue(is_dir($dir));
        $files = ['composer.json', 'app.yaml', 'wordpress/wp-config.php'];
        foreach ($files as $file) {
            $this->assertFileExists($dir . '/' . $file);
        }
        // check the syntax of the rendered PHP file
        passthru(sprintf('php -l %s/wordpress/wp-config.php', $dir), $ret);
        $this->assertEquals(0, $ret);

        // check naively that variables were added
        $wpConfig = file_get_contents($dir . '/wordpress/wp-config.php');
        $this->assertStringContainsString($projectId, $wpConfig);
        $this->assertStringContainsString($dbPassword, $wpConfig);
    }
}
