<?php
/**
 * Copyright 2021 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * For instructions on how to run the full sample:
 *
 * @see https://github.com/GoogleCloudPlatform/php-docs-samples/tree/main/compute/cloud-client/README.md
 */

namespace Google\Cloud\Samples\Compute;

# [START compute_instances_list_all]
use Google\Cloud\Compute\V1\AggregatedListInstancesRequest;
use Google\Cloud\Compute\V1\Client\InstancesClient;

/**
 * List all instances for a particular Cloud project.
 *
 * @param string $projectId Your Google Cloud project ID.
 *
 * @throws \Google\ApiCore\ApiException if the remote call fails.
 */
function list_all_instances(string $projectId)
{
    // List Compute Engine instances using InstancesClient.
    $instancesClient = new InstancesClient();
    $request = (new AggregatedListInstancesRequest())
        ->setProject($projectId);
    $allInstances = $instancesClient->aggregatedList($request);

    printf('All instances for %s' . PHP_EOL, $projectId);
    foreach ($allInstances as $zone => $zoneInstances) {
        $instances = $zoneInstances->getInstances();
        if (count($instances) > 0) {
            printf('Zone - %s' . PHP_EOL, $zone);
            foreach ($instances as $instance) {
                printf(' - %s' . PHP_EOL, $instance->getName());
            }
        }
    }
}
# [END compute_instances_list_all]

require_once __DIR__ . '/../../../testing/sample_helpers.php';
\Google\Cloud\Samples\execute_sample(__FILE__, __NAMESPACE__, $argv);
