# Cloud Datastore sample application

This code sample is intended to be in the following document:
https://cloud.google.com/datastore/docs/datastore-api-tutorial

The code is using the
[Datastore Client Library for PHP](https://cloud.google.com/php/docs/reference/cloud-datastore/latest).

To run the sample, do the following first:

1. [Enable billing](https://support.google.com/cloud/answer/6293499#enable-billing).
1. [Enable the Cloud Datastore API](https://console.cloud.google.com/flows/enableapi?apiid=datastore.googleapis.com).
1. **Install dependencies** via [Composer](http://getcomposer.org/doc/00-intro.md).
    Run `php composer.phar install` (if composer is installed locally) or `composer install`
    (if composer is installed globally).

Then use one of the following methods:

1. Run `gcloud auth application-default login`

or

1. Create a service account at the
[Service account section in the Cloud Console](https://console.cloud.google.com/iam-admin/serviceaccounts/)
1. Download the json key file of the service account.
1. Set GOOGLE_APPLICATION_CREDENTIALS environment variable pointing to that file.

Then you can run the code samples:

1.  Execute the snippets in the [src/](src/) directory by running:

    ```text
    $ php src/SNIPPET_NAME.php
    ```

    The usage will print for each if no arguments are provided.
