<!---
  category: DevicesSensorsAndPower
  samplefwlink: http://go.microsoft.com/fwlink/p/?LinkId=619990
--->

# Bluetooth advertisement sample

This sample demonstrates use of the [**Bluetooth Advertisement**](https://msdn.microsoft.com/en-us/library/windows/apps/xaml/windows.devices.bluetooth.advertisement.aspx) Runtime API to send and receive Bluetooth Low Energy advertisements.

This sample allows the user to publish and watch for Bluetooth Low Energy advertisements.  You can choose one of four scenarios and you will likely need two Windows devices to see :
- **Foreground watcher**: Scanning for a particular LE advertisement containing a matching manufacturer data section and above a certain RSSI threshold.
- **Foregound publisher**: Publishing a LE advertisement. The advertisement generated by this scenario can be received by running Scenario 1 or 3 on another Windows platform in close proximity with this one.
- **Background watcher**: Scanning for a particular LE advertisement containing a matching manufacturer data section and above a certain RSSI threshold using a background trigger and task. 
- **Background publisher**: Publishing a LE advertisement in the background. The advertisement generated by this scenario can be received by running Scenario 1 or 3 on another Windows platform in close proximity with this one.

**Note:** A working Bluetooth dongle/radio is needed in order to test this sample's functionality.  The VS Emulator is a valid target, but since there's technically no valid Bluetooth, the app will treat it as if there's no Bluetooth radio and beacon functionality cannot be used.  

## System requirements

**Client:** Windows 10

**Server:** Windows Server 2016 Technical Preview

**Phone:** Windows 10

## Build the sample

1. If you download the samples ZIP, be sure to unzip the entire archive, not just the folder with the sample you want to build. 
2. Start Microsoft Visual Studio 2015 and select **File** \> **Open** \> **Project/Solution**.
3. Starting in the folder where you unzipped the samples, go to the Samples subfolder, then the subfolder for this specific sample, then the subfolder for your preferred language (C++, C#, or JavaScript). Double-click the Visual Studio 2015 Solution (.sln) file.
4. Press Ctrl+Shift+B, or select **Build** \> **Build Solution**.

## Run the sample

The next steps depend on whether you just want to deploy the sample or you want to both deploy and run it.

### Deploying the sample

- Select Build > Deploy Solution. 

### Deploying and running the sample

- To debug the sample and then run it, press F5 or select Debug >  Start Debugging. To run the sample without debugging, press Ctrl+F5 or selectDebug > Start Without Debugging. 

