<!---
  category: CustomUserInteractions
  samplefwlink: http://go.microsoft.com/fwlink/p/?LinkId=620522
--->

# Complex inking sample

This sample demonstrates how to use advanced InkPresenter functionality to achieve scenarios such as interleaving ink with other objects, selecting ink, copy/paste, and event handling.  It is built upon the Universal Windows Platform (UWP) in C++ and can run on both Desktop and Mobile Windows 10 SKUs.

Specifically, this sample covers using the [**Windows.UI.Input.Inking**](http://msdn.microsoft.com/library/windows/apps/br208524) APIs to:
-   Render ink strokes onto app specified VSIS surface
-   Erase ink strokes via mode toggle or eraser button
-   Select ink strokes via mode toggle or barrel button drag

**Note**  Read the following instructions before using the app.

-   Draw ink strokes with a tablet pen, or with finger when Touch Inking Mode is enabled.  Mouse can not be used to ink in this sample.
-   Activate the selection mode by hold the pen barrel button and drag on inking surface.  Alternatively, checking the Selection Mode combobox.
-   Press Clear button to erase all content from the inking area.
-   Press Insert Shape to insert random geometric shape on top of existing ink.  Ink can interleave on top of existing shapes.
-   Touch inking mode can be toggled with Enable Touch Inking checkbox.  When touch inking is enabled, both pen and finger can ink.
-   With touch inking disabled, pen can ink while finger manipulates the inking surface.
-   All buttons and menu choices can be activated with mouse, pen, or touch.
-   Message box at the bottom of the page will report any events generated by current active inking input devices.

To obtain information about Windows 10 development, go to the [Windows Dev Center](https://dev.windows.com)

To obtain information about Microsoft Visual Studio 2015 and the tools for developing Windows apps, go to [Visual Studio 2015](http://go.microsoft.com/fwlink/?LinkID=532422)

## Related topics
--------------

[Getting started with apps](http://msdn.microsoft.com/library/windows/apps/)

## Reference

[**Windows.UI.Input.Inking**](http://msdn.microsoft.com/library/windows/apps/br208524)

## Operating system requirements
-----------------------------

**Client:** Windows 10

**Phone:** Windows 10

## Build the sample
----------------

1. If you download the samples ZIP, be sure to unzip the entire archive, not just the folder with the sample you want to build. 
2. Start Microsoft Visual Studio 2015 and select **File** \> **Open** \> **Project/Solution**.
3. Starting in the folder where you unzipped the samples, go to the Samples subfolder, then the subfolder for this specific sample, then the subfolder for your preferred language (C++, C#, or JavaScript). Double-click the Visual Studio 2015 Solution (.sln) file.
4. Press Ctrl+Shift+B, or select **Build** \> **Build Solution**.

## Run the sample
--------------
To debug the app and then run it, press F5 or use **Debug** \> **Start Debugging**. To run the app without debugging, press Ctrl+F5 or use **Debug** \> **Start Without Debugging**.


