<!---
  category: CustomUserInteractions
  samplefwlink: http://go.microsoft.com/fwlink/p/?LinkId=620602
--->

# Simple inking sample

This sample demonstrates how to use ink functionality (such as capturing ink from user input and performing handwriting recognition on ink strokes) in Universal Windows apps using C#.

Specifically, this sample covers using the Windows.UI.Input.Inking APIs to do the following:
-   Capture user input and render as ink strokes
-   Save and load ink strokes
-   Erase ink strokes
-   Change which input types (Mouse/Touch/Pen) are used for inking 
-   Recognize handwriting from ink strokes 
-   Select ink strokes 

## Related topics

**Samples**

[ComplexInk](/Samples/ComplexInk)

**Reference**

[**Windows.UI.Input.Inking**](http://msdn.microsoft.com/library/windows/apps/br208524)

## Operating system requirements

**Client:** Windows 10

**Server:** Windows Server 2016 Technical Preview

**Phone:** Windows 10

## Build the sample

1. If you download the samples ZIP, be sure to unzip the entire archive, not just the folder with the sample you want to build. 
2. Start Microsoft Visual Studio 2015 and select **File** \> **Open** \> **Project/Solution**.
3. Starting in the folder where you unzipped the samples, go to the Samples subfolder, then the subfolder for this specific sample, then the subfolder for your preferred language (C++, C#, or JavaScript). Double-click the Visual Studio 2015 Solution (.sln) file.
4. Press Ctrl+Shift+B, or select **Build** \> **Build Solution**.

## Run the sample

The next steps depend on whether you just want to deploy the sample or you want to both deploy and run it.

### Deploying the sample

- Select Build > Deploy Solution. 

### Deploying and running the sample

- To debug the sample and then run it, press F5 or select Debug >  Start Debugging. To run the sample without debugging, press Ctrl+F5 or selectDebug > Start Without Debugging. 

