﻿using System;
using Windows.Security.Cryptography.Core;
using Windows.Storage.Streams;

namespace Smartcard
{
    static class ChallengeResponseAlgorithm
    {
        /// <summary>
        /// Calculates the response by encrypting the challenge by using Triple DES (3DES).
        /// If the resulting values are the same, the authentication is successful.
        /// </summary>
        /// <param name="challenge">a block of challenge data generated by smart card using its admin key</param>
        /// <param name="adminkey">the admin key of the smart card, which is normally saved on the server side or management tool.</param>
        /// <returns>the response</returns>
        public static IBuffer CalculateResponse(IBuffer challenge, IBuffer adminkey)
        {
            if (challenge == null)
            {
                throw new ArgumentNullException("challenge");
            }
            if (adminkey == null)
            {
                throw new ArgumentNullException("adminkey");
            }

            SymmetricKeyAlgorithmProvider objAlg = SymmetricKeyAlgorithmProvider.OpenAlgorithm(SymmetricAlgorithmNames.TripleDesCbc);
            var symmetricKey = objAlg.CreateSymmetricKey(adminkey);
            var buffEncrypted = CryptographicEngine.Encrypt(symmetricKey, challenge, null);
            return buffEncrypted;
        }
    }
}