unit gossdat;
//## ==========================================================================================================================================================================================================================
//##
//## MIT License
//##
//## Copyright 2025 Blaiz Enterprises ( http://www.blaizenterprises.com )
//##
//## Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
//## files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
//## modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
//## is furnished to do so, subject to the following conditions:
//##
//## The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//##
//## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
//## OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//## LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//## CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//##
//## ==========================================================================================================================================================================================================================
//## Library.................. static data (gossdat.pas)
//## Version.................. -
//## Items.................... -
//## Last Updated ............ 03jul2025
//## Lines of Code............ -
//##
//## main.pas ................ app code
//## gossroot.pas ............ console/gui app startup and control
//## gossio.pas .............. file io
//## gossimg.pas ............. image/graphics
//## gossnet.pas ............. network
//## gosswin.pas ............. static Win32 api calls
//## gosswin2.pas ............ dynamic Win32 api calls
//## gosssnd.pas ............. sound/audio/midi/chimes
//## gossgui.pas ............. gui management/controls
//## gossdat.pas ............. app icons (24px and 20px) and help documents (gui only) in txt, bwd or bwp format
//## gosszip.pas ............. zip support
//## gossjpg.pas ............. jpeg support
//## gossgame.pas ............ game support (optional)
//## gamefiles.pas ........... internal files for game (optional)
//##
//## ==========================================================================================================================================================================================================================
//## Important Format(s) Note:
//##
//## Many of the images and documents used below require a specific file format and storage in a binary pascal array in order to work.  A free gui tool
//## is available at http://www.blaizenterprises.com/blaiztools.html  The tool provides one button actions for pasting and converting images into
//## TEA/JPEG/PNG image formats, and packing them into a pascal array, as well as support for loading, compressing and packing text documents into
//## pascal arrays.
//## ==========================================================================================================================================================================================================================
//## Performance Note:
//##
//## The runtime compiler options "Range Checking" and "Overflow Checking", when enabled under Delphi 3
//## (Project > Options > Complier > Runtime Errors) slow down graphics calculations by about 50%,
//## causing ~2x more CPU to be consumed.  For optimal performance, these options should be disabled
//## when compiling.
//## ==========================================================================================================================================================================================================================

interface

uses
   gossroot;

const
//program icons ----------------------------------------------------------------
//app icon (required) - 24w x 24h size in TEA format only, accessed via tepIcon24
//Note: This icon is used by Gossamer internally for display on the app's Window Header (Title bar) and must be in the TEA (text picture) format.
//      A separate MS icon (.ico) is required for display on Windows Desktop/Explorer/Taskbar etc, currently stored within the resource file
//      "<app name>-256.res"
program_icon24h
:array[0..1851] of byte=(
84,69,65,51,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,2,1,0,0,0,1,4,0,0,0,1,37,0,0,0,1,95,1,0,1,1,154,24,9,37,1,202,37,14,57,1,231,36,12,56,1,247,35,12,55,6,250,36,12,56,1,247,37,13,58,1,231,40,15,62,1,202,47,18,71,1,154,59,25,89,1,95,75,29,112,1,37,73,24,110,1,4,0,0,0,1,1,2,1,4,1,1,0,0,0,1,1,0,0,0,1,6,0,0,0,1,83,0,0,0,1,197,0,0,0,1,243,2,0,3,1,252,53,23,74,1,252,83,35,117,1,251,83,34,118,8,250,83,34,118,1,251,83,34,118,2,252,84,35,120,1,243,88,36,124,1,197,92,40,125,1,83,93,41,122,1,6,0,0,0,1,1,0,0,0,1,4,0,0,0,1,83,0,0,0,1,219,0,0,0,2,250,2,1,3,1,250,65,34,79,1,250,101,54,124,1,250,102,54,125,13,250,103,55,125,1,219,102,57,120,1,83,59,42,65,1,4,0,0,0,1,37,0,0,0,1,197,0,0,0,3,250,3,1,3,1,250,75,48,79,1,250,117,75,124,1,250,118,75,125,14,250,100,64,106,1,197,45,32,48,1,37,0,0,0,1,95,0,0,0,1,243,0,0,0,3,250,4,2,3,1,250,85,61,79,1,250,133,95,124,1,250,134,96,125,1,250,133,95,124,1,250,130,92,122,1,250,129,92,122,7,250,130,92,122,1,250,133,95,124,1,250,134,96,125,2,250,
104,74,97,1,243,31,23,29,1,95,0,0,0,1,154,0,0,0,1,252,0,0,0,3,250,5,3,3,1,250,95,74,79,1,250,149,116,124,1,250,150,116,125,1,250,136,106,114,1,250,81,61,71,1,250,73,52,65,7,250,79,58,69,1,250,129,100,108,1,250,150,117,125,2,250,114,89,95,1,252,25,20,21,1,154,0,0,0,1,202,0,0,0,1,252,0,0,0,3,250,6,4,3,1,250,105,87,79,1,250,165,136,124,1,250,166,137,125,1,250,147,121,110,1,250,46,37,34,1,250,1,0,1,1,250,2,1,2,6,250,37,30,27,1,250,135,112,102,1,250,166,137,125,2,250,125,104,95,1,252,24,19,18,1,202,0,0,0,1,231,0,0,0,1,251,0,0,0,3,250,7,5,3,1,250,115,100,79,1,250,180,157,124,1,250,181,159,125,1,250,161,140,110,1,250,51,43,33,1,250,0,0,0,7,250,40,35,26,1,250,147,129,102,1,250,182,159,125,1,250,181,158,125,1,250,138,120,96,1,251,24,21,16,1,231,0,0,0,1,247,0,0,0,4,250,9,7,3,1,250,126,114,79,1,250,196,179,124,1,250,198,180,125,1,250,175,158,110,1,250,55,49,33,1,250,0,0,0,7,250,44,40,26,1,250,160,146,102,1,250,198,180,125,2,250,150,137,96,1,250,26,23,15,1,247,0,0,0,5,250,10,9,3,1,250,136,
127,79,1,250,212,199,124,1,250,214,201,125,1,250,189,177,110,1,250,60,56,33,1,250,0,0,0,7,250,48,45,26,1,250,173,163,102,1,250,214,201,125,2,250,162,152,96,1,250,28,26,15,1,250,0,0,0,5,250,12,11,3,1,250,146,141,79,1,250,228,220,124,1,250,230,222,125,1,250,203,196,110,1,250,65,62,33,1,250,0,0,0,7,250,46,44,24,1,250,185,179,101,1,250,230,223,125,1,250,230,222,125,1,250,174,169,96,1,250,30,29,15,1,250,0,0,0,5,250,13,13,3,1,250,156,154,79,1,250,243,241,124,1,250,246,243,125,1,250,216,215,110,1,250,69,69,33,1,250,0,0,0,3,250,1,1,0,1,250,26,26,10,1,250,88,88,46,1,250,141,141,72,1,250,149,149,77,1,250,210,208,109,1,250,246,243,125,2,250,186,185,96,1,250,32,32,15,1,250,0,0,0,5,250,13,13,3,1,250,156,154,79,1,250,243,241,124,1,250,246,243,125,1,250,216,215,110,1,250,69,69,33,1,250,0,0,0,3,250,73,71,40,1,250,169,166,91,1,250,229,227,119,1,250,243,241,124,1,250,244,241,124,1,250,244,242,125,1,250,246,243,125,2,250,186,185,96,1,250,32,32,15,1,250,0,0,0,4,250,0,1,2,1,250,22,21,11,1,250,145,
140,79,1,250,228,220,124,1,250,230,222,125,1,250,203,196,110,1,250,65,62,33,1,250,0,0,0,2,250,47,44,26,1,250,173,167,99,1,250,226,219,124,1,250,231,223,125,1,250,230,223,125,4,250,230,222,125,1,250,174,169,96,1,250,30,29,15,1,250,0,0,0,1,250,1,1,0,1,250,31,29,19,1,250,111,103,69,1,250,156,145,94,1,250,163,151,98,1,250,179,167,107,1,250,213,200,125,1,250,214,201,125,1,250,189,177,110,1,250,60,56,33,1,250,0,0,0,2,250,107,99,64,1,250,202,189,119,1,250,214,201,125,7,250,162,152,96,1,250,28,26,15,1,250,0,0,0,1,247,61,54,41,1,250,150,135,100,1,250,193,175,123,1,250,197,179,125,3,250,198,180,125,2,250,175,158,110,1,250,55,49,33,1,250,0,0,0,1,250,2,2,2,1,250,132,120,84,1,250,195,177,123,1,250,198,180,125,7,250,150,136,95,1,250,25,22,15,1,247,34,28,24,1,231,131,114,93,1,251,179,156,124,1,250,182,159,125,5,250,181,158,125,1,250,161,140,110,1,250,51,43,33,1,250,0,0,0,1,250,6,5,3,1,250,127,111,87,1,250,180,157,124,1,250,182,159,125,6,250,180,158,124,1,250,130,114,89,1,251,14,12,8,1,231,75,
61,57,1,202,152,125,115,1,252,166,137,125,7,250,147,121,110,1,250,45,37,33,1,250,0,0,0,2,250,99,82,74,1,250,161,133,121,1,250,166,137,125,6,250,161,133,121,1,250,97,81,73,1,252,0,0,0,1,202,98,76,82,1,154,144,112,121,1,252,150,117,125,6,250,150,116,125,1,250,132,103,110,1,250,39,30,32,1,250,0,0,0,2,250,52,41,42,1,250,132,104,110,1,250,150,116,125,1,250,150,117,125,4,250,150,116,125,1,250,132,104,109,1,250,51,40,41,1,252,0,0,0,1,154,108,78,100,1,95,131,94,122,1,243,134,96,125,7,250,113,81,105,1,250,26,17,23,1,250,0,0,0,2,250,2,2,2,1,250,73,54,65,1,250,122,89,112,1,250,133,95,124,1,250,134,96,126,2,250,133,96,124,1,250,122,89,111,1,250,71,53,64,1,250,2,1,2,1,243,0,0,0,1,95,108,73,111,1,37,117,76,123,1,197,118,75,125,6,250,118,75,124,1,250,86,56,91,1,250,2,2,1,1,250,0,0,0,3,250,5,3,5,1,250,50,34,49,1,250,80,54,80,1,250,94,62,95,2,250,80,54,80,1,250,50,34,48,1,250,4,2,4,1,250,0,0,0,1,197,0,0,0,1,37,90,56,98,1,4,106,59,124,1,83,103,55,125,1,219,102,54,125,5,250,94,52,112,1,250,39,24,
45,1,250,0,0,0,5,250,1,0,1,1,250,3,2,3,1,250,6,3,7,2,250,3,2,4,1,250,1,0,1,1,250,0,0,0,1,219,0,0,0,1,83,0,0,0,1,4,0,0,0,1,1,88,41,113,1,6,92,40,124,1,83,88,36,124,1,197,86,34,124,1,243,85,33,123,1,252,84,33,121,1,252,77,33,107,1,251,44,20,59,1,250,1,0,1,1,250,0,0,0,6,250,0,0,0,1,251,0,0,0,2,252,0,0,0,1,243,0,0,0,1,197,0,0,0,1,83,0,0,0,1,6,0,0,0,1,1,0,0,1,1,1,0,0,0,1,1,70,27,106,1,4,78,27,119,1,37,72,23,113,1,95,61,19,97,1,154,46,15,74,1,202,27,8,41,1,231,2,1,5,1,247,0,0,0,6,250,0,0,0,1,247,0,0,0,1,231,0,0,0,1,202,0,0,0,1,154,0,0,0,1,95,0,0,0,1,37,0,0,0,1,4,0,0,0,2,1);


//app small icon (optional) - 20w x 20h size in TEA format only, accessed via tepIcon20
program_icon20h
:array[0..1311] of byte=(
84,69,65,51,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,2,1,0,0,0,1,23,0,0,0,1,95,0,0,0,1,162,31,12,48,1,212,44,16,67,1,239,43,15,66,1,249,43,15,66,4,250,43,15,66,1,249,44,16,67,1,239,46,17,72,1,212,54,21,82,1,162,68,28,103,1,95,80,28,121,1,23,0,0,0,1,1,6,2,10,1,1,0,0,0,1,1,0,0,0,1,36,0,0,0,1,195,0,0,0,1,245,0,0,0,1,250,63,28,85,1,250,90,39,122,1,250,90,39,123,9,250,91,40,124,1,245,93,41,125,1,195,98,48,125,1,36,0,0,0,1,1,0,0,0,1,23,0,0,0,1,195,0,0,0,1,251,0,0,0,2,250,77,45,87,1,250,110,64,125,11,250,110,64,125,1,251,109,64,122,1,195,52,37,55,1,23,0,0,0,1,95,0,0,0,1,245,0,0,0,3,250,90,63,87,1,250,129,90,125,2,250,128,89,124,1,250,128,88,124,7,250,129,90,125,2,250,122,84,118,1,245,36,27,35,1,95,0,0,0,1,162,0,0,0,4,250,104,80,87,1,250,148,114,125,1,250,147,113,124,1,250,99,75,87,1,250,84,60,75,1,250,84,61,75,5,250,91,67,80,1,250,143,110,120,1,250,149,114,125,1,250,138,107,117,1,250,30,24,26,1,162,0,0,0,1,212,0,0,0,4,250,117,97,87,1,250,167,139,125,1,250,165,137,123,1,
250,74,61,54,1,250,0,0,0,6,250,46,38,34,1,250,159,132,118,1,250,168,139,125,1,250,155,129,117,1,250,29,24,22,1,212,0,0,0,1,239,0,0,0,4,250,130,115,87,1,250,185,164,125,1,250,183,162,123,1,250,83,72,55,1,250,0,0,0,6,250,52,46,34,1,250,176,156,118,1,250,186,165,125,1,250,173,152,117,1,250,30,27,20,1,239,0,0,0,1,249,0,0,0,4,250,144,133,87,1,250,205,190,125,1,250,202,187,123,1,250,92,84,55,1,250,0,0,0,6,250,57,53,34,1,250,195,180,118,1,250,206,191,125,1,250,191,177,117,1,250,32,29,19,1,249,0,0,0,5,250,157,150,87,1,250,224,215,125,1,250,221,212,123,1,250,100,95,55,1,250,0,0,0,6,250,62,60,34,1,250,213,204,118,1,250,225,216,125,1,250,209,201,117,1,250,35,34,19,1,250,0,0,0,5,250,171,169,87,1,250,244,241,125,1,250,240,238,123,1,250,109,108,55,1,250,0,0,0,4,250,48,48,24,1,250,124,124,64,1,250,139,139,72,1,250,233,231,120,1,250,245,242,125,1,250,227,225,117,1,250,38,37,19,1,250,0,0,0,5,250,171,169,87,1,250,244,241,125,1,250,240,238,123,1,250,109,108,55,1,250,0,0,0,2,250,18,17,7,1,250,137,
134,75,1,250,223,220,117,1,250,244,241,125,2,250,244,242,125,1,250,245,242,125,1,250,227,225,117,1,250,38,37,19,1,250,0,0,0,2,250,10,9,4,1,250,40,37,22,1,250,55,51,32,1,250,160,153,89,1,250,224,215,125,1,250,221,212,123,1,250,100,96,55,1,250,0,0,0,2,250,102,97,60,1,250,215,206,121,1,250,225,216,125,5,250,209,201,117,1,250,35,34,19,1,250,0,0,0,1,249,43,39,27,1,250,139,127,89,1,250,184,169,113,1,250,191,176,117,1,250,196,180,120,1,250,206,190,125,1,250,202,187,123,1,250,92,84,55,1,250,0,0,0,2,250,160,148,100,1,250,207,191,125,1,250,206,191,125,5,250,191,177,117,1,250,32,29,19,1,249,22,18,16,1,239,144,128,100,1,250,185,163,125,1,250,186,165,125,4,250,183,162,123,1,250,83,72,55,1,250,0,0,0,1,250,4,4,3,1,250,165,146,111,1,250,187,165,125,1,250,186,165,125,5,250,170,150,114,1,250,23,21,15,1,239,85,69,64,1,212,163,135,122,1,250,168,139,125,5,250,165,137,123,1,250,74,61,55,1,250,0,0,0,2,250,133,112,99,1,250,168,140,125,1,250,168,139,125,4,250,168,140,125,1,250,132,111,98,1,250,0,0,0,
1,212,108,84,92,1,162,147,113,124,1,250,149,114,125,5,250,146,113,123,1,250,63,49,53,1,250,0,0,0,2,250,71,56,58,1,250,144,112,121,1,250,149,114,125,4,250,144,112,121,1,250,70,55,57,1,250,0,0,0,1,162,114,81,109,1,95,129,89,124,1,245,129,90,125,5,250,124,86,119,1,250,42,29,39,1,250,0,0,0,2,250,8,5,7,1,250,80,58,74,1,250,123,86,117,1,250,128,89,124,2,250,123,86,117,1,250,79,58,73,1,250,8,5,6,1,245,0,0,0,1,95,107,70,114,1,23,111,66,125,1,195,110,64,125,1,251,110,64,125,4,250,92,56,103,1,250,12,6,14,1,250,0,0,0,4,250,35,21,35,1,250,57,35,59,1,250,57,35,60,1,250,35,21,35,1,250,0,0,0,1,251,0,0,0,1,195,0,0,0,1,23,0,0,0,1,1,97,48,123,1,36,93,41,125,1,195,91,39,125,1,245,91,39,124,1,250,90,39,124,1,250,84,39,113,1,250,36,17,46,1,250,0,0,0,8,250,0,0,0,1,245,0,0,0,1,195,0,0,0,1,36,0,0,0,1,1,3,1,4,1,1,0,0,0,1,1,80,28,120,1,23,76,25,118,1,95,66,20,104,1,162,51,17,80,1,212,24,8,36,1,239,0,0,0,1,249,0,0,0,4,250,0,0,0,1,249,0,0,0,1,239,0,0,0,1,212,0,0,0,1,162,0,0,0,1,95,0,0,0,1,23,0,0,0,2,1);
//:array[0..0] of byte=(0);


//additional icons (B..D) are optional - 25may2025 -----------------------------
//Note: Supported image format: tea
//Note: Each icon, if specified, must be 24w x 24h.  The icons form an animation of upto 10 cells in total.
//      When triggered, the app icon - (top-left) of window - will animate and cycle through each of the cells
//      in a continuos loop for a short time period of about 2 seconds.
//How To Use:
//      Use rootwin.xhead.aniAdd(xtep,xms) to add upto 10 cells, and rootwin.xhead.aniPlay to
//      trigger animation playback for ~2 seconds.  To extend playback, call rootwin.xhead.aniPlay
//      regularly.
//
//Example:
//to setup the animation ready for playback:
//      rootwin.xhead.aniAdd(tepIcon24 ,200);
//      rootwin.xhead.aniAdd(tepIcon24B,200);
//      rootwin.xhead.aniAdd(tepIcon24C,200);
//      rootwin.xhead.aniAdd(tepIcon24D,200);
//
//to play the animation call:
//      rootwin.xhead.aniPlay;
//
//to clear the animation (e.g. to create a new animation) call:
//      rootwin.xhead.aniClear;
//
//Note: the examples above must be executed within "tprogram" for access to rootwin, see
//      the unit marked "main" for tprogram.


//accessed via "tepIcon24B"
program_icon24hB
:array[0..1246] of byte=(
84,69,65,51,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,3,1,0,0,0,1,15,0,0,0,1,101,0,0,0,1,171,14,9,18,1,212,22,13,30,1,236,22,13,29,1,248,22,12,29,6,250,22,13,29,1,248,22,13,30,1,236,24,14,32,1,212,28,17,36,1,171,38,24,48,1,101,54,36,69,1,15,22,12,29,1,1,16,10,21,1,1,0,0,0,3,1,0,0,0,1,67,0,0,0,1,221,0,0,0,2,250,58,23,83,1,250,86,31,125,13,250,87,32,125,1,221,91,37,125,1,67,63,26,92,1,1,0,0,0,2,1,0,0,0,1,67,0,0,0,1,241,0,0,0,3,250,68,36,83,1,250,102,53,125,14,250,103,53,125,1,241,103,56,121,1,67,0,0,0,1,1,0,0,0,1,15,0,0,0,1,221,0,0,0,4,250,79,50,83,1,250,118,74,125,15,250,96,61,102,1,221,0,0,0,1,15,0,0,0,1,101,0,0,0,5,250,89,64,83,1,250,134,95,125,15,250,103,74,96,1,250,0,0,0,1,101,0,0,0,1,171,0,0,0,5,250,100,78,83,1,250,150,116,125,2,250,140,108,117,1,250,70,52,60,1,250,69,51,60,8,250,130,101,109,1,250,150,116,125,2,250,115,90,96,1,250,0,0,0,1,171,0,0,0,1,212,0,0,0,5,250,111,91,83,1,250,166,137,125,2,250,151,124,114,1,250,0,0,0,9,250,137,113,104,1,250,166,137,125,
2,250,127,105,96,1,250,0,0,0,1,212,0,0,0,1,236,0,0,0,5,250,121,105,83,1,250,182,158,125,2,250,166,144,114,1,250,0,0,0,9,250,150,131,104,1,250,182,158,125,2,250,139,121,96,1,250,0,0,0,1,236,0,0,0,1,248,0,0,0,5,250,132,120,83,1,250,197,180,125,2,250,180,163,114,1,250,0,0,0,9,250,163,148,104,1,250,197,180,125,2,250,151,137,96,1,250,0,0,0,1,248,0,0,0,6,250,143,134,83,1,250,214,201,125,2,250,194,183,114,1,250,0,0,0,9,250,176,166,104,1,250,214,201,125,2,250,163,153,96,1,250,0,0,0,7,250,153,148,83,1,250,230,222,125,2,250,209,202,114,1,250,0,0,0,9,250,189,183,104,1,250,230,222,125,2,250,176,170,96,1,250,0,0,0,4,250,31,31,18,1,250,116,116,60,1,250,131,131,66,1,250,179,178,92,1,250,246,244,125,2,250,223,222,114,1,250,0,0,0,9,250,202,201,104,1,250,246,244,125,2,250,188,186,96,1,250,0,0,0,2,250,1,1,0,1,250,146,144,80,1,250,230,228,120,1,250,246,244,125,5,250,223,222,114,1,250,0,0,0,9,250,202,201,104,1,250,246,244,125,2,250,188,186,96,1,250,0,0,0,2,250,135,131,79,1,250,228,221,125,1,250,230,
222,125,6,250,209,202,114,1,250,0,0,0,9,250,189,183,104,1,250,230,222,125,2,250,176,170,96,1,250,0,0,0,1,250,21,19,13,1,250,199,187,119,1,250,214,201,125,7,250,194,183,114,1,250,0,0,0,5,250,20,20,14,1,250,116,108,72,1,250,153,143,93,1,250,152,142,92,1,250,192,180,114,1,250,214,201,125,2,250,163,154,96,1,250,0,0,0,1,250,83,75,54,1,248,197,180,125,8,250,180,163,114,1,250,0,0,0,4,250,65,59,46,1,250,175,159,114,1,250,197,180,125,6,250,151,137,96,1,250,0,0,0,1,248,90,78,62,1,236,182,158,125,8,250,158,138,109,1,250,0,0,0,3,250,11,10,8,1,250,160,140,113,1,250,182,158,125,7,250,139,121,96,1,250,0,0,0,1,236,45,38,34,1,212,164,135,124,1,250,166,137,125,7,250,124,103,94,1,250,0,0,0,3,250,86,71,67,1,250,166,137,125,8,250,126,104,95,1,250,0,0,0,1,212,0,0,0,1,171,120,95,100,1,250,150,116,125,6,250,148,115,123,1,250,59,47,49,1,250,0,0,0,3,250,103,81,86,1,250,150,116,125,8,250,114,89,95,1,250,0,0,0,1,171,0,0,0,1,101,33,25,30,1,250,119,87,110,1,250,134,95,125,4,250,132,95,123,1,250,82,61,74,1,
250,0,0,0,4,250,91,66,85,1,250,134,95,125,8,250,92,66,85,1,250,0,0,0,1,101,0,0,0,1,15,0,0,0,1,221,12,8,12,1,250,74,49,75,1,250,98,64,101,1,250,100,65,104,1,250,90,59,92,1,250,46,31,47,1,250,0,0,0,5,250,56,38,58,1,250,118,74,125,8,250,59,39,61,1,221,0,0,0,1,15,0,0,0,1,1,0,0,0,1,67,0,0,0,1,241,0,0,0,10,250,2,1,2,1,250,88,50,106,1,250,102,53,125,6,250,89,49,106,1,241,3,2,5,1,67,0,0,0,3,1,0,0,0,1,67,0,0,0,1,221,0,0,0,10,250,21,11,27,1,250,75,34,104,1,250,86,32,125,1,250,86,31,125,2,250,87,32,125,1,250,80,36,109,1,221,42,23,52,1,67,0,0,0,5,1,0,0,0,1,15,0,0,0,1,101,0,0,0,1,171,0,0,0,1,212,0,0,0,1,236,0,0,0,1,248,0,0,0,6,250,0,0,1,1,248,34,14,53,1,236,51,14,85,1,212,58,18,95,1,171,53,24,81,1,101,4,2,6,1,15,0,0,0,3,1);


//accessed via "tepIcon24C"
program_icon24hC
:array[0..0] of byte=(0);


//accessed via "tepIcon24D"
program_icon24hD
:array[0..0] of byte=(0);


//help viewer banner images - optional -----------------------------------------
//.banner 1
programbanner
:array[0..0] of byte=(0);//disabled

//.banner 2
programbanner2
:array[0..0] of byte=(0);//disabled


//app help document(s) - optional ----------------------------------------------
//note: these help documents, if specified, are processed and merged into one large
//      document at runtime by the built-in help viewer, which supports documents in
//      the following 3 formats:
//
//      1. txt - plain text
//      2. bwd - enhanced text (Blaiz Enterprises format)
//      3. bwp - advanced text (Blaiz Enterprises format)
//
//      These documents can be compressed (using zip) or left uncompressed.


//app help - app specific help document, which appears above system help
apphelp//03jul2025
:array[0..47039] of byte=(
120,1,204,189,7,124,85,213,214,245,189,19,130,116,17,68,122,147,34,9,132,208,139,74,145,14,210,73,144,38,112,67,147,128,20,41,82,140,68,177,160,20,17,84,84,84,64,16,1,21,80,105,10,8,210,21,68,16,145,46,85,68,5,36,65,74,128,144,188,127,214,184,103,221,229,57,73,140,222,251,125,239,235,111,223,243,172,61,215,156,99,142,57,230,92,251,156,19,32,79,195,78,237,170,120,252,23,51,184,223,144,7,248,191,143,70,15,238,51,188,119,244,208,190,247,149,172,156,43,251,240,49,195,71,244,29,52,188,119,255,190,131,100,24,53,44,122,232,240,17,99,30,229,174,106,174,236,189,30,233,61,228,209,33,195,238,43,89,165,102,173,90,53,170,87,197,212,39,122,68,244,19,95,123,94,55,207,27,225,121,221,61,175,131,231,141,244,188,193,230,138,49,175,143,120,94,73,207,107,228,121,99,204,45,110,253,201,239,121,209,198,222,207,243,134,120,222,48,179,214,86,95,159,29,31,236,195,13,50,8,236,98,25,228,121,56,100,15,242,34,131,188,190,65,222,227,230,117,88,144,23,29,228,61,26,228,149,12,242,134,155,245,160,32,111,168,177,
224,131,145,219,152,32,175,143,121,197,1,75,175,32,111,164,185,37,106,68,144,87,209,172,7,7,121,17,102,23,135,78,65,94,127,3,142,81,176,184,69,7,121,228,98,1,26,246,71,204,86,55,147,11,251,16,99,17,25,50,226,128,63,11,56,116,55,158,253,140,15,14,0,2,34,124,214,216,1,196,14,55,236,218,197,162,216,112,159,69,254,248,168,168,12,86,26,109,144,21,66,177,192,42,11,22,4,33,151,106,241,163,84,42,200,163,46,200,224,134,146,247,25,146,20,8,2,81,24,97,91,53,200,171,236,43,173,157,217,34,215,24,131,217,212,84,234,58,3,72,10,160,240,65,25,16,216,13,55,70,89,68,6,7,236,88,192,161,71,44,122,7,121,3,141,155,152,3,130,145,222,193,13,62,72,196,45,107,118,241,140,8,186,53,27,92,13,124,74,178,75,58,177,2,156,16,213,43,157,73,10,20,181,200,168,134,166,197,65,108,129,2,132,40,152,40,187,192,213,23,200,83,26,76,132,175,236,248,115,171,246,145,75,129,100,36,59,175,220,50,0,216,85,14,183,214,153,53,128,248,168,101,84,135,133,171,93,218,42,137,70,180,225,38,50,88,184,88,91,158,163,12,38,89,224,105,135,
74,121,225,160,133,29,78,1,186,117,81,160,154,69,249,110,21,172,145,154,240,199,140,62,184,17,75,22,236,192,178,5,127,117,39,227,71,6,4,164,166,35,234,29,42,1,136,145,44,172,73,65,165,112,83,22,157,23,182,84,23,91,36,165,167,98,162,186,84,160,138,34,74,129,114,19,236,223,26,9,42,2,150,43,202,40,169,78,113,43,38,34,32,216,180,198,6,31,50,14,48,101,226,9,31,241,180,250,167,211,235,214,70,88,194,41,48,220,4,166,227,220,216,184,241,192,132,36,250,216,144,135,12,8,26,162,179,21,80,204,65,134,76,164,17,31,127,46,89,236,252,64,18,61,9,20,109,110,9,84,10,73,170,90,172,230,184,177,166,149,149,124,237,83,201,68,169,179,248,179,11,25,44,40,230,62,1,144,90,195,195,171,125,187,105,109,222,71,244,70,163,247,8,222,77,184,30,245,188,94,102,75,239,44,220,202,103,160,121,67,193,147,119,31,222,164,250,120,183,222,155,236,251,142,222,113,176,240,174,164,119,177,222,190,247,29,48,241,39,181,26,141,20,80,69,46,120,218,177,87,117,20,8,127,49,167,40,220,236,84,96,103,23,241,137,194,217,234,137,86,172,
49,202,159,45,219,125,97,162,9,56,196,242,160,96,145,193,227,83,206,119,82,212,47,178,208,62,64,184,69,76,112,184,120,80,147,20,35,181,112,11,67,152,144,133,188,220,42,59,11,124,168,130,163,4,49,140,225,102,23,139,220,212,119,205,57,22,75,30,52,137,195,3,92,187,42,129,119,19,181,210,239,45,6,134,209,102,126,170,58,239,44,109,124,70,104,84,52,121,163,12,97,200,112,137,48,91,148,38,157,221,249,193,110,69,179,224,42,132,68,80,101,141,3,91,120,18,136,145,53,10,0,123,107,204,140,15,183,108,253,247,239,128,150,63,7,10,137,200,75,35,48,186,138,241,46,217,206,100,135,137,30,215,52,8,79,248,80,32,76,104,4,62,129,108,133,131,167,182,240,183,8,116,150,50,173,62,56,208,95,183,233,120,202,232,151,40,80,1,196,193,7,194,48,161,161,110,155,252,104,183,242,181,3,103,192,213,184,191,85,184,139,240,255,81,201,180,213,10,197,66,243,3,225,192,194,241,68,49,170,230,225,230,87,181,181,219,50,253,164,112,99,53,111,60,48,117,28,220,214,168,5,56,192,132,68,220,178,214,100,166,207,77,4,220,51,238,50,236,
96,208,220,93,203,83,237,32,139,61,239,174,32,122,130,241,176,210,167,47,182,104,61,180,241,71,34,94,185,21,61,63,79,124,36,20,175,112,99,186,224,79,82,217,1,84,32,3,137,37,80,106,140,224,227,67,70,183,144,72,199,238,150,96,157,49,166,197,63,48,139,235,233,102,105,231,140,132,205,18,101,248,248,61,112,92,4,87,1,30,20,4,118,242,61,6,37,145,235,172,182,130,134,91,104,192,67,198,245,116,137,209,35,100,68,76,244,225,233,97,65,194,12,142,27,229,146,33,133,171,39,235,74,230,177,163,71,180,184,185,14,224,208,53,90,243,183,184,9,1,110,26,12,90,156,65,86,132,48,33,68,129,16,216,35,74,198,65,224,172,25,9,156,153,100,69,65,210,213,167,169,227,12,121,110,3,253,177,187,15,34,52,4,150,236,216,211,17,144,45,160,160,129,191,10,228,86,210,165,202,10,52,156,255,155,35,0,56,225,163,77,58,183,198,54,142,221,214,210,206,55,24,122,191,112,99,241,249,159,60,97,0,129,15,200,60,184,92,62,173,29,187,229,19,249,231,119,55,55,54,176,197,60,78,17,147,193,246,131,69,106,202,39,233,48,211,157,138,230,213,15,
153,94,104,140,73,205,113,35,4,134,76,5,128,12,9,45,192,14,67,63,168,104,211,107,122,26,72,134,64,236,110,139,1,113,137,181,77,205,33,173,194,93,122,105,5,194,211,143,118,184,161,77,44,100,64,230,40,81,35,156,41,141,39,6,130,96,252,187,31,255,8,167,46,46,194,89,35,169,0,1,199,18,168,131,84,165,41,132,184,229,55,55,254,178,167,85,117,104,192,167,11,210,81,35,228,129,165,46,230,129,210,16,150,181,10,228,22,76,125,251,160,204,48,99,199,72,32,14,68,17,78,91,85,59,15,55,60,177,16,2,2,131,193,154,40,121,226,35,122,20,165,203,126,83,104,110,190,23,140,242,254,253,129,159,207,243,124,206,31,106,190,41,240,93,128,159,77,233,75,1,175,250,178,96,127,238,132,39,95,7,176,243,163,39,190,32,240,149,129,87,118,177,232,59,133,13,212,207,178,8,199,135,31,82,241,213,35,187,231,255,1,27,206,84,164,90,144,34,218,225,207,22,85,75,13,61,195,165,0,109,162,40,202,100,161,247,226,82,1,239,26,122,16,225,38,161,8,172,234,124,132,110,103,16,200,149,254,71,74,101,65,76,101,161,149,162,196,24,148,52,8,208,
214,3,51,204,88,180,203,22,73,161,71,79,241,4,196,38,114,139,133,115,6,105,0,2,2,52,212,205,8,95,43,117,198,133,73,210,255,237,135,243,112,95,69,234,14,2,170,71,170,139,116,240,161,53,90,176,197,69,213,220,218,183,0,214,208,230,213,21,65,146,218,105,183,83,141,5,4,106,97,152,241,167,70,2,185,30,52,22,235,79,82,48,245,133,154,19,196,154,16,17,99,33,62,18,68,198,192,49,0,147,18,192,97,145,214,143,101,216,2,25,31,85,36,127,113,144,157,20,20,162,225,113,171,35,208,205,206,60,19,107,135,129,93,61,223,228,35,88,91,169,142,103,99,83,5,34,48,240,164,80,21,129,3,239,102,9,28,126,90,134,20,100,39,220,29,251,230,142,157,40,248,224,64,153,160,209,95,149,67,129,220,170,16,64,168,142,53,11,148,100,225,215,62,78,4,178,64,143,112,124,216,229,194,77,77,100,65,141,10,36,11,14,66,86,251,8,100,215,150,25,230,52,61,202,121,38,248,101,148,128,54,145,198,146,20,90,128,73,237,228,117,117,230,150,188,216,37,38,76,162,125,226,224,207,174,173,14,5,88,67,30,52,236,132,224,201,90,99,192,43,107,56,195,31,
40,98,195,141,27,18,73,70,66,48,146,11,31,61,154,132,15,8,73,5,34,17,68,70,89,168,5,35,254,184,177,182,32,24,113,192,104,223,230,64,32,145,212,195,95,28,34,76,8,81,141,125,228,173,164,24,113,3,211,242,193,2,32,175,126,181,168,16,171,18,108,241,177,183,172,41,68,51,201,130,188,246,224,224,137,27,14,129,7,45,212,68,209,86,65,81,142,31,38,22,194,65,179,246,104,31,154,109,4,91,180,18,187,77,68,58,65,185,231,46,194,247,72,140,114,26,173,194,213,17,225,160,3,70,46,110,53,162,232,160,164,208,0,4,59,215,223,82,18,124,13,0,82,131,143,14,82,27,28,247,248,115,107,153,211,32,210,209,86,60,169,139,45,183,22,118,161,4,26,111,58,234,139,38,65,235,192,134,2,107,103,187,84,192,187,128,139,92,53,141,119,64,162,224,128,44,226,67,222,255,232,25,236,13,49,215,163,193,94,175,96,47,58,216,27,22,236,149,12,246,90,5,123,49,193,222,224,96,111,96,176,55,60,216,203,30,236,255,238,195,232,82,163,223,193,116,9,116,72,205,1,26,21,13,153,180,118,221,98,221,210,92,209,108,45,106,61,207,213,192,119,70,20,230,
28,185,124,154,26,217,49,90,14,145,70,88,196,103,2,49,186,169,81,204,250,227,160,39,6,234,225,67,213,228,149,164,122,10,209,98,198,76,56,118,198,58,26,55,156,45,50,225,4,114,171,199,142,162,244,76,14,196,81,20,152,44,24,179,104,95,239,32,96,215,108,177,230,85,157,149,26,220,18,69,95,88,216,83,54,204,220,98,196,31,5,2,43,194,153,93,236,64,81,11,180,9,17,91,217,133,160,199,2,133,104,122,137,2,144,53,151,100,33,68,163,229,215,17,183,125,110,83,26,250,16,244,1,76,179,209,204,48,1,156,98,165,128,219,26,166,2,50,164,211,115,82,181,184,84,221,18,0,209,204,179,64,112,149,143,197,126,180,96,13,2,91,56,208,23,110,37,35,70,178,32,96,170,211,165,93,186,230,214,210,212,64,17,133,157,68,44,80,18,216,140,20,5,1,42,210,247,95,66,2,123,129,241,191,47,132,90,162,204,185,30,106,14,245,173,31,74,7,255,231,199,251,16,134,131,18,73,79,88,81,41,22,209,99,87,21,217,190,88,173,104,10,110,233,28,88,6,128,112,59,75,74,68,184,38,31,64,70,72,250,147,139,238,128,102,179,68,27,2,48,177,99,0,85,28,2,85,138,
48,118,182,26,27,230,122,71,99,30,148,142,20,58,41,44,52,111,22,144,16,213,8,159,84,145,49,138,134,20,80,139,233,8,8,108,81,8,41,24,72,94,225,134,39,137,172,157,116,144,7,159,88,9,107,117,192,39,131,223,109,241,116,5,161,52,221,234,225,192,26,50,36,82,106,178,235,193,162,158,138,0,158,92,48,132,9,22,105,146,86,203,80,82,159,87,163,76,95,228,76,148,158,132,130,5,135,188,16,11,108,4,70,117,22,38,146,66,3,128,93,177,98,194,171,236,50,90,109,245,126,7,62,254,25,215,71,135,215,166,208,112,34,8,224,240,164,4,240,109,93,183,206,181,249,163,46,254,10,71,170,223,148,249,227,48,190,243,234,239,102,240,125,153,239,188,238,119,103,191,175,204,252,129,90,58,223,175,133,67,8,104,126,127,190,6,108,90,95,183,249,42,237,138,111,203,65,22,10,81,93,82,172,148,169,11,49,171,153,6,113,139,8,110,103,105,129,196,113,251,133,44,132,128,35,163,85,143,68,116,153,112,46,61,232,92,245,64,230,18,49,27,98,23,160,185,169,177,171,137,66,112,159,111,108,193,74,115,197,174,222,19,89,16,174,113,37,144,91,0,5,2,
43,182,228,169,40,133,227,198,227,66,118,28,32,204,52,250,121,82,38,32,104,197,43,91,2,100,1,38,80,54,29,14,88,194,141,79,180,15,4,103,192,149,203,110,169,5,126,89,240,33,59,104,196,18,66,160,78,61,110,150,21,233,216,197,135,122,177,187,196,34,124,39,46,227,3,159,106,167,36,148,139,76,34,119,24,56,113,226,160,103,32,114,49,9,48,36,4,79,183,10,214,88,0,164,28,28,112,35,16,181,165,63,114,177,208,187,48,21,177,182,234,137,152,45,147,40,177,82,151,193,209,220,170,35,108,193,196,198,66,21,40,20,182,169,81,18,40,249,96,100,23,62,88,80,140,91,174,22,198,31,35,91,128,19,43,31,182,244,188,162,16,17,128,9,14,236,178,133,27,69,17,197,154,221,116,102,94,79,66,178,104,180,236,199,42,2,1,4,92,152,172,169,72,15,94,85,170,119,4,185,241,234,118,129,40,234,34,175,8,176,86,201,220,18,43,134,116,164,154,33,70,172,158,177,36,194,72,34,75,155,181,178,72,82,42,18,142,37,73,8,225,174,212,225,198,98,29,216,69,76,112,20,8,130,219,2,136,249,49,204,248,124,90,206,126,181,187,19,24,97,200,224,208,212,200,
72,118,205,161,159,14,208,115,37,194,141,11,13,5,165,26,169,66,170,106,90,192,116,65,120,42,194,28,11,218,82,32,31,126,168,23,16,89,104,68,213,52,190,61,129,211,202,105,22,56,88,148,8,4,29,162,80,131,3,26,200,218,37,11,229,3,30,102,44,44,216,101,139,68,244,151,181,62,105,96,183,237,110,103,96,163,125,35,228,38,37,16,100,182,200,8,50,217,173,110,13,124,141,99,151,46,171,209,192,34,23,89,240,199,142,63,8,226,128,145,91,87,55,144,17,16,88,184,241,74,8,158,172,109,138,70,38,4,192,12,10,75,10,48,5,229,170,218,214,177,167,37,35,89,208,205,79,40,40,73,70,144,213,235,192,110,146,206,214,238,38,109,226,216,129,173,103,192,253,38,33,131,132,173,32,233,204,170,91,35,233,244,41,8,254,112,35,11,183,225,134,0,150,104,223,195,211,126,25,161,4,219,38,22,246,132,170,100,36,165,113,68,97,103,129,80,244,136,78,9,80,189,195,14,8,109,194,14,2,206,74,205,26,163,162,210,106,162,203,92,221,97,72,120,42,2,197,5,121,160,34,124,111,82,81,206,220,2,168,93,220,200,142,27,11,248,144,20,187,186,153,193,90,
8,241,251,220,8,103,64,40,4,1,217,165,106,240,1,103,129,197,42,102,15,145,95,103,113,38,92,196,136,114,7,163,157,163,39,200,173,28,73,185,69,109,169,71,10,56,80,56,70,174,70,127,37,163,31,1,183,107,105,101,79,245,44,192,25,230,100,164,11,112,96,72,84,187,184,65,9,122,168,202,46,11,245,20,146,122,171,250,203,15,183,252,201,14,159,105,249,187,97,25,249,124,235,126,16,101,20,165,57,73,237,90,179,23,248,245,135,86,138,164,134,129,181,31,121,170,176,99,204,22,85,224,67,203,108,213,50,162,3,70,64,208,132,164,204,36,158,234,41,51,96,91,19,229,204,36,83,7,50,206,138,2,135,183,21,152,19,165,199,175,29,39,113,147,93,165,241,10,13,236,32,176,22,130,205,226,119,246,253,6,27,98,176,37,23,125,215,217,1,1,26,16,96,193,7,96,205,3,62,82,79,91,161,230,7,74,32,147,17,77,240,196,191,73,26,254,154,22,60,37,84,39,19,197,154,138,128,69,115,85,68,9,50,2,69,136,11,142,131,31,72,71,51,72,16,38,4,41,88,132,25,14,220,130,163,207,120,105,61,166,92,233,144,29,14,148,160,179,169,234,176,96,87,11,160,205,22,
175,112,136,48,70,236,205,141,5,124,90,163,145,208,26,100,118,9,135,134,52,97,45,76,20,214,90,118,110,93,100,162,200,136,69,98,74,16,110,193,97,45,79,5,254,37,121,202,39,74,211,194,43,217,177,64,143,20,110,44,176,0,42,157,134,147,44,98,110,75,192,31,11,183,60,34,24,3,160,184,5,74,152,148,64,34,192,89,0,165,191,63,207,173,205,46,112,105,66,148,160,120,149,182,46,25,137,67,19,197,138,140,60,37,184,197,71,28,192,140,48,76,216,138,114,78,13,83,225,247,248,194,147,20,68,65,9,180,170,127,231,51,18,53,138,191,148,33,23,28,48,34,35,118,139,137,221,45,211,142,135,78,10,91,28,49,82,227,70,8,19,2,26,107,245,2,110,184,113,97,196,130,221,157,4,110,3,199,0,64,27,34,109,21,27,238,75,33,97,221,92,40,79,55,225,128,209,234,214,193,36,85,106,48,217,178,12,229,204,45,187,234,50,35,65,22,16,84,8,172,200,194,22,62,196,202,8,115,214,80,162,94,236,25,41,68,129,224,0,110,127,54,171,91,212,128,170,222,14,26,248,232,89,124,216,66,146,20,4,146,203,62,196,148,23,55,113,0,159,181,253,22,227,106,66,105,200,
34,207,84,245,105,234,171,157,44,192,186,177,237,156,88,182,90,57,242,202,19,113,184,128,101,110,73,65,69,225,6,4,25,149,139,133,62,120,187,176,129,211,235,242,7,135,219,170,206,0,71,254,185,186,6,198,1,16,56,40,11,189,176,31,239,145,75,7,13,16,134,16,122,60,105,113,8,51,254,182,155,129,28,52,93,132,67,213,205,222,196,76,172,236,100,76,245,115,169,203,223,141,77,149,57,237,214,5,7,22,96,114,69,153,86,106,74,185,141,54,70,104,179,176,221,135,3,22,118,93,49,253,82,80,172,220,152,43,213,46,52,2,117,238,254,178,53,46,160,68,238,21,240,80,18,7,240,89,184,181,251,113,75,103,246,236,87,117,106,33,10,206,224,176,128,191,122,164,26,177,192,28,11,183,170,203,125,164,71,27,59,62,244,142,53,165,209,113,110,229,108,117,203,248,99,220,173,69,124,236,137,99,182,65,78,171,34,37,149,32,238,163,76,199,65,181,232,8,195,138,66,232,5,175,68,185,206,202,72,34,60,177,243,170,53,10,80,26,183,234,160,116,192,89,56,130,101,77,22,0,81,32,58,181,71,1,14,42,1,52,28,36,142,50,114,11,242,0,211,101,44,224,216,
92,108,233,253,136,210,8,225,86,218,194,135,53,167,143,75,143,32,236,42,223,118,80,71,82,3,201,174,109,13,11,113,38,151,6,30,52,232,73,10,214,84,193,22,248,246,129,70,22,192,149,84,4,184,165,16,60,89,16,200,66,41,132,156,86,155,34,124,79,218,214,38,80,197,18,155,78,83,2,229,130,170,82,195,144,216,180,114,177,133,131,58,200,90,11,10,193,168,18,84,93,184,1,193,8,25,220,108,21,82,149,190,72,85,50,178,96,23,159,180,90,204,22,82,208,47,178,112,113,75,56,121,33,236,230,194,7,40,28,216,69,46,77,5,4,72,129,69,32,132,224,192,174,91,126,184,217,181,79,3,60,137,37,208,114,182,80,108,33,11,91,88,84,44,107,81,74,53,187,26,129,51,228,233,50,33,44,184,85,55,137,181,220,108,46,82,184,93,43,231,19,208,37,28,17,116,171,28,174,40,35,26,69,73,100,187,0,77,242,106,14,201,40,76,236,68,249,229,194,83,50,226,35,101,228,134,61,112,2,93,110,74,154,86,21,233,204,15,176,80,2,31,52,248,176,160,58,105,130,152,220,166,122,34,108,81,202,136,155,45,4,52,112,220,35,201,174,14,184,95,189,74,68,46,59,18,120,42,
220,162,17,146,14,121,75,131,129,17,103,116,144,206,208,166,5,84,199,171,74,160,28,46,205,60,89,240,135,36,11,28,192,225,194,2,37,26,106,223,56,164,185,125,62,67,134,122,21,203,26,88,141,16,8,170,209,118,1,52,28,192,215,57,210,45,175,246,185,148,78,81,36,149,14,116,132,116,138,85,47,176,243,196,83,22,44,228,229,22,218,225,38,29,124,100,100,161,7,163,155,145,247,89,191,207,243,184,1,8,19,10,172,234,124,22,106,228,216,169,162,129,129,5,25,4,110,149,2,161,148,34,212,167,51,91,16,163,64,48,41,28,135,48,227,175,90,216,13,36,0,115,90,47,253,93,2,77,28,59,129,169,126,28,250,103,228,17,4,62,96,186,225,220,186,66,105,12,176,64,204,246,58,157,126,89,76,116,147,56,56,51,144,36,138,54,8,212,200,80,145,133,171,141,177,19,66,22,110,51,254,177,65,7,10,124,46,2,25,60,212,22,72,180,177,48,54,24,173,131,38,159,91,149,131,143,30,41,196,218,1,99,205,46,91,168,65,227,184,197,159,170,65,22,67,29,76,247,57,163,112,124,132,28,110,162,240,199,66,199,193,17,37,194,237,168,167,35,11,104,132,64,128,88,46,
20,35,16,35,234,9,71,250,67,152,91,173,109,22,251,208,192,78,160,30,95,64,17,174,161,130,149,70,20,170,56,40,17,248,80,229,22,156,8,227,140,127,23,99,65,61,214,58,116,122,74,208,71,0,173,26,236,18,43,134,170,151,53,80,216,113,3,80,81,24,97,107,255,124,147,181,248,200,25,182,248,219,64,158,246,64,225,67,127,37,38,4,192,84,8,133,131,41,59,70,197,74,7,50,178,224,82,106,62,178,2,34,100,171,188,66,128,98,75,177,88,192,244,115,75,167,191,212,142,51,2,66,210,234,0,32,210,233,33,25,229,83,32,80,43,17,35,156,5,8,146,69,228,65,192,158,206,153,98,0,136,162,101,234,160,159,218,25,60,53,210,13,16,241,183,104,48,177,18,5,62,148,252,10,169,234,60,24,59,24,37,45,109,0,17,22,4,43,17,51,240,127,247,169,248,15,200,219,83,64,43,173,44,237,140,104,180,64,35,221,202,25,0,53,142,45,138,165,124,180,197,18,248,116,130,9,93,198,77,125,183,3,147,193,222,129,9,25,194,53,129,188,114,60,193,228,210,84,3,139,143,223,163,76,135,14,86,112,211,216,167,63,105,192,218,242,219,24,100,177,189,219,128,131,223,192,
44,168,49,218,156,32,123,202,160,33,35,250,176,176,167,131,16,123,196,170,152,201,169,108,206,47,175,186,42,24,192,191,60,113,129,122,66,149,186,192,135,9,167,131,44,8,34,17,148,136,65,109,29,228,53,52,62,150,3,19,219,192,216,21,40,89,88,15,51,104,126,63,38,146,15,175,202,197,120,131,99,67,88,19,197,46,73,161,199,173,214,90,68,251,186,131,26,154,153,116,106,4,19,127,28,108,69,180,201,253,110,168,45,220,200,165,30,233,105,19,153,129,49,72,167,53,76,11,157,130,161,186,76,57,122,176,232,251,190,154,72,81,32,176,69,93,122,56,219,65,138,48,37,227,208,192,200,194,2,254,140,156,106,81,94,44,250,39,144,236,118,241,181,137,53,21,225,38,101,148,148,186,160,65,34,250,136,212,172,113,203,248,233,192,95,202,7,142,31,186,217,46,240,116,130,182,237,133,30,86,86,7,216,66,131,188,76,148,184,169,88,140,108,1,194,171,184,185,66,249,97,178,37,88,10,36,181,78,156,124,168,78,169,229,0,97,84,130,57,33,172,113,86,118,248,72,112,156,33,131,131,125,16,17,216,212,215,53,200,176,27,101,168,130,35,242,105,
33,227,137,143,40,169,22,44,161,38,17,217,233,56,41,72,132,81,115,78,177,52,2,2,176,10,115,30,11,164,179,100,212,98,48,209,202,79,118,48,65,179,186,81,17,200,20,69,106,48,9,193,193,214,75,34,214,228,5,153,45,214,122,176,72,186,138,38,150,45,36,226,160,129,147,241,169,0,89,28,36,172,88,169,70,191,92,56,68,24,240,127,191,143,255,211,191,251,77,129,208,86,162,170,206,123,101,19,199,14,1,21,21,105,74,182,117,185,177,248,32,20,22,212,160,10,88,81,53,146,98,65,118,253,13,13,214,8,226,102,105,99,28,164,146,82,180,115,102,137,64,181,152,87,146,74,7,77,117,180,113,195,146,86,79,3,9,128,128,179,24,186,28,218,58,118,91,169,159,145,116,233,228,98,203,239,8,112,139,164,162,26,200,132,222,1,168,31,20,184,76,144,215,218,193,108,224,59,95,86,124,119,55,173,194,9,180,114,165,79,131,1,166,83,56,187,28,26,249,140,224,40,175,107,129,57,2,170,46,194,137,229,86,99,159,14,31,77,23,158,76,136,75,15,100,29,67,98,123,153,22,83,224,48,3,24,40,26,233,212,65,14,175,31,97,107,119,57,187,198,255,247,105,211,
107,164,224,74,171,4,205,45,130,35,38,18,113,139,103,58,154,219,25,248,91,34,3,72,11,144,75,157,117,117,110,247,231,45,203,19,230,12,128,102,32,157,92,25,100,171,50,133,70,7,245,28,166,245,12,42,85,171,112,158,48,208,75,7,48,112,120,210,169,171,131,17,211,42,73,46,105,171,225,79,107,247,239,82,130,45,79,57,29,4,158,228,220,254,51,173,2,75,67,25,4,65,49,228,170,234,60,192,59,58,118,210,169,28,63,35,243,102,219,141,15,69,249,189,203,96,180,131,100,37,242,123,247,132,18,151,255,63,70,240,253,64,85,98,254,3,185,208,138,57,132,128,154,206,163,3,40,94,121,80,176,144,81,115,194,144,80,59,22,156,145,130,93,251,229,29,242,224,40,150,221,140,191,17,219,236,58,11,168,4,190,14,5,73,35,2,190,62,227,230,190,227,91,62,24,129,34,68,58,128,128,69,107,48,245,208,211,27,129,149,154,88,250,194,150,146,98,231,22,16,74,227,203,41,137,194,77,165,42,13,97,245,141,213,102,212,60,248,237,186,121,75,5,188,53,195,7,134,164,192,173,170,51,66,77,28,59,52,244,115,188,200,63,87,218,234,207,220,112,131,9,84,
89,68,153,181,95,57,100,151,15,227,36,146,242,71,82,236,92,26,81,109,169,58,213,174,15,249,216,173,128,4,250,129,16,238,10,142,86,88,162,157,71,171,159,146,236,82,59,211,66,34,22,66,195,248,207,36,82,105,164,163,124,77,102,32,14,41,112,128,24,133,144,209,85,187,221,159,183,136,69,19,29,174,91,167,222,247,15,28,58,249,126,5,37,255,250,128,223,69,233,247,111,25,244,123,195,216,226,239,131,177,165,95,56,169,95,17,198,191,77,176,191,49,76,255,192,193,254,179,136,250,198,185,221,159,127,159,64,83,223,239,34,179,191,16,64,255,192,65,191,148,204,207,185,149,239,23,11,144,11,52,8,183,240,61,189,121,92,208,41,198,178,156,239,216,162,48,34,240,74,59,216,210,252,235,252,114,171,103,62,18,209,119,78,46,138,169,107,244,72,35,10,32,177,90,227,134,140,56,16,21,110,236,122,204,98,215,36,208,11,77,14,200,172,241,84,56,250,99,1,71,248,209,62,59,25,65,214,113,96,23,88,110,137,34,11,152,88,180,5,91,44,80,2,199,98,226,140,29,88,64,240,180,133,171,52,248,144,133,181,102,131,87,214,128,219,227,79,56,
177,160,177,5,56,187,202,72,148,22,56,179,8,55,224,120,226,160,181,77,20,168,176,91,29,200,66,128,179,74,3,25,77,4,2,154,106,212,174,146,146,142,198,105,11,86,242,196,104,223,203,80,192,79,231,94,6,7,16,124,0,228,34,5,233,176,224,169,20,188,202,130,143,186,96,103,64,221,33,23,84,17,132,11,103,17,0,71,220,220,162,72,7,85,104,232,49,8,55,16,120,197,147,64,26,193,90,180,85,59,121,85,26,11,28,180,86,82,107,103,193,46,129,132,144,148,249,65,58,113,38,17,107,236,54,35,252,85,32,14,216,109,153,112,86,141,170,154,117,224,211,32,176,227,85,157,199,111,59,147,11,50,162,215,52,96,60,0,4,86,147,144,42,62,196,216,149,20,148,147,14,120,43,67,94,186,9,86,101,130,160,55,157,8,223,179,168,147,175,227,56,200,223,175,204,191,164,141,63,125,65,46,105,5,67,218,141,209,54,72,169,117,18,69,94,14,172,113,198,211,29,0,219,35,236,236,66,152,112,41,38,124,53,14,169,241,100,139,91,104,227,76,7,229,143,91,180,217,37,150,93,75,134,91,220,92,16,66,116,28,220,129,180,233,128,37,92,41,240,36,208,162,5,54,58,
252,207,224,2,36,157,21,97,172,9,199,174,146,5,14,38,4,40,95,225,48,212,46,73,21,136,131,56,203,206,233,128,3,22,22,4,74,1,124,20,30,109,228,82,189,174,164,56,179,101,39,156,133,60,193,81,199,185,133,152,114,217,71,1,115,78,82,178,200,206,45,110,248,115,65,15,26,17,190,17,138,242,61,10,0,244,155,150,86,127,46,36,213,57,33,75,96,107,48,146,87,103,13,110,32,139,0,158,42,16,50,208,224,194,19,206,176,194,71,125,145,63,14,178,176,144,133,236,56,179,150,134,168,167,188,0,98,65,49,101,36,74,131,33,113,8,33,16,99,58,146,18,206,167,14,28,88,128,15,50,11,192,193,97,17,97,194,65,104,225,19,19,100,245,157,16,81,34,181,74,176,85,167,159,145,40,138,197,71,199,138,18,72,42,4,234,37,47,52,240,193,34,35,110,100,68,46,240,241,84,45,112,3,193,198,234,145,203,173,74,208,51,156,240,112,227,22,56,243,54,157,109,10,200,146,20,14,44,220,231,48,206,164,131,6,211,8,13,214,36,34,187,202,103,141,133,188,104,165,207,72,13,140,131,184,137,51,158,96,130,76,56,23,224,34,150,193,111,1,188,153,138,48,177,128,
144,139,55,2,41,160,19,129,38,216,89,83,5,25,69,30,103,9,139,5,182,242,84,141,196,226,15,38,14,226,131,131,59,165,24,133,143,27,91,126,239,137,129,52,212,20,156,73,237,230,69,19,194,185,154,250,228,98,13,114,224,207,186,177,19,206,107,90,80,108,217,201,209,159,83,132,155,119,168,202,230,181,130,137,13,156,40,41,64,236,0,51,69,148,44,53,24,9,182,80,3,50,144,180,141,195,162,230,226,105,159,39,72,135,56,242,71,121,208,244,52,3,10,31,16,184,8,196,142,69,7,159,112,140,178,224,3,115,214,110,105,126,79,54,152,227,175,112,156,225,0,2,33,110,215,148,20,35,187,154,40,165,224,150,3,162,201,135,134,24,166,147,203,214,5,85,112,236,115,82,90,145,23,11,200,86,22,251,133,154,159,157,34,84,148,175,198,244,43,2,25,14,84,4,172,216,170,34,38,1,139,29,48,208,152,25,60,201,136,3,61,5,182,157,113,136,54,91,126,66,181,54,104,148,140,255,95,58,55,54,110,76,47,25,81,210,134,68,250,50,98,1,138,140,228,178,173,127,200,164,128,33,58,168,47,114,64,97,252,89,195,83,135,69,22,33,164,53,18,216,41,95,157,37,54,
157,190,0,139,20,188,226,76,34,82,179,86,141,46,61,210,1,8,20,132,133,204,90,35,42,55,251,112,96,23,134,236,138,103,170,127,72,7,154,123,52,84,47,200,112,32,16,64,78,138,248,8,10,11,118,136,217,41,82,106,59,45,76,136,253,134,216,214,252,243,118,190,136,241,27,222,248,162,199,111,126,190,207,187,245,101,208,253,202,230,247,61,145,223,68,173,175,135,252,27,34,160,90,153,26,117,10,68,195,170,173,218,49,178,128,54,172,88,192,150,5,189,67,64,49,231,150,112,182,108,67,169,206,178,77,103,210,192,36,138,116,106,122,168,57,245,88,200,232,38,117,115,133,153,236,10,17,91,68,3,135,241,35,41,56,232,6,31,157,59,4,100,157,193,183,0,60,221,201,17,14,41,128,18,61,104,144,5,59,70,156,173,20,202,14,37,237,178,37,50,44,220,112,191,63,34,65,58,41,166,90,168,162,170,239,235,128,171,24,32,77,3,60,149,93,211,226,7,139,8,18,80,82,164,133,217,202,199,86,181,80,120,180,79,64,202,4,159,94,184,178,99,9,108,113,152,211,229,182,230,151,14,245,14,246,250,154,95,58,228,87,2,177,122,126,194,25,98,144,36,47,248,
122,27,69,82,140,74,135,39,91,220,34,11,73,93,109,185,101,139,234,180,176,125,17,32,254,225,102,43,218,224,43,92,205,34,132,2,137,226,149,44,56,144,215,125,232,217,89,237,96,248,243,91,86,168,130,95,169,52,34,248,214,175,84,82,105,183,234,10,242,58,24,110,224,144,20,28,169,199,171,37,243,191,170,212,158,125,144,225,111,223,65,220,138,160,161,73,75,255,253,40,253,234,26,4,123,252,10,41,46,170,107,231,232,131,92,170,145,138,224,192,173,95,47,220,33,87,115,105,171,90,0,121,56,211,107,62,52,186,12,105,10,118,118,241,244,107,34,125,193,211,30,174,80,223,60,164,243,132,9,243,165,179,250,11,86,51,38,40,122,196,173,218,4,20,107,8,80,136,95,118,28,176,163,39,90,177,197,229,74,225,142,10,91,170,136,87,162,120,37,5,228,185,236,48,99,199,168,188,208,32,132,91,113,248,159,140,7,36,105,22,151,237,157,157,210,127,31,64,243,143,16,73,154,145,222,217,209,245,107,1,165,137,60,178,176,5,26,5,218,131,153,145,22,227,67,20,58,232,48,162,0,185,212,2,6,134,161,213,92,201,14,50,66,185,28,50,210,11,117,
89,189,243,147,218,133,5,156,217,16,13,156,153,4,114,185,14,42,80,104,108,185,163,110,213,230,225,192,51,129,95,173,214,199,252,249,251,32,115,100,26,153,201,1,28,52,13,6,165,145,130,87,208,128,213,84,184,26,106,30,252,178,132,27,74,132,64,149,40,94,233,157,197,212,1,199,136,158,182,167,36,197,130,200,64,145,81,183,172,81,24,55,110,117,220,168,197,210,72,231,8,224,163,142,147,52,194,55,96,204,216,95,126,210,224,71,199,124,246,208,47,201,225,131,71,148,249,21,181,252,202,29,62,93,240,251,115,248,55,200,173,12,61,104,195,10,112,56,219,121,128,182,59,36,234,160,253,56,135,51,14,58,173,44,212,53,170,131,167,134,7,7,234,5,153,93,248,163,57,206,20,254,111,254,206,239,225,33,138,188,56,195,193,174,9,215,64,178,165,93,183,239,56,147,145,92,32,107,23,127,186,73,43,185,21,85,94,73,138,133,11,14,32,227,195,46,5,234,111,22,149,50,100,44,44,183,225,134,134,159,157,44,88,68,79,141,99,45,31,48,21,174,91,236,92,81,134,185,88,137,36,110,144,33,59,187,188,234,120,178,142,118,234,37,11,196,136,
34,5,62,220,170,41,20,136,167,95,177,220,170,34,178,3,130,63,248,34,143,29,4,162,52,219,108,217,103,136,31,8,185,244,199,115,74,10,2,73,21,78,70,200,112,75,8,23,14,42,129,222,177,197,21,229,192,42,5,206,248,104,120,2,233,185,194,186,162,201,78,44,217,129,229,21,230,220,218,17,178,133,4,242,177,90,17,136,8,182,53,26,57,201,136,29,52,214,194,231,22,28,65,65,155,45,213,139,157,68,224,160,39,51,195,90,187,220,146,69,254,248,224,32,180,192,2,45,20,62,118,151,117,107,19,2,37,170,38,23,52,120,197,1,124,118,59,249,0,73,129,157,193,192,1,145,245,14,210,208,215,68,118,161,65,20,28,44,61,194,185,133,170,152,171,11,100,193,147,75,52,96,197,174,110,113,240,59,32,132,203,31,103,242,226,38,103,216,226,204,45,121,217,10,53,118,160,196,185,151,185,37,22,55,62,66,132,25,194,184,113,181,48,82,179,16,25,66,36,59,175,88,8,17,108,184,113,230,150,116,92,248,187,79,96,236,74,33,218,180,0,28,181,0,79,68,224,86,60,5,142,191,173,2,187,146,42,145,248,99,97,0,44,43,193,182,243,85,161,99,210,212,232,79,184,
164,6,16,127,144,9,20,136,159,127,43,39,145,248,203,89,26,66,204,54,49,202,32,227,35,146,146,130,53,172,164,179,31,49,183,64,109,249,117,141,210,24,21,182,80,73,181,184,234,97,17,97,118,161,164,30,133,27,127,214,210,71,198,140,231,149,167,146,74,31,170,80,165,188,218,42,168,8,110,20,142,63,23,133,219,39,143,242,170,118,182,116,4,88,184,205,101,23,139,134,13,88,116,0,13,11,248,248,131,96,223,65,194,140,93,207,118,248,68,251,230,74,8,86,31,9,14,14,177,46,79,28,44,49,192,89,131,64,163,121,230,224,102,27,215,194,112,128,0,187,32,112,177,86,172,144,113,198,2,55,244,199,78,249,172,193,17,13,162,228,134,79,90,162,129,192,86,184,193,201,248,23,97,18,145,133,140,132,147,130,236,74,132,197,42,64,81,184,89,38,90,96,65,141,191,172,136,167,144,144,85,32,177,44,92,13,185,133,182,21,42,35,159,67,210,249,137,71,99,243,105,228,113,243,65,133,63,46,79,255,231,30,212,136,200,48,148,188,208,80,105,76,59,118,118,229,192,92,169,53,170,23,125,168,221,190,167,176,21,56,84,182,156,134,127,231,169,235,
14,48,176,238,73,116,15,32,91,182,29,210,83,29,196,46,194,90,216,177,76,245,125,1,159,214,6,135,170,65,211,45,58,144,148,75,45,195,8,62,79,12,94,65,198,40,41,42,26,127,44,54,5,32,236,162,15,8,238,123,74,90,169,253,42,133,191,4,7,132,164,246,16,1,171,81,65,115,43,105,11,223,224,65,140,40,210,217,16,253,104,157,91,240,217,210,36,115,43,170,112,35,17,183,108,177,80,46,63,38,42,196,253,33,39,254,232,131,191,68,0,4,74,98,133,179,69,99,97,249,144,151,91,77,5,248,232,9,73,9,200,86,184,217,205,248,9,5,135,164,98,174,138,200,11,37,173,217,5,153,116,110,59,252,138,34,214,202,75,21,114,198,98,163,192,23,200,95,150,143,104,56,227,22,97,62,87,128,192,129,141,50,100,100,135,24,80,188,74,100,140,146,11,113,84,56,22,162,252,24,166,154,87,99,192,22,254,204,63,169,185,164,131,180,101,77,57,228,82,184,21,71,117,169,64,5,98,17,26,62,56,219,35,15,32,133,176,203,197,81,85,155,88,131,76,56,110,226,204,66,117,1,194,174,43,117,180,1,212,224,17,37,25,137,213,179,130,214,11,135,68,164,198,168,211,1,72,
90,227,193,86,90,84,69,134,146,133,79,46,183,16,97,194,7,26,172,109,9,172,49,218,57,97,173,25,208,144,195,10,28,88,97,167,83,127,153,93,110,120,170,46,100,33,17,15,67,2,169,14,35,128,202,136,206,164,192,31,7,178,163,128,90,137,27,107,236,202,139,63,183,126,99,105,187,38,124,194,201,8,73,53,90,56,228,82,165,25,60,119,176,114,251,72,184,109,55,76,208,28,26,248,128,201,130,203,178,181,69,165,213,23,162,128,162,215,232,64,57,148,38,158,42,202,134,227,0,2,108,177,83,23,69,225,41,205,21,50,192,224,176,11,31,14,8,28,32,195,58,194,247,25,190,65,208,45,134,126,103,7,127,82,160,42,158,126,243,0,13,248,144,75,243,169,214,40,175,164,35,86,204,53,168,56,0,66,10,248,240,42,100,28,112,6,74,253,21,165,112,227,64,58,42,82,45,44,8,113,193,165,6,85,128,6,44,149,82,59,62,170,75,98,130,70,8,22,114,177,133,27,118,110,89,67,137,16,98,137,98,30,88,224,169,63,155,214,31,190,96,193,129,236,68,9,89,58,16,203,22,175,126,66,9,156,26,113,163,40,189,131,227,38,132,114,62,14,105,105,226,142,183,136,1,5,8,108,
195,77,58,73,33,216,138,190,223,246,227,71,82,158,100,164,112,18,65,9,16,200,184,237,86,8,196,252,244,199,162,122,81,131,40,220,120,5,74,234,69,248,134,36,202,20,136,51,114,89,145,197,19,163,68,248,75,133,53,192,122,68,168,65,98,14,37,98,161,193,43,118,208,192,132,9,175,84,164,66,116,120,225,134,81,149,254,55,121,137,37,17,45,3,95,114,177,134,0,246,80,51,24,220,98,231,98,129,140,216,37,139,26,129,61,204,121,200,119,52,115,37,62,248,107,65,45,128,179,14,172,154,122,177,147,136,63,37,167,167,250,179,114,0,49,82,154,118,121,165,112,198,213,61,68,96,130,70,83,240,228,42,101,62,110,69,27,31,214,110,56,12,105,19,254,24,59,249,20,35,22,122,156,47,165,104,109,236,24,73,138,27,183,130,34,35,129,212,107,19,69,6,52,136,16,170,67,13,2,137,226,21,28,22,32,147,151,91,178,224,131,164,82,21,181,217,165,34,28,196,42,157,147,40,217,1,193,89,107,156,185,229,21,86,148,64,46,160,192,244,163,129,81,229,48,45,26,39,129,16,194,22,132,217,197,130,242,172,213,41,44,240,113,103,82,33,24,133,160,129,228,
86,177,238,129,133,158,31,178,110,225,12,85,50,178,8,115,100,108,225,27,9,236,168,4,121,16,72,39,113,164,76,184,177,200,65,66,65,35,218,39,5,206,192,226,137,197,173,81,21,177,197,172,98,39,16,161,196,25,2,68,97,39,157,196,225,54,213,170,253,90,38,28,156,201,165,90,168,14,28,110,161,7,154,104,67,143,75,143,74,149,192,45,169,253,116,35,74,239,38,226,38,88,94,9,65,10,144,33,12,44,22,129,147,8,79,110,69,85,34,144,37,220,24,85,29,41,68,73,206,244,20,11,196,220,201,132,185,170,118,229,74,103,246,36,130,244,183,221,20,43,120,138,18,248,44,184,64,102,203,29,9,117,135,45,24,178,37,50,118,24,34,124,143,211,140,127,80,71,31,48,65,224,178,42,97,4,92,34,68,27,253,83,21,45,112,170,109,117,8,165,9,180,90,81,11,137,192,116,5,76,75,40,10,129,0,87,3,243,10,31,13,6,109,226,82,143,176,168,59,168,65,22,24,70,27,124,141,138,178,96,148,86,228,85,153,42,132,64,66,192,231,150,53,139,180,152,176,165,212,246,205,154,210,184,84,11,187,169,214,5,19,109,145,221,79,37,41,131,131,148,193,193,22,27,101,68,195,
66,44,187,248,104,240,184,133,36,99,192,2,194,118,78,72,29,136,175,194,241,132,33,186,9,141,225,20,255,140,15,6,56,26,3,4,215,154,212,160,105,38,109,22,151,79,58,26,166,74,21,41,212,8,64,104,16,107,114,193,60,52,195,111,145,154,4,247,128,192,48,173,191,90,166,114,74,165,251,135,167,141,3,36,213,31,148,180,54,34,80,5,133,195,144,91,186,67,189,92,100,132,60,176,182,143,45,124,211,69,57,184,73,55,124,8,100,24,228,15,25,160,84,190,136,217,22,43,23,226,72,19,118,181,5,14,8,157,76,32,227,1,25,236,156,56,133,187,141,248,75,182,224,16,8,55,197,170,46,214,110,71,212,98,166,200,54,189,162,33,32,59,8,202,200,173,64,136,21,32,254,234,75,198,135,205,206,106,96,45,52,151,20,72,193,150,20,16,1,221,146,17,145,185,44,201,65,198,223,118,138,5,91,238,25,84,155,244,231,11,45,28,76,165,70,22,84,37,157,170,163,76,164,198,194,173,242,234,51,137,118,201,46,74,226,239,58,176,101,3,117,96,53,0,129,124,72,1,103,252,117,66,113,131,112,170,127,83,11,79,72,178,203,212,225,143,167,8,96,97,139,53,224,105,125,
29,195,1,170,20,162,5,148,20,203,109,32,165,114,190,158,162,27,33,200,75,129,144,84,34,119,72,224,32,7,117,28,122,220,90,207,64,100,137,140,29,55,133,64,67,195,12,147,192,112,220,176,91,37,35,204,45,22,26,167,231,33,154,171,5,194,132,161,82,168,64,29,55,252,201,194,235,223,45,199,130,179,16,44,165,65,73,61,2,208,142,1,12,185,69,40,60,249,186,7,13,214,106,168,149,157,135,176,237,20,26,114,137,45,200,68,177,75,136,28,52,174,226,156,214,121,231,129,243,144,79,124,183,59,173,13,26,207,64,160,224,137,155,202,215,195,74,12,117,84,33,70,94,202,129,188,21,182,145,175,10,124,244,189,85,53,138,24,104,28,106,44,220,2,200,179,209,74,90,213,247,215,195,72,151,42,7,165,38,151,96,105,159,134,7,73,173,146,202,34,197,192,151,29,134,92,132,35,17,154,16,101,237,44,232,187,186,131,63,62,56,88,217,117,238,240,193,152,126,249,242,129,27,104,90,179,112,143,18,70,87,7,91,181,171,60,138,73,76,60,85,26,124,8,196,168,89,133,24,107,66,84,2,41,168,87,189,38,86,181,67,149,181,160,112,83,117,16,227,177,3,26,
8,116,74,207,46,94,255,242,47,63,68,154,191,126,201,31,40,112,241,79,231,254,111,254,109,7,243,179,74,181,70,133,163,9,197,162,6,117,161,88,184,209,42,227,111,25,110,187,117,54,53,30,72,167,1,3,28,241,153,46,198,67,50,170,179,228,98,129,164,244,2,133,113,192,83,157,2,7,88,26,193,69,8,110,161,190,175,207,149,131,188,178,127,254,182,213,216,132,19,235,190,35,168,137,224,0,168,188,88,212,110,242,146,17,76,22,118,50,217,194,13,4,44,34,102,221,176,67,146,114,240,1,132,68,192,10,223,69,112,117,240,83,32,176,28,212,198,95,28,68,6,88,110,37,2,15,13,146,178,214,84,99,15,68,32,74,195,204,79,21,104,25,178,232,42,107,112,36,41,129,250,153,3,128,172,51,34,181,157,234,40,159,74,210,16,64,222,145,1,161,29,90,131,198,109,198,171,214,92,17,142,140,209,255,93,179,232,41,250,83,62,250,67,24,26,92,13,204,43,167,56,218,52,29,233,212,35,57,83,5,23,110,106,25,62,226,47,125,144,78,186,185,197,202,63,157,2,129,66,10,48,211,79,65,34,181,35,157,9,183,85,32,187,157,73,145,241,155,94,230,208,146,103,92,69,
0,139,216,194,68,221,129,149,53,170,198,192,193,168,228,27,15,105,66,72,170,84,211,81,128,164,236,162,51,23,157,165,10,61,18,219,25,77,32,192,115,230,47,207,130,100,209,19,9,103,160,68,30,64,247,201,175,20,218,130,176,22,16,86,32,52,40,92,71,85,187,132,51,3,58,215,184,233,225,144,86,45,48,7,144,171,129,97,142,140,172,145,154,94,68,27,89,8,135,128,68,6,31,163,62,93,224,102,49,241,23,121,209,96,203,62,49,0,36,74,135,26,31,55,29,220,240,4,16,182,248,80,69,69,51,219,88,40,193,15,144,153,199,194,22,158,170,78,14,104,72,32,175,220,2,40,134,170,157,212,146,232,49,19,2,7,124,112,144,167,42,178,37,4,246,75,148,196,80,239,182,32,64,76,22,114,9,28,28,248,96,23,103,21,5,37,56,224,201,22,22,50,242,32,34,23,11,180,18,7,65,177,139,179,44,64,69,248,6,41,35,239,173,15,249,254,77,58,255,116,93,255,182,157,168,86,6,80,135,197,77,36,233,160,196,164,41,163,10,68,58,140,88,244,80,149,116,238,219,1,80,236,34,38,181,224,12,97,75,178,169,217,82,165,108,145,34,240,1,174,112,118,41,95,28,144,17,14,188,
130,201,43,52,164,164,142,0,183,60,111,17,74,109,130,27,66,225,6,61,205,0,233,180,133,167,152,75,88,236,22,31,146,26,123,36,5,156,87,156,137,130,6,107,162,240,196,71,45,80,227,252,62,5,137,149,144,21,18,234,59,20,36,34,4,146,128,136,140,31,32,254,210,83,181,88,183,176,128,212,56,232,161,71,129,64,129,163,198,73,43,63,149,240,161,4,192,195,141,103,198,63,168,168,112,48,17,28,98,18,68,156,121,69,19,58,203,22,100,72,81,209,172,225,140,27,129,98,165,249,199,71,51,128,93,84,65,67,70,2,113,211,144,96,135,161,159,230,24,145,139,74,193,167,64,22,88,72,129,140,238,131,78,58,219,249,148,27,175,120,130,159,190,230,84,1,56,62,188,2,14,43,248,64,76,84,3,249,147,43,194,119,214,162,140,115,170,148,48,74,55,56,80,20,220,88,80,130,62,224,5,194,170,53,132,144,157,20,144,145,170,18,10,52,110,169,72,172,112,64,82,209,182,82,227,128,179,159,39,229,227,230,158,74,235,134,157,98,161,132,15,32,208,3,86,248,110,174,64,170,170,151,88,68,83,186,192,188,208,3,138,115,7,148,235,67,8,246,84,147,170,100,171,
109,3,67,143,216,116,120,194,89,77,135,164,152,251,125,56,209,174,36,133,9,5,138,140,85,210,175,251,129,197,170,47,184,145,139,222,137,140,30,17,212,8,50,243,169,201,135,128,104,96,87,148,59,129,174,8,202,14,32,202,99,119,57,192,208,102,4,92,173,193,71,243,201,46,210,145,8,59,250,131,64,129,164,195,98,117,203,200,243,63,157,191,208,197,22,191,153,132,127,197,246,136,89,232,175,154,223,250,219,230,230,141,30,26,238,185,131,88,58,67,158,206,48,35,154,218,141,20,128,80,8,175,84,103,229,85,81,24,169,151,53,118,22,58,59,146,133,45,26,74,32,89,168,157,91,174,6,70,40,105,197,46,81,56,75,40,64,184,56,137,225,198,147,188,108,169,95,136,105,243,2,18,109,28,104,10,14,60,181,96,165,209,130,0,183,56,99,177,28,92,16,81,82,115,89,183,51,25,65,11,60,254,108,129,67,44,131,196,2,124,48,185,136,210,131,2,35,107,219,116,106,132,188,160,228,198,26,7,203,95,197,194,16,59,158,108,105,98,193,209,135,46,1,114,30,45,115,66,44,85,36,130,3,77,33,208,205,37,50,86,121,101,1,89,130,144,139,64,72,42,10,100,
184,161,164,171,188,109,77,35,67,204,237,35,110,132,16,11,14,73,149,23,173,176,248,241,73,31,57,202,41,196,61,74,233,215,162,9,68,43,201,5,115,212,128,94,224,35,11,122,25,164,164,90,172,38,4,50,48,42,83,237,144,50,232,137,39,137,112,64,61,137,169,9,196,206,45,118,248,176,80,175,253,186,144,78,131,2,31,95,0,186,58,203,129,92,234,26,248,48,100,45,26,48,199,31,122,104,98,59,133,79,184,177,147,151,70,240,42,86,172,53,84,176,133,33,107,160,216,37,29,32,64,225,192,90,85,68,248,222,49,59,250,74,195,71,147,169,211,129,51,56,128,136,152,214,220,98,215,88,90,103,101,183,69,145,81,110,126,71,9,254,58,29,212,162,161,162,5,160,201,72,118,123,22,192,119,83,227,3,32,14,174,236,126,62,100,103,90,148,151,170,245,246,74,136,236,106,168,59,138,148,207,46,87,3,243,42,14,132,227,47,157,163,125,115,168,57,97,203,61,182,126,179,138,68,68,161,3,181,83,29,177,20,104,21,110,227,83,158,116,180,18,122,160,113,193,106,176,201,104,5,113,195,1,100,151,66,234,27,134,196,6,30,88,249,176,229,150,217,206,225,224,
42,134,27,91,228,69,79,191,214,176,37,79,118,133,134,15,11,216,178,64,1,46,177,197,34,49,93,170,126,89,40,31,62,194,161,41,246,150,16,208,80,9,218,210,153,91,106,140,240,141,162,251,70,201,239,221,26,99,222,239,248,247,86,252,53,102,189,223,69,26,97,9,129,134,109,55,183,18,31,98,154,85,233,73,45,216,241,132,73,170,13,194,174,64,22,176,210,97,17,73,98,97,104,1,237,100,226,233,78,17,81,88,52,12,106,1,183,126,217,241,177,5,70,25,5,240,145,152,40,131,116,248,75,210,192,192,112,131,79,118,117,141,212,196,42,145,66,176,0,66,21,136,160,45,36,229,2,202,109,40,34,96,145,26,140,177,31,72,169,128,159,195,219,118,163,73,213,63,255,40,94,204,177,19,5,142,96,201,46,88,200,176,86,23,224,233,102,196,159,246,209,53,232,161,24,177,173,76,55,109,155,16,10,31,171,85,39,227,172,116,56,171,70,21,66,118,82,176,165,68,174,254,86,10,152,16,229,54,43,220,88,32,204,217,116,147,226,134,51,22,73,154,234,168,216,92,194,135,42,11,113,32,220,237,8,71,140,20,0,234,41,202,2,206,18,135,45,178,80,126,250,167,47,
212,244,14,55,96,185,88,168,239,44,152,4,210,101,240,219,98,152,113,134,0,108,137,66,219,127,198,173,162,9,15,108,22,127,94,163,25,112,245,39,17,233,144,203,62,81,33,128,32,216,113,163,4,20,64,55,81,210,45,91,28,58,220,216,162,222,84,61,65,67,112,201,222,203,0,170,89,68,41,132,5,131,167,183,21,96,89,203,129,93,2,53,207,118,180,26,152,44,238,108,40,41,158,248,107,68,153,49,33,167,58,48,42,153,45,149,150,234,204,128,249,207,52,39,202,82,109,225,107,58,172,168,14,161,88,80,26,5,170,118,214,100,39,87,170,60,241,177,131,173,133,253,1,154,110,21,75,225,0,2,98,27,4,44,14,88,16,1,35,11,242,226,166,55,86,114,217,181,84,146,110,210,92,221,68,64,77,130,122,77,215,216,197,13,233,88,112,41,163,219,122,38,205,111,72,194,77,106,191,7,32,141,139,54,4,132,32,134,144,132,21,89,216,18,243,255,71,30,122,205,211,110,28,170,182,50,187,16,70,79,8,163,149,219,125,247,13,177,129,249,119,199,163,204,255,79,100,222,25,121,67,212,111,173,228,183,160,176,224,247,156,240,70,201,159,202,241,74,84,164,239,185,
33,205,1,215,17,80,47,108,179,52,3,208,32,53,186,73,79,117,10,35,22,94,9,161,245,26,12,2,213,17,60,177,112,43,218,100,193,153,64,90,192,154,40,218,202,26,99,224,99,144,145,195,199,238,226,76,211,237,84,115,11,25,192,33,44,206,228,194,66,34,22,140,95,58,224,226,38,79,94,69,15,14,228,226,130,73,132,9,7,33,202,55,207,18,36,144,18,225,218,162,16,169,100,7,21,64,33,67,18,74,160,233,86,108,185,117,63,45,100,240,89,45,16,0,89,40,29,89,96,165,7,90,90,98,82,14,189,230,82,57,168,106,27,106,249,195,80,176,129,53,82,160,158,99,240,71,97,29,112,252,37,178,198,128,45,191,3,75,153,128,131,102,83,176,230,176,147,26,139,13,79,139,51,5,82,154,180,205,184,56,170,139,212,196,42,139,16,52,42,36,229,162,124,110,33,204,2,74,174,164,24,53,96,24,93,254,220,74,22,189,191,16,78,108,132,137,101,171,161,79,127,249,208,86,178,83,41,179,4,160,134,13,11,118,37,133,36,81,88,120,133,158,123,106,176,32,136,26,4,127,58,34,134,44,8,103,23,254,106,83,58,186,133,6,121,53,124,224,42,150,16,2,129,146,26,220,138,3,53,
106,141,91,152,143,234,223,18,1,74,154,13,157,29,85,228,55,45,24,193,20,109,94,41,132,11,127,53,136,212,86,34,145,196,63,45,113,164,48,177,56,104,230,253,178,131,79,119,184,52,105,162,167,158,2,206,109,58,186,193,71,250,224,9,43,254,92,3,218,132,96,100,65,70,68,99,193,22,52,34,156,51,165,210,112,96,60,88,131,163,174,225,76,106,11,235,71,94,85,203,7,76,18,149,10,250,247,31,201,81,20,104,20,104,251,37,242,173,125,224,96,226,76,8,233,168,8,16,44,172,229,166,249,151,62,58,158,120,34,8,104,34,207,45,33,162,173,175,171,216,193,193,78,94,94,255,114,248,241,81,186,192,62,2,165,15,117,34,67,45,174,254,25,63,203,86,55,112,200,5,97,146,186,237,195,129,45,158,66,17,102,139,221,166,166,71,56,195,159,91,87,91,105,162,16,109,225,198,5,127,36,138,246,157,8,38,71,21,177,248,223,126,3,34,87,96,167,200,75,9,118,90,160,151,86,222,6,134,216,127,51,24,168,244,239,119,129,96,47,38,216,227,23,58,241,201,28,75,23,163,3,227,129,44,100,23,37,214,44,144,194,47,35,146,210,95,236,92,248,64,88,207,37,63,169,
177,83,20,175,248,104,236,221,39,167,2,221,217,150,230,72,1,56,187,104,165,7,20,22,214,106,125,69,179,69,58,182,48,6,182,152,19,209,218,57,32,224,180,48,242,18,34,64,205,0,104,16,195,2,184,14,17,125,137,54,183,42,77,4,216,101,225,214,69,94,2,245,201,22,123,132,113,192,167,149,65,3,80,3,99,211,249,133,19,75,20,41,196,92,82,75,73,140,154,1,248,52,54,62,174,92,34,73,120,32,37,182,162,140,63,104,156,50,28,112,179,200,16,144,176,122,130,225,108,57,19,229,62,154,232,50,129,34,67,20,124,196,86,39,87,189,232,101,236,236,130,211,214,228,18,56,73,241,199,200,150,116,182,62,72,193,229,231,6,7,205,33,175,246,239,146,233,151,186,71,155,223,241,206,199,84,254,104,219,126,76,229,182,159,249,115,13,254,116,3,187,124,244,177,150,53,70,254,164,3,31,44,252,153,56,191,99,135,139,63,4,193,206,47,0,212,223,64,187,245,251,216,249,232,107,138,210,88,106,246,16,10,194,180,3,254,178,88,145,209,159,145,80,199,241,209,195,147,186,108,115,237,44,97,164,173,60,108,153,34,225,248,137,140,17,31,240,1,39,74,
79,48,121,18,200,22,118,101,79,21,188,178,243,254,104,113,208,156,57,68,88,129,131,3,85,8,83,145,223,16,90,158,225,38,23,158,244,20,79,165,38,47,11,117,77,148,72,193,46,200,92,226,134,67,57,31,67,214,184,169,10,162,112,8,53,91,170,157,45,228,13,243,17,134,36,62,10,81,129,32,99,212,168,91,241,197,80,118,185,17,197,173,152,240,138,81,125,177,37,171,22,2,177,243,54,173,188,120,146,203,213,33,194,55,105,13,12,90,170,242,242,199,142,4,10,74,179,33,112,203,1,76,157,2,220,84,142,123,40,36,166,200,43,208,190,207,218,146,9,4,89,36,33,76,225,209,62,89,36,133,20,192,95,90,233,184,249,213,2,8,82,83,2,8,56,200,25,163,159,91,152,41,7,35,84,217,149,27,107,66,32,128,133,212,116,150,139,53,118,0,89,128,73,200,223,237,50,129,233,52,209,170,141,27,224,86,67,104,32,23,22,21,34,86,174,254,116,141,16,174,54,62,193,241,177,98,74,234,244,83,71,59,245,250,41,32,193,49,130,201,208,202,147,87,248,96,65,22,125,106,66,25,18,145,133,45,66,184,36,17,175,218,194,142,115,184,241,129,60,77,231,86,69,217,3,78,
56,22,119,32,201,75,117,122,250,101,252,131,16,81,224,3,203,165,86,2,139,17,124,158,201,88,184,69,94,110,173,230,154,40,236,24,43,155,215,104,231,232,165,234,22,120,16,148,66,111,13,110,10,68,160,88,53,142,87,125,78,102,129,98,132,88,137,72,205,155,2,245,218,230,114,43,197,252,236,132,96,193,223,37,41,31,212,83,184,110,37,93,3,227,44,74,196,226,67,131,132,156,106,105,85,141,191,165,65,8,185,196,156,53,156,129,226,21,170,216,185,162,140,158,218,226,54,85,76,66,236,51,31,31,235,140,8,234,8,70,48,3,27,71,94,13,97,47,223,176,101,112,18,44,189,22,127,53,156,146,34,131,176,240,132,15,156,33,6,97,110,255,178,4,149,70,249,146,142,64,180,197,40,73,121,38,48,30,122,12,34,139,190,11,176,139,143,82,16,21,109,222,191,116,107,235,146,236,50,242,154,78,8,91,126,159,88,16,83,33,100,228,109,66,37,48,24,24,237,108,144,20,187,196,183,237,195,95,15,100,56,115,233,248,43,144,91,66,240,20,50,11,84,18,43,65,81,35,179,193,26,4,118,185,85,32,175,184,81,38,7,150,88,118,201,130,167,114,177,133,209,254,
124,21,31,41,3,55,64,80,35,240,211,81,71,243,241,134,79,68,252,16,143,191,221,193,167,29,62,249,232,7,122,157,61,143,95,101,204,7,158,209,198,222,200,172,217,226,195,143,254,54,8,191,132,80,191,135,144,91,2,177,227,204,130,63,44,99,225,231,137,29,4,126,108,40,59,255,239,117,72,74,174,236,153,110,253,169,34,226,136,36,79,27,106,161,240,146,134,188,122,13,121,110,109,35,40,159,50,37,11,53,178,197,90,2,202,95,170,2,2,38,187,157,125,79,51,158,39,220,146,14,103,165,67,79,214,106,16,81,220,162,18,62,92,77,205,45,187,154,64,82,216,55,26,165,115,83,11,4,134,209,38,138,112,145,4,25,216,222,134,33,198,82,230,123,4,22,178,67,21,139,254,31,63,253,45,134,128,16,72,34,64,52,114,169,230,114,9,19,210,192,71,3,121,237,193,105,107,64,52,156,130,165,16,205,88,90,33,110,222,22,38,28,139,10,180,200,22,10,137,160,129,29,88,216,90,109,219,25,254,216,149,75,152,20,245,183,116,192,95,141,96,193,252,144,66,199,132,91,248,112,75,227,32,128,17,55,53,151,173,80,223,145,97,13,37,220,216,101,13,7,116,128,15,
158,172,17,86,7,150,133,200,99,15,115,74,96,138,82,29,90,98,149,81,4,184,149,2,80,82,10,169,77,70,144,193,20,55,9,72,31,197,196,118,22,40,53,215,110,201,211,74,141,255,223,18,13,28,219,133,214,166,52,149,12,14,76,152,112,72,146,157,91,91,53,107,146,234,22,31,252,89,83,5,151,85,85,213,41,176,151,177,19,101,201,107,74,65,38,220,38,34,150,53,124,176,235,49,165,45,74,211,45,60,111,61,175,66,60,254,227,181,74,136,23,17,226,149,12,241,90,133,120,125,67,188,126,33,222,8,115,59,32,196,27,18,226,141,9,241,134,27,75,76,136,215,59,196,27,104,182,42,154,215,71,29,255,74,33,222,176,16,15,159,71,66,188,254,62,4,112,64,0,57,58,196,235,19,226,1,56,210,135,134,241,113,179,11,8,198,65,6,42,220,56,15,245,185,129,131,27,129,128,140,10,241,6,155,91,139,169,5,233,184,196,4,231,94,6,135,45,252,169,133,75,81,237,140,15,52,40,7,183,166,190,212,128,227,3,115,140,236,226,140,133,181,159,127,43,83,154,116,96,23,182,80,82,44,70,52,172,234,211,176,113,136,135,56,148,160,146,113,254,187,90,1,8,121,148,164,
10,4,151,8,100,196,66,70,94,193,4,159,146,85,14,37,179,176,173,17,43,180,197,19,35,213,73,85,68,38,138,54,225,144,170,158,169,230,77,75,79,156,1,65,46,196,103,13,37,210,73,106,94,225,35,2,236,178,166,16,118,229,47,242,24,113,131,27,85,160,94,53,159,122,15,25,79,236,40,128,39,217,161,77,56,151,13,151,158,205,140,5,31,109,201,153,64,50,138,9,248,90,96,97,151,112,6,155,133,203,156,212,213,125,169,35,141,212,16,99,24,192,17,96,90,217,219,24,64,82,227,134,15,152,132,32,44,128,53,124,128,173,141,17,26,56,164,143,22,101,208,224,201,133,32,202,14,56,173,135,12,204,65,96,75,147,144,78,235,25,18,156,53,0,80,186,207,228,109,107,164,118,39,161,131,73,1,14,137,212,29,232,201,13,139,166,37,85,159,6,134,30,12,229,99,111,109,184,155,5,100,106,135,12,187,160,217,91,24,194,19,161,106,250,132,98,151,78,169,64,73,58,192,20,242,63,121,242,64,9,221,148,157,20,210,214,157,1,232,165,35,41,91,16,198,31,134,112,227,149,91,234,146,2,236,170,251,106,77,90,39,139,64,162,200,206,133,122,226,192,52,18,203,
45,23,28,72,1,213,97,102,23,7,82,96,116,27,138,98,181,124,138,181,50,110,246,65,173,99,130,179,122,10,8,177,161,190,163,129,49,204,88,42,154,215,84,201,192,156,210,224,128,51,124,144,75,207,73,104,235,212,192,7,99,58,135,218,246,87,122,130,38,11,8,178,232,150,210,192,39,17,229,212,246,149,19,56,0,255,63,84,132,92,144,84,225,48,100,77,141,20,11,97,4,100,23,194,110,199,241,113,107,100,11,55,44,116,141,247,68,42,10,55,149,186,243,6,160,173,87,187,46,2,187,228,2,7,31,194,193,39,22,11,169,41,95,124,2,57,208,32,129,88,100,148,188,215,167,100,171,63,15,134,72,2,165,217,35,196,206,6,41,148,29,31,37,13,51,28,52,36,184,225,140,56,140,40,172,88,171,137,244,142,236,204,6,225,44,84,59,91,154,28,220,20,5,37,62,84,84,246,177,234,96,202,129,3,199,132,116,248,255,99,98,146,133,188,98,8,7,82,255,51,122,246,99,79,103,67,73,35,7,49,9,66,119,224,233,170,161,68,226,239,30,147,244,165,80,177,40,204,66,154,32,75,89,51,255,220,90,14,93,254,62,7,14,35,176,116,132,30,49,51,18,65,228,211,207,213,240,175,
114,81,41,56,104,139,200,44,42,25,145,133,76,225,128,167,85,190,250,110,139,106,144,129,68,208,166,4,94,233,41,41,0,215,25,196,200,248,97,135,3,70,245,157,5,125,129,88,58,15,34,184,225,96,143,30,33,60,9,249,56,193,236,129,166,182,90,180,118,127,126,220,53,245,73,234,166,70,91,116,150,133,51,66,141,143,198,12,231,43,57,95,226,251,62,194,31,202,241,253,188,114,207,17,49,56,232,191,158,189,134,81,139,231,165,164,164,148,232,217,107,224,127,214,253,122,83,212,191,125,250,13,31,123,107,157,147,255,245,236,55,156,3,229,121,65,90,87,253,143,207,224,65,252,17,136,87,166,223,144,193,35,6,71,15,234,91,181,239,224,62,119,99,248,79,222,42,190,188,38,246,31,230,189,133,8,135,191,147,183,170,47,239,173,234,255,105,189,183,42,254,155,121,171,249,242,26,206,127,81,239,243,79,77,184,133,255,191,208,185,186,47,111,70,116,78,43,239,223,215,57,166,114,207,152,65,125,218,199,49,75,7,82,142,123,119,60,216,180,69,83,47,8,14,65,183,134,37,229,48,63,247,201,20,28,124,235,226,191,16,174,204,89,51,103,
14,9,201,156,61,75,150,219,178,230,204,158,51,103,142,236,57,114,228,186,61,239,29,185,110,207,115,123,142,28,119,228,191,35,207,157,249,238,186,235,174,156,185,11,20,204,159,175,96,222,124,119,229,187,5,18,148,137,152,144,204,217,50,103,206,150,47,87,142,92,249,254,246,127,41,95,122,121,178,6,189,29,116,60,83,80,41,47,56,79,80,166,60,65,41,155,189,18,240,204,28,100,254,187,85,250,173,255,130,130,225,120,91,150,172,217,178,231,192,97,197,29,94,112,80,166,76,193,33,153,110,177,102,247,73,246,189,144,60,153,243,222,93,165,193,109,119,182,143,206,82,234,177,124,85,159,158,246,110,214,210,13,63,217,112,87,135,239,226,203,84,235,53,108,124,182,236,249,11,20,44,84,184,236,61,229,66,195,202,87,175,81,179,86,237,123,239,107,212,184,73,211,102,205,91,60,24,25,213,241,161,78,157,187,116,237,221,167,111,191,71,250,199,12,24,62,98,228,227,163,70,143,25,251,204,179,207,61,63,225,133,23,39,78,127,229,213,215,102,188,254,198,155,51,231,206,123,111,254,251,11,22,46,250,224,211,101,203,87,172,
92,245,217,231,171,55,110,218,188,101,235,182,175,190,222,190,231,251,189,63,236,219,127,224,224,161,19,39,79,253,116,250,231,51,191,252,250,91,194,197,63,46,93,190,114,53,241,218,245,91,117,5,121,153,84,22,175,169,214,149,135,186,130,67,66,50,133,100,185,85,87,80,240,168,91,133,231,9,201,124,119,149,219,242,54,104,159,37,250,177,59,75,85,125,58,107,190,134,211,222,253,100,67,182,210,213,58,196,223,213,107,216,119,217,243,151,169,126,162,108,194,173,210,76,101,25,43,108,252,63,170,204,22,246,159,186,14,121,57,51,5,209,188,76,121,248,127,133,125,51,114,238,196,196,215,147,179,183,124,55,246,161,248,165,207,156,95,87,54,169,114,194,75,107,230,231,42,186,240,135,17,147,138,76,184,56,255,169,188,141,199,87,206,26,114,231,31,197,79,45,29,224,221,24,48,49,113,226,217,228,236,21,79,252,124,115,98,167,147,163,63,123,41,119,190,93,119,198,188,184,32,124,226,158,247,223,157,242,249,225,253,133,174,45,91,85,226,185,152,184,13,181,235,84,76,104,219,33,49,54,197,187,99,92,216,232,109,221,
247,45,185,252,113,155,183,230,15,40,144,251,244,225,110,111,23,219,89,36,232,143,188,181,235,78,120,208,187,17,49,49,233,200,205,119,146,235,142,222,120,53,57,123,163,132,81,155,138,151,78,152,245,110,185,167,47,117,235,222,230,100,177,122,215,207,221,156,190,183,89,29,175,102,110,47,180,223,182,57,53,174,236,223,180,244,80,163,19,83,183,44,238,208,189,214,198,226,53,247,212,248,177,97,217,35,251,246,125,159,252,71,241,119,219,100,75,10,205,180,167,255,194,223,35,74,45,31,223,226,204,180,187,159,175,17,113,177,249,134,142,81,35,203,204,26,191,118,65,114,225,239,143,159,73,42,91,63,254,165,20,111,227,87,241,87,175,108,61,191,174,217,225,2,133,14,175,185,112,243,232,172,75,65,103,163,58,246,94,212,53,98,214,144,157,223,148,218,220,228,76,145,119,78,237,200,115,234,254,85,35,182,222,187,179,95,226,192,173,201,197,18,102,182,185,126,219,154,5,3,99,130,114,84,136,185,218,162,246,228,89,79,175,124,101,162,119,120,238,231,151,19,159,59,49,42,161,92,82,233,29,39,43,134,173,56,127,56,
110,89,230,159,250,157,185,127,84,239,29,223,158,59,127,102,65,155,129,115,230,4,79,188,54,233,202,193,155,31,103,57,247,253,156,152,174,245,39,44,63,177,52,169,113,66,209,217,253,190,27,177,126,109,142,233,249,238,95,88,114,218,140,76,153,10,149,91,60,58,95,253,79,183,157,127,229,212,23,197,227,238,28,88,162,248,212,231,99,27,140,126,126,100,252,205,23,30,27,146,237,240,197,102,159,55,207,113,160,104,216,134,93,21,247,62,53,110,74,251,158,89,198,109,62,182,162,231,150,39,219,158,188,242,69,124,228,169,154,211,35,234,52,153,251,97,120,143,187,87,78,125,180,195,171,219,118,148,206,253,218,155,27,142,204,127,224,171,44,229,179,222,123,99,224,150,226,149,190,171,115,231,252,122,243,151,254,182,111,108,141,241,69,139,76,250,117,95,153,111,171,77,254,164,80,157,17,115,114,141,173,176,179,78,208,141,7,99,43,38,46,88,88,164,68,246,196,179,77,246,13,25,245,104,254,221,15,63,93,186,102,182,141,31,254,107,149,55,171,90,247,159,63,95,250,235,172,66,223,191,183,183,198,147,13,247,183,252,
120,106,208,239,67,238,233,60,239,225,248,170,223,60,144,47,104,220,196,227,177,49,9,23,78,236,223,180,243,246,93,93,18,10,76,190,244,100,165,86,107,55,172,252,124,198,175,93,250,101,89,61,232,235,232,223,107,47,190,144,123,116,138,183,105,92,133,248,207,18,238,153,186,164,243,128,194,217,94,248,102,100,193,114,145,217,231,20,121,177,223,183,5,50,189,242,118,239,47,188,17,249,58,109,90,119,87,138,55,126,252,182,147,41,222,225,200,142,137,253,175,174,190,125,234,241,92,133,247,61,126,223,145,215,23,110,76,254,87,169,176,149,13,27,150,159,114,225,203,175,203,140,44,88,242,230,139,139,70,95,221,212,181,90,204,135,113,75,127,157,209,122,81,230,154,13,79,254,94,189,86,151,173,117,214,206,158,125,111,177,106,123,219,221,118,249,174,51,191,222,120,32,182,214,43,219,54,109,168,112,170,123,161,181,81,205,10,119,94,29,25,118,255,202,243,151,126,156,85,243,76,189,31,226,78,150,216,90,41,36,182,220,178,2,245,42,39,52,125,243,196,47,111,12,110,255,196,208,60,7,30,41,148,227,234,11,95,23,125,
250,129,98,83,238,218,22,91,39,113,203,241,169,147,242,247,59,179,33,57,244,251,58,141,242,78,249,38,124,73,166,213,147,79,149,29,23,95,40,203,244,10,167,102,39,150,63,182,101,125,161,164,208,221,245,138,182,61,158,226,221,57,160,71,209,25,55,58,213,188,90,113,193,195,5,39,127,114,174,220,192,222,75,25,254,163,19,19,215,39,103,175,144,80,109,75,92,174,20,175,247,206,90,155,123,20,72,200,156,60,97,201,152,43,217,135,156,123,63,44,236,246,2,67,203,173,27,54,124,230,213,11,7,159,233,190,62,161,192,185,63,142,87,236,214,233,139,153,41,94,187,213,123,230,206,60,249,251,233,29,95,151,46,122,250,205,169,145,15,20,159,223,100,76,174,171,231,71,198,63,210,58,161,65,252,249,93,155,159,12,174,248,175,86,31,23,233,61,226,246,162,167,188,143,175,61,241,82,210,168,165,93,198,255,92,228,195,209,191,223,253,90,217,241,77,110,159,94,58,248,163,5,47,55,248,61,52,184,107,133,137,123,235,213,28,157,169,85,252,229,228,53,143,157,170,152,103,196,164,252,7,135,143,94,245,221,218,199,106,86,91,254,90,
185,159,183,13,94,49,255,120,253,23,214,21,74,156,61,103,219,226,209,145,15,47,219,191,252,243,108,57,134,247,13,29,185,235,221,223,115,127,50,231,246,151,38,134,50,226,255,224,127,203,214,54,203,255,86,173,9,151,67,47,63,247,220,242,215,87,78,27,188,239,84,241,46,47,44,58,90,164,78,239,66,59,251,239,63,243,122,82,190,171,87,94,250,225,167,149,31,39,22,137,191,89,118,93,66,137,23,78,191,116,44,114,250,193,81,147,70,31,89,242,85,183,103,86,204,30,90,111,211,236,86,79,141,27,244,107,253,248,37,41,222,137,143,206,207,26,248,196,247,241,19,146,243,238,156,91,39,215,172,182,111,125,121,118,202,59,213,190,189,80,233,232,250,185,131,74,221,31,58,226,195,218,151,78,228,253,245,108,246,138,159,61,83,188,243,228,208,195,171,138,246,46,184,37,182,253,168,20,47,228,120,252,233,109,231,122,102,217,20,29,19,210,163,210,248,18,231,171,44,10,250,226,165,121,31,255,116,166,228,176,122,173,18,182,244,138,219,80,121,125,204,206,182,155,239,43,118,102,195,177,98,77,234,190,62,113,109,213,174,69,
10,13,62,117,49,249,135,236,213,110,155,210,52,203,206,226,71,135,31,152,26,235,197,126,23,127,245,248,146,119,18,206,36,103,159,144,208,115,83,215,31,206,159,94,249,236,178,223,106,141,186,178,111,248,242,123,174,148,157,94,246,142,106,97,89,162,71,53,45,253,238,193,103,246,173,30,146,24,90,255,220,133,19,113,7,142,109,153,157,51,185,124,108,185,167,215,86,28,59,242,185,85,51,182,30,109,122,241,205,215,70,45,42,84,39,44,235,246,29,223,158,63,83,99,71,255,117,37,19,167,196,47,72,206,30,148,48,239,100,167,241,107,203,214,154,84,253,102,129,14,179,114,245,219,152,175,98,157,149,145,15,214,42,232,157,126,163,250,3,9,179,222,184,48,109,119,236,19,137,91,78,150,72,12,27,181,249,194,132,113,153,227,107,141,175,177,184,244,198,235,29,175,31,29,176,106,245,138,149,199,202,188,178,226,157,55,219,4,63,91,233,226,153,240,230,219,30,244,174,196,37,150,207,114,62,211,201,98,213,142,103,217,148,226,229,254,229,165,235,173,247,79,109,92,113,212,240,144,103,11,158,172,242,97,245,7,38,23,205,
123,188,196,163,151,150,76,74,46,22,13,139,66,219,110,228,184,81,37,238,68,173,228,157,127,172,63,81,246,104,236,177,21,143,254,120,233,224,154,201,189,231,15,76,241,54,52,171,223,231,199,71,78,149,216,80,226,246,250,79,151,236,50,242,66,230,170,59,98,250,127,211,114,231,224,23,242,205,125,60,188,230,162,66,103,87,21,59,187,37,238,196,153,30,85,82,188,231,154,164,120,89,115,39,149,191,144,143,71,244,79,55,10,92,121,188,222,230,199,199,204,234,121,253,252,27,199,214,60,178,107,202,103,23,246,60,85,183,72,114,182,176,132,9,221,18,112,153,154,111,244,157,155,167,175,91,120,52,223,218,27,225,5,134,175,188,25,95,239,129,201,103,22,134,220,81,247,147,30,69,110,52,60,58,112,118,124,171,169,135,6,70,38,204,126,250,163,113,135,143,47,45,222,245,155,139,49,121,91,125,210,248,245,123,123,63,119,119,193,231,154,14,219,238,109,251,166,233,99,147,159,172,69,243,127,185,57,107,105,92,223,11,79,143,61,54,49,118,116,220,178,216,6,75,214,12,88,61,253,193,107,249,119,151,159,254,238,83,153,114,
77,158,94,183,77,133,47,171,239,154,112,104,87,210,93,89,174,60,155,80,233,133,58,77,138,191,251,94,236,221,241,223,116,56,208,255,187,123,167,223,61,188,74,120,254,168,227,195,134,126,180,233,227,47,47,207,201,221,141,199,87,207,36,111,250,177,77,93,103,111,203,157,191,66,143,196,109,91,135,183,120,44,231,254,144,230,209,171,34,218,68,93,206,252,226,229,95,188,243,61,159,232,116,230,245,115,185,18,186,109,142,203,52,174,236,217,245,203,58,109,126,101,232,235,133,251,156,71,141,163,243,135,78,31,211,169,125,236,206,211,91,191,169,178,170,255,246,63,190,62,114,223,162,165,187,15,121,73,107,111,206,47,247,100,92,114,246,131,241,175,55,223,251,213,23,123,206,47,62,127,250,249,125,67,11,229,153,120,164,74,201,184,47,10,151,248,96,226,205,70,191,246,204,31,183,161,97,138,215,119,253,157,177,109,226,178,39,69,38,142,237,253,214,182,122,89,95,237,190,105,193,246,108,5,166,85,152,112,168,242,184,248,242,183,223,63,249,165,106,61,70,22,72,186,235,235,229,109,115,191,83,109,115,137,172,
117,34,99,78,37,118,44,245,74,235,59,6,61,187,189,225,169,11,209,95,222,251,85,145,225,95,81,213,238,183,26,205,95,55,127,244,160,117,95,141,204,92,126,213,61,21,215,245,175,189,125,194,182,186,247,22,58,223,243,245,184,229,187,215,222,252,52,238,248,187,215,59,109,40,214,230,202,169,182,241,61,159,239,216,103,205,138,151,26,174,143,137,206,187,179,244,237,205,191,238,212,36,139,55,245,173,67,107,166,30,232,118,124,213,150,33,47,198,21,191,124,236,80,166,147,211,127,155,85,184,192,225,228,13,239,182,8,255,164,66,159,71,55,53,222,249,242,194,15,188,156,247,150,121,251,246,131,37,86,54,219,24,247,66,207,101,251,207,15,122,111,220,119,199,114,175,173,251,216,201,238,17,199,203,116,221,58,123,193,214,61,223,54,111,253,82,151,7,202,84,104,186,176,106,150,34,183,141,190,231,169,242,204,93,131,20,175,215,133,144,164,236,137,61,223,167,232,46,189,234,20,88,50,186,223,197,114,189,251,86,8,125,35,127,193,193,159,31,201,250,91,214,11,61,222,185,209,56,182,221,103,137,59,233,254,154,213,
9,83,142,52,45,242,69,100,211,231,91,188,122,117,232,225,206,151,235,54,47,151,176,52,251,205,121,235,7,44,45,56,238,216,204,136,23,227,151,157,120,100,211,250,60,7,98,174,79,57,215,187,211,222,26,69,6,125,210,184,217,55,119,189,29,188,112,206,109,101,62,201,242,148,87,102,255,158,250,43,150,110,220,49,228,217,250,241,109,186,119,219,80,184,215,218,239,126,237,250,112,205,237,183,117,94,243,123,145,79,46,247,234,159,233,27,30,244,245,15,172,255,242,88,137,184,126,83,10,108,137,203,187,39,238,174,179,51,103,204,218,247,208,235,213,182,71,197,236,251,101,231,233,143,30,172,157,115,205,212,157,199,38,239,231,237,47,100,241,158,159,62,79,232,180,237,216,179,251,71,93,173,85,47,207,51,35,63,248,178,219,237,153,214,198,175,201,116,224,181,6,223,79,254,163,39,67,182,161,118,175,209,245,123,79,13,110,86,170,250,176,138,107,159,158,182,53,235,253,83,67,58,237,88,31,223,50,199,189,231,215,199,44,61,148,237,244,248,230,211,91,190,214,231,145,134,153,114,175,120,120,88,181,125,79,213,169,
118,162,214,185,103,226,207,110,169,31,223,190,126,145,216,210,235,150,173,27,114,219,47,241,173,107,188,23,54,250,108,213,79,195,51,15,47,23,249,205,148,30,223,165,120,153,159,217,51,123,211,216,33,27,138,85,107,242,249,204,111,91,22,154,121,232,219,227,205,27,79,203,23,21,53,104,211,219,147,51,77,123,56,110,114,189,146,71,199,125,93,34,62,178,82,81,222,216,183,20,207,183,111,69,177,2,157,199,55,63,215,230,157,219,46,212,105,254,178,183,125,91,246,7,66,27,120,63,245,25,187,159,103,66,230,152,53,107,18,154,190,19,95,174,67,254,59,27,213,216,59,247,247,110,255,122,118,121,145,103,31,237,248,217,169,66,219,170,7,93,170,117,46,197,163,240,11,137,3,227,59,240,57,161,231,29,125,186,183,237,148,144,252,214,163,131,151,212,40,242,214,153,233,247,46,41,126,79,222,154,155,182,37,172,204,221,99,194,226,216,249,55,194,147,170,127,124,235,131,66,242,222,158,121,214,221,157,212,58,239,128,67,183,77,184,119,229,39,187,251,77,91,251,94,135,46,189,27,86,29,215,177,253,244,160,211,47,214,123,
237,250,154,232,236,71,250,207,248,174,246,246,186,171,23,93,191,43,120,125,216,218,106,143,157,218,149,120,79,219,243,197,78,221,255,97,138,151,101,192,184,208,196,246,39,187,244,89,221,242,139,188,183,77,251,87,195,115,189,51,191,176,113,245,239,89,27,85,254,234,167,81,94,112,253,67,111,157,152,63,33,233,206,179,87,230,38,14,79,200,125,226,229,87,90,236,174,241,245,150,21,87,158,201,57,229,244,125,227,63,44,21,52,237,226,167,111,63,213,54,103,208,229,165,204,224,248,175,219,94,89,154,37,182,204,91,69,98,119,246,175,87,183,90,161,26,155,7,118,42,94,141,141,183,198,237,89,151,99,245,212,13,171,183,61,63,46,207,232,65,251,126,107,185,184,67,233,60,239,52,10,62,220,173,96,191,126,221,215,68,189,29,209,162,228,201,53,23,18,195,31,159,93,33,49,242,68,227,154,31,127,93,121,66,151,95,38,118,254,224,133,175,190,222,226,141,92,31,31,181,254,90,149,65,181,146,215,85,63,118,115,198,103,199,14,117,58,213,239,243,248,225,201,217,230,197,255,88,231,254,145,143,45,24,48,246,230,226,149,51,
43,13,250,42,87,190,190,93,222,43,84,103,202,246,172,95,157,153,121,126,253,241,133,143,127,223,61,121,211,204,135,219,53,254,227,193,253,133,7,231,173,17,190,237,185,115,229,43,189,24,183,172,199,252,27,45,227,54,220,155,148,229,221,254,3,11,36,149,89,221,239,157,33,11,59,151,57,23,117,255,194,187,79,93,9,255,220,155,245,230,156,220,65,137,79,156,88,127,96,81,178,215,57,166,248,61,63,12,250,61,118,224,168,247,175,189,62,243,231,175,199,253,80,236,251,37,39,163,46,109,127,101,234,151,215,247,175,142,219,80,102,93,213,129,179,238,75,236,118,242,88,182,129,181,246,143,125,175,94,225,53,121,126,221,223,233,145,240,138,93,218,108,190,92,123,67,157,235,19,47,86,122,62,110,213,212,231,214,21,140,173,191,44,190,211,212,122,94,247,157,167,206,231,61,56,226,226,199,191,188,60,232,179,215,218,101,221,113,91,247,77,163,118,28,248,169,232,228,159,215,253,120,243,229,164,150,39,135,20,137,173,253,217,254,181,145,241,171,218,38,118,95,248,112,236,135,49,49,121,155,149,221,254,175,151,207,189,
219,160,253,183,149,143,156,169,27,154,233,143,2,87,238,184,249,198,136,217,135,230,157,42,176,121,113,145,45,215,95,154,19,91,232,221,31,235,158,59,212,100,254,225,141,203,142,236,8,127,177,232,219,69,99,63,44,50,124,255,252,113,235,99,243,37,134,157,136,123,170,120,200,202,248,9,207,14,250,121,229,119,139,127,26,147,103,112,217,63,250,236,40,250,246,39,63,37,215,184,118,150,113,140,93,54,107,63,31,68,183,61,63,51,219,221,93,138,255,240,242,87,207,53,202,93,239,236,180,89,43,174,79,125,32,115,190,246,255,236,127,157,6,230,120,228,173,157,3,71,207,124,248,204,152,6,107,234,119,253,164,137,119,87,247,240,138,243,222,218,217,114,244,140,135,95,89,91,50,139,177,53,156,49,180,89,233,213,141,10,175,185,249,115,214,160,33,139,239,232,210,237,208,244,232,241,181,95,252,173,189,183,235,116,36,185,27,92,41,18,119,255,183,55,234,244,24,149,116,233,64,173,113,35,235,230,243,14,150,110,209,110,222,7,171,139,103,255,248,171,234,95,85,156,187,178,195,199,155,167,133,221,187,49,52,211,165,69,
253,231,100,237,177,253,104,139,103,151,134,12,10,253,229,116,80,116,226,222,189,96,60,244,74,235,229,51,26,149,62,180,241,247,49,225,223,141,31,176,51,159,247,84,239,249,57,223,221,251,188,247,204,222,194,93,67,131,11,134,159,63,63,252,167,13,69,187,156,253,132,172,109,103,102,253,253,142,247,62,249,232,133,177,31,78,158,248,100,190,160,162,149,155,13,41,216,124,94,231,221,113,217,115,102,127,180,230,67,87,190,237,26,90,250,197,169,29,94,8,170,81,35,95,80,200,149,135,174,134,23,238,95,250,213,151,158,219,93,116,220,136,101,7,187,253,56,232,143,57,47,117,255,162,214,156,218,73,191,13,224,111,21,124,249,229,241,200,123,198,223,255,108,88,248,192,82,37,78,140,12,137,122,181,93,200,208,13,197,86,135,76,172,49,37,75,252,220,167,194,150,29,220,48,114,234,125,5,127,222,214,250,183,34,37,222,105,221,196,107,82,241,163,106,91,75,207,200,55,45,75,147,190,33,185,55,206,46,26,147,61,100,74,199,59,70,116,44,24,252,78,19,207,175,154,173,181,183,13,48,53,44,62,223,249,141,127,189,84,106,236,
171,15,84,187,22,117,171,236,12,181,238,205,66,91,199,92,154,87,186,246,174,122,175,122,203,59,228,247,142,191,156,171,208,45,211,156,204,115,39,134,122,169,252,47,211,183,227,202,143,158,215,97,197,254,216,210,39,166,20,62,189,184,210,229,15,207,237,170,51,250,216,93,31,61,216,163,225,154,231,239,253,178,103,251,53,165,62,171,95,112,244,178,205,61,202,39,62,119,114,103,222,93,91,159,249,242,161,163,5,198,135,149,250,49,103,171,67,207,39,62,59,171,247,181,121,55,219,221,219,246,149,44,161,71,174,143,88,159,111,219,149,182,91,46,60,95,248,155,119,103,254,184,100,240,136,31,63,88,63,242,244,11,175,245,26,27,116,177,247,111,77,162,99,59,199,183,249,252,163,196,132,223,123,158,56,58,233,84,203,176,232,230,151,110,92,43,219,185,236,178,87,114,77,27,218,57,41,33,211,248,154,207,215,175,114,237,137,217,133,215,188,253,246,185,163,211,187,86,56,191,227,244,146,11,215,155,253,122,111,84,229,229,243,38,156,153,220,169,70,88,189,152,97,177,227,246,237,74,156,49,233,106,233,129,181,230,14,
90,250,196,152,50,137,107,62,56,154,84,53,190,196,230,218,239,95,124,180,236,103,207,87,236,113,96,208,197,89,133,138,236,136,9,250,105,202,226,63,38,143,204,84,236,236,143,13,142,4,21,203,21,123,225,20,199,164,68,166,113,187,122,20,138,207,187,254,173,49,163,158,120,100,65,248,180,136,142,101,198,60,221,239,203,51,189,126,154,61,103,233,19,107,151,175,125,179,87,254,253,115,247,134,110,202,116,199,147,199,22,46,121,187,206,7,247,236,189,252,248,148,155,35,215,255,52,250,224,206,240,50,139,54,190,95,248,187,73,139,58,54,57,60,186,92,129,28,151,159,88,241,228,185,197,187,191,104,210,39,174,223,111,199,46,21,232,153,148,185,68,82,199,18,7,87,175,186,153,121,127,138,23,212,44,133,3,179,118,215,170,159,98,215,127,58,33,41,169,231,181,90,215,10,95,122,168,217,149,193,139,83,188,6,35,83,188,47,219,243,134,212,254,230,91,31,198,237,238,30,23,159,47,46,33,106,120,189,99,47,63,17,26,183,107,75,138,247,74,220,180,165,233,1,55,171,118,254,90,150,127,8,219,239,80,151,1,121,218,44,174,247,
222,178,205,247,109,173,184,241,76,194,206,152,142,229,134,135,53,105,114,240,254,155,41,222,7,13,154,228,139,44,25,58,119,162,247,87,255,27,255,219,149,163,91,50,29,57,210,100,240,123,199,171,47,201,119,103,226,15,67,18,155,143,88,122,61,219,193,20,239,120,195,184,41,221,103,20,252,217,107,62,241,248,227,209,51,39,157,203,127,236,143,11,5,110,198,151,239,89,171,81,255,27,247,63,241,245,145,165,41,94,182,219,95,67,138,251,235,39,101,109,155,48,47,57,111,177,10,201,227,31,143,75,188,99,246,169,135,234,109,24,148,226,213,75,136,59,22,60,245,227,110,113,187,214,246,188,250,229,252,11,119,141,173,59,251,232,250,175,254,110,224,188,163,57,190,59,151,124,57,185,73,220,159,216,149,136,127,249,215,158,151,238,92,70,35,158,77,241,10,127,114,37,199,144,107,87,39,37,39,230,123,114,252,225,228,39,121,156,174,203,92,60,190,199,212,71,174,46,189,88,129,207,243,141,230,199,237,110,179,43,197,11,190,51,105,192,192,238,29,190,189,182,253,112,247,13,67,183,87,125,40,236,174,23,74,60,189,224,63,
65,245,42,244,255,87,153,109,121,155,182,237,240,65,230,26,59,247,190,121,223,67,87,35,215,239,72,154,26,154,248,228,176,163,85,18,183,156,218,217,171,95,191,214,183,55,95,222,178,121,153,95,11,93,220,215,165,104,206,83,63,71,204,171,83,226,213,78,181,78,180,44,145,183,243,184,239,95,46,145,231,108,158,223,106,21,168,87,116,86,147,85,43,38,237,24,127,36,199,11,241,31,84,109,89,180,102,142,226,159,29,207,185,191,69,252,201,74,137,77,146,171,197,54,252,174,79,135,73,31,124,125,219,138,193,23,139,247,253,177,224,139,27,175,108,124,99,219,250,26,123,118,30,175,240,230,184,42,93,19,55,119,111,92,241,238,61,101,190,159,178,242,251,181,203,154,79,93,83,183,114,205,222,197,47,159,222,250,214,219,189,174,47,186,213,236,159,158,252,241,209,190,117,42,142,221,251,227,171,229,26,150,175,213,98,253,137,15,203,156,159,127,250,137,195,163,214,71,110,93,209,51,215,150,132,66,124,230,88,22,249,197,250,169,157,226,79,255,184,185,112,203,195,221,171,199,244,171,248,253,176,215,218,111,40,251,122,
120,155,225,111,143,240,114,221,28,178,121,85,205,25,199,178,213,43,217,252,116,196,138,108,21,151,127,209,176,246,178,27,151,86,7,117,154,252,244,197,237,237,63,29,246,192,145,44,93,247,38,180,221,48,251,174,22,31,36,142,63,182,49,185,244,39,123,234,212,58,217,162,213,234,249,139,119,190,56,115,228,35,65,125,43,175,139,207,183,250,204,133,219,54,212,233,16,251,224,238,243,61,187,37,118,59,94,183,94,174,43,251,174,38,28,251,106,97,226,232,146,203,187,255,146,116,249,182,246,121,167,237,255,121,201,168,54,67,59,12,234,242,235,210,81,59,231,213,237,127,106,232,129,55,191,91,80,120,98,187,229,179,35,214,157,174,241,224,247,147,86,183,168,249,125,204,61,151,59,125,113,116,221,15,77,242,117,90,59,174,93,190,246,77,188,255,252,175,203,170,113,101,247,124,20,17,81,242,179,189,21,79,204,60,84,98,121,171,151,142,23,60,149,124,99,108,238,225,45,150,175,138,184,227,157,102,253,43,92,47,28,213,233,142,163,245,227,227,94,168,116,254,252,249,216,232,65,87,222,236,220,172,104,254,215,23,189,
89,112,150,87,244,167,125,239,191,19,211,247,195,108,201,219,150,116,63,114,45,111,193,249,121,142,140,111,191,173,99,157,161,3,107,180,111,121,98,217,181,119,150,109,216,59,119,105,151,218,215,183,204,77,241,94,88,91,237,253,196,79,55,132,95,110,217,113,245,211,101,91,236,206,27,245,222,11,135,95,123,186,232,248,172,223,54,137,89,120,104,206,237,79,245,158,249,117,138,247,236,168,228,185,93,39,208,148,18,39,154,37,149,94,127,57,239,222,250,23,18,83,188,236,99,143,94,169,54,56,34,251,91,139,230,30,28,216,247,201,228,27,183,239,77,170,244,254,192,194,43,223,90,212,163,91,142,73,59,107,188,121,190,216,129,147,247,244,45,223,249,246,55,55,148,174,59,180,237,226,1,251,254,20,95,255,68,177,20,111,225,140,119,83,188,184,109,137,237,150,44,217,147,173,246,206,166,85,23,141,88,222,237,151,85,223,255,124,184,198,47,31,77,77,108,22,247,91,217,133,113,199,18,146,243,197,109,188,63,197,107,95,177,81,114,138,55,53,126,193,152,199,171,253,180,32,41,197,123,230,207,94,119,253,92,191,96,253,
152,250,193,227,118,117,173,177,121,230,209,149,215,95,122,175,114,239,239,75,189,218,114,216,153,218,91,179,252,88,162,107,204,186,133,111,54,205,214,163,234,250,175,174,116,221,156,80,98,202,218,250,39,138,140,154,221,117,223,163,35,190,218,61,248,158,159,71,54,154,124,170,118,185,186,3,47,254,113,114,87,82,190,165,39,115,79,105,188,114,86,161,231,115,103,57,80,165,239,31,165,54,175,10,95,240,244,140,58,97,215,179,95,139,123,40,97,201,130,147,57,14,14,25,57,168,195,217,246,171,167,77,170,179,63,114,249,228,205,111,207,106,113,249,131,42,245,123,36,53,186,49,34,233,158,221,111,132,119,221,187,122,222,244,166,225,115,30,241,166,70,246,24,254,65,220,134,230,203,75,44,123,102,254,232,174,215,99,118,140,88,253,102,239,135,159,108,218,102,224,31,247,183,217,123,122,205,200,150,253,127,250,60,246,212,163,89,31,78,126,237,192,175,179,138,36,212,184,248,97,163,121,15,127,48,107,74,196,129,109,191,245,207,244,123,177,182,201,217,75,127,212,125,83,193,239,235,84,234,27,115,207,184,225,
195,135,238,9,174,251,84,240,123,187,83,188,33,252,216,56,199,156,145,21,51,181,153,117,172,232,252,181,47,77,153,189,104,103,236,51,125,227,255,216,50,204,107,189,120,109,143,61,109,223,30,247,192,190,45,171,54,93,200,187,177,193,180,115,187,159,200,95,127,207,83,245,219,38,231,138,29,27,127,97,107,247,42,239,125,127,250,70,241,5,217,54,95,31,185,41,168,252,141,169,23,42,125,182,180,229,210,175,235,102,121,48,33,247,115,151,7,182,126,104,91,228,164,182,123,207,151,201,187,105,120,142,215,250,150,222,95,183,193,47,205,26,86,248,173,109,246,228,67,215,47,63,247,233,150,147,21,43,180,90,247,90,187,220,247,237,59,179,61,252,199,175,35,167,93,223,157,229,96,190,78,219,143,197,31,89,57,175,208,238,187,11,165,120,11,46,51,50,109,19,7,79,170,127,61,136,15,249,79,111,226,7,207,191,125,80,225,116,228,141,145,49,167,10,125,119,119,137,43,215,235,39,206,108,207,221,231,37,127,137,207,125,227,201,44,124,3,159,147,251,131,254,75,95,155,112,254,135,247,223,78,241,54,207,202,153,251,250,147,
37,78,180,41,177,170,205,140,199,166,148,42,58,251,58,63,45,63,215,63,211,111,99,43,156,158,154,56,120,74,165,18,23,179,62,91,162,209,152,20,239,192,30,190,4,13,255,117,246,165,172,19,82,188,76,32,221,249,64,137,200,246,61,195,141,149,239,91,47,183,42,157,124,172,254,141,194,180,233,215,39,151,191,145,251,230,186,220,201,247,60,85,111,193,220,117,157,134,28,94,208,186,231,181,103,31,24,247,250,188,20,239,197,121,201,69,22,180,73,241,230,84,175,159,88,16,122,222,245,185,19,175,117,75,46,50,119,83,161,228,45,183,160,155,1,253,96,253,193,221,238,249,117,238,3,113,231,19,227,158,243,158,108,223,36,246,211,250,131,43,212,172,211,255,241,20,47,177,248,250,19,141,143,173,220,190,99,72,185,131,35,42,68,222,27,249,241,23,215,95,203,117,152,31,28,231,126,191,198,23,195,219,198,31,125,179,230,188,15,122,52,138,238,157,245,155,87,190,61,209,190,217,231,75,95,77,26,115,99,236,161,131,221,143,118,27,221,173,105,183,95,78,13,154,118,244,232,189,81,177,197,59,135,158,41,254,78,133,109,235,170,
196,182,72,152,176,245,231,85,207,116,216,27,62,168,250,27,69,190,153,218,102,249,240,211,175,111,59,58,252,237,79,138,125,81,173,71,219,81,241,219,54,119,122,224,90,129,25,141,139,79,250,35,238,65,239,234,47,235,143,207,73,46,63,254,100,205,207,118,47,127,243,95,57,115,204,173,246,97,158,35,153,94,121,166,219,202,217,241,29,10,230,253,173,74,220,241,51,45,123,141,123,124,213,154,156,199,159,8,246,110,14,252,233,173,93,207,214,171,214,225,193,28,133,154,214,63,243,97,165,63,186,158,169,81,105,66,189,234,203,191,29,209,187,54,157,28,243,221,250,134,77,188,113,19,126,137,139,111,183,235,249,213,227,23,238,45,181,119,249,155,45,207,31,46,115,255,151,197,223,91,180,180,103,252,144,243,153,227,255,216,54,255,206,166,9,61,222,121,172,218,153,59,214,110,172,85,251,202,163,99,247,159,252,118,69,254,197,243,102,220,24,247,250,147,3,178,36,180,204,52,40,233,203,109,103,31,62,59,240,212,55,185,114,222,120,184,120,161,34,33,237,178,92,202,87,176,242,87,37,167,14,232,154,212,40,177,247,141,
127,197,182,78,108,118,223,148,18,155,87,21,168,89,228,234,23,207,191,183,245,100,254,235,131,79,199,5,87,248,125,233,211,124,125,206,157,53,169,225,222,65,151,226,10,30,152,157,245,183,188,94,254,203,239,29,139,41,61,118,240,111,159,95,157,147,251,147,165,151,159,200,21,122,247,23,95,172,90,150,251,234,184,239,202,191,127,225,253,214,81,60,207,54,49,127,115,142,190,195,16,62,150,226,77,233,254,201,186,101,251,194,231,172,93,62,179,194,142,22,47,215,137,108,188,225,187,189,151,74,190,180,162,254,43,37,174,22,184,184,40,246,199,92,39,127,237,118,180,77,242,135,73,147,215,39,182,170,94,226,122,174,95,143,37,22,40,145,200,215,252,108,207,63,195,231,132,47,120,48,5,243,57,174,240,222,139,189,147,79,38,71,141,169,146,226,61,22,87,254,161,215,227,206,94,40,127,169,254,107,55,207,38,77,238,151,80,235,249,163,35,222,89,49,40,236,253,7,58,246,169,85,229,247,118,99,159,26,206,55,245,141,209,115,82,188,221,67,24,177,47,63,75,241,182,174,168,243,70,138,247,217,250,215,138,183,138,59,210,
115,251,164,150,171,147,215,245,30,54,231,234,228,117,151,147,155,246,76,186,167,112,238,155,183,93,186,144,148,99,106,210,128,74,137,45,214,214,186,50,117,121,220,192,152,30,227,126,92,55,228,80,239,31,167,182,58,83,123,241,236,123,234,255,94,233,116,51,195,125,238,158,223,215,47,125,35,172,93,183,166,61,199,166,120,165,43,37,223,153,43,75,242,51,99,71,37,103,222,150,92,61,206,47,245,210,107,51,54,158,250,234,199,2,179,58,141,122,109,218,154,226,159,157,157,216,167,214,67,157,170,181,200,25,217,109,71,120,220,184,234,125,195,215,183,187,175,195,213,53,75,207,254,124,127,135,21,215,202,94,93,154,220,248,211,151,62,45,245,233,199,255,135,142,183,14,106,51,122,215,69,131,20,183,210,162,197,10,20,119,247,64,41,46,161,184,211,34,197,221,53,72,209,226,90,28,74,177,98,197,221,37,72,145,226,197,33,88,144,226,16,32,164,55,191,189,239,62,115,238,57,115,255,72,50,153,201,100,190,228,91,235,125,159,247,145,101,243,49,185,111,247,185,102,69,81,123,212,158,154,60,135,234,15,213,180,87,88,
128,196,146,196,27,110,59,143,102,219,79,168,254,134,142,199,246,45,148,100,41,1,241,162,165,245,34,170,242,130,201,116,190,102,118,223,241,212,5,170,230,103,139,174,103,18,104,249,209,112,68,105,77,210,104,188,0,67,121,225,164,121,175,151,64,232,203,52,142,223,35,36,64,168,101,118,176,204,194,60,193,2,148,242,81,70,255,205,251,3,222,236,117,196,204,137,156,52,141,101,59,71,213,124,217,198,202,211,237,63,64,244,227,116,209,196,126,73,248,240,8,207,92,147,49,170,210,228,116,152,251,238,133,164,128,101,68,7,232,137,174,233,169,130,188,231,111,114,53,240,213,231,154,64,216,170,220,92,250,83,83,108,136,199,217,236,76,69,14,129,183,88,120,104,35,84,134,87,253,180,192,40,139,71,140,219,132,11,253,52,39,145,21,135,28,189,150,42,14,34,178,79,107,23,164,0,232,155,247,30,1,23,102,168,250,137,190,138,144,249,109,59,183,213,145,121,61,237,43,188,155,54,133,117,107,79,89,63,118,22,191,196,190,229,204,114,101,8,239,133,242,190,92,95,209,32,252,161,128,149,246,241,205,208,39,17,175,36,110,38,
54,105,221,206,60,254,227,68,177,90,195,223,183,65,57,198,154,6,96,207,39,33,233,149,63,169,35,82,122,251,123,170,47,211,153,66,90,210,185,110,142,246,252,123,11,173,230,43,190,197,221,128,194,255,243,167,225,41,126,136,51,138,209,195,64,201,113,153,61,168,50,138,98,108,22,230,252,140,159,159,247,246,207,77,176,198,212,205,136,20,187,219,50,172,187,62,255,7,200,52,245,160,234,37,192,3,84,62,154,135,108,254,132,123,57,132,16,195,125,189,59,117,18,186,114,243,125,24,241,222,42,109,24,118,27,122,173,207,120,90,228,6,148,181,254,128,247,26,20,88,186,52,59,191,245,229,101,142,87,107,228,23,103,78,59,59,54,83,168,139,176,138,13,90,119,216,250,245,20,50,129,15,62,212,64,146,57,4,91,195,206,159,114,65,113,146,148,216,118,233,232,96,106,192,224,92,15,229,198,56,121,176,173,86,132,250,151,186,204,106,170,250,191,32,250,76,199,210,57,175,77,140,67,76,250,198,177,170,53,226,157,100,10,42,132,27,80,117,255,83,142,90,182,209,158,79,74,210,133,248,88,37,227,65,11,27,198,111,231,30,150,47,36,
245,176,135,119,124,223,206,241,91,176,119,219,170,88,119,122,99,202,255,1,244,132,155,191,61,200,187,180,35,86,133,251,86,217,159,201,209,6,87,105,254,17,181,138,3,28,245,110,243,44,185,140,176,44,242,236,234,44,171,52,133,200,191,220,237,44,8,177,105,43,208,255,7,112,80,100,189,95,212,104,8,23,171,161,196,22,195,182,191,41,194,143,83,139,124,243,133,216,244,210,225,93,60,251,104,255,234,26,81,161,113,184,96,31,221,250,143,119,78,24,83,50,233,104,98,0,18,127,72,51,208,29,54,255,98,90,53,190,53,104,247,186,136,141,86,236,193,183,8,55,162,2,74,163,211,97,203,138,65,5,93,204,193,75,46,118,135,229,184,105,41,42,239,135,210,128,38,71,49,146,76,181,83,246,42,152,9,14,154,89,66,204,58,127,174,43,74,106,99,116,181,248,148,73,180,4,88,109,206,134,146,153,242,98,36,107,186,107,51,142,142,255,193,78,137,39,202,88,3,246,159,81,28,34,105,230,16,86,63,252,124,46,45,176,199,165,254,80,175,35,58,203,213,221,76,194,45,229,251,215,195,221,97,230,253,231,143,195,224,70,107,36,93,218,163,99,63,
119,249,230,42,164,59,243,31,32,120,45,141,6,76,144,155,168,130,106,147,251,159,238,149,199,161,76,151,223,177,177,83,194,150,226,174,39,61,223,254,150,225,241,75,123,20,220,102,13,111,230,22,217,251,42,150,24,216,200,93,111,154,151,37,95,200,22,192,231,218,119,93,203,59,92,240,98,81,10,127,135,51,255,133,89,125,176,164,118,19,211,100,100,226,30,195,181,151,235,142,252,20,206,53,83,56,78,17,129,103,223,148,248,137,253,184,40,255,52,76,221,92,229,80,50,158,72,16,6,194,240,114,210,20,16,223,245,186,45,194,192,204,35,85,198,136,162,43,104,90,56,250,158,108,176,148,104,79,19,49,79,92,124,42,183,166,233,30,69,183,70,13,192,25,180,14,235,172,3,206,166,196,174,96,249,60,88,19,60,177,251,43,244,51,45,131,189,116,124,130,138,208,146,3,82,100,113,248,76,125,165,101,15,237,171,4,139,239,153,109,70,71,95,143,62,201,149,98,158,50,211,229,121,206,235,126,72,30,162,177,130,201,146,214,197,220,56,50,255,146,200,63,177,248,59,181,140,244,218,131,231,239,124,145,58,93,40,240,162,239,247,164,86,
38,94,98,2,214,216,106,98,160,123,40,211,250,237,52,252,213,13,155,4,120,81,0,41,155,141,180,106,78,19,50,80,141,126,78,216,174,183,146,108,252,152,122,51,82,234,237,171,71,29,57,195,239,210,54,9,40,138,166,150,80,187,83,147,72,225,195,198,112,14,224,83,241,249,149,252,2,89,174,252,162,58,145,63,201,26,237,242,109,127,127,173,160,209,249,72,235,118,131,249,223,95,99,46,192,189,157,229,51,245,128,2,232,69,205,113,178,90,74,95,21,185,241,109,241,135,183,195,110,211,148,208,137,172,125,157,251,25,236,42,228,248,63,64,11,36,46,228,153,195,162,143,142,249,88,181,159,140,10,160,109,142,213,121,68,88,202,37,54,105,157,169,86,130,250,201,23,110,114,225,56,72,79,37,197,75,222,189,237,172,42,173,56,150,184,132,231,118,1,244,182,57,34,12,161,52,183,151,224,141,197,181,255,40,161,112,79,127,113,229,120,135,251,15,96,15,174,51,190,6,253,169,131,46,197,253,3,88,3,99,124,30,242,135,219,22,16,180,149,29,38,71,196,248,159,164,179,31,161,143,181,221,254,71,98,147,128,144,141,247,70,61,52,23,68,
133,59,147,88,131,70,179,181,218,103,154,61,145,182,225,94,135,135,131,12,139,25,255,107,144,240,227,253,252,169,112,88,164,144,66,74,59,235,184,124,179,123,97,49,197,209,221,59,180,197,221,4,131,222,60,82,45,58,40,165,176,144,54,148,78,254,124,86,131,191,11,116,222,222,20,252,74,251,124,164,142,187,63,240,52,240,125,202,112,79,53,153,161,196,107,167,88,99,245,212,46,2,162,128,196,224,214,62,25,218,168,205,33,250,23,136,103,21,35,76,245,243,60,187,243,53,186,127,215,185,40,212,178,77,124,1,41,162,217,125,135,34,7,53,40,132,128,230,72,158,83,30,77,97,126,17,255,176,17,177,221,254,121,229,83,129,115,166,200,120,56,211,149,169,199,170,28,229,131,103,206,253,193,219,82,77,21,5,243,201,77,231,251,218,187,213,5,250,122,121,161,254,173,158,70,213,234,123,221,18,10,178,51,71,108,133,17,142,49,97,78,51,115,65,123,86,223,192,181,222,109,92,80,20,18,232,215,41,251,185,190,97,254,132,251,166,152,46,196,176,148,235,183,140,224,244,228,79,122,144,195,77,199,165,5,250,192,6,11,124,27,10,34,
125,198,109,99,229,234,250,109,85,179,40,50,185,12,246,230,248,238,231,116,124,162,24,228,189,121,179,121,203,171,173,224,218,211,187,194,130,3,159,135,97,33,36,175,45,40,119,41,37,68,164,25,49,16,199,86,219,120,128,122,254,63,164,88,246,6,229,159,35,179,146,152,10,207,178,99,251,0,190,69,68,6,59,133,73,215,255,0,81,33,24,139,82,114,21,27,171,203,165,53,157,77,32,55,183,26,158,185,122,247,249,93,104,152,69,2,170,201,198,218,92,240,198,122,7,187,255,41,155,23,86,89,217,57,122,176,184,105,228,151,198,242,108,198,150,237,9,53,168,68,46,247,54,41,28,64,128,177,158,48,125,30,203,243,150,88,193,126,135,152,221,47,89,216,132,156,4,208,22,236,214,197,174,143,90,114,68,210,21,232,205,187,219,20,24,73,198,7,127,223,172,65,164,104,22,51,139,69,4,141,20,69,179,47,209,138,176,120,129,139,53,38,231,253,209,198,153,115,202,57,159,182,113,71,175,107,236,164,4,189,116,233,217,67,111,134,1,122,45,166,36,254,251,205,220,81,128,83,53,242,88,46,107,194,114,97,123,33,88,201,136,78,41,0,228,210,117,
51,108,39,171,34,118,72,248,62,198,153,129,142,184,212,68,75,121,203,229,160,20,96,162,132,22,204,63,19,160,19,241,34,49,130,169,149,165,196,0,40,159,88,56,155,87,173,226,148,208,21,226,133,38,5,22,173,100,157,139,115,195,76,252,122,170,133,238,71,85,169,187,163,158,8,50,189,43,194,205,48,224,10,160,87,159,141,104,227,8,75,91,74,92,160,228,248,78,170,194,52,91,26,27,166,133,75,121,91,132,93,233,99,214,135,104,135,45,47,21,35,208,206,153,129,164,72,30,63,79,217,14,217,91,94,206,117,115,118,170,205,151,242,238,58,39,168,219,104,233,56,77,177,143,77,41,183,252,96,208,28,2,9,216,107,137,125,148,61,228,246,152,160,54,55,94,91,46,17,165,239,250,80,91,114,113,57,90,68,220,37,195,131,162,22,122,94,6,201,116,47,8,139,165,26,50,125,25,11,31,66,67,38,239,126,180,194,152,185,187,166,170,155,76,160,216,190,139,147,97,109,105,175,246,3,15,78,74,215,116,118,15,193,172,115,45,63,191,200,79,137,184,251,73,140,39,62,28,204,126,17,168,185,128,218,118,211,43,216,72,146,73,1,219,136,65,25,170,129,
205,245,58,142,6,18,252,148,229,86,5,186,66,126,105,206,99,98,76,56,175,202,57,69,52,183,144,6,245,111,110,46,238,52,135,31,55,174,250,86,107,5,223,103,176,71,55,127,66,134,53,152,84,58,186,206,245,110,170,201,141,19,230,107,132,155,255,174,215,185,13,158,189,219,189,106,119,239,187,134,54,123,111,182,150,15,62,162,116,38,76,251,30,222,68,190,214,7,231,89,227,9,198,68,115,42,205,141,224,8,103,96,190,214,211,15,160,109,165,215,68,11,60,99,43,38,161,160,206,134,113,221,124,117,53,169,75,247,96,74,11,24,99,181,79,59,226,96,129,82,248,22,178,146,192,214,175,104,77,60,222,44,182,10,215,180,127,166,211,215,75,166,146,253,7,240,117,164,47,5,4,41,181,70,137,225,23,200,164,243,83,73,199,221,244,79,11,125,14,63,241,208,45,8,102,219,110,163,33,214,12,15,165,150,129,90,137,67,196,143,236,127,168,17,228,33,253,132,126,80,249,139,49,231,145,149,255,36,16,168,137,28,209,100,67,43,237,211,198,229,18,76,203,81,36,80,114,18,149,236,125,210,157,29,2,224,91,7,16,95,45,230,232,190,222,74,70,113,40,
59,161,207,191,210,212,162,161,102,127,211,57,102,201,40,55,81,186,137,229,96,118,136,180,39,106,30,35,17,239,171,136,101,70,172,119,75,204,96,122,132,191,140,15,234,238,131,25,45,49,123,29,23,220,132,104,83,6,149,23,179,98,151,190,207,79,21,242,167,13,103,12,87,107,5,160,173,205,96,41,172,64,25,22,133,79,252,198,164,240,66,10,107,228,119,114,211,26,181,145,144,57,95,103,149,146,207,19,238,98,127,223,7,112,60,230,45,249,151,5,113,159,251,116,58,25,47,13,5,12,45,209,238,61,202,142,202,68,242,39,205,102,44,246,249,147,237,108,209,65,22,43,122,105,39,125,144,18,112,255,74,63,1,150,46,138,47,53,135,163,238,220,227,69,70,167,16,43,70,34,188,127,128,38,137,0,3,42,183,78,139,90,207,43,116,34,57,186,145,175,248,24,167,31,205,68,190,132,252,102,82,68,87,123,25,65,76,80,226,33,118,205,176,196,214,197,39,205,105,160,89,72,32,94,68,252,123,19,206,106,49,252,196,237,21,120,22,61,183,249,84,96,72,179,102,191,104,32,144,170,7,218,68,145,223,21,82,97,171,98,117,173,199,231,153,115,218,221,191,
93,185,110,242,5,118,212,52,20,199,245,114,216,183,45,171,171,137,228,48,13,142,123,79,234,47,54,120,147,122,241,79,133,179,181,197,132,191,88,221,58,62,250,173,190,182,198,56,35,184,138,58,150,165,131,40,188,212,66,67,61,208,157,95,53,134,21,26,27,179,21,97,234,225,207,160,93,151,254,255,144,154,156,7,192,213,66,168,45,130,3,24,225,171,223,162,227,31,176,223,161,145,80,59,23,165,192,116,151,4,231,189,170,43,145,48,216,93,58,93,184,176,4,197,89,208,186,52,229,154,68,230,42,156,159,61,208,200,152,164,214,240,26,153,204,49,32,122,195,138,136,209,127,159,140,62,91,206,180,154,2,233,24,184,20,254,216,47,75,144,138,145,197,200,211,37,45,243,208,0,216,128,92,152,153,91,65,1,57,227,56,131,97,243,215,100,58,90,29,56,202,216,46,156,22,74,179,147,165,85,14,57,121,149,182,159,34,124,96,137,27,210,160,86,212,47,8,219,150,198,99,12,55,26,120,87,181,144,223,18,102,22,97,1,247,217,144,78,10,116,193,57,42,218,239,241,237,130,103,85,248,197,217,182,158,183,164,63,196,179,13,27,63,156,159,132,
133,100,31,195,23,173,161,195,119,152,205,144,184,235,85,172,127,128,2,253,139,40,192,131,151,16,218,153,113,194,98,146,199,230,225,220,187,95,1,52,59,149,185,214,156,35,124,129,137,25,219,37,200,23,38,242,61,75,198,179,55,11,180,150,41,111,197,111,79,141,37,176,135,71,126,206,43,230,215,24,79,20,109,94,60,86,222,199,34,163,81,28,195,15,83,251,250,134,61,69,156,39,71,241,98,59,28,194,254,131,156,217,217,27,187,230,151,80,124,22,52,28,212,125,47,186,171,60,227,94,220,1,118,8,72,106,97,189,21,17,80,148,190,210,230,12,106,71,6,59,96,17,98,70,154,126,56,168,188,46,103,122,250,171,140,125,175,245,44,121,59,196,169,176,178,146,36,161,60,62,109,163,72,17,111,25,162,126,115,93,201,148,252,193,246,160,111,108,18,0,162,249,12,104,99,190,66,137,87,204,182,12,40,187,179,27,72,78,235,64,210,167,48,61,212,93,59,165,0,135,6,99,169,173,8,247,125,122,42,238,8,48,26,193,177,152,93,97,10,51,78,104,222,251,190,191,178,191,98,93,64,149,108,83,146,66,180,247,241,90,186,243,146,35,174,144,239,3,193,
79,49,153,194,72,140,104,75,44,101,102,79,89,122,255,16,148,172,141,16,5,23,29,101,26,39,22,219,98,39,54,19,190,13,60,149,211,100,164,80,200,229,248,109,125,217,198,20,159,202,121,84,10,121,111,17,127,17,170,204,148,165,72,132,231,166,215,45,71,19,241,151,223,44,50,122,196,130,30,70,62,176,2,25,121,64,136,140,242,213,231,78,62,42,21,241,80,34,155,208,30,178,160,188,228,118,50,132,51,181,222,196,36,14,34,43,33,121,49,65,144,118,55,12,2,47,192,205,116,105,136,161,223,244,8,113,245,134,5,172,69,224,43,130,214,166,114,109,237,176,197,153,202,64,121,207,41,51,232,134,53,143,136,175,156,236,75,181,95,132,238,5,237,114,247,98,179,227,228,167,99,184,77,111,155,63,10,167,116,224,14,32,1,250,126,152,249,67,228,248,75,226,40,16,183,13,29,115,253,42,26,164,77,159,222,250,139,15,100,138,108,26,51,83,97,216,245,197,27,201,249,213,143,3,0,136,51,209,218,161,29,109,47,232,242,65,138,202,218,245,45,209,164,46,77,86,87,210,177,164,104,176,152,196,104,97,175,220,229,82,85,15,218,94,2,190,164,229,
209,201,73,69,196,207,162,235,69,77,118,249,178,150,215,8,141,42,99,110,251,67,212,227,18,218,40,117,146,192,35,161,47,163,76,121,148,230,125,110,43,254,36,226,98,115,105,2,40,119,194,18,30,19,177,157,18,217,63,159,186,124,133,212,0,68,204,95,166,14,5,6,24,16,95,136,28,41,206,114,87,91,90,22,186,182,169,249,124,240,255,147,215,10,203,57,181,145,10,23,219,111,43,140,173,187,149,228,230,213,77,149,62,55,180,24,230,234,3,79,75,109,247,190,181,195,200,135,139,95,120,247,60,15,82,251,29,244,150,209,200,169,102,255,210,229,35,7,145,243,234,158,155,224,26,145,82,199,210,18,18,248,84,88,136,18,66,154,128,145,65,122,219,246,67,50,47,46,152,25,31,245,82,49,62,15,176,189,73,39,18,228,200,160,155,76,179,192,68,40,156,159,20,80,44,253,229,214,141,229,182,126,186,105,154,184,179,137,109,215,167,15,131,204,83,63,2,111,131,224,117,181,246,255,0,245,182,177,194,122,109,132,224,237,101,158,15,63,51,26,84,121,209,60,145,127,161,113,136,199,216,202,29,183,198,242,175,31,74,237,123,215,59,79,230,
111,67,234,3,242,81,126,186,141,188,219,181,117,248,233,69,210,187,139,222,132,218,107,110,242,87,122,179,215,36,78,204,134,41,238,204,95,233,62,48,123,191,31,72,42,174,75,117,109,186,158,115,109,214,144,17,188,52,156,146,74,89,147,103,88,43,57,23,167,143,116,3,19,73,153,201,100,237,184,205,170,255,229,85,121,65,46,206,117,144,15,217,20,223,239,84,211,208,121,244,57,24,10,72,218,136,44,139,154,21,129,16,104,145,130,142,45,156,63,23,253,156,127,173,120,215,176,217,121,132,188,74,4,229,104,36,211,21,33,51,92,38,111,127,254,40,143,24,131,206,22,18,228,26,119,140,73,60,226,98,166,56,73,227,212,21,247,126,216,252,66,26,196,15,135,146,71,248,122,188,158,65,188,235,253,228,206,244,145,212,253,151,51,60,175,206,229,91,143,227,108,173,184,150,163,230,233,126,99,206,146,86,179,21,237,100,215,23,14,137,60,146,113,15,28,166,141,80,160,207,97,157,248,83,1,146,205,4,241,1,174,178,253,15,64,218,159,194,60,131,83,75,114,169,111,125,111,26,98,117,83,167,248,127,32,180,255,19,177,177,21,17,139,
61,21,135,176,241,246,163,40,158,16,134,11,182,21,151,162,208,210,31,130,104,29,159,182,37,110,118,15,206,235,70,18,164,38,193,190,210,55,131,174,109,5,138,153,74,76,103,130,52,105,247,57,143,242,72,60,219,11,229,35,115,134,243,187,193,99,113,52,181,143,79,37,129,205,73,27,226,207,139,169,174,199,96,48,11,134,149,62,238,211,62,88,14,192,19,227,245,241,108,229,38,48,61,30,219,184,151,212,86,56,183,202,75,166,189,8,203,207,85,53,252,239,142,153,34,252,199,242,10,58,106,136,169,199,144,122,36,234,205,112,207,73,108,10,97,117,240,180,216,160,170,233,122,109,185,231,124,170,187,93,91,56,95,120,21,246,224,132,176,92,176,62,71,145,145,167,162,111,155,94,243,120,219,147,89,51,157,57,31,41,237,40,147,125,177,117,170,231,46,203,197,122,214,156,138,211,223,119,159,11,255,138,20,71,84,160,95,183,130,220,93,163,217,203,97,201,73,153,56,83,163,191,131,159,158,30,150,68,221,161,189,196,203,237,9,162,27,36,254,126,223,214,122,179,143,77,33,95,16,114,188,49,188,57,139,107,13,176,153,158,161,247,
255,0,220,56,71,7,75,43,141,31,102,204,102,104,81,216,165,216,190,135,99,198,187,220,240,91,238,73,43,118,164,138,206,248,216,173,52,161,163,3,191,201,17,249,68,185,163,123,110,39,249,99,106,225,77,242,11,132,42,184,92,222,28,36,243,249,119,37,165,240,18,156,211,44,231,198,68,177,219,242,242,25,203,138,210,152,148,183,118,224,67,28,96,249,60,177,51,112,11,76,162,176,253,164,121,48,213,148,118,48,119,22,118,68,44,247,196,191,188,212,13,203,9,157,119,38,87,119,14,137,47,169,191,189,173,203,149,50,66,155,151,18,101,188,228,21,90,34,29,128,86,152,34,6,239,169,111,166,35,123,94,7,59,42,53,180,49,99,183,197,184,208,182,214,97,133,74,172,155,19,86,91,67,234,135,109,71,182,163,176,148,22,91,234,22,204,87,197,199,142,40,115,14,250,119,247,122,210,209,156,141,162,101,249,143,115,50,172,241,83,53,3,47,142,56,190,187,96,185,201,177,198,219,150,170,226,12,18,65,186,1,230,114,221,178,12,2,41,133,233,80,153,249,111,178,100,238,169,158,137,32,213,50,23,169,116,69,180,245,245,33,119,8,229,68,
39,93,156,244,164,35,49,161,163,166,209,190,255,150,186,117,105,66,88,158,251,49,19,129,232,246,48,224,157,133,221,7,185,135,102,142,159,220,145,216,84,83,114,167,103,70,141,155,44,249,66,236,222,82,58,204,191,158,187,144,137,0,32,69,222,99,253,210,49,80,97,47,210,216,176,229,219,83,217,23,245,171,175,8,215,10,229,55,210,249,56,219,42,96,119,114,80,152,86,60,139,238,46,175,69,250,245,203,195,49,6,178,61,144,182,146,171,3,32,203,237,153,210,51,144,216,199,68,123,208,184,174,149,27,100,75,250,7,237,170,79,184,231,180,177,182,40,137,89,232,10,144,248,106,18,160,140,131,177,43,217,38,78,63,155,35,42,78,144,205,90,217,7,187,249,113,185,118,175,61,76,240,254,213,151,177,88,195,111,230,24,208,84,21,36,25,70,21,216,56,209,74,96,119,186,90,137,160,239,31,160,170,165,69,59,98,57,83,28,88,10,176,88,79,109,135,104,182,3,107,4,153,153,46,151,89,235,247,27,63,44,62,175,77,221,48,136,45,115,11,106,103,26,53,2,119,241,129,198,3,161,172,210,63,14,37,191,99,238,201,193,18,195,67,41,252,49,194,
82,18,249,213,89,233,38,102,160,21,101,169,20,9,195,42,71,246,85,169,158,3,244,239,135,1,34,246,218,148,198,70,134,74,164,241,89,62,125,22,166,57,131,209,195,45,173,179,25,115,213,55,180,102,20,226,129,156,250,40,70,29,107,132,208,31,242,165,203,241,169,179,118,130,68,107,69,56,47,74,108,203,82,213,84,85,162,243,33,52,208,171,206,98,190,124,41,232,213,86,21,240,197,178,195,185,227,138,60,135,228,48,166,140,65,218,43,34,28,8,37,118,132,153,174,219,130,227,136,103,89,109,73,149,152,59,229,10,165,209,92,185,177,190,167,143,121,119,173,37,61,217,178,130,91,178,5,247,98,138,84,52,78,206,103,66,114,232,33,101,60,253,84,245,81,139,150,3,185,167,137,102,184,33,171,70,245,247,93,18,199,57,4,208,214,30,197,194,70,189,112,236,184,206,116,131,165,190,102,156,208,74,242,84,37,198,111,157,99,45,166,55,190,136,61,69,13,147,23,52,212,178,57,42,215,210,178,252,115,187,25,173,66,68,226,124,105,155,137,74,179,223,106,240,210,157,79,201,106,107,187,9,237,44,237,45,253,187,211,235,198,79,158,64,252,
23,77,198,73,209,215,95,175,205,140,215,111,184,233,86,89,53,231,211,158,108,126,74,91,185,234,221,2,35,173,237,192,180,82,6,219,73,0,135,13,172,217,51,103,131,193,142,108,112,147,226,121,84,114,212,136,219,61,180,232,212,252,212,157,122,188,182,186,56,163,141,99,80,28,193,153,217,121,46,19,41,212,227,8,211,47,157,214,217,11,203,217,169,82,204,247,202,80,46,183,13,14,172,45,215,118,118,242,83,138,246,250,50,105,242,94,249,68,241,158,216,72,105,45,222,247,77,213,50,67,125,180,202,236,105,211,49,248,134,15,93,173,128,32,209,223,22,168,99,98,95,46,103,69,146,136,163,205,6,81,80,232,171,150,118,184,58,185,35,89,229,252,156,233,148,186,107,173,24,81,101,133,184,50,193,41,241,101,246,185,23,24,77,169,171,18,121,38,176,242,23,119,25,167,60,209,194,230,131,227,92,207,75,181,82,7,234,254,185,166,36,162,149,245,117,165,231,249,103,205,44,70,111,146,209,209,152,24,34,143,239,20,2,21,43,207,7,230,134,58,76,212,42,225,106,154,93,177,47,211,184,115,190,77,208,211,36,143,69,209,215,88,31,13,
8,236,185,234,204,148,103,237,252,248,253,48,196,222,74,4,243,145,249,52,87,138,51,152,3,171,25,88,147,111,74,25,221,175,128,47,245,247,158,135,29,233,95,174,154,170,4,22,155,245,140,150,101,101,51,184,20,211,220,221,10,243,228,178,200,98,94,58,234,76,203,160,44,125,225,142,8,131,224,87,195,18,155,131,199,199,25,38,38,195,143,54,159,93,220,31,135,183,231,131,21,137,100,154,31,222,88,196,244,224,93,68,110,14,130,98,100,232,46,62,229,33,205,70,10,125,82,69,49,163,52,19,203,105,61,74,163,161,22,205,116,212,75,39,8,189,237,39,73,195,185,189,23,70,22,178,89,207,149,37,171,8,226,0,179,255,109,46,81,124,45,199,188,69,164,34,4,104,210,163,101,53,253,185,84,221,243,167,124,93,201,215,177,61,93,227,249,120,106,57,54,118,15,113,41,75,108,45,12,201,52,55,251,168,222,25,247,48,57,134,47,196,202,161,44,38,245,228,160,155,246,39,103,60,67,121,51,135,219,232,15,172,241,228,81,154,42,36,110,186,241,2,43,191,194,98,115,121,213,92,65,122,61,76,175,35,146,200,152,84,151,143,64,210,154,4,76,237,147,
84,179,236,120,11,118,152,171,45,233,106,221,248,157,21,179,139,165,19,165,115,40,71,201,24,201,124,251,145,67,143,177,142,173,169,9,182,169,119,87,99,224,113,243,242,189,174,245,255,168,190,100,32,195,5,134,223,66,185,235,111,247,134,124,110,147,187,46,197,15,201,116,83,193,175,13,56,247,206,224,108,162,195,242,91,188,225,169,135,45,141,82,198,89,49,54,228,118,86,35,239,204,172,17,125,195,128,16,15,248,227,72,22,240,37,146,213,47,122,216,64,150,211,65,20,196,200,182,203,245,97,27,240,15,16,26,166,91,234,28,129,85,5,19,249,134,111,61,93,230,32,249,167,207,165,251,16,253,169,125,141,208,246,40,134,32,78,210,54,39,115,124,151,238,6,171,142,97,68,17,229,200,33,226,132,54,149,6,121,110,11,89,125,86,142,96,163,63,35,62,175,94,151,216,75,200,44,231,16,129,189,19,248,121,51,69,12,95,56,91,193,98,237,154,147,18,175,237,251,30,3,80,100,58,7,254,162,238,59,95,172,164,47,188,162,157,81,21,0,89,198,139,35,26,101,41,141,177,50,153,255,108,134,153,77,38,198,133,191,78,230,36,29,239,59,92,249,
178,210,187,174,115,41,250,201,124,164,19,159,189,132,63,209,14,131,238,81,65,187,60,108,182,61,198,105,178,60,166,233,46,41,138,2,79,236,154,21,251,154,165,243,24,166,243,113,172,214,103,118,221,122,126,18,26,47,239,124,117,181,254,136,7,168,170,27,37,133,190,215,20,105,226,33,82,106,246,46,4,24,77,69,56,124,15,39,223,235,123,48,248,234,151,171,143,79,187,22,22,102,175,148,201,191,86,208,124,98,129,43,132,18,5,121,241,141,186,226,48,72,108,24,18,15,138,138,136,53,243,147,7,89,136,208,144,222,147,163,125,252,163,28,11,223,178,58,183,62,141,50,36,70,213,35,54,243,82,253,89,66,185,170,220,147,3,188,196,43,83,238,119,159,60,245,48,179,177,11,216,251,167,22,89,66,169,31,102,230,164,52,190,101,19,143,50,182,219,77,137,93,185,145,129,230,209,23,142,11,232,47,156,58,150,115,30,6,142,135,4,18,120,65,77,95,78,36,188,134,169,190,75,150,120,20,185,60,115,19,156,235,246,43,143,21,74,58,125,18,29,83,65,78,122,191,192,173,41,31,121,231,122,118,18,64,125,245,71,202,125,7,140,107,42,220,245,
96,94,66,128,26,227,39,235,215,198,24,110,8,202,203,235,139,136,13,225,23,182,86,40,228,131,111,52,225,234,26,92,158,123,204,206,18,24,44,155,36,34,106,176,210,29,93,36,205,177,152,239,201,245,96,147,59,174,148,51,163,104,145,248,189,130,121,41,29,102,236,26,211,195,232,144,121,215,195,104,242,69,131,113,61,83,142,112,62,178,172,173,127,188,22,87,204,244,202,188,250,211,154,96,198,131,15,226,16,125,71,230,87,168,33,198,50,56,79,103,81,83,113,231,85,60,186,164,222,107,246,62,12,42,218,36,38,153,166,43,126,128,168,152,52,160,8,31,155,205,205,48,217,79,50,73,232,124,185,111,140,112,6,93,226,201,161,50,205,35,175,1,10,8,245,223,73,155,92,19,187,87,10,249,83,68,16,123,83,92,14,31,63,194,85,198,180,175,175,233,9,196,242,185,226,3,63,171,11,104,89,98,22,17,129,75,100,61,164,111,41,149,66,255,38,102,83,33,238,111,234,242,131,220,183,199,154,39,236,120,156,108,12,133,77,180,222,241,156,94,182,73,91,177,206,149,17,250,151,46,37,120,63,241,88,52,172,31,74,132,155,86,174,198,108,111,84,7,
127,245,46,34,214,130,47,84,9,133,8,108,68,189,119,107,37,47,149,90,136,181,16,55,255,29,148,143,11,131,47,233,113,62,103,10,90,195,24,246,7,134,75,9,254,112,88,233,146,88,236,198,94,46,9,61,107,169,247,153,160,128,16,65,91,36,241,174,123,133,194,61,251,165,131,53,0,134,164,20,99,98,52,91,87,90,230,99,13,227,135,69,19,56,22,174,189,88,105,147,143,235,74,221,252,141,2,25,150,124,42,216,116,233,104,91,212,35,249,220,73,209,94,38,195,152,16,111,252,246,143,51,189,95,125,193,170,183,188,127,10,141,122,23,165,36,107,15,37,34,235,59,102,72,104,212,216,239,117,123,55,146,10,32,117,205,238,191,141,86,53,92,43,252,152,180,51,184,121,74,218,28,39,201,119,60,91,196,181,229,175,134,11,34,176,11,7,90,67,94,195,143,149,225,182,231,99,65,236,219,185,240,191,205,236,97,113,246,59,71,223,159,238,137,219,15,165,171,96,2,226,16,98,115,195,31,169,77,31,154,45,38,67,162,33,238,194,236,86,124,51,125,179,145,7,218,170,211,247,220,93,117,187,134,79,229,82,206,213,135,57,45,97,37,127,6,22,37,212,159,
227,66,83,66,118,127,245,178,201,98,203,150,196,7,238,183,79,234,140,56,238,128,112,236,125,25,118,118,94,61,250,128,244,156,87,149,17,9,142,14,61,162,51,50,188,65,180,113,155,134,243,167,53,82,42,54,84,126,136,253,21,227,119,166,182,135,71,64,137,43,222,200,21,231,169,246,202,21,227,143,61,253,246,124,61,237,78,110,56,148,10,50,187,87,112,221,131,4,221,161,71,63,213,139,28,13,127,158,77,38,23,234,47,197,225,15,53,202,30,83,185,168,49,5,37,168,139,230,79,251,126,77,61,81,161,143,212,41,196,188,208,183,118,74,133,84,254,152,37,56,104,113,60,0,85,177,105,138,9,31,32,89,84,48,59,154,87,34,98,8,158,191,72,234,120,197,122,3,28,239,198,11,137,106,111,95,25,231,254,116,5,154,223,35,95,241,233,117,224,66,206,110,250,224,167,191,41,246,60,196,101,166,175,40,194,239,109,148,249,102,178,195,61,5,109,3,219,142,202,2,207,74,3,206,6,18,4,223,195,93,119,128,36,142,246,59,24,181,253,130,42,140,48,114,1,138,254,13,67,55,19,64,98,126,213,64,8,70,39,220,98,71,191,146,232,59,204,89,184,59,87,113,
117,25,160,121,115,24,120,64,69,246,199,79,105,160,3,28,38,101,85,233,247,237,120,216,167,6,115,82,40,28,211,249,7,70,189,152,139,255,112,208,190,128,105,115,217,153,51,133,198,244,138,152,71,86,243,132,219,116,90,54,251,212,89,206,90,167,195,146,174,35,252,139,161,5,165,31,200,144,180,40,114,207,136,5,55,233,70,19,215,134,242,52,98,216,99,229,205,248,180,189,189,192,249,155,88,230,131,22,217,73,15,36,11,188,24,171,226,225,24,134,150,127,195,217,18,183,200,199,103,226,67,33,118,154,150,6,95,82,178,34,93,174,38,143,243,13,46,96,14,77,89,251,177,221,107,186,212,75,248,161,169,37,122,87,236,107,133,37,135,130,140,245,247,155,179,218,3,35,145,92,178,201,146,242,149,162,93,239,117,139,226,205,159,162,35,216,75,72,242,177,109,147,164,166,163,142,172,232,205,137,77,0,1,57,22,243,136,0,200,69,105,219,34,111,209,99,23,205,252,247,227,171,32,5,215,40,96,147,72,114,163,233,61,181,126,11,81,161,7,101,104,100,238,215,177,7,81,250,115,14,85,65,144,81,136,226,92,93,116,186,51,53,59,208,8,156,
253,80,242,212,205,251,132,142,242,133,156,69,254,3,236,84,32,55,178,144,97,168,196,198,221,192,63,192,133,94,53,145,162,2,183,94,161,103,225,138,14,18,52,156,77,191,138,146,81,102,88,254,1,144,112,11,36,71,59,113,124,15,79,215,239,30,18,120,171,118,115,115,91,99,71,107,253,199,87,26,151,201,38,248,25,28,158,41,121,79,142,191,171,242,225,209,219,94,23,229,97,205,235,132,25,134,155,198,42,120,174,83,24,41,151,105,73,138,253,8,78,142,250,220,242,55,20,53,217,235,161,53,209,229,241,37,18,51,119,47,191,109,60,178,212,193,105,158,202,7,191,168,161,18,43,43,244,209,31,122,186,230,188,14,157,191,93,133,12,179,102,48,143,53,190,193,39,146,117,186,74,212,240,248,7,104,212,76,93,2,54,254,45,44,91,53,83,179,52,52,69,117,117,154,49,202,43,74,44,204,59,186,230,141,32,142,238,222,249,16,58,187,65,253,214,182,166,133,215,173,38,129,21,181,86,203,59,239,94,25,110,185,71,196,135,139,49,214,4,73,159,75,151,15,214,225,175,30,250,232,168,185,187,98,116,86,77,38,64,60,201,165,101,154,63,179,179,107,
146,89,54,237,57,94,214,31,239,8,226,206,14,90,186,233,217,250,63,26,142,121,107,212,134,216,134,180,118,108,122,249,27,156,60,110,119,130,113,17,218,240,230,50,19,13,79,79,26,137,200,98,65,179,113,155,76,69,71,49,163,236,175,151,42,204,133,35,173,33,100,162,183,162,195,73,177,230,244,173,211,203,164,59,155,218,239,88,99,118,115,128,121,108,52,0,213,131,181,52,179,242,232,46,108,155,237,66,50,191,92,139,112,123,243,3,179,76,246,191,207,145,71,148,59,134,35,155,112,60,188,125,25,226,195,156,207,5,12,23,173,113,222,106,246,206,123,139,194,180,153,142,238,244,89,28,43,67,197,36,207,15,149,63,97,94,69,81,85,87,206,122,229,139,189,105,250,142,68,137,217,57,146,245,70,145,82,94,238,126,177,170,136,249,10,136,217,218,82,35,232,239,94,65,119,55,8,244,45,142,115,94,134,228,127,12,145,156,151,229,183,151,240,44,214,33,80,82,227,225,207,159,18,174,81,105,39,246,73,59,95,183,75,89,19,215,136,158,8,67,50,16,122,23,67,64,66,36,173,95,196,80,99,198,159,114,163,49,137,168,195,95,216,227,192,
23,113,8,211,56,36,116,136,122,24,89,239,231,107,182,105,42,61,84,254,84,102,9,185,159,121,150,137,206,22,122,93,27,168,211,54,72,99,21,113,175,191,88,204,179,0,141,219,189,97,111,21,244,92,12,229,90,113,120,246,10,115,190,35,99,203,15,23,187,168,214,190,54,222,86,124,146,43,39,214,78,153,37,84,152,169,0,72,6,183,210,58,63,29,123,21,158,93,115,53,31,16,118,125,108,254,230,35,88,36,194,111,197,230,55,127,23,119,140,81,27,38,253,246,244,101,237,229,206,165,154,99,100,14,46,129,199,235,181,218,110,185,106,208,115,99,35,120,15,227,158,246,43,212,218,149,235,179,66,201,191,178,175,68,168,79,107,139,49,125,238,62,32,162,239,60,120,55,191,32,20,28,101,251,129,11,230,125,48,228,170,19,211,17,39,132,37,88,77,222,138,102,212,54,214,143,112,244,35,124,161,211,245,37,232,77,117,99,93,30,99,132,93,202,79,28,211,115,201,187,254,239,43,38,25,148,170,46,191,13,214,159,86,122,219,29,16,73,134,109,57,36,192,89,87,10,215,59,110,164,37,152,250,192,123,154,180,68,105,215,36,12,147,255,218,244,28,
184,194,218,94,139,229,74,49,230,38,2,217,255,181,17,29,166,13,235,80,44,217,161,74,87,39,208,58,120,77,113,159,166,158,6,122,59,183,123,161,223,235,212,169,102,172,196,0,161,169,159,190,170,243,107,91,32,101,223,153,59,93,230,139,142,165,10,32,191,166,87,189,172,225,213,142,144,77,112,110,154,165,62,65,148,233,193,40,230,22,186,31,13,108,182,3,63,113,197,255,65,209,152,193,4,195,206,138,1,115,82,191,10,85,67,85,154,245,228,38,121,254,1,140,1,121,226,211,198,105,191,174,133,117,69,203,247,64,70,130,167,178,228,152,161,91,116,205,194,223,112,89,19,5,126,145,180,202,58,100,229,38,222,223,86,73,4,21,194,146,175,22,170,56,106,126,120,56,54,74,254,228,75,80,55,99,211,48,19,87,0,118,19,17,79,155,254,156,84,163,201,149,19,219,242,250,17,216,207,26,10,196,123,207,167,19,150,24,204,169,19,251,215,238,155,20,212,201,109,76,40,212,214,201,138,153,224,70,58,244,97,254,216,209,191,147,101,86,253,122,250,43,138,224,135,46,164,161,224,200,75,165,55,215,29,166,127,95,219,206,191,243,216,218,
58,89,251,81,24,53,135,114,151,5,20,36,57,86,250,89,90,144,253,129,20,151,149,56,122,164,202,217,74,143,43,113,146,208,227,201,173,137,236,249,143,66,24,180,152,66,253,108,35,120,185,136,169,121,223,76,176,247,221,245,75,133,144,189,104,87,193,113,81,222,170,36,3,198,159,38,69,118,137,150,153,154,55,37,59,136,114,139,102,191,24,45,199,107,195,147,165,69,201,17,123,93,156,149,42,224,34,19,16,147,109,54,185,0,56,142,111,136,29,209,155,1,240,226,186,231,114,227,11,212,94,83,218,133,56,237,125,253,251,170,17,166,219,53,215,202,240,116,54,91,179,1,124,120,83,52,181,165,187,168,227,172,202,238,13,46,145,172,208,137,63,92,76,207,172,143,115,68,153,115,226,16,185,212,175,92,252,185,11,218,75,73,163,222,186,129,37,170,246,63,28,8,51,50,167,166,236,85,74,79,113,234,124,206,155,108,251,64,36,13,75,224,57,113,223,200,227,226,1,182,201,210,170,148,169,216,11,188,72,151,210,194,34,254,210,197,107,181,243,36,122,178,84,161,255,238,190,56,95,6,161,113,68,124,93,247,122,177,231,37,60,195,244,
89,129,180,234,235,59,230,148,241,159,180,141,253,117,222,31,38,226,19,131,143,88,60,227,161,117,205,0,63,243,132,115,3,189,238,118,139,86,13,194,120,224,144,206,129,235,64,119,214,96,199,179,194,40,175,249,250,57,40,91,161,255,215,188,166,154,245,175,11,91,125,73,170,3,23,181,237,34,95,138,84,23,163,41,60,59,86,7,220,167,246,197,166,143,101,41,136,234,68,138,3,165,51,51,8,124,181,229,134,238,68,73,99,106,182,110,109,255,130,255,80,9,87,217,110,213,145,28,225,208,162,194,203,92,241,50,134,159,185,228,80,142,38,151,39,199,193,77,157,64,49,242,33,73,202,15,86,35,33,87,224,23,244,218,254,251,61,87,240,87,229,48,32,177,212,179,109,105,124,253,214,102,137,214,88,82,35,51,158,18,125,31,22,129,71,113,42,76,6,40,237,241,244,136,37,244,115,156,179,89,47,44,239,107,158,186,219,152,72,157,231,222,186,179,176,43,158,102,138,95,220,176,243,199,148,22,165,10,227,222,108,151,211,229,23,11,184,119,208,141,134,155,83,17,66,227,113,19,251,57,47,23,254,165,228,64,18,199,37,97,199,182,111,11,205,
189,120,142,207,185,199,90,50,106,246,226,204,223,165,20,188,239,37,227,240,60,54,151,166,173,58,92,122,200,140,101,174,17,93,54,245,39,229,31,179,123,149,62,61,151,2,55,112,98,46,39,123,211,40,97,245,134,173,146,59,123,183,135,237,252,182,217,158,49,124,50,152,192,202,65,85,6,110,33,111,186,60,119,118,224,157,116,50,215,138,178,140,44,117,152,13,17,5,31,179,168,121,17,231,151,48,245,112,84,39,232,238,102,164,205,244,157,43,70,121,5,102,244,228,97,120,149,220,225,207,191,3,233,79,251,92,215,189,157,99,145,158,6,26,31,48,81,58,44,204,125,231,80,16,32,26,25,235,103,184,74,114,104,13,177,70,89,113,182,44,91,201,255,54,148,16,21,85,142,2,75,109,236,47,15,200,218,190,102,50,150,23,83,22,17,47,131,67,129,164,12,240,250,243,164,193,2,230,207,245,169,59,127,180,221,250,208,27,217,86,160,137,18,73,139,221,120,255,149,178,182,13,122,139,5,25,66,98,183,185,49,183,36,91,172,84,66,216,214,248,104,225,76,55,100,119,122,255,75,139,255,159,49,239,191,95,149,53,159,1,130,80,162,224,51,46,248,
183,21,209,112,47,11,76,99,129,167,18,163,194,83,10,26,196,4,129,45,211,57,151,66,16,133,13,113,138,3,63,204,188,228,209,28,33,139,234,150,133,143,138,142,151,195,12,89,160,89,74,251,150,97,77,221,123,112,208,13,83,38,179,117,0,222,21,103,210,250,112,24,76,150,242,161,102,228,101,220,30,111,233,152,212,226,98,149,168,185,99,110,71,22,115,218,108,40,251,248,31,214,102,237,252,63,74,100,31,215,62,21,219,108,230,221,156,202,82,137,234,156,203,157,25,138,206,6,13,197,193,254,58,125,225,113,55,108,205,49,201,203,48,6,76,4,127,210,10,99,125,215,17,239,147,236,121,189,190,88,103,127,71,237,181,65,183,68,173,198,130,33,178,26,254,83,252,126,149,214,81,4,170,158,238,30,97,76,109,243,185,240,60,241,56,194,126,76,100,189,119,213,225,160,238,156,215,240,31,0,166,124,115,89,119,23,11,94,234,232,125,112,248,100,29,16,25,89,5,46,129,61,198,160,20,159,164,176,7,60,175,156,154,189,127,128,191,97,36,67,160,135,10,69,148,2,251,2,212,250,155,57,37,122,212,243,186,182,92,225,188,146,171,250,56,169,
226,216,12,59,89,105,59,129,48,59,35,134,129,250,250,137,103,217,120,160,200,187,250,73,84,51,113,158,13,162,58,79,250,157,95,176,19,51,1,203,104,121,11,77,150,2,35,239,74,27,221,189,192,221,212,26,201,219,181,80,71,24,29,237,100,124,187,237,159,186,29,122,185,67,247,189,0,123,190,176,72,168,67,41,156,23,161,114,251,165,144,4,190,8,81,108,78,64,52,214,199,119,94,204,215,201,37,174,179,97,212,61,170,171,246,249,143,18,23,187,1,107,212,147,242,82,174,136,181,60,77,103,80,25,186,81,194,6,132,90,183,125,96,122,139,89,239,120,229,49,61,1,247,117,141,140,179,252,64,47,9,119,179,94,52,129,243,158,14,77,46,24,227,137,13,163,254,138,99,35,231,190,39,250,233,232,202,63,72,101,135,24,199,95,201,172,209,228,73,224,45,102,64,126,85,44,147,171,51,52,254,145,143,94,199,172,55,90,216,196,217,216,209,255,244,211,149,21,23,150,4,153,204,103,159,106,71,48,145,121,252,181,199,230,221,10,61,52,105,255,203,91,141,95,74,166,212,102,107,11,138,224,188,171,68,251,160,62,233,103,78,254,103,158,24,195,
230,148,185,122,121,230,176,59,11,171,222,145,165,181,118,21,37,167,164,247,199,134,244,231,9,126,131,148,212,205,45,196,143,188,16,164,180,25,44,196,190,40,74,92,106,134,41,58,186,239,97,191,88,202,177,202,161,228,36,226,44,70,55,218,253,16,151,21,3,102,254,197,133,169,37,156,237,163,66,28,101,58,179,93,247,75,162,80,157,102,17,116,181,16,240,94,56,170,217,84,238,67,235,208,191,145,30,196,165,44,196,150,220,4,204,150,6,46,183,217,96,80,137,147,21,75,185,186,63,251,170,21,2,155,110,21,78,115,42,219,14,133,21,28,52,187,154,110,14,219,58,218,69,60,187,205,123,126,83,125,20,228,118,243,68,245,27,5,51,125,135,192,145,96,152,59,107,203,236,44,95,233,106,65,79,115,229,179,6,62,188,250,176,99,67,240,10,157,58,55,215,119,54,12,119,204,45,180,35,144,195,246,77,97,60,95,110,75,195,236,199,142,197,191,99,125,113,195,154,191,111,28,214,174,64,166,252,62,92,20,173,204,4,243,158,198,107,202,223,135,114,167,2,73,60,205,185,159,26,161,199,245,251,60,97,101,134,175,15,179,90,219,193,179,121,5,
92,23,153,177,143,171,103,4,185,49,128,9,208,119,51,255,72,165,199,110,13,64,128,226,55,155,208,134,73,12,52,163,220,237,188,66,238,159,11,38,40,184,75,206,21,4,194,55,161,26,154,173,35,36,28,56,201,15,41,186,249,145,243,231,242,205,213,115,85,78,143,239,94,69,248,103,25,125,226,59,237,117,84,93,110,249,164,251,174,240,187,8,237,176,50,214,6,10,64,225,64,221,242,49,167,56,255,104,200,199,153,89,71,99,39,227,197,92,119,27,30,159,95,165,242,1,116,35,161,252,93,188,231,29,206,174,208,132,178,48,1,242,134,196,139,131,54,233,174,207,146,99,15,124,43,192,45,189,235,164,161,96,139,62,138,127,128,231,94,129,167,142,16,252,226,227,2,106,55,231,19,82,133,247,47,104,232,191,210,181,83,210,171,222,159,13,128,233,121,144,116,26,82,1,81,105,142,172,113,31,90,76,152,59,59,153,149,220,209,243,194,113,104,53,1,226,215,100,91,72,222,37,158,46,131,157,4,144,201,60,142,227,49,108,197,95,245,82,0,36,119,34,97,16,29,219,191,48,188,227,178,55,241,178,233,170,231,32,197,2,95,231,133,249,233,10,187,253,
213,218,195,221,109,109,115,240,139,161,2,202,139,219,2,131,19,223,241,22,138,26,170,241,194,157,88,228,87,230,16,189,61,207,205,4,171,225,142,210,33,235,151,81,35,56,235,209,119,95,248,33,123,134,190,40,53,43,177,116,199,34,138,188,7,99,222,139,210,53,92,233,37,223,6,174,74,122,131,200,251,240,211,227,213,26,7,59,106,174,28,172,120,171,142,15,15,25,243,81,59,167,97,83,175,40,117,233,229,134,189,63,176,47,148,40,253,209,123,20,85,155,129,245,207,85,170,166,150,235,148,239,74,28,71,10,231,114,186,27,83,176,74,87,73,184,180,193,114,174,19,119,164,7,133,63,77,105,196,139,159,233,222,19,106,203,194,25,80,148,83,175,70,110,152,217,179,244,130,110,206,148,57,150,199,18,225,89,35,149,209,131,56,192,53,56,20,229,44,80,26,112,77,148,161,184,224,236,205,178,228,121,214,188,129,141,168,79,219,115,129,150,201,33,56,111,101,112,103,247,113,246,99,35,32,140,209,250,180,56,76,12,75,219,101,165,84,153,115,30,169,180,33,54,31,151,151,142,203,79,234,46,120,120,227,192,152,82,162,85,254,19,220,
39,250,59,179,39,174,168,240,34,152,125,122,9,128,20,66,59,246,250,255,68,46,254,59,126,65,54,24,228,122,113,2,38,232,121,233,151,59,148,216,111,62,62,165,24,205,74,149,28,207,106,181,22,247,215,113,199,2,206,94,62,244,177,12,46,56,136,196,111,77,14,46,209,107,19,53,192,35,102,100,123,240,133,114,41,185,26,3,224,175,148,174,120,14,10,46,125,54,165,46,133,106,15,170,254,163,43,165,233,28,189,248,168,60,237,144,57,240,250,89,17,228,163,81,206,247,34,172,34,162,64,157,44,230,43,67,193,118,46,207,185,102,123,139,177,76,225,20,254,123,148,168,129,255,124,250,229,220,113,14,238,250,70,146,42,32,5,96,179,159,127,171,188,251,93,103,172,114,71,140,105,54,148,1,57,28,37,63,126,101,156,19,18,9,248,221,252,134,115,144,210,19,101,16,164,126,39,181,216,28,139,173,50,47,126,70,113,37,28,233,26,25,0,185,82,170,68,89,7,233,44,182,42,255,1,202,246,173,87,97,36,138,104,56,156,111,197,102,249,248,87,190,97,83,150,159,145,181,239,101,170,79,80,11,74,62,83,160,226,10,64,59,54,117,41,169,4,198,214,
150,41,102,159,92,59,234,15,213,22,134,40,34,143,80,171,1,124,241,219,32,200,204,159,203,135,127,213,164,112,115,77,44,33,88,32,56,56,116,12,168,122,192,156,202,102,153,184,72,206,184,129,22,121,144,9,28,130,172,229,205,60,155,88,183,223,152,116,170,97,34,167,118,160,227,254,40,37,250,168,9,78,232,158,244,244,21,16,170,46,142,253,80,2,120,49,151,51,103,137,119,192,216,192,226,190,159,135,226,74,1,26,223,50,104,6,212,56,95,138,29,149,191,68,229,200,65,83,41,133,12,151,216,80,89,90,96,116,151,82,112,209,174,201,40,245,138,222,170,112,245,96,144,32,177,162,78,255,195,205,93,77,62,30,219,245,25,137,209,81,7,118,246,179,136,113,210,43,205,205,182,85,107,148,3,27,24,32,16,224,107,188,187,205,241,220,67,142,146,172,123,91,50,205,117,231,21,139,10,206,218,35,61,237,252,13,89,36,120,27,244,27,169,84,153,225,248,245,35,42,136,74,255,196,78,187,30,85,137,85,233,144,197,87,152,209,128,151,150,90,222,38,108,167,44,237,56,217,197,93,1,254,232,151,26,44,52,106,60,126,76,42,251,203,51,52,228,
240,33,34,3,81,213,125,165,44,181,56,97,53,153,121,210,122,128,247,158,1,150,167,39,199,54,109,44,245,139,142,61,213,233,40,53,228,114,179,240,254,67,225,226,15,108,30,247,197,52,131,44,167,204,205,155,191,133,191,22,128,77,56,51,189,165,31,149,224,118,215,87,192,187,118,68,47,179,121,199,124,100,94,160,28,149,244,176,189,9,123,22,8,149,233,27,144,127,233,162,198,15,77,84,121,192,219,218,235,113,172,170,253,94,113,170,143,20,116,152,46,242,3,42,205,212,24,126,169,186,225,100,153,155,18,16,188,79,125,70,38,35,22,128,140,231,171,93,14,2,193,13,144,89,47,232,254,1,12,58,224,37,21,166,10,180,131,48,228,203,70,215,77,205,46,233,254,107,186,239,183,180,85,30,16,231,154,138,230,89,6,51,142,62,15,31,112,181,251,209,233,252,63,0,199,228,156,83,230,236,226,180,98,43,101,220,31,185,116,52,100,131,252,196,11,68,47,222,46,226,227,142,125,51,103,165,208,4,21,129,15,127,106,131,128,219,39,151,39,73,98,213,181,43,162,218,171,33,9,194,248,30,179,145,210,23,170,98,226,30,7,215,48,125,175,73,19,
205,121,122,159,172,74,98,41,175,231,202,114,136,36,225,189,197,7,140,142,3,215,151,105,118,13,171,36,176,118,83,15,28,169,56,192,13,183,173,102,227,5,77,76,71,220,23,110,61,32,116,211,48,204,167,163,245,3,252,72,16,30,215,188,237,250,28,84,177,190,14,183,29,82,101,92,56,93,98,212,18,203,7,70,189,3,110,47,229,236,119,177,215,181,180,59,220,82,12,189,90,214,241,242,72,249,21,39,29,12,57,126,239,215,97,63,167,217,188,176,245,201,12,164,152,161,121,177,240,141,53,25,60,29,0,56,172,59,45,159,227,217,96,221,134,138,173,73,240,157,40,45,54,123,77,170,157,242,59,91,170,17,53,179,148,122,146,183,126,51,116,248,89,166,111,215,55,189,148,7,150,216,255,150,127,82,55,31,17,233,0,88,92,234,18,47,135,39,162,145,157,112,178,89,116,108,14,245,202,155,122,21,226,156,180,146,100,249,162,75,61,205,64,147,32,100,235,213,219,51,31,110,74,121,135,1,31,14,205,9,230,164,68,54,156,155,36,107,193,7,141,249,83,50,159,175,107,76,162,142,228,42,141,213,241,170,4,173,115,0,165,146,222,80,160,234,116,70,187,
148,222,106,212,245,15,210,2,80,13,64,17,62,250,93,177,255,246,187,85,142,67,158,72,240,33,134,167,70,22,129,248,153,153,244,231,136,56,168,147,205,202,78,71,130,204,71,212,169,56,204,54,54,95,48,47,226,30,241,145,184,197,23,4,48,36,203,133,82,216,65,218,243,181,111,71,34,21,160,11,222,113,56,229,245,234,70,143,104,115,80,88,162,167,89,111,223,25,53,112,16,156,216,67,180,244,107,67,163,195,188,180,123,130,196,208,95,32,40,161,239,122,10,140,7,120,202,254,150,147,200,172,96,35,174,79,133,169,83,241,127,165,107,235,198,64,171,6,144,227,11,250,219,164,133,84,42,204,22,9,70,158,220,231,148,35,6,89,187,224,38,229,131,217,222,247,33,44,126,13,188,232,8,233,11,138,24,22,239,4,161,99,42,23,12,25,247,54,246,21,34,105,205,103,33,172,176,59,95,234,169,18,255,31,230,146,106,222,254,130,211,156,245,204,141,141,228,172,172,40,63,87,122,244,68,12,177,195,126,179,202,165,113,235,89,161,131,1,123,229,68,234,64,40,63,47,243,155,132,79,154,127,132,61,246,126,124,201,135,208,71,2,248,196,30,180,
217,105,116,64,88,105,66,104,18,116,14,94,82,73,170,85,36,210,71,126,107,41,167,43,161,60,37,86,57,139,63,93,225,105,71,64,195,222,107,38,195,112,117,0,167,118,63,106,242,127,95,233,185,193,251,132,179,72,214,67,118,76,63,73,87,102,130,240,7,135,151,35,115,179,201,17,137,32,161,189,143,122,242,7,61,26,108,201,158,199,113,107,151,35,198,127,228,43,224,227,171,167,28,111,90,27,154,69,9,169,14,135,81,200,244,28,171,197,85,248,194,221,157,137,39,165,100,152,10,200,193,82,72,137,39,73,148,129,170,146,135,116,92,11,128,173,230,210,50,226,250,77,217,157,80,174,177,138,18,240,47,65,85,186,157,126,180,210,212,217,213,247,224,166,105,123,151,57,49,42,70,50,140,68,108,202,157,202,250,177,26,73,11,248,93,18,76,150,108,42,201,10,21,2,213,2,111,22,35,95,86,149,44,115,186,144,187,161,139,79,103,138,85,21,89,207,102,244,9,161,197,62,253,184,28,159,149,174,137,24,31,202,244,105,212,4,121,26,231,144,255,132,26,52,14,23,20,240,51,192,62,69,60,24,200,116,145,112,130,228,169,22,78,129,199,69,213,
168,9,21,207,60,233,82,90,170,241,9,25,13,71,73,152,165,76,47,118,186,135,60,253,34,148,22,184,79,183,26,174,220,202,56,149,135,220,171,232,21,104,101,62,16,122,253,92,247,159,129,176,184,119,203,63,63,4,25,239,4,5,138,101,106,80,175,209,180,174,48,97,32,31,201,22,70,130,190,102,0,59,248,141,75,38,3,179,130,166,221,213,246,31,115,202,152,161,53,88,206,93,115,207,155,171,70,223,45,150,148,63,72,184,195,115,70,230,255,34,218,148,177,234,142,181,63,5,130,30,110,228,31,114,246,133,171,242,235,11,28,241,232,7,149,42,115,192,61,186,247,33,202,173,219,139,47,54,134,219,158,96,201,96,232,64,26,84,156,248,226,197,224,235,68,93,89,154,136,57,201,49,100,120,131,80,176,218,73,29,77,239,213,148,66,80,48,142,48,24,10,119,52,3,15,174,228,92,17,167,12,18,107,252,65,42,198,21,210,72,91,236,66,62,251,12,90,246,14,210,63,137,163,221,82,168,119,184,84,250,212,100,147,83,81,129,220,220,77,203,194,202,252,115,5,151,22,91,187,120,253,95,34,157,187,62,227,216,16,82,201,252,18,19,198,74,195,183,207,114,
181,231,99,52,52,177,149,134,88,153,20,188,159,249,115,56,202,180,251,233,219,188,80,204,173,232,196,74,243,41,171,70,6,45,2,182,151,3,216,230,102,112,36,126,97,63,203,226,121,192,145,23,64,71,124,85,3,126,46,80,126,251,157,245,21,115,184,2,231,67,156,134,204,186,139,119,115,155,83,140,179,39,103,107,143,24,89,196,78,183,5,174,223,99,143,173,118,104,96,43,10,251,134,74,78,3,212,93,66,200,76,50,167,94,39,87,176,182,78,26,5,148,56,219,124,28,33,22,174,41,26,126,138,56,47,4,37,190,111,81,203,198,216,186,195,60,184,55,144,172,52,141,2,5,205,96,43,125,116,239,249,35,237,224,201,43,237,200,164,156,158,235,158,211,101,253,18,141,63,253,106,202,1,215,130,225,74,221,95,81,98,158,151,27,32,224,51,173,90,202,78,57,9,98,206,158,212,245,92,243,150,210,194,192,223,189,120,152,161,79,81,30,238,76,182,71,27,221,15,229,89,233,97,38,155,181,111,32,226,204,12,139,218,54,89,177,254,202,24,42,177,42,250,216,94,41,108,119,103,124,38,127,165,232,251,169,210,8,184,206,210,244,243,77,108,214,82,107,13,
32,164,59,100,2,41,229,26,179,137,33,197,94,245,107,251,111,207,104,203,85,94,252,89,210,158,56,68,51,227,40,227,60,11,241,130,126,135,63,87,227,2,24,86,203,60,241,103,180,245,246,7,232,92,116,124,139,192,231,99,65,247,241,223,149,255,43,64,125,143,178,192,72,66,135,207,151,250,224,215,66,204,166,199,173,177,128,17,165,209,94,65,175,7,223,186,201,39,22,122,142,101,122,135,7,87,212,177,119,208,225,11,250,17,141,87,3,51,252,252,135,45,33,214,80,119,72,46,251,40,37,44,185,164,238,81,239,202,90,222,166,13,163,140,13,189,160,132,119,12,162,110,240,166,162,125,205,177,120,225,13,3,245,158,235,38,115,222,12,150,205,156,117,224,2,21,206,164,97,126,247,40,153,170,226,65,1,27,26,200,115,121,54,34,46,180,135,72,82,231,115,126,5,186,183,67,138,9,77,226,130,145,245,53,76,59,246,25,192,88,113,74,26,85,8,46,74,142,228,103,6,255,1,138,169,135,12,30,22,107,34,192,67,185,58,15,255,245,126,160,117,160,27,181,21,75,153,22,38,192,73,188,231,122,168,44,128,39,3,145,95,185,235,232,199,181,184,170,174,
68,132,78,68,196,148,134,139,255,187,2,225,30,106,151,210,239,71,234,175,198,186,235,73,26,43,166,232,68,70,233,83,132,53,121,41,96,164,196,112,164,122,193,16,77,220,33,83,61,248,5,220,248,24,20,129,173,51,183,121,186,200,128,66,239,244,254,192,231,16,168,177,204,43,51,65,179,57,198,158,150,214,88,209,164,13,165,159,88,9,144,13,157,107,33,180,137,225,90,195,95,30,89,175,144,49,224,129,14,51,145,149,192,42,156,210,40,92,155,132,176,193,111,164,132,94,252,171,16,156,1,54,178,69,56,119,210,237,187,193,80,153,5,94,64,224,12,118,126,130,204,33,193,43,163,171,127,0,211,105,184,214,162,40,71,181,241,138,141,22,46,243,136,27,22,231,178,255,15,58,70,31,16,177,67,53,17,78,115,26,42,90,86,68,156,183,170,223,24,157,213,134,127,214,132,162,2,140,103,130,64,101,34,237,54,148,93,138,158,12,104,178,181,203,125,13,239,66,43,182,81,238,146,196,105,181,198,56,36,213,94,148,148,226,234,23,50,250,169,159,117,8,246,7,224,232,245,101,239,29,2,248,223,53,101,220,185,54,109,152,78,106,206,234,115,163,
188,203,169,228,174,123,179,18,124,167,147,245,171,96,61,45,110,245,52,145,226,128,52,104,136,116,232,167,244,213,171,64,177,208,126,67,93,40,48,201,56,79,25,64,19,49,236,212,34,5,179,103,49,182,183,39,55,174,217,191,82,219,183,158,99,94,89,250,254,116,90,132,202,2,162,230,254,92,3,238,234,214,191,85,69,75,22,47,140,193,75,213,224,201,170,194,249,254,84,41,162,140,72,226,237,146,133,73,224,38,7,216,236,121,228,179,145,217,193,165,82,95,115,246,6,58,62,184,193,199,108,140,77,35,69,183,222,33,10,41,250,98,152,185,187,219,8,123,119,149,207,149,121,219,76,205,53,103,12,145,188,137,114,234,187,144,147,56,67,27,208,253,78,134,210,227,120,72,221,165,205,135,157,2,138,151,155,202,144,127,0,77,57,26,223,104,225,253,198,220,147,171,252,6,165,75,232,188,193,183,65,176,125,173,18,85,142,43,203,17,127,100,219,17,206,181,251,147,99,212,5,79,132,107,117,229,188,87,43,90,71,67,34,21,113,49,253,98,251,177,235,243,13,123,237,207,109,138,250,22,59,24,105,40,178,33,80,202,231,33,29,3,239,139,91,
119,1,59,218,75,13,123,111,142,191,29,153,146,98,157,153,65,173,91,207,252,189,232,164,87,136,167,176,2,45,75,58,47,182,131,182,199,166,239,80,98,177,228,147,137,89,75,125,147,72,102,182,114,71,234,242,250,235,27,225,97,123,145,57,191,185,161,219,69,247,189,154,140,126,95,140,136,99,36,89,18,238,188,148,10,48,51,116,24,191,48,59,73,191,246,88,173,61,186,95,255,19,167,116,93,69,91,191,147,237,248,180,39,114,169,20,224,189,33,189,196,228,184,234,204,179,138,78,40,237,35,179,217,97,49,19,140,77,54,222,181,111,137,117,54,208,240,108,144,255,205,215,198,23,169,42,199,6,94,55,130,234,229,27,161,18,221,66,39,45,100,31,198,230,10,50,244,95,52,240,73,179,217,162,140,169,204,127,30,116,65,172,82,186,44,230,14,34,158,40,11,209,89,127,133,97,120,89,206,236,185,155,127,153,80,222,195,126,40,89,27,141,182,11,2,150,8,129,105,172,41,211,109,164,163,57,144,143,145,53,151,171,133,10,56,98,177,220,236,52,115,49,163,69,2,188,111,121,52,57,63,97,221,236,130,57,14,156,172,7,146,2,86,91,36,163,89,35,
100,233,198,30,169,253,142,128,209,155,77,137,17,204,87,66,34,1,63,131,37,76,101,22,222,32,247,207,44,190,18,73,107,132,180,47,109,43,207,255,21,34,180,208,92,56,249,10,241,181,114,203,122,46,144,71,59,222,31,45,221,78,246,232,140,10,55,145,192,87,251,30,136,186,93,14,47,28,68,222,155,162,39,180,217,164,147,10,110,98,51,157,23,17,133,255,239,185,139,108,174,42,76,16,211,79,93,5,174,95,1,0,246,155,131,222,38,138,120,226,208,30,124,191,65,211,183,59,106,102,50,22,92,223,194,229,127,174,148,99,39,126,215,194,222,77,26,161,39,111,29,226,77,164,227,95,90,207,158,61,120,159,172,144,45,213,199,164,83,15,144,249,250,254,126,241,93,77,76,253,26,222,240,204,251,66,175,90,143,191,106,164,193,32,225,82,127,22,146,25,44,186,74,118,170,218,79,183,234,105,48,147,128,188,108,172,246,206,118,1,13,128,118,126,125,223,143,84,62,196,15,149,194,52,61,115,245,39,59,52,53,235,71,237,112,14,70,251,226,72,128,33,113,120,48,251,234,131,158,51,244,162,28,139,86,165,8,255,227,20,161,131,253,89,194,11,93,
214,69,122,20,56,33,73,46,44,117,92,230,119,198,215,163,109,36,70,126,118,196,219,196,187,73,66,166,39,25,112,33,165,122,251,13,254,1,52,212,107,233,153,117,82,229,82,29,126,122,38,6,206,125,177,74,65,181,179,226,114,135,52,152,193,204,250,106,207,31,75,231,137,17,165,54,153,145,218,163,44,222,162,35,226,157,4,44,38,153,108,63,185,249,166,250,187,146,144,191,17,55,119,213,220,203,204,68,130,218,171,230,106,118,123,197,30,209,148,76,141,196,111,81,41,58,47,13,31,200,144,15,190,111,185,41,247,47,102,235,176,187,228,7,190,83,179,222,112,153,96,106,237,18,223,7,221,118,200,98,143,109,103,99,234,230,123,103,121,181,246,96,58,120,254,240,54,176,51,237,105,91,139,152,210,111,85,189,59,115,31,119,253,75,203,190,163,226,64,253,205,170,44,189,197,167,6,132,174,170,159,149,190,213,101,82,195,216,216,131,193,100,86,47,85,23,184,140,11,151,115,92,125,38,214,192,73,54,249,123,178,32,196,156,240,131,131,140,212,69,107,108,212,68,108,249,243,23,169,44,206,149,240,56,149,74,206,18,213,244,3,85,
211,52,125,219,134,137,192,103,9,49,237,29,217,220,91,239,8,102,149,151,49,226,118,174,55,73,76,225,87,195,250,184,118,116,75,131,45,141,177,204,25,35,212,176,104,185,235,218,183,142,38,103,207,77,185,86,246,174,44,200,30,91,46,16,245,188,91,18,75,86,219,81,171,63,150,135,218,12,23,229,62,155,3,254,11,29,133,160,208,17,193,143,99,190,193,213,251,255,192,35,70,181,199,205,166,95,223,132,46,139,98,156,226,128,114,122,159,243,232,107,222,157,198,82,38,182,151,101,246,63,92,152,48,253,10,108,8,222,245,46,37,114,215,187,244,60,213,188,194,121,208,121,94,95,55,170,48,249,237,246,145,25,85,158,88,172,218,113,164,143,229,45,130,76,255,20,62,120,38,221,55,127,162,18,44,188,168,102,3,19,210,213,58,34,31,117,30,14,227,9,245,87,237,153,3,230,67,88,71,103,133,248,151,158,80,7,21,92,191,54,161,72,198,141,214,116,104,141,171,142,157,243,178,176,163,65,97,162,178,242,11,246,135,222,177,156,15,255,0,107,23,224,237,36,100,94,216,136,130,175,112,222,142,50,179,93,225,2,232,126,210,176,80,187,105,
254,37,247,205,215,79,40,22,52,121,203,118,45,66,143,135,209,110,51,231,179,103,222,146,10,148,58,128,40,233,155,70,13,236,164,65,34,205,157,254,239,58,238,244,47,177,235,210,222,250,223,78,55,142,131,45,42,49,217,72,93,77,108,214,165,56,219,232,36,4,232,122,243,225,62,233,31,224,45,25,221,79,229,133,58,240,49,234,128,144,67,197,246,127,0,20,169,58,113,35,157,153,117,107,12,190,190,64,177,176,108,173,79,173,140,3,150,77,241,70,197,80,143,203,221,224,192,144,151,163,175,10,4,60,151,164,29,197,65,210,63,110,114,132,62,91,118,16,83,246,82,78,160,197,29,122,229,6,135,146,62,179,133,221,42,5,164,61,44,206,43,88,153,130,57,0,173,251,86,113,142,170,26,178,214,16,214,164,145,175,54,235,121,1,90,152,147,76,52,214,243,159,52,254,156,190,167,226,227,211,224,235,21,47,194,85,131,118,11,181,108,167,104,101,29,217,139,238,122,23,225,202,67,169,74,175,248,71,79,245,238,136,230,127,44,111,61,177,161,207,138,11,151,88,195,25,27,44,93,20,29,158,170,67,169,1,199,94,247,30,85,27,173,220,171,127,
175,76,71,114,25,250,14,74,189,200,103,49,105,102,158,37,40,96,182,148,175,244,106,1,183,10,232,248,210,134,122,27,215,243,211,127,77,178,164,121,191,169,224,101,129,54,74,166,91,253,164,26,225,188,194,210,166,19,192,126,203,121,146,4,127,115,150,16,89,23,39,101,177,45,78,43,219,22,201,187,173,81,206,92,185,130,184,198,200,64,28,98,92,107,255,239,101,165,71,29,229,53,75,131,15,35,128,231,44,132,44,44,232,26,86,90,137,228,67,185,134,140,123,211,180,253,125,88,61,141,117,83,64,56,7,125,156,194,89,66,16,237,246,174,221,87,99,19,21,159,109,77,51,163,152,247,41,176,80,59,140,93,105,118,169,54,44,236,61,149,10,149,80,7,53,249,22,180,196,129,10,7,65,55,59,12,236,247,89,105,166,55,107,223,115,22,230,173,81,204,59,225,196,94,2,64,63,229,74,47,255,231,124,67,15,161,172,225,223,49,33,192,14,98,150,74,192,129,197,51,109,242,117,72,58,154,104,182,108,136,156,52,7,237,211,149,74,27,157,29,250,82,118,252,131,126,75,238,107,9,186,154,136,176,175,192,107,150,234,103,65,72,178,154,242,177,124,
108,131,91,62,31,84,70,169,234,127,138,137,9,231,63,128,95,22,156,3,117,127,43,147,185,62,95,106,0,127,77,106,27,121,96,11,157,137,249,212,76,51,183,247,206,207,48,35,28,114,38,211,22,11,247,147,140,1,13,67,100,12,137,210,28,188,141,69,123,30,184,127,137,56,128,162,210,176,119,77,104,37,117,111,131,86,137,55,197,80,171,232,63,43,41,96,218,68,151,158,159,235,96,163,201,123,132,144,165,240,31,192,156,31,124,8,50,58,218,122,145,54,252,31,234,226,70,16,120,87,25,212,123,157,174,254,245,125,223,176,131,159,23,212,164,17,154,196,167,175,250,19,2,95,76,138,54,37,244,152,216,144,83,248,47,134,69,46,3,60,58,72,140,68,125,51,76,249,199,95,95,81,23,123,209,184,68,197,251,85,236,188,28,59,49,88,220,31,39,255,134,245,52,140,105,85,29,134,41,254,156,80,160,203,181,171,246,252,152,136,148,28,11,143,83,239,241,20,112,127,33,187,87,90,242,166,106,227,181,37,15,106,38,26,231,221,95,200,52,193,168,249,40,143,186,8,79,139,187,149,130,222,111,172,220,195,166,23,4,140,102,156,74,163,7,99,224,39,28,
125,19,113,72,141,195,49,8,229,20,159,164,65,101,107,11,135,180,43,17,170,255,193,9,91,255,0,235,238,255,189,25,33,14,212,230,251,163,52,250,52,139,92,237,16,244,78,253,126,45,98,97,77,71,177,213,102,47,58,241,176,237,99,31,51,176,6,234,211,144,95,224,7,146,50,135,219,19,111,199,13,193,199,59,148,21,34,193,171,67,56,188,182,177,252,39,205,211,55,224,19,142,142,247,43,97,228,92,39,23,112,15,181,233,4,77,255,1,46,81,219,238,161,96,2,124,254,53,235,73,10,252,160,42,62,225,44,53,58,24,183,89,63,151,73,130,79,100,127,193,56,60,135,94,74,26,226,61,227,55,92,250,161,13,96,249,157,116,129,87,236,97,246,190,157,214,14,253,79,150,208,192,110,158,30,88,146,150,144,111,178,127,63,148,213,94,80,157,71,118,191,200,190,33,96,78,61,186,252,64,150,156,32,52,71,148,96,33,120,253,74,54,77,250,16,221,199,69,169,155,163,5,231,76,239,206,246,136,125,130,197,14,125,165,77,216,99,253,158,44,167,102,78,216,129,2,61,84,34,88,32,136,172,54,113,209,41,14,218,4,107,73,49,163,253,142,32,10,212,194,90,60,215,
33,59,182,168,119,141,35,254,220,107,127,134,51,26,52,72,134,72,53,148,24,89,198,254,165,141,117,166,69,201,94,71,173,226,203,13,42,114,20,128,251,14,119,136,84,185,200,230,76,93,178,207,49,135,170,182,137,65,97,178,244,93,215,122,220,228,255,0,143,58,74,245,93,207,64,43,12,42,33,242,41,87,108,82,33,222,62,161,255,149,75,255,79,54,29,17,245,212,225,125,127,115,182,146,53,148,50,177,151,62,183,221,218,244,197,246,238,45,246,193,38,143,227,205,118,226,2,243,53,134,48,220,253,2,108,17,49,76,255,74,202,189,202,164,41,233,217,98,189,219,239,166,60,145,153,61,165,203,34,130,173,71,43,122,213,145,249,79,247,26,118,106,34,203,35,132,158,15,145,211,88,161,252,103,223,199,88,234,93,232,49,23,30,199,60,115,70,219,192,58,178,36,40,231,3,17,84,168,1,40,140,47,66,8,16,27,91,42,96,47,83,159,183,105,63,189,215,49,170,151,37,61,195,102,76,11,33,146,212,125,6,195,127,160,6,52,238,211,88,9,87,149,245,8,17,218,30,99,35,63,47,132,154,80,137,215,152,137,128,224,229,55,181,129,171,168,178,169,97,104,
0,167,168,6,95,127,15,248,99,241,56,244,255,54,233,31,111,32,1,22,98,1,11,244,98,208,141,204,53,83,7,209,122,35,67,19,181,224,64,246,85,218,46,28,179,229,71,180,49,212,70,235,60,152,163,123,96,187,234,80,160,188,171,171,12,33,2,247,11,200,112,35,244,90,90,230,133,119,191,244,63,232,110,242,153,64,31,17,214,96,192,174,251,49,204,194,16,46,137,196,121,60,135,170,145,167,162,252,22,18,45,245,140,24,7,16,28,195,148,105,233,87,169,146,90,216,123,175,23,185,149,176,108,88,87,50,188,59,109,160,147,86,39,47,151,78,125,163,80,71,84,101,111,2,186,164,108,4,252,52,205,44,252,0,96,187,13,229,71,254,67,52,178,46,224,86,33,16,128,13,138,22,161,191,187,181,64,242,160,4,74,239,39,203,13,209,57,21,238,43,67,69,57,28,112,215,77,142,240,163,105,48,12,120,246,167,110,181,70,244,150,8,78,86,57,93,193,61,29,202,101,67,222,74,111,27,45,48,113,169,248,156,146,119,227,230,19,48,193,2,117,100,66,112,16,224,31,224,155,55,138,23,5,219,160,200,150,99,106,149,17,92,193,25,200,124,130,233,187,114,218,28,139,
84,32,33,234,100,96,134,166,155,100,212,81,210,130,198,5,84,75,53,214,75,215,215,116,159,160,108,52,197,117,171,64,184,239,116,31,241,3,171,62,253,221,3,234,106,42,142,123,127,186,246,213,80,188,155,231,61,233,66,179,121,182,222,69,204,165,205,53,251,255,176,246,221,81,77,109,219,250,65,80,68,74,168,74,71,233,16,1,27,130,84,81,233,77,164,215,40,69,132,80,149,26,74,16,69,16,233,8,40,189,119,136,2,161,8,18,56,52,17,66,239,32,189,215,132,18,2,132,240,219,158,247,206,189,231,119,223,184,99,220,241,198,251,99,141,157,177,247,216,217,107,237,61,215,90,243,251,214,156,223,90,50,17,185,122,122,236,153,36,121,79,96,248,70,87,177,168,201,132,164,64,197,71,232,84,63,33,94,40,76,76,174,147,114,231,22,21,143,219,0,152,193,52,24,49,242,212,189,251,57,218,93,149,200,180,51,203,20,212,49,183,148,168,43,116,184,135,192,121,32,90,26,27,65,209,71,5,137,208,67,146,43,73,188,74,149,34,109,210,126,174,151,200,239,149,49,29,79,58,77,134,18,212,54,79,109,121,240,221,163,219,18,68,217,149,89,240,41,83,
151,196,9,16,180,118,6,186,162,250,175,39,180,84,231,67,223,123,78,154,148,111,214,92,185,87,17,246,230,203,49,202,150,135,193,20,64,91,98,224,211,74,201,19,207,130,192,230,153,115,7,250,30,163,86,100,149,159,154,101,149,216,110,99,118,179,23,168,15,79,108,135,123,127,183,153,231,88,232,191,43,242,53,59,245,105,188,60,103,123,46,204,186,224,9,68,149,164,58,215,65,228,55,10,172,64,204,84,154,203,44,127,119,76,182,10,211,33,222,161,83,253,129,104,128,224,235,73,92,7,88,74,210,251,165,164,83,0,50,157,129,62,20,123,65,191,120,55,213,159,116,109,248,18,201,237,249,239,198,93,119,19,73,135,198,106,4,223,63,58,125,145,106,158,202,99,127,124,115,174,184,157,213,255,17,251,136,158,186,127,193,149,99,158,48,40,54,102,2,222,121,6,242,103,215,221,218,208,194,2,4,56,250,57,250,37,122,110,70,17,164,184,154,54,118,6,154,89,67,19,190,81,18,153,86,102,129,111,155,236,9,128,99,68,254,239,111,107,131,81,4,239,91,58,78,104,195,116,201,3,181,91,3,30,3,211,137,129,89,121,165,139,164,236,215,134,8,
173,5,14,112,17,114,18,163,143,167,36,128,243,215,146,188,189,102,192,165,214,181,193,87,18,165,152,52,19,236,40,222,28,158,42,107,83,110,146,97,25,215,47,46,39,205,109,125,232,226,13,245,218,203,239,228,183,205,64,155,236,162,97,152,69,184,120,105,96,118,145,231,138,43,86,141,120,211,217,113,44,227,0,253,169,77,94,82,154,127,206,78,159,48,186,85,3,44,2,207,38,159,129,64,196,135,52,122,5,111,161,26,194,173,59,131,59,252,145,41,99,139,169,163,60,101,136,102,65,210,197,117,118,255,190,113,113,84,129,197,23,14,241,243,59,41,149,25,219,95,154,203,162,165,137,8,245,67,144,18,5,124,57,169,183,247,97,91,192,9,206,134,116,241,160,100,205,189,215,23,128,22,176,64,122,151,168,46,61,168,88,47,121,100,75,84,29,50,44,80,144,200,131,59,108,150,87,51,33,204,180,24,127,187,45,53,85,27,39,215,122,6,82,101,179,34,213,101,210,48,9,42,75,117,55,117,192,243,227,1,133,198,24,223,188,61,225,115,211,103,32,56,53,206,176,97,90,102,192,85,232,59,200,148,209,61,98,240,205,243,226,208,94,184,91,60,168,239,
124,130,53,85,1,100,113,190,56,20,163,86,150,10,239,59,159,247,236,91,105,211,105,189,33,133,255,141,146,199,53,119,200,190,58,8,14,64,2,123,22,94,99,94,226,183,153,195,71,81,41,172,108,203,65,50,252,25,225,225,75,135,116,211,7,58,34,58,148,119,142,160,47,99,211,171,200,78,96,39,16,66,2,209,244,68,193,135,67,47,246,242,61,14,157,168,187,134,206,83,5,93,163,88,164,17,50,1,120,69,41,201,83,236,25,155,51,48,7,206,118,245,77,215,109,190,4,186,64,173,234,89,69,62,168,193,159,121,163,191,115,71,47,32,194,60,175,229,188,96,79,204,212,239,190,92,61,208,163,47,253,11,165,105,163,24,18,72,211,91,136,112,132,193,19,240,189,194,83,83,234,119,187,87,92,86,132,216,136,176,67,243,121,48,49,204,138,255,12,244,197,185,151,20,238,72,188,82,19,195,95,97,159,105,173,104,6,26,78,15,40,138,24,161,37,30,97,44,234,234,126,108,152,36,85,0,25,228,143,191,197,85,10,193,81,114,41,223,146,123,99,43,218,131,120,99,107,139,183,127,137,236,214,160,89,76,83,23,251,206,37,93,61,3,29,172,229,107,37,63,199,58,212,
31,101,82,110,51,71,44,72,50,60,117,96,3,198,225,36,150,130,2,69,162,254,196,140,85,245,25,232,152,201,232,154,156,39,82,239,52,93,225,18,33,20,31,142,19,56,124,211,112,231,205,22,147,100,125,47,16,231,247,242,98,194,164,223,215,125,158,178,103,230,179,86,95,207,64,3,177,27,118,206,215,31,33,137,9,136,253,161,238,153,215,64,234,116,131,233,137,178,15,32,130,224,243,0,83,240,49,242,208,184,252,226,187,17,197,29,89,47,60,151,118,96,39,169,139,231,11,250,53,218,158,86,124,100,127,66,181,140,240,61,231,194,130,209,183,199,109,60,60,55,194,120,190,41,234,91,238,108,206,156,72,17,204,241,142,88,218,154,208,6,121,151,178,151,77,242,219,217,235,114,147,69,238,93,76,107,171,178,198,165,35,43,113,127,197,103,216,248,248,145,20,60,145,199,36,197,99,81,153,241,82,87,48,162,163,7,117,6,130,2,108,131,178,170,185,36,253,216,106,43,130,105,17,205,207,18,189,192,115,196,124,16,125,188,159,4,240,51,146,95,77,72,55,207,64,177,186,38,103,32,164,58,98,159,233,17,233,50,171,235,66,203,112,224,243,
138,128,182,99,253,162,162,195,43,107,58,37,247,126,235,11,208,68,211,237,15,33,54,118,117,23,33,86,21,114,178,131,64,110,22,178,83,49,166,12,30,230,47,164,194,71,136,128,240,169,2,194,84,229,128,135,97,57,8,60,180,12,54,162,2,56,105,215,44,237,73,245,5,164,15,102,220,171,34,68,22,121,69,3,88,191,50,139,253,189,180,121,137,163,43,7,138,199,248,63,107,225,216,66,146,3,116,9,55,128,30,38,90,242,111,175,68,87,121,40,206,34,141,143,120,225,194,217,165,43,151,150,137,126,216,141,22,4,19,81,214,61,139,144,163,134,26,241,232,108,231,166,254,212,2,46,220,87,152,255,166,33,76,142,155,193,143,0,174,243,75,71,232,121,235,33,127,103,44,86,179,152,160,216,125,107,202,225,234,149,228,102,240,19,176,145,210,209,107,40,189,178,27,191,214,27,2,220,120,191,237,149,51,237,86,67,245,33,3,127,159,70,30,247,189,11,134,31,15,40,188,145,63,102,8,194,222,155,244,232,75,5,141,132,207,179,172,94,4,43,7,169,117,179,39,0,102,73,137,63,28,60,13,246,243,202,4,191,109,9,119,115,138,66,233,136,188,13,191,120,
204,99,163,15,241,235,163,152,93,168,45,160,44,158,221,27,201,136,111,206,164,26,174,43,40,121,122,42,90,11,135,243,152,129,106,56,83,135,63,69,107,100,71,190,49,154,151,123,30,116,231,89,160,10,68,101,66,203,72,75,172,134,5,78,153,73,91,152,199,202,2,81,111,179,255,227,136,92,82,36,230,245,72,144,162,14,98,54,193,234,106,240,198,220,204,135,170,16,85,166,73,71,17,217,123,237,3,108,32,86,98,201,182,35,17,15,52,82,43,117,141,164,120,6,42,255,109,182,84,200,190,228,127,80,164,43,36,192,220,127,132,204,235,158,92,152,2,60,135,124,100,19,90,145,169,171,23,199,179,2,237,187,242,222,99,100,68,238,94,241,24,31,5,172,196,244,41,205,47,50,91,72,252,209,232,222,78,169,185,66,124,25,116,236,231,67,249,170,221,7,173,30,2,22,193,128,12,87,156,239,46,132,119,93,235,121,126,162,211,97,241,21,70,219,190,243,166,25,252,195,108,236,165,63,231,139,52,198,56,251,40,110,161,238,239,116,206,167,111,37,7,165,38,131,84,228,244,189,1,172,59,172,214,219,35,82,5,202,93,78,198,212,164,7,127,76,53,244,89,
136,215,175,189,140,229,241,182,233,187,4,234,195,146,66,10,125,6,45,171,250,247,235,125,93,202,93,4,76,226,164,233,235,101,153,130,64,64,7,153,9,236,224,169,104,76,59,185,67,176,87,10,55,247,129,182,201,36,52,12,172,75,133,23,32,120,111,241,118,110,162,123,37,231,206,64,88,173,222,177,117,30,234,181,68,52,179,156,166,245,249,197,31,58,239,105,34,247,84,34,110,12,222,90,216,145,82,90,85,64,29,78,103,1,218,81,226,128,41,90,108,43,198,25,232,186,214,239,201,184,157,129,56,246,147,72,113,152,112,192,146,150,255,114,7,111,54,200,3,58,1,50,163,167,8,158,83,22,46,167,17,169,80,244,194,10,16,190,138,4,218,145,157,83,150,28,230,228,97,173,248,126,23,26,119,169,3,23,77,12,135,119,156,194,53,1,33,174,228,177,82,4,43,240,142,11,74,17,163,185,232,99,170,108,4,53,141,20,110,110,29,125,219,84,97,254,84,100,104,232,228,195,126,129,97,234,220,239,177,79,53,20,238,168,120,112,36,180,203,130,52,229,230,90,43,60,3,141,46,102,252,48,250,254,72,129,41,135,129,168,194,18,155,3,252,145,177,41,240,33,
215,128,103,142,160,54,254,165,79,129,61,152,73,151,210,51,138,37,87,179,195,43,83,123,112,87,136,31,142,51,78,253,254,172,6,234,25,176,116,126,23,24,219,48,136,4,195,127,123,69,117,66,134,7,107,92,66,140,149,103,214,51,122,21,242,91,9,247,201,136,7,140,135,126,205,216,204,37,15,198,178,21,50,244,92,164,108,229,113,39,111,108,240,69,73,175,112,16,81,228,180,30,208,117,233,234,29,175,156,55,72,130,27,72,8,189,69,121,251,110,90,221,145,189,182,34,200,168,227,171,119,20,157,231,223,203,217,117,149,130,115,25,157,29,29,13,37,39,42,226,78,230,0,84,255,78,242,196,240,163,90,200,150,139,140,124,67,147,127,121,65,53,24,234,72,164,37,204,97,189,205,9,108,56,176,9,118,164,210,117,113,218,84,125,111,115,137,11,12,225,229,94,87,93,234,205,3,185,55,45,14,190,110,51,14,215,187,250,51,70,89,163,161,143,226,77,153,90,57,120,238,177,126,66,117,56,168,142,227,165,104,183,243,232,116,97,235,120,201,77,41,13,80,223,251,111,151,234,201,173,43,179,215,69,23,181,127,100,210,10,67,57,135,34,5,181,13,
223,127,17,233,21,188,0,228,165,231,162,177,234,250,245,58,0,175,112,234,85,3,0,35,237,192,119,198,64,122,151,58,18,28,144,49,55,19,33,89,41,34,184,243,88,141,194,28,78,113,255,85,70,123,227,238,63,114,116,41,158,213,210,195,185,33,216,80,124,46,54,148,8,160,215,9,142,14,248,141,16,231,217,232,39,113,0,201,52,69,241,146,132,243,61,150,12,220,25,93,202,32,178,216,207,217,126,147,104,213,166,238,184,17,49,225,8,12,58,214,41,142,54,78,177,139,17,25,110,186,75,247,121,104,26,62,239,24,10,58,45,167,197,111,60,254,1,204,193,14,159,12,217,160,17,134,117,42,142,169,111,0,64,85,21,185,161,199,244,102,32,223,3,163,98,147,121,113,50,89,235,196,118,40,133,178,168,120,239,118,39,239,100,107,125,190,77,20,88,3,20,217,154,228,77,237,74,121,29,254,117,53,103,186,17,232,202,193,190,164,142,130,5,202,8,62,220,229,58,199,174,217,45,118,187,68,37,185,71,229,57,194,107,172,138,191,0,190,71,194,12,135,30,183,199,59,141,52,202,19,72,189,45,199,22,226,78,177,35,218,250,122,122,187,147,45,233,58,186,
108,237,15,162,150,209,30,129,108,196,187,125,141,140,4,136,54,22,29,234,124,62,63,201,134,245,145,197,82,234,161,151,252,88,186,122,38,93,220,200,8,7,196,167,108,107,94,237,233,251,7,252,238,229,44,6,110,32,174,144,231,142,60,187,183,86,1,75,235,89,56,18,112,50,82,248,159,29,76,216,223,117,0,122,172,121,23,8,236,174,76,253,43,186,187,29,123,72,244,223,128,30,16,17,251,6,158,149,38,211,64,12,64,116,26,140,132,142,38,133,71,85,59,94,251,218,31,70,18,234,12,84,43,40,217,184,108,118,33,197,189,208,209,88,207,212,100,178,252,200,69,240,105,225,135,117,245,53,19,5,9,66,228,28,152,202,33,6,51,111,233,173,3,132,197,24,59,217,63,254,108,99,170,196,117,227,151,79,249,109,124,80,26,82,156,196,227,19,208,121,89,166,55,204,58,106,49,171,133,229,61,247,211,198,79,98,172,20,244,47,111,235,19,85,177,105,239,234,75,215,111,251,184,223,241,67,134,185,59,116,158,19,44,222,18,174,70,121,185,126,82,78,21,95,214,239,81,176,14,226,220,90,136,203,115,152,118,15,54,51,71,160,87,178,246,165,229,106,104,
187,66,75,194,63,198,21,117,239,87,168,11,102,167,184,16,75,146,15,189,188,140,250,167,246,169,26,12,115,38,91,242,187,4,115,92,98,214,197,191,78,168,89,56,127,14,251,113,9,206,168,12,51,238,254,34,248,57,224,132,111,166,249,169,43,95,124,139,138,201,155,169,45,70,129,95,165,51,55,207,251,52,185,185,71,141,33,179,136,55,11,59,75,8,48,117,244,39,81,140,167,3,243,54,83,230,243,251,58,242,117,197,89,150,195,94,48,143,140,233,103,159,151,220,155,218,126,138,53,154,197,191,105,204,160,77,70,220,193,175,185,222,214,169,156,129,14,230,140,228,12,176,239,94,43,234,100,72,115,246,14,196,182,211,81,219,12,202,61,175,130,180,248,179,204,251,201,203,182,35,88,253,159,149,221,139,188,3,171,221,164,206,188,126,121,90,248,178,210,235,206,78,7,14,233,133,137,170,18,227,241,218,242,29,172,58,186,111,177,233,41,247,45,150,252,242,41,198,10,243,58,13,189,112,168,223,41,216,196,25,241,176,255,96,35,128,97,103,171,236,32,64,181,187,246,93,103,46,183,83,179,251,247,4,120,140,52,198,116,80,78,57,31,
38,149,28,146,151,176,41,37,101,230,159,77,93,107,227,212,64,103,112,195,136,235,189,17,229,170,210,14,148,151,96,223,46,67,87,121,162,68,96,106,79,78,10,223,180,31,70,249,136,47,192,88,145,137,106,78,54,118,122,20,144,25,223,5,133,82,93,46,16,190,147,223,25,140,207,70,5,143,101,8,89,97,23,43,45,115,152,130,240,131,42,124,118,228,65,106,181,79,91,23,211,138,6,57,113,3,237,126,202,221,113,53,146,141,218,16,197,239,25,154,159,220,230,155,59,159,124,204,235,89,147,73,46,17,127,161,94,164,12,245,200,185,98,63,60,153,163,90,170,29,224,234,42,119,163,75,206,29,115,147,87,122,60,200,190,195,130,238,64,3,202,248,2,95,83,6,19,204,179,103,25,153,45,163,214,202,58,228,14,138,88,145,135,96,246,141,129,36,251,36,192,167,99,30,229,19,153,251,117,139,26,166,54,185,76,150,47,176,232,134,120,27,83,172,56,43,185,144,129,13,129,18,152,30,15,55,94,35,84,54,79,95,198,209,125,60,158,74,218,181,250,118,253,56,175,84,91,98,59,188,235,103,134,196,226,172,7,249,155,54,153,79,117,202,86,55,7,118,172,58,
93,72,123,215,185,149,30,52,124,79,51,27,201,224,103,15,71,45,137,38,183,139,110,65,127,161,136,191,162,203,121,27,107,146,151,205,125,86,34,87,62,112,219,58,54,85,172,228,171,58,166,55,120,183,121,67,230,128,62,112,126,168,236,10,121,107,117,13,16,65,233,120,110,135,161,125,148,65,173,131,205,58,133,255,177,52,176,196,219,254,61,188,222,97,104,229,165,101,26,154,226,12,36,232,63,114,155,242,192,68,175,48,109,88,109,79,66,204,2,152,163,154,178,183,150,108,100,91,161,187,18,235,136,131,45,9,82,176,227,112,40,209,7,224,10,70,37,73,134,198,255,230,60,226,197,18,162,217,10,185,251,104,95,79,217,180,231,47,79,146,101,119,102,107,244,68,192,140,212,111,69,238,172,171,69,237,58,127,202,46,148,216,63,114,67,123,96,65,240,178,116,47,64,47,52,230,102,7,41,126,70,210,191,144,106,100,29,218,118,46,47,203,173,76,166,188,57,101,174,17,98,118,133,146,130,97,34,51,234,126,103,236,96,94,96,1,160,23,171,104,221,54,148,211,64,200,155,77,187,57,141,93,214,246,250,73,247,40,156,242,24,219,136,158,
238,208,195,4,26,79,77,84,167,136,60,5,143,119,174,34,222,30,63,166,200,92,78,59,84,230,189,225,73,35,195,30,136,105,73,6,209,239,117,192,43,57,158,134,7,223,1,216,137,31,183,239,95,201,114,185,87,226,46,205,199,162,113,173,9,99,241,246,241,249,31,83,100,42,88,181,227,65,202,95,44,200,89,52,237,20,161,171,109,66,33,228,69,164,64,79,142,39,87,133,40,77,106,37,217,228,30,160,65,135,231,35,81,245,206,169,96,123,55,209,153,24,177,6,61,237,34,140,228,154,71,187,173,145,147,136,171,255,165,99,175,47,64,100,185,166,43,185,15,228,17,246,52,251,109,205,96,25,95,245,227,155,68,81,50,57,178,233,154,213,127,196,163,32,175,157,22,147,104,39,137,110,4,17,36,33,32,115,207,243,252,219,169,177,27,22,21,61,111,32,81,170,86,25,145,240,3,102,50,226,170,35,187,97,79,60,226,149,157,55,181,146,167,43,159,242,117,221,97,54,157,139,138,15,68,115,191,184,167,26,175,242,16,153,161,120,173,148,150,227,225,149,54,30,90,115,9,188,242,194,133,225,178,190,212,150,155,210,123,247,73,107,11,210,171,170,223,253,
233,251,113,247,217,24,91,162,134,117,212,54,28,95,236,77,20,170,211,115,21,146,139,45,228,127,108,110,23,221,104,21,77,88,156,255,229,179,172,50,167,122,144,121,201,251,101,2,175,244,187,163,79,179,100,67,236,59,10,12,254,66,35,10,124,62,245,218,216,229,16,59,1,252,215,66,13,250,176,81,183,200,87,93,76,227,6,156,0,75,48,146,239,47,68,208,43,247,87,193,89,190,11,205,90,219,117,148,217,58,113,86,203,97,219,29,149,75,148,15,218,134,225,235,241,234,167,113,30,18,227,5,127,104,238,118,20,250,84,224,200,208,67,63,119,193,196,189,232,126,213,141,251,92,60,155,131,39,82,62,222,120,103,236,117,179,187,177,236,189,69,22,231,227,245,134,76,221,14,111,45,236,235,245,93,58,88,7,116,45,190,30,128,143,216,60,16,199,43,238,196,184,106,8,15,0,214,99,147,0,112,80,238,205,211,41,42,84,243,235,40,141,89,65,106,77,226,84,32,5,176,185,127,26,222,127,10,97,124,107,58,160,180,51,27,220,92,3,40,109,222,177,95,142,19,151,11,46,228,92,82,201,202,179,53,106,45,225,246,153,234,175,148,80,64,217,183,103,
80,85,245,134,25,123,193,127,66,215,3,185,135,19,193,194,51,107,47,195,236,125,162,21,204,23,233,85,252,24,154,123,32,125,194,165,121,15,152,62,166,162,190,163,233,10,178,52,37,91,251,10,52,152,161,144,2,140,253,200,0,106,254,88,210,211,207,183,178,131,196,231,175,64,234,32,232,130,95,55,8,216,136,150,231,200,121,33,121,35,155,245,82,217,242,62,71,11,241,241,167,231,38,31,164,112,72,87,109,64,252,76,232,85,41,24,74,245,178,247,13,245,130,40,103,69,225,162,89,26,55,226,227,54,147,178,85,164,35,2,44,180,89,7,10,119,28,52,180,15,94,38,148,207,76,161,185,231,172,140,231,118,46,233,102,251,155,224,18,80,61,41,43,62,222,173,122,15,253,203,150,222,189,237,41,169,48,140,87,108,125,144,181,223,6,207,99,94,209,214,110,107,140,38,145,177,90,216,98,191,150,92,44,19,226,80,132,72,242,143,38,59,112,210,30,54,131,169,172,124,234,31,225,206,173,121,225,107,100,30,199,255,124,119,145,207,100,170,150,243,203,100,156,202,173,27,42,16,41,165,126,73,46,216,66,249,247,121,217,174,123,215,6,246,127,
41,136,65,116,252,222,130,42,43,217,196,249,35,162,52,164,182,63,174,112,182,186,221,12,14,120,16,30,250,224,138,54,4,134,48,134,113,233,97,190,90,196,133,168,223,179,162,163,170,9,52,88,234,222,218,40,222,119,230,54,188,144,161,248,14,241,66,118,18,121,173,253,243,188,188,232,141,231,6,226,104,135,144,176,107,41,217,118,108,110,178,179,195,20,167,105,140,28,59,95,149,230,97,171,13,140,174,231,55,124,108,85,242,121,79,106,54,247,192,152,165,164,22,39,162,140,187,85,251,125,233,31,107,154,122,7,142,46,196,159,199,53,135,219,223,229,162,66,210,173,215,118,127,126,88,242,255,250,97,124,38,73,173,203,96,139,191,74,219,17,85,105,44,151,98,58,40,128,51,222,34,159,235,19,27,175,66,210,56,236,89,86,229,113,177,136,231,115,27,60,51,223,70,111,119,143,91,185,215,209,201,24,151,14,60,37,79,125,165,105,174,95,240,99,241,164,158,148,17,39,183,105,37,54,159,163,113,185,162,128,133,229,176,78,106,47,222,149,120,120,187,65,249,12,196,75,42,0,150,8,6,0,20,36,88,102,130,232,136,68,159,190,130,
46,25,250,255,219,43,248,40,111,34,11,16,77,202,175,171,204,252,95,254,251,111,254,226,119,161,144,242,138,153,153,192,56,187,51,98,92,111,177,46,70,182,27,126,140,160,87,205,135,224,78,72,151,200,79,174,72,53,71,211,119,206,35,169,28,42,58,103,35,149,63,104,51,150,47,125,249,148,174,63,14,182,134,123,32,199,224,61,56,112,104,213,204,229,23,73,201,42,72,251,203,89,249,211,42,214,233,211,158,83,229,185,79,131,133,201,143,242,18,153,114,123,88,26,253,188,21,33,158,29,40,75,67,86,86,96,190,218,148,152,244,195,115,161,9,180,197,83,27,223,104,110,173,43,144,53,198,36,248,187,248,93,16,218,190,183,223,171,130,140,156,143,220,31,39,190,223,181,145,203,57,241,235,59,31,162,3,55,192,169,254,40,200,181,255,174,203,236,75,20,38,179,142,150,244,98,69,220,86,167,48,145,244,146,254,34,124,238,114,244,185,198,109,192,135,180,242,39,227,230,199,165,173,180,70,26,205,120,70,69,209,176,195,107,231,202,89,253,123,129,93,22,56,193,47,97,75,200,96,64,9,232,33,174,183,227,110,32,87,159,24,187,189,
151,81,109,109,59,95,205,7,197,219,117,91,237,238,235,176,67,242,57,221,22,121,190,185,43,65,251,25,212,47,98,194,74,55,159,93,132,130,238,32,137,58,173,100,113,186,112,208,70,225,191,40,131,229,149,190,192,43,92,29,216,174,250,165,49,2,153,228,40,236,214,55,239,206,138,29,138,160,87,66,118,67,39,234,73,84,115,197,62,236,14,254,15,177,19,35,43,102,253,252,94,190,251,85,28,249,85,43,124,79,73,252,91,235,144,3,238,112,16,201,19,89,38,128,74,86,123,30,153,157,120,87,116,117,225,188,154,244,213,168,225,148,235,143,70,183,128,149,16,137,49,228,28,186,131,117,185,182,97,80,229,67,185,180,172,167,165,228,163,151,246,167,168,213,5,5,212,209,30,206,143,68,213,137,147,106,146,121,67,123,169,223,223,50,255,171,130,5,222,196,20,96,26,29,192,15,239,243,112,90,253,168,142,249,204,193,233,193,157,95,255,59,138,27,212,96,138,235,109,195,79,4,190,201,235,242,190,83,158,181,98,203,203,241,72,177,131,207,131,211,158,188,44,128,10,11,196,61,54,227,40,231,161,209,98,51,29,201,150,189,111,137,34,47,
230,10,110,221,58,218,123,253,195,128,115,65,33,31,109,68,98,33,94,197,34,155,51,104,149,179,8,250,26,161,58,85,143,229,58,244,78,58,63,209,184,122,173,183,2,121,115,169,129,63,207,64,21,170,0,103,254,28,1,254,33,246,211,177,81,160,1,112,138,1,55,139,70,213,86,119,187,240,20,54,93,8,44,83,252,94,170,232,24,82,92,180,235,7,56,146,180,142,93,141,177,210,128,135,36,21,75,30,82,221,20,130,191,48,125,198,123,217,227,49,97,38,23,189,159,232,164,7,176,43,210,122,202,204,32,160,144,69,206,237,16,142,70,208,27,4,192,230,11,55,158,127,253,255,1,238,208,67,27,0,116,234,198,17,99,254,126,211,239,27,255,42,100,255,7,52,205,239,202,255,173,220,110,120,56,183,37,213,6,23,91,142,45,25,111,67,228,255,106,255,109,252,52,81,128,241,67,118,165,240,93,128,81,194,215,103,168,232,178,230,117,169,58,196,145,179,163,41,47,91,24,147,234,190,244,30,6,157,252,4,179,237,111,64,191,120,116,102,69,205,11,70,25,152,242,61,123,167,202,70,225,7,216,4,204,201,76,211,23,147,214,203,40,113,105,172,137,23,101,253,
129,85,30,182,63,136,7,250,122,176,203,4,161,206,22,103,255,71,151,244,166,103,218,142,216,116,92,1,67,183,142,186,15,32,1,22,16,202,178,171,250,78,209,154,39,18,62,220,237,85,233,195,190,59,96,211,156,184,20,171,31,117,132,1,249,248,223,92,65,249,41,54,73,140,187,182,207,84,209,149,127,89,133,251,153,175,169,33,6,36,97,49,70,23,191,87,18,85,199,140,167,102,40,16,179,73,36,22,236,82,89,122,206,194,201,81,131,82,49,141,218,68,64,189,175,87,161,251,161,121,253,236,201,66,248,9,84,185,15,136,124,162,115,232,27,115,240,122,108,98,218,154,245,132,218,231,15,209,104,64,212,65,238,52,253,12,100,143,166,11,236,85,160,10,125,212,255,204,212,149,159,108,7,117,5,58,109,209,57,21,63,6,167,27,94,55,248,15,183,170,177,89,255,27,30,115,104,123,69,179,197,219,38,170,214,159,86,206,240,122,34,0,156,247,192,174,226,115,227,240,242,131,229,201,151,159,189,201,1,96,238,195,52,153,137,209,66,169,236,79,190,77,129,229,64,225,47,106,148,239,222,99,124,49,162,54,110,201,106,103,170,3,200,206,13,22,71,
220,253,243,171,137,230,151,21,182,229,58,120,39,237,217,119,162,66,86,2,114,132,28,139,132,200,87,33,237,128,220,218,130,4,171,63,187,165,170,214,240,200,164,37,78,160,179,62,113,219,235,186,152,179,101,143,17,195,88,177,91,230,74,122,93,169,168,225,98,146,168,177,151,235,182,188,133,56,249,198,157,52,7,204,3,81,189,200,233,209,132,25,157,247,130,51,93,117,91,119,241,177,102,85,24,70,231,219,234,203,138,242,230,32,251,221,115,249,200,11,4,68,129,229,42,15,171,164,238,165,181,70,193,33,57,237,185,165,129,15,142,176,66,221,229,239,145,253,79,249,12,221,40,197,67,58,173,212,38,190,75,189,26,38,82,225,206,47,109,199,35,95,176,39,12,78,175,115,115,12,11,12,166,207,63,48,77,87,224,230,237,14,220,243,117,169,187,74,150,252,51,253,154,118,97,237,196,33,84,242,52,144,102,167,125,113,183,229,15,207,103,250,105,202,15,204,239,28,217,123,164,232,26,218,219,33,213,149,75,242,225,158,204,122,150,161,152,63,41,145,223,180,200,63,138,49,31,206,166,93,123,150,39,116,162,7,69,127,97,249,162,90,
141,209,170,157,107,130,44,247,162,129,142,6,195,203,196,31,171,45,125,69,225,101,151,152,19,150,4,227,14,92,126,172,121,66,30,2,77,48,191,48,246,252,125,206,175,136,133,171,17,36,148,88,131,213,35,134,142,212,205,199,117,7,77,64,11,35,23,182,244,231,240,239,103,163,105,215,173,132,73,173,232,225,172,216,3,46,248,218,101,85,237,216,109,187,8,123,142,46,250,11,100,179,238,198,114,12,197,62,209,109,25,212,68,205,211,207,11,106,114,170,242,117,49,107,50,152,114,198,128,159,84,12,61,159,64,119,149,244,211,127,133,184,151,26,88,76,49,122,107,118,161,182,208,68,242,53,129,152,209,168,203,210,159,13,52,82,243,108,183,32,146,221,115,152,64,115,151,20,212,81,89,89,180,123,118,93,198,187,116,9,93,110,31,38,229,81,99,50,164,88,194,34,121,102,96,132,12,221,91,246,181,146,234,91,250,225,31,189,236,49,198,57,114,146,166,253,197,101,194,213,25,197,94,207,128,153,143,245,159,111,226,239,111,229,63,252,109,235,83,111,170,192,133,45,255,90,92,26,232,80,81,153,184,168,194,193,81,125,205,201,190,
70,99,180,116,135,193,129,1,118,124,33,47,95,139,181,197,215,89,160,62,68,90,218,78,212,205,207,179,40,225,8,42,190,188,207,9,200,248,162,105,135,79,37,138,150,209,212,196,155,69,24,172,166,22,187,85,249,157,45,152,137,82,161,197,250,59,208,206,178,134,119,189,179,16,197,236,172,215,2,182,20,49,238,250,40,106,180,89,225,198,64,185,96,188,94,164,156,102,177,18,255,168,137,132,226,241,195,224,222,32,50,64,138,138,11,86,70,32,11,120,37,213,66,43,161,139,142,104,46,114,184,86,53,249,41,156,101,162,159,49,135,109,253,34,104,209,237,85,155,21,22,28,108,67,176,204,37,188,207,71,159,24,72,37,167,45,151,247,46,109,237,182,150,15,48,183,235,184,167,218,127,247,173,42,18,218,44,22,251,232,68,90,12,200,151,229,18,86,229,9,78,77,186,83,92,192,33,102,153,39,94,228,20,111,100,92,253,141,143,18,239,93,159,8,166,131,165,115,199,118,247,19,252,140,235,6,51,63,226,62,37,116,222,167,124,74,214,161,63,240,221,172,161,6,239,59,40,158,131,13,204,42,155,185,63,114,8,39,229,189,42,186,117,3,178,43,155,
22,234,176,244,178,118,118,207,42,207,210,196,252,132,117,166,102,110,16,43,119,253,160,109,217,243,8,145,2,197,5,32,137,201,0,143,104,172,55,251,81,78,9,88,23,115,90,149,73,204,88,246,133,194,170,227,104,9,61,191,126,26,75,239,140,52,232,55,25,91,9,3,233,137,207,187,156,37,254,160,118,133,205,127,184,19,32,228,217,157,73,237,203,231,165,250,124,97,135,38,96,198,234,96,199,80,167,69,229,235,192,242,183,196,158,1,14,7,241,220,61,251,23,49,34,9,184,72,76,84,1,232,149,197,176,240,30,70,93,246,197,232,140,205,68,243,50,132,90,105,224,35,115,134,156,32,178,184,193,37,25,86,236,64,226,182,143,35,82,99,107,34,253,207,187,114,39,148,173,38,115,37,38,242,250,150,123,114,200,22,36,46,47,47,198,104,118,214,151,239,124,138,159,12,175,60,145,107,26,197,18,0,14,203,76,24,5,196,80,105,51,219,47,115,91,220,127,80,94,70,84,122,235,247,205,187,13,222,141,85,125,69,17,243,51,88,45,247,73,105,100,223,155,33,3,51,175,20,135,156,177,22,59,27,103,150,188,92,72,133,244,181,251,133,111,250,200,6,178,
89,237,180,155,133,114,93,73,208,101,207,249,202,207,214,115,97,31,103,19,52,122,164,28,241,21,46,186,94,7,174,73,3,109,201,194,217,245,224,228,191,79,53,127,254,222,227,153,208,213,76,50,36,72,206,147,129,197,92,222,123,24,83,36,26,184,181,210,120,55,33,117,10,203,203,178,191,87,39,78,251,140,188,16,120,16,167,178,112,237,191,156,56,209,47,248,170,37,186,245,142,64,114,102,172,244,55,147,92,100,167,128,68,221,212,174,68,216,52,15,26,167,79,224,232,104,228,30,120,54,90,238,209,118,155,86,116,93,89,247,174,72,14,155,232,216,85,25,220,214,72,137,15,249,131,97,57,234,92,255,71,184,154,176,205,236,1,186,210,157,66,132,245,68,173,187,99,108,19,19,71,237,19,76,165,123,19,185,152,21,106,238,244,92,199,31,199,202,213,73,249,127,56,111,58,39,217,222,116,185,206,16,112,65,125,62,101,94,130,206,129,116,125,64,104,224,64,77,97,248,153,2,197,151,203,87,165,41,165,165,215,229,75,62,207,161,240,73,135,104,234,137,209,9,0,194,117,212,112,174,137,106,82,44,156,164,76,224,253,73,189,25,25,137,
83,83,245,27,1,59,5,146,81,82,120,120,127,126,95,32,173,143,217,200,108,244,157,9,42,181,102,214,105,205,32,165,109,41,227,236,193,107,33,98,243,106,57,247,99,179,67,0,132,2,90,61,175,240,173,168,101,252,143,27,150,44,209,212,28,239,125,166,12,45,180,18,82,23,151,14,235,129,33,208,140,83,233,191,125,221,223,254,238,255,166,144,27,178,80,137,102,105,2,170,231,14,166,15,139,104,200,201,127,111,40,71,6,186,4,108,172,46,67,166,249,79,31,227,47,95,227,255,226,72,118,54,110,231,98,123,237,247,222,237,78,14,175,236,126,31,255,159,0,0,0,0,255,255,3,0,12,99,29,26);
//:array[0..0] of byte=(0);


//system help - information relating to the app's system settings and general behaviour
syshelp//07nov2025
:array[0..17112] of byte=(
120,1,236,157,235,110,28,201,153,166,109,96,127,17,152,123,200,37,48,48,53,75,138,18,213,39,11,59,99,80,20,213,226,88,18,5,146,106,185,215,235,31,201,170,36,89,86,157,92,7,81,236,203,88,204,21,205,149,237,243,190,95,68,102,86,145,114,171,103,52,30,187,157,141,238,150,88,149,25,241,157,207,17,124,242,246,233,195,95,240,207,96,124,49,249,127,252,57,44,199,253,121,175,156,86,143,139,7,255,176,49,191,153,47,170,209,188,119,85,141,226,131,235,89,57,157,47,110,134,252,180,247,15,27,23,147,241,98,92,234,171,131,201,114,54,168,102,197,171,234,58,62,158,15,126,224,227,135,233,161,222,100,56,153,121,69,189,226,159,246,88,225,203,47,211,195,177,34,27,158,95,166,71,31,126,245,245,215,95,126,177,151,222,23,132,139,234,195,226,223,255,237,23,191,248,253,226,15,7,87,229,248,178,42,22,87,85,225,199,7,227,203,98,114,225,159,203,233,244,87,243,226,219,55,71,27,207,102,147,81,177,152,76,249,111,50,60,47,103,69,111,56,232,189,43,54,127,191,168,166,143,39,211,197,96,50,158,239,61,248,67,113,28,127,
221,44,38,179,130,183,139,81,53,94,22,155,247,239,223,47,254,165,249,110,75,11,205,6,151,87,11,109,116,61,24,247,39,215,247,238,23,197,254,184,216,172,23,136,143,249,118,56,44,250,131,249,116,88,222,240,200,105,53,172,122,139,180,111,160,206,174,7,162,200,102,177,40,207,129,175,152,95,77,174,139,225,96,238,213,253,76,17,68,159,223,223,216,56,3,205,77,63,95,156,154,19,243,205,120,118,48,47,216,100,176,40,6,99,214,88,92,205,170,170,152,179,151,48,123,188,241,240,126,241,100,57,24,46,118,142,198,65,165,188,100,177,83,204,170,178,95,76,198,195,155,221,229,188,42,202,121,49,152,111,236,221,47,14,150,243,5,68,91,1,128,167,121,6,234,249,187,193,188,60,31,242,198,184,95,12,203,243,106,56,172,250,249,173,135,59,15,31,108,60,186,95,156,150,239,249,240,211,214,152,251,89,246,191,24,12,171,173,249,61,96,18,229,222,25,233,25,251,240,223,195,175,30,252,175,226,220,152,12,214,49,1,237,222,213,100,2,14,23,112,91,196,30,140,166,195,27,168,96,154,151,43,96,136,208,48,152,175,89,7,10,12,23,131,
81,197,59,207,96,252,96,60,95,148,227,94,181,93,236,255,105,89,22,47,203,217,96,172,239,222,150,139,222,149,8,36,89,171,101,139,77,37,128,243,180,124,188,188,96,225,157,98,60,41,198,21,248,95,72,154,198,69,217,239,15,196,143,114,88,12,39,101,127,59,0,216,150,172,205,171,5,204,221,47,158,12,203,193,15,197,225,120,81,205,166,179,193,188,154,255,106,21,234,173,127,186,127,222,131,52,37,124,94,104,75,104,2,231,203,90,94,22,215,213,120,113,19,47,205,183,193,108,62,69,0,6,226,147,160,48,39,164,33,163,9,242,85,206,167,72,200,252,150,186,136,118,147,17,242,195,215,131,18,81,204,60,100,39,54,236,87,179,129,216,90,46,17,144,114,49,232,149,67,208,21,209,69,153,185,72,117,118,13,51,36,213,112,147,109,69,176,139,25,198,97,187,24,67,75,127,6,115,38,51,232,12,24,208,31,88,207,6,11,160,140,183,160,13,82,229,103,71,194,49,96,31,141,16,137,31,38,227,138,167,79,121,181,95,206,146,112,73,53,14,75,184,115,167,108,20,87,146,234,5,182,96,114,61,46,150,227,193,159,150,82,142,70,193,230,128,188,159,164,
58,32,72,250,81,128,218,228,58,144,72,248,32,56,231,128,153,52,160,234,11,91,144,5,135,5,82,113,215,34,219,44,54,155,200,14,104,123,209,194,218,205,66,250,123,82,210,98,33,244,251,40,183,87,222,100,217,231,85,113,51,89,254,138,23,47,176,49,197,162,66,226,111,43,101,49,31,78,224,225,78,81,9,255,139,165,120,145,161,179,126,182,4,28,115,180,184,154,44,33,249,248,38,68,51,176,145,221,70,30,67,3,37,172,104,198,32,80,43,167,146,207,48,151,80,191,244,118,54,83,139,114,182,96,91,177,166,250,80,162,106,224,2,40,197,67,62,76,88,20,15,55,97,204,113,32,29,22,147,5,16,31,212,5,211,89,161,15,6,209,164,45,166,229,176,90,44,248,202,70,19,24,170,114,6,25,14,108,170,203,252,181,246,78,6,213,244,139,119,251,200,233,228,50,25,99,113,179,255,71,72,149,120,9,247,251,213,124,48,147,204,66,200,64,230,248,183,197,245,21,36,237,35,79,122,97,136,206,141,145,230,247,213,240,102,59,61,163,167,251,179,242,82,124,152,161,51,50,144,189,229,108,62,153,237,194,146,203,106,182,24,76,107,193,79,155,37,44,108,96,
122,127,90,178,107,250,194,10,226,133,122,147,209,116,201,118,146,139,10,16,90,28,18,36,248,29,124,22,111,141,23,131,241,146,77,225,232,114,218,71,190,48,61,19,116,250,194,6,45,219,157,108,8,141,196,176,54,71,210,212,85,13,53,123,225,199,6,94,243,91,240,12,172,198,213,117,2,48,188,12,44,150,56,108,188,149,106,26,220,249,213,192,226,178,246,28,160,92,97,178,109,136,36,216,122,235,55,69,113,88,206,229,233,194,227,34,223,193,159,228,193,66,242,119,178,251,77,222,18,231,122,144,92,96,195,219,196,209,157,85,229,9,157,201,74,146,149,7,209,13,35,31,228,189,173,36,97,79,218,78,95,158,93,30,255,165,60,252,191,20,14,4,68,32,125,118,42,180,246,231,184,125,169,225,217,205,84,138,45,244,90,226,35,213,221,212,131,155,216,156,197,98,50,230,201,239,37,37,109,124,101,155,77,245,36,180,239,188,128,180,31,81,92,142,49,164,22,97,175,211,223,204,216,100,123,220,94,105,158,41,55,38,242,169,31,148,65,145,223,128,61,237,135,139,30,222,6,35,181,178,117,144,0,176,199,214,59,107,247,51,116,183,241,118,
16,207,111,38,90,162,23,25,146,59,173,42,70,120,190,12,135,216,242,147,177,141,118,70,48,50,218,219,66,51,91,47,220,137,156,104,210,200,36,143,207,137,121,16,40,41,152,121,104,139,180,130,212,70,216,129,28,97,173,200,140,67,38,113,164,77,133,32,25,108,57,109,91,223,16,160,97,137,113,200,150,55,246,74,76,16,195,175,196,182,136,157,138,41,46,20,151,218,246,177,248,132,164,24,96,185,30,221,160,141,34,92,143,119,102,118,244,61,108,138,165,35,197,126,24,64,7,110,9,221,132,255,1,28,59,50,99,138,17,33,203,173,133,107,203,141,202,201,127,219,14,236,36,50,239,42,156,16,185,171,69,239,55,27,223,87,118,103,200,196,29,203,36,201,200,14,2,240,179,75,184,88,206,245,222,199,168,44,83,184,226,198,86,189,215,10,13,179,249,92,231,136,168,198,126,243,43,129,47,227,31,194,82,134,173,174,159,86,236,215,18,16,217,230,85,179,22,120,173,26,183,243,146,120,158,101,181,138,2,200,28,61,110,215,8,182,125,94,245,1,7,215,195,227,6,145,18,19,222,94,41,174,18,171,181,218,229,108,130,138,38,110,17,155,221,250,
44,30,37,86,36,4,114,194,48,30,16,14,65,82,254,80,70,2,20,56,28,132,111,30,33,99,107,1,178,1,116,191,73,83,44,117,168,69,78,88,16,100,194,163,177,5,111,14,99,203,243,9,10,181,144,96,250,213,221,81,53,99,11,199,250,34,99,86,196,148,222,160,154,250,91,0,194,15,97,161,244,169,172,7,82,18,251,201,67,240,223,87,15,154,176,169,5,99,50,217,188,93,42,0,196,249,207,171,247,149,132,218,248,201,77,47,174,112,197,23,23,213,12,64,67,83,22,108,50,28,188,171,138,171,201,108,64,168,182,224,113,137,14,47,58,80,204,50,68,104,89,245,121,246,162,236,11,13,63,163,192,100,38,47,23,98,113,61,57,87,216,58,100,211,161,36,243,76,177,37,1,206,56,146,154,8,205,28,126,160,82,193,132,68,248,73,113,41,247,54,130,102,152,121,91,33,137,5,212,101,153,183,87,146,142,185,226,219,219,200,154,30,41,236,149,108,16,35,42,190,41,205,89,212,152,96,157,149,136,106,69,183,241,68,65,59,96,181,23,10,16,146,154,65,23,108,188,36,98,236,200,44,236,83,68,252,87,96,190,131,107,189,144,196,44,38,215,138,101,47,103,213,13,9,247,
144,56,153,93,231,119,61,146,16,33,150,37,16,49,221,175,200,68,135,206,70,109,253,64,241,24,3,52,31,14,216,122,59,28,43,38,23,157,132,27,132,161,146,69,196,104,49,27,236,100,90,130,197,93,226,61,95,78,21,162,75,31,70,229,135,193,104,57,74,146,29,86,182,95,77,225,63,50,252,104,175,56,87,54,2,146,39,223,62,217,23,197,208,3,162,192,111,244,57,241,10,161,37,152,85,80,239,124,184,4,18,9,68,57,156,94,17,45,147,59,141,97,111,138,35,179,47,98,71,172,231,120,62,133,204,240,239,245,171,111,99,103,0,125,53,89,84,143,241,120,137,39,208,238,22,23,237,196,38,83,68,85,17,57,28,84,230,17,146,37,112,151,170,2,20,123,15,138,139,233,188,216,242,151,243,130,167,101,242,39,227,254,61,44,198,213,0,191,54,170,128,192,246,4,24,20,198,41,40,107,84,86,218,63,171,166,37,58,216,48,120,91,235,42,149,108,175,152,52,162,44,222,195,146,73,160,47,41,170,32,20,158,2,203,207,190,243,37,48,18,46,58,137,16,217,216,233,224,245,155,98,58,185,22,27,201,227,156,139,33,148,96,36,150,43,183,155,12,151,78,240,225,249,145,
45,215,12,20,70,200,124,31,144,224,218,4,17,128,234,94,131,204,0,54,246,136,229,144,215,74,158,54,18,83,175,213,34,209,110,107,93,177,116,50,115,152,50,225,101,80,229,191,98,62,154,160,5,69,80,24,165,200,68,129,62,50,164,167,150,60,164,6,46,131,230,128,192,25,74,226,180,168,67,108,156,46,224,232,37,111,111,61,184,127,159,154,207,189,199,27,79,43,66,225,17,96,205,49,26,215,197,72,49,69,34,115,139,181,161,87,208,124,142,32,237,142,100,54,222,15,156,216,130,252,62,9,245,117,241,190,68,186,32,139,116,238,150,197,157,47,207,101,237,207,171,49,137,26,14,8,173,5,94,241,26,70,224,109,202,32,170,215,216,46,30,62,120,176,3,116,74,160,99,53,24,114,62,25,246,135,10,109,247,211,78,97,148,121,84,162,64,74,162,84,6,113,188,33,180,185,40,151,195,5,143,158,225,231,198,250,60,187,196,86,248,114,74,178,35,170,108,154,82,132,67,169,54,244,52,170,69,4,56,167,229,69,85,60,169,93,145,130,209,188,55,166,109,38,40,225,202,77,161,31,204,227,140,22,159,190,83,148,0,212,87,178,43,200,251,152,184,225,82,
10,129,97,73,186,193,114,71,42,148,1,253,185,228,70,233,5,100,233,97,238,145,25,196,32,126,222,124,182,183,89,188,171,72,138,18,71,35,157,59,84,145,66,159,107,117,4,248,98,48,27,73,38,23,19,244,174,37,21,225,211,18,73,100,81,141,244,253,141,162,216,56,80,208,175,112,112,139,114,17,242,192,255,144,7,232,18,112,232,219,196,0,33,51,170,200,93,149,110,215,52,184,48,5,50,139,4,251,109,129,89,53,188,232,160,133,4,249,130,107,227,182,193,181,81,106,190,22,68,122,66,171,6,10,31,179,183,8,181,156,89,72,180,16,120,45,69,81,241,132,15,89,225,150,133,1,5,139,76,114,90,59,222,163,5,121,138,15,85,146,3,125,91,24,156,173,2,232,89,229,132,210,53,7,177,141,127,5,223,16,1,102,67,84,107,62,151,154,71,65,115,141,82,59,88,38,168,47,73,151,185,113,229,37,173,94,244,110,122,138,152,160,167,158,250,136,93,68,183,159,55,78,61,130,234,221,239,178,95,79,65,246,10,39,95,34,152,200,86,45,192,201,125,12,171,139,197,46,86,120,11,165,95,206,131,228,84,251,224,181,188,216,174,171,36,91,211,97,243,21,42,245,187,
98,58,248,16,113,64,139,253,63,84,51,34,190,229,12,59,93,59,251,201,197,197,42,164,111,29,71,52,144,198,207,102,215,35,11,220,190,171,29,34,76,10,57,46,202,30,82,44,185,54,247,29,123,253,56,234,25,2,194,87,0,120,38,11,117,52,222,61,38,168,145,173,251,82,146,113,32,58,139,103,132,150,88,240,176,57,59,139,201,14,230,75,127,216,22,203,161,80,178,163,138,119,193,199,114,157,101,127,25,37,182,178,47,69,184,83,208,93,93,120,63,168,120,129,239,73,255,20,15,151,151,136,226,182,132,208,76,79,229,132,96,55,226,241,70,153,88,203,116,58,212,81,17,135,76,95,144,38,79,221,178,140,41,220,186,144,188,249,17,86,73,184,182,200,186,247,41,100,109,19,72,136,38,33,180,81,149,27,81,105,223,73,81,157,171,0,107,75,150,66,75,118,91,159,216,69,40,253,113,158,129,95,5,184,51,153,119,71,107,15,31,228,234,89,235,149,164,106,46,161,241,244,173,228,231,73,45,187,97,165,127,60,3,58,168,203,119,207,16,161,28,208,100,243,143,179,108,149,198,100,202,240,75,112,62,154,18,237,102,65,182,61,81,53,35,226,90,142,224,
98,88,70,250,15,0,155,43,44,51,248,148,83,247,41,140,73,241,116,82,54,203,5,120,77,207,39,242,4,117,233,229,181,158,220,116,156,137,59,80,56,213,126,193,25,84,253,236,51,34,102,21,242,132,209,57,22,94,158,23,137,148,181,199,205,17,174,59,101,15,15,77,42,190,28,226,5,37,89,243,193,104,48,164,217,162,254,79,173,77,78,113,228,177,148,70,19,223,149,33,101,188,128,203,161,230,23,81,9,201,147,68,253,122,50,123,7,204,139,72,204,182,115,193,137,232,55,85,19,137,49,206,39,148,95,70,228,147,42,194,19,242,12,46,40,93,18,224,167,183,176,120,142,87,231,187,97,65,48,130,229,8,45,84,85,77,29,172,208,148,200,245,208,120,5,178,19,226,222,185,182,215,154,197,150,183,178,150,98,184,194,9,78,166,250,57,118,86,235,231,251,84,58,81,253,130,216,85,25,134,43,194,242,131,120,15,147,185,44,46,39,147,62,49,30,21,117,148,27,181,158,18,103,98,118,166,14,72,203,158,114,62,106,67,10,78,6,16,21,98,107,57,213,148,54,159,12,137,67,136,241,144,194,120,90,180,106,145,29,230,188,77,165,221,120,57,209,79,166,34,248,
162,56,33,213,50,200,38,103,203,41,121,160,41,134,213,95,142,175,41,246,65,180,26,113,136,15,49,249,170,73,227,118,97,89,164,112,65,206,154,109,33,12,80,243,143,229,140,78,9,81,135,106,129,88,229,10,168,82,29,86,112,68,70,2,190,138,155,195,143,73,40,90,120,215,105,150,137,156,132,172,34,191,164,73,1,145,219,101,128,100,155,3,55,185,238,122,117,212,61,234,3,128,129,116,69,99,39,236,137,138,76,253,9,117,150,40,157,202,80,166,228,192,109,76,210,104,9,170,87,35,243,120,167,52,49,133,171,187,1,197,111,156,237,69,176,172,184,23,214,192,15,226,86,149,187,100,73,193,30,222,225,60,228,185,29,108,95,134,124,37,120,135,138,192,30,254,250,215,15,224,175,35,79,193,128,161,31,204,208,170,178,63,153,141,197,5,150,125,134,122,30,160,176,144,11,228,94,43,9,136,31,183,230,176,118,184,27,164,226,97,7,141,179,201,152,18,196,104,57,87,47,198,185,150,130,44,34,57,22,144,51,58,138,56,6,191,239,2,0,124,69,221,45,151,222,158,86,211,136,38,23,44,164,54,47,76,228,11,81,220,75,44,11,161,197,205,206,229,
140,58,183,116,213,246,31,181,31,252,160,245,69,63,86,81,95,37,233,179,8,152,189,198,98,146,34,249,62,193,101,138,9,33,195,57,201,131,4,35,81,62,101,202,14,232,175,201,143,36,246,99,4,9,86,181,4,5,238,159,177,89,36,52,214,1,181,116,208,180,155,169,81,14,150,240,126,100,164,95,23,211,15,225,245,232,187,34,7,153,189,72,219,92,105,187,228,142,128,157,28,147,102,44,27,78,122,189,229,244,134,54,70,15,187,160,210,1,118,94,133,121,201,15,169,23,197,5,201,242,179,229,12,140,103,106,72,129,99,130,95,122,21,17,104,212,67,32,108,132,95,229,144,236,1,230,77,70,238,159,41,151,149,68,133,32,69,85,138,69,120,2,19,3,67,30,20,91,180,11,211,83,247,4,32,145,216,214,85,85,190,135,43,241,174,56,121,203,67,61,83,114,75,239,56,10,106,45,150,228,112,53,72,83,199,221,242,57,110,63,177,231,151,173,194,143,31,115,68,89,190,47,177,218,42,189,176,104,171,163,106,116,46,197,119,251,148,125,146,98,245,209,120,232,140,8,37,119,54,191,4,200,179,168,102,72,60,146,113,102,51,253,148,154,226,42,158,44,232,16,102,
157,101,137,86,13,208,144,32,83,167,137,98,72,60,4,38,103,164,42,136,46,156,74,71,183,130,213,176,54,140,186,219,239,171,18,37,81,196,151,168,43,249,64,226,32,242,122,233,123,169,2,64,184,39,121,11,250,0,224,215,123,60,182,102,102,162,237,34,81,90,51,37,251,185,247,73,63,146,29,108,51,208,61,81,135,165,108,164,85,106,211,231,182,81,168,200,120,61,109,207,109,172,249,29,92,69,83,205,212,220,233,170,119,209,204,68,52,102,47,80,249,22,91,159,212,121,167,35,64,195,64,126,192,19,98,81,93,44,53,188,171,37,14,178,68,71,30,174,60,137,56,242,129,54,20,45,240,7,193,65,58,176,3,197,198,238,166,38,224,100,178,136,30,208,71,71,202,123,191,13,122,229,234,4,2,241,246,10,33,86,93,235,214,178,68,52,196,1,180,141,114,237,53,213,57,180,22,145,243,23,191,53,9,191,249,45,170,239,141,231,60,186,79,73,199,6,243,146,1,149,30,14,110,225,44,88,122,77,20,49,57,127,63,160,103,102,121,155,15,46,199,132,3,216,152,69,93,168,228,133,243,138,54,57,234,173,36,200,61,100,64,198,168,165,106,74,216,47,137,171,75,
17,138,201,73,116,27,72,154,39,213,117,126,2,148,107,229,152,26,214,166,46,219,188,157,104,150,124,198,5,209,145,27,220,41,54,217,178,111,133,160,125,122,186,247,92,149,26,140,85,15,1,216,48,73,132,66,8,253,172,10,36,47,41,103,132,105,181,183,206,68,146,4,64,89,69,17,194,35,189,42,141,48,165,160,146,63,86,89,140,210,112,64,160,29,29,40,79,137,121,129,128,52,36,242,159,185,27,95,200,63,186,113,64,230,136,239,166,32,166,38,105,56,17,219,61,49,75,28,150,2,148,231,4,111,11,245,120,101,28,209,5,250,184,20,141,20,239,33,57,148,115,201,78,134,42,94,90,110,128,132,40,39,67,110,67,95,170,85,79,73,162,116,56,133,197,166,69,153,31,176,60,156,125,55,47,148,218,104,177,153,252,29,6,90,165,130,204,66,240,142,228,154,61,145,60,91,2,224,64,27,174,136,80,222,73,62,245,225,238,5,150,206,86,142,200,139,156,75,102,94,142,38,50,235,107,132,54,215,208,172,77,248,87,75,88,182,141,181,190,64,40,10,158,176,73,84,101,159,217,4,143,42,79,223,64,132,164,60,87,38,34,45,33,30,29,97,219,6,115,133,16,23,250,
9,228,178,49,104,189,67,189,12,193,252,103,226,133,189,7,215,197,7,138,29,223,60,184,226,231,98,111,251,193,215,143,182,191,162,64,17,98,179,129,120,253,115,241,232,155,47,252,216,30,67,50,126,236,155,237,189,95,127,177,253,69,243,24,106,244,207,197,215,95,125,227,199,190,120,180,231,199,30,61,218,126,248,245,215,237,213,240,205,44,184,69,104,63,75,85,49,170,55,3,212,143,104,246,94,102,132,98,83,205,69,16,171,68,189,115,235,139,15,250,18,28,147,44,91,82,109,39,192,98,75,131,9,161,40,237,197,122,180,88,96,29,212,80,181,140,108,200,117,124,115,205,61,71,211,61,119,168,178,124,93,59,195,72,172,132,246,95,62,248,71,209,209,91,137,173,219,112,35,151,191,212,158,24,244,64,69,108,6,100,237,34,15,109,173,65,86,99,168,45,4,149,217,131,17,97,49,15,38,176,224,39,252,162,250,144,119,198,210,96,30,9,179,120,211,88,2,240,140,118,10,69,213,75,210,20,132,241,38,140,134,91,32,178,217,250,130,87,152,94,184,154,176,48,243,83,204,214,205,22,75,2,100,230,12,98,3,210,125,226,60,190,149,86,100,25,66,
103,108,220,64,44,73,149,28,171,148,217,234,72,22,128,204,160,128,141,105,36,89,82,230,53,95,170,33,19,106,150,53,35,104,69,83,42,23,52,173,166,132,62,42,49,149,74,73,102,82,160,173,189,47,255,145,66,76,34,37,181,30,188,61,1,80,208,20,213,205,100,112,227,167,109,91,173,206,172,105,16,37,226,128,23,1,90,221,57,182,3,83,252,86,251,30,152,50,96,104,36,44,117,248,115,249,27,42,198,105,178,238,46,55,4,51,136,188,162,62,3,160,123,219,197,35,103,74,95,108,83,117,69,135,251,50,245,80,70,52,107,180,79,56,233,147,100,124,179,146,247,39,236,94,94,99,164,84,249,208,3,30,215,74,15,223,18,18,56,148,216,189,27,170,47,0,67,216,65,252,24,118,20,72,122,50,84,90,46,244,61,79,129,233,117,251,64,98,80,11,22,132,210,158,16,11,115,231,170,143,202,246,13,212,128,233,69,81,198,214,162,38,238,28,22,208,69,182,212,148,17,130,180,136,242,0,133,216,218,251,64,39,99,57,205,60,91,247,231,34,181,118,87,85,63,197,101,64,209,167,117,65,237,73,162,69,58,58,83,185,41,12,125,191,192,142,176,170,148,92,223,182,5,
207,228,36,178,101,69,128,151,174,73,4,120,72,169,170,252,16,127,65,156,45,22,217,52,214,102,89,153,67,237,155,229,138,34,190,104,168,32,39,155,211,107,61,60,83,208,102,250,173,198,52,117,103,48,252,183,226,30,151,37,52,154,98,225,203,149,95,38,81,65,69,157,26,253,159,18,32,255,135,253,194,143,82,217,69,61,152,144,44,133,107,217,70,67,222,12,215,137,21,113,145,85,252,142,218,84,150,171,22,239,12,196,46,203,142,146,152,215,152,229,136,174,26,191,31,144,183,169,65,9,134,209,214,58,141,234,184,25,211,130,25,201,17,152,130,50,66,44,113,160,45,107,173,36,36,73,148,234,31,206,224,148,241,240,62,22,209,129,210,146,138,171,252,23,60,203,181,127,37,63,51,60,38,212,114,51,74,85,130,144,204,92,249,87,221,137,238,185,236,188,214,226,123,66,192,136,33,66,120,111,87,247,163,126,23,163,185,150,3,143,173,96,156,109,195,44,140,50,43,248,5,199,179,252,245,158,55,135,190,226,92,142,208,190,98,223,126,177,247,5,224,222,206,124,28,35,235,251,148,164,168,224,196,146,77,245,91,99,49,1,66,61,62,21,250,
22,97,232,106,84,127,68,76,160,166,112,46,217,165,216,73,192,139,188,153,109,228,44,152,39,196,215,212,37,117,76,161,13,82,108,172,20,90,68,171,206,9,51,171,208,212,114,152,98,153,141,103,164,104,180,234,60,126,32,147,144,242,20,241,206,40,64,2,100,162,137,232,45,16,130,196,78,55,227,169,246,71,45,58,8,144,34,105,191,143,166,193,158,212,190,101,113,25,77,190,18,169,85,71,193,168,188,57,199,239,46,109,246,50,190,72,108,146,152,154,37,254,126,159,80,134,241,11,244,57,226,49,99,128,20,0,142,226,186,107,26,124,196,113,80,33,19,70,5,248,219,210,181,112,73,164,191,236,201,245,8,209,102,23,210,120,77,195,74,186,219,67,120,8,66,12,238,18,216,43,2,247,11,33,47,154,54,81,54,236,34,113,35,100,122,66,133,5,137,84,191,233,42,94,203,6,49,179,231,158,42,2,161,172,223,61,252,192,0,101,50,225,29,95,135,241,144,73,244,75,154,69,255,68,217,243,174,2,44,100,250,94,164,158,90,57,167,219,33,152,72,68,228,207,166,43,132,124,90,253,177,252,110,201,104,248,108,32,194,121,152,235,110,169,93,21,216,227,
161,26,179,218,86,147,78,168,247,230,169,39,244,55,225,137,216,175,233,103,145,89,205,120,213,64,233,249,204,150,96,158,132,45,2,242,156,156,82,216,29,44,70,204,243,195,7,26,196,106,135,215,148,10,154,244,7,12,228,34,100,225,195,136,105,28,237,92,51,246,77,179,144,248,1,149,200,33,59,72,121,50,9,202,142,42,66,66,82,5,189,41,25,172,23,77,130,26,160,202,156,40,227,152,135,109,15,225,128,22,103,147,126,201,203,169,236,19,168,162,2,40,36,116,229,127,174,253,188,71,145,136,85,36,86,84,117,102,229,181,6,39,166,242,236,152,134,40,100,18,162,233,203,154,6,13,24,206,203,219,236,215,124,44,173,25,125,196,49,136,25,101,56,17,141,98,166,151,147,3,162,38,35,71,151,42,152,138,28,60,125,19,208,165,114,150,75,185,213,7,191,19,53,28,155,108,125,28,131,159,230,20,24,42,125,172,201,22,3,46,102,40,145,232,112,66,48,89,35,106,43,110,236,0,141,158,122,77,200,176,83,24,168,28,94,192,26,113,5,245,56,212,236,140,166,11,156,96,52,2,154,4,49,178,61,172,57,46,72,82,1,38,174,238,11,74,104,235,44,14,203,1,
21,83,41,54,84,62,70,227,23,41,196,86,150,40,186,194,185,220,247,93,11,174,97,4,84,38,50,229,143,183,62,44,81,252,154,206,122,110,130,241,126,240,119,7,94,167,7,230,197,195,135,33,117,161,250,233,232,73,16,154,101,94,150,61,195,245,130,6,226,7,16,197,118,71,38,140,44,202,141,169,156,141,57,51,198,41,19,118,177,71,81,71,12,181,128,175,16,187,36,242,229,89,117,106,129,35,215,241,160,158,130,28,207,200,103,150,201,112,62,193,224,133,249,82,114,205,3,96,195,33,1,41,50,145,3,120,70,133,31,119,52,208,233,1,0,37,97,224,115,213,153,86,182,198,32,175,71,151,36,180,19,173,205,75,42,10,156,187,125,151,9,54,55,197,136,77,164,70,23,81,134,20,218,84,154,2,73,219,29,118,10,147,9,54,74,235,249,217,10,91,99,204,182,146,235,92,25,204,168,97,144,96,125,158,225,222,204,246,136,233,151,77,18,150,91,75,4,15,5,18,223,18,2,13,117,228,2,209,152,77,152,17,34,173,33,171,30,114,198,134,246,163,233,15,20,168,172,181,123,129,230,0,246,51,89,250,186,134,181,155,98,40,61,156,219,100,130,178,158,241,13,105,133,
33,84,110,96,82,132,190,162,172,198,177,236,254,61,32,206,7,110,119,218,10,164,17,138,146,243,28,46,253,104,56,28,6,30,196,249,16,45,111,216,76,54,91,99,125,148,237,180,190,10,235,209,243,202,134,230,248,183,121,208,55,90,241,30,27,55,11,244,181,124,115,158,161,88,142,169,71,244,99,232,3,76,243,0,134,62,44,74,166,189,164,187,28,83,49,179,93,218,104,64,217,17,90,50,33,24,48,53,229,156,104,169,235,41,237,20,121,196,238,25,9,210,24,87,61,70,120,169,29,199,23,65,210,155,17,67,42,50,105,72,155,87,13,191,0,199,46,21,202,155,159,119,132,119,22,253,159,30,211,121,135,11,141,211,224,186,198,151,244,36,22,58,45,82,10,53,51,57,79,141,249,193,21,171,130,250,251,132,136,92,148,19,225,57,115,14,216,15,76,187,167,60,82,121,236,92,85,186,48,133,43,26,234,24,36,136,211,218,19,209,250,72,144,40,249,54,16,4,86,105,252,68,71,162,206,36,7,174,36,198,174,219,33,46,207,106,148,146,86,103,87,26,159,59,65,184,84,163,198,129,158,202,139,170,50,65,68,138,96,242,55,113,18,195,48,214,86,90,230,2,9,200,199,
140,206,84,88,80,134,44,225,137,150,128,114,84,140,152,99,194,9,98,162,137,41,127,237,31,36,70,116,6,243,14,74,81,21,81,215,235,219,143,189,56,120,138,123,86,231,2,167,16,67,108,161,242,248,139,232,200,201,75,72,161,93,105,24,43,211,166,204,106,155,22,121,172,141,150,96,194,94,35,168,7,39,103,197,214,1,12,38,111,47,78,48,207,103,75,60,196,61,162,87,233,177,201,151,104,34,45,31,211,57,153,205,77,12,196,87,7,72,68,20,58,0,28,203,113,112,97,30,48,115,23,139,59,244,64,182,99,16,13,149,139,250,126,184,115,149,150,164,133,91,212,254,0,164,241,131,196,162,254,70,21,127,204,190,131,106,101,240,82,255,230,172,142,106,26,58,224,39,243,16,161,118,208,171,145,86,126,238,93,249,36,144,92,145,236,249,92,189,46,53,193,162,23,17,208,207,153,200,139,102,141,42,156,245,8,177,4,74,63,72,168,177,17,8,174,99,96,134,42,123,239,84,2,130,207,59,244,215,167,74,102,240,199,56,200,139,193,229,50,87,106,129,74,169,33,22,83,253,38,198,181,105,135,201,123,156,79,200,206,144,57,234,241,244,189,205,210,32,213,
109,103,193,113,159,251,88,180,21,91,156,56,46,203,139,180,137,139,242,168,12,145,194,114,87,54,118,147,243,131,130,170,224,155,217,146,153,148,116,227,168,20,56,74,62,146,199,146,225,22,157,69,91,18,202,26,170,224,141,201,134,29,252,149,166,204,212,54,132,32,213,232,188,234,171,140,145,40,173,32,202,17,40,53,5,135,248,218,218,161,39,92,13,149,36,103,147,30,40,199,164,248,230,217,73,153,192,104,82,195,14,50,47,232,167,217,21,180,53,137,91,66,196,66,8,227,66,125,83,12,160,99,50,188,175,208,135,246,37,61,238,157,144,177,92,164,202,197,32,24,170,102,30,53,221,84,176,76,117,159,53,197,2,255,253,40,92,70,1,97,39,126,0,13,184,76,129,84,7,40,99,70,16,159,198,128,45,134,80,147,130,25,212,112,81,234,13,55,3,138,100,65,70,25,200,81,16,213,152,157,174,49,160,216,148,168,16,137,219,233,107,219,136,164,138,147,123,15,121,166,32,123,244,204,209,96,40,122,145,81,116,231,141,136,103,62,26,80,237,140,24,40,101,182,252,36,139,154,197,220,141,8,160,158,35,144,101,177,249,98,114,189,153,134,227,
4,117,180,93,97,142,170,141,12,210,99,183,132,74,10,160,76,193,100,203,86,178,43,104,169,128,151,242,125,182,79,170,125,234,77,5,201,210,61,97,144,235,15,88,45,79,204,186,234,86,142,226,20,94,140,213,13,125,206,211,249,122,0,218,18,51,152,239,210,86,154,175,141,218,136,163,117,16,73,221,156,228,7,36,10,155,47,57,137,176,28,249,200,239,230,115,44,226,166,213,35,207,174,0,12,124,150,138,114,38,86,22,47,166,132,147,200,37,143,113,170,140,31,58,144,188,53,46,80,181,86,140,160,213,88,202,104,105,167,100,88,13,49,222,19,105,191,176,115,86,148,197,58,4,181,133,11,4,179,171,128,230,75,141,220,200,58,81,122,243,92,117,61,44,222,106,34,107,104,213,239,32,72,20,190,156,79,169,11,68,232,88,131,32,183,163,94,232,170,42,89,57,245,204,186,173,145,97,68,158,81,165,85,131,35,179,137,119,102,165,182,223,71,134,144,54,69,47,62,187,103,224,147,118,74,169,197,177,80,113,10,61,87,178,217,240,138,6,185,232,251,76,70,169,62,122,75,126,17,21,38,147,45,199,216,54,211,109,71,83,135,243,62,228,128,56,250,
220,44,174,19,74,89,72,144,154,85,68,101,101,30,210,234,37,126,156,49,57,41,249,102,126,210,135,106,28,55,145,60,206,168,91,174,121,87,24,6,196,33,223,178,245,160,98,71,43,11,4,5,154,19,44,43,196,80,185,88,157,107,218,81,185,150,145,202,83,81,3,216,124,202,80,192,102,161,14,55,118,195,93,255,205,23,170,47,233,51,13,44,187,202,241,164,213,217,205,169,219,67,83,110,47,213,3,93,238,137,70,175,52,117,215,203,102,21,75,130,22,177,134,19,188,11,8,47,59,156,58,224,239,201,106,42,38,146,80,134,48,236,73,129,208,191,243,74,231,141,120,212,101,90,60,212,76,39,141,20,247,144,22,143,244,134,76,157,158,87,143,110,93,116,196,85,149,104,246,137,142,233,236,208,246,208,159,148,84,28,58,32,36,237,146,31,20,246,51,110,64,143,177,53,51,183,113,241,237,243,199,72,25,85,12,164,159,90,0,141,40,79,84,168,203,67,194,225,225,10,75,142,79,88,164,86,167,50,74,233,65,102,77,78,44,62,58,126,141,65,0,141,204,156,56,154,183,121,234,35,174,167,130,88,227,111,175,12,4,3,202,250,56,200,41,28,80,39,17,82,183,0,
100,146,203,68,202,253,198,28,56,214,24,104,54,54,94,102,208,111,45,113,53,192,103,106,82,152,81,2,205,112,198,154,228,112,156,43,148,172,185,144,189,40,231,239,184,186,64,11,101,196,111,45,180,2,75,67,31,104,203,68,31,122,201,127,2,172,25,241,240,128,29,226,83,214,219,48,136,254,78,3,134,154,119,25,14,131,158,183,246,193,17,169,161,215,162,182,206,118,76,122,110,187,201,133,168,226,121,67,112,70,12,203,212,46,86,37,33,209,172,254,202,7,57,92,132,142,252,41,135,195,155,47,29,62,189,140,78,0,118,217,119,50,52,169,45,33,225,218,17,72,130,91,206,47,23,155,79,35,237,219,164,241,97,219,36,186,207,49,240,153,92,49,195,185,217,224,69,169,76,100,201,110,75,148,129,161,150,117,145,9,103,116,78,60,143,192,71,239,93,1,124,26,7,146,232,139,154,57,116,130,92,46,70,242,8,73,12,238,94,109,102,200,110,106,107,205,132,127,136,84,226,172,244,230,105,144,59,194,4,61,221,76,150,248,89,84,38,8,176,162,51,192,195,62,82,1,250,70,234,224,104,169,25,181,54,194,48,109,29,190,18,177,1,174,51,55,162,236,
249,125,43,68,128,198,161,86,202,5,185,52,224,27,34,218,176,201,219,37,208,116,143,195,45,160,238,72,181,78,235,243,12,224,29,22,145,221,87,210,172,122,107,159,223,167,32,27,132,64,59,141,79,36,221,117,91,199,238,46,99,40,37,243,235,212,28,20,139,190,27,171,177,99,121,103,228,116,182,232,33,116,59,107,100,126,169,179,189,202,206,36,28,191,199,14,50,115,57,146,172,252,65,37,113,223,181,112,232,246,179,175,90,184,15,187,125,196,66,202,139,6,123,55,254,12,216,162,138,46,111,149,72,206,154,169,158,130,204,68,217,201,3,2,75,38,36,92,183,22,51,147,236,66,144,196,28,125,232,133,173,235,214,235,32,187,96,133,92,41,200,72,164,143,71,195,172,194,46,194,5,226,139,58,221,212,90,238,7,53,114,32,125,75,116,202,18,151,151,74,58,242,201,100,200,65,127,158,122,200,120,129,247,29,232,80,243,27,149,58,175,136,223,109,80,75,123,131,87,104,251,62,84,213,140,36,108,171,136,53,73,1,26,127,134,13,207,238,12,162,231,66,86,210,100,161,74,63,146,96,140,83,145,30,130,23,17,145,9,2,231,22,67,164,5,171,226,
51,171,118,50,255,84,62,83,161,15,63,222,102,156,75,164,17,31,221,252,202,203,141,35,208,162,102,71,109,130,64,94,86,25,155,86,23,167,225,55,24,181,189,50,153,116,11,27,69,76,25,126,156,208,177,237,151,132,185,233,177,5,76,77,131,18,218,105,160,90,72,237,214,226,220,50,31,49,114,144,179,189,84,249,224,10,7,100,121,215,119,175,68,217,147,225,97,32,67,95,207,36,102,212,174,19,125,41,82,214,243,106,201,170,180,116,46,164,172,181,91,202,30,231,201,101,99,215,235,19,61,150,216,156,102,16,87,58,187,147,212,101,216,88,102,88,114,70,179,30,134,137,114,217,202,123,158,1,157,239,122,125,2,91,13,179,239,199,73,133,21,197,91,229,100,195,102,203,68,138,238,179,84,218,208,222,210,182,65,211,90,197,209,40,63,197,108,75,150,146,244,120,94,45,130,39,169,44,204,150,4,1,107,193,220,40,41,116,86,219,221,144,133,218,154,55,18,222,34,133,99,83,229,23,168,64,251,28,158,150,139,42,83,13,172,60,135,192,200,210,31,93,221,173,135,59,143,178,235,10,115,177,182,175,132,73,114,198,17,106,108,127,166,184,226,
234,75,133,47,96,181,80,10,25,45,57,97,66,179,161,133,174,107,178,240,54,210,38,234,46,113,132,55,103,124,154,64,80,107,76,221,127,35,40,8,229,15,35,103,33,1,80,51,33,52,37,62,119,30,33,133,70,145,149,181,161,254,10,186,60,52,19,129,35,243,44,215,40,251,228,220,131,197,145,97,82,102,153,145,23,145,220,81,45,98,51,190,190,168,145,113,71,211,49,35,113,251,53,179,147,245,37,49,0,146,178,54,140,7,199,183,49,195,85,223,78,113,84,254,145,254,79,4,176,9,102,13,84,212,175,166,25,159,250,109,17,12,35,192,236,18,36,130,30,106,120,213,50,94,31,122,8,181,157,235,24,94,118,108,232,214,126,29,35,202,51,164,190,7,114,179,57,25,239,198,73,191,254,110,214,125,162,11,101,72,112,37,188,251,38,157,209,93,178,109,149,134,251,187,89,24,42,46,126,240,115,203,49,79,178,197,137,225,58,208,44,248,140,17,176,19,87,23,28,108,164,54,140,170,33,58,200,171,186,148,162,78,254,34,102,199,133,25,193,211,34,206,51,108,81,234,231,138,2,90,235,177,26,171,159,82,78,164,151,78,205,158,83,180,217,40,216,211,166,66,
62,78,21,25,32,142,88,185,82,37,64,84,181,159,10,215,238,130,99,19,228,44,52,29,97,94,203,50,6,60,110,124,227,140,157,48,158,82,25,218,198,6,170,24,243,204,53,236,76,216,4,111,150,24,167,135,62,51,71,200,147,231,186,21,158,234,112,80,76,97,189,27,76,167,178,53,98,178,77,57,10,186,82,131,109,234,245,220,238,130,67,57,80,175,106,152,162,12,220,58,173,42,119,43,180,64,108,207,238,171,121,103,44,145,243,132,149,25,92,189,149,53,54,222,198,136,166,238,179,165,181,150,48,177,163,161,212,29,20,170,33,73,41,176,219,165,177,150,26,77,251,138,112,96,51,10,151,75,43,144,71,168,148,153,45,77,213,6,103,70,22,164,124,121,55,65,131,62,69,107,42,95,11,80,198,149,38,9,101,132,64,7,75,247,137,185,36,94,138,31,241,164,232,87,98,31,250,159,2,94,213,228,100,170,84,148,11,33,147,13,37,51,205,146,39,34,39,62,242,145,226,253,108,35,133,5,207,150,205,80,157,47,210,73,250,41,169,217,153,92,236,196,248,59,146,116,137,13,81,248,215,184,111,78,45,115,8,78,198,200,142,63,236,146,26,78,156,113,138,25,125,247,
80,217,15,40,83,129,48,238,202,97,48,170,71,108,160,173,18,70,245,82,98,76,30,49,210,164,5,80,158,230,83,238,46,84,171,119,129,9,245,115,78,67,242,211,206,37,164,63,58,163,124,138,249,153,95,113,116,57,18,14,3,94,87,109,222,87,187,228,135,112,68,243,217,126,48,147,19,92,68,230,228,87,217,251,77,29,43,250,60,130,7,115,48,0,169,79,192,5,80,195,41,169,151,175,47,177,181,145,218,239,248,106,17,214,190,226,219,246,245,18,186,149,46,185,183,220,225,11,244,25,141,243,237,72,46,241,48,111,180,100,231,231,78,114,218,55,26,69,218,179,203,44,6,87,26,65,5,5,103,192,107,210,178,173,11,6,20,180,92,234,214,214,208,226,57,46,3,11,213,94,203,203,126,124,17,228,62,9,110,128,159,23,172,137,199,150,200,16,76,158,76,49,3,231,75,93,1,161,18,11,71,73,56,62,57,25,81,182,208,149,81,20,154,199,49,222,148,141,97,176,12,228,34,245,137,195,39,12,177,105,150,105,43,225,3,106,243,123,27,27,79,39,75,157,110,56,144,41,3,252,83,77,253,100,189,118,62,236,34,73,4,89,148,209,252,112,152,133,132,24,66,207,182,248,
116,141,32,248,110,23,251,188,88,35,39,85,33,128,84,136,235,163,17,43,75,165,10,133,140,79,234,188,50,36,17,103,180,101,226,164,231,243,119,140,51,200,18,71,244,199,71,183,97,145,5,4,82,194,173,60,50,117,225,150,129,74,47,199,99,10,32,18,32,85,134,80,6,201,94,68,26,82,234,232,172,243,153,164,87,158,217,174,132,161,1,80,155,140,110,30,167,114,135,223,74,133,29,152,35,43,173,9,12,130,13,218,4,136,155,143,39,199,217,205,88,232,238,75,11,8,27,60,159,27,169,182,48,108,206,191,177,123,58,228,181,170,199,108,39,176,195,22,33,179,9,50,151,83,248,102,198,185,63,141,143,58,172,113,224,200,104,27,13,209,126,106,104,209,148,156,48,87,11,140,212,11,228,68,113,246,125,206,209,185,228,103,223,100,183,203,22,68,253,120,115,42,153,169,85,36,66,113,176,61,78,76,14,198,68,81,86,29,40,228,169,45,0,16,9,52,53,7,247,242,177,95,153,194,150,156,1,175,120,27,165,253,92,30,110,139,57,1,44,42,6,255,132,35,186,139,70,111,182,49,84,197,233,209,158,110,130,248,54,157,20,20,75,22,128,137,97,169,100,42,164,
159,11,77,200,16,237,212,87,60,228,128,52,197,1,44,78,25,47,110,232,0,152,56,67,97,134,71,105,221,71,196,220,114,202,99,106,226,48,225,174,122,121,112,57,166,132,200,238,80,60,146,20,157,182,160,64,143,150,107,110,81,0,88,218,224,91,12,182,112,180,111,57,118,231,114,239,139,84,164,142,83,142,84,147,124,11,71,93,139,65,44,101,73,133,60,228,6,131,56,135,67,15,107,72,218,82,151,174,32,227,25,143,196,151,48,169,28,170,32,72,233,216,5,179,244,52,22,99,173,26,37,67,189,122,121,130,239,12,9,13,37,209,194,4,203,60,195,160,250,32,157,196,104,229,202,159,86,113,50,215,245,66,122,195,220,251,142,159,181,235,36,128,150,60,195,178,24,221,77,32,230,112,47,249,14,85,210,93,133,76,202,126,133,179,47,120,131,210,42,131,167,27,26,92,248,219,149,118,177,76,147,93,198,114,201,182,12,41,120,166,210,99,27,222,84,102,150,52,193,50,33,110,2,82,161,245,237,57,210,1,93,176,208,118,56,10,210,211,162,188,165,244,29,73,19,100,162,100,211,81,184,107,151,45,223,141,225,6,108,100,83,66,38,79,63,100,108,164,
33,144,183,61,12,81,55,118,138,255,204,96,233,74,117,144,203,22,26,200,165,182,178,135,83,232,122,27,19,34,17,14,100,98,4,106,45,176,250,215,146,38,104,239,16,164,53,86,132,21,213,22,97,223,179,167,205,97,130,90,8,8,223,1,218,129,254,248,74,75,96,204,145,140,160,82,206,158,253,180,32,78,33,147,188,186,92,110,80,52,84,34,69,47,26,56,171,102,242,130,113,76,124,159,73,75,207,13,35,211,250,171,145,149,31,180,74,70,93,82,19,121,244,229,52,199,37,137,139,55,37,140,126,88,55,48,16,187,122,203,104,252,196,231,62,233,12,244,190,121,227,64,105,6,53,4,249,93,221,196,209,155,120,32,92,245,205,143,231,86,114,37,33,86,30,105,87,20,171,119,115,148,14,182,202,73,33,159,46,253,193,166,32,105,83,6,11,83,102,19,5,46,77,84,200,175,82,232,198,21,245,48,244,242,179,189,226,72,42,135,195,126,131,104,41,207,222,17,206,130,16,84,180,203,14,83,55,212,90,148,111,192,142,214,139,66,31,152,245,182,109,38,92,8,2,35,184,138,98,242,253,73,251,170,7,228,144,216,91,120,166,213,249,76,56,183,112,154,13,250,146,
124,95,72,74,126,100,195,117,199,21,5,242,45,48,25,133,160,104,100,10,203,5,193,187,166,105,116,94,127,156,5,0,214,232,202,33,192,76,227,162,186,164,171,50,47,129,158,67,107,164,94,92,173,164,94,145,26,38,240,245,225,163,246,19,177,34,207,160,244,173,70,178,178,4,48,241,145,106,40,66,213,92,231,148,124,171,205,153,214,77,13,139,22,60,0,47,211,177,177,241,134,82,15,163,90,40,208,49,39,196,72,183,115,106,26,138,32,81,134,25,227,249,144,230,54,174,97,73,161,206,29,56,193,236,55,115,70,104,181,43,113,99,170,255,233,181,154,62,130,181,62,124,26,169,1,223,129,87,57,116,159,126,192,200,188,175,252,81,5,40,174,208,0,113,90,158,54,90,55,146,34,221,116,203,50,79,19,34,209,178,103,145,220,23,229,175,234,7,106,158,51,141,112,214,85,112,145,190,62,239,181,222,202,178,203,228,101,1,29,247,54,129,64,14,245,160,9,73,216,219,136,160,152,139,219,253,245,55,190,100,13,39,164,132,246,177,171,20,168,64,60,23,99,26,210,68,145,43,82,28,25,6,145,194,117,23,13,121,5,165,229,166,60,244,198,245,147,147,
241,206,234,199,40,207,123,34,129,29,15,221,128,179,247,74,150,27,72,117,5,179,252,150,162,155,135,162,177,246,208,221,30,18,28,169,41,23,98,232,35,221,229,33,57,81,3,246,167,242,87,69,187,187,249,171,149,17,22,153,212,168,42,165,120,132,10,199,157,76,230,40,242,231,98,50,69,230,84,21,183,35,254,75,178,251,192,33,33,6,51,170,2,34,66,86,169,20,45,194,118,149,155,146,153,175,79,71,197,183,228,216,190,196,151,111,67,72,98,214,218,66,17,129,24,175,167,115,249,245,249,156,108,211,179,39,202,7,8,114,145,123,93,146,69,255,198,191,167,64,200,246,19,186,201,228,100,13,124,92,156,232,230,182,99,43,226,118,241,154,218,244,118,241,61,179,177,234,115,190,166,209,174,11,98,116,243,231,118,241,196,215,186,125,27,119,188,241,7,149,110,186,43,61,158,127,75,147,159,199,152,191,196,12,56,165,202,170,41,17,60,240,101,41,136,222,17,57,95,186,29,27,221,102,52,176,127,131,159,76,173,14,3,135,238,36,34,25,74,78,197,14,151,132,244,143,139,205,253,100,245,177,47,206,68,83,151,175,245,177,221,176,175,114,
245,132,181,157,17,65,96,189,94,186,166,23,118,17,43,135,195,170,11,160,153,172,241,113,220,23,35,18,54,195,57,210,100,24,221,126,64,234,134,153,72,53,229,236,225,237,9,19,231,99,111,48,63,211,171,233,194,218,72,40,82,84,150,122,115,228,55,88,202,28,176,102,144,55,239,243,183,64,180,14,96,227,59,110,171,231,19,102,88,116,7,137,131,118,159,249,56,243,233,199,122,14,65,0,175,13,216,130,84,192,226,172,198,125,209,124,250,157,44,47,29,56,38,241,14,96,213,118,215,27,56,248,70,214,3,2,188,113,61,54,155,112,137,193,92,113,60,245,198,116,114,202,251,152,206,134,53,146,92,1,166,98,97,42,89,200,42,57,111,72,151,1,224,53,235,203,154,144,75,46,87,240,164,134,204,121,98,3,86,52,39,19,192,119,154,198,46,210,232,146,119,227,90,5,10,177,245,21,11,138,205,125,97,83,236,67,81,104,197,53,183,214,139,179,57,183,174,30,8,163,237,251,27,198,156,98,2,14,110,18,208,83,12,111,4,77,179,13,136,44,198,10,42,123,92,15,81,125,13,154,81,229,209,175,38,56,53,8,57,105,175,15,70,106,98,176,57,27,41,58,5,104,164,
199,220,45,206,139,46,28,38,68,145,178,47,139,45,236,223,56,218,73,43,96,81,190,29,14,239,73,70,235,254,47,0,224,190,168,137,180,71,255,31,199,103,60,199,92,82,210,69,242,126,221,11,130,180,167,147,12,154,216,209,9,137,40,212,81,177,116,77,63,2,151,48,98,108,166,2,46,65,57,0,99,15,117,112,20,109,86,240,247,114,160,219,81,85,145,206,206,19,234,85,31,42,154,185,4,153,36,58,173,213,105,228,147,91,50,14,192,58,41,120,88,55,109,136,119,186,144,88,183,246,59,189,123,225,19,2,26,221,143,211,75,198,210,231,62,229,191,43,38,53,229,97,119,25,108,25,232,174,31,149,55,25,21,39,216,188,164,86,100,55,233,161,160,136,108,120,52,227,161,6,67,131,57,134,91,12,241,216,200,240,70,30,177,166,143,242,33,238,246,36,35,211,233,113,2,89,119,198,40,89,58,148,34,108,184,77,3,102,238,201,17,80,181,35,124,39,37,95,212,102,255,229,211,175,190,128,73,251,74,255,157,251,235,174,146,24,140,176,224,219,224,120,200,205,137,185,196,11,128,84,100,154,141,125,176,2,122,164,17,46,81,70,163,40,117,82,75,39,130,77,
210,110,65,18,120,19,51,48,90,133,105,245,250,198,185,204,204,59,192,22,119,129,5,38,101,215,67,41,10,214,139,28,113,105,64,143,223,2,178,31,79,153,15,60,29,40,214,155,242,9,15,96,185,50,217,208,160,163,49,221,210,62,129,29,94,197,30,157,141,104,33,129,161,103,178,184,210,79,199,174,163,130,164,106,153,232,197,164,173,162,75,62,76,195,137,8,41,220,187,100,137,214,77,154,18,65,29,96,119,148,79,215,76,193,52,139,171,118,198,117,240,113,16,72,128,202,160,164,107,103,153,111,167,209,36,149,144,85,150,146,123,63,21,69,8,234,157,123,104,103,23,148,220,103,91,125,209,197,106,157,143,64,247,52,181,160,64,128,29,212,196,73,182,194,132,89,81,195,156,166,75,164,226,146,2,98,41,239,65,89,187,249,213,14,77,82,18,13,100,159,61,71,48,179,74,188,215,21,98,34,236,184,79,247,243,50,149,243,67,55,197,101,16,23,69,115,155,117,21,99,40,114,198,51,217,144,37,179,14,25,234,30,173,201,160,67,119,250,133,18,90,47,26,130,20,140,2,69,154,238,158,244,86,205,138,111,171,15,20,200,43,213,147,248,58,170,156,
155,255,231,241,255,149,147,126,6,87,92,54,107,87,203,120,205,148,105,87,205,112,214,215,213,57,17,52,88,45,22,211,249,227,221,221,235,235,235,251,215,112,236,234,79,247,39,179,203,130,213,84,78,143,163,13,41,240,32,243,58,140,57,111,117,44,235,202,40,60,94,235,19,54,164,179,107,215,41,25,242,26,89,239,237,56,80,28,181,149,116,182,12,164,128,39,17,72,204,116,121,217,184,110,174,67,160,139,229,83,83,202,51,207,208,3,113,226,18,179,157,72,232,32,137,104,116,108,253,86,224,44,1,81,125,226,163,21,20,183,104,148,101,234,189,196,201,92,104,215,71,183,64,216,196,66,53,21,108,22,70,184,20,154,147,244,171,174,29,147,9,138,221,201,67,197,50,117,194,69,45,41,23,11,82,8,174,125,252,29,107,199,88,15,203,157,37,112,210,152,149,233,77,112,215,206,206,172,109,225,27,26,143,168,89,48,30,246,89,13,161,149,131,67,1,194,246,20,0,146,111,65,211,100,200,1,46,206,16,238,6,156,108,125,132,121,166,112,98,203,76,207,170,185,150,206,105,55,14,232,253,128,131,167,9,190,52,150,203,174,249,96,31,18,175,54,
244,177,107,232,132,150,117,13,71,212,141,42,122,157,193,134,163,8,54,229,203,124,242,202,234,183,100,94,251,151,12,32,213,127,192,53,231,95,33,20,135,30,40,111,240,219,136,98,179,60,241,6,14,88,161,219,191,148,34,247,38,219,157,105,243,37,197,86,121,12,142,239,215,22,12,148,158,122,98,31,130,68,245,245,227,45,170,214,136,139,9,181,250,36,202,159,36,12,90,166,102,201,136,86,10,243,104,190,74,108,234,219,91,144,157,166,221,117,166,162,163,234,203,84,61,211,13,6,84,139,46,46,228,47,226,244,27,236,253,40,122,68,14,142,230,228,79,68,221,22,158,167,77,83,174,166,94,32,251,54,27,99,110,213,135,115,191,193,213,251,225,204,158,232,150,108,228,240,32,251,23,89,120,79,30,80,78,72,179,93,246,14,33,107,28,106,61,199,187,236,122,8,45,217,98,170,167,188,227,49,2,232,1,218,158,120,113,53,212,157,28,121,212,249,57,133,86,17,4,110,75,57,168,214,70,131,74,161,78,64,210,14,158,37,105,159,38,62,153,243,22,176,88,200,191,199,66,100,217,103,149,103,174,210,123,184,141,131,17,12,79,112,224,0,227,25,
118,197,186,153,141,133,25,153,136,131,73,100,252,177,196,185,242,107,135,136,202,66,84,165,104,113,238,204,71,132,116,104,14,132,157,224,105,66,42,233,77,187,147,177,113,146,122,2,41,4,36,248,113,145,57,42,34,46,7,185,55,36,226,70,141,203,177,81,18,20,42,106,208,150,41,146,133,174,93,8,183,165,153,126,108,33,209,20,145,63,129,18,173,229,100,251,206,213,112,142,223,47,147,88,48,164,38,168,206,40,189,22,5,78,50,114,41,43,48,179,147,43,67,240,106,87,134,123,214,65,201,232,47,69,123,41,150,189,129,229,113,207,50,198,147,11,187,35,254,146,73,84,211,107,55,183,180,144,130,82,23,247,249,172,31,245,120,59,122,181,158,84,102,167,39,37,151,71,241,133,22,61,97,174,163,118,240,243,149,227,83,142,128,214,30,9,254,168,18,95,233,180,136,131,225,149,86,27,30,193,102,121,207,215,245,170,81,159,107,254,178,27,128,68,21,41,14,138,198,18,54,227,60,70,53,45,109,44,91,250,80,111,195,50,133,97,252,246,27,206,137,196,153,36,233,88,96,97,32,26,195,140,230,6,68,98,249,156,203,204,85,80,74,135,98,21,31,
208,35,106,164,95,84,209,207,13,83,154,179,171,251,120,82,183,218,213,20,97,212,63,249,188,186,237,22,173,54,73,86,77,16,87,170,57,99,59,156,156,3,105,106,194,201,13,69,9,91,191,169,40,28,103,106,195,25,116,69,233,204,228,75,72,200,89,199,151,18,93,201,55,249,39,221,28,82,0,88,73,187,211,9,118,138,29,57,178,53,107,60,169,58,32,34,149,69,54,101,28,244,124,85,142,255,212,187,189,179,122,62,173,111,246,78,234,177,102,172,220,137,142,115,105,12,121,18,150,210,147,113,37,220,93,204,108,155,28,137,125,75,232,71,146,192,136,11,33,62,250,77,180,238,39,241,84,138,104,191,32,56,109,238,6,195,215,247,43,133,95,124,155,5,13,174,41,78,195,102,201,204,200,223,198,97,203,49,119,254,84,4,176,201,166,211,31,12,170,168,147,224,120,77,154,226,218,120,211,91,202,199,143,196,107,157,121,137,11,192,212,7,161,22,39,112,180,191,204,99,10,203,211,111,224,210,227,169,232,167,48,195,154,156,74,33,46,140,217,117,107,123,254,115,44,125,55,105,2,35,95,112,162,189,64,71,185,153,162,101,64,86,155,212,54,205,
11,212,141,224,84,20,52,93,35,73,34,202,94,189,19,74,106,113,230,80,163,205,7,133,199,200,18,66,211,67,97,44,73,24,43,9,222,155,179,103,59,223,88,220,245,183,135,95,33,28,160,45,69,146,84,178,115,50,93,62,235,149,26,194,182,52,170,126,40,225,75,150,192,60,65,102,147,156,138,59,113,238,174,54,205,195,234,178,236,213,245,230,157,135,123,95,238,53,7,65,155,109,149,221,56,75,241,89,150,150,98,139,238,237,77,193,210,66,0,131,208,140,84,222,230,134,42,209,14,110,59,99,112,45,105,245,224,113,224,196,38,254,237,51,90,212,83,76,90,57,21,123,83,161,77,145,179,15,45,91,79,25,82,255,227,160,129,215,189,17,182,37,120,110,195,180,175,177,35,205,249,175,0,107,81,80,172,199,57,75,121,29,160,67,165,113,65,87,197,254,233,193,145,47,118,205,183,123,36,135,240,54,178,171,160,82,205,18,217,4,221,252,103,211,87,71,151,68,252,237,89,16,109,141,173,4,195,90,237,227,74,59,57,170,56,56,225,81,68,79,142,134,113,2,94,141,86,104,72,112,77,154,210,188,5,9,224,248,118,238,172,96,32,210,77,190,173,116,216,69,
55,24,150,252,31,11,37,241,209,205,59,2,135,132,86,89,163,212,245,82,117,100,220,133,24,196,243,99,122,31,41,48,226,220,83,156,124,189,168,42,28,102,58,195,35,213,96,133,150,126,102,115,41,17,75,191,166,198,39,87,125,109,200,176,124,143,54,89,65,110,85,40,182,11,151,85,66,160,93,104,89,199,214,19,5,200,147,40,149,90,246,117,178,10,196,244,247,40,131,248,140,8,253,135,1,215,158,225,27,229,251,76,69,56,103,62,204,164,248,250,109,4,162,122,92,95,100,170,35,202,236,23,229,0,95,214,113,13,113,98,46,64,99,30,0,238,185,10,142,58,203,30,104,152,71,150,8,127,131,17,2,32,2,186,108,147,108,19,1,211,119,234,214,163,11,186,61,67,35,234,105,106,34,140,215,152,251,162,246,116,182,142,251,197,185,53,106,79,81,201,255,36,148,144,192,140,28,27,242,139,41,146,65,133,117,45,227,29,39,211,128,81,15,16,202,176,50,190,121,72,6,236,224,18,115,251,65,121,189,107,7,226,80,58,123,203,109,192,83,201,120,148,195,148,132,97,207,174,116,212,57,236,89,140,173,185,140,134,211,37,30,162,146,133,112,112,76,50,
216,44,179,180,11,24,12,3,216,236,249,86,47,100,41,6,54,116,125,201,84,193,58,164,81,158,227,235,55,69,101,1,151,35,95,91,133,164,196,191,129,130,43,159,67,54,133,102,196,9,149,38,198,38,51,255,6,27,254,204,22,56,57,160,161,226,17,185,87,43,156,227,176,102,38,10,83,138,2,103,143,35,65,172,187,114,245,132,81,42,82,230,236,86,56,74,114,135,131,115,4,132,243,149,140,183,149,11,40,42,187,131,220,185,205,139,38,247,184,179,88,119,147,43,63,23,69,176,49,188,67,13,238,82,183,190,229,223,215,230,201,105,125,197,252,141,130,73,128,53,75,219,168,202,135,57,8,145,31,210,237,203,114,47,234,62,4,187,185,74,73,177,29,32,33,18,108,200,106,76,100,98,71,65,142,228,38,255,110,46,171,170,144,146,107,143,24,221,148,233,19,71,234,101,93,14,158,126,47,162,238,42,146,251,121,203,14,233,124,172,100,103,141,49,168,9,76,164,248,161,89,177,252,75,152,92,202,98,221,99,36,95,237,80,153,34,181,53,219,248,200,19,215,101,216,133,100,87,89,7,191,163,69,173,102,246,17,38,64,157,28,150,12,154,9,188,86,115,98,145,
220,132,97,255,116,155,149,68,115,192,58,81,19,134,158,24,28,43,135,177,23,157,47,56,215,173,201,155,136,212,196,241,200,189,195,152,212,96,213,253,23,10,219,213,14,135,70,33,26,125,110,198,200,90,9,122,178,153,90,54,250,195,245,200,119,38,8,145,115,158,139,35,217,111,228,206,146,45,169,184,77,153,56,137,190,74,48,71,146,178,101,142,38,33,72,206,239,114,153,23,138,159,41,150,226,95,148,141,204,68,204,111,42,114,168,188,128,76,111,71,160,150,28,178,94,137,27,30,136,0,230,212,39,5,149,82,31,36,76,169,140,176,94,59,60,65,40,139,204,200,218,55,58,178,224,28,118,248,30,205,109,105,179,228,248,162,17,84,243,35,25,135,75,20,65,215,50,105,51,143,108,218,195,40,173,242,111,127,112,114,161,239,184,186,155,41,97,44,137,86,212,131,146,6,140,175,148,208,211,96,240,113,5,58,91,218,21,97,171,105,135,61,86,108,147,203,206,239,170,138,64,109,229,229,144,194,0,49,165,140,233,119,13,9,22,255,210,9,40,137,9,37,165,226,170,75,136,174,161,132,230,54,77,11,129,218,9,46,184,67,88,177,172,22,41,155,205,
26,52,180,7,223,30,117,237,42,14,254,40,50,211,173,70,10,43,160,172,251,28,168,5,23,58,156,79,62,88,43,148,167,219,131,91,107,106,211,5,43,164,202,192,200,20,84,92,90,187,42,63,9,148,196,127,148,98,93,126,236,47,169,156,219,212,212,7,141,20,8,32,247,92,127,192,111,160,76,26,179,30,88,4,15,211,6,24,23,93,221,107,246,201,9,166,43,56,162,233,14,120,139,43,194,138,148,87,107,110,17,249,215,53,203,210,123,58,105,174,83,128,187,254,180,35,206,210,45,130,228,191,195,224,179,186,113,181,166,61,102,53,225,153,28,45,24,150,197,155,211,39,77,197,67,231,225,217,212,97,165,7,79,178,179,39,69,86,60,92,155,197,120,183,230,84,93,67,201,74,22,110,10,49,208,221,244,130,205,103,197,141,130,98,162,12,169,191,65,108,117,92,52,168,228,72,93,250,145,197,222,92,243,28,140,6,177,25,32,225,151,3,25,62,217,65,154,139,241,154,130,17,153,53,244,77,211,201,184,50,159,40,148,237,18,45,221,32,234,163,38,114,75,144,231,9,206,2,148,148,234,235,26,106,95,51,34,155,127,181,156,201,79,228,243,116,210,38,64,117,96,
205,243,52,209,0,160,70,90,139,131,153,142,169,0,74,146,46,155,38,88,45,101,188,90,142,20,159,167,34,41,15,56,46,89,99,72,222,107,45,148,143,155,114,115,121,21,78,249,3,10,10,44,115,68,147,106,237,158,99,80,179,251,28,53,98,130,196,240,219,196,195,210,64,37,79,220,155,170,105,86,95,32,142,82,101,44,27,236,32,230,53,39,117,108,78,70,81,89,73,242,38,12,49,45,210,209,228,108,99,64,60,73,125,50,102,191,66,132,194,116,41,142,136,250,235,186,66,160,240,132,83,58,41,217,120,161,84,99,94,229,93,83,212,128,139,220,97,194,138,215,46,141,38,67,37,98,228,26,50,194,166,192,217,129,67,109,89,37,69,98,69,13,19,184,96,21,149,185,173,82,216,226,198,147,76,195,52,30,74,49,11,220,139,41,56,107,40,164,215,67,49,94,148,38,181,156,105,243,98,191,226,186,135,48,2,181,64,73,208,105,184,168,137,194,206,21,195,34,152,9,153,216,98,51,107,190,192,91,39,16,191,103,118,176,88,218,9,33,173,207,217,208,62,136,128,33,215,68,234,96,205,209,220,138,80,242,43,220,254,169,56,137,203,239,48,175,89,29,194,165,65,65,
48,90,78,87,31,201,181,123,84,224,233,139,23,77,220,38,160,213,44,20,117,146,75,9,186,33,67,136,125,106,184,177,214,75,5,255,186,103,66,18,23,59,241,170,80,187,210,237,45,235,248,133,89,129,176,185,129,96,97,85,108,88,135,140,226,245,202,46,124,201,71,90,50,187,205,204,84,238,208,29,235,150,8,185,29,121,61,199,199,12,87,234,121,142,253,95,77,34,244,211,171,232,44,37,211,149,117,67,230,249,146,152,200,118,34,170,157,186,75,155,118,164,199,198,244,38,134,105,6,162,79,88,35,37,221,34,204,166,52,33,41,0,30,104,115,149,172,226,190,127,73,14,234,167,147,66,238,187,227,71,194,62,173,50,68,171,228,48,186,14,5,20,191,129,133,238,121,146,248,68,215,157,120,217,141,101,231,21,6,54,250,135,74,75,235,251,106,181,33,129,240,66,229,75,217,196,38,69,241,17,56,89,202,214,211,68,131,117,87,30,160,93,33,204,253,116,197,167,58,26,200,28,27,220,129,205,144,191,10,74,228,80,244,7,14,125,201,99,38,125,215,217,71,197,88,46,87,98,49,35,250,134,146,84,5,91,10,47,16,117,176,73,176,68,176,13,139,163,52,
33,121,83,164,206,54,199,206,91,237,172,204,227,122,138,94,62,199,65,4,148,225,98,101,221,103,175,57,129,36,106,0,109,247,118,251,54,12,49,69,215,10,105,241,23,146,154,168,136,10,138,253,215,71,196,20,220,244,29,106,186,178,110,67,192,214,186,49,0,9,231,214,5,92,52,167,216,146,227,156,54,45,91,100,23,8,45,69,205,46,182,126,173,81,6,156,76,52,107,21,223,54,18,129,8,54,172,187,255,234,240,76,60,248,215,253,239,246,107,149,104,44,40,239,239,52,214,21,36,36,213,52,130,116,46,117,29,124,45,211,32,220,130,24,128,95,17,176,37,127,33,193,34,107,128,207,172,1,55,199,148,89,114,43,82,144,37,181,212,70,173,111,49,126,217,223,72,170,41,218,194,116,74,73,31,83,207,70,52,105,37,91,20,173,137,45,194,41,152,114,41,28,93,238,115,219,85,152,138,100,30,66,205,214,168,6,30,175,211,229,62,113,70,11,110,245,153,173,116,111,204,56,40,45,68,208,221,130,36,137,94,226,75,33,31,63,234,178,51,155,34,58,98,46,59,34,249,89,216,201,41,153,23,109,88,2,173,184,52,175,207,110,216,13,194,151,11,207,67,35,243,188,
227,88,87,177,58,84,67,12,213,195,73,249,177,83,57,249,157,20,219,148,186,130,79,21,16,140,110,188,7,32,118,95,65,124,197,159,249,10,212,180,119,100,72,209,185,178,236,248,34,35,140,184,155,243,88,176,232,158,232,26,213,116,96,166,54,11,35,156,23,227,105,243,145,164,243,84,123,234,126,228,116,133,76,242,157,53,190,138,129,178,13,183,200,203,76,70,46,10,140,57,149,214,47,80,11,13,207,198,150,142,65,243,161,66,168,116,175,27,97,41,101,230,11,202,211,216,108,18,137,243,74,83,137,210,205,228,78,216,176,197,59,205,2,207,213,56,144,181,243,180,2,113,157,71,79,156,249,72,7,85,185,161,4,145,60,112,182,228,185,152,166,159,85,204,193,71,213,197,175,31,81,234,59,245,66,180,250,206,191,182,82,189,8,149,89,228,101,90,119,180,6,226,32,154,189,71,156,224,5,116,215,205,28,246,42,223,134,48,81,253,169,205,91,219,144,8,117,186,10,178,90,58,245,199,250,61,226,102,87,2,118,108,140,47,248,205,77,252,98,11,238,88,118,201,232,185,26,200,154,11,240,173,35,73,195,204,39,223,157,76,102,151,187,238,4,84,
62,0,207,197,53,152,120,238,104,2,82,157,13,133,191,68,85,118,132,22,203,28,223,34,72,189,8,158,39,74,16,21,158,8,115,228,83,103,2,35,62,210,231,113,42,95,41,167,189,50,153,96,176,150,117,235,17,175,100,149,16,105,169,136,236,246,106,202,9,220,128,227,204,5,2,42,202,200,135,162,177,48,249,229,212,36,76,189,78,132,47,69,9,132,136,103,97,89,234,160,57,200,161,107,66,226,26,9,30,81,66,224,176,12,60,156,145,230,223,73,1,228,207,116,253,36,78,151,118,34,96,136,136,177,87,72,39,23,1,241,105,115,82,60,35,239,218,1,51,81,206,59,99,208,228,71,219,230,183,174,120,193,192,140,223,181,238,121,137,159,31,221,113,217,75,124,163,235,102,1,16,247,171,23,161,56,160,9,157,140,49,223,73,224,100,184,124,122,180,31,191,28,202,56,121,182,87,209,51,113,136,114,158,20,174,248,131,28,113,73,22,35,17,209,237,151,150,64,138,164,204,194,121,90,95,223,130,246,98,194,48,142,59,150,2,6,130,74,136,244,71,159,108,94,74,42,43,134,241,44,139,71,92,75,174,83,48,148,52,242,65,97,86,181,136,229,65,159,122,38,4,13,
209,37,137,171,242,28,139,43,11,240,189,187,46,236,181,231,94,180,115,187,61,191,89,143,119,112,123,215,218,124,71,238,0,126,246,6,125,24,12,139,253,143,54,233,17,183,85,5,180,210,173,43,91,221,10,108,84,14,135,29,213,130,86,64,10,246,26,153,90,29,6,72,186,185,34,158,111,53,45,132,206,233,110,21,101,146,84,157,154,67,248,162,161,56,27,69,194,152,41,66,69,45,6,135,191,59,44,54,255,183,158,80,119,236,95,52,129,16,19,207,137,152,18,172,167,190,163,37,233,76,176,138,20,216,195,76,201,86,227,231,176,223,31,153,105,74,6,164,32,80,98,164,48,46,69,211,178,171,104,65,183,179,164,229,214,224,235,90,228,93,115,88,177,39,219,235,53,15,104,39,107,235,162,10,11,169,214,174,99,221,69,204,163,216,78,41,249,116,207,38,168,16,55,207,135,108,30,241,192,111,164,120,202,196,172,57,42,199,101,35,38,218,200,208,105,1,254,206,80,100,16,210,17,132,12,164,170,22,239,76,124,230,34,213,213,70,204,121,153,181,52,117,227,245,154,140,52,107,69,212,5,52,179,148,217,38,45,183,125,138,86,171,15,48,144,44,203,
114,198,205,238,58,227,72,107,70,21,69,109,171,170,72,154,200,146,197,16,108,200,74,158,250,170,93,58,118,84,163,254,174,226,160,185,30,68,56,213,165,169,15,31,51,245,77,65,10,39,225,77,20,150,166,117,28,169,70,5,164,62,68,136,19,162,100,69,255,67,113,199,143,207,186,93,187,35,8,47,188,215,30,83,206,45,9,53,154,109,105,149,139,75,242,44,193,213,156,214,71,54,249,51,67,111,42,125,73,166,20,107,40,42,211,111,205,94,37,55,40,57,165,165,13,234,243,155,121,144,80,86,7,161,75,149,118,249,125,102,119,200,100,62,54,138,8,90,72,139,152,208,190,152,181,62,205,92,167,185,53,241,44,209,136,79,62,245,65,207,104,229,119,38,197,132,82,195,215,22,9,142,99,62,113,211,254,32,106,67,34,141,76,95,58,112,40,164,218,172,201,190,45,88,112,203,162,222,154,36,108,15,74,110,197,136,100,50,21,56,146,88,132,11,115,100,64,116,217,81,132,106,86,117,60,0,118,141,233,88,5,119,119,203,196,159,97,23,52,200,226,155,249,144,84,247,229,209,25,189,79,14,184,113,152,239,96,50,189,9,141,85,103,176,240,117,98,197,161,
50,22,130,36,53,45,183,60,150,154,166,82,207,185,176,230,7,226,207,252,173,110,27,43,184,140,224,181,206,175,2,168,172,30,231,154,81,41,13,195,17,38,82,30,128,207,169,232,67,212,236,223,198,9,61,221,235,35,195,148,30,159,231,20,87,1,27,191,192,18,170,88,92,234,36,79,164,225,186,140,9,213,85,149,27,86,179,144,72,135,57,37,128,206,156,166,108,210,119,231,193,52,221,116,151,180,46,127,229,164,66,30,64,180,81,3,30,152,85,111,80,43,76,116,206,181,187,102,92,194,164,55,137,44,222,120,89,25,227,41,86,130,153,139,193,133,254,172,140,214,148,59,22,104,226,235,162,10,45,13,107,120,146,24,30,117,19,169,205,98,157,127,192,242,15,181,66,234,147,9,242,12,93,10,254,235,163,204,4,230,144,200,251,82,164,225,152,72,235,89,81,154,73,36,226,5,157,7,150,140,114,106,152,89,38,118,252,35,89,166,62,209,227,100,21,105,124,29,15,18,183,56,48,60,28,190,192,55,71,9,151,144,0,44,164,74,24,34,183,25,192,238,153,171,233,43,174,21,5,118,66,204,186,105,6,121,245,81,70,7,236,150,231,170,188,233,6,89,215,220,160,
175,3,164,54,232,200,225,217,243,195,226,244,248,217,217,219,253,147,195,226,232,180,120,125,114,252,221,209,211,195,167,156,132,58,229,103,126,167,243,219,163,179,231,199,111,206,10,158,56,217,127,117,246,125,113,252,172,216,127,245,125,241,219,163,87,79,183,139,195,223,189,62,57,60,61,45,142,79,138,163,151,175,95,28,29,242,217,209,171,131,23,111,158,30,189,250,182,120,194,123,175,142,145,242,35,100,157,69,207,142,11,109,152,150,58,58,228,189,103,197,203,195,147,131,231,172,188,255,228,232,197,209,217,247,220,236,115,116,246,74,107,62,99,209,253,226,245,254,201,217,209,193,155,23,251,39,197,235,55,39,175,143,79,15,217,254,41,203,190,58,122,245,236,132,93,14,95,30,190,58,187,207,174,124,86,28,126,199,15,197,233,243,125,138,131,218,106,255,13,208,159,24,190,131,227,215,223,159,28,125,251,252,172,120,126,252,226,233,33,31,62,57,4,178,253,39,47,14,99,43,144,58,120,177,127,244,114,187,120,186,255,114,255,91,65,119,82,28,179,202,137,31,75,208,189,125,126,232,143,216,111,159,127,15,
206,142,142,95,9,141,131,227,87,103,39,252,184,13,150,39,103,245,171,111,143,78,15,57,217,118,114,116,42,130,60,59,57,102,121,145,147,55,68,179,87,122,239,213,97,172,34,82,27,234,154,35,60,34,44,222,128,116,13,203,211,195,253,23,172,5,123,94,173,60,12,55,117,31,234,191,255,219,47,126,241,203,79,252,231,23,221,63,29,5,58,10,116,20,232,40,208,81,224,239,158,2,159,228,52,255,238,169,212,17,224,47,69,129,79,146,199,95,254,165,160,249,203,239,243,105,248,127,234,83,127,121,248,127,22,59,254,8,121,127,22,56,118,72,116,20,248,27,167,192,255,224,159,191,113,20,126,230,224,139,67,119,255,243,51,71,188,67,175,163,64,71,129,142,2,29,5,62,3,5,126,36,28,255,248,215,159,97,239,110,137,142,2,29,5,126,102,20,248,184,197,248,41,223,252,204,136,210,161,211,81,160,163,192,79,165,192,79,49,24,159,244,236,79,5,224,111,236,249,159,113,233,254,111,140,19,29,184,29,5,58,10,116,20,232,40,208,81,160,163,192,95,17,5,212,48,249,43,2,231,51,128,242,177,192,247,51,44,221,45,209,166,192,207,79,116,218,216,
253,249,191,223,33,100,127,254,133,238,219,142,2,29,5,58,10,116,20,232,40,208,81,224,167,82,224,14,119,251,177,143,126,234,210,221,243,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,63,19,10,220,21,32,254,76,80,235,208,248,79,80,224,231,87,182,188,75,210,63,223,103,255,9,82,119,175,118,20,248,111,166,192,207,79,219,255,155,9,218,109,255,169,20,232,68,239,83,41,245,87,243,220,167,123,205,191,26,144,63,27,32,221,176,228,103,35,101,183,80,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,71,129,142,2,29,5,50,5,62,189,13,221,126,50,191,253,87,249,103,27,208,31,253,251,95,37,6,63,1,168,31,69,176,126,224,39,44,218,61,250,163,20,168,201,154,254,242,163,47,116,15,116,20,248,123,167,192,186,210,124,252,231,191,119,74,117,248,119,20,232,40,208,81,160,163,192,103,162,192,199,93,77,251,155,207,180,89,183,76,71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,64,
71,129,142,2,29,5,58,10,116,20,232,40,208,81,160,163,192,223,2,5,218,133,161,79,255,251,127,17,102,221,145,233,255,34,194,118,203,118,20,232,40,240,89,41,240,233,198,178,121,242,179,2,208,45,214,81,160,163,192,127,132,2,141,66,234,111,255,145,21,186,119,58,10,116,20,232,40,80,83,224,151,191,252,255,2,0,0,0,255,255,3,0,33,85,184,202);



//additional program support files ---------------------------------------------
programfile__JoanOfArc_mid
:array[0..5318] of byte=(
120,1,237,92,235,83,91,103,122,127,125,86,149,41,161,12,75,25,143,87,165,50,162,154,131,70,32,144,53,172,44,8,57,243,86,32,46,90,153,139,67,165,24,33,144,101,140,0,155,93,156,177,98,79,6,229,140,36,228,38,37,245,76,241,193,83,143,103,210,153,126,238,135,236,125,179,155,205,110,239,247,246,115,63,245,15,232,244,111,112,127,239,77,55,46,193,235,116,147,108,228,124,120,206,251,220,47,239,251,156,231,188,16,174,46,110,172,17,66,236,228,28,249,58,249,229,213,197,55,111,19,162,181,147,231,11,95,107,25,248,75,242,252,13,155,77,187,216,66,158,155,165,111,190,30,89,184,12,206,230,191,207,54,3,231,184,58,27,105,33,26,249,109,226,37,59,88,159,195,127,132,216,128,57,253,191,85,226,70,229,126,135,124,141,80,242,45,146,38,211,88,169,127,237,228,194,185,115,175,160,114,45,127,120,245,245,25,142,21,69,125,78,159,219,207,247,136,127,164,250,248,23,199,163,201,243,33,34,118,5,9,21,210,31,98,115,244,16,237,151,191,165,125,120,222,212,90,189,218,43,166,150,156,212,82,102,113,254,22,209,214,136,102,215,52,246,160,105,118,
170,221,50,181,53,179,78,126,231,187,66,254,175,127,95,251,238,249,85,173,245,13,46,111,158,85,190,56,255,99,33,255,143,126,237,199,231,215,148,252,154,150,154,60,147,253,98,250,39,66,254,159,156,218,79,206,127,91,107,245,188,152,253,18,249,169,144,255,151,175,107,63,101,246,125,92,62,160,165,230,207,100,191,212,243,177,144,255,55,67,251,152,229,47,205,229,151,180,212,216,217,228,253,63,23,242,255,254,13,237,231,76,94,248,143,248,191,113,54,249,249,95,8,249,255,252,61,237,23,76,94,228,31,246,207,84,191,237,18,253,68,200,255,199,176,246,9,203,95,69,254,74,209,243,65,248,170,231,147,19,54,193,159,209,15,198,175,218,31,133,105,137,124,16,14,119,60,26,167,159,188,243,65,116,124,207,120,20,165,218,7,83,227,43,143,166,0,35,211,7,233,71,17,74,194,180,102,211,252,119,169,227,103,194,232,191,158,211,126,198,156,30,84,73,39,39,6,93,252,43,219,179,145,12,9,172,146,224,117,162,155,239,5,246,3,180,35,72,109,35,180,176,165,211,249,103,70,134,188,186,64,174,220,32,253,119,222,117,239,27,180,253,85,218,122,133,22,108,
253,180,72,185,96,134,4,147,68,207,236,13,64,176,125,132,218,131,244,142,78,23,159,209,12,25,217,37,175,101,136,111,119,143,238,83,218,49,66,181,215,104,218,71,103,159,5,214,72,48,77,70,238,17,253,206,222,46,164,58,131,180,117,132,166,117,218,242,236,181,21,38,69,87,137,47,83,14,237,67,196,199,164,236,180,38,76,91,107,145,124,79,132,249,55,46,237,123,108,111,25,42,204,165,19,195,252,223,174,3,61,183,127,167,168,211,174,131,75,185,135,196,149,107,43,94,162,197,123,7,122,190,173,232,162,143,16,107,235,193,165,109,70,176,49,194,142,139,182,29,232,102,137,64,130,28,92,50,203,239,0,171,29,184,242,15,145,36,13,18,229,93,29,235,75,38,91,183,128,86,126,192,24,93,185,242,14,136,29,7,142,220,254,114,209,65,221,159,151,213,187,251,187,240,188,229,224,210,230,190,240,92,223,44,191,13,140,237,192,101,150,239,193,69,59,162,227,152,22,134,201,0,211,3,140,202,16,194,114,153,42,67,120,168,100,232,62,35,156,154,33,158,145,83,50,100,170,12,153,42,67,144,224,89,174,73,222,123,105,151,217,5,171,221,112,206,9,216,9,232,6,
28,3,28,67,94,219,92,244,226,129,99,99,16,143,129,3,199,150,23,48,120,224,88,243,3,250,129,31,0,28,62,112,172,75,250,77,9,87,37,76,5,64,31,60,112,172,74,168,248,148,190,109,169,39,215,8,165,188,25,132,188,23,197,247,163,240,126,192,65,192,0,96,0,112,240,24,168,232,3,160,15,87,248,93,208,227,130,30,23,244,184,160,167,178,206,27,88,247,30,56,160,151,199,103,122,0,67,53,235,97,172,7,176,150,113,231,36,188,45,227,222,146,80,173,111,75,61,219,18,42,250,150,140,79,209,213,122,93,226,215,69,156,142,45,105,239,182,196,155,6,236,51,255,62,79,251,213,198,103,115,21,59,190,47,58,194,223,250,181,239,179,142,32,186,253,252,105,111,139,255,153,120,236,75,20,60,37,31,117,62,142,36,108,70,194,30,78,236,7,74,232,168,17,234,121,60,149,176,143,39,202,19,37,131,106,227,212,54,69,7,31,211,132,109,38,97,139,36,138,177,210,12,181,69,104,43,165,250,99,131,97,32,248,40,12,65,45,66,237,6,245,2,9,89,219,84,162,60,8,113,251,56,181,79,209,81,38,14,43,51,137,226,112,137,210,150,8,109,153,161,99,204,110,56,97,143,38,138,204,110,107,
148,182,70,104,224,49,100,163,92,124,186,52,78,181,41,106,139,82,55,227,140,37,236,51,137,242,104,41,70,91,103,168,61,66,135,25,114,150,137,151,253,165,40,181,205,210,54,134,172,136,15,150,166,40,25,167,109,81,58,253,120,129,25,130,218,178,7,134,160,208,185,64,59,33,222,134,136,104,162,28,128,75,208,9,255,13,225,146,45,144,216,95,19,17,217,2,194,250,87,54,63,49,150,31,158,243,154,252,24,213,252,24,244,67,94,158,102,130,106,55,80,93,130,156,167,237,191,19,242,251,231,45,56,60,108,190,193,148,243,248,213,4,49,18,228,74,162,28,44,189,74,181,43,180,221,224,39,138,188,150,32,35,137,226,5,108,95,76,9,206,17,234,120,28,230,156,35,137,103,97,136,183,134,105,203,72,205,232,208,146,43,246,252,64,52,138,191,251,166,246,3,54,33,137,177,28,99,221,201,19,210,251,23,172,145,155,222,189,17,26,180,140,180,123,207,160,99,150,145,97,112,212,162,25,125,143,114,56,8,56,104,133,111,110,236,133,233,162,53,178,125,7,252,139,150,177,162,11,254,155,126,192,160,21,89,14,238,69,168,110,133,215,246,86,192,248,39,110,203,72,122,64,
241,91,225,215,227,64,24,214,248,178,177,55,78,163,86,56,238,199,154,194,66,129,66,117,97,216,26,191,145,1,197,128,142,73,232,192,250,122,16,235,32,56,211,224,212,45,186,220,5,70,104,204,149,67,80,249,199,3,150,145,96,86,7,172,104,198,187,23,133,68,116,121,80,192,228,128,92,123,0,13,208,117,177,190,206,32,214,203,12,31,180,162,127,36,228,102,54,188,123,51,204,251,149,52,44,175,89,145,237,29,192,226,5,43,114,83,231,174,68,50,189,128,99,150,128,97,224,221,88,195,213,155,12,63,10,232,225,124,227,249,105,184,252,0,225,15,194,229,144,53,158,143,99,157,198,218,205,131,53,242,5,2,143,199,44,122,139,229,53,100,25,16,52,0,195,55,75,1,112,60,12,89,145,180,1,85,30,107,252,214,155,16,157,128,104,161,13,148,32,194,103,37,64,137,114,229,7,144,41,101,172,17,179,7,69,136,2,51,12,132,7,144,21,35,96,209,52,227,12,89,20,222,83,24,11,111,221,131,134,176,21,222,8,1,162,136,235,5,59,30,188,214,120,102,18,54,220,96,96,198,135,45,99,187,212,14,13,251,15,80,223,81,168,134,202,237,1,32,252,80,237,5,196,126,184,229,133,74,152,
216,102,170,13,168,218,129,228,164,21,190,207,52,64,245,86,193,134,7,148,121,187,208,5,221,168,251,237,66,11,48,120,184,185,6,168,161,224,105,136,106,150,145,47,190,3,157,239,217,173,232,45,86,14,148,111,155,149,3,101,225,229,12,201,53,240,55,89,57,253,86,52,23,0,244,2,239,175,225,31,3,157,173,189,214,204,237,49,148,209,131,242,33,203,188,60,185,98,39,30,222,182,34,57,86,39,36,151,67,212,109,155,213,15,107,148,65,212,79,214,19,97,69,224,193,120,126,5,206,47,33,28,86,199,49,107,220,220,194,122,22,25,212,177,158,182,12,243,77,184,142,12,223,26,64,44,163,50,243,200,244,253,194,36,24,222,237,134,133,16,52,33,197,102,65,131,40,42,124,191,112,1,164,97,139,230,153,12,234,104,22,55,160,228,225,26,146,61,134,100,35,201,38,219,206,12,178,100,163,226,121,150,108,86,71,15,135,225,237,119,160,161,224,134,128,7,2,76,5,43,60,171,78,24,176,7,85,241,131,113,128,229,188,11,156,127,138,45,114,211,0,167,23,201,30,4,7,42,156,103,91,4,117,196,6,230,231,250,86,175,80,125,155,5,54,106,133,111,244,2,162,158,91,108,141,179,199,
19,80,232,70,70,150,17,6,118,242,118,6,132,21,152,46,48,39,223,111,181,70,50,221,48,49,141,234,176,195,55,136,106,176,106,82,28,178,30,192,176,21,77,51,136,67,135,179,194,215,56,75,156,174,32,90,79,20,91,106,6,213,103,135,112,230,254,18,96,26,103,234,109,100,176,136,211,8,159,249,225,75,179,34,78,128,208,3,200,14,31,131,88,99,111,178,34,142,155,97,184,248,22,124,246,192,69,108,65,51,134,245,22,178,193,14,95,24,46,175,193,227,121,20,141,197,78,177,183,123,177,102,199,163,48,12,134,119,217,118,96,69,211,177,121,153,166,183,17,210,58,92,219,223,181,34,139,1,16,10,237,214,248,202,48,40,133,54,36,138,25,41,188,105,69,174,15,48,82,135,21,73,50,55,209,27,174,177,94,128,179,191,210,11,86,164,116,149,153,47,64,27,100,163,76,54,138,166,201,50,50,179,26,64,164,133,11,214,84,178,119,111,138,22,46,202,7,228,108,217,205,88,59,192,202,30,38,173,104,82,28,141,25,212,103,6,70,166,160,28,18,239,88,51,8,22,58,218,209,53,157,48,59,13,232,0,68,86,86,186,5,92,102,89,43,56,209,88,6,241,48,106,77,101,252,76,180,5,209,50,68,
113,30,149,97,142,161,2,203,126,232,194,57,155,216,192,186,180,104,77,161,116,83,112,52,138,140,49,135,99,219,142,189,24,188,153,189,237,220,155,101,214,99,56,63,49,90,194,251,194,100,125,98,20,25,147,71,24,107,118,164,99,168,93,12,248,89,51,192,36,218,173,217,251,58,30,128,184,239,103,136,14,107,46,63,188,55,135,61,59,107,122,128,8,1,226,192,204,50,99,80,21,195,126,136,154,105,168,122,159,224,72,141,194,95,29,8,101,131,109,36,48,194,187,24,234,24,219,238,1,164,214,236,214,24,83,109,131,13,47,30,130,214,44,118,22,16,23,96,107,17,182,238,192,70,12,136,123,208,20,99,170,217,3,219,163,216,179,121,9,77,22,48,58,75,94,66,83,152,138,42,188,233,4,29,117,82,114,146,30,3,63,119,197,100,97,23,28,86,140,63,20,151,224,75,15,76,194,185,35,144,165,50,12,188,132,183,37,223,150,132,183,123,65,55,64,167,128,5,98,205,153,65,196,224,5,66,16,162,102,20,174,188,5,75,78,152,100,46,93,196,122,154,229,177,13,18,239,46,90,11,153,225,189,5,100,120,46,143,204,206,49,93,91,232,255,172,8,177,188,7,50,104,180,185,2,219,145,15,177,
71,81,133,40,48,49,115,26,148,7,208,82,98,172,229,183,173,5,28,239,5,90,232,68,93,66,44,182,22,240,206,130,183,250,149,210,57,88,244,255,80,12,31,127,255,138,246,67,54,124,196,213,157,86,224,196,123,139,181,195,76,106,190,156,161,29,135,241,212,112,57,78,7,14,231,0,177,35,176,158,198,250,226,97,18,244,36,232,115,41,63,240,126,224,41,240,61,135,169,84,176,156,162,94,208,3,160,15,2,31,2,222,131,245,48,214,3,160,143,129,238,6,222,0,190,23,120,55,240,109,192,15,0,111,3,62,157,73,117,130,20,204,192,202,23,195,139,36,98,74,34,166,120,42,10,199,46,192,215,16,124,101,49,197,129,111,61,204,166,38,203,89,234,0,125,17,244,54,224,175,1,223,14,239,41,114,216,3,252,36,240,14,224,99,192,119,213,228,192,159,76,105,32,117,39,105,39,176,20,90,123,192,21,6,151,19,210,179,144,238,172,88,85,94,164,128,79,1,63,151,90,70,230,109,21,254,56,214,113,172,83,168,76,138,87,38,29,79,217,192,178,28,167,4,218,222,128,182,22,112,59,161,61,140,117,12,235,46,172,167,177,190,8,169,73,72,57,128,135,148,29,164,184,208,53,13,236,69,68,56,
143,8,59,192,149,94,79,181,1,69,215,121,28,75,120,180,67,102,25,2,204,178,136,64,229,65,85,47,137,188,136,26,79,128,191,27,252,215,192,223,142,8,210,112,143,32,194,244,2,60,141,211,197,5,238,161,200,42,176,41,216,138,211,16,147,73,194,191,36,207,241,10,80,26,214,130,107,14,186,230,160,43,158,18,248,234,254,82,181,192,126,178,67,52,198,44,166,82,194,3,229,145,202,66,28,57,143,35,231,73,236,230,36,118,179,210,50,135,136,230,80,147,133,212,104,121,129,234,160,79,128,222,13,107,215,192,207,244,141,34,34,134,87,59,68,84,58,131,221,157,193,238,86,25,248,124,79,81,213,187,47,241,254,205,202,126,148,149,253,8,144,247,163,172,236,71,160,243,126,148,149,253,40,43,251,81,86,246,163,172,236,71,89,217,143,32,207,251,81,86,246,163,172,236,71,89,217,143,178,178,31,101,211,153,108,165,31,37,161,141,119,130,172,204,36,180,241,78,144,21,187,49,155,149,157,32,43,119,95,86,118,2,120,195,59,1,232,188,19,100,101,39,168,88,247,39,179,213,78,0,110,222,9,178,178,19,100,101,39,144,86,149,23,41,224,121,39,200,202,78,32,249,227,
88,243,211,139,156,240,78,144,77,199,179,213,78,144,149,157,32,43,59,1,124,225,157,0,153,228,157,0,62,242,78,192,164,170,157,0,84,222,9,160,147,119,130,108,122,61,91,237,4,89,217,9,96,153,119,2,25,65,92,230,33,35,171,151,196,154,119,130,172,236,4,200,15,239,4,89,217,9,178,233,5,120,170,58,129,204,106,60,155,78,193,150,234,4,240,143,119,130,172,236,4,146,107,14,186,120,39,144,248,84,37,183,170,22,168,100,181,19,72,15,148,71,25,153,133,56,114,200,59,1,246,17,239,4,82,203,28,34,226,157,32,43,59,1,228,121,39,128,85,222,9,128,231,157,160,178,67,100,39,192,190,226,157,64,102,32,222,220,191,135,47,187,127,155,157,32,222,236,4,108,38,104,118,2,54,133,126,101,223,100,169,188,27,61,119,236,48,149,119,2,134,1,135,1,7,14,147,121,209,187,151,118,131,229,37,252,64,25,4,246,154,46,180,224,161,23,15,6,160,156,10,20,103,126,148,113,174,31,102,118,89,115,217,57,204,228,38,0,187,15,111,228,227,229,27,116,235,112,53,127,173,188,74,191,13,56,1,136,17,54,23,5,253,173,195,204,182,19,16,227,116,110,17,176,237,240,70,46,6,254,
46,240,69,193,87,136,67,193,10,16,25,88,244,194,114,16,208,3,24,170,129,236,77,184,139,181,152,67,86,243,5,47,36,241,145,145,47,56,64,97,62,229,195,208,237,132,170,0,84,13,98,189,119,17,8,207,225,42,156,228,206,236,250,177,246,31,174,229,7,203,107,52,112,184,158,47,108,148,215,97,100,45,95,240,3,211,129,57,212,3,142,22,32,252,153,237,86,160,240,117,133,111,181,93,54,227,12,31,170,183,115,243,221,116,225,165,223,77,205,217,10,95,69,205,217,138,29,224,47,223,183,65,229,55,201,126,119,180,72,127,36,110,141,254,65,215,126,196,110,141,40,191,53,114,158,246,179,237,143,23,159,244,103,220,15,251,233,24,96,15,32,5,236,5,52,158,244,47,73,168,240,75,146,94,129,130,238,187,235,126,232,131,188,239,110,47,160,1,40,215,155,18,102,116,224,71,159,248,42,208,131,117,168,178,214,51,222,135,58,13,62,209,51,30,192,208,19,253,174,90,187,177,30,123,162,67,15,135,208,91,15,5,127,255,166,23,254,6,171,113,128,191,46,158,77,39,214,225,39,253,21,232,192,122,18,235,139,128,211,79,244,156,19,122,195,176,219,13,56,1,232,0,156,4,94,
66,133,223,148,244,140,194,11,232,131,188,15,242,62,240,249,32,239,131,188,15,242,190,156,92,43,88,161,43,126,145,31,125,83,198,141,188,234,200,191,126,87,7,28,69,220,189,128,70,53,126,212,69,172,37,68,190,249,90,229,37,167,242,35,229,239,74,125,57,193,231,2,191,11,250,92,208,239,130,126,23,248,241,123,50,136,83,233,145,121,80,249,80,176,98,71,241,73,184,89,175,95,207,169,181,242,67,242,41,191,20,84,250,164,221,254,77,29,117,24,125,210,127,77,214,73,237,63,181,239,84,221,50,138,46,247,161,196,251,160,135,239,59,172,235,234,32,235,82,201,227,93,25,159,170,99,99,190,85,126,97,87,212,65,193,134,184,149,255,13,249,213,21,94,229,65,217,171,192,6,125,146,175,127,73,198,223,24,247,53,117,30,27,207,157,92,75,186,15,122,124,216,55,213,243,167,206,161,192,7,80,239,0,242,27,128,127,1,212,63,0,127,2,216,175,1,228,139,193,230,249,111,158,127,209,71,154,231,159,231,161,121,254,209,143,155,239,255,230,251,95,245,197,19,222,127,95,144,247,255,203,206,15,58,230,15,62,111,97,254,224,115,96,227,28,128,247,164,192,43,40,
223,227,18,239,131,60,159,111,33,207,231,15,200,243,121,4,125,132,191,151,213,92,130,249,69,208,235,241,47,59,127,85,230,31,53,7,96,206,170,155,199,213,90,65,204,1,220,63,57,55,189,172,253,138,188,154,123,142,204,121,114,30,60,130,23,251,234,101,235,87,137,95,229,89,205,217,205,249,143,239,191,230,252,215,252,254,99,115,205,241,223,127,133,238,223,252,15,95,52,58,23,109,151,31,188,109,128,234,3,56,4,188,7,31,192,131,104,240,1,228,161,225,2,226,238,0,240,195,184,152,144,244,77,185,86,23,20,71,160,226,147,122,212,139,69,125,208,87,96,125,67,236,135,253,126,216,239,71,131,228,23,23,240,143,127,16,195,159,126,92,136,244,231,20,84,116,121,49,35,249,124,57,47,14,122,16,23,14,242,98,69,125,16,171,6,127,87,249,165,46,6,228,5,139,138,247,154,244,7,23,65,252,130,69,65,117,177,160,46,96,212,139,81,197,117,77,234,83,252,138,190,164,244,200,193,65,93,100,68,21,94,189,64,213,139,87,225,27,224,175,197,126,245,247,174,254,32,87,220,249,72,220,160,253,51,209,62,170,222,160,177,95,250,214,158,122,151,218,222,243,226,247,
171,213,131,246,209,9,255,99,158,251,169,219,36,222,7,140,155,184,233,226,83,239,13,246,8,184,73,250,76,246,232,238,163,254,167,222,235,114,21,236,163,78,46,177,89,149,224,143,53,18,180,143,118,61,245,238,8,61,76,251,49,188,74,159,179,143,6,171,182,2,125,180,151,107,231,194,194,31,169,199,187,35,61,24,237,163,142,167,194,225,197,70,222,235,210,247,7,164,111,131,61,246,246,209,0,120,27,125,63,37,90,163,143,94,128,63,199,250,174,50,115,67,234,171,215,238,239,163,34,151,53,209,42,9,149,203,112,31,237,172,211,126,138,39,95,166,188,207,53,243,254,185,236,247,102,222,63,159,62,211,204,123,51,239,199,189,43,155,253,253,164,41,162,249,94,85,153,121,145,121,166,217,103,154,125,230,75,222,103,116,204,255,98,154,215,49,31,235,248,164,16,16,88,57,70,19,220,103,178,153,158,113,138,121,24,127,104,163,113,178,151,39,161,158,167,246,43,224,232,36,205,120,197,44,206,244,157,62,211,51,94,62,172,195,25,240,114,101,194,135,234,52,223,192,35,191,17,234,173,28,255,45,85,207,227,149,95,41,199,127,25,233,247,235,188,150,221,
226,4,94,120,205,149,9,175,165,71,140,87,100,156,125,207,49,219,42,255,136,76,234,99,216,102,174,27,234,242,242,185,70,237,84,174,27,246,58,251,64,226,85,58,83,230,161,167,90,157,218,221,248,27,179,203,177,255,106,206,230,233,153,71,54,190,32,187,188,254,108,214,156,55,17,75,237,253,9,59,199,159,214,81,212,93,75,195,62,172,209,251,169,245,62,189,151,156,33,203,13,182,165,190,218,110,41,118,116,99,47,121,153,253,205,110,100,154,247,51,234,4,240,93,35,107,94,185,103,251,108,239,197,154,115,100,229,205,119,252,155,244,236,121,103,231,229,132,30,255,171,206,51,242,48,224,245,80,127,163,88,185,107,61,161,11,84,237,157,225,235,138,249,173,46,46,143,88,58,230,238,146,243,87,222,90,149,219,96,254,133,91,223,51,88,70,63,213,195,51,223,102,242,249,167,26,217,25,238,146,153,55,234,58,25,145,125,234,201,97,252,170,130,108,34,146,198,94,108,6,109,214,172,102,166,230,251,225,255,183,102,120,155,170,154,53,188,121,170,118,207,94,65,104,83,175,160,35,103,225,171,121,234,112,38,212,15,41,144,145,179,156,58,228,240,75,
113,234,224,103,77,100,103,233,148,144,120,145,78,89,55,197,85,119,227,25,238,2,27,206,205,217,123,228,153,171,197,45,84,187,184,42,216,11,245,200,207,224,188,193,223,95,233,188,53,107,247,235,172,221,20,209,211,213,54,203,127,250,234,14,19,125,134,120,231,200,208,21,233,9,208,206,33,252,204,214,61,65,244,121,86,214,161,112,149,210,61,68,67,79,221,208,243,6,167,140,158,72,137,54,82,102,184,182,27,100,232,8,229,42,167,108,30,67,249,22,183,3,74,141,7,194,183,138,204,181,170,157,158,33,58,252,212,189,193,101,96,231,8,229,59,60,122,80,212,87,91,37,210,89,21,79,13,69,104,155,39,250,6,107,47,181,50,130,146,62,70,91,173,7,245,50,194,107,120,128,188,29,71,129,182,239,240,140,30,241,224,254,137,118,68,60,245,218,132,7,144,129,182,235,100,72,124,181,226,15,188,186,169,160,84,60,168,161,136,154,66,230,72,164,21,10,180,193,206,113,50,160,236,212,101,71,68,138,42,28,145,233,29,194,207,234,221,21,59,53,218,42,94,243,87,206,209,92,139,120,234,61,16,118,4,101,135,92,198,54,61,46,117,80,8,247,106,76,85,10,33,28,175,161,
84,138,199,123,89,173,140,160,152,248,131,185,66,27,233,175,17,235,28,162,173,248,181,152,167,94,254,9,102,187,76,231,171,191,143,112,177,143,142,177,29,201,122,35,255,85,11,212,193,211,71,7,4,142,239,220,218,27,133,202,107,140,79,235,149,47,116,86,150,163,188,234,5,214,211,199,118,61,162,169,177,225,237,163,94,150,233,227,228,212,171,178,222,6,120,143,78,248,21,127,132,13,248,161,94,47,149,56,208,78,106,124,227,143,236,38,86,134,203,39,45,49,214,225,174,181,222,31,197,171,84,10,27,140,167,154,171,129,62,234,17,247,196,85,92,251,127,17,239,123,125,180,91,220,123,146,161,235,164,95,21,222,209,79,91,216,30,147,117,194,159,126,86,148,174,126,106,31,162,163,226,6,154,92,190,135,45,81,45,162,147,19,75,244,50,255,163,71,255,7,66,231,122,125);


programfile__Titanic_mid
:array[0..17454] of byte=(
120,1,237,189,91,112,27,89,154,38,246,31,220,8,32,41,138,18,41,9,186,177,72,129,164,72,137,23,144,4,65,128,9,48,19,23,2,4,1,130,0,193,59,69,10,164,68,137,172,146,68,149,168,123,149,74,78,80,84,169,197,222,181,90,26,169,171,103,214,27,222,13,59,194,126,235,157,234,170,238,218,153,221,24,175,237,221,181,215,187,47,94,191,248,193,177,17,29,81,118,76,248,101,159,236,23,187,252,157,147,0,8,168,116,173,173,222,233,30,183,30,64,37,50,243,156,255,250,253,255,249,207,159,137,177,201,181,243,68,100,33,70,117,236,63,25,155,188,246,17,142,14,211,119,179,38,147,193,97,165,239,230,12,56,254,46,99,180,157,252,43,250,174,155,244,11,14,252,159,244,93,19,195,247,70,219,240,165,198,244,250,242,149,141,94,173,250,151,119,72,187,249,87,102,246,203,170,243,100,239,176,45,204,155,22,163,54,233,126,254,195,243,100,92,37,163,197,240,179,251,79,122,20,82,229,224,47,213,251,119,159,196,162,38,175,162,13,37,7,204,129,128,197,75,119,146,20,240,14,80,82,53,5,168,57,70,218,62,47,217,3,62,109,32,54,102,243,14,24,2,164,169,94,162,128,
220,217,67,82,128,242,53,42,117,199,136,84,95,85,119,228,244,47,85,170,125,146,36,205,228,241,154,98,161,102,140,174,29,120,146,84,12,30,98,114,248,90,146,164,24,13,121,2,44,57,96,146,49,140,28,217,235,33,237,68,44,42,201,100,240,4,181,97,57,97,244,80,91,55,29,197,217,86,149,46,199,232,68,103,132,169,178,5,227,90,249,184,93,238,184,57,166,74,124,92,215,147,100,200,228,83,63,112,83,117,140,206,37,201,229,35,114,39,40,25,210,66,62,197,225,38,237,104,44,90,227,14,91,125,164,249,125,97,124,177,183,147,28,62,202,31,82,233,131,238,72,85,140,152,170,24,48,174,129,143,219,235,9,216,99,106,21,31,183,253,137,135,170,228,152,49,57,20,141,81,40,73,253,30,159,33,25,97,160,40,44,199,172,160,183,61,214,103,148,201,234,137,105,33,57,246,1,70,200,251,158,200,24,141,246,129,203,110,50,37,233,144,42,83,143,98,137,145,252,58,241,38,85,242,14,252,193,137,55,25,130,132,255,230,197,187,215,51,64,109,129,154,24,89,185,190,78,61,241,14,192,148,18,228,30,212,84,117,112,213,77,27,80,210,113,47,237,117,187,201,211,97,131,130,194,
208,207,117,57,150,95,109,163,125,110,130,137,145,76,85,238,62,82,194,228,105,32,12,66,79,228,184,5,138,116,41,100,145,41,228,33,131,28,38,53,48,35,211,186,28,155,148,41,223,33,71,52,213,211,186,15,131,181,98,48,205,38,43,90,173,155,28,24,74,229,163,57,220,62,82,20,173,31,99,73,79,124,178,86,173,144,91,29,36,185,87,115,170,116,92,13,239,241,209,126,220,214,228,83,180,62,31,237,145,123,52,213,231,185,238,166,164,219,207,125,102,245,137,138,33,196,64,176,98,53,70,238,208,101,12,149,125,226,109,6,107,161,131,42,93,244,210,17,55,181,171,253,48,61,77,82,169,183,187,151,148,94,35,238,213,2,79,250,156,218,65,92,126,234,137,167,83,227,6,217,244,68,118,107,221,221,100,87,168,74,237,37,119,184,74,38,115,31,85,67,46,109,94,159,31,151,106,166,39,242,208,130,74,203,50,153,212,254,118,47,157,83,201,45,199,72,141,120,221,220,251,46,123,135,52,191,151,76,50,254,224,18,183,90,199,103,50,130,204,83,16,190,34,239,129,127,245,201,137,54,12,117,227,137,66,78,117,64,171,83,169,83,13,107,14,153,236,152,103,73,142,247,224,142,
189,30,25,190,173,245,203,234,34,6,72,64,116,66,100,113,234,28,158,193,189,235,79,124,190,60,184,233,247,1,63,6,72,13,31,226,211,120,212,251,211,79,124,180,232,27,208,62,80,233,83,31,173,170,10,249,228,19,56,87,251,164,147,180,154,206,62,225,169,112,59,95,74,165,14,153,162,129,174,235,1,0,86,76,179,169,52,48,60,173,185,134,169,54,182,164,121,113,139,245,73,60,2,87,204,135,59,201,228,163,190,182,0,121,6,184,180,140,79,226,164,157,228,182,227,134,162,18,239,101,59,184,157,155,12,183,30,216,144,187,175,210,118,212,0,201,225,247,176,29,5,198,226,251,145,108,199,29,130,249,252,255,206,118,212,48,249,6,94,99,59,62,153,84,229,101,219,201,87,61,81,233,225,135,48,143,124,6,38,197,13,67,13,81,36,68,129,208,78,103,128,16,123,246,70,232,184,28,51,41,136,1,177,199,87,20,58,4,51,182,4,98,76,141,48,95,196,20,162,199,231,2,116,200,71,99,176,191,80,220,168,4,152,172,238,196,225,42,10,177,16,13,167,227,166,100,134,197,101,99,96,96,59,154,38,41,78,85,73,58,156,138,153,19,241,252,237,20,177,4,153,147,137,234,120,48,63,18,
39,75,146,204,1,170,73,249,88,76,177,36,212,199,8,59,158,4,77,165,168,51,25,53,197,194,44,222,247,179,189,113,34,196,216,36,173,38,20,67,108,204,144,74,110,127,156,34,3,190,74,144,41,32,8,87,127,31,9,223,217,40,18,126,68,13,25,229,24,243,164,183,175,168,84,173,244,111,15,32,202,42,192,89,114,253,109,76,68,126,111,34,101,144,218,98,101,145,50,136,112,50,69,110,4,51,53,82,22,41,61,30,114,15,237,70,202,76,101,164,20,104,231,105,35,55,112,45,75,202,88,37,218,201,99,64,28,129,118,25,61,82,166,16,41,93,101,145,50,94,25,41,149,56,2,82,17,237,134,69,164,148,253,8,60,122,164,28,43,69,202,184,30,41,101,68,74,85,68,202,232,43,34,101,134,220,201,2,218,117,129,181,100,89,164,84,138,145,82,241,83,183,191,24,41,59,139,145,18,177,5,222,143,72,57,84,138,148,126,114,143,149,71,202,112,49,82,142,20,35,165,82,140,148,25,82,83,197,72,57,162,71,74,252,225,145,114,180,44,82,6,73,25,214,35,229,212,110,164,12,234,145,114,108,55,82,102,245,72,57,172,71,202,209,242,72,217,57,78,106,182,16,41,195,165,72,25,36,117,172,18,237,130,
197,72,233,27,38,53,94,134,118,1,30,41,95,129,118,30,110,24,60,12,242,252,233,53,86,225,30,34,143,231,181,86,1,107,80,198,244,228,9,182,33,103,43,173,2,57,140,60,246,30,86,225,14,147,18,175,180,10,53,66,178,255,119,105,21,174,239,89,5,178,1,221,42,252,176,10,23,207,159,106,252,34,115,242,146,37,157,53,37,23,88,124,216,24,8,150,67,122,198,156,200,150,32,125,170,58,158,40,135,244,48,139,197,45,137,209,114,72,79,155,98,99,44,30,40,135,244,184,33,54,99,72,77,151,65,186,154,164,8,22,97,201,242,88,148,49,133,50,164,100,118,99,81,134,169,41,230,75,189,20,139,178,70,37,198,228,209,242,88,244,163,18,94,14,233,73,163,156,97,158,121,29,210,149,93,72,111,11,36,73,176,240,7,74,255,91,66,210,31,23,111,191,211,181,241,31,102,233,225,53,17,191,77,164,109,88,36,218,67,9,138,37,236,229,149,136,158,24,153,187,35,44,214,71,17,5,94,108,212,235,17,154,251,137,39,128,240,89,94,137,208,172,175,168,67,96,221,83,86,132,208,238,63,193,178,49,194,215,175,229,165,136,189,35,211,20,153,166,224,244,78,103,144,90,35,180,119,132,142,
43,11,166,240,2,69,23,30,95,9,211,33,5,105,109,112,129,69,102,89,96,214,20,69,90,27,164,67,1,26,139,80,71,116,209,24,206,48,101,114,39,174,144,41,76,44,74,195,35,139,166,200,42,11,142,27,251,19,219,209,17,146,130,84,21,161,195,209,5,115,120,49,127,59,74,44,76,230,200,217,234,224,84,126,36,72,150,8,153,251,169,38,58,198,148,172,37,60,249,56,170,144,39,76,83,81,114,32,167,14,46,27,189,145,135,123,2,17,64,236,118,143,151,108,1,50,6,41,25,153,54,42,11,108,240,252,246,74,52,94,29,161,237,222,40,237,27,36,155,66,109,96,35,200,57,249,3,103,195,43,83,36,173,112,229,174,61,241,210,92,4,9,124,156,252,25,205,236,39,89,9,82,36,166,85,39,232,58,116,66,254,44,37,34,159,250,41,63,16,161,15,18,116,65,172,100,7,35,20,77,126,130,219,239,61,25,36,205,138,133,99,34,110,139,210,135,10,141,69,35,52,168,216,18,208,230,32,245,36,98,154,170,40,106,20,43,31,82,163,56,24,204,222,137,146,49,65,109,131,196,107,105,7,159,68,130,228,237,206,98,164,203,79,2,65,20,248,52,172,122,12,32,39,152,33,220,12,91,169,11,128,156,136,118,4,229,
62,87,132,60,193,89,16,183,20,164,252,137,64,96,26,35,156,120,18,161,83,9,58,30,32,219,96,191,230,82,78,107,225,240,236,94,133,2,24,18,21,129,62,115,152,180,102,133,142,70,146,154,71,25,208,64,120,109,52,174,217,113,167,54,240,36,74,74,36,77,94,153,41,68,131,52,84,46,14,63,230,143,11,113,68,98,164,4,75,226,72,68,32,145,247,16,199,160,66,209,200,127,184,56,132,32,51,92,16,157,10,23,137,102,7,35,88,31,66,81,170,18,207,35,129,42,74,162,94,33,123,100,128,2,167,73,25,32,111,63,245,247,111,197,192,216,195,48,56,190,249,164,159,8,188,66,190,1,34,47,125,65,131,178,163,67,182,250,229,42,175,124,68,241,73,125,190,191,27,130,14,6,189,61,218,116,164,247,209,114,7,153,250,248,242,200,56,200,47,223,131,251,252,40,241,22,107,190,166,135,197,154,175,57,180,188,185,185,170,213,252,35,212,123,239,252,55,78,246,143,120,189,87,173,95,32,211,98,111,53,234,189,23,207,147,69,212,123,243,231,87,26,141,231,152,197,210,86,53,170,106,255,234,234,207,156,67,91,116,76,54,56,233,113,211,49,58,126,108,72,27,114,6,44,199,104,231,174,
147,12,77,242,99,103,19,29,111,210,191,108,210,191,108,11,236,124,230,12,24,218,8,127,42,46,105,34,106,10,252,148,154,200,208,130,251,90,232,120,75,87,174,133,150,156,129,199,93,78,170,115,118,105,173,78,58,90,28,178,79,59,214,68,39,156,184,208,73,13,78,28,57,169,165,116,155,160,161,165,146,134,62,109,72,76,240,185,167,137,36,103,7,46,33,163,211,203,255,176,194,81,233,246,31,60,107,99,192,194,103,109,220,101,75,159,213,25,224,226,248,165,245,216,220,99,39,23,210,25,76,187,80,18,18,190,228,66,210,191,108,162,109,46,185,67,11,91,116,136,200,137,63,78,162,99,11,63,201,29,163,28,191,239,144,126,223,33,76,49,247,0,172,88,155,166,57,99,70,253,72,106,195,81,27,228,184,32,228,216,134,161,219,232,120,155,62,116,27,61,238,117,146,205,121,70,11,54,205,25,157,244,64,230,2,153,219,254,176,137,28,149,179,55,47,60,56,216,76,237,205,11,154,218,76,172,101,238,129,191,5,74,153,214,6,90,200,142,163,134,22,114,182,36,181,206,22,218,215,136,25,26,169,161,49,163,13,53,10,34,252,80,95,211,244,246,98,19,181,52,225,75,62,195,
194,206,167,77,100,57,156,124,236,60,76,199,15,199,114,135,105,233,80,234,113,215,33,232,52,169,235,180,32,129,140,174,211,185,71,119,56,153,153,252,188,147,90,91,112,142,155,66,82,136,172,133,30,93,117,82,117,225,92,83,233,62,125,158,7,39,154,168,17,179,30,108,162,83,5,201,21,228,216,50,93,24,69,168,118,90,55,168,87,79,254,248,176,147,218,156,153,235,78,26,43,155,187,113,14,154,125,124,156,179,154,20,226,107,164,199,141,92,107,58,143,206,133,7,39,156,212,232,196,220,78,58,85,161,188,127,71,199,87,31,120,142,147,245,248,234,118,232,56,169,199,51,90,235,113,114,28,93,124,220,117,148,234,142,78,107,173,71,233,232,225,115,186,112,22,180,99,135,233,196,209,115,143,238,28,37,219,209,133,252,252,81,106,125,245,237,184,225,40,53,28,93,208,134,142,146,113,247,246,161,195,68,71,87,31,156,56,74,141,56,119,240,40,157,58,186,154,191,121,148,236,71,87,183,232,40,253,94,209,210,184,250,75,106,44,67,163,189,205,69,52,178,101,175,175,174,94,106,140,93,191,166,237,253,115,32,210,189,127,118,152,253,185,64,36,231,66,218,
40,221,167,197,68,126,179,184,3,245,155,201,145,73,203,202,5,227,57,102,180,76,230,175,63,85,199,243,139,42,57,21,88,12,202,66,33,224,171,58,92,31,34,249,207,213,251,83,79,85,58,166,202,159,239,1,148,110,170,190,253,127,142,191,70,124,87,143,115,135,158,170,1,237,128,74,167,213,36,110,207,59,213,200,49,156,254,20,1,246,28,174,48,243,178,189,170,214,224,171,252,196,83,153,26,229,72,16,101,104,220,119,28,71,135,124,131,154,205,71,3,242,32,169,42,150,248,72,157,206,242,162,189,210,139,235,31,222,198,21,70,149,234,186,67,56,188,175,213,60,245,244,163,194,16,197,120,209,189,56,175,153,176,174,190,135,154,55,166,65,249,47,255,41,146,164,54,63,234,89,18,182,128,248,38,150,175,203,237,205,122,67,143,131,221,100,129,111,163,186,239,165,127,113,15,67,25,158,250,60,218,1,31,157,150,99,247,101,10,6,122,115,1,202,169,161,77,149,198,134,51,218,254,97,234,138,77,107,77,49,250,32,142,74,74,34,59,21,167,143,146,89,115,130,126,50,148,164,123,145,172,214,23,193,6,66,4,101,73,242,180,147,187,95,59,33,83,131,28,122,80,39,
83,167,172,186,56,173,141,32,93,115,201,178,102,150,233,20,104,221,247,20,255,63,20,162,42,15,42,250,116,20,91,32,238,94,2,10,161,246,17,192,245,65,126,185,65,14,104,216,228,82,228,200,2,246,59,90,100,255,16,254,244,232,55,99,51,1,247,200,84,227,246,73,168,237,247,123,123,134,220,52,133,59,59,159,202,97,158,60,28,148,233,176,215,167,117,226,242,186,167,30,68,53,210,124,221,97,23,174,173,117,7,80,14,146,249,46,6,54,1,109,110,178,116,83,14,119,158,196,156,109,222,46,205,237,165,106,172,242,91,64,150,218,175,245,171,36,201,254,45,236,157,180,131,164,67,222,83,70,140,168,5,158,122,122,81,70,225,163,118,200,125,216,123,17,26,212,58,158,202,158,11,184,236,46,174,1,199,253,218,25,204,215,236,57,173,245,138,45,8,147,27,165,125,95,28,51,251,52,3,102,28,122,170,250,123,177,109,81,227,86,180,81,252,61,140,219,142,63,69,41,170,222,77,29,16,163,211,77,118,31,223,130,217,171,66,74,62,114,187,119,62,4,185,50,181,184,67,70,213,103,244,246,152,3,221,143,99,94,58,165,242,12,25,172,140,187,125,71,60,173,6,57,106,84,156,
121,191,27,23,122,120,169,107,200,237,221,94,193,4,97,177,207,132,130,112,173,28,98,61,221,22,247,208,227,229,30,106,196,166,15,232,235,238,57,164,132,180,97,79,203,61,133,50,242,80,126,83,85,243,159,40,62,19,12,245,67,15,89,225,2,48,35,153,246,168,138,209,45,107,17,111,135,25,130,80,3,61,90,175,26,213,194,33,229,36,46,92,82,149,124,36,128,13,28,50,123,201,24,34,3,54,136,100,159,197,115,218,160,180,222,243,144,223,115,114,211,67,19,158,62,77,118,203,159,31,199,168,50,207,66,76,216,9,117,187,204,178,106,15,156,24,87,251,95,44,5,8,22,100,117,147,1,198,252,163,177,202,149,64,190,144,230,243,97,51,21,127,176,225,166,70,31,118,11,254,167,5,243,32,155,60,56,3,186,60,93,186,20,180,147,30,108,30,137,239,170,188,170,65,23,137,193,75,204,167,98,77,147,191,86,148,138,5,131,254,206,5,179,115,2,4,138,61,57,158,180,117,15,54,184,21,191,55,190,221,224,137,55,121,97,48,180,93,227,193,46,28,253,67,25,118,219,9,187,135,137,209,83,21,169,188,10,4,25,214,78,40,240,202,113,173,65,166,19,248,210,3,237,141,42,147,90,155,66,
14,121,6,117,177,124,123,114,241,39,97,238,208,139,194,161,221,10,161,188,35,167,8,234,18,14,157,212,29,122,180,220,161,135,203,28,122,184,210,161,229,17,114,251,9,198,95,230,208,49,221,161,83,186,67,71,203,28,26,213,173,130,67,135,117,135,150,119,29,122,172,228,208,225,162,67,15,235,14,61,166,59,52,160,217,51,204,139,173,175,112,104,175,238,208,81,221,161,177,33,202,29,58,10,135,30,213,29,218,93,116,104,127,201,161,3,229,14,173,150,57,180,82,112,232,254,146,67,163,78,233,203,98,230,112,209,161,163,186,67,199,203,29,122,76,119,104,229,37,135,198,54,221,80,193,161,107,43,69,15,161,235,210,255,225,162,247,156,134,244,223,79,244,135,97,247,216,175,148,85,98,94,89,51,193,122,122,159,202,25,237,148,151,36,53,195,75,215,80,60,237,125,170,100,12,48,157,132,119,210,128,69,97,191,50,123,20,32,216,226,141,241,163,33,20,37,213,184,209,61,12,120,240,232,240,32,3,30,210,128,135,184,14,15,241,151,225,225,68,71,80,155,243,198,181,86,121,76,243,170,89,45,19,146,243,109,42,45,193,66,79,116,96,227,213,75,251,81,135,128,
231,242,208,57,142,80,151,214,186,84,218,175,100,180,211,10,29,80,39,242,113,108,175,170,147,88,251,76,193,33,181,22,133,142,168,211,26,112,197,43,207,52,224,139,19,234,44,231,200,172,204,105,221,10,237,83,231,23,101,58,39,47,104,232,17,233,85,207,96,60,0,208,34,254,44,73,160,255,40,54,130,100,114,186,147,70,53,108,244,202,230,128,239,37,116,13,31,241,184,12,114,218,168,116,234,232,170,234,232,26,122,25,93,147,172,199,103,113,143,232,144,147,212,33,7,127,56,228,164,75,144,35,31,82,146,2,114,112,134,67,142,87,64,206,136,14,57,226,187,42,239,168,65,29,5,10,135,5,228,140,126,31,114,222,79,216,237,114,216,226,233,55,40,46,129,197,61,2,139,3,192,226,225,151,176,120,208,44,143,218,3,29,227,170,242,18,228,68,26,220,113,191,55,11,200,201,86,64,78,237,31,69,246,190,34,251,175,63,41,228,151,42,242,75,244,252,32,191,60,17,162,134,208,240,56,28,111,234,41,242,76,4,169,54,37,162,5,208,1,162,198,243,33,153,198,229,68,11,76,122,31,218,58,134,84,89,224,214,33,228,86,167,144,184,12,40,64,181,4,140,90,59,133,179,178,26,
65,38,42,114,206,122,156,76,200,17,196,124,238,143,97,37,34,225,132,54,240,20,142,238,83,184,181,11,224,90,123,170,210,45,57,186,15,211,169,234,180,7,151,108,125,246,52,148,220,178,170,40,167,37,13,33,30,254,127,114,91,166,227,17,210,110,121,167,141,145,49,163,127,216,28,12,63,142,249,233,84,132,14,5,201,230,165,113,239,216,145,193,65,131,50,111,12,15,228,209,170,209,226,29,213,106,189,52,228,77,110,175,0,35,194,168,28,136,178,93,173,50,205,250,195,22,239,132,214,171,160,252,48,173,249,2,168,44,224,15,122,67,34,243,15,187,251,169,209,75,211,125,195,135,194,211,38,212,25,6,113,102,144,172,131,161,123,97,202,40,19,218,201,65,178,235,223,85,249,39,13,145,201,252,39,225,49,131,159,88,96,146,69,16,145,195,100,232,227,123,222,22,12,26,201,26,189,227,90,196,175,154,65,183,26,28,214,122,35,243,90,56,154,61,137,11,151,34,217,60,74,78,152,1,149,46,99,148,224,97,237,216,72,28,84,12,225,193,123,131,228,31,148,55,7,105,98,16,120,232,29,255,252,56,8,0,173,97,50,161,137,199,27,49,43,147,246,160,103,60,18,223,57,1,2,
209,122,134,115,65,162,190,84,131,55,235,247,47,110,55,12,46,54,249,169,195,139,136,60,72,189,125,84,251,71,145,189,151,200,58,149,56,154,131,52,190,210,162,167,145,72,13,160,185,49,2,208,71,250,28,77,118,192,58,31,236,71,43,210,211,40,89,20,202,35,80,81,203,83,37,152,239,194,229,19,79,35,105,92,20,228,5,203,91,56,113,224,169,162,60,56,25,5,254,19,172,163,206,139,5,83,160,27,166,128,36,60,226,171,197,13,139,79,3,212,31,68,42,132,139,235,159,6,58,112,46,156,143,122,169,59,72,210,96,0,173,133,53,48,29,62,178,225,169,210,137,194,33,217,195,200,54,148,110,173,62,76,31,40,180,39,10,143,81,122,234,163,88,8,68,98,221,24,68,219,247,52,218,191,49,8,83,133,89,196,173,130,70,148,49,81,178,140,16,134,209,186,158,254,71,230,196,143,122,169,31,51,127,254,49,18,214,12,102,231,166,90,170,220,29,206,23,215,202,230,240,218,242,149,235,90,237,151,119,40,207,254,219,56,251,178,234,54,42,119,3,11,243,198,69,231,30,84,238,206,157,167,42,81,185,251,247,169,239,204,108,152,158,37,67,91,247,146,116,234,59,179,249,230,234,181,
59,141,248,34,163,121,147,84,247,157,217,114,101,253,226,218,117,254,13,112,43,73,29,223,153,141,235,87,248,97,86,91,71,107,99,13,142,47,243,27,18,227,91,7,18,196,190,51,87,157,191,182,186,124,121,179,145,48,242,30,92,231,126,208,243,37,219,99,101,39,236,44,96,99,3,118,214,97,99,245,118,102,180,49,170,126,134,17,238,124,103,54,196,249,128,17,237,147,36,25,190,51,155,54,87,87,249,128,129,252,100,130,14,129,164,59,27,55,58,248,5,131,219,169,47,89,143,157,165,109,108,198,198,198,76,184,219,242,37,59,102,103,38,59,131,82,10,227,164,226,23,82,164,57,112,116,97,149,158,165,211,91,135,191,100,45,54,62,55,110,58,103,103,23,108,236,98,61,91,183,177,37,59,155,177,50,191,157,213,219,4,53,242,179,76,140,165,201,3,142,80,103,192,173,202,62,108,196,131,30,204,95,228,38,213,191,39,77,219,193,20,93,6,93,147,107,203,66,48,225,173,12,26,68,185,96,192,53,23,140,47,73,31,224,190,181,141,91,252,56,147,63,155,164,19,69,46,167,181,75,96,218,138,219,63,186,34,206,39,98,249,27,9,218,91,156,231,89,178,231,193,103,184,2,130,48,
94,220,16,227,109,201,73,50,226,112,3,114,23,66,197,135,157,158,197,194,143,235,191,100,102,43,147,236,140,65,154,43,207,98,244,211,51,24,39,186,124,141,223,23,121,208,153,164,106,92,187,140,131,192,213,36,53,65,155,231,174,109,108,234,84,230,151,147,116,26,87,95,95,227,210,78,142,107,160,82,107,199,52,231,215,55,33,253,244,214,1,92,126,125,249,202,57,156,46,168,114,168,42,65,15,141,184,204,142,251,130,87,206,243,251,166,103,113,124,12,199,155,87,151,207,225,190,120,254,147,4,129,61,227,170,152,102,240,65,230,75,78,157,205,206,122,109,44,97,99,11,54,118,94,98,151,237,236,186,141,221,220,207,174,219,217,69,27,11,218,88,53,116,88,11,141,54,66,80,43,80,92,42,157,95,197,40,215,111,113,37,198,141,41,202,95,205,140,25,210,212,146,142,31,205,8,105,175,114,51,76,201,245,105,192,67,138,154,113,241,141,146,213,165,98,15,164,47,153,205,202,218,237,204,95,197,134,171,217,180,141,205,217,217,25,43,91,144,88,167,149,89,49,93,245,179,20,125,4,202,231,184,126,161,183,45,200,221,11,197,172,45,223,20,34,89,154,3,107,102,
124,113,110,227,178,254,69,62,37,52,107,188,46,20,179,170,93,79,210,103,56,191,169,107,58,49,179,85,35,92,64,183,152,103,73,101,27,10,106,179,177,172,141,173,8,62,47,89,217,149,106,118,161,138,205,74,236,148,157,85,89,185,3,224,26,238,55,5,109,79,107,232,54,150,112,248,178,182,199,118,170,32,201,253,172,197,206,58,235,88,151,141,185,236,172,207,198,124,54,230,183,177,97,137,203,118,178,142,205,153,216,153,189,236,172,157,91,250,234,126,118,225,24,91,171,227,19,158,63,192,86,235,185,237,175,217,216,71,118,118,233,24,187,92,199,174,216,216,85,59,251,248,40,219,236,97,215,79,178,77,43,187,102,231,170,89,133,115,216,216,180,157,69,109,236,16,156,3,178,58,6,227,122,20,130,69,164,86,151,175,9,111,28,127,112,236,75,46,70,201,198,170,112,193,7,204,108,227,150,104,178,49,134,195,21,112,246,144,155,201,5,97,140,169,153,135,251,160,194,235,248,226,214,218,234,53,24,239,114,254,227,24,87,35,131,126,179,217,237,206,44,193,246,76,64,31,168,34,51,157,95,205,112,141,22,4,153,206,106,19,56,88,190,86,50,197,84,208,152,
166,7,39,82,180,5,211,19,240,145,206,110,93,78,211,64,193,122,50,203,26,246,122,76,160,247,210,250,170,208,102,58,185,221,155,166,25,104,235,186,238,182,169,88,190,26,36,149,185,64,86,155,74,210,30,220,179,6,30,185,103,39,250,243,75,9,78,135,249,252,134,110,206,177,60,58,15,30,12,23,181,133,205,164,15,209,108,87,208,214,179,184,250,184,250,183,237,163,246,249,105,91,253,106,205,216,102,213,253,251,174,155,247,164,225,143,173,198,101,201,151,178,213,70,236,104,184,121,22,167,218,239,204,84,112,170,88,232,209,197,24,109,57,49,201,184,240,53,184,226,59,73,214,124,121,131,203,227,89,153,104,5,80,237,138,214,176,113,181,76,182,70,225,47,187,162,213,253,94,23,45,248,219,128,224,117,55,175,144,109,193,205,211,217,252,249,52,39,185,10,115,156,20,243,102,150,225,145,156,19,51,20,202,9,41,73,88,15,16,186,124,225,95,122,124,72,102,243,51,73,74,236,74,87,159,172,36,226,34,158,8,9,115,173,22,194,74,60,63,155,160,200,238,109,64,38,13,74,209,0,168,230,91,235,151,56,80,39,51,15,12,112,118,17,7,106,109,236,136,157,53,
217,217,0,208,70,98,103,108,108,93,98,215,108,108,243,0,135,252,156,157,141,218,138,17,99,24,38,90,242,187,212,204,22,172,85,56,221,179,244,89,6,195,248,48,51,222,146,38,53,29,49,101,104,50,21,219,151,166,4,226,202,81,110,135,2,249,82,201,124,178,120,71,50,241,1,238,64,20,216,85,44,216,3,70,39,187,127,138,190,202,255,130,107,55,185,161,163,74,228,65,131,136,22,166,115,203,34,142,142,167,69,84,181,92,223,184,113,110,141,115,147,45,32,179,128,179,50,96,54,109,92,225,98,214,145,217,124,125,157,99,146,46,196,228,155,128,217,124,105,121,83,24,115,17,153,77,23,184,174,17,78,127,8,52,47,227,78,29,154,77,151,214,69,128,253,62,54,151,99,114,5,157,239,133,202,133,248,82,68,101,195,21,0,69,178,8,201,5,160,72,46,21,16,217,116,105,85,132,226,34,36,235,96,90,2,100,80,161,91,202,123,33,178,229,214,170,110,234,201,34,40,155,47,10,29,232,82,143,253,30,32,114,219,174,97,165,135,41,57,190,21,77,18,165,233,46,172,244,214,178,8,192,33,74,123,83,112,221,36,157,229,30,179,38,80,32,29,39,221,204,112,45,0,80,7,80,126,63,79,2,
240,157,134,113,45,151,96,176,60,196,167,162,76,183,185,242,68,40,141,66,243,144,69,244,26,63,4,20,99,120,145,20,140,11,19,133,69,139,188,128,143,4,135,49,95,191,118,67,32,149,194,144,30,220,21,55,241,4,72,55,225,103,105,23,189,191,45,98,232,134,2,225,153,168,65,183,72,195,218,6,207,21,88,134,12,41,170,202,42,249,117,145,49,88,167,194,134,44,29,77,199,237,89,158,209,217,167,68,174,112,137,179,150,233,49,8,99,181,103,73,251,72,220,6,176,23,209,93,87,113,42,102,207,4,30,176,119,202,36,236,25,90,198,205,113,61,57,46,228,18,5,236,43,154,173,153,251,12,247,189,162,221,114,19,211,45,179,104,185,134,229,75,240,241,98,38,97,190,181,124,71,168,241,157,12,247,230,111,167,250,237,146,211,230,171,177,89,13,128,68,178,253,150,168,23,68,137,68,50,53,125,242,183,181,38,123,176,214,246,73,131,221,221,105,191,224,179,223,87,16,144,120,104,221,184,130,152,94,52,235,150,20,61,94,249,219,152,107,24,86,111,86,4,196,215,231,26,102,228,26,37,137,84,4,196,66,178,241,160,89,132,67,145,170,34,217,80,51,60,56,190,95,178,161,138,
85,193,91,147,13,100,244,5,52,195,66,55,65,60,50,242,212,240,89,92,217,254,76,36,96,157,118,22,177,177,152,157,13,227,63,118,54,82,199,92,18,219,171,167,97,142,247,15,139,218,71,191,117,68,237,43,179,182,192,134,116,255,190,124,225,142,61,176,193,243,151,96,218,238,136,218,72,245,151,229,46,99,213,113,218,25,139,113,27,43,203,94,60,111,200,11,47,33,232,110,127,138,203,43,179,151,13,216,96,33,123,153,228,137,33,150,67,12,206,172,39,134,89,156,188,90,150,189,240,24,92,202,94,84,140,85,153,189,28,64,102,88,139,204,16,185,224,27,178,151,233,45,18,58,171,204,94,176,28,46,101,47,7,196,234,160,148,189,52,38,41,183,155,134,232,190,162,103,47,72,69,42,178,151,109,152,66,49,123,209,252,120,134,98,247,182,103,137,164,118,29,217,11,150,101,165,236,37,190,117,228,93,244,104,98,123,45,204,100,100,163,85,172,214,200,206,90,216,17,19,91,183,176,38,19,219,176,176,1,19,251,216,204,18,102,118,221,34,114,30,19,187,81,37,210,158,26,246,113,21,91,55,178,21,11,203,153,88,208,194,70,77,172,214,204,142,25,25,171,226,163,81,21,
163,253,208,9,95,248,233,40,145,213,92,111,54,128,88,209,2,211,113,224,236,131,233,47,121,206,175,216,216,168,196,198,196,146,161,219,198,106,36,177,10,152,135,100,10,217,146,124,24,11,231,230,20,133,11,119,11,1,226,131,39,73,242,195,190,47,217,65,27,235,64,137,64,24,243,240,1,22,61,201,70,48,230,1,54,86,199,38,236,108,210,206,166,235,217,12,62,109,108,222,206,19,185,243,86,118,81,98,27,18,219,172,103,55,218,216,205,122,118,107,144,221,238,101,55,237,236,134,141,175,43,47,73,236,172,141,13,90,217,158,106,198,172,140,206,131,205,127,139,200,88,133,245,158,30,215,211,115,111,204,180,31,90,159,165,233,188,80,158,64,131,103,19,203,15,247,77,136,85,140,21,246,119,109,245,36,135,230,196,71,249,143,19,124,37,99,186,178,113,125,141,158,205,44,110,119,206,136,197,204,250,149,139,56,63,149,203,175,138,144,35,144,99,114,145,47,101,44,23,244,85,148,110,69,19,9,227,36,22,51,19,98,49,83,176,164,201,197,252,249,73,142,41,226,174,169,143,52,117,138,31,21,139,6,147,211,219,189,147,148,231,213,145,194,114,102,98,54,95,
61,193,151,179,186,229,165,23,243,141,101,102,55,30,55,165,105,107,100,156,234,119,13,47,157,201,171,208,9,55,86,161,249,113,108,126,141,239,226,203,88,252,111,28,95,18,51,213,99,192,23,60,118,11,86,102,10,145,242,29,149,102,222,188,190,204,235,82,187,58,51,34,239,45,83,23,95,120,238,234,74,95,120,150,116,5,169,138,98,142,174,46,228,82,24,234,85,202,130,41,97,142,146,178,244,37,234,179,169,143,242,185,41,94,201,48,111,46,139,120,175,171,11,139,79,29,92,190,175,171,207,210,188,242,85,140,5,250,76,227,241,45,26,231,74,47,162,152,208,215,150,90,84,241,120,54,127,125,156,23,120,138,183,61,75,175,229,175,166,233,96,153,138,197,23,205,111,128,151,42,102,48,112,40,216,35,160,160,213,198,194,86,102,51,176,180,149,131,195,28,160,6,235,41,3,91,39,182,98,101,77,70,14,38,3,140,23,10,248,218,202,192,174,10,108,129,39,94,99,108,212,202,54,141,236,184,141,163,193,186,129,3,75,197,106,11,181,69,221,204,38,206,106,193,114,128,233,124,54,65,53,191,253,94,152,241,225,122,17,231,38,151,182,28,40,32,74,188,72,52,110,99,103,
37,94,48,66,9,131,87,46,236,236,90,61,219,64,65,207,206,22,4,244,244,74,172,6,213,48,120,123,246,217,132,98,158,164,150,201,105,195,4,41,37,28,154,56,95,7,95,83,190,100,134,3,172,198,198,246,217,153,3,181,65,68,77,177,50,76,217,217,152,196,151,136,109,40,206,160,138,129,106,208,110,29,230,89,122,217,54,65,63,107,249,146,25,173,188,92,5,140,219,111,231,12,163,194,51,40,177,56,10,147,245,108,170,158,83,130,210,226,178,149,173,72,236,92,27,59,143,146,99,47,187,88,199,214,176,4,237,101,31,181,240,10,203,149,24,219,136,178,43,39,217,70,61,187,82,207,46,219,216,21,59,219,56,192,174,226,16,236,72,188,76,134,112,126,88,47,190,52,0,135,126,182,15,88,48,114,25,6,61,243,240,8,254,123,25,255,157,140,217,39,104,176,112,48,49,113,112,146,226,220,56,46,23,109,53,29,175,153,160,199,209,47,153,5,32,104,103,71,237,188,8,11,106,79,75,188,120,4,152,198,39,234,169,30,59,207,30,70,235,88,178,158,255,39,140,169,173,108,4,58,174,225,128,158,180,115,177,167,15,176,76,29,27,183,179,140,157,77,72,156,211,140,168,107,165,237,44,
5,140,22,249,7,42,90,7,237,172,214,206,231,170,18,148,243,74,208,159,93,5,245,176,98,243,200,101,252,3,253,190,191,115,9,201,165,88,173,219,109,252,218,189,80,130,157,181,2,252,173,44,42,241,138,172,83,104,198,40,49,202,127,10,243,64,49,215,204,111,134,171,165,125,15,62,129,242,48,186,40,56,85,67,7,86,118,92,172,248,79,72,172,89,12,211,109,231,225,40,14,178,160,15,27,155,181,179,57,4,141,94,182,112,128,157,25,230,149,45,148,199,150,237,108,165,141,173,234,229,96,212,198,80,149,68,221,11,81,165,142,157,147,120,108,185,80,205,214,90,217,250,1,182,118,156,173,30,96,23,218,196,127,80,66,64,84,57,206,206,8,131,91,20,5,229,85,137,93,168,231,3,162,216,176,80,199,150,36,110,248,184,0,145,10,166,128,194,223,133,6,118,177,135,173,157,100,235,126,118,81,102,23,48,62,190,63,206,235,160,107,162,44,136,42,221,197,131,108,205,207,214,101,182,22,101,235,195,236,163,203,236,82,43,251,8,23,212,243,74,30,38,154,146,248,128,8,128,188,182,103,19,148,31,224,255,193,225,34,10,217,40,254,181,179,137,54,94,27,79,53,112,157,65,
145,168,222,5,237,188,64,8,29,163,238,14,233,42,141,76,174,103,131,54,214,47,177,222,58,214,143,242,161,176,128,118,17,123,81,83,132,255,244,137,111,32,67,212,233,241,77,187,196,78,194,104,236,236,148,141,225,75,85,119,21,59,75,192,50,234,248,39,194,62,236,35,11,26,246,74,159,152,217,44,40,177,75,119,37,54,5,9,24,165,59,181,108,194,42,221,54,176,73,16,47,177,57,131,116,107,31,155,175,146,110,56,164,235,168,197,214,74,155,38,30,219,225,114,49,38,161,78,3,163,87,205,210,199,22,214,195,107,183,210,85,198,154,132,45,216,76,210,70,45,51,89,165,43,128,150,131,210,101,135,244,145,67,250,208,33,173,59,164,53,135,116,209,33,93,112,72,171,14,233,188,67,58,231,144,150,29,82,206,33,157,117,72,75,14,105,209,33,157,113,72,11,14,105,222,33,205,57,164,89,135,52,237,144,166,28,210,164,67,202,58,164,9,135,148,113,72,105,135,52,238,144,82,14,41,233,144,18,14,105,212,33,197,29,210,136,67,138,57,164,168,67,26,118,72,17,135,20,118,72,65,135,164,58,36,197,33,13,57,164,128,67,242,59,36,217,33,13,58,36,159,67,26,112,8,35,47,
246,80,91,46,21,119,98,108,217,75,168,242,103,175,95,91,215,14,254,10,187,49,244,223,245,176,95,85,77,145,61,53,142,174,197,197,6,190,27,147,43,118,45,62,248,7,31,252,137,59,180,179,232,38,103,119,100,103,177,27,237,11,250,145,87,125,200,183,38,61,161,135,132,182,47,47,190,244,226,146,16,190,216,89,196,23,226,66,234,12,209,108,243,67,146,67,232,140,218,254,76,52,155,25,60,120,230,56,182,253,25,186,239,229,200,118,122,150,246,120,168,201,77,212,201,59,209,12,149,83,117,70,248,227,201,139,232,70,234,36,39,122,41,186,49,103,55,239,213,32,151,74,10,102,198,38,152,11,123,188,1,242,6,240,246,130,157,27,56,3,154,2,216,172,246,82,200,75,138,119,231,174,76,22,213,143,215,123,160,95,5,27,125,20,162,237,107,152,205,131,158,59,78,182,63,127,23,15,98,160,161,145,223,230,37,213,75,184,211,237,127,200,251,160,60,254,237,187,184,70,52,135,96,76,139,26,32,52,159,5,48,13,8,138,112,50,36,69,76,35,235,211,224,78,62,132,159,124,254,154,16,223,180,221,185,196,39,199,156,120,214,129,19,131,17,209,112,135,151,96,108,163,177,
11,115,109,15,226,50,15,69,113,9,88,192,240,222,64,141,76,59,23,49,188,96,68,2,11,226,70,193,5,127,24,181,48,131,206,200,35,193,72,50,15,22,65,30,103,2,212,234,28,68,252,96,77,232,71,208,73,120,34,212,227,7,29,5,134,176,175,9,65,240,25,95,102,72,8,13,243,136,25,193,141,79,144,174,22,68,87,198,16,134,19,164,189,196,16,40,8,9,134,48,182,80,139,96,136,51,200,53,195,229,133,187,66,37,121,129,39,33,50,93,94,37,134,112,177,104,69,229,12,129,21,220,2,182,10,12,97,44,240,244,74,134,254,29,141,44,80,100,129,130,11,212,191,176,115,163,159,104,68,92,140,189,214,190,105,10,79,147,50,77,209,233,157,187,224,190,15,27,248,243,20,153,231,95,245,204,227,73,155,154,48,81,20,26,195,206,62,31,94,92,30,157,167,193,121,234,155,182,131,158,30,50,5,161,55,92,21,153,222,30,68,175,65,148,252,17,178,139,169,200,207,167,229,74,233,131,246,240,224,2,102,198,32,250,180,81,49,109,184,52,45,134,230,207,245,204,131,196,154,40,223,243,23,198,16,192,218,15,179,248,167,243,119,131,100,140,144,17,67,96,160,17,208,56,77,160,52,56,79,222,
249,237,207,132,113,99,96,3,134,7,111,138,32,16,100,134,231,183,239,138,254,7,139,24,178,32,135,126,46,138,157,27,216,143,213,229,208,47,228,240,50,65,160,6,52,233,210,232,153,215,105,42,147,3,70,215,133,55,56,111,239,225,122,44,151,3,102,67,47,3,228,0,169,67,8,66,26,53,125,194,246,47,98,218,162,40,10,226,23,51,23,197,175,79,11,18,35,133,57,223,36,7,175,144,0,164,193,201,156,230,224,1,33,192,160,12,58,99,208,82,120,158,64,169,2,57,64,13,120,230,71,151,131,87,188,41,160,35,4,176,32,127,104,231,46,8,130,228,32,69,168,25,95,193,255,194,17,26,136,236,108,14,112,77,216,240,20,10,238,192,229,193,48,128,135,250,195,102,33,212,157,91,152,172,159,76,3,1,113,7,30,3,14,161,255,20,162,216,57,47,238,171,195,125,152,213,47,110,197,0,24,57,18,66,75,0,232,216,185,129,11,245,89,59,200,130,249,116,90,244,89,239,226,110,113,21,117,240,233,45,56,135,89,49,0,166,239,15,239,220,197,29,191,66,19,249,159,116,4,28,191,146,62,115,72,247,28,210,167,14,233,19,135,116,215,33,221,113,72,183,29,210,45,135,116,211,33,2,151,67,218,116,
72,215,28,210,199,14,105,195,33,93,113,240,112,116,233,141,17,105,101,55,34,253,137,224,79,247,81,250,213,43,226,211,204,247,66,84,41,62,141,149,133,168,196,150,235,79,192,74,105,247,127,223,233,98,204,169,226,225,230,202,197,77,109,255,87,136,56,182,255,222,197,190,170,58,67,118,117,112,225,188,113,177,183,176,255,111,92,165,42,139,225,81,231,72,180,216,39,31,125,180,41,81,247,243,217,46,195,87,18,115,72,6,135,100,116,73,38,135,100,118,72,22,135,84,229,146,172,14,201,230,144,236,46,73,114,72,213,14,105,143,67,170,113,73,123,29,82,173,67,218,231,144,246,187,164,58,135,84,239,144,14,184,164,131,14,233,144,67,114,56,164,195,46,233,136,67,58,234,144,142,57,164,227,46,169,193,33,125,224,144,26,93,82,147,67,58,225,144,156,14,169,217,37,181,56,164,86,135,116,210,33,181,185,164,118,135,116,202,33,157,118,73,29,14,169,211,33,117,57,164,110,151,228,114,72,61,14,169,215,33,245,185,36,183,67,234,119,72,30,23,34,174,228,21,161,119,208,197,195,48,130,49,66,242,144,139,135,103,4,233,160,75,10,137,152,141,200,61,236,
226,81,28,177,28,17,61,238,226,209,29,49,62,233,146,32,76,132,124,4,254,180,139,39,1,72,5,144,16,76,186,120,114,128,20,97,198,197,115,5,100,12,200,27,22,92,60,135,64,38,129,124,226,172,139,231,22,200,48,86,92,60,213,64,194,129,180,227,130,139,167,32,72,68,144,142,124,232,226,169,9,204,225,178,139,155,6,12,228,42,44,197,197,237,5,86,115,29,22,228,226,118,4,107,186,237,226,150,5,251,130,149,125,234,226,22,7,187,187,255,228,230,243,89,154,255,74,26,238,130,42,122,191,146,162,57,105,36,39,197,115,82,34,39,37,115,82,42,39,141,231,164,76,78,154,200,73,147,57,105,42,39,205,228,164,217,156,52,159,147,22,114,210,98,78,90,202,73,185,156,180,156,147,206,229,164,243,57,233,66,78,186,152,147,214,115,210,135,57,233,82,78,186,156,147,54,114,210,213,156,116,45,39,109,230,164,27,57,233,102,78,186,157,147,238,228,164,79,114,210,167,57,233,179,156,116,255,85,20,77,171,222,45,199,87,156,200,146,79,128,5,48,2,142,192,23,92,1,108,150,92,65,207,204,32,147,11,149,57,25,4,8,49,66,152,144,42,100,59,35,68,61,41,36,15,21,164,133,
70,132,145,63,71,232,249,74,100,98,154,42,221,255,103,35,18,57,184,81,26,29,220,34,97,142,186,45,194,16,185,21,10,19,220,239,224,246,119,192,193,141,15,150,167,155,221,113,221,224,132,181,53,59,184,169,193,206,116,35,211,45,172,187,96,91,207,213,118,10,56,72,110,199,172,110,122,238,235,0,175,30,158,215,241,236,78,183,175,33,145,251,5,139,102,5,155,226,6,37,172,73,55,37,144,175,27,145,110,65,48,31,110,59,130,227,179,194,255,129,2,186,189,64,48,220,82,116,51,17,54,2,249,193,64,32,75,221,52,96,23,220,40,96,17,91,141,207,241,122,37,60,17,192,187,210,209,245,212,76,201,102,194,19,88,145,230,199,67,104,53,84,155,181,227,64,61,0,109,18,89,27,30,248,108,38,165,153,66,205,228,105,22,169,97,66,160,94,136,156,177,102,146,155,201,205,239,221,89,196,133,49,145,108,33,211,116,119,145,220,69,106,23,69,186,30,242,113,112,14,249,152,210,67,161,30,242,244,136,204,13,207,8,168,60,71,11,105,232,242,70,115,48,207,103,120,250,211,76,32,71,222,37,4,185,17,242,82,12,0,18,48,89,129,4,124,203,223,225,212,76,190,102,154,61,162,
83,241,115,228,162,120,151,19,159,12,137,42,94,117,165,246,209,108,23,121,251,40,208,39,82,62,156,152,213,179,152,46,154,233,162,16,39,82,228,73,160,117,170,147,240,222,41,95,175,158,153,209,12,237,116,76,225,109,115,34,253,195,233,153,78,10,225,1,148,94,100,75,219,55,179,30,243,12,109,247,139,84,105,48,75,213,98,6,74,247,145,218,39,178,37,44,77,69,116,1,37,18,238,197,60,217,46,82,244,169,240,24,11,230,153,234,165,64,151,158,51,81,182,144,208,246,234,9,109,111,126,16,19,151,114,90,92,140,33,2,93,228,198,249,84,159,166,166,176,151,134,63,152,3,210,3,71,30,254,86,45,202,120,196,118,65,22,127,178,68,83,248,51,69,52,227,209,6,33,15,208,137,228,23,18,158,1,255,120,114,155,211,89,20,9,228,33,212,35,9,97,112,169,20,232,196,140,32,26,116,234,4,64,48,208,143,24,99,251,26,102,200,116,137,82,119,186,75,80,171,139,9,36,165,186,56,61,144,212,76,31,39,91,233,42,203,46,179,30,24,68,165,224,64,62,164,22,232,227,58,130,236,192,26,207,158,75,178,83,10,58,122,136,141,57,80,179,205,151,2,152,27,3,131,46,188,12,13,164,21,
165,184,115,209,77,108,138,63,127,2,94,141,200,164,211,80,60,136,135,5,114,1,22,141,80,215,140,46,50,208,26,234,45,230,211,152,90,55,65,220,241,149,20,217,133,201,152,128,201,81,129,148,99,2,41,211,175,71,202,51,2,41,207,10,164,92,17,96,185,42,192,114,237,21,96,169,131,209,199,244,92,238,202,125,197,97,243,186,128,205,91,2,57,239,10,228,188,7,216,220,110,124,174,118,237,180,206,210,44,132,133,110,220,144,122,86,69,19,33,41,231,85,180,48,146,186,26,82,233,179,216,234,112,140,62,81,151,225,188,154,65,57,139,182,89,244,175,47,123,209,207,55,242,199,203,223,71,50,241,5,138,173,226,49,181,207,212,101,60,20,160,153,149,179,120,191,158,86,139,87,66,169,203,148,88,232,199,119,18,208,47,25,230,29,24,148,138,61,250,12,239,180,202,134,254,83,74,7,234,224,199,104,22,162,148,119,251,82,138,234,147,161,237,15,147,116,112,118,48,127,103,150,170,102,188,154,58,171,218,102,208,89,61,19,96,179,148,191,63,21,52,205,160,16,5,47,205,198,242,119,179,100,73,5,183,240,58,56,107,138,118,110,99,232,172,250,83,0,3,205,134,31,197,
102,201,55,163,106,42,156,119,10,144,57,19,192,66,255,81,98,134,186,166,34,218,201,41,58,156,13,233,46,175,60,186,59,69,150,153,96,254,222,12,25,167,228,45,154,9,217,166,40,31,157,161,158,41,12,157,29,61,141,163,134,44,13,164,35,63,21,254,20,18,51,76,13,131,21,21,99,230,239,112,142,84,13,207,150,152,211,104,250,79,147,57,131,7,225,178,170,57,67,90,55,80,14,243,169,51,10,156,76,27,154,33,86,160,44,13,202,192,244,143,69,217,83,157,178,135,156,119,78,217,25,78,217,246,157,51,68,243,129,237,207,230,9,89,36,209,243,120,87,215,31,19,202,247,72,40,159,243,87,154,113,92,251,93,37,150,136,251,217,126,58,220,79,114,63,169,253,152,40,67,207,99,253,93,179,94,164,154,72,41,179,122,86,137,164,107,186,152,89,206,225,64,207,46,129,153,34,193,124,126,152,232,144,23,80,8,248,212,115,205,21,92,163,231,155,28,69,113,128,156,179,128,164,218,16,224,211,112,136,167,115,31,209,243,166,16,169,131,184,83,79,69,175,32,27,197,197,72,71,63,214,51,82,28,92,95,122,206,105,228,241,223,0,28,205,14,82,108,144,66,131,184,93,79,86,111,
97,64,113,129,1,81,142,231,22,131,252,154,136,184,236,171,66,42,203,49,25,67,33,157,5,46,243,140,54,79,207,49,226,72,47,77,246,170,147,98,137,30,31,160,169,1,30,121,155,68,46,4,177,143,200,52,45,211,40,127,142,87,29,37,154,70,16,198,211,188,42,246,220,69,52,142,224,5,34,42,252,14,97,120,44,78,115,113,117,14,255,129,177,143,81,106,140,71,250,121,162,241,9,90,152,0,162,215,52,22,171,0,11,248,146,232,204,24,69,198,30,197,16,189,207,144,47,60,74,11,163,154,138,51,168,111,4,135,105,14,79,187,45,196,40,28,171,194,128,65,224,133,56,211,53,151,162,96,74,59,25,36,154,163,195,232,156,195,163,203,136,34,156,146,32,159,253,209,93,113,181,101,38,69,10,46,19,103,14,227,197,72,83,184,12,76,97,205,62,51,140,247,131,109,225,11,64,89,62,58,69,61,147,137,45,154,152,60,141,109,195,134,9,234,199,211,142,147,169,7,92,24,115,163,154,60,71,230,133,209,45,194,212,103,240,7,62,188,128,115,226,72,147,207,144,121,9,95,46,97,72,252,1,1,115,227,63,165,137,81,144,171,249,38,136,38,113,251,36,153,167,240,116,197,20,153,103,208,81,63,
55,138,212,65,235,158,163,234,133,148,166,158,137,179,5,224,208,25,98,75,113,77,89,34,54,50,70,57,72,35,199,101,228,91,26,165,232,40,186,252,137,143,127,102,152,34,144,6,94,81,184,20,171,18,210,122,148,16,103,186,34,41,58,3,54,65,24,222,8,19,78,210,2,216,212,37,120,38,78,17,72,67,92,109,9,167,64,184,118,82,156,57,140,238,221,32,46,19,18,164,240,48,45,64,26,115,73,219,2,164,49,71,61,51,144,6,120,153,192,227,102,96,98,106,82,27,194,211,38,144,220,223,144,80,206,4,254,37,44,252,190,75,148,30,92,197,210,131,88,32,98,153,168,175,180,176,112,212,23,91,215,92,98,189,229,42,86,31,92,197,234,131,75,212,195,197,98,20,11,175,85,151,168,135,187,36,172,59,176,96,205,185,138,37,113,177,156,197,162,86,95,132,205,186,10,235,176,41,151,168,138,187,176,138,121,14,73,3,26,196,218,24,43,100,172,147,199,92,162,58,46,214,207,88,244,140,184,68,117,220,85,172,142,139,245,54,214,70,170,88,129,99,29,30,208,11,228,174,66,129,220,43,86,236,88,183,99,245,238,22,43,249,94,177,242,114,185,36,44,193,186,92,124,181,143,21,25,86,254,
88,255,183,63,152,149,22,159,211,243,190,110,82,186,169,163,155,252,221,120,159,12,69,186,191,0,81,88,229,98,185,139,165,47,214,192,200,242,144,238,97,133,28,206,73,106,78,242,231,36,95,78,234,207,73,189,57,169,43,39,157,206,73,109,185,231,176,12,120,71,7,175,23,242,84,223,95,86,50,177,13,22,75,38,182,244,242,149,198,232,165,27,215,87,181,195,95,163,104,82,245,207,19,236,107,241,114,129,241,133,171,198,69,127,161,104,82,120,221,73,116,169,126,39,250,2,141,254,125,232,248,76,69,52,71,138,90,191,69,47,213,112,143,233,69,58,109,254,118,243,152,173,221,142,22,44,59,225,49,115,135,69,26,221,175,183,92,217,68,203,21,122,104,30,172,125,205,176,247,117,82,60,15,225,179,50,236,187,30,150,248,198,41,118,88,38,176,113,40,118,121,176,165,114,202,42,54,95,112,153,56,229,180,139,190,245,169,23,105,76,27,83,211,167,209,230,210,153,242,54,225,161,133,100,84,66,119,106,95,42,185,31,157,120,167,179,211,123,209,153,241,209,215,188,13,8,155,99,216,149,107,174,99,167,109,188,95,28,219,148,216,13,67,99,196,106,3,111,7,71,
83,236,199,232,142,181,179,155,237,47,166,78,218,144,220,124,205,110,29,120,145,141,238,159,34,219,215,188,141,2,155,50,87,237,188,109,60,193,94,100,98,230,44,25,191,230,123,124,124,143,85,107,123,145,206,214,35,231,56,141,237,235,100,196,248,173,53,100,253,112,30,253,206,182,251,247,27,166,110,88,55,207,216,219,71,109,214,16,56,206,183,191,136,207,48,192,231,183,195,61,210,252,65,91,163,213,238,171,169,234,56,93,189,52,96,189,175,224,130,199,244,2,125,209,49,215,231,93,49,170,65,151,76,107,66,136,246,88,138,92,169,164,54,156,14,86,165,104,187,243,107,190,247,138,61,105,108,73,13,96,203,213,202,102,196,134,27,54,167,249,46,28,118,78,193,151,216,118,67,203,8,54,175,246,217,248,86,33,213,65,96,29,153,177,217,180,111,79,134,102,82,10,90,81,98,73,175,57,69,73,188,28,53,53,218,251,109,79,210,238,190,108,189,127,191,254,230,61,219,135,40,189,38,237,130,104,77,121,145,66,214,150,120,24,67,78,149,78,106,29,105,170,206,206,242,28,174,246,219,11,62,107,160,219,254,98,106,212,240,173,177,201,54,186,95,106,180,218,
96,96,224,11,13,118,43,14,174,240,250,22,91,115,187,228,238,180,13,247,216,167,250,109,75,3,92,255,87,228,186,155,129,99,247,149,6,82,183,198,94,32,13,204,142,229,235,190,230,157,243,205,86,214,105,103,174,99,172,95,236,222,97,195,12,219,135,231,192,89,61,187,120,156,43,96,221,197,55,186,23,173,124,107,109,204,202,100,177,133,219,32,122,189,120,139,190,214,245,34,75,117,169,96,238,219,218,136,109,30,133,244,13,168,193,119,243,30,88,179,173,204,90,209,151,110,13,161,221,239,39,205,96,74,219,242,166,240,188,115,58,142,36,118,123,41,77,71,82,145,7,106,50,126,36,69,209,68,247,193,36,141,38,135,240,22,217,71,231,191,230,70,105,128,182,91,153,100,229,54,234,181,241,29,224,121,43,223,149,4,49,151,96,28,186,249,216,216,173,105,118,187,149,221,178,241,221,108,236,33,99,99,151,164,23,73,26,79,120,118,122,18,52,158,108,127,142,68,252,127,83,19,138,166,198,3,6,52,65,13,197,66,38,188,37,57,22,163,255,249,118,186,111,207,108,255,67,107,154,140,169,30,251,76,175,109,150,182,39,146,73,6,132,78,17,239,73,77,69,114,233,
164,45,69,159,187,210,180,47,179,48,153,142,161,205,243,108,74,169,66,139,54,188,47,165,216,190,69,215,26,26,239,155,215,237,99,155,182,11,119,234,135,63,182,31,187,8,57,72,141,35,48,175,45,235,139,236,56,103,118,33,75,39,210,201,137,175,217,30,27,223,114,198,179,19,216,240,172,147,132,157,156,122,145,229,79,0,105,206,44,53,124,123,51,96,125,49,149,101,223,142,245,73,205,237,182,205,99,92,175,14,11,92,186,173,214,100,235,169,182,79,212,219,241,165,228,148,142,157,180,119,156,182,9,53,75,232,191,188,34,91,111,6,246,8,155,94,192,44,216,62,21,13,6,195,112,32,209,198,132,173,90,60,253,49,119,146,183,49,157,145,216,82,61,203,9,77,195,221,209,132,16,65,47,129,216,173,245,85,49,181,154,69,177,53,42,182,224,199,176,227,138,103,158,208,99,0,132,192,118,43,118,240,173,108,31,186,172,96,222,1,152,17,101,147,219,235,72,113,82,241,203,240,66,251,232,132,189,126,213,38,4,113,16,159,16,196,196,164,36,218,247,62,191,243,53,111,109,128,189,193,102,128,65,251,109,12,27,231,93,48,57,116,91,233,83,137,206,121,72,165,65,
60,168,117,176,158,183,57,224,122,90,132,225,228,255,159,1,116,67,243,60,40,133,7,175,83,212,15,127,6,232,205,255,71,2,189,140,154,238,23,160,23,18,160,151,214,65,111,90,7,189,220,15,2,189,158,93,208,75,191,26,244,50,223,3,189,197,18,232,165,222,6,122,203,239,0,122,131,2,244,32,215,86,30,79,82,154,0,189,105,128,94,226,63,24,244,102,102,211,97,1,122,113,1,122,161,34,232,77,190,13,244,166,116,208,155,214,65,15,249,125,57,232,77,254,112,208,219,190,240,38,176,227,150,252,53,91,221,243,98,102,177,234,235,119,132,189,238,23,51,100,154,93,125,216,56,63,127,8,176,209,61,79,218,95,181,157,145,255,43,149,167,177,254,220,156,239,224,2,141,206,120,154,230,104,251,236,72,246,209,250,8,29,138,103,114,60,225,31,207,97,75,43,154,202,69,146,7,163,52,56,67,181,200,21,18,217,39,242,215,252,169,186,250,106,246,129,141,53,73,172,181,142,57,37,230,1,168,161,193,17,237,21,112,64,209,220,193,251,74,196,19,101,103,171,217,114,61,91,209,91,72,218,56,50,162,25,4,17,246,204,1,222,154,113,166,142,45,30,96,243,240,122,244,47,74,
252,63,11,245,252,70,224,0,144,20,237,70,112,60,244,219,248,37,230,182,243,135,187,142,33,108,73,172,26,109,88,18,179,216,5,248,194,199,183,154,120,89,30,251,3,168,9,163,50,140,250,112,169,250,142,186,49,170,199,216,103,64,245,29,219,14,165,210,59,246,37,176,136,68,238,135,253,10,212,159,75,117,119,212,165,81,119,71,141,26,219,29,168,87,163,106,141,12,15,21,108,236,138,140,138,154,54,42,219,195,101,13,15,168,123,35,153,67,13,28,149,112,175,54,251,2,235,161,210,166,147,225,239,20,51,168,170,240,218,198,234,141,107,155,90,219,175,249,203,153,254,69,63,251,53,207,159,188,217,210,166,211,197,98,155,195,195,175,44,63,87,23,242,126,21,111,166,92,208,176,155,231,15,204,92,11,80,74,70,31,181,123,65,27,144,201,230,89,160,190,180,197,77,249,101,15,225,241,225,122,239,2,169,11,15,189,191,230,225,8,173,87,117,162,109,235,24,218,126,234,89,179,196,90,234,120,226,212,95,207,97,12,104,11,33,162,161,165,23,143,199,33,9,176,178,110,209,211,130,160,138,36,202,135,46,105,137,101,172,188,135,9,109,39,232,168,225,109,42,
34,37,90,0,81,60,67,172,249,181,80,25,114,164,6,222,236,3,125,225,18,128,51,148,133,168,134,103,69,13,213,140,254,203,181,159,71,178,164,78,111,227,157,152,71,240,250,9,101,129,66,11,249,195,10,29,14,81,42,0,98,199,182,8,63,26,161,100,89,128,106,85,122,124,3,239,171,144,233,255,94,143,156,253,41,133,87,41,154,110,137,208,227,250,95,51,123,47,179,16,15,149,120,138,110,79,27,147,234,153,5,77,79,85,63,15,227,133,134,244,103,205,193,117,234,95,207,135,130,180,175,159,58,7,150,41,188,150,15,13,240,23,97,6,112,198,187,158,199,251,130,240,188,254,9,101,141,6,150,243,31,14,96,207,31,111,205,92,35,239,90,62,140,84,55,72,129,193,53,10,174,61,200,10,185,29,70,138,129,54,27,17,60,208,160,118,65,180,208,109,226,41,76,59,187,101,103,119,108,236,238,1,246,201,49,118,215,250,115,44,153,176,23,251,107,118,235,16,195,15,153,212,88,25,3,81,63,159,254,249,239,144,250,159,208,0,207,211,181,247,36,181,140,196,50,163,252,215,69,163,180,141,163,175,243,252,181,245,155,171,90,223,111,96,150,183,254,229,113,246,155,170,89,178,
59,150,23,206,155,22,211,133,183,24,98,47,20,191,90,243,224,63,191,186,84,111,254,66,157,222,217,247,27,30,87,77,13,140,156,95,168,244,87,171,169,89,205,157,162,234,212,116,126,20,103,234,25,36,217,138,102,170,106,150,168,98,147,213,60,156,163,17,11,173,92,122,42,132,156,25,13,200,55,15,112,169,222,20,201,17,250,202,98,118,145,140,34,138,214,127,17,203,238,71,6,214,17,35,67,108,58,159,20,115,33,139,67,231,211,20,218,206,144,112,67,31,13,236,46,177,59,189,236,182,200,191,129,52,71,36,158,249,210,224,23,40,125,196,211,218,80,156,12,241,153,109,51,110,70,199,157,196,115,123,116,102,33,183,7,58,37,241,127,60,183,137,245,4,102,171,253,34,78,91,255,203,200,228,170,198,151,250,233,21,173,45,77,142,244,89,205,254,127,32,29,173,111,225,75,19,60,19,66,84,107,53,212,224,177,17,124,131,20,230,102,0,25,147,246,193,23,168,22,142,79,223,75,167,45,227,212,60,190,112,40,77,109,99,75,71,198,233,35,148,61,18,179,218,80,130,12,99,43,143,174,252,134,103,18,200,180,241,220,221,7,128,47,124,34,179,194,243,173,245,188,195,16,
94,40,139,214,205,40,122,11,69,123,23,50,28,180,140,33,141,65,3,33,60,111,214,202,230,170,217,60,32,81,100,68,64,197,184,196,111,180,131,248,193,47,48,211,248,248,227,153,113,60,153,60,134,191,99,148,95,31,156,212,58,7,169,206,63,169,181,251,241,170,172,73,77,9,16,222,35,139,183,144,78,218,20,218,130,134,204,162,49,19,64,128,236,137,247,195,137,102,53,180,175,89,185,107,125,49,72,123,188,139,63,165,129,165,99,120,167,195,228,0,213,38,86,30,12,252,134,85,213,176,5,179,144,189,141,221,254,128,221,137,178,219,162,139,28,173,122,192,13,9,183,238,249,34,178,178,7,73,177,233,55,204,36,113,135,5,22,32,117,234,20,184,48,2,150,4,82,204,213,113,102,208,4,136,0,192,123,255,68,115,234,58,50,101,116,121,142,179,75,31,240,21,23,111,5,20,205,123,112,67,5,93,158,200,197,204,95,68,8,3,83,224,139,200,217,135,20,62,139,183,114,226,79,25,210,182,255,219,146,81,167,55,46,221,185,186,182,113,101,93,27,248,6,70,125,251,127,32,246,77,213,125,108,240,159,95,240,27,23,9,107,213,7,139,43,78,118,238,56,176,229,239,222,251,69,180,
29,111,222,213,252,209,227,250,159,194,81,99,197,81,131,126,212,161,255,169,60,247,199,251,162,127,160,114,161,111,86,60,166,95,224,125,40,223,156,59,110,89,241,144,229,190,229,156,195,98,9,209,138,199,114,238,152,197,114,94,59,246,139,215,152,5,121,84,188,103,16,141,87,48,156,191,189,198,241,251,199,37,57,251,76,206,130,220,223,195,241,200,121,162,120,155,179,7,106,207,144,238,246,132,215,198,10,229,103,200,114,94,40,127,152,86,50,66,249,245,187,202,207,156,38,1,18,120,34,10,143,205,31,161,40,7,0,113,16,109,135,136,40,211,131,103,160,249,222,244,107,205,1,147,234,35,56,223,11,105,156,141,133,185,248,109,206,174,31,52,134,32,22,119,247,253,192,187,203,68,7,110,157,61,69,57,150,28,131,50,167,57,251,130,247,70,202,28,41,30,64,48,58,207,120,49,228,235,156,228,85,227,189,10,99,43,92,172,66,42,156,166,174,239,209,244,214,49,222,69,42,229,140,21,162,66,5,29,209,198,183,202,166,64,199,143,37,21,110,136,101,182,167,143,94,65,211,187,202,166,194,138,223,77,83,175,113,188,119,160,233,68,153,21,191,218,134,190,
47,39,225,89,111,129,216,55,88,79,133,238,168,35,102,66,129,251,85,222,73,206,198,146,241,188,201,146,202,52,248,110,148,253,56,210,122,3,110,84,104,240,237,52,189,105,164,247,179,170,55,226,208,123,201,233,141,152,84,161,193,87,89,122,185,85,125,179,210,69,191,40,99,81,7,245,46,178,244,114,80,199,73,203,144,0,117,117,23,212,11,105,95,133,24,223,205,17,190,15,129,37,243,221,69,194,246,215,26,93,133,139,190,65,152,21,148,189,131,130,127,24,192,59,203,197,88,38,193,31,144,16,255,224,187,43,157,240,155,149,86,232,178,128,233,186,34,91,75,169,153,214,246,234,140,172,53,87,8,54,173,34,216,80,103,214,132,135,56,132,199,119,208,233,89,211,233,194,129,158,186,59,207,82,23,143,200,216,109,198,143,207,33,9,160,174,194,121,61,167,248,102,165,133,126,129,183,16,119,116,20,70,5,122,160,179,143,103,10,150,219,181,43,45,34,83,24,210,28,191,168,0,191,150,11,212,213,206,71,197,47,215,201,68,45,187,163,234,16,45,7,41,218,129,49,117,44,226,29,80,34,42,11,64,23,121,1,238,140,115,194,156,139,58,38,241,237,251,46,206,143,
78,21,168,65,255,165,30,83,113,166,131,159,41,15,184,194,70,168,117,138,63,226,210,213,110,2,75,173,156,43,158,152,240,185,10,121,42,231,9,3,9,18,113,82,31,69,24,112,95,152,19,95,154,31,251,129,56,95,54,63,231,140,203,132,211,143,249,185,112,43,249,95,199,176,98,8,49,57,248,47,92,85,57,115,144,11,167,48,179,51,89,22,26,192,188,115,81,87,12,232,225,55,11,197,148,248,7,243,149,10,121,41,25,131,247,182,46,9,249,23,249,199,40,96,190,181,130,127,144,40,68,192,167,16,140,112,41,10,254,193,28,88,20,182,193,133,167,83,89,150,176,113,249,243,75,10,196,113,201,85,242,255,22,253,11,229,147,44,248,47,132,35,142,128,37,253,235,202,231,36,8,253,99,254,74,171,228,243,191,164,255,239,99,4,87,62,76,64,215,191,206,130,16,65,185,254,185,150,248,146,141,179,88,166,127,8,31,38,32,28,131,159,132,240,97,2,101,250,215,229,83,97,191,21,252,235,198,223,194,173,128,171,88,16,15,47,40,205,252,10,251,231,41,84,178,24,128,223,198,191,96,190,210,127,94,205,63,8,105,93,50,9,181,23,236,95,112,81,76,148,184,254,33,130,34,42,188,100,5,
190,48,55,1,225,8,220,10,116,120,16,64,82,92,111,136,251,125,156,197,130,22,185,23,150,144,191,32,133,11,175,147,130,48,190,130,21,8,19,252,62,10,8,23,4,22,20,28,5,84,148,89,33,40,19,134,80,54,127,133,20,10,16,132,135,223,224,14,83,5,41,232,186,168,72,196,185,8,42,124,185,224,5,48,1,24,66,137,127,152,192,203,235,173,239,161,64,5,255,208,127,129,132,215,162,160,16,1,55,177,130,255,57,95,66,1,225,2,48,196,87,122,225,43,248,175,64,65,110,255,75,156,121,65,5,159,69,224,31,71,129,50,43,16,46,80,224,31,151,8,124,212,81,128,11,255,236,174,163,11,225,227,188,225,62,51,221,199,75,154,119,177,24,132,200,194,10,4,35,223,199,2,126,62,86,112,68,96,97,113,22,221,10,95,97,5,220,23,74,89,163,240,66,174,8,221,10,116,253,85,90,129,128,195,114,44,46,95,152,234,81,0,36,8,65,112,65,98,254,86,225,241,111,179,130,50,42,244,136,32,64,153,15,161,71,132,151,168,120,41,34,8,68,43,185,131,110,184,8,42,237,84,194,5,16,130,177,202,112,129,135,163,96,165,45,86,88,4,100,161,135,6,29,122,113,51,92,79,167,194,208,186,100,64,253,6,65,
127,240,21,118,1,191,40,27,136,248,234,93,143,17,176,17,92,94,194,72,61,70,8,31,111,160,206,217,98,230,112,122,86,247,145,2,88,34,133,168,196,75,12,1,75,105,119,225,87,48,11,198,218,46,196,12,127,193,15,16,20,163,246,219,80,179,229,45,81,227,53,168,89,178,20,206,72,65,64,133,172,65,8,104,119,126,145,146,84,162,118,185,165,232,178,16,96,81,144,136,238,47,194,94,74,216,93,136,93,194,165,75,168,7,231,2,120,137,144,45,44,133,59,155,8,217,176,148,210,252,220,210,223,228,41,252,36,119,19,24,136,169,232,38,21,158,202,77,163,160,130,215,224,69,209,89,56,255,197,192,83,154,31,227,227,126,185,189,12,47,43,240,2,156,115,18,4,106,148,91,68,37,255,124,136,215,68,77,1,22,130,132,2,255,130,132,210,252,111,211,63,56,231,35,131,255,11,156,127,221,186,117,91,20,242,21,204,87,198,11,142,20,165,168,41,48,162,34,106,87,206,207,239,199,20,130,127,240,244,189,172,17,252,131,121,1,150,133,120,1,18,138,38,80,210,127,129,138,87,100,141,152,159,143,239,43,184,128,8,22,208,194,59,243,255,182,120,241,170,172,169,60,94,240,201,11,
137,99,1,230,192,127,37,70,113,229,149,235,95,196,75,214,186,100,132,60,50,196,128,30,242,91,173,128,58,251,116,92,56,115,58,131,213,196,25,232,172,125,152,103,210,165,24,42,156,31,108,235,97,68,164,145,212,3,74,69,190,168,187,69,207,174,88,116,153,149,110,22,10,47,79,35,90,120,2,161,171,133,155,149,158,76,151,7,176,183,44,38,96,144,5,205,136,52,2,58,21,154,217,85,203,91,96,65,228,144,220,50,132,100,56,9,16,107,171,176,207,183,5,16,97,182,165,249,251,194,248,53,53,110,214,149,243,23,204,178,60,128,114,183,44,165,81,144,143,110,25,165,149,138,112,142,146,65,190,2,22,203,176,30,191,6,28,231,62,33,68,80,32,94,144,80,226,159,203,159,35,195,235,2,40,206,235,105,132,112,14,110,89,240,9,72,1,34,120,167,197,148,238,246,156,132,179,5,88,194,205,149,201,180,16,1,39,174,0,107,21,252,235,202,111,185,80,176,31,225,211,229,65,179,224,144,229,139,169,10,88,0,255,96,65,136,224,149,243,23,228,255,90,88,40,2,130,110,2,188,16,7,206,33,5,144,251,78,252,191,13,22,64,28,72,208,19,168,66,64,121,121,49,81,128,69,17,22,48,51,
68,80,6,139,239,144,52,112,21,115,100,224,252,151,81,254,110,139,105,152,61,244,207,193,153,231,10,92,75,186,9,64,10,156,255,211,88,184,241,76,142,78,227,0,132,158,206,112,118,74,171,42,228,10,101,11,43,113,127,201,242,56,155,98,64,177,155,240,214,218,91,1,79,42,199,40,30,233,88,3,70,223,117,59,170,204,195,42,232,40,205,242,210,5,130,71,78,232,251,236,241,253,168,212,20,234,104,133,29,6,78,244,15,160,169,4,98,21,216,5,253,129,177,162,12,245,163,227,47,9,160,164,169,10,239,68,115,130,174,67,161,229,134,178,123,96,151,101,32,38,198,30,228,73,106,59,146,84,164,170,220,10,168,59,86,176,74,188,63,68,124,197,39,209,252,157,24,20,145,189,88,252,233,196,87,122,88,194,9,253,91,29,130,248,137,86,25,114,160,211,49,189,176,5,223,244,139,255,27,91,79,97,197,215,209,218,134,79,179,248,6,138,163,246,140,73,207,76,91,103,241,189,230,45,176,12,112,128,229,248,240,96,172,128,40,221,69,124,130,68,65,143,240,207,2,159,112,62,206,170,83,5,119,133,146,5,52,130,48,59,216,58,97,208,177,66,142,113,22,203,28,237,141,43,157,16,
247,74,206,181,78,5,119,212,50,42,202,243,135,239,7,42,78,197,110,10,43,130,61,188,180,117,162,144,197,232,190,0,66,244,136,37,36,172,211,34,194,53,226,106,101,46,232,44,209,82,88,239,240,234,224,43,215,59,175,144,8,196,1,114,132,68,121,132,131,171,112,137,64,174,28,58,132,68,116,232,40,3,77,177,216,169,204,104,185,222,75,84,224,102,190,2,229,1,172,144,209,96,224,50,137,112,42,184,80,160,36,206,98,41,163,3,33,92,168,197,189,184,194,218,143,203,69,14,113,142,117,213,8,36,135,25,150,180,195,97,182,178,26,84,70,139,190,20,22,58,226,211,9,66,48,16,55,99,97,35,160,21,145,174,50,140,114,3,41,208,130,91,10,18,121,155,141,136,120,94,201,209,174,68,132,117,240,96,86,98,26,132,148,81,241,110,18,17,130,208,243,25,104,167,16,210,91,133,12,203,108,4,99,241,216,82,153,233,150,73,4,84,128,99,200,69,167,69,55,179,178,124,147,223,207,133,194,37,14,246,185,118,126,28,27,113,114,120,208,149,80,76,111,132,165,20,194,187,208,46,215,139,161,117,65,95,19,155,58,227,72,89,241,195,76,34,212,22,241,74,88,146,112,31,114,166,168,
189,143,67,131,48,25,225,71,157,113,46,32,17,243,116,135,42,136,9,204,160,158,14,97,113,73,117,102,10,32,220,73,103,78,71,120,54,92,12,127,5,185,137,240,39,46,109,79,65,116,37,186,169,29,119,11,209,113,101,250,146,133,226,59,196,84,166,204,87,152,148,192,222,10,243,230,78,166,231,7,93,2,89,117,97,139,81,116,195,126,85,126,184,75,136,16,160,144,94,193,201,244,251,203,212,136,147,194,170,202,160,226,21,176,3,171,214,197,5,219,42,217,38,52,241,86,39,43,19,138,230,7,236,64,28,37,147,42,166,203,111,114,178,215,74,68,248,25,7,98,112,84,52,137,18,248,9,228,41,203,120,43,168,16,128,179,75,133,126,127,153,68,4,230,20,92,29,26,227,128,84,48,35,1,59,248,74,228,9,200,155,39,10,66,41,57,25,206,181,234,119,188,30,118,42,105,17,30,6,161,148,132,90,233,240,5,237,148,23,97,95,237,100,176,145,215,75,164,224,234,229,57,116,5,21,220,18,121,92,42,216,136,96,90,120,201,46,248,189,108,35,144,200,75,225,64,148,156,184,117,136,136,32,128,24,3,21,243,233,18,16,131,80,65,14,119,240,221,245,192,46,4,130,138,226,146,130,187,164,
14,196,2,182,74,64,204,105,121,73,34,175,0,226,55,74,132,35,223,203,165,184,114,216,209,205,20,66,41,129,159,32,164,100,169,175,128,26,128,12,55,214,66,91,136,16,159,238,53,58,28,235,3,193,58,116,175,41,11,147,192,148,242,120,45,118,240,10,193,174,16,122,244,63,58,255,60,45,41,229,106,252,64,64,165,110,145,250,117,69,47,208,143,94,202,250,42,70,44,158,131,25,191,165,3,161,64,65,89,202,87,65,71,33,209,170,252,174,50,91,124,87,106,126,148,12,182,192,229,75,228,114,193,232,190,251,30,125,124,239,44,27,125,78,39,101,14,23,27,131,162,21,7,71,245,11,14,233,127,246,239,254,217,109,88,166,127,95,234,237,28,91,189,190,124,169,241,234,242,121,109,232,31,163,183,243,230,255,184,200,254,49,239,163,63,175,213,240,247,5,182,241,7,17,47,136,70,122,147,197,248,43,53,150,182,172,52,137,95,57,78,63,48,255,169,58,186,109,83,212,67,120,151,4,126,122,21,15,120,215,225,181,120,105,254,123,179,116,88,60,237,189,115,78,63,16,39,95,117,240,111,14,203,238,7,106,160,9,63,213,171,41,114,239,65,188,117,107,19,191,38,250,207,207,
254,53,158,227,235,248,200,142,135,201,238,223,223,254,228,79,189,153,252,232,95,227,151,77,240,214,214,165,91,54,60,233,55,182,41,5,54,64,64,198,252,215,238,203,118,60,131,85,191,106,255,100,137,63,75,55,49,105,199,47,159,224,217,44,82,119,26,255,20,191,36,139,38,251,210,227,3,180,89,98,124,2,63,211,114,109,115,181,49,172,13,254,5,24,191,255,175,110,177,191,16,15,96,94,40,61,64,160,243,141,78,237,255,253,252,200,90,241,173,85,107,249,91,127,230,246,60,108,71,69,250,155,153,221,255,4,182,143,227,155,191,62,231,22,255,217,250,95,11,255,217,157,154,89,138,83,91,71,150,47,109,52,166,33,114,229,47,249,204,255,211,18,251,75,49,179,86,207,167,46,62,251,169,191,48,43,255,247,93,177,209,162,204,71,183,175,74,6,211,223,83,3,196,223,23,24,32,95,160,254,47,249,251,137,170,196,139,178,240,114,162,210,155,137,240,90,162,67,120,27,150,120,15,86,3,222,128,37,222,125,85,122,27,17,30,124,237,114,240,215,92,245,137,183,91,13,136,183,74,250,197,123,38,245,215,13,225,113,12,188,107,8,79,103,36,197,195,26,120,46,23,207,110,
76,139,183,89,226,25,94,60,217,129,231,59,240,132,47,30,247,192,99,191,120,13,21,94,64,117,89,60,18,82,122,167,144,254,66,161,123,218,249,191,231,43,252,26,47,116,188,43,13,250,127,139,210,168,154,92,191,124,117,25,189,197,225,127,194,95,87,249,175,187,217,63,225,13,243,170,230,88,72,155,22,219,120,199,252,135,194,254,200,98,248,252,255,58,89,246,250,176,237,250,255,172,193,111,106,160,142,6,85,124,70,196,231,136,248,76,138,207,180,248,156,20,159,179,226,243,140,248,204,137,207,243,101,159,103,197,255,231,196,103,86,124,166,196,167,62,90,72,252,159,207,165,125,115,172,33,42,142,226,226,115,76,124,150,207,51,35,190,89,16,159,75,226,115,69,124,174,138,207,117,124,150,73,225,122,81,10,230,145,229,107,87,87,181,200,63,133,12,76,255,166,139,253,83,110,16,183,181,83,11,247,10,239,236,132,45,146,120,131,218,227,191,168,29,73,21,141,49,245,185,251,239,247,117,105,169,72,227,231,87,251,232,80,132,182,164,14,254,66,166,201,72,251,196,72,235,213,244,137,135,103,71,248,59,15,241,59,86,85,250,67,201,187,174,208,80,
156,123,95,242,206,181,245,115,155,141,171,151,87,86,241,75,51,43,119,240,148,114,241,197,162,116,180,120,85,205,228,218,198,101,252,196,71,20,191,231,181,122,105,189,236,146,221,129,46,232,231,212,141,43,151,214,175,172,118,93,217,224,87,253,127,88,232,190,4);


programfile__The_Pink_Panther_mid
:array[0..24723] of byte=(
120,1,116,189,219,87,91,89,246,239,183,11,89,5,150,192,42,48,133,141,141,133,0,9,196,253,142,208,253,6,66,2,4,226,102,48,216,6,124,197,55,92,190,85,185,170,186,26,182,182,36,11,116,126,191,129,16,194,194,156,147,49,242,146,151,188,116,183,237,110,119,247,75,110,39,39,39,39,121,75,70,30,242,146,26,184,249,49,134,243,55,164,243,89,2,87,215,239,140,228,97,51,215,101,174,181,230,252,206,203,90,123,179,176,195,211,43,183,36,73,250,82,250,66,210,125,241,127,133,167,159,62,160,214,33,253,253,139,175,166,87,110,27,34,247,86,31,24,34,203,171,207,87,110,63,149,254,62,173,94,162,83,146,254,62,119,234,84,193,249,34,233,239,19,170,194,255,210,32,253,189,93,58,30,167,254,142,113,167,47,223,187,241,116,249,206,227,213,199,21,191,251,94,42,250,157,36,57,254,27,173,254,119,133,65,253,239,52,30,253,239,22,66,250,223,93,147,254,171,170,173,126,191,106,203,57,41,159,94,119,78,150,172,247,251,139,183,92,211,210,150,117,64,174,92,183,14,20,175,187,166,229,138,45,183,95,189,101,11,200,133,235,182,128,106,221,237,175,216,178,
135,84,91,158,209,215,53,235,246,144,99,221,51,42,27,182,156,67,170,173,254,1,185,96,189,127,64,179,238,28,42,223,178,14,21,108,185,70,229,186,117,235,208,197,117,215,232,143,91,238,96,193,231,73,74,214,221,193,226,45,251,184,180,229,25,222,125,180,110,31,215,173,123,134,163,167,16,69,218,114,142,201,197,235,206,49,53,162,148,108,185,2,5,66,20,3,162,232,215,93,129,159,182,108,62,213,150,59,192,50,54,95,249,186,59,80,188,229,25,147,182,236,193,215,151,215,237,193,178,117,207,152,124,118,203,61,172,218,178,249,229,218,45,87,72,189,101,29,70,224,97,105,157,134,226,117,235,112,249,186,43,4,75,191,21,149,29,242,217,245,126,43,194,58,138,182,28,145,130,45,75,248,181,111,221,18,46,95,119,68,208,167,63,168,222,114,122,229,139,235,253,65,105,221,233,45,218,114,141,128,74,64,182,174,91,3,186,117,215,200,55,91,238,105,214,113,34,138,123,186,124,221,230,44,221,178,135,209,39,188,251,195,186,39,92,186,110,15,203,247,182,172,215,213,91,174,25,88,172,215,235,182,108,168,235,22,99,103,100,215,186,109,188,2,241,231,142,
199,12,201,231,225,47,217,242,206,23,108,57,230,245,235,158,161,221,217,117,199,124,235,186,119,94,158,62,70,118,236,5,160,54,175,247,143,49,97,0,65,34,242,169,117,107,100,4,76,238,109,185,49,134,205,139,1,41,172,219,188,149,88,6,76,34,175,219,214,237,145,82,97,29,235,150,13,22,183,87,24,48,196,186,104,99,29,195,58,99,114,197,186,117,12,76,198,100,205,86,191,27,133,109,242,153,245,126,119,201,186,211,38,240,16,184,236,254,22,76,220,2,19,215,150,19,243,244,135,153,197,233,215,172,247,135,241,20,172,97,29,151,75,215,173,227,193,117,151,239,6,246,85,159,152,7,69,221,129,242,45,15,74,219,167,101,108,60,125,119,221,51,190,223,182,229,65,20,123,228,223,141,32,156,102,221,19,82,254,207,170,45,103,88,141,233,127,90,119,134,117,88,93,135,219,96,245,17,89,183,110,29,81,227,58,114,59,88,75,91,54,251,218,186,205,174,6,238,74,44,174,65,203,221,223,8,237,212,152,254,229,150,51,80,184,213,63,206,28,129,154,245,126,22,117,33,137,117,84,174,93,183,142,22,129,146,124,26,159,0,131,97,20,116,15,171,241,7,38,192,63,236,161,
215,247,145,66,131,35,131,129,27,84,108,147,50,230,156,68,124,129,53,72,90,67,40,232,26,197,7,5,75,222,69,133,51,245,251,11,192,161,12,152,10,183,28,161,215,141,235,142,144,30,168,228,214,173,254,73,188,216,39,2,202,7,76,147,37,56,33,96,15,137,128,26,46,92,167,160,71,22,124,193,39,220,216,207,66,190,10,100,1,167,240,235,223,226,7,69,200,179,186,101,157,97,245,41,252,207,58,83,8,172,136,62,66,48,78,1,138,45,160,95,119,143,252,180,229,193,15,236,99,200,102,31,171,92,23,21,199,156,122,203,59,183,251,221,186,119,110,117,221,49,39,151,30,59,177,255,27,124,248,28,178,150,162,10,147,14,201,77,8,81,36,212,57,179,101,115,35,72,80,204,234,150,8,202,242,45,251,68,1,70,123,61,129,177,86,215,237,19,238,45,219,12,28,211,184,155,109,6,81,167,133,235,20,138,192,46,196,117,64,118,84,110,218,114,186,11,182,250,61,76,210,239,33,116,221,154,45,203,132,106,203,49,77,80,58,166,213,235,150,9,249,34,110,83,128,251,160,112,63,54,118,250,73,15,196,23,131,45,204,80,190,110,13,90,183,220,174,142,45,219,192,189,117,183,11,97,6,204,
68,82,129,240,156,123,68,83,57,222,243,111,139,168,169,17,45,249,61,162,45,210,82,133,169,10,72,77,121,115,225,22,34,115,137,208,8,33,154,43,112,78,232,87,177,229,236,195,181,156,107,235,206,190,178,245,126,167,110,203,130,81,29,222,228,221,117,135,23,107,141,189,220,234,159,192,237,253,63,174,247,79,8,115,214,111,185,60,248,158,72,117,46,79,25,161,46,95,98,5,194,203,247,146,5,8,31,95,221,150,7,201,237,145,189,230,117,15,153,193,30,201,204,253,238,165,244,242,119,63,146,141,63,167,223,211,239,73,191,106,223,242,179,103,143,165,223,127,47,233,127,79,234,253,111,13,250,223,23,174,234,127,79,234,253,253,66,139,254,247,164,94,99,218,52,243,76,54,205,152,210,245,97,185,71,230,71,121,186,193,41,23,203,13,206,210,180,121,78,121,42,243,227,90,186,46,172,172,200,252,152,72,87,5,98,33,185,42,16,183,166,77,97,89,35,155,194,186,116,125,72,190,36,243,67,159,110,64,104,185,33,80,153,54,79,41,143,101,126,44,164,235,66,49,189,92,23,82,140,233,170,112,172,90,174,10,199,151,211,38,191,44,201,38,127,69,186,126,80,182,200,
252,40,78,55,12,173,201,13,67,245,105,115,36,86,35,155,35,74,125,186,110,36,166,149,235,70,148,182,116,213,116,172,76,174,154,142,223,75,55,140,201,181,233,250,33,181,76,161,85,174,31,98,160,41,40,151,202,166,96,69,218,56,18,171,146,141,35,202,165,116,117,80,249,81,230,199,112,250,252,148,242,91,249,252,84,2,54,191,124,138,37,17,54,34,95,148,249,97,102,178,151,204,83,151,54,79,40,119,101,126,92,23,90,94,22,90,62,79,87,141,41,247,229,170,177,196,217,116,253,140,92,39,215,207,72,233,134,73,6,242,227,44,50,130,143,57,82,147,110,188,19,171,148,27,239,160,155,113,84,121,46,243,99,52,125,41,20,187,38,95,10,197,59,210,166,137,53,217,52,81,37,224,233,3,158,151,233,6,143,192,213,83,149,54,207,199,52,178,121,94,233,22,74,86,125,86,82,89,66,201,68,101,186,129,100,45,55,204,92,76,215,79,200,6,153,31,77,105,211,152,172,150,77,99,134,180,113,60,214,40,27,199,149,115,233,234,72,236,156,92,29,81,26,210,231,71,148,9,249,252,72,162,61,109,154,102,164,105,186,50,93,63,42,148,36,243,164,27,130,79,228,134,96,43,75,70,71,
89,114,223,154,54,7,162,221,178,57,32,215,165,107,109,74,179,92,107,107,78,215,249,149,54,185,206,111,77,183,134,148,110,185,53,212,155,110,246,70,111,203,205,222,151,233,186,64,244,59,185,46,176,152,54,251,163,55,101,179,95,46,100,202,232,50,115,202,167,145,33,58,141,12,178,38,93,19,138,174,200,53,161,59,233,90,151,210,47,215,186,44,88,73,57,141,133,150,211,173,163,209,89,185,117,84,62,147,110,14,40,95,202,205,129,145,116,253,176,210,32,215,15,91,211,213,1,197,41,87,7,154,211,13,254,232,89,185,193,47,187,68,211,5,154,188,233,90,175,226,150,107,189,244,13,41,95,224,27,203,233,134,145,232,25,185,97,68,14,167,91,71,148,51,114,235,200,44,114,42,131,200,137,198,99,81,79,250,130,79,45,215,179,161,200,20,210,213,83,74,181,92,61,229,79,215,204,40,181,114,205,140,37,93,235,22,51,186,171,210,198,128,2,138,1,75,218,20,80,150,210,213,195,58,153,130,81,174,30,110,77,215,6,229,171,114,109,112,57,93,63,5,66,13,190,74,185,126,42,202,242,190,154,116,139,63,246,80,110,241,235,211,45,158,168,71,110,241,128,110,147,63,
106,151,155,252,194,153,2,130,43,32,63,72,27,125,172,107,244,117,165,27,71,149,78,185,113,180,39,221,224,82,250,228,6,23,214,11,69,131,233,11,17,131,108,12,185,229,11,17,75,186,122,58,250,91,185,122,122,49,93,19,137,246,201,53,145,242,244,133,224,45,249,66,176,55,93,235,19,182,241,141,17,150,202,57,194,50,148,110,30,86,166,228,230,225,146,116,107,68,193,251,35,186,116,87,8,233,219,2,58,185,43,132,69,218,2,32,228,85,110,203,13,94,149,96,246,193,92,153,110,35,128,228,182,145,118,97,218,75,152,54,140,219,43,163,248,125,121,186,109,12,177,218,198,76,233,230,16,45,205,33,2,63,16,189,46,148,40,72,55,71,162,181,63,127,237,210,253,220,103,215,253,236,181,233,126,158,237,215,253,252,168,175,236,231,51,61,186,159,219,59,117,63,47,180,234,126,254,77,147,238,231,75,102,221,207,46,147,238,231,197,218,210,159,95,24,116,63,87,232,117,63,251,46,232,126,94,173,208,253,108,42,43,251,249,106,137,238,231,179,167,117,63,15,159,210,253,44,73,87,229,230,72,205,207,75,5,186,159,59,74,143,199,74,30,125,186,150,157,81,174,13,
232,136,162,104,49,81,212,158,174,241,8,247,244,23,203,53,30,229,107,185,214,31,73,95,28,81,110,210,82,32,83,104,163,197,44,204,122,5,179,22,167,47,204,224,162,23,102,126,76,87,143,40,85,114,245,72,111,186,102,26,31,170,153,118,48,179,176,120,160,46,109,156,137,126,35,27,103,94,166,235,3,74,135,92,31,104,197,22,202,48,118,208,224,103,98,117,111,116,54,93,61,27,253,94,174,158,125,153,174,154,81,110,167,245,195,117,50,133,175,101,253,112,85,186,122,2,240,171,39,138,210,53,67,202,130,92,51,36,165,235,198,40,212,141,21,147,16,133,15,141,148,144,20,73,119,181,17,53,34,224,76,181,152,215,24,86,122,101,99,88,143,119,42,67,120,102,125,186,33,76,128,53,132,155,210,141,151,149,113,185,241,50,152,11,230,134,145,38,17,20,87,8,10,141,240,146,110,36,43,74,215,122,112,69,207,64,218,24,97,113,35,206,81,53,174,92,73,235,199,43,100,10,236,224,227,37,34,90,150,112,158,66,34,70,228,175,81,53,78,68,87,221,104,121,186,61,130,85,219,25,213,60,66,86,107,30,41,78,155,135,163,119,100,243,240,55,100,17,162,198,56,78,212,76,144,
58,234,39,202,211,141,195,202,53,185,113,88,18,146,46,33,65,57,210,146,236,235,199,138,144,68,25,160,166,73,183,14,41,143,211,237,65,157,76,225,148,220,30,244,167,171,70,240,178,170,145,115,105,253,144,50,39,235,135,52,233,186,8,102,50,207,232,100,10,115,233,230,254,50,217,60,67,136,55,247,23,10,183,189,141,219,170,211,237,51,44,209,51,165,145,219,103,162,157,233,186,193,50,185,103,234,153,92,55,104,18,114,57,145,139,36,61,42,228,26,61,151,110,156,64,155,198,9,186,132,162,205,99,106,194,22,69,141,65,131,220,60,22,13,202,198,32,218,8,113,140,67,51,2,56,212,10,17,250,227,247,228,234,113,139,192,107,33,173,247,107,4,94,19,178,222,95,152,174,30,3,246,234,177,210,116,221,0,133,186,1,182,141,225,232,11,217,56,76,8,142,42,33,185,102,20,91,7,208,170,154,77,172,106,140,232,174,26,43,76,95,176,137,156,98,43,75,87,205,129,105,213,92,105,186,125,76,177,203,237,99,77,233,230,48,243,52,135,47,226,155,121,191,172,97,195,3,139,186,80,153,48,64,47,6,208,179,95,68,237,105,147,189,132,61,67,102,175,178,23,136,45,193,42,
118,76,29,137,239,25,121,143,252,60,78,74,50,143,199,216,247,198,112,136,186,177,88,81,186,106,0,127,174,26,72,124,147,54,113,196,151,77,78,28,41,40,182,4,126,176,73,179,123,57,197,134,137,247,179,107,142,136,133,237,98,167,253,49,93,229,195,219,171,124,175,206,164,27,166,87,229,134,233,158,116,253,128,216,104,7,228,83,105,83,143,92,46,155,122,80,124,130,244,100,156,136,149,139,184,65,225,17,172,123,254,50,65,113,254,114,130,205,125,252,7,217,52,94,67,188,200,157,196,139,92,202,130,63,178,160,137,173,61,246,165,216,218,67,98,187,252,94,108,151,163,108,237,72,95,21,78,4,211,245,211,66,192,105,53,138,201,35,104,246,83,218,60,122,79,54,143,186,210,141,243,216,159,31,211,248,115,12,59,70,216,254,46,69,72,205,151,34,137,155,98,135,43,102,135,43,23,199,144,82,113,12,105,79,55,56,216,186,28,237,98,127,102,231,153,80,110,8,104,134,129,70,185,159,174,138,176,205,84,69,18,158,116,3,45,114,195,112,241,47,187,101,121,218,212,37,23,202,166,46,61,241,23,179,17,127,138,138,68,203,126,206,143,165,244,249,9,124,255,252,
132,216,45,39,4,168,19,236,179,163,242,12,222,246,140,185,126,98,42,84,156,137,94,193,113,247,155,4,186,183,65,247,21,234,79,254,192,238,95,39,0,9,3,200,179,180,169,93,24,179,189,28,117,176,128,49,242,170,80,156,69,80,34,88,42,236,203,198,17,18,74,132,94,200,13,33,51,19,41,231,133,153,216,108,81,156,240,136,105,210,85,83,255,180,34,87,77,109,25,126,207,225,237,247,191,62,188,169,42,56,188,21,121,111,182,69,238,45,175,62,190,248,135,239,37,213,31,56,191,253,119,146,254,15,133,119,245,127,224,252,246,135,133,11,250,63,92,147,254,201,183,61,121,71,218,158,184,163,222,158,187,243,250,183,209,201,59,234,232,28,207,196,157,249,109,147,87,62,31,53,121,139,182,17,164,52,202,143,150,237,134,1,74,13,3,186,109,243,232,235,251,81,243,168,92,188,109,26,150,245,81,211,176,180,205,105,170,39,202,143,210,237,6,151,124,49,218,224,146,182,205,193,215,182,168,57,40,71,182,77,156,209,162,166,193,242,109,78,78,214,40,63,10,197,92,167,152,75,191,109,14,231,46,68,205,225,197,237,134,65,249,226,118,253,168,58,42,10,81,80,53,
109,155,124,52,25,199,24,235,203,141,70,141,99,61,219,166,153,159,162,166,153,170,109,156,120,58,90,31,188,187,221,48,36,23,70,27,134,152,103,226,245,104,212,60,33,183,139,69,26,88,68,181,205,113,235,81,180,97,50,180,109,30,145,107,183,27,167,116,81,243,200,235,150,104,227,148,28,220,54,93,125,16,53,93,29,216,198,171,155,162,252,64,162,225,23,209,134,225,86,4,122,221,135,64,242,224,118,195,156,152,123,78,47,86,179,176,154,124,106,155,131,224,197,168,201,95,130,84,185,187,72,84,185,109,186,34,23,68,77,87,42,183,235,71,132,110,35,98,166,208,79,209,134,144,80,45,122,134,153,98,59,223,131,19,114,15,119,108,227,154,246,104,125,248,219,237,134,224,90,180,33,8,79,240,117,183,0,105,68,64,89,8,15,19,13,10,145,112,179,109,54,83,41,218,16,232,218,54,79,190,158,138,154,57,66,110,55,140,203,186,104,195,120,157,48,203,32,102,185,183,109,26,16,224,14,212,111,27,199,115,51,81,242,50,32,137,153,102,154,133,81,150,49,74,100,155,99,15,150,27,97,185,209,215,95,11,203,93,217,230,132,98,138,214,79,73,232,141,9,249,113,9,89,
228,10,100,169,218,110,156,126,93,31,109,156,22,150,27,6,166,97,183,144,201,143,76,15,182,27,194,168,219,16,174,23,34,13,9,145,58,183,27,198,80,119,172,70,224,94,43,140,91,183,77,194,193,119,156,170,109,99,36,167,138,26,121,211,23,166,44,197,140,58,193,213,42,184,112,20,171,16,202,90,190,109,14,69,237,81,115,104,127,124,219,60,190,81,23,53,143,143,108,55,248,16,165,193,87,38,84,56,47,252,202,176,109,114,160,185,201,81,190,109,28,217,232,136,26,71,194,194,173,208,115,16,44,34,116,241,163,105,155,67,50,226,121,12,219,230,200,27,116,137,108,127,247,7,162,227,15,191,142,14,205,127,34,58,190,156,126,250,248,209,141,101,233,45,239,54,111,137,141,255,190,95,255,182,240,142,254,45,177,241,150,216,120,123,77,138,254,31,109,25,119,168,32,227,251,78,126,169,248,190,107,207,248,95,150,101,60,51,165,138,59,164,140,31,104,220,186,131,62,123,233,193,13,139,238,128,67,205,129,173,67,119,112,167,165,72,241,204,104,14,202,26,117,7,221,245,186,131,233,58,221,1,135,154,3,14,53,7,150,139,186,131,155,231,116,7,23,206,150,
30,76,156,209,29,112,168,57,152,81,105,20,255,203,162,3,73,146,27,14,190,149,202,14,238,22,235,14,56,253,228,39,120,212,167,59,144,60,177,72,198,55,169,206,12,190,136,122,148,193,23,106,197,55,169,202,4,214,10,50,254,169,68,143,18,88,51,43,254,169,222,204,224,76,93,38,116,91,62,157,9,172,168,148,193,153,118,37,116,91,151,25,190,37,207,43,195,183,42,148,192,74,89,198,125,211,144,9,223,217,12,41,238,155,122,216,245,153,145,89,189,18,190,179,150,9,92,43,202,132,22,42,149,145,217,2,70,202,119,148,192,181,102,37,180,96,200,4,126,84,236,121,37,13,78,221,65,179,67,119,192,41,238,96,182,223,112,240,178,87,119,160,226,169,236,214,29,180,119,150,29,112,146,59,120,210,172,59,40,108,210,29,152,27,116,7,46,83,233,193,98,45,178,163,120,205,165,99,125,110,158,43,67,113,221,65,64,167,59,120,170,213,29,232,139,138,149,192,143,42,0,128,79,138,222,62,120,240,197,49,34,166,50,221,65,75,149,238,128,99,225,129,177,171,236,96,212,42,64,136,163,239,173,213,76,96,161,70,241,223,186,154,9,222,42,87,2,11,222,76,96,209,171,4,111,
85,42,129,197,242,140,255,230,189,204,192,178,74,241,223,156,205,12,210,63,176,44,191,80,6,111,85,101,252,247,175,42,254,251,175,206,102,2,207,191,205,132,30,169,149,192,115,249,84,102,228,150,90,9,61,186,149,9,221,173,81,70,110,93,85,66,119,139,50,129,71,63,100,134,22,207,41,129,71,166,76,240,97,165,50,180,24,45,80,130,15,11,50,129,59,177,54,37,112,167,11,33,162,125,72,160,126,171,125,194,243,184,240,173,246,145,42,227,133,195,21,81,189,213,62,208,188,213,222,163,237,46,125,183,139,222,106,111,82,94,134,46,66,175,209,55,79,251,83,248,230,168,63,144,222,106,47,83,190,87,240,86,59,3,207,20,116,137,254,107,180,69,160,179,212,199,160,147,212,71,161,97,198,7,160,62,198,58,225,239,167,223,167,127,171,181,84,81,246,191,213,218,104,235,109,125,171,117,152,222,106,93,50,204,254,82,42,229,111,181,131,53,12,188,248,86,59,100,126,171,13,49,96,152,133,7,122,105,171,100,82,209,86,252,86,59,14,79,132,246,17,248,194,44,56,9,29,43,163,157,190,233,18,250,152,75,8,57,201,248,203,8,48,117,14,37,42,40,67,175,80,159,101,
157,121,214,156,163,126,149,250,60,117,161,240,66,51,84,7,0,226,97,206,101,230,94,98,142,27,8,127,131,182,155,8,127,139,242,45,232,109,214,191,13,207,93,214,189,11,189,7,239,10,244,62,124,15,24,35,0,123,4,125,8,93,165,237,49,124,171,200,247,13,107,61,102,173,167,245,111,181,207,1,232,9,114,189,160,252,12,57,190,163,253,57,50,125,79,249,5,178,252,200,248,151,140,93,131,254,192,243,35,243,255,38,245,44,227,14,87,40,222,135,170,140,239,129,70,113,69,162,103,20,223,3,67,198,115,89,149,241,175,22,40,238,112,236,220,47,113,224,181,149,253,18,240,188,197,228,125,191,176,169,52,239,174,46,83,145,226,95,45,204,251,190,8,122,109,117,89,222,149,195,149,186,3,222,102,78,252,191,244,224,39,141,238,128,183,25,252,158,100,113,89,190,126,176,84,80,118,192,107,206,65,164,77,248,122,180,47,227,95,148,11,20,255,162,153,112,150,79,19,190,114,32,19,92,157,87,130,171,139,153,208,202,61,37,180,34,207,102,66,139,139,74,104,209,155,9,173,202,197,74,104,85,202,4,111,200,103,149,224,13,73,12,10,48,72,194,243,163,67,184,62,142,
189,246,128,84,17,157,206,248,151,101,131,226,95,134,231,118,180,65,9,220,102,212,195,104,59,62,46,101,66,215,162,11,74,232,26,133,7,81,191,18,122,64,215,157,104,163,18,188,3,243,114,116,90,9,48,202,191,156,42,102,248,57,92,62,234,4,177,178,140,235,169,210,159,113,206,233,21,215,83,73,113,206,73,25,199,180,94,113,76,75,25,123,68,175,216,35,82,198,54,170,87,108,163,82,198,26,212,43,214,160,148,233,31,208,43,253,3,82,198,226,209,43,22,143,148,233,115,232,149,62,135,148,233,237,215,43,189,253,82,166,167,71,175,244,244,72,153,238,14,189,210,221,33,101,186,90,244,74,87,139,148,233,52,235,149,78,179,148,233,48,234,149,14,163,148,105,55,232,149,118,131,148,105,172,210,43,141,85,27,186,140,255,161,140,164,107,200,247,208,45,148,253,130,138,66,212,174,233,51,190,149,91,138,111,133,180,119,255,161,50,120,95,190,147,25,252,65,25,85,6,127,168,200,248,159,70,253,25,31,226,251,17,223,135,248,94,196,247,34,190,39,162,57,177,185,90,241,160,134,123,84,67,178,215,145,142,212,138,27,117,92,65,13,185,80,119,240,168,79,173,
184,80,203,57,80,156,207,137,198,46,149,226,68,61,135,167,56,191,33,44,180,170,20,7,106,218,29,197,249,28,89,214,168,82,236,168,107,235,47,38,87,150,41,182,126,233,32,132,58,86,54,144,251,53,58,197,218,35,225,55,192,196,102,66,26,84,250,59,164,131,112,37,112,181,148,226,67,37,138,5,40,250,204,5,39,190,84,162,244,1,73,175,177,32,191,111,156,61,93,162,244,50,87,143,65,125,224,86,235,112,43,141,210,3,68,109,85,106,124,173,82,105,171,74,52,229,19,110,99,161,46,63,64,236,68,98,87,226,245,155,68,174,203,43,44,121,254,205,139,204,208,74,105,102,14,224,70,127,148,117,202,220,90,129,50,250,35,217,112,37,106,200,140,62,42,204,140,63,87,103,22,214,146,43,202,194,154,148,153,191,238,80,230,175,75,153,43,215,28,202,21,188,103,14,58,7,157,189,234,80,102,175,74,153,203,11,14,229,242,130,148,153,89,40,86,70,31,117,40,51,148,167,231,29,202,244,188,148,153,186,226,80,198,159,75,202,212,21,41,51,57,231,80,38,49,192,4,116,2,26,153,117,40,145,89,41,51,126,25,158,203,82,102,12,58,6,13,207,56,148,240,140,148,25,157,118,40,
163,24,106,4,58,2,29,158,114,40,195,83,120,239,164,67,9,77,226,188,19,14,37,56,33,101,134,160,67,208,64,196,161,4,48,228,224,184,67,25,28,151,50,3,208,1,168,127,204,161,248,199,164,140,47,236,80,124,97,28,96,212,161,120,49,176,7,202,111,32,50,238,17,135,226,30,193,224,195,14,197,53,140,161,161,78,168,35,228,80,28,33,12,27,116,40,118,28,192,6,181,65,173,67,14,197,58,132,1,3,14,165,63,128,225,6,29,138,101,16,163,65,251,160,189,3,14,165,23,7,233,241,59,148,30,63,126,14,237,134,118,249,28,74,151,15,63,247,58,148,78,47,126,14,237,128,182,123,28,74,59,14,212,230,118,40,109,110,41,211,234,114,40,173,46,41,211,2,109,129,54,59,29,74,179,51,250,191,140,146,33,148,182,204,96,253,12,105,130,212,248,91,67,198,239,102,63,248,81,173,12,214,147,94,95,94,204,120,157,164,212,111,73,127,207,121,158,146,210,191,97,183,116,147,34,31,81,126,64,219,138,38,227,246,145,66,111,83,22,233,121,177,68,241,58,169,139,20,62,207,51,11,223,180,42,227,242,145,118,39,217,22,198,117,138,219,71,250,14,179,222,48,109,65,40,42,19,11,108,49,
148,253,5,138,203,7,159,183,46,227,24,100,29,87,41,177,65,218,181,151,1,219,69,197,49,72,42,239,103,235,233,99,110,66,222,54,0,237,214,9,56,223,106,59,89,171,131,122,27,79,139,58,99,245,50,190,137,178,89,173,216,6,152,179,158,178,137,167,142,167,86,147,233,239,68,78,67,161,98,245,178,77,85,27,222,106,171,104,191,72,252,116,66,207,179,102,5,242,148,83,62,203,83,202,243,21,207,25,214,40,129,106,121,78,243,20,241,124,9,223,41,104,65,248,173,86,138,222,97,175,144,255,109,83,102,108,53,250,85,38,236,44,81,198,72,180,163,19,47,149,176,211,156,25,54,6,149,209,137,202,76,176,41,160,12,27,207,101,134,58,187,148,96,83,69,102,208,91,167,12,117,150,101,252,1,147,50,232,45,203,120,67,38,197,31,40,207,120,2,117,138,55,84,201,89,161,74,241,4,244,25,199,248,69,118,155,250,140,125,12,44,198,235,51,214,209,74,197,62,166,207,88,66,23,21,235,104,77,166,55,84,169,88,66,117,153,30,104,47,180,203,171,83,122,152,171,203,251,170,240,45,71,218,183,191,62,210,126,153,19,47,124,249,35,237,227,213,219,210,59,14,181,239,56,212,254,
15,86,253,187,194,121,253,59,14,181,239,56,212,190,227,80,187,91,178,227,124,36,55,237,184,30,21,197,40,92,140,185,30,201,45,59,238,103,178,62,230,126,86,177,227,121,34,55,197,60,79,254,210,191,211,180,82,180,227,14,71,207,199,154,86,74,99,238,112,229,142,103,174,104,167,121,85,190,20,227,199,189,143,124,220,251,72,74,252,200,9,237,35,103,224,143,170,94,195,71,99,151,238,35,153,228,35,59,217,199,39,205,101,31,203,26,117,31,67,70,221,71,182,195,143,164,179,143,108,133,31,79,125,93,250,145,143,119,31,217,241,62,178,21,126,108,44,44,251,200,118,248,145,19,224,71,73,234,137,121,230,228,229,143,156,11,63,62,213,150,125,100,223,204,79,192,89,248,163,228,81,190,223,105,186,25,61,19,107,186,217,186,211,124,255,149,61,214,124,191,112,167,105,81,174,139,53,45,106,118,26,175,71,219,98,141,215,43,119,26,86,55,67,177,134,85,211,78,227,138,92,26,107,92,169,218,105,154,22,163,166,219,119,154,175,199,110,199,154,175,111,186,118,204,211,178,110,167,121,72,29,163,112,42,214,60,36,237,180,142,186,119,154,173,214,88,235,
104,111,172,217,106,216,49,123,6,118,26,167,235,98,102,79,1,139,88,98,141,211,209,82,22,82,239,212,223,145,173,177,250,59,137,226,29,243,140,124,54,102,158,145,118,154,249,229,99,140,175,75,59,173,211,247,118,154,7,91,99,173,211,35,177,230,193,194,29,115,240,222,78,99,164,110,167,105,153,149,130,3,177,198,136,124,125,199,124,89,29,107,90,142,185,99,230,203,250,157,230,197,104,240,157,246,165,180,211,114,165,240,157,246,133,230,29,103,196,88,243,162,250,157,246,27,158,85,218,30,22,189,211,222,135,222,165,239,150,234,157,246,38,116,137,250,117,218,175,82,190,98,122,167,13,223,120,167,181,201,63,188,211,122,169,248,170,222,105,253,186,119,218,1,202,131,208,128,254,157,118,168,254,157,54,68,125,152,190,145,86,6,208,54,6,141,52,189,211,78,90,222,105,167,109,239,180,151,233,159,173,124,167,157,171,121,167,157,55,188,227,252,246,78,123,13,158,235,240,44,81,190,81,199,226,148,111,211,127,135,241,119,169,223,235,121,167,125,96,70,200,46,132,101,141,111,224,127,202,60,207,232,127,206,90,47,160,223,209,255,146,
249,190,167,127,45,101,143,181,92,185,187,211,114,51,106,140,181,220,44,223,105,94,137,23,229,157,169,217,81,28,107,94,81,253,202,161,74,127,113,40,222,49,62,242,181,248,227,37,115,217,71,182,171,143,236,149,31,121,183,248,56,119,94,247,209,84,86,138,175,232,62,178,231,225,64,209,194,188,55,9,207,210,149,151,126,228,37,228,35,111,102,56,143,236,218,169,191,42,23,198,234,175,158,219,105,158,151,59,99,252,40,222,105,189,179,26,107,189,227,222,105,187,41,159,143,241,163,110,167,109,153,190,182,101,105,167,237,129,172,223,105,93,40,136,81,48,237,52,143,87,197,90,23,228,130,88,243,184,180,83,191,16,237,139,213,47,20,238,52,223,144,43,98,205,55,162,254,157,250,101,217,21,171,103,88,243,124,212,201,220,248,211,141,104,123,172,245,6,19,77,71,61,177,182,105,10,43,209,193,88,219,10,93,203,81,231,78,243,114,81,140,66,75,172,153,81,141,203,41,83,172,145,66,239,157,232,165,88,239,157,194,157,174,27,202,217,157,206,107,250,88,215,13,41,214,121,77,218,233,152,211,199,58,230,164,157,246,41,125,172,125,138,217,198,244,
177,182,49,38,11,233,99,173,33,252,199,175,143,181,248,17,192,165,143,53,187,164,157,38,171,62,214,100,101,234,30,125,172,177,71,218,49,183,233,99,230,54,105,167,161,81,31,107,104,68,9,163,62,86,111,148,118,76,213,250,152,169,90,218,49,94,208,199,140,23,164,157,186,114,125,172,174,124,99,149,56,122,66,24,233,64,100,21,64,228,31,118,218,110,43,213,177,182,219,93,232,47,160,91,5,76,10,177,214,85,217,186,83,255,80,177,199,234,31,86,236,52,255,160,156,253,200,59,227,71,222,23,79,18,131,238,35,239,138,216,210,144,79,12,194,150,188,47,230,147,3,47,201,31,167,235,74,98,205,63,32,239,53,117,222,174,47,12,154,88,19,250,54,206,149,127,172,208,107,98,141,232,108,158,82,99,239,210,143,150,139,69,49,51,186,55,140,21,126,228,61,249,227,205,115,69,177,6,48,168,15,21,126,252,254,107,221,199,11,103,139,98,245,96,97,242,107,62,218,191,18,73,70,29,51,129,137,209,165,249,120,246,180,14,215,80,199,140,96,83,103,213,224,43,229,177,58,240,169,5,159,90,240,169,1,159,26,240,49,128,143,1,124,170,193,167,26,124,244,224,163,7,159,
75,224,115,9,124,170,192,167,170,60,122,59,239,103,1,93,89,222,17,133,82,66,105,206,239,255,207,149,157,238,23,202,232,78,87,157,43,214,253,194,188,211,225,236,141,117,213,153,119,218,28,237,177,14,103,253,78,235,80,107,172,205,97,216,105,30,104,142,181,14,233,119,26,7,154,98,205,3,53,59,13,65,115,172,113,160,110,167,126,192,16,107,8,214,239,24,135,176,207,128,105,167,54,80,19,51,14,89,118,106,156,149,177,218,128,117,167,26,90,227,12,196,170,157,255,126,110,199,249,61,121,219,249,189,126,199,245,19,190,201,143,190,29,247,247,36,117,247,247,234,29,207,154,236,141,121,214,254,247,186,29,251,90,92,191,99,117,84,198,236,107,173,59,22,95,93,204,234,104,223,233,117,213,197,44,190,174,157,30,111,77,172,215,213,190,211,53,80,25,235,241,118,237,116,248,43,99,93,3,29,59,237,195,21,177,14,191,101,167,53,112,46,214,62,76,198,29,172,140,181,6,186,118,26,71,75,73,109,93,164,182,178,88,227,168,99,167,126,184,144,212,230,216,49,186,203,98,245,195,223,196,140,238,184,234,29,251,211,187,95,239,79,133,63,177,63,157,246,
63,126,186,250,56,240,116,121,85,122,207,6,245,158,13,234,223,59,244,239,11,175,234,223,107,46,234,223,243,27,229,247,98,131,42,203,58,239,201,21,89,215,242,76,220,121,47,20,119,17,144,89,247,11,185,53,238,126,161,203,178,63,21,198,61,79,254,227,111,179,190,80,244,124,220,23,170,200,250,195,175,166,179,131,87,206,197,253,97,217,144,13,132,43,227,131,87,228,223,196,3,225,178,108,232,202,102,56,30,186,162,202,6,173,114,48,30,180,22,100,3,51,242,79,241,192,204,197,172,127,84,57,159,245,5,29,113,255,168,20,247,5,165,172,215,171,207,122,156,133,113,175,247,92,220,227,148,178,110,171,35,238,182,22,102,93,157,189,113,87,103,97,214,217,212,27,119,54,149,102,29,53,205,113,71,141,148,181,87,57,226,246,42,93,214,122,118,36,110,61,251,170,246,253,23,5,133,239,191,248,162,232,253,23,82,229,251,47,84,148,37,75,214,179,118,43,238,89,51,103,253,107,183,178,131,107,37,113,255,218,72,214,255,29,18,174,53,101,125,107,250,184,255,187,222,184,111,77,13,223,50,124,149,180,69,59,105,168,164,65,214,211,146,232,203,250,7,127,
140,251,7,77,217,192,21,89,202,6,7,213,241,192,149,0,106,232,227,193,193,214,236,96,88,135,54,61,89,255,21,93,124,48,60,16,247,95,169,204,14,222,139,14,197,7,239,149,100,253,183,21,99,220,127,123,163,46,235,236,183,100,93,0,227,236,103,122,87,56,146,117,118,180,102,93,193,145,184,179,35,106,141,187,130,93,112,232,179,46,127,80,112,188,136,187,252,234,172,115,208,10,135,62,238,28,236,200,122,253,38,152,220,113,175,63,250,101,214,203,111,251,96,45,139,123,67,47,179,142,241,66,184,239,197,29,227,149,89,238,17,149,199,109,206,127,30,201,122,38,165,44,215,39,178,54,62,104,198,109,195,154,172,39,88,158,181,93,46,200,250,199,212,113,203,68,93,220,19,140,196,109,151,165,184,168,123,184,171,146,117,76,168,179,131,163,229,89,31,159,241,227,131,163,165,113,199,132,38,27,192,42,254,73,85,214,25,44,140,251,198,190,141,7,160,212,227,78,126,127,145,117,142,23,103,3,19,40,57,25,136,7,38,52,113,231,184,154,78,71,214,25,46,204,6,70,105,31,151,79,199,3,163,170,236,96,80,23,119,134,165,172,47,160,206,58,38,11,226,254,241,
111,227,190,64,97,220,49,169,206,218,38,164,172,103,180,8,103,40,140,15,6,101,77,220,67,193,54,129,157,70,11,178,22,6,217,102,113,185,112,20,151,11,27,226,182,89,56,167,53,113,209,193,119,192,172,109,101,49,238,159,214,197,61,51,117,113,219,138,188,150,181,76,154,153,238,92,214,54,126,39,110,27,239,138,91,16,222,22,129,121,4,15,24,46,142,123,70,126,98,133,103,113,255,176,38,110,139,104,208,86,149,117,68,138,179,131,195,209,10,52,68,134,97,85,220,17,41,207,250,167,48,192,80,105,54,48,37,87,198,253,83,229,241,192,20,74,12,45,211,81,148,13,140,73,89,231,40,206,31,96,132,127,170,42,238,28,69,187,80,97,214,17,6,196,201,232,165,248,224,164,134,200,40,201,122,198,10,178,182,64,81,220,17,6,122,62,242,198,61,99,26,22,151,79,83,19,189,234,184,45,80,152,181,140,166,10,179,222,8,74,15,75,113,11,138,187,192,190,55,82,9,119,180,56,238,141,168,179,93,147,234,120,47,122,184,198,138,65,164,36,206,93,171,167,160,81,195,208,226,184,107,226,28,220,58,70,234,178,61,225,98,24,53,217,142,186,162,120,215,100,65,182,107,74,29,
239,9,107,226,93,136,221,222,174,143,119,212,85,102,91,77,21,241,246,246,178,108,115,115,105,188,213,116,46,222,220,236,200,214,123,202,227,245,158,194,172,177,79,19,55,246,165,240,205,171,72,126,247,86,220,118,87,19,119,93,45,202,186,38,139,179,222,137,91,113,215,36,126,55,33,123,178,94,172,231,186,170,92,142,123,39,207,101,173,163,106,184,48,239,4,161,56,170,195,121,8,83,196,240,140,205,3,167,132,34,242,29,140,80,146,117,92,81,58,226,142,43,51,104,82,142,53,228,89,84,105,206,58,6,138,227,142,129,146,172,221,80,151,181,134,43,226,214,176,42,110,55,224,194,131,229,113,203,96,105,182,215,161,139,247,58,6,178,61,6,71,188,199,144,189,158,117,253,88,46,2,180,135,0,173,138,187,126,148,207,254,205,227,214,252,205,227,44,250,155,100,83,255,205,211,163,249,155,212,90,248,55,143,9,170,87,255,77,58,207,115,150,178,174,232,111,158,98,168,22,158,211,208,211,180,23,105,178,254,159,168,127,9,191,26,79,249,30,158,83,204,165,162,94,80,254,55,73,37,202,240,169,5,143,24,67,191,150,190,51,208,82,218,191,166,159,249,61,
85,80,3,79,29,229,122,218,27,225,109,134,175,133,182,54,218,58,104,235,166,220,75,185,31,106,71,86,23,212,77,187,39,122,255,189,246,183,245,239,181,63,21,191,215,254,70,243,94,251,163,238,189,246,135,146,247,218,239,161,47,121,190,227,249,182,244,189,246,5,109,207,11,223,107,159,81,127,90,244,94,251,4,250,13,245,199,208,85,158,71,60,15,105,127,0,189,207,115,143,49,43,231,222,107,239,82,190,195,220,183,161,183,244,239,181,55,161,55,170,222,107,151,13,239,181,75,208,197,202,247,218,235,166,247,28,54,223,107,175,214,189,215,46,240,204,195,119,165,230,189,118,14,58,11,255,101,158,153,139,239,181,211,204,63,85,241,94,59,9,157,96,92,132,121,199,89,99,172,252,189,54,140,44,163,240,141,240,12,151,189,215,134,160,65,158,33,158,0,125,131,232,54,192,227,167,207,167,126,175,245,210,238,161,221,77,155,139,178,147,57,29,212,237,212,109,170,247,90,43,229,126,218,44,212,251,40,247,82,238,97,92,55,229,78,202,29,208,118,250,218,40,183,82,110,134,54,209,223,72,217,76,123,3,245,122,202,70,218,234,40,215,146,162,126,194,
29,191,167,110,224,169,134,231,18,253,23,41,87,210,127,142,114,57,109,101,148,117,180,105,169,23,81,86,211,118,138,178,74,249,175,123,222,243,74,234,202,58,127,146,237,89,215,90,71,220,249,83,36,238,90,19,59,228,79,114,93,220,253,19,46,180,38,95,199,49,255,197,254,158,77,248,253,175,55,225,47,197,141,90,213,212,242,75,233,143,108,191,127,100,251,253,31,61,250,63,22,46,234,255,200,251,225,31,121,63,252,163,248,165,199,23,187,110,95,244,81,130,87,251,93,207,180,114,229,144,99,205,33,47,121,135,124,247,63,52,118,149,30,114,212,57,228,91,255,33,103,183,67,206,225,135,53,151,202,14,57,135,31,234,202,117,135,124,223,63,228,232,125,200,39,166,195,25,85,233,33,223,157,18,158,105,121,145,138,238,176,136,14,222,252,14,57,184,29,242,86,120,216,222,9,131,39,86,189,235,243,71,171,19,62,127,213,174,63,242,234,66,194,31,41,219,245,121,229,206,132,207,171,218,245,4,163,45,9,238,168,237,122,35,169,206,93,247,112,115,194,27,121,70,247,197,132,155,187,182,187,254,203,58,216,98,53,135,26,119,201,33,191,141,57,228,77,244,
144,195,230,33,111,160,135,188,48,28,94,50,151,31,114,192,60,212,86,31,175,203,33,17,25,74,15,121,251,204,203,211,243,165,238,144,235,36,8,170,73,248,47,203,223,28,126,33,149,28,14,159,42,205,107,193,111,44,14,249,64,150,215,148,95,70,32,108,194,181,235,153,149,207,32,104,121,130,130,180,59,232,41,69,224,145,93,255,120,125,98,208,51,187,235,241,151,36,252,227,119,118,189,163,117,9,143,191,124,215,55,219,155,240,142,202,195,9,223,172,106,87,156,100,18,174,229,248,183,187,36,36,195,174,223,91,152,160,80,144,240,123,153,104,226,91,102,45,78,8,234,25,86,51,233,234,174,119,204,156,240,12,23,236,250,158,116,36,188,99,242,74,194,247,68,179,235,185,165,252,54,225,185,149,52,238,58,103,66,187,174,203,134,132,115,38,106,74,184,46,155,119,157,174,240,174,235,186,45,225,116,69,89,231,122,251,174,115,204,187,235,154,237,72,56,185,220,148,112,205,194,17,14,236,186,174,86,36,156,225,27,187,222,1,221,174,199,171,75,184,174,34,134,247,70,194,59,32,143,239,122,87,20,223,174,107,186,50,225,93,121,153,112,77,107,118,29,
11,171,9,199,66,213,174,237,230,106,194,118,243,159,221,187,158,144,16,125,172,56,65,225,98,194,63,38,151,239,14,206,203,181,137,193,249,242,221,64,248,73,34,16,150,251,118,3,195,3,137,192,240,203,221,192,44,234,5,102,11,119,7,3,114,211,174,127,232,92,130,194,169,132,127,136,165,195,200,196,181,200,93,255,172,172,75,248,103,163,190,93,207,130,28,0,201,130,132,103,33,90,186,59,56,7,180,227,209,138,196,224,156,180,27,24,137,46,36,2,35,20,22,162,214,68,96,1,192,230,163,227,44,42,237,250,167,163,246,132,127,154,194,66,234,124,194,79,151,247,70,180,33,225,189,161,217,117,221,81,206,238,58,221,197,184,135,238,176,217,161,74,184,238,72,9,167,91,218,117,56,138,15,249,150,159,112,56,36,92,70,218,181,91,139,241,239,178,132,221,42,29,158,233,145,118,109,184,17,31,51,18,54,139,116,56,216,46,237,242,125,246,240,78,139,46,193,247,89,220,74,218,237,199,117,203,26,75,18,253,157,210,174,165,189,224,144,223,123,225,210,37,9,11,188,125,45,5,135,139,181,120,139,65,147,232,107,145,118,123,27,213,135,124,252,56,12,87,106,
18,189,141,210,110,79,131,250,80,184,161,169,76,147,232,105,144,118,187,141,106,220,177,20,119,44,74,116,27,165,221,174,154,194,67,222,101,15,191,149,138,18,93,53,210,110,103,117,33,238,121,46,209,89,45,237,118,84,233,19,29,85,210,110,251,5,125,162,253,130,252,20,119,213,29,234,139,116,135,124,40,65,64,225,162,175,90,176,159,92,140,241,212,4,205,3,226,69,158,223,245,206,43,19,9,239,60,230,28,255,97,215,115,93,151,112,140,47,38,60,215,229,25,48,87,174,129,55,206,57,31,237,4,43,125,194,53,255,25,35,189,192,7,108,10,242,57,192,107,43,17,248,128,77,1,152,149,29,170,122,53,2,31,176,81,231,67,174,189,83,35,240,1,27,117,62,252,22,90,53,39,248,20,130,89,9,120,105,78,240,41,60,193,171,232,4,159,194,124,30,145,12,69,39,248,104,242,225,90,115,73,125,130,79,37,81,168,62,193,166,146,244,161,62,193,69,67,222,41,61,188,121,78,117,130,77,113,30,87,93,185,234,4,163,226,67,17,193,29,165,42,176,210,231,115,147,8,123,190,21,28,158,61,93,122,40,66,159,15,79,249,240,23,48,242,237,96,150,60,85,76,103,217,33,191,161,61,60,133,
145,68,248,243,91,220,195,39,205,165,56,134,46,15,4,251,229,223,91,118,221,227,241,151,135,124,4,195,175,116,248,146,200,145,34,253,232,15,249,86,5,54,122,48,41,19,62,132,255,232,242,57,83,164,163,178,198,210,188,238,124,195,192,71,88,211,160,59,241,141,178,19,159,248,117,14,45,69,54,117,194,61,174,65,54,229,236,33,95,200,242,121,84,56,135,72,176,66,9,161,140,80,138,151,221,124,2,230,55,204,200,44,156,175,248,208,101,42,203,231,64,33,196,108,191,200,181,242,127,113,115,215,57,27,175,216,117,4,116,9,231,236,179,93,251,87,238,132,35,96,222,229,125,48,97,255,170,126,215,210,215,149,176,58,76,187,189,214,186,132,165,175,126,183,199,167,79,244,90,77,187,93,3,85,137,30,159,121,183,195,127,49,209,53,208,186,219,30,170,74,240,110,184,219,58,84,154,104,15,57,118,155,67,154,68,235,80,32,209,28,42,218,109,12,88,19,141,129,120,199,31,217,126,254,248,235,237,231,11,149,120,7,60,254,181,123,248,197,115,233,79,108,66,127,98,19,250,15,118,253,159,184,149,242,39,54,161,63,177,9,253,137,77,40,251,155,215,157,35,210,235,
254,7,242,228,191,72,75,242,131,87,157,35,117,175,250,31,72,175,187,102,164,215,214,101,209,186,38,87,188,178,46,255,240,170,107,102,238,95,248,13,241,206,79,175,199,31,42,109,175,195,102,199,171,241,135,77,175,71,61,250,87,97,115,221,235,225,112,213,171,81,79,221,235,96,228,226,171,225,112,221,235,161,153,202,87,193,72,221,235,193,169,115,175,134,102,76,175,253,99,149,175,6,167,234,94,123,35,231,94,249,199,12,175,61,80,111,196,252,218,53,94,241,202,19,105,126,237,240,86,188,114,141,91,94,219,251,74,94,57,188,173,175,236,125,255,193,250,89,54,151,144,109,237,63,151,141,214,53,185,233,68,182,1,100,59,60,255,39,160,248,211,175,161,40,89,16,80,140,63,127,254,120,245,222,212,237,31,164,15,64,241,1,40,254,39,167,254,67,225,19,253,7,160,248,176,208,164,255,32,246,227,142,156,184,128,144,228,2,66,206,255,82,121,122,68,46,59,98,171,59,98,171,59,194,37,143,248,188,117,68,232,31,241,177,245,136,61,249,8,119,61,226,131,235,17,151,14,142,112,223,35,92,226,136,95,245,28,225,210,71,124,3,57,226,210,65,146,75,7,71,
226,210,193,17,151,14,142,184,116,112,196,158,156,159,0,231,61,98,79,158,201,137,11,7,201,193,23,69,185,0,239,160,201,192,154,44,229,184,97,96,79,114,179,32,39,110,22,36,135,111,5,115,225,59,41,117,142,155,4,201,240,29,185,48,199,53,130,228,200,108,244,108,146,235,3,57,113,125,32,47,42,199,135,35,66,228,136,16,57,226,250,192,17,199,136,35,174,15,28,177,75,31,113,125,224,136,227,196,17,159,131,142,56,82,28,145,70,143,184,62,112,68,104,28,17,26,71,53,151,142,37,227,250,0,42,232,142,56,94,28,225,241,71,92,31,72,114,125,0,85,224,227,250,192,17,161,145,215,205,84,166,59,34,215,30,113,125,224,136,29,251,136,115,11,234,196,11,114,92,31,200,113,125,32,201,245,129,28,215,7,146,92,31,200,113,125,32,201,245,129,36,215,7,114,92,31,200,13,44,171,146,92,31,200,113,125,32,41,174,15,36,185,62,144,227,250,64,82,92,31,200,113,125,32,199,245,129,164,184,62,144,227,250,64,146,235,3,57,174,15,36,185,62,144,228,250,64,142,235,3,57,174,15,36,185,62,144,227,250,64,82,92,31,72,114,125,32,39,174,15,36,185,62,128,16,209,62,36,
40,207,121,31,122,63,104,127,44,252,192,231,222,15,218,71,69,31,180,119,11,62,104,111,83,190,74,249,50,237,17,232,176,250,131,118,144,178,155,118,11,245,78,202,77,50,141,150,226,15,218,254,142,15,90,171,254,131,214,94,241,65,235,104,253,160,117,221,248,160,245,85,126,224,215,254,71,146,19,219,246,74,31,180,3,234,92,87,67,193,145,212,65,221,92,120,36,233,105,27,164,92,94,152,115,61,20,246,167,30,48,31,73,167,152,115,8,190,47,53,71,210,25,218,203,224,173,82,125,208,134,212,71,82,45,109,13,212,27,105,111,134,127,152,122,27,245,118,234,93,140,27,161,222,195,211,71,155,133,49,163,140,177,81,183,83,119,208,63,166,66,30,234,46,234,238,146,15,218,113,214,241,84,161,32,178,79,212,125,208,78,245,36,187,26,164,36,242,124,208,206,152,224,99,94,27,96,204,106,144,145,185,58,169,55,49,207,92,65,174,235,44,115,229,245,96,157,43,244,93,96,206,175,152,251,12,99,231,177,243,87,212,203,224,93,160,175,130,113,23,40,95,101,61,61,60,38,234,121,61,24,123,141,254,102,218,90,233,191,78,191,208,165,131,177,93,180,117,83,22,216,
45,81,183,80,239,167,110,163,108,135,58,225,191,81,124,44,163,199,240,65,123,171,12,163,93,252,160,189,131,45,86,244,201,174,179,244,223,211,160,11,243,59,25,99,101,76,15,115,221,167,44,244,104,165,252,128,57,27,79,116,51,193,47,120,107,165,92,87,33,242,155,232,35,126,143,229,132,119,149,49,45,180,181,51,190,3,222,111,208,95,200,216,75,189,143,62,43,60,79,40,231,241,166,238,160,236,2,227,103,200,232,161,238,166,238,97,220,115,240,126,161,251,160,253,22,188,191,3,247,239,13,31,180,63,104,146,93,133,229,56,33,245,181,114,120,203,144,27,126,225,43,77,208,122,124,71,133,108,6,234,122,53,182,160,237,60,107,95,40,193,55,40,27,40,55,8,28,85,73,175,232,19,24,118,67,133,206,110,250,60,194,201,11,115,189,213,2,15,93,178,75,53,151,236,173,118,192,43,247,209,81,69,135,98,19,22,166,165,72,120,41,189,79,114,14,234,174,135,229,185,142,106,70,52,44,39,29,140,236,168,86,229,108,15,43,114,109,221,119,147,109,221,229,73,219,195,72,206,247,32,122,62,233,123,80,151,243,175,198,42,127,73,50,156,231,126,201,137,252,18,42,159,
88,184,155,145,207,5,220,205,72,114,55,35,159,88,68,110,228,110,70,62,79,240,11,169,35,142,78,39,201,165,244,136,119,151,35,206,4,34,55,222,57,226,94,198,17,123,235,17,239,18,40,20,29,204,113,47,163,56,233,95,212,229,196,189,140,36,63,34,185,224,234,90,50,184,218,145,227,94,70,82,220,203,200,113,39,35,201,221,140,156,184,151,145,11,222,208,36,41,156,78,114,47,67,12,10,48,72,34,165,68,135,200,41,34,181,62,32,179,70,167,115,220,203,208,39,253,203,164,10,238,101,36,185,151,65,2,137,182,147,60,72,186,220,203,72,114,47,35,39,238,101,36,185,151,145,19,247,50,146,220,203,200,137,123,25,73,238,101,48,60,133,92,203,231,64,54,234,4,209,178,156,235,105,244,122,146,59,25,57,231,140,62,233,156,145,114,142,73,125,210,49,41,229,248,5,99,210,62,38,229,108,195,250,164,109,88,202,89,135,4,128,234,36,191,179,206,245,251,53,71,34,91,115,201,33,201,95,136,229,44,30,77,30,80,85,175,58,201,93,141,92,159,163,56,159,181,7,219,85,73,238,108,228,122,251,139,243,153,251,146,89,149,228,238,70,174,167,183,248,136,247,58,54,31,85,
178,167,87,202,117,99,4,50,120,178,187,83,98,127,193,201,193,17,176,147,93,109,18,128,75,185,78,50,62,25,61,217,217,36,229,58,234,11,242,251,80,145,166,36,217,81,47,229,218,235,10,142,56,160,145,225,75,146,237,117,82,174,173,154,64,149,170,146,109,213,82,174,181,74,159,108,173,146,114,45,231,245,201,150,243,82,174,185,92,159,108,46,151,114,77,165,250,100,83,169,148,107,44,209,39,27,75,164,156,89,163,79,154,53,230,252,46,193,89,41,191,123,8,99,139,141,81,200,249,155,166,50,118,32,177,43,9,251,190,250,34,39,238,144,96,20,176,124,232,22,134,249,130,138,66,234,94,211,231,184,67,146,228,14,73,142,59,36,73,113,135,36,39,238,144,36,185,67,146,19,119,72,114,62,96,230,14,73,210,7,212,94,160,246,2,181,7,168,249,195,206,156,27,168,249,235,205,156,107,72,159,116,1,179,211,143,73,128,215,225,193,36,192,106,119,96,18,224,180,245,99,18,96,180,246,234,147,86,224,235,239,212,39,121,191,200,89,218,244,73,75,27,240,55,233,147,125,64,213,91,175,79,246,2,81,79,157,62,217,3,52,221,213,250,100,55,176,116,1,75,23,176,116,2,
75,39,176,116,0,75,7,176,180,3,75,59,176,180,1,75,27,176,180,2,75,171,102,251,113,46,240,131,148,155,91,83,231,70,191,85,231,252,208,225,53,185,48,73,33,25,248,161,56,57,188,86,146,28,253,182,32,57,183,38,59,142,60,164,18,190,110,17,222,132,184,72,145,45,80,82,170,167,90,164,4,210,64,133,230,200,115,150,182,50,245,17,95,165,142,164,82,250,74,233,99,43,241,148,73,185,133,53,234,88,124,116,141,58,34,13,255,68,253,107,41,55,254,109,65,110,104,13,254,115,212,207,51,254,2,244,34,244,18,107,84,195,91,3,53,82,111,160,189,137,185,91,89,71,164,106,100,240,244,208,223,75,189,143,241,22,248,250,105,183,194,99,163,47,159,10,89,223,77,57,159,6,55,22,146,163,107,82,114,136,103,252,91,41,57,252,147,148,27,243,57,146,99,62,41,23,118,59,146,97,55,194,217,139,147,11,107,29,201,81,187,148,27,233,119,36,71,176,197,112,175,35,57,140,45,66,157,142,100,8,91,4,219,28,201,32,182,24,106,118,36,135,154,113,150,6,71,50,208,32,229,6,141,142,228,160,81,202,13,212,56,146,3,53,68,228,37,71,210,127,73,202,249,46,56,146,194,245,189,231,
200,125,231,240,137,179,142,164,0,194,253,149,35,233,254,10,159,40,113,36,93,216,196,121,218,145,116,158,198,39,190,116,36,29,95,226,19,42,71,210,174,138,254,111,102,178,115,244,114,110,60,168,202,5,231,11,114,131,51,42,142,91,202,143,31,180,191,173,33,119,147,211,191,231,249,142,71,228,247,103,165,31,180,79,201,231,143,121,30,177,55,61,224,156,112,31,122,151,190,219,60,55,139,9,117,246,191,37,202,215,165,163,175,93,240,47,148,112,150,20,251,109,9,7,52,232,84,9,225,0,29,135,103,68,119,244,168,15,254,64,49,7,54,168,143,54,167,72,1,148,173,148,57,123,182,119,194,219,94,114,52,216,14,109,42,33,231,66,235,233,171,41,33,53,80,190,196,250,149,197,28,238,24,83,65,123,89,49,135,60,202,58,145,42,160,218,98,114,50,148,253,239,126,13,252,167,216,95,12,208,130,146,124,152,138,179,156,239,66,233,17,223,151,242,121,154,111,76,71,226,140,199,235,14,231,217,178,252,97,144,207,74,71,188,14,229,243,246,131,47,56,255,72,205,201,193,25,137,163,104,83,50,56,175,73,142,7,163,147,228,114,221,145,96,228,157,46,31,251,143,250,
96,244,200,219,17,0,78,89,115,163,227,250,220,8,185,117,104,74,157,27,123,16,111,103,131,68,216,95,192,85,3,28,167,176,231,180,61,85,147,35,41,127,131,98,143,169,63,42,224,116,203,166,251,128,242,61,53,32,210,119,87,77,14,5,252,60,232,42,114,40,229,101,53,39,95,250,22,225,187,174,6,80,198,92,165,60,95,192,65,149,242,21,202,179,106,14,243,240,204,168,217,115,24,51,77,219,164,10,80,41,79,168,0,20,42,12,51,198,218,163,5,128,202,184,97,234,193,2,54,57,202,129,2,94,0,160,3,106,78,209,240,250,84,71,211,117,80,143,10,112,161,46,14,16,6,168,93,69,94,134,18,45,190,11,172,71,4,173,86,64,187,213,228,101,198,119,22,0,48,180,173,128,253,15,218,162,6,59,250,27,213,0,13,101,227,31,62,197,120,147,138,131,55,180,142,121,37,104,13,178,84,243,8,163,87,65,47,240,156,231,57,199,243,53,79,57,14,87,6,45,229,209,241,156,225,41,46,73,14,77,21,36,71,30,8,103,80,39,199,30,112,202,61,205,248,34,250,190,228,81,51,70,229,248,160,149,100,137,151,21,97,233,227,68,46,94,88,78,54,230,134,228,232,248,220,7,94,177,62,252,250,21,235,107,
61,175,88,69,190,229,231,207,111,63,189,183,44,253,153,55,172,63,243,134,245,31,33,133,107,250,63,243,134,245,231,133,235,250,63,243,39,16,141,123,181,213,229,27,181,213,202,232,94,203,120,241,94,173,171,104,3,186,193,95,34,14,238,213,94,162,231,146,226,163,85,77,175,142,86,53,189,202,212,231,49,190,189,150,160,134,94,205,6,148,222,232,165,189,218,179,140,57,43,171,247,106,249,53,122,109,157,98,163,155,130,171,100,175,101,184,124,163,101,88,113,126,158,150,89,92,42,90,75,233,85,137,158,137,207,61,98,193,210,189,150,144,138,158,210,141,150,144,232,49,48,137,1,81,90,134,85,162,23,126,209,171,12,237,213,94,160,231,66,180,246,100,29,185,148,66,241,94,203,68,17,221,197,27,45,19,98,193,26,88,106,148,105,122,36,36,22,226,72,72,172,44,125,94,208,182,215,18,40,18,227,54,160,98,218,177,95,45,24,60,233,9,230,123,88,48,143,74,244,194,158,61,82,190,97,143,200,229,123,246,101,22,28,41,218,128,110,180,240,231,64,159,7,195,235,210,160,135,128,6,136,66,162,231,24,210,81,122,254,149,238,161,207,61,160,46,196,31,62,17,
127,56,106,160,65,72,44,159,223,171,173,165,80,43,208,16,122,0,103,94,143,97,101,248,179,61,196,180,5,136,82,70,79,129,16,229,242,94,237,121,216,206,43,118,122,176,225,200,137,13,71,162,198,207,211,86,236,213,90,97,177,230,205,92,180,215,18,22,198,199,9,194,2,132,207,216,218,199,80,149,223,78,238,217,239,192,18,44,222,128,130,160,176,119,61,131,235,229,139,39,188,2,237,188,184,136,17,194,222,33,165,255,179,102,158,255,172,71,104,118,60,248,244,103,22,97,120,161,21,107,140,48,120,228,23,103,137,182,125,230,21,230,165,123,248,68,202,97,225,1,199,6,105,216,179,251,145,210,47,159,217,179,79,29,43,2,21,138,0,110,222,125,162,176,12,193,194,159,233,236,217,231,142,241,135,10,223,251,197,50,40,253,175,128,250,245,252,39,226,158,136,16,58,17,33,36,124,239,88,17,176,60,246,122,97,121,224,14,158,192,29,20,34,232,209,76,47,166,251,87,61,255,106,112,21,44,85,194,156,130,37,116,50,56,244,107,17,78,124,14,21,23,117,176,168,55,160,160,28,197,57,142,69,64,184,227,133,132,151,48,203,208,201,44,67,66,197,227,249,133,151,
224,150,193,19,183,12,254,35,210,197,24,60,11,140,242,158,53,20,109,220,179,251,0,204,39,23,238,217,199,41,140,43,227,184,61,182,245,151,225,250,184,152,31,105,143,101,202,221,221,227,210,202,70,227,28,248,55,222,167,112,63,106,218,51,14,168,247,236,3,186,13,232,134,125,64,62,189,103,188,67,195,101,26,238,208,112,153,144,108,89,209,48,1,209,177,162,97,70,97,161,252,130,107,39,235,161,152,249,102,249,134,153,191,97,219,179,95,101,225,155,44,124,149,133,111,226,62,173,83,229,27,173,83,24,179,245,41,133,167,12,54,94,45,223,48,94,37,84,204,194,3,8,71,232,70,203,178,110,207,28,102,146,112,249,158,217,14,181,67,241,51,179,75,102,196,40,35,70,9,226,86,100,110,189,95,185,215,58,0,29,160,14,7,207,94,107,55,180,91,190,180,103,156,134,147,139,115,123,230,21,160,95,81,111,64,17,187,242,255,111,238,218,61,227,18,35,150,100,20,156,209,236,25,111,161,224,140,102,195,120,11,123,218,175,99,128,7,52,92,71,243,7,34,151,16,44,226,31,176,216,179,207,82,152,37,112,237,215,73,3,15,72,42,215,73,42,15,162,125,123,118,18,151,
61,72,102,61,198,155,240,108,89,165,114,21,33,86,1,243,170,192,206,11,139,23,17,237,51,20,102,148,110,82,19,178,138,238,101,193,134,179,89,39,164,61,35,189,208,13,227,140,124,234,179,93,23,152,9,200,86,8,237,171,64,182,34,102,3,9,140,70,208,131,179,125,138,193,230,235,160,118,93,62,203,148,210,158,249,22,33,186,42,109,152,111,97,164,78,204,104,198,182,198,121,245,6,229,13,202,27,198,249,216,18,126,202,216,69,12,183,2,247,10,9,227,120,214,159,78,180,144,187,246,204,215,152,244,90,244,244,158,253,6,172,55,96,93,5,227,7,236,52,171,186,13,243,131,40,177,154,23,4,151,192,136,246,176,114,123,207,190,64,240,174,148,110,64,197,164,109,39,138,51,41,54,178,79,231,125,242,68,239,72,94,239,150,19,183,122,177,103,159,128,99,66,224,139,77,90,86,143,109,2,50,8,230,166,199,253,11,190,209,254,61,115,31,146,245,201,5,2,100,108,129,202,19,2,104,164,2,60,108,210,176,103,190,141,197,150,81,247,54,19,45,63,219,179,219,152,195,166,8,48,79,102,191,138,129,87,137,132,99,29,94,158,168,29,117,238,153,49,180,121,86,4,150,240,5,
44,105,196,165,242,254,128,185,140,43,191,12,65,237,188,49,241,128,86,36,108,117,119,157,184,234,200,94,235,234,177,23,65,133,56,88,225,187,162,61,227,139,226,13,232,134,241,69,62,203,33,207,28,201,254,216,171,133,103,44,170,113,96,64,126,82,130,93,132,19,19,76,79,8,38,251,35,68,120,161,219,128,50,54,182,136,92,101,40,93,128,76,101,98,118,82,65,222,187,126,36,126,153,244,50,41,237,216,182,36,140,39,216,246,137,240,152,99,23,5,176,60,75,212,186,103,190,139,150,119,73,9,198,176,144,85,133,233,10,55,40,51,163,10,243,69,61,39,179,162,229,241,172,62,184,240,234,235,152,13,23,176,95,199,48,230,251,101,123,118,246,51,232,134,221,37,204,49,83,176,103,156,164,50,83,176,97,156,20,39,151,39,76,188,200,161,224,9,147,46,10,127,200,239,4,248,195,177,28,24,138,196,96,190,42,87,28,187,206,19,198,79,160,170,112,159,39,204,49,33,208,62,222,60,240,182,99,111,111,100,93,198,220,23,254,143,187,25,39,192,236,249,241,24,202,27,45,207,163,77,159,35,132,32,202,31,5,162,45,196,0,99,238,48,198,24,57,209,247,58,250,138,252,38,244,
189,30,37,34,243,206,252,217,255,17,222,126,29,103,190,137,51,95,71,154,155,34,208,243,185,224,179,240,228,109,48,195,221,177,23,216,225,238,200,58,136,5,6,137,195,147,56,239,255,135,41,72,150,76,82,251,57,111,3,229,113,72,224,146,215,217,14,72,89,80,49,139,17,228,241,104,236,3,21,54,42,223,107,91,35,55,16,213,80,210,20,174,105,198,176,230,39,164,109,179,147,130,19,135,106,36,4,27,249,167,75,246,26,17,178,49,68,87,35,60,141,79,232,50,227,251,102,27,93,102,220,212,236,6,131,238,39,210,94,47,27,57,116,163,151,63,193,100,121,86,164,23,42,56,78,239,117,71,224,64,25,232,70,47,127,206,184,103,94,96,236,2,178,52,146,59,27,151,218,247,26,65,182,49,210,177,215,200,246,211,56,110,218,107,12,64,3,117,39,180,117,175,17,56,185,56,184,215,232,129,122,204,123,141,14,168,163,126,207,124,25,123,173,148,109,64,89,206,188,103,102,21,243,32,148,99,147,121,152,254,252,6,208,180,103,102,179,51,15,53,159,212,77,123,102,220,192,236,135,143,117,204,129,250,189,198,53,230,91,195,233,26,145,172,113,33,218,137,179,21,238,53,190,
0,169,23,37,120,15,214,125,33,109,52,190,32,169,119,10,248,94,148,111,64,105,20,118,251,215,89,190,125,207,206,73,203,110,21,73,151,85,237,67,98,251,123,128,59,47,138,0,35,208,22,163,176,228,221,227,135,19,47,132,195,190,72,128,173,194,190,72,206,89,21,14,132,45,236,206,207,153,68,100,178,171,24,246,9,134,189,138,97,159,8,7,202,115,200,210,231,152,154,96,2,242,204,34,242,174,22,138,101,58,63,187,7,217,43,239,185,8,219,242,92,56,58,169,255,57,91,192,130,112,110,16,181,123,112,195,99,7,18,147,16,28,87,113,210,85,156,245,170,112,195,126,56,250,127,45,201,20,160,223,38,48,167,0,253,182,72,42,199,142,138,142,199,203,136,196,120,108,151,252,38,158,223,15,142,133,69,190,99,150,235,123,246,249,19,150,121,97,186,232,69,130,159,117,92,184,203,201,230,120,125,207,76,178,202,67,55,95,178,65,249,24,190,121,33,244,47,179,29,31,87,166,96,43,194,16,98,15,21,123,233,63,78,52,160,147,15,116,177,143,138,51,200,28,49,42,206,32,115,191,100,94,140,144,87,61,218,67,198,196,27,86,68,192,93,199,26,203,164,131,57,17,176,88,100,
89,181,97,156,251,37,57,138,116,158,87,67,184,114,23,99,186,72,185,39,241,32,192,19,166,196,73,136,9,202,27,198,17,97,82,193,154,119,54,49,216,89,184,103,12,16,233,78,252,42,0,178,249,115,183,234,36,44,196,134,115,141,73,175,9,206,101,242,139,200,99,97,241,222,129,236,34,143,133,217,189,204,87,224,184,34,50,80,128,224,183,115,212,10,144,71,237,159,149,33,0,113,81,51,127,30,122,156,16,30,156,36,132,7,81,148,59,198,25,63,248,108,114,146,42,18,139,164,74,114,93,21,6,69,82,59,255,198,201,103,150,219,184,21,201,105,85,108,38,36,167,60,75,222,201,73,232,199,121,212,254,89,102,164,201,111,138,200,188,130,204,249,141,17,153,87,216,183,78,102,21,86,96,250,57,229,198,49,206,194,235,5,198,171,226,12,112,124,180,161,112,108,19,166,205,167,116,244,130,226,150,123,198,89,4,97,87,131,138,48,104,248,124,166,2,171,99,117,236,248,55,172,11,120,215,241,134,133,103,121,139,247,204,243,72,227,229,168,56,255,237,201,233,128,141,16,57,140,115,34,132,243,34,11,208,112,13,68,54,19,236,200,115,225,36,58,196,105,225,216,139,238,
227,248,84,166,217,183,110,131,247,180,56,45,129,12,191,57,221,128,110,216,251,68,56,70,152,153,87,48,40,182,87,134,152,189,128,12,44,210,50,248,113,170,165,44,60,158,44,144,143,44,182,205,147,83,55,91,220,109,182,184,121,172,112,27,107,204,11,204,188,140,125,68,172,121,25,247,72,204,158,215,18,116,201,204,252,179,35,227,204,138,153,230,201,45,108,241,12,249,28,28,156,129,142,119,69,32,156,199,21,230,133,55,77,224,77,139,168,56,129,39,45,138,195,208,177,43,84,156,108,233,202,196,127,238,45,96,151,207,84,34,42,143,141,182,128,126,39,59,89,36,191,147,85,127,6,9,187,230,129,231,92,212,194,169,167,101,150,93,239,31,95,29,22,138,121,235,32,239,44,252,127,126,117,152,61,121,127,153,253,199,87,135,33,222,238,249,190,224,2,106,206,99,188,173,247,157,188,118,145,215,106,59,120,119,233,96,171,201,191,69,147,206,242,47,245,11,224,85,219,75,79,47,59,75,109,39,133,78,33,130,120,209,190,118,194,114,141,128,248,213,247,14,224,224,144,146,127,109,207,191,8,27,24,99,200,143,65,197,153,147,79,22,51,248,193,201,203,121,
229,231,247,95,241,126,135,31,206,150,48,24,63,156,197,135,126,245,249,1,215,155,57,121,57,159,17,179,93,98,218,75,56,66,203,244,137,66,211,121,133,120,3,60,94,144,158,153,147,158,25,209,19,173,254,213,130,199,131,133,30,44,120,237,100,193,107,98,193,207,131,243,111,128,188,32,66,49,43,235,252,234,243,3,135,253,107,39,111,176,215,148,129,207,61,227,199,179,177,85,228,197,23,174,112,162,33,239,182,199,159,31,78,88,22,78,88,22,4,112,213,232,81,173,132,216,2,197,215,25,50,220,13,68,34,43,81,103,34,50,221,13,66,232,17,120,44,139,124,173,240,81,232,60,35,206,139,161,194,8,203,39,70,88,22,118,194,243,248,218,1,160,199,159,37,16,77,188,173,94,57,177,198,21,1,219,241,103,9,178,209,117,145,33,100,18,22,91,83,203,12,145,193,214,212,50,195,150,241,143,23,242,60,111,222,114,128,63,123,2,126,222,44,199,248,9,117,136,64,222,143,242,40,45,11,136,235,17,161,94,56,81,158,69,68,206,113,82,39,69,46,147,194,23,89,117,153,60,176,72,144,255,99,161,99,94,211,73,14,17,66,9,16,174,16,217,55,80,252,202,63,120,113,193,227,165,
197,23,48,150,254,135,139,243,241,228,216,116,151,17,136,64,89,38,227,158,44,112,246,179,48,104,125,124,202,70,152,27,24,145,176,129,18,62,226,147,206,177,224,197,159,121,155,62,183,156,57,94,233,202,137,146,191,18,230,243,39,139,127,247,4,22,129,188,240,18,253,9,224,122,178,193,21,5,169,142,123,128,170,10,149,38,177,124,21,42,77,10,87,203,247,144,108,79,150,22,186,157,68,213,37,246,220,107,98,182,227,193,152,90,143,178,66,4,61,222,40,68,152,160,103,194,69,150,59,46,144,178,106,171,24,124,5,111,168,98,240,149,95,230,231,133,174,246,210,137,249,46,113,40,152,21,172,199,211,226,13,162,71,68,149,232,153,121,101,218,235,252,145,204,40,14,104,207,202,54,40,111,24,159,113,218,124,177,61,253,103,190,146,254,249,215,95,73,11,126,47,46,162,12,47,255,240,131,97,232,197,189,231,210,95,248,76,250,23,62,147,254,207,23,244,127,41,236,213,255,69,83,173,255,203,130,95,255,151,107,246,216,255,250,228,141,231,113,193,27,215,99,213,27,203,148,250,141,125,182,103,211,245,88,189,105,153,82,109,218,103,165,77,207,227,164,
243,141,243,65,193,27,223,162,250,141,101,1,134,133,132,102,211,183,168,219,180,44,92,220,116,62,128,107,33,186,244,198,57,82,181,233,28,121,213,255,198,255,88,122,99,131,205,243,64,253,198,181,168,223,244,60,40,218,116,45,22,110,210,190,105,91,120,117,254,141,237,166,250,141,159,185,92,55,165,55,158,187,238,77,255,98,241,166,231,174,102,211,117,83,179,105,187,249,79,221,111,108,67,48,140,107,222,120,144,198,229,151,205,155,158,41,122,253,76,49,174,222,180,13,37,252,111,124,15,36,68,42,122,99,25,17,226,140,108,242,7,254,155,150,17,29,210,148,34,141,242,253,27,31,67,157,83,37,111,44,213,154,55,246,33,215,166,111,170,110,211,82,173,218,116,78,193,48,20,61,133,166,210,27,47,146,58,239,150,49,67,172,99,211,251,24,133,166,10,54,157,119,139,152,98,195,251,198,9,30,62,116,176,204,22,188,177,223,20,107,168,55,157,143,203,55,237,55,85,155,150,217,127,214,161,100,9,74,74,111,252,11,128,183,56,178,233,95,64,254,133,58,20,86,163,112,172,230,141,107,22,36,70,138,208,165,224,141,103,86,105,217,180,141,8,29,128,100,
86,183,233,154,141,119,189,225,15,15,222,12,46,20,191,113,45,168,222,112,55,242,236,230,224,66,225,166,109,182,119,211,179,208,186,233,90,96,14,31,96,57,239,22,190,177,88,80,100,188,119,211,119,179,24,17,165,77,139,229,220,166,125,252,213,5,96,64,204,187,21,111,236,83,152,239,156,101,211,119,215,176,105,57,39,160,208,109,218,167,210,195,111,124,216,194,57,126,238,141,221,223,180,233,91,192,90,126,148,28,79,220,121,227,71,57,155,88,24,24,92,119,155,48,116,201,166,255,65,49,58,128,246,221,205,64,222,138,174,89,213,27,255,44,214,92,120,177,233,159,213,32,88,57,162,23,193,180,81,246,198,127,183,224,141,3,1,61,44,97,27,145,239,209,139,248,35,170,77,255,221,139,155,142,155,27,55,222,56,177,179,111,68,247,198,162,45,121,99,111,54,111,250,70,28,155,78,156,193,222,140,193,180,209,255,187,250,47,56,238,95,126,237,184,93,127,16,142,203,93,102,195,179,199,15,239,61,147,254,138,227,254,21,199,253,79,62,253,95,249,190,255,87,141,89,255,215,133,203,250,191,94,211,31,158,218,239,126,42,155,246,123,166,213,169,238,167,
171,169,158,233,120,207,126,223,170,220,180,111,185,82,148,234,91,157,76,89,174,196,91,247,187,87,101,125,170,123,85,189,223,19,92,78,245,4,229,249,253,190,187,114,105,170,239,110,233,190,37,242,48,101,137,200,87,246,29,75,178,121,223,62,161,75,57,150,110,165,236,252,25,194,126,207,85,70,245,92,213,236,91,102,239,164,44,179,242,242,190,125,97,241,19,215,88,62,113,45,227,147,167,183,224,147,167,163,232,147,167,165,240,147,167,17,218,80,248,73,170,167,207,4,53,170,83,246,5,245,39,169,78,181,111,187,173,254,228,169,165,173,22,158,154,98,104,37,117,141,232,131,15,10,191,135,113,30,51,180,137,241,173,208,118,234,93,140,233,101,14,11,101,43,109,118,120,157,212,93,172,45,100,112,235,62,241,251,207,79,252,118,219,180,111,13,91,82,182,219,171,251,150,225,194,148,53,44,75,251,61,67,133,41,11,255,250,213,126,87,164,41,213,51,228,72,117,69,42,247,123,38,228,192,126,119,8,165,38,164,84,119,72,218,239,26,212,167,186,6,165,253,78,111,229,167,37,183,58,197,95,167,127,50,184,165,253,14,167,142,249,197,58,234,84,135,83,
218,111,183,22,124,90,98,109,131,131,117,237,172,105,69,39,139,42,213,110,149,246,219,122,53,159,12,125,234,79,75,61,133,159,12,221,69,169,182,94,233,147,212,37,237,183,118,194,215,193,28,109,240,182,48,182,73,149,106,237,148,246,91,90,104,107,160,110,132,191,166,40,213,210,34,237,55,155,11,62,25,46,161,103,37,250,125,173,249,180,244,149,58,213,108,150,62,121,138,165,253,38,48,242,20,49,135,26,253,85,234,84,147,81,218,111,52,128,253,23,204,241,5,107,23,176,182,186,40,213,104,96,93,173,180,111,174,130,191,20,254,243,240,27,212,41,115,21,243,52,74,251,13,231,193,176,139,185,145,157,223,29,167,26,206,75,251,245,229,5,224,87,149,170,47,151,246,77,95,233,83,166,175,54,190,221,239,254,70,238,76,117,127,131,179,76,61,73,245,76,197,245,194,161,90,112,166,162,125,203,252,189,148,101,62,174,217,239,190,47,159,79,117,223,47,7,103,120,134,228,240,126,223,138,124,38,213,183,82,191,111,153,248,41,197,191,40,219,178,239,88,144,13,56,148,62,229,88,120,40,28,170,5,159,196,161,44,87,104,157,186,155,178,79,201,254,125,
207,204,26,70,68,80,128,246,204,32,116,63,194,98,104,79,15,96,116,0,96,43,194,54,73,251,238,43,0,111,134,175,30,7,50,209,102,132,183,174,12,39,66,169,58,81,167,207,4,79,61,101,28,209,99,166,220,4,109,102,30,225,160,173,212,219,160,109,208,118,104,59,107,224,188,82,39,243,8,67,117,193,135,195,121,186,105,195,144,158,94,234,125,80,225,124,253,244,219,160,118,120,29,60,78,33,47,206,231,162,221,109,70,126,198,120,178,134,125,151,181,32,229,190,82,149,114,225,21,206,94,125,202,217,43,237,59,58,209,31,171,219,91,245,41,123,171,180,111,107,212,167,108,88,195,90,175,79,89,235,165,253,254,90,125,170,191,86,218,183,232,65,70,31,253,94,132,106,251,126,207,36,225,188,122,55,213,51,25,175,16,232,183,2,157,14,11,92,21,225,220,188,223,253,80,174,77,117,63,196,203,249,183,117,83,252,48,237,247,221,151,207,166,250,238,87,238,91,38,129,127,146,57,28,2,108,199,21,150,30,127,145,178,143,203,193,253,158,101,89,157,234,89,182,236,91,166,111,165,44,211,242,248,190,125,78,214,164,120,53,198,233,203,63,45,217,112,164,190,98,
112,80,239,219,174,22,125,50,224,168,134,38,240,108,196,81,5,158,102,116,111,112,65,203,168,227,72,230,10,250,202,112,174,194,79,75,141,58,120,193,180,169,228,147,212,92,154,199,125,169,25,7,109,161,220,194,88,236,104,32,176,151,90,225,195,6,34,40,164,246,82,2,132,50,65,178,132,173,13,216,98,137,135,123,96,200,160,251,180,212,197,152,110,112,238,6,239,30,214,238,161,173,7,153,8,56,254,212,231,147,68,208,25,250,24,43,168,133,54,108,37,245,211,223,79,176,246,83,182,210,134,179,47,89,89,147,132,37,244,19,190,181,148,183,35,182,117,22,17,212,172,235,58,135,45,225,113,233,161,248,23,254,104,32,185,44,241,24,220,17,104,13,246,141,54,144,100,154,82,182,171,47,73,50,229,34,201,16,32,97,181,72,50,103,73,50,117,169,158,240,24,73,230,226,126,79,36,106,72,245,68,36,18,13,107,185,145,77,36,41,168,199,165,58,73,58,200,197,186,66,14,3,50,73,253,170,227,36,228,17,250,20,163,35,148,68,210,233,33,25,225,58,29,248,156,161,189,24,252,152,3,76,165,70,85,170,195,65,82,66,103,3,254,238,33,6,150,12,69,169,118,11,201,168,139,
128,214,99,187,139,180,147,0,12,21,234,84,91,23,243,16,224,173,96,110,40,67,166,175,224,215,21,165,90,219,104,215,145,124,132,237,72,24,134,114,77,170,185,81,250,180,84,41,146,14,248,24,72,130,216,64,178,170,78,146,14,99,69,2,246,232,68,178,217,55,95,212,167,204,23,73,34,231,244,169,250,115,255,124,11,101,49,166,3,64,45,128,46,50,56,129,136,96,251,158,27,180,93,64,233,74,4,187,64,223,69,12,170,135,26,104,35,120,151,234,161,56,145,200,146,82,62,48,105,235,100,177,188,3,208,134,209,69,66,56,54,62,245,19,163,123,88,199,128,193,197,238,176,36,12,12,160,92,200,196,144,2,108,250,48,164,144,73,242,56,246,249,3,145,148,231,198,179,148,107,22,89,220,37,251,246,235,208,62,21,114,2,184,112,110,18,202,146,129,241,213,212,47,225,196,122,228,17,64,86,151,179,107,209,87,203,3,40,75,245,244,53,82,110,166,95,0,218,73,63,206,152,79,20,86,28,26,167,58,94,95,172,243,121,253,201,125,235,66,77,138,87,153,211,41,235,2,105,116,54,122,137,24,111,101,83,13,16,227,150,125,219,141,232,25,68,5,22,124,69,136,46,112,246,228,55,27,
104,126,179,161,93,44,67,126,50,116,98,227,118,150,38,174,150,16,37,191,153,176,137,230,69,204,171,0,244,85,180,3,53,127,62,247,105,169,130,167,156,254,50,234,216,153,205,229,147,244,21,60,95,21,164,108,55,84,216,30,81,207,210,38,248,132,137,170,153,27,191,90,106,37,15,44,178,49,245,2,147,136,29,228,34,14,250,16,148,1,236,192,121,188,197,206,76,178,148,68,242,20,129,13,46,121,60,235,113,122,35,117,118,126,225,156,98,162,165,106,248,170,105,215,151,67,233,51,8,161,153,135,60,104,187,70,153,100,189,68,50,54,16,200,75,98,19,16,9,214,35,175,30,47,72,4,45,97,220,124,244,90,145,146,236,44,9,167,16,3,132,179,145,229,13,226,248,192,49,34,127,12,17,59,4,139,179,197,178,13,50,121,53,142,81,173,78,217,174,129,178,129,113,39,139,123,196,113,133,227,139,200,78,134,110,142,43,243,172,35,50,62,22,56,118,30,185,225,196,52,192,130,214,30,39,123,175,157,9,196,62,218,79,155,216,38,68,122,194,91,151,196,150,130,105,68,186,19,161,234,201,155,135,137,217,154,150,106,65,128,133,37,224,149,46,193,123,145,118,97,162,74,158,243,
164,57,160,23,38,91,186,196,124,120,91,126,188,152,151,181,36,143,63,133,96,251,150,21,185,130,172,83,146,162,80,187,223,181,96,38,235,92,75,117,45,144,117,110,201,51,136,137,56,14,50,184,200,144,45,88,182,174,252,147,1,15,144,206,161,255,57,166,22,214,189,132,254,224,146,247,154,182,146,227,99,11,214,21,78,11,216,149,169,158,91,122,82,215,69,38,59,73,87,67,199,41,81,152,223,227,36,85,13,113,94,26,100,2,17,109,96,32,82,176,212,163,74,117,114,142,234,240,227,46,68,174,132,65,12,24,100,73,164,42,63,169,202,11,47,103,158,37,113,150,17,145,196,185,164,221,75,186,18,70,5,15,3,94,225,17,231,195,38,210,21,231,175,86,39,107,138,249,61,37,169,86,206,95,45,118,125,170,197,78,170,234,215,167,154,251,73,79,125,250,84,83,31,231,160,30,125,138,127,254,97,223,220,69,42,226,204,213,208,161,79,53,116,144,146,218,72,73,109,156,105,90,56,211,112,190,50,54,233,83,70,142,17,117,102,125,170,206,44,237,215,178,251,214,226,117,53,117,250,84,77,157,180,111,168,209,167,12,53,210,126,117,181,62,85,93,29,77,12,179,193,19,100,2,
18,11,167,84,11,229,14,104,7,117,78,106,146,200,23,231,161,231,161,103,56,117,157,193,159,191,130,146,88,165,114,248,196,169,170,10,74,16,74,245,148,197,161,164,153,126,252,155,147,225,73,82,165,93,120,144,7,62,242,19,127,216,232,74,121,214,52,251,238,155,230,148,251,166,180,239,186,118,113,223,121,185,36,5,77,65,247,29,17,115,138,63,247,221,183,135,204,41,59,71,87,155,223,156,178,1,173,213,97,78,89,217,13,250,251,46,238,247,181,151,164,160,169,190,246,94,54,251,232,5,54,251,177,125,203,50,103,182,229,240,190,245,94,244,244,190,101,80,157,178,222,227,245,192,122,143,173,107,48,250,3,25,7,129,132,178,121,138,64,54,234,226,177,139,7,129,251,232,19,71,90,146,165,196,145,159,255,241,228,24,140,118,202,237,148,91,105,111,165,220,4,109,20,148,182,70,202,66,105,241,112,252,228,86,53,96,209,198,17,84,42,167,94,78,187,224,107,82,113,176,161,220,66,89,36,127,49,143,56,241,137,121,113,33,169,179,0,105,41,119,50,86,28,111,57,246,114,235,156,7,158,122,177,6,101,171,120,152,151,157,43,255,228,229,166,223,69,191,208,
171,149,118,33,163,135,178,0,59,47,63,252,221,180,139,211,30,167,5,73,156,22,242,227,104,207,143,99,124,158,95,214,113,226,114,113,166,229,221,168,231,90,37,7,91,69,76,43,30,177,4,83,136,37,56,180,138,76,192,70,121,108,95,222,22,164,46,202,159,69,205,219,158,54,54,92,73,28,124,4,60,2,170,11,208,11,80,19,212,84,144,234,185,70,127,222,159,168,231,213,213,237,91,30,193,47,193,35,209,150,135,146,200,40,128,79,60,121,30,68,63,69,255,41,248,190,164,77,60,2,22,1,125,3,99,26,232,59,3,21,243,54,81,22,102,18,254,41,204,240,89,158,188,175,82,239,20,15,227,122,232,23,115,244,192,43,252,183,31,202,219,72,254,17,122,218,105,19,176,218,105,23,38,115,82,118,82,206,155,141,126,55,109,110,234,121,95,167,47,15,37,237,125,148,251,144,87,224,67,10,151,28,212,57,47,28,143,167,158,31,7,229,224,35,121,240,218,71,230,125,203,109,185,103,223,250,8,51,220,150,191,73,89,31,177,195,10,71,21,187,250,103,67,231,81,102,70,7,43,58,160,121,173,40,231,219,153,93,56,158,112,48,17,177,36,197,99,180,200,61,191,69,162,243,180,11,100,243,20,
222,60,250,204,253,25,209,60,210,69,127,213,254,150,177,95,192,251,133,250,175,218,223,80,255,158,122,190,143,250,11,230,57,69,223,41,213,95,249,167,51,63,73,197,148,139,105,127,4,207,87,204,253,149,244,87,110,79,30,175,127,158,242,45,193,79,187,30,62,241,156,162,109,137,182,252,218,140,169,167,126,149,126,129,188,144,235,60,243,206,81,206,91,128,246,227,64,248,43,255,92,217,137,115,195,147,207,50,255,111,123,103,215,21,213,213,36,224,35,132,128,125,90,25,9,74,80,60,65,20,63,162,124,211,52,77,55,221,13,45,31,138,6,144,24,52,72,0,17,27,130,4,137,193,196,55,195,235,58,162,201,100,157,62,107,189,183,51,167,207,47,225,120,61,55,51,119,115,63,63,96,46,231,15,204,83,213,189,125,147,155,89,107,46,103,173,92,28,107,87,237,239,170,218,181,107,215,222,45,148,155,163,156,104,151,42,57,244,107,53,71,246,29,112,85,118,112,93,104,208,110,209,95,18,92,62,163,5,61,244,59,73,89,89,216,34,89,225,111,31,180,155,224,178,0,217,247,84,82,21,169,30,217,99,240,65,36,165,242,0,26,109,23,131,33,244,33,234,202,74,17,233,171,21,
5,23,247,81,165,79,26,183,182,98,108,24,183,216,122,149,39,99,195,147,171,104,6,60,148,21,165,218,37,11,147,54,101,213,137,102,229,88,5,121,218,16,205,204,103,143,236,68,27,233,83,180,211,72,31,49,250,61,193,216,234,25,99,211,145,93,0,222,4,159,36,127,154,190,166,41,115,155,50,119,160,223,37,61,203,60,230,128,247,192,23,128,247,193,191,2,62,160,255,7,212,89,2,46,65,123,68,254,50,245,86,72,175,146,94,35,253,152,246,30,3,159,128,111,64,127,10,44,2,55,169,179,9,253,91,240,109,240,103,192,29,104,59,208,118,193,159,131,239,1,191,135,246,61,233,23,208,247,193,95,146,254,17,218,143,164,127,34,253,10,250,207,164,255,145,244,235,203,85,94,176,6,212,130,192,19,213,33,244,85,117,14,119,221,130,71,86,18,221,132,79,242,53,192,123,98,7,86,19,244,38,202,153,93,171,3,28,39,192,186,2,188,2,253,6,229,228,152,86,89,193,94,183,232,187,209,25,229,55,109,24,67,107,214,153,214,133,174,249,180,163,59,32,27,209,35,104,34,127,177,90,10,91,188,225,71,108,84,207,167,171,22,138,126,206,144,143,187,169,6,93,92,86,181,84,64,53,226,
140,75,245,20,92,55,23,96,55,109,137,229,84,11,69,125,179,139,234,24,41,143,139,170,177,34,181,48,224,170,219,148,51,150,121,132,250,35,120,238,198,200,171,229,33,95,117,139,118,197,138,103,201,87,93,6,87,139,117,120,195,75,61,207,4,201,173,140,151,220,178,130,196,87,25,47,241,21,65,35,96,63,176,187,152,241,186,139,56,43,224,93,130,47,131,47,147,191,67,254,14,229,247,41,191,79,8,224,229,225,95,189,204,203,174,96,100,243,126,117,4,204,94,181,153,145,234,136,24,189,142,156,81,124,240,55,40,35,62,135,28,232,100,47,185,14,148,125,164,178,53,122,35,155,164,197,70,87,86,52,105,70,173,82,133,166,91,43,184,114,19,168,90,66,27,234,187,0,101,207,193,211,84,235,34,154,36,86,230,90,44,72,111,65,215,61,6,206,56,164,165,158,217,19,100,251,215,125,5,26,7,110,221,3,100,213,26,107,44,146,206,179,114,141,109,87,14,186,211,213,2,100,26,53,50,254,133,81,39,17,165,138,145,14,100,178,221,64,153,148,136,91,160,108,148,50,72,53,127,164,205,230,214,14,77,84,199,145,15,186,76,72,54,84,85,75,112,135,180,228,93,34,125,137,118,174,
74,27,224,102,35,83,134,130,139,249,51,62,130,244,105,212,94,39,94,21,144,154,54,234,203,198,39,38,73,38,169,19,38,173,102,145,122,138,187,172,61,57,181,136,227,148,108,165,51,210,18,174,18,191,191,173,222,75,139,51,115,150,244,167,4,85,231,105,228,12,107,86,202,202,186,28,161,49,241,24,135,73,227,11,139,191,172,158,167,172,75,97,150,196,67,9,67,201,9,215,202,247,227,138,16,255,73,184,159,210,33,196,12,238,3,231,67,21,71,26,175,234,62,105,81,242,17,42,201,34,144,237,150,99,180,114,56,141,162,19,127,208,122,34,50,226,93,149,109,153,180,4,55,57,194,74,144,213,202,207,84,112,241,146,56,29,233,98,17,14,118,8,7,104,147,3,141,114,67,184,47,92,19,142,15,144,150,73,200,65,136,3,128,170,32,199,104,149,138,46,116,242,47,81,78,84,81,38,168,146,5,74,217,30,232,196,232,52,230,32,203,64,198,45,174,183,24,121,81,53,217,220,57,48,112,74,121,84,25,188,236,38,226,63,8,87,146,64,97,0,129,60,109,68,184,38,17,105,78,27,234,167,199,169,44,107,46,14,126,140,60,203,212,101,162,226,254,73,125,241,77,36,216,36,156,150,9,116,147,
150,137,139,107,42,59,182,4,95,228,56,37,42,41,52,97,170,168,147,232,186,66,104,87,144,58,199,73,124,45,79,133,208,71,90,153,249,203,39,65,122,44,231,165,199,178,65,118,195,173,241,178,27,215,241,250,127,194,233,31,12,242,175,220,83,65,118,175,201,211,68,254,160,209,203,238,173,120,249,131,206,32,207,99,44,47,127,151,243,192,134,248,234,28,145,50,12,42,117,134,234,23,254,43,47,122,141,111,158,23,93,21,61,22,3,33,139,158,53,144,239,180,130,177,103,148,189,68,148,142,227,167,158,115,49,245,18,102,183,228,156,12,199,243,114,76,85,63,27,154,76,188,26,245,212,137,85,53,65,142,125,26,149,16,151,43,223,19,100,111,245,123,99,207,46,4,153,91,231,188,236,173,203,28,19,57,198,202,185,83,180,112,180,62,72,205,87,164,37,103,232,213,161,90,47,131,171,193,207,153,96,42,103,119,142,198,171,93,64,137,202,18,89,92,149,160,143,70,14,107,3,126,47,201,248,105,75,162,26,93,68,241,231,137,68,49,54,9,4,229,7,160,51,182,85,142,218,237,8,75,34,34,162,169,18,142,151,72,154,30,203,101,217,49,198,74,208,133,116,254,113,144,233,138,
123,217,103,253,65,106,226,50,244,122,47,195,58,215,168,31,171,66,130,12,121,86,68,37,126,64,0,118,190,18,3,224,144,230,165,38,40,199,209,93,150,239,170,92,77,16,35,208,35,252,165,56,203,142,232,103,39,145,145,167,240,139,192,213,170,24,94,202,233,21,8,17,80,61,246,178,109,173,18,200,210,182,37,98,147,168,244,215,14,79,218,81,214,85,198,46,227,104,215,171,12,104,216,70,225,163,149,95,8,146,4,142,71,158,118,5,137,81,46,48,100,206,202,95,32,243,92,197,84,8,95,149,23,56,234,249,238,250,160,223,174,253,16,116,97,44,94,2,123,36,99,229,167,101,156,255,25,123,7,38,70,206,251,64,193,177,133,65,106,21,121,117,50,86,9,210,200,138,150,248,7,10,219,111,83,190,42,3,81,124,137,212,182,75,180,92,22,131,70,199,233,147,49,181,203,98,33,186,186,202,92,36,224,71,180,42,72,50,14,139,177,86,98,38,93,94,106,53,233,37,237,88,144,72,60,10,250,239,54,121,137,4,46,155,44,88,217,154,229,176,64,240,78,67,37,98,5,100,81,53,208,255,93,232,22,183,57,251,244,199,245,134,21,167,31,177,235,196,114,36,232,166,123,130,88,35,169,43,109,
113,112,78,44,115,162,221,255,154,99,110,204,75,44,207,5,3,123,156,210,214,10,222,192,94,93,208,191,69,112,132,157,187,119,237,107,175,119,205,9,18,155,79,189,196,102,83,48,176,63,233,13,236,215,7,67,91,147,193,200,126,173,55,180,85,96,245,197,188,145,253,92,48,118,80,199,226,19,188,214,27,59,192,213,210,141,90,204,116,69,175,43,46,43,203,87,92,125,221,195,98,212,97,76,186,175,49,94,83,78,247,5,232,186,65,66,215,253,161,137,118,227,180,251,5,245,7,171,109,163,71,234,142,152,62,88,175,234,98,201,28,49,44,114,21,101,198,160,123,40,109,233,1,212,33,79,120,9,174,227,32,74,109,220,38,221,35,161,155,61,176,153,114,205,244,243,49,240,99,232,22,208,234,130,231,204,169,1,92,44,186,24,74,227,62,233,88,223,178,77,24,63,201,156,165,228,252,36,150,175,141,129,181,49,57,61,39,53,4,217,3,112,109,180,151,115,12,233,147,228,233,70,75,227,218,152,219,255,119,78,136,244,101,212,234,250,80,80,71,15,174,174,143,140,130,6,196,20,155,78,7,40,63,0,93,142,166,18,251,212,80,12,229,101,191,144,96,155,58,135,112,73,119,113,160,
14,146,124,19,114,81,119,8,92,157,102,242,213,67,0,215,1,210,143,172,224,203,112,93,61,10,44,235,65,109,48,122,159,126,244,120,78,158,184,71,196,210,173,179,192,179,49,143,159,28,7,252,151,126,112,151,50,142,105,175,193,203,96,177,24,67,144,190,11,189,139,109,64,39,94,235,241,87,71,131,17,46,29,71,136,218,164,184,112,196,186,4,195,99,92,251,16,0,75,142,198,184,102,107,246,146,163,135,171,65,114,129,171,202,5,119,155,8,95,139,151,92,216,134,99,204,80,236,130,114,136,145,170,219,43,51,161,39,217,100,196,65,115,226,65,122,163,133,64,32,189,202,81,214,114,103,89,60,36,142,49,165,26,160,156,3,84,78,200,83,207,3,84,140,81,49,70,67,113,242,227,228,159,172,126,234,195,67,215,40,22,83,211,169,3,213,99,4,254,193,59,164,142,178,140,242,234,121,210,174,108,72,24,158,74,112,6,168,172,134,174,3,134,133,170,160,208,197,201,19,103,203,4,99,196,195,149,171,134,138,232,131,236,43,210,178,221,75,8,252,15,81,129,102,47,189,225,62,245,178,175,228,174,122,251,136,255,118,133,175,225,232,216,241,26,62,96,35,120,99,253,209,
177,115,181,124,20,158,39,221,15,173,159,188,97,202,12,159,56,58,150,5,102,107,131,252,78,243,209,177,9,242,38,40,51,73,249,201,198,163,99,83,224,83,224,74,167,206,77,202,222,172,171,226,49,210,228,223,132,174,249,167,170,120,14,156,114,19,82,94,242,169,95,0,22,76,125,218,213,242,166,125,218,153,36,127,178,151,190,168,55,69,251,90,15,250,20,227,16,92,219,3,142,81,110,12,122,14,152,163,189,44,48,75,59,105,96,26,122,10,152,162,191,97,234,13,3,19,224,9,202,233,156,193,251,160,247,209,78,55,244,110,202,95,3,94,131,222,9,236,164,92,7,253,119,0,29,112,7,250,121,224,121,112,2,21,199,62,5,63,77,253,211,64,229,43,245,227,208,227,13,65,97,191,245,232,152,69,93,11,239,100,199,125,226,21,246,29,24,218,14,242,46,87,181,87,136,217,28,195,122,17,165,4,79,53,102,7,212,227,40,249,106,50,174,6,147,7,23,37,12,194,135,184,213,124,80,70,253,121,96,59,116,113,159,37,144,37,123,197,117,84,133,61,170,122,16,66,109,160,139,211,103,108,151,218,97,112,85,31,202,171,173,164,252,31,14,42,53,222,228,193,74,80,120,245,192,43,188,122,
17,140,189,158,246,198,94,159,8,10,59,247,189,2,39,183,177,61,240,61,124,174,157,91,94,118,39,25,100,118,94,123,153,157,102,162,167,11,4,77,99,65,102,227,53,30,118,147,151,217,40,224,228,181,85,87,58,227,212,62,128,106,175,129,106,159,129,106,70,129,106,241,128,186,158,129,202,31,160,90,58,160,174,111,160,30,242,128,106,193,128,106,169,128,230,0,166,203,12,220,28,248,12,110,242,77,121,13,237,80,206,156,105,76,191,102,124,106,161,200,55,184,25,175,25,231,31,206,106,148,51,227,149,120,176,124,166,93,51,110,241,67,229,51,225,39,51,15,51,14,181,208,228,171,25,0,170,101,6,170,121,0,170,185,0,154,121,152,121,169,14,64,87,11,12,60,83,253,84,143,72,159,172,126,113,160,124,106,222,128,13,213,79,117,139,180,234,27,80,247,65,160,169,103,218,53,253,155,113,154,249,169,110,81,222,200,177,194,47,124,7,238,126,51,15,197,113,88,80,19,159,121,56,136,35,210,136,169,47,226,132,16,189,92,118,209,144,101,188,185,121,119,209,75,204,115,61,191,246,166,187,170,23,232,166,217,241,148,111,232,168,242,3,186,206,27,29,214,121,130,
203,225,69,204,180,154,117,160,206,163,61,24,121,210,68,55,212,147,195,201,71,248,87,58,47,242,99,224,49,112,53,231,224,77,224,220,254,85,204,57,229,117,190,180,239,48,39,57,35,203,73,78,246,127,229,59,80,249,128,185,87,185,176,109,232,184,168,167,124,1,87,121,210,190,217,129,141,25,151,48,161,92,255,168,62,112,41,162,252,163,156,234,55,237,170,222,152,181,74,251,170,79,208,229,200,171,1,116,198,35,135,42,213,63,232,102,13,171,199,0,174,124,7,230,184,185,124,66,89,61,13,210,103,254,112,149,76,26,145,195,138,113,43,116,47,1,215,65,177,45,31,144,150,104,117,23,19,208,5,194,132,76,16,193,108,241,205,52,202,85,105,133,113,12,68,21,4,92,25,10,84,133,130,174,10,5,174,2,97,34,42,16,162,59,42,0,232,42,144,223,149,87,133,4,215,120,48,227,144,11,16,249,180,95,232,198,213,16,97,200,215,206,56,184,160,252,251,190,202,184,197,9,86,3,74,127,106,12,129,58,15,160,186,54,228,107,132,159,241,169,225,160,190,10,12,92,227,123,228,43,206,179,25,117,153,160,235,2,165,190,26,81,160,113,181,140,235,37,81,31,137,246,168,160,
112,134,213,128,224,218,168,147,139,96,37,134,155,129,159,198,17,85,1,225,136,170,33,52,46,208,253,32,127,112,202,75,31,184,79,104,128,137,164,90,56,218,34,144,215,84,54,26,30,131,30,99,64,202,72,42,170,195,66,190,58,40,76,68,25,69,190,106,40,184,106,36,184,106,30,26,167,154,5,221,120,74,18,169,145,152,129,156,18,228,211,129,81,222,120,229,138,83,94,53,75,38,2,195,51,48,198,76,196,120,241,26,56,164,222,48,249,156,188,42,43,22,168,140,65,195,229,70,44,129,39,46,87,37,131,56,92,170,241,180,163,43,128,114,186,178,97,172,25,167,97,184,58,64,208,85,32,64,35,56,93,113,212,51,43,80,175,134,192,141,135,110,20,195,40,140,81,92,229,35,229,212,113,3,234,202,103,220,106,17,105,95,29,63,160,42,46,227,83,69,38,8,245,48,238,169,28,12,127,29,230,201,211,135,202,149,20,208,68,205,62,68,203,152,167,196,104,148,95,180,159,167,124,126,142,75,50,124,219,87,111,214,189,212,43,142,130,15,87,64,56,134,61,116,95,203,90,173,172,83,179,134,85,3,144,136,170,148,145,28,45,201,165,19,247,249,21,14,210,131,170,32,184,145,172,218,74,
232,186,39,65,87,73,210,78,94,190,159,185,40,227,174,240,21,86,54,185,211,18,164,214,50,94,106,173,62,72,126,67,232,246,27,94,169,61,88,246,6,31,16,154,93,198,205,30,156,175,247,250,151,223,124,114,116,172,6,231,166,6,231,40,134,35,19,195,233,49,206,99,11,78,78,11,120,43,244,86,242,59,192,59,112,126,218,128,109,208,213,73,2,255,12,252,51,113,154,104,231,60,229,28,202,59,64,197,161,127,40,15,93,242,219,170,159,113,178,52,223,189,135,167,74,67,231,240,234,218,40,40,29,40,46,13,208,176,84,58,7,93,242,207,82,238,44,80,189,91,232,138,51,16,83,254,44,229,207,58,213,242,146,95,253,62,180,47,237,81,95,7,32,237,72,187,244,167,237,208,95,11,249,45,212,57,13,253,52,244,79,232,239,19,232,39,129,39,193,227,208,185,218,58,118,28,252,56,253,214,0,107,160,91,64,235,28,207,42,121,254,247,202,221,244,146,175,26,130,212,70,193,75,109,112,196,121,52,23,12,46,178,81,61,234,15,250,55,8,83,46,190,233,172,174,71,164,169,23,63,70,27,120,92,192,99,209,138,6,240,104,224,33,249,106,188,161,233,109,51,235,77,215,19,210,87,131,5,
93,110,130,101,237,73,68,64,62,53,254,212,51,235,93,195,208,111,158,123,61,40,104,247,67,199,235,6,118,221,119,188,46,14,113,55,230,120,85,192,149,250,245,25,94,21,204,240,170,96,146,87,5,147,188,42,24,231,85,193,56,175,10,70,121,85,192,235,131,43,188,58,184,194,171,131,203,3,188,42,24,224,85,65,15,175,10,122,204,171,2,247,63,159,105,208,227,207,151,79,18,208,34,64,68,32,238,207,151,79,18,120,35,24,246,231,203,167,63,95,62,177,153,19,234,254,255,241,242,105,248,127,127,98,150,33,108,77,216,88,66,251,18,18,230,126,165,253,60,43,254,52,97,233,70,194,196,113,44,128,77,30,97,100,235,4,80,162,128,77,208,201,215,151,237,56,22,18,130,94,37,92,222,206,221,138,60,102,148,112,118,94,163,60,24,239,188,91,95,125,126,198,175,21,136,150,245,79,241,60,95,159,155,57,213,231,101,78,245,57,153,83,125,62,134,65,215,231,98,24,244,255,243,51,177,195,191,154,201,18,213,223,148,159,10,232,123,186,71,188,167,107,147,247,116,125,248,45,12,92,238,65,136,70,18,107,199,251,100,192,231,153,216,25,98,223,188,162,212,9,75,24,237,56,
249,13,196,215,143,147,54,147,111,132,25,31,38,15,211,168,199,127,249,86,137,185,115,145,36,119,27,114,47,34,47,149,101,235,144,190,184,214,227,169,73,243,145,125,192,117,191,94,251,159,59,178,255,210,194,83,128,51,60,9,112,142,248,131,159,60,23,32,189,215,202,51,2,158,60,236,0,183,161,111,82,167,8,124,2,254,152,244,26,101,86,192,151,249,190,166,206,67,104,139,87,121,50,2,126,143,167,13,242,220,97,22,252,14,244,25,250,144,39,17,83,228,77,64,27,191,120,100,231,104,123,180,157,167,24,180,55,204,55,116,249,200,30,236,60,178,251,50,71,246,141,177,35,251,122,73,4,245,183,231,71,252,114,229,232,247,191,92,169,27,231,151,43,117,99,223,175,111,110,89,17,191,90,137,248,213,202,191,245,57,81,253,29,39,138,117,57,209,210,83,39,90,110,126,251,175,23,34,254,30,65,196,19,144,114,126,201,42,243,67,164,114,122,189,49,178,211,251,145,221,245,32,178,59,250,35,187,205,45,68,246,217,233,200,110,125,7,229,211,183,115,165,252,82,172,60,190,222,84,230,135,88,229,116,177,161,156,156,109,45,165,139,86,41,57,235,230,35,187,221,
61,19,217,157,153,200,190,210,21,217,87,247,34,251,122,138,198,156,200,238,30,139,236,222,175,35,123,96,50,178,19,189,145,61,20,43,243,19,159,200,78,54,149,198,215,173,242,232,99,58,30,110,44,141,62,166,108,138,244,200,57,6,114,157,193,245,48,72,6,154,165,108,142,54,243,205,145,61,70,253,113,242,11,173,145,125,19,218,68,91,100,79,94,140,236,41,202,78,83,246,22,101,111,95,142,236,25,218,186,211,25,217,119,41,247,5,244,89,202,206,65,155,167,220,189,134,82,122,189,46,178,153,244,200,98,172,36,147,231,183,103,229,236,139,150,242,68,177,174,84,216,62,21,217,95,198,34,251,126,91,105,116,155,58,95,209,206,34,240,193,213,200,222,122,55,18,217,187,139,145,189,231,50,210,29,114,158,157,136,236,109,224,183,204,124,139,153,110,194,186,226,225,63,68,246,211,61,166,89,19,217,27,39,74,19,197,119,228,62,249,41,178,215,223,174,68,246,227,55,59,145,189,118,161,148,125,113,174,52,178,120,189,148,223,141,211,43,188,221,174,45,143,238,158,42,167,183,235,202,201,164,251,60,178,87,223,142,82,114,165,60,182,91,95,26,223,118,
95,83,247,237,2,148,239,74,99,187,136,110,247,109,78,90,187,77,11,141,229,220,238,175,55,74,73,152,58,186,91,87,74,111,207,149,114,187,86,57,181,18,47,103,87,90,202,201,149,223,24,248,250,231,140,194,173,47,101,87,172,114,230,199,195,249,114,118,187,185,148,249,241,25,131,68,214,79,225,81,145,111,19,113,111,33,175,111,221,14,166,246,130,41,186,245,204,117,38,178,191,35,119,247,102,100,63,23,6,36,35,251,251,98,100,191,56,136,236,31,186,74,217,109,139,81,190,249,56,178,247,93,167,148,92,177,74,169,149,30,52,165,1,77,169,99,180,22,179,139,151,147,51,191,192,132,31,182,168,6,67,190,71,185,246,164,185,183,72,118,215,133,242,221,225,29,102,21,103,174,135,105,38,69,165,221,57,186,62,60,81,46,236,158,40,141,239,186,105,202,184,5,180,238,68,41,57,147,65,62,245,229,137,93,167,196,239,250,144,95,67,121,68,184,82,252,231,237,114,161,216,80,154,216,61,28,41,141,236,54,193,231,250,82,190,88,87,158,90,57,161,163,41,20,209,58,120,60,190,254,235,0,37,27,75,83,43,135,195,229,252,139,88,169,80,60,28,167,209,24,138,217,
88,130,80,206,30,192,203,98,162,60,34,171,100,233,215,143,74,201,165,139,229,20,189,12,21,227,229,209,131,134,210,200,18,236,60,56,28,40,103,14,98,165,209,131,88,57,177,94,87,26,42,54,150,135,119,91,75,169,221,55,175,75,137,245,24,236,175,47,13,239,214,150,7,215,91,75,153,3,22,219,203,191,125,196,188,18,240,150,69,179,141,202,124,139,98,111,193,129,77,216,90,188,135,48,224,209,6,249,79,200,91,71,189,30,163,196,107,40,247,42,112,5,113,124,131,250,45,195,182,71,192,37,190,175,249,30,242,61,224,91,108,65,105,81,216,251,164,191,4,46,80,255,30,11,97,158,242,115,208,102,129,95,0,239,242,221,193,10,204,0,111,215,177,120,128,211,244,49,69,122,18,250,4,248,77,250,42,144,30,39,61,70,58,15,204,177,56,178,39,88,156,148,203,144,78,83,103,132,50,41,210,195,148,73,54,177,200,209,252,4,180,65,240,1,96,63,121,125,164,123,27,74,131,235,86,41,253,18,179,177,98,69,118,15,109,116,147,119,3,120,29,248,57,101,174,81,254,42,240,10,240,50,244,78,210,151,200,187,8,222,65,250,2,233,118,232,159,241,57,164,207,67,111,131,126,22,
188,149,244,167,208,90,192,207,144,110,6,54,65,63,5,173,17,60,14,30,3,214,67,251,136,116,13,105,235,77,180,29,97,73,163,223,91,210,218,44,150,244,227,201,103,107,251,63,236,90,239,49,165,239,49,165,255,126,203,121,95,255,196,121,31,27,118,222,47,109,57,239,151,51,191,252,135,29,230,214,221,184,159,91,63,17,230,167,220,147,126,126,234,109,49,100,177,94,244,249,69,104,200,31,160,136,251,133,197,119,141,97,174,232,246,249,185,98,109,152,95,250,201,231,175,81,220,13,199,139,238,113,127,188,120,33,228,207,73,213,248,252,51,24,78,175,191,246,167,215,187,194,169,165,159,253,169,37,8,249,180,219,225,231,211,117,97,97,65,202,44,184,61,225,212,172,219,238,79,205,182,134,147,51,191,157,14,39,166,98,254,228,140,123,146,158,26,253,137,41,237,141,62,122,220,207,253,124,79,77,152,189,254,133,159,189,158,12,243,51,111,104,103,198,10,115,57,199,207,229,172,48,155,118,252,108,218,10,249,219,92,254,232,176,21,102,6,29,63,51,104,133,233,94,199,79,247,90,225,72,151,227,143,116,89,97,234,154,227,167,174,89,225,112,167,227,
15,119,90,97,178,195,241,249,194,161,118,199,31,106,183,194,4,48,1,28,4,242,23,129,195,1,224,0,176,31,216,223,254,79,63,200,188,63,103,222,117,204,219,253,132,137,191,125,25,142,175,184,103,252,241,21,38,181,248,66,152,115,213,20,106,12,243,139,69,159,63,126,178,30,142,175,255,236,143,175,39,133,55,199,133,55,78,56,189,244,194,159,94,98,254,139,110,204,231,159,142,48,63,235,246,251,249,217,56,204,153,19,222,220,13,239,228,220,84,56,179,216,224,223,201,253,75,143,63,179,216,24,222,158,119,252,219,243,86,120,107,218,241,111,77,91,225,52,243,159,102,254,83,73,199,159,74,90,225,100,183,227,79,118,91,225,4,243,155,96,126,55,207,59,254,205,243,86,88,104,118,252,66,115,125,152,91,113,7,253,220,10,44,93,113,79,249,249,149,183,7,225,248,172,123,49,44,44,197,125,18,8,119,233,29,92,229,63,80,67,5,98,50,164,26,134,228,14,133,227,75,238,57,38,216,224,147,56,195,44,221,243,225,244,2,146,155,94,136,133,83,11,110,157,207,63,125,97,62,39,229,115,137,176,144,252,139,95,72,186,136,126,22,37,154,154,205,133,147,75,191,53,
134,19,139,45,254,228,210,119,176,161,211,159,88,124,73,251,244,56,235,182,134,217,217,118,250,25,243,179,179,116,90,116,15,194,220,70,179,207,79,152,253,220,6,194,93,67,184,107,8,247,17,194,125,132,112,31,32,220,7,8,247,75,132,251,37,194,157,69,184,179,8,119,6,225,162,20,195,147,8,119,18,225,142,35,220,113,43,28,26,69,184,163,8,55,133,112,83,8,23,229,224,47,103,135,252,229,108,159,191,156,29,242,151,179,125,254,114,118,216,119,197,241,251,174,88,97,239,69,199,239,189,248,223,79,222,179,138,222,87,86,209,255,0,196,20,50,6);


programfile__We_Are_The_Champions_mid
:array[0..24253] of byte=(
120,1,133,189,217,87,84,103,254,255,187,159,189,171,138,209,121,54,34,131,5,136,40,162,72,16,44,168,42,25,68,16,167,56,79,136,226,128,179,113,74,210,73,16,147,104,247,93,85,49,24,254,139,78,219,157,225,238,156,223,239,140,127,6,139,94,236,92,254,238,190,151,125,94,239,207,46,76,206,111,173,179,14,107,237,181,139,61,62,207,103,30,159,61,114,230,238,184,231,121,9,54,231,93,31,57,243,249,125,207,251,241,181,247,159,160,178,247,238,216,195,39,19,143,31,61,171,57,242,153,247,31,255,248,206,147,77,251,58,59,219,106,142,62,122,126,235,243,71,99,207,57,53,246,160,102,228,197,179,137,155,53,39,95,220,120,48,113,211,142,61,171,57,246,124,124,103,111,116,237,225,177,207,31,221,122,86,188,168,255,209,157,207,199,94,78,60,186,163,43,188,255,92,136,37,130,202,82,239,63,167,130,178,244,3,239,127,148,103,87,31,94,155,241,38,189,236,127,181,254,143,45,246,143,91,237,199,156,239,199,98,129,115,140,143,191,77,255,229,23,47,116,109,19,59,254,171,229,239,140,250,239,53,158,251,95,216,149,140,123,127,47,63,231,253,189,226,
146,251,251,229,67,222,223,175,122,238,39,78,255,196,233,255,117,135,251,137,211,63,149,103,188,159,42,30,185,159,46,175,247,126,186,186,221,253,131,211,255,224,244,127,99,199,233,127,148,15,123,255,168,56,235,254,113,249,136,247,15,238,254,192,233,15,156,254,239,89,247,161,228,11,239,67,249,33,239,67,197,168,251,112,121,208,251,112,181,196,253,147,211,255,228,244,255,118,192,253,147,187,255,89,126,197,251,103,197,164,251,231,229,73,239,159,87,27,221,191,56,253,47,78,255,239,7,220,191,56,253,175,242,122,239,95,156,254,215,229,81,239,95,87,183,186,159,57,253,51,167,255,143,237,238,103,78,255,92,94,237,253,204,200,127,190,124,221,251,153,187,127,225,244,47,156,254,63,171,220,47,188,251,151,242,19,222,47,220,253,203,229,3,222,47,87,215,187,95,57,253,43,167,255,175,237,238,87,238,254,181,252,177,247,43,119,255,122,249,168,247,43,167,127,227,244,111,156,254,191,217,113,250,55,230,253,27,167,127,187,220,238,253,118,53,190,247,167,91,128,101,156,45,81,234,126,186,233,220,79,55,106,248,157,114,63,221,154,228,
248,164,251,192,177,15,55,74,221,135,196,129,226,239,155,252,6,10,118,252,54,191,143,184,15,92,251,129,107,127,230,89,63,243,172,159,19,149,238,103,206,255,204,179,126,78,28,226,56,231,56,255,11,231,127,225,252,47,156,255,133,243,191,112,254,151,68,59,199,57,199,249,95,57,255,43,231,127,229,252,175,156,255,149,243,191,114,254,87,206,255,202,249,223,110,110,118,191,221,72,186,223,18,61,197,223,13,197,223,85,197,227,229,238,55,174,253,109,124,178,121,153,164,230,119,237,15,254,182,43,51,181,98,126,215,206,255,247,143,242,233,142,83,123,191,235,200,248,211,93,39,154,191,235,202,148,44,62,109,118,211,169,227,193,98,87,171,91,220,210,230,22,31,126,234,22,107,186,253,69,47,211,144,79,141,184,239,82,25,175,144,28,139,229,122,175,123,185,244,117,174,253,108,197,223,51,147,219,94,167,51,222,235,222,76,144,75,93,74,188,78,101,118,21,90,39,42,62,56,192,230,160,25,231,252,15,206,103,95,194,6,24,93,89,236,131,91,195,126,61,199,55,4,31,220,102,126,111,117,111,146,25,239,131,171,227,119,146,99,182,231,186,6,126,55,
114,108,23,91,51,219,94,151,27,190,229,229,78,220,227,247,1,206,117,112,205,161,242,104,15,122,220,62,182,22,54,93,219,194,243,247,37,62,184,61,254,235,19,25,254,111,98,211,179,146,28,175,101,95,205,182,217,189,30,214,123,203,249,109,227,245,115,131,99,241,215,131,153,77,111,90,51,235,10,173,163,9,230,188,59,215,51,230,229,178,163,94,190,163,47,152,74,101,220,223,51,94,240,186,39,227,94,103,51,37,83,29,153,234,124,207,113,63,215,117,206,174,201,245,192,113,153,201,242,169,158,204,39,60,195,189,238,202,196,242,29,67,241,66,235,125,159,235,29,247,37,184,39,153,223,63,224,79,119,92,2,150,183,74,167,246,103,234,192,131,3,134,94,174,235,60,248,184,228,242,45,39,203,166,90,50,235,163,177,166,24,95,154,185,28,98,175,57,36,244,92,198,237,49,23,47,0,119,94,174,135,241,53,159,242,166,123,142,7,188,55,152,106,206,172,250,174,39,19,159,78,157,93,207,120,245,94,112,118,55,40,36,159,187,124,235,165,173,140,113,53,120,3,103,227,37,224,108,109,52,127,225,41,224,153,37,108,101,252,174,96,91,167,141,255,55,126,196,85,
52,166,29,241,15,174,158,115,141,28,223,195,94,176,63,192,117,29,252,127,136,125,106,19,99,46,97,207,239,78,240,212,206,249,22,240,55,194,184,155,92,238,196,57,246,194,193,86,182,21,46,119,230,1,251,24,155,104,198,139,129,23,225,109,59,240,143,229,6,47,187,215,103,50,194,75,147,232,164,208,58,94,63,213,154,41,21,30,152,43,52,57,186,153,227,155,114,89,240,212,117,214,229,122,46,251,130,79,190,99,192,230,13,220,203,128,121,109,190,227,8,120,58,15,172,174,187,92,118,188,92,199,128,67,80,104,125,224,242,29,167,189,233,142,115,165,220,39,60,121,194,47,231,107,34,254,56,19,128,195,32,215,113,83,184,171,54,94,57,188,21,250,191,200,243,110,121,139,27,183,187,197,123,181,238,117,135,222,121,210,91,108,107,112,226,37,241,16,207,115,139,217,46,7,15,105,12,159,68,112,174,244,25,187,205,63,215,123,21,188,140,241,123,135,139,230,114,207,224,35,90,23,141,231,91,199,216,183,11,134,165,17,124,27,248,191,138,77,184,49,154,5,191,147,129,224,36,62,204,165,174,137,142,196,155,165,224,53,201,113,232,108,56,22,193,109,108,
37,243,217,154,27,62,235,231,78,28,11,114,103,70,5,231,0,56,239,0,190,192,121,92,48,174,102,28,149,133,214,203,37,192,184,169,144,28,247,53,46,198,235,231,59,14,175,227,57,130,193,250,92,246,18,112,60,11,188,79,249,249,158,236,10,205,179,8,55,15,218,135,39,50,126,174,103,28,158,96,235,186,4,108,207,174,230,221,137,233,142,227,235,217,7,140,25,90,61,11,236,111,186,66,242,222,170,63,193,61,6,221,250,211,169,115,137,249,182,173,193,223,218,50,43,114,29,163,241,249,182,70,253,46,159,111,107,209,94,178,200,95,124,233,49,207,43,28,107,213,177,178,92,215,181,64,56,0,214,222,124,219,30,29,243,120,110,229,124,219,62,253,46,101,236,177,249,182,131,250,237,115,191,199,188,74,230,219,250,29,227,213,252,28,252,225,116,79,62,117,148,49,61,224,217,163,59,24,103,57,112,117,185,212,125,232,218,228,25,112,143,129,15,147,101,252,94,201,38,30,89,207,182,217,7,230,224,239,19,126,111,103,147,28,91,230,147,6,120,161,30,158,105,228,222,38,126,55,251,17,78,110,241,91,252,35,124,239,67,110,234,183,228,93,19,239,107,224,90,147,
87,240,207,14,126,215,115,109,13,231,132,127,241,164,120,84,60,99,116,128,44,25,47,5,247,181,204,45,158,75,31,23,127,175,97,142,43,11,173,183,252,159,42,190,112,146,93,249,142,212,38,240,183,177,144,188,40,26,20,205,113,44,35,188,110,206,101,111,185,136,63,110,198,128,155,87,148,87,205,185,30,104,180,11,92,103,199,184,103,114,229,159,112,181,109,186,235,156,248,98,37,207,220,38,57,52,221,115,37,6,30,124,240,128,12,187,88,205,181,21,200,49,15,156,186,233,244,184,203,239,191,8,127,94,45,131,191,54,126,112,171,24,187,228,114,39,155,228,68,154,121,74,198,237,112,223,165,51,62,114,49,40,52,222,1,158,158,100,174,55,157,190,231,114,3,183,37,199,188,92,239,61,151,111,155,136,207,181,29,46,97,76,59,34,29,35,156,172,230,57,27,188,185,174,163,252,222,196,182,205,158,7,236,56,30,233,144,72,22,117,56,241,139,100,149,248,229,131,235,9,94,15,104,159,174,224,221,28,223,183,118,46,125,114,79,110,248,166,151,27,184,193,251,110,197,117,94,215,194,51,110,174,119,180,230,109,58,179,122,46,205,190,43,179,98,174,107,160,250,
45,58,240,77,99,166,162,208,56,17,204,245,125,166,49,111,227,26,104,107,114,85,238,32,114,39,45,126,97,159,130,239,160,19,193,152,251,109,28,175,15,102,208,165,222,42,158,181,50,119,240,20,215,162,79,144,101,220,203,245,55,2,230,83,199,179,75,10,141,183,141,14,167,187,110,136,231,60,238,19,205,233,25,69,248,159,246,121,215,6,224,29,76,167,175,148,79,193,63,92,227,229,219,144,125,169,235,204,79,186,78,178,90,112,78,75,95,163,87,164,95,154,4,115,230,157,136,243,30,111,161,166,219,45,124,122,200,45,220,232,48,248,47,4,237,192,127,220,45,32,211,22,246,238,115,11,253,123,221,2,50,110,161,100,151,91,56,154,116,111,225,155,133,23,53,110,1,89,184,208,241,137,91,184,185,201,45,124,185,193,45,172,90,239,222,246,33,75,219,50,241,5,15,154,104,28,49,92,22,26,31,106,110,17,189,117,220,114,115,109,189,240,198,22,198,33,90,96,92,240,49,243,43,3,30,208,132,116,158,120,206,91,57,215,117,118,13,48,173,156,78,13,251,140,23,28,141,6,211,93,131,146,7,232,150,167,85,208,224,138,185,222,147,113,112,36,188,9,103,91,184,126,197,
92,250,84,80,104,187,45,252,236,126,195,88,11,141,151,247,2,239,32,151,190,226,12,55,169,113,111,110,96,204,231,188,228,168,51,252,28,204,108,4,167,107,231,250,70,145,13,208,128,240,146,186,243,9,207,139,49,118,158,57,234,10,141,55,2,224,171,235,133,131,93,249,182,17,191,208,246,208,155,238,186,230,166,26,25,211,193,155,37,60,179,134,113,185,233,158,139,142,107,227,185,212,88,18,252,72,239,186,197,3,9,199,28,121,246,85,131,239,219,1,228,215,186,50,183,216,186,198,45,2,71,225,110,113,103,163,91,252,162,93,118,216,10,198,190,129,121,7,192,211,207,55,222,241,5,119,224,235,205,39,207,21,225,250,202,43,180,189,2,174,216,73,233,9,232,246,174,55,191,239,188,251,27,122,115,58,253,165,251,123,197,55,216,245,207,48,222,191,192,198,158,116,127,219,199,253,224,125,174,235,174,55,215,246,101,57,243,42,231,249,165,211,233,187,205,236,43,23,61,207,77,103,111,251,188,87,176,41,95,60,27,56,27,95,253,90,183,88,91,229,22,191,222,229,47,66,39,140,109,243,119,217,140,141,71,240,211,156,192,159,248,5,89,239,185,124,195,87,
222,116,246,43,95,48,153,79,158,119,133,134,47,163,49,102,31,163,71,238,121,133,253,159,219,24,231,246,127,169,177,248,243,251,206,4,140,77,52,226,207,239,79,5,127,219,159,73,240,252,146,233,236,171,54,246,171,52,174,55,251,153,83,239,87,177,55,13,153,184,116,193,226,246,82,183,120,115,147,224,180,225,237,126,198,210,149,137,127,135,77,85,148,99,102,139,21,90,95,114,207,99,228,251,51,55,213,144,49,61,156,79,254,37,200,245,98,59,164,175,193,115,99,192,235,186,155,107,253,210,205,117,124,105,240,17,108,24,115,0,12,165,183,144,193,178,145,100,187,236,103,147,173,211,3,79,166,183,71,191,37,99,164,15,100,75,121,149,243,77,233,224,111,77,200,191,222,72,255,32,111,203,150,106,14,121,243,77,99,254,210,139,46,199,57,183,116,181,43,190,244,164,171,116,233,80,187,63,205,56,150,46,183,151,45,165,246,250,75,227,123,253,183,173,17,28,151,60,248,28,153,40,249,243,22,217,202,220,132,111,199,115,253,92,63,120,206,178,165,144,137,77,95,186,41,225,186,255,153,95,104,127,224,21,154,30,250,243,201,171,110,126,223,85,193,
210,99,94,222,28,215,48,23,205,109,155,108,201,72,87,237,98,30,29,252,62,196,92,122,176,169,37,31,196,139,146,21,226,191,205,156,143,179,247,180,109,120,211,142,14,238,207,148,191,97,252,70,35,3,183,99,134,131,166,18,183,120,104,181,91,28,217,226,203,38,90,92,219,228,22,145,21,69,127,194,55,91,8,217,2,142,76,87,130,155,196,235,254,76,192,60,75,222,54,101,202,243,117,223,248,83,77,25,191,208,2,77,212,189,0,23,247,109,158,185,158,59,204,241,1,60,13,157,182,255,5,124,92,250,136,155,185,150,111,124,230,83,198,252,182,126,55,0,237,14,220,77,25,206,7,176,109,122,50,53,51,93,163,110,126,79,54,248,219,158,76,25,184,99,252,210,19,146,131,43,152,147,233,110,111,126,143,230,184,213,125,15,221,74,111,115,45,255,39,221,76,10,23,207,244,176,116,242,30,96,243,209,206,229,30,217,187,135,116,45,50,42,149,248,30,153,62,147,62,207,117,105,111,190,25,154,109,206,84,204,55,131,255,230,76,124,38,123,215,255,62,157,137,207,55,51,142,230,204,138,239,241,5,230,155,239,248,51,125,227,142,255,55,190,169,211,51,122,184,87,118,192,
71,250,137,189,105,65,118,214,101,220,247,125,216,44,3,25,116,157,231,205,244,93,241,102,6,39,220,108,122,220,155,77,221,241,102,15,222,113,249,186,73,222,9,158,27,78,187,92,159,116,36,124,149,122,228,253,3,156,23,234,30,233,29,238,111,13,153,242,66,203,184,227,93,229,60,215,47,212,221,46,231,183,43,180,220,44,43,254,207,248,174,106,124,126,116,252,65,241,186,9,127,190,249,152,142,7,209,241,219,203,215,7,51,3,215,125,198,198,187,207,187,239,7,51,62,215,120,209,53,19,37,63,32,87,126,192,78,251,1,25,198,243,3,232,151,177,76,248,175,251,248,157,178,103,113,223,113,222,127,91,247,149,20,199,160,249,50,110,207,255,126,32,19,231,89,222,108,230,177,205,111,182,251,190,205,53,215,135,78,238,190,229,21,90,30,184,92,230,115,96,241,0,152,140,123,243,13,55,121,222,21,159,57,107,190,30,243,21,252,152,231,163,82,158,19,48,119,189,195,21,234,238,235,127,104,236,118,241,255,207,153,223,197,63,205,239,94,105,116,221,147,146,249,230,207,12,22,122,30,215,23,231,253,121,9,115,118,51,208,162,230,173,49,50,119,230,241,84,
239,229,253,94,201,235,110,155,179,211,220,153,179,99,206,222,15,221,25,247,67,6,153,152,17,29,156,213,125,6,47,230,81,193,251,184,238,85,132,235,104,222,140,239,190,155,237,121,236,205,102,63,103,254,223,50,199,49,230,255,144,121,62,116,51,131,143,121,247,168,207,28,157,238,229,189,224,29,187,72,60,210,131,124,171,155,116,192,1,124,191,90,198,55,199,190,40,206,251,69,113,126,47,152,223,85,157,103,236,70,35,69,28,60,215,117,28,19,92,206,70,112,49,184,125,93,162,49,243,204,132,222,25,225,253,28,112,184,34,220,51,254,175,141,206,36,155,222,34,31,222,130,243,232,250,167,49,249,83,226,201,8,174,15,3,193,5,152,184,31,56,62,223,124,194,253,128,238,16,236,10,45,223,10,222,113,104,192,231,218,24,176,116,208,65,201,204,224,67,111,102,96,20,121,0,173,39,161,245,134,39,204,255,137,155,237,125,0,125,124,101,178,32,151,121,100,52,159,27,64,150,247,62,242,102,187,158,32,239,158,121,115,29,108,169,11,162,127,193,9,31,24,158,104,157,252,12,89,234,97,31,136,22,125,112,178,1,217,28,96,7,151,254,192,113,240,228,253,192,
60,144,165,113,225,86,180,248,22,254,70,246,122,200,170,216,124,242,9,58,234,186,201,209,124,213,19,228,236,115,27,67,161,10,25,219,142,45,209,58,234,230,58,71,77,230,46,94,216,140,204,29,69,143,62,244,22,15,111,245,23,119,111,115,139,21,213,230,51,46,246,212,187,197,170,157,242,23,125,139,187,36,247,187,197,160,221,45,222,232,144,223,232,47,54,167,150,99,48,53,145,173,191,1,249,80,195,38,223,192,100,17,191,205,63,148,12,170,140,100,182,124,109,197,67,20,11,217,195,117,146,109,181,108,242,181,229,167,84,112,76,178,220,252,6,151,27,1,110,253,208,206,224,99,55,223,86,47,255,168,22,89,92,50,223,112,203,225,15,186,215,35,38,59,28,114,218,159,111,107,214,249,42,116,112,124,170,10,61,147,185,30,207,87,141,115,95,147,142,67,127,192,190,255,58,207,186,239,230,118,142,87,188,169,2,166,200,117,158,227,115,191,104,160,2,218,16,12,221,219,78,244,34,252,96,207,201,222,244,223,238,196,78,173,190,207,59,234,176,17,78,59,131,35,48,212,115,129,31,48,69,86,162,219,10,213,207,188,66,243,179,141,111,170,51,177,55,205,153,
132,158,99,244,134,174,100,220,142,177,121,139,27,122,98,83,213,166,35,131,69,15,27,38,51,225,45,94,247,35,27,97,96,21,227,237,116,133,61,95,122,133,218,73,15,155,193,155,235,68,126,36,111,186,124,237,87,122,182,183,248,162,198,155,59,192,251,120,55,58,204,155,219,19,189,91,58,212,240,20,225,40,210,103,194,209,134,30,211,105,140,7,59,64,112,21,142,164,79,83,248,174,109,236,123,124,158,181,34,58,150,228,255,63,116,169,96,48,157,186,128,255,141,204,62,38,92,220,18,30,124,233,119,238,145,173,89,253,166,86,122,41,230,191,217,163,253,10,238,151,111,83,235,191,181,255,27,13,150,111,15,232,220,30,116,192,37,206,237,199,7,110,101,142,143,189,66,237,43,142,183,71,243,129,7,94,31,3,158,157,227,194,173,167,249,137,102,192,13,115,28,229,190,148,244,16,182,184,124,2,209,145,252,51,211,71,208,140,183,2,59,187,98,190,173,91,184,118,196,11,188,92,230,25,227,189,23,204,99,27,129,27,27,143,225,227,64,102,51,99,118,140,119,5,188,229,77,119,94,150,13,101,239,153,111,75,27,93,25,46,107,159,123,133,61,240,231,158,27,154,107,
130,123,2,238,169,156,170,205,172,252,174,51,19,7,6,254,52,242,140,121,250,185,33,108,218,254,39,208,216,35,236,69,240,212,240,151,64,118,229,220,126,248,13,252,205,17,3,147,63,63,159,52,190,211,243,68,47,91,35,157,47,159,92,241,42,241,140,230,165,152,148,217,110,236,211,220,103,115,42,198,216,106,152,171,236,4,175,214,252,214,206,211,203,231,171,222,18,43,192,182,44,133,142,189,215,67,108,240,4,243,21,204,3,228,75,192,220,124,198,99,116,51,5,172,243,251,225,131,206,113,127,174,135,45,59,26,199,167,229,125,30,207,246,121,71,9,123,249,240,102,131,176,223,194,49,241,168,108,203,58,126,239,224,218,122,135,125,11,142,20,103,107,146,205,203,241,102,96,153,130,79,122,53,63,209,149,226,23,92,211,228,242,123,110,113,239,14,124,108,197,94,238,3,175,59,192,9,126,217,63,193,121,61,87,116,83,202,51,140,247,161,177,73,127,106,15,182,169,244,8,207,6,230,27,230,219,14,97,175,223,117,75,173,216,169,201,33,155,203,146,119,72,54,150,195,78,231,121,47,99,75,55,219,221,210,209,118,217,208,113,217,225,75,147,123,133,91,139,
1,45,173,105,181,49,35,243,75,150,90,235,221,210,234,122,127,169,161,62,0,110,78,118,172,209,7,49,158,183,200,130,249,125,196,143,234,30,154,236,212,28,230,147,119,252,220,0,227,6,199,185,30,240,92,247,53,122,23,125,206,187,77,30,116,129,231,150,113,241,196,29,112,32,251,206,71,134,87,202,223,64,223,72,14,196,165,99,222,212,33,87,234,50,137,185,142,113,108,121,238,73,141,199,242,73,108,134,36,254,81,235,51,104,100,2,250,229,61,232,143,28,178,97,126,223,9,179,51,245,30,236,98,98,139,147,103,166,83,227,159,32,255,75,204,222,110,229,217,248,107,138,151,160,35,20,39,243,68,215,26,179,228,181,116,137,228,56,252,33,223,197,228,123,190,10,218,110,122,130,223,131,236,193,55,230,185,94,161,234,11,111,113,180,206,17,35,132,102,47,72,166,69,250,2,249,54,111,49,25,228,11,126,53,227,240,22,241,179,241,251,156,233,128,242,180,228,75,147,225,84,114,2,155,127,158,56,99,68,75,107,12,71,145,140,223,7,110,37,119,14,5,226,105,241,49,112,42,97,188,91,160,115,104,134,24,236,200,61,238,151,188,127,32,218,41,71,190,123,156,
55,222,228,122,232,236,16,124,32,30,209,179,44,30,197,30,58,196,143,17,13,33,211,217,111,229,216,26,209,18,155,249,58,101,162,155,66,211,109,205,209,100,16,207,150,125,82,141,124,247,145,201,49,100,51,190,215,211,88,190,234,1,99,239,52,25,50,159,204,42,22,27,201,146,254,155,200,121,236,16,226,116,26,187,193,88,247,117,98,11,84,33,235,185,31,189,145,0,199,43,241,123,220,116,255,83,233,14,226,132,159,58,61,123,62,121,69,243,49,216,21,170,145,237,205,159,251,115,205,143,18,232,137,64,114,89,113,89,240,229,227,183,120,249,218,151,110,122,80,48,28,226,190,91,238,45,246,157,124,149,194,158,251,94,161,22,124,9,7,240,149,225,161,127,111,36,95,82,227,110,49,185,95,114,212,100,165,249,228,196,118,161,21,175,168,167,131,197,242,180,252,207,162,14,168,6,70,242,17,59,145,231,146,249,41,27,159,232,45,55,40,28,140,115,204,124,199,149,198,59,17,77,225,95,202,15,144,254,86,60,196,96,187,250,59,206,77,247,79,72,47,56,243,247,142,193,223,131,247,245,188,53,118,47,50,29,120,197,139,50,119,181,104,21,153,233,164,19,128,95,
80,216,131,173,218,134,156,107,184,232,10,181,15,52,254,143,115,50,61,39,219,200,116,129,222,183,154,77,246,130,232,107,63,115,48,121,201,94,116,209,179,38,162,47,233,5,93,103,114,36,177,12,215,104,110,240,20,114,103,190,173,3,223,243,176,224,40,217,1,175,76,198,138,227,18,78,53,182,114,233,53,228,253,74,228,125,188,176,231,137,141,141,251,224,207,207,208,197,183,136,39,98,83,71,56,117,140,217,55,154,16,109,100,160,135,90,182,61,153,114,100,180,236,144,128,249,150,240,156,10,198,130,189,60,129,236,248,2,217,241,5,248,197,86,67,7,107,12,232,90,193,140,231,62,115,115,146,37,200,201,185,22,96,209,62,142,174,153,76,22,99,197,49,98,161,248,154,55,37,71,43,144,49,81,12,97,32,83,35,189,156,83,204,2,219,63,55,52,161,177,197,144,63,81,206,96,72,186,70,240,80,206,75,250,67,242,93,113,122,217,92,146,235,117,178,139,193,193,168,108,99,207,116,9,54,166,120,75,182,41,242,27,152,29,146,253,203,239,61,145,93,207,88,115,67,95,241,190,73,142,65,123,61,240,74,246,235,72,102,152,44,148,206,94,198,79,74,118,51,255,247,144,
103,72,251,60,223,226,48,69,185,8,60,191,214,57,100,93,79,209,46,120,6,108,250,124,228,146,193,6,252,114,94,62,191,104,86,54,207,36,251,109,204,69,122,169,134,223,141,210,231,140,67,239,75,249,194,29,207,227,92,122,21,112,247,21,211,2,7,65,190,26,254,78,158,240,11,205,47,177,213,76,118,243,206,163,22,207,1,86,166,55,231,154,39,5,179,56,188,233,193,155,43,177,213,202,224,193,210,252,246,111,145,159,39,92,97,59,54,250,174,73,195,93,113,124,178,135,252,185,93,147,187,139,54,104,195,212,118,252,168,182,54,179,59,193,157,203,111,63,13,77,159,84,28,95,188,133,204,63,73,76,139,255,83,146,243,143,234,184,30,155,246,166,244,180,151,223,254,16,94,58,164,123,55,138,63,136,163,37,240,79,35,29,6,239,32,207,3,174,143,229,183,143,64,59,29,146,27,140,165,31,93,126,205,228,130,158,159,59,12,141,244,240,108,252,236,185,253,28,79,102,20,63,171,226,62,135,174,243,223,176,127,179,75,239,194,126,72,126,182,76,131,70,127,216,8,101,175,15,3,11,233,76,233,176,20,58,76,60,139,205,243,118,23,186,107,123,166,92,207,0,22,130,129,
108,43,79,250,35,95,253,133,55,211,133,255,159,125,224,23,170,159,122,179,61,215,189,89,116,156,198,87,104,198,31,38,126,149,203,98,127,119,48,62,104,27,91,21,28,121,222,92,51,254,7,52,111,242,139,235,165,179,100,167,44,158,63,232,136,223,17,115,27,149,159,225,144,95,210,51,240,193,94,193,6,59,80,52,28,217,154,178,47,34,185,36,26,73,73,22,144,175,72,175,42,194,81,255,67,11,138,95,108,96,51,185,181,158,120,138,124,60,239,123,124,191,31,200,53,67,35,17,175,104,175,24,97,71,38,62,155,186,198,28,206,25,95,204,224,195,205,116,93,133,15,90,165,59,188,233,20,182,129,120,160,107,76,122,130,57,105,110,247,27,163,231,175,229,61,53,198,51,138,237,235,186,136,126,45,151,128,190,147,28,149,15,180,70,239,102,239,28,116,38,120,56,197,37,24,91,236,251,76,38,152,237,185,192,251,47,249,51,232,161,25,242,6,249,234,49,104,227,136,229,136,166,137,59,205,39,7,236,217,115,189,159,57,108,76,225,121,165,241,86,7,186,9,28,73,119,96,127,4,196,138,245,124,7,77,251,154,175,98,73,208,182,205,159,247,39,76,95,172,60,224,128,129,242,
139,204,243,156,217,75,197,88,183,55,147,185,235,102,83,55,5,11,87,228,29,79,248,201,87,127,13,28,136,109,36,159,152,45,144,203,64,115,93,196,120,58,144,67,169,207,229,235,24,255,130,55,124,221,115,242,117,5,63,55,151,145,207,68,140,160,45,211,140,60,226,88,55,48,144,173,89,171,249,176,223,193,166,184,150,112,118,0,91,179,19,252,153,253,79,252,47,189,14,189,42,26,224,152,224,40,127,64,118,133,249,149,28,107,10,138,248,227,152,116,219,22,139,129,71,244,226,241,191,231,35,163,215,154,191,44,186,110,5,70,200,94,224,46,184,24,62,102,187,70,189,217,3,224,189,45,235,192,131,241,133,226,248,242,243,166,187,136,203,75,79,166,208,37,92,167,185,206,144,131,146,61,55,147,66,111,55,92,117,115,169,235,70,35,204,179,9,187,95,99,5,231,209,187,35,250,80,108,179,212,129,3,112,46,59,187,180,136,255,18,195,81,228,131,153,157,175,241,42,62,236,231,209,141,75,141,253,78,241,250,165,216,128,91,186,212,167,188,46,182,46,118,2,118,6,124,234,45,117,14,187,165,3,69,187,248,217,144,15,223,122,75,231,142,43,174,163,216,172,249,
182,75,216,185,154,39,115,118,196,5,43,21,75,248,225,64,38,134,156,92,81,228,223,64,49,187,217,238,27,226,95,112,123,147,24,237,41,211,147,185,44,177,206,110,230,222,197,214,241,196,236,70,217,150,211,3,47,189,197,146,93,240,42,54,109,55,242,173,29,252,182,140,69,185,102,98,172,133,186,175,60,248,219,236,17,226,40,158,217,142,17,127,251,197,58,142,29,69,187,11,92,47,251,31,149,204,253,163,126,2,175,194,165,248,92,124,35,92,11,231,157,216,132,31,233,130,124,171,197,0,226,130,139,96,134,28,119,175,187,51,196,30,68,39,146,13,205,60,71,182,139,224,111,248,8,138,252,224,136,129,121,240,66,41,177,76,241,140,247,150,152,216,108,247,101,96,112,213,116,227,12,182,242,76,215,117,233,71,217,119,192,188,73,122,58,178,253,53,103,116,245,124,195,41,227,71,233,3,201,8,211,213,221,208,8,113,250,92,199,173,85,60,83,177,255,128,103,248,232,91,198,37,95,123,59,155,252,191,189,140,205,244,37,191,83,240,249,167,236,205,55,231,120,122,213,50,173,79,213,137,102,20,87,17,28,148,111,21,156,204,214,137,201,183,144,143,33,121,
198,124,150,231,22,51,187,178,254,5,56,61,197,124,78,198,166,7,158,24,205,206,100,111,48,143,14,191,80,143,78,219,135,191,186,15,157,136,190,65,247,74,174,175,145,108,2,134,30,48,148,60,180,188,9,207,77,8,70,200,227,64,114,4,248,249,83,245,208,19,186,154,188,11,239,184,6,124,136,135,118,92,36,190,81,195,123,164,19,238,185,40,110,49,233,222,160,43,222,212,163,47,118,226,67,237,196,62,61,154,100,12,253,200,80,98,167,228,134,160,39,104,238,161,203,117,96,135,118,143,25,60,63,250,29,138,215,67,71,138,217,163,207,228,223,4,31,105,73,181,12,203,49,169,72,87,84,21,117,197,230,8,206,107,129,153,252,103,197,156,36,87,4,67,171,7,129,134,210,216,234,196,191,229,115,48,159,101,249,193,188,87,254,33,95,36,143,148,219,54,88,139,94,12,206,204,223,3,14,9,217,179,192,23,57,125,10,121,249,144,249,159,115,249,102,98,129,109,189,254,212,78,243,199,108,46,111,118,90,126,2,121,33,27,66,52,115,30,121,130,254,232,46,230,96,59,110,224,139,68,242,3,28,32,111,159,238,42,202,16,108,214,1,225,5,59,92,180,43,255,102,35,91,13,91,29,
115,16,13,137,63,52,55,217,73,237,228,20,68,35,13,222,210,102,201,200,109,108,165,222,210,6,217,82,158,183,84,42,93,228,185,165,23,135,130,165,79,63,117,75,235,62,197,182,61,137,45,96,190,187,242,66,38,247,150,58,90,131,165,70,182,173,205,254,210,218,102,95,180,96,120,199,199,92,234,174,23,12,204,223,20,255,44,235,139,165,235,245,193,210,39,53,241,165,75,91,253,165,201,13,146,61,138,135,85,206,116,142,57,209,220,108,234,150,55,219,126,205,87,158,110,186,31,217,160,152,35,126,232,20,242,48,223,116,23,63,237,137,167,28,77,161,233,113,68,31,102,107,220,129,70,200,247,75,238,118,34,135,218,175,58,229,31,129,135,217,31,138,133,33,219,148,247,139,108,80,226,115,139,183,119,71,126,108,19,191,79,182,56,108,14,127,153,126,138,62,210,159,227,152,109,145,142,16,60,69,35,38,99,138,52,98,182,228,202,98,12,18,184,10,158,202,177,8,222,194,129,248,216,228,73,37,118,82,5,252,230,227,91,67,83,205,232,2,98,144,13,199,133,123,71,156,69,246,116,77,196,179,181,220,179,236,199,72,150,69,117,6,216,141,208,133,241,95,209,239,
209,187,20,43,149,173,99,182,203,118,124,214,196,244,0,177,2,243,99,76,230,88,12,4,121,159,40,250,163,146,89,1,190,103,25,250,45,120,77,28,242,117,59,116,77,110,67,50,17,254,77,68,188,137,125,145,190,2,173,142,186,31,176,255,167,251,111,123,194,137,116,33,185,46,239,123,124,33,104,216,233,218,121,248,187,80,253,202,226,143,210,247,138,69,206,181,141,153,204,151,253,7,31,27,46,204,206,131,119,193,141,217,118,196,82,34,57,136,237,139,142,112,139,151,247,56,139,31,4,228,141,197,179,81,124,178,46,130,159,106,239,68,199,6,15,246,248,4,109,107,196,151,252,78,239,44,194,31,219,79,114,82,112,151,174,240,214,65,55,171,36,227,148,227,207,183,43,158,125,155,251,186,125,242,254,222,92,246,166,241,221,2,113,141,249,134,49,183,192,59,149,239,7,15,13,249,182,199,254,20,112,82,124,128,120,82,164,231,129,15,52,85,71,30,27,24,83,23,210,58,97,54,211,124,242,24,188,65,78,13,158,148,111,32,29,202,184,34,93,209,108,244,29,199,86,95,201,124,29,249,37,55,69,60,70,114,24,89,162,252,187,228,168,106,128,4,123,114,110,232,146,131,
151,252,233,190,39,192,159,154,186,221,223,194,19,232,218,125,103,252,66,77,148,51,40,236,254,154,218,3,244,232,110,249,11,210,195,87,196,251,200,130,86,213,81,144,71,67,175,112,92,49,10,198,17,151,254,183,124,191,228,53,121,242,8,54,146,17,138,201,126,212,163,200,9,233,81,209,183,104,87,49,20,197,82,218,57,222,137,157,124,136,58,36,171,73,226,29,39,120,62,239,208,123,178,215,57,39,121,169,235,133,31,193,94,246,183,39,248,151,191,169,1,38,187,209,3,187,51,9,205,29,250,209,24,124,27,143,236,42,201,72,213,34,176,255,174,15,253,73,222,158,90,12,230,126,158,121,51,255,118,98,27,204,187,176,27,159,24,24,131,71,224,115,197,45,140,214,201,159,0,111,231,34,28,138,183,179,55,172,214,67,250,117,1,218,1,151,141,249,54,197,165,63,117,224,18,60,14,234,90,241,3,254,176,106,35,144,171,105,106,194,84,79,24,213,67,104,108,26,203,22,112,108,227,98,124,129,114,130,240,149,209,126,190,245,137,211,251,225,49,222,79,94,43,170,227,98,172,232,75,226,255,179,233,171,248,110,81,220,253,143,119,156,47,127,187,27,61,40,248,51,103,
222,161,184,156,112,34,31,78,126,186,95,132,83,41,180,17,7,30,166,59,161,7,217,158,62,239,247,169,171,224,125,19,110,154,60,233,76,215,184,159,111,121,17,213,240,65,199,179,61,248,34,237,103,177,165,94,16,59,120,14,173,140,56,114,52,140,231,161,100,94,100,139,41,6,132,77,194,220,21,211,240,168,147,45,218,98,208,17,254,121,49,94,167,56,208,222,92,246,50,62,203,5,116,110,47,182,133,116,154,242,206,155,4,23,217,78,230,7,40,46,240,135,221,101,58,83,116,2,206,83,248,87,61,37,102,223,244,224,107,118,157,84,157,156,238,245,229,63,68,242,81,246,150,100,168,233,32,238,81,61,173,209,12,123,207,81,123,165,28,170,236,149,101,159,36,134,12,178,188,219,2,114,61,223,126,13,24,220,1,30,119,144,159,23,221,130,236,130,182,29,170,235,1,22,228,216,101,95,201,199,149,45,154,189,231,81,243,3,124,206,68,116,178,165,77,177,77,183,192,252,11,45,228,192,234,158,58,232,206,179,186,33,47,179,150,177,70,182,97,79,102,133,248,63,223,118,135,184,10,58,165,71,113,183,109,248,170,228,229,137,255,21,233,72,181,151,17,92,136,91,68,176,
210,60,150,249,74,246,155,98,226,203,250,87,118,130,230,108,58,88,240,98,75,41,238,27,48,87,79,52,39,91,206,236,64,123,94,26,25,35,59,108,219,178,12,138,228,40,57,131,92,23,56,202,222,76,216,251,185,22,248,42,198,232,99,63,174,83,76,164,104,127,241,60,141,197,243,229,207,74,142,235,55,52,166,216,38,245,36,138,43,63,112,243,45,29,208,202,57,63,159,188,109,207,255,27,118,162,124,243,92,23,60,130,60,202,165,209,173,232,1,124,28,229,26,205,159,33,166,236,205,239,218,131,222,194,206,237,34,15,66,204,192,198,130,206,159,226,154,34,31,37,160,121,158,59,174,90,9,205,139,124,194,184,249,27,208,98,48,215,113,51,208,181,115,173,55,75,243,201,231,113,241,71,52,38,108,35,197,55,129,173,238,147,92,149,143,162,120,73,20,43,32,94,208,193,152,168,125,145,223,69,156,198,151,143,133,174,241,231,186,198,2,116,233,87,134,71,201,25,234,54,129,77,201,116,250,201,102,158,149,208,24,150,46,31,18,47,58,217,59,228,11,220,210,241,46,183,20,28,138,47,77,144,31,8,62,181,186,110,229,9,148,91,93,58,214,106,53,102,211,41,106,92,94,81,
223,114,1,91,103,112,167,91,218,92,237,150,50,91,221,210,23,155,131,165,216,134,245,75,23,214,250,192,172,12,95,208,230,159,111,194,94,93,121,128,99,147,142,92,170,141,127,154,88,0,118,8,252,217,239,10,85,143,25,251,48,118,204,125,226,199,195,204,23,253,143,174,180,92,36,190,98,14,29,32,94,165,38,197,106,170,168,215,141,106,83,200,189,34,55,44,238,43,185,142,29,35,220,71,249,189,228,126,223,106,86,164,63,229,67,101,187,2,226,36,9,243,163,202,211,49,120,251,97,174,143,26,189,17,100,212,224,184,98,232,150,79,35,167,93,15,93,224,95,153,204,134,94,196,243,218,100,83,168,110,40,242,73,77,94,166,20,211,184,10,29,149,65,187,101,156,47,231,252,50,189,111,224,25,27,217,172,62,158,227,219,184,102,59,251,186,168,214,140,113,75,102,48,222,245,216,34,156,171,143,19,31,199,102,149,79,159,228,190,58,114,36,30,215,136,111,20,123,84,12,79,250,105,181,193,171,208,244,128,115,43,224,255,147,236,197,103,113,98,157,200,41,209,66,215,105,142,41,134,233,201,254,223,1,222,203,161,1,206,93,81,172,106,111,174,235,138,116,236,
46,209,5,48,110,205,245,156,19,93,180,80,175,136,238,222,37,217,100,60,205,121,114,2,86,175,91,138,157,35,189,129,13,96,181,186,202,33,168,118,8,58,244,252,66,213,83,171,115,154,39,86,167,56,190,233,195,131,151,101,39,196,121,127,189,100,187,240,147,107,167,62,187,61,83,159,111,58,239,23,154,168,91,168,202,52,243,12,230,243,32,150,27,185,226,229,250,142,18,19,31,223,10,46,148,111,142,131,11,228,205,153,56,99,219,85,104,186,166,235,99,185,212,229,114,158,85,198,120,214,194,183,101,26,67,161,106,212,120,52,223,209,177,138,107,214,80,203,186,58,215,117,12,250,161,222,175,131,248,97,207,133,32,223,245,105,220,248,64,242,33,242,215,18,83,93,153,79,114,89,193,236,76,81,198,159,138,231,187,218,155,24,207,6,174,137,108,146,72,158,108,203,117,92,218,196,92,54,170,54,182,232,63,91,189,56,207,220,198,59,21,63,47,225,121,208,234,13,47,223,126,208,104,125,190,237,51,217,100,140,239,243,70,96,16,203,181,95,94,201,252,119,20,154,46,106,46,45,185,44,115,62,136,252,194,62,193,150,215,28,148,163,49,56,243,46,47,127,240,
224,46,238,243,167,208,199,185,246,11,130,225,74,96,177,133,103,80,131,120,5,126,153,136,243,28,209,147,114,43,73,209,75,161,245,33,114,227,37,117,237,204,73,243,202,170,158,254,28,53,209,231,85,67,174,90,240,101,159,63,242,67,144,133,188,203,167,182,88,117,126,219,243,169,171,220,79,190,177,245,41,180,113,92,244,3,61,1,203,14,96,217,115,161,101,186,227,202,118,96,163,113,56,213,131,75,143,77,35,15,115,29,103,245,220,102,197,249,166,187,174,7,156,91,205,117,91,84,83,172,88,37,61,24,58,31,151,15,51,157,186,234,203,143,177,250,50,236,97,171,143,84,29,226,178,223,42,158,253,2,159,85,53,20,240,46,99,243,100,3,75,222,154,110,142,108,97,201,36,245,16,136,166,75,53,102,213,4,80,51,137,158,136,234,192,25,187,251,153,38,167,31,211,99,202,235,5,212,123,82,151,126,57,137,60,134,142,198,253,31,225,223,185,20,57,137,84,166,154,26,74,108,65,15,62,18,159,203,30,84,156,77,190,196,86,247,99,199,24,251,72,127,81,55,204,111,245,184,52,194,171,203,182,225,126,254,111,135,103,77,135,197,255,154,202,168,167,133,235,164,219,
26,252,220,240,41,248,81,188,235,211,55,113,148,223,158,199,187,99,185,51,119,53,46,213,240,151,80,195,191,142,26,254,21,185,65,226,149,187,183,5,127,219,109,57,202,164,230,92,104,189,19,204,239,174,211,177,196,95,145,227,196,41,183,242,14,255,175,200,115,108,39,195,105,33,249,23,199,53,146,187,142,235,220,143,93,99,200,255,179,187,230,119,39,221,52,250,96,174,99,212,211,60,116,46,170,5,87,44,118,52,6,30,35,93,213,147,169,42,214,245,151,204,183,108,143,250,44,44,94,123,13,252,162,11,209,201,63,82,63,62,151,61,91,204,141,41,119,168,124,180,236,100,229,152,100,199,124,204,199,151,240,220,162,141,67,157,54,52,16,217,194,38,147,212,63,160,30,25,120,244,248,10,209,199,116,207,205,234,200,46,160,174,64,60,132,221,130,142,3,31,242,193,37,251,204,159,139,49,223,82,197,159,255,10,237,161,183,137,169,158,41,17,77,255,85,186,145,88,48,122,44,46,217,149,79,29,131,134,39,5,11,233,107,225,24,120,203,102,177,156,165,114,207,141,210,201,204,191,238,15,59,69,243,145,189,174,247,213,170,222,137,49,203,86,105,84,124,144,
253,46,108,89,201,122,249,152,228,19,83,163,22,75,196,118,3,239,29,248,90,135,84,27,194,111,209,65,135,122,61,184,71,182,96,147,3,87,146,147,232,153,94,238,79,82,231,60,192,94,245,12,229,197,62,26,233,23,209,196,125,241,155,229,200,114,103,38,168,45,63,171,58,232,4,180,225,67,27,21,208,202,38,122,105,246,40,135,150,235,189,36,251,195,169,255,130,92,71,21,244,155,224,61,202,207,89,189,46,253,15,208,81,173,229,187,161,5,225,157,26,134,43,205,208,128,120,221,67,206,113,190,14,90,56,13,188,145,67,89,120,129,122,117,174,147,46,48,187,22,92,56,100,154,228,222,74,100,171,63,223,178,51,242,21,176,177,169,131,23,77,184,31,137,89,205,245,94,216,77,239,141,198,34,25,35,154,18,79,138,174,170,145,197,146,5,224,155,190,1,232,144,231,212,115,172,36,223,211,174,24,173,226,226,38,71,115,93,87,101,191,37,192,49,249,73,231,171,167,35,138,197,80,27,99,191,197,79,135,68,251,30,248,7,7,251,197,59,30,184,23,44,101,203,24,140,197,195,232,57,240,126,129,103,95,246,243,169,94,240,190,219,169,214,91,240,69,30,35,171,213,111,160,
188,94,13,155,108,210,70,246,248,4,41,100,101,234,50,207,163,158,6,191,68,246,40,50,140,248,163,241,50,215,201,175,211,181,146,5,162,23,163,203,85,140,163,12,25,162,247,241,238,83,196,176,149,87,85,204,162,131,123,148,143,151,31,174,250,92,221,183,138,205,240,29,227,190,68,174,247,6,247,157,149,109,198,125,122,158,104,80,227,82,175,137,248,235,227,123,148,207,160,31,236,164,159,163,22,30,156,171,150,167,140,123,87,74,22,240,187,52,151,58,203,179,206,24,222,127,76,221,53,127,26,124,202,14,227,190,97,233,15,7,157,196,249,63,193,115,62,210,138,206,75,47,252,190,33,235,126,63,157,69,62,159,245,126,79,103,213,67,99,53,57,191,19,7,152,223,221,228,126,39,246,245,251,183,237,162,17,143,223,122,174,255,123,243,167,254,239,101,159,250,211,233,51,254,239,216,140,58,255,59,245,207,191,63,107,47,17,221,115,47,188,16,195,223,58,203,92,14,65,111,248,228,214,123,116,9,248,166,189,31,219,111,33,219,170,36,219,62,210,28,244,3,15,245,112,189,100,138,252,110,201,217,90,182,245,102,127,98,235,224,103,123,200,181,179,202,
145,10,159,37,208,24,182,2,207,54,122,190,26,252,21,251,254,199,118,106,193,91,136,63,163,3,127,127,70,188,31,25,150,239,56,232,77,183,157,244,126,63,55,36,189,18,252,62,49,148,248,253,47,67,193,119,232,105,232,146,57,12,149,253,222,55,228,115,62,198,62,206,190,20,154,245,56,174,223,9,246,49,174,215,239,56,191,125,126,171,215,198,231,222,101,223,71,207,12,116,127,190,139,119,117,92,215,51,29,215,249,216,102,186,191,226,247,196,176,255,123,237,112,226,247,149,195,58,238,236,57,231,134,74,236,186,149,195,9,122,114,124,241,140,217,19,196,133,243,61,159,122,203,215,65,39,202,219,36,196,103,204,49,144,237,30,241,209,213,181,240,140,104,202,236,70,229,203,229,63,8,119,178,215,127,108,141,98,196,57,98,9,185,222,11,216,3,189,240,196,121,213,92,111,134,119,18,208,83,28,154,167,159,240,138,228,165,226,36,244,129,222,87,143,19,184,240,160,97,209,166,217,190,224,163,140,77,126,176,120,168,146,223,178,121,87,178,137,182,165,231,100,243,170,118,66,182,108,29,184,210,190,190,44,210,131,141,200,188,171,156,107,242,115,
103,110,25,79,74,198,34,231,56,38,121,91,199,86,195,251,68,251,210,191,122,135,229,120,212,203,185,1,89,24,32,11,145,165,87,164,207,84,23,83,5,237,150,75,246,160,231,203,160,239,53,200,192,53,146,253,162,217,66,114,194,23,109,41,239,199,117,43,153,207,6,116,104,9,114,70,114,153,190,78,228,44,121,169,31,241,145,231,119,55,99,207,143,211,251,65,159,82,212,51,21,201,195,200,175,21,125,150,0,235,82,116,151,122,246,144,135,212,76,66,83,17,108,26,160,109,217,72,202,223,154,12,241,126,236,186,207,216,83,210,189,204,39,242,243,133,43,230,139,174,128,126,187,238,85,254,181,39,67,92,33,97,54,14,52,14,12,246,113,79,135,116,45,123,211,167,210,45,252,150,46,209,249,143,121,140,213,60,43,49,221,51,22,207,183,156,94,47,26,132,111,84,79,37,29,89,49,77,15,37,177,3,250,181,70,215,192,35,1,56,142,252,174,244,195,128,243,149,212,177,197,191,67,103,224,211,211,163,117,139,222,18,122,54,136,13,1,35,201,209,200,207,29,32,102,209,171,152,26,121,173,229,26,142,182,195,210,159,254,95,241,155,145,189,210,197,171,35,157,169,113,
91,108,22,126,239,41,242,233,129,196,107,114,32,54,87,250,111,232,129,218,56,157,186,164,247,170,183,141,247,109,48,25,14,237,1,115,114,131,233,147,122,15,241,75,201,91,209,218,42,139,83,68,52,181,149,248,214,176,211,120,114,195,130,47,186,107,192,226,196,252,150,13,210,204,38,157,219,169,222,46,224,100,125,16,208,30,189,72,234,251,130,190,120,79,165,228,31,177,5,222,93,237,231,219,172,22,32,129,110,88,195,177,50,193,83,118,4,113,50,206,91,239,98,140,190,176,21,22,63,35,103,178,176,147,152,219,245,78,183,176,249,160,91,56,249,169,91,40,109,119,11,25,250,169,190,160,159,170,181,213,45,220,109,113,11,53,123,252,133,109,13,142,94,27,139,97,44,84,238,136,161,179,232,41,187,163,24,28,186,232,0,61,84,103,136,97,156,94,142,155,120,244,154,109,1,230,49,198,70,109,230,46,249,12,196,21,177,221,21,107,64,207,210,19,234,203,118,5,199,102,115,224,19,72,182,111,209,88,193,5,62,26,188,100,61,103,38,255,12,102,244,156,97,255,29,77,50,14,226,235,13,244,57,221,143,240,64,46,118,190,1,61,15,62,243,109,86,83,29,76,53,194,
251,248,39,60,95,99,150,61,44,89,64,29,97,147,15,76,236,218,233,158,171,234,215,83,175,85,9,215,168,255,9,248,221,129,110,174,208,151,70,110,187,109,159,124,113,230,117,108,121,94,9,174,83,143,212,74,198,160,254,178,132,250,200,192,189,236,19,191,208,248,212,87,78,52,223,120,145,103,40,95,223,13,157,97,171,145,87,201,245,82,191,165,88,29,182,47,227,244,44,22,174,124,150,122,168,212,171,20,229,173,42,69,135,192,96,131,248,87,241,80,240,139,253,111,49,208,149,192,146,90,158,101,31,30,89,208,38,187,205,25,108,216,127,236,219,131,134,128,139,100,155,124,104,217,253,242,229,203,93,68,183,146,101,27,216,100,19,110,227,126,245,112,46,199,133,165,207,205,22,84,79,20,247,236,199,31,16,253,201,22,236,164,174,197,234,47,60,122,217,252,133,221,219,128,57,241,219,54,252,36,232,119,1,31,200,226,178,234,183,195,255,81,204,78,54,194,2,115,94,56,217,194,111,232,73,61,122,234,213,163,126,80,252,177,112,12,186,107,78,113,110,191,43,198,115,121,191,236,10,249,24,45,188,91,244,175,154,114,201,79,217,25,178,35,100,135,84,
74,231,179,215,252,226,108,102,123,148,74,63,208,83,39,126,163,223,237,170,122,195,160,183,227,170,161,241,193,219,138,124,219,41,245,30,66,143,212,146,182,153,47,79,207,221,205,0,252,121,234,37,155,79,82,15,148,204,172,229,154,74,238,45,201,55,142,81,83,127,209,209,131,7,172,201,83,30,132,198,192,159,124,91,98,83,6,119,209,56,207,143,226,239,200,114,248,130,218,147,168,254,135,30,61,249,204,92,139,252,60,40,154,191,165,190,191,53,178,219,128,37,244,114,27,25,129,31,162,122,45,122,240,160,43,201,98,116,165,249,16,101,211,196,129,85,51,161,121,232,29,133,54,106,105,14,50,22,224,174,57,2,111,100,226,57,233,202,53,208,46,114,243,146,232,158,120,70,39,244,107,185,1,141,139,62,203,243,204,173,71,115,19,253,170,214,3,219,102,188,138,247,49,142,86,71,127,31,207,189,4,173,246,217,156,224,1,139,205,105,174,17,204,101,31,10,47,203,178,59,29,227,57,113,96,70,62,76,114,92,118,161,112,97,180,169,30,72,189,55,49,191,47,235,171,15,80,49,112,250,2,45,254,165,252,17,48,131,102,136,185,166,159,34,11,30,179,34,200,100,
20,3,228,62,98,141,228,150,158,193,219,95,187,66,219,231,244,231,62,83,127,91,37,207,76,16,227,163,63,55,198,123,100,55,41,39,33,217,220,163,49,176,23,157,202,166,146,158,22,77,120,182,113,95,133,158,129,28,40,1,134,162,187,24,199,28,99,247,128,107,64,172,184,134,241,169,47,210,242,57,196,95,18,133,253,212,136,53,124,163,113,122,249,134,71,196,243,122,201,91,60,182,154,180,92,246,115,244,97,84,235,98,99,221,175,186,221,59,130,173,112,93,174,251,167,179,247,137,209,202,126,144,157,167,28,94,26,221,168,189,248,76,227,247,226,92,71,223,224,245,21,212,41,203,63,140,106,147,35,31,67,189,2,244,220,221,230,25,226,97,233,141,116,165,213,244,160,155,34,120,203,142,48,251,65,189,118,137,41,234,164,243,73,106,160,147,212,151,182,62,227,222,23,54,246,249,125,244,215,210,107,25,245,93,82,183,80,140,65,210,127,130,254,126,102,180,204,28,100,107,110,225,57,73,141,99,190,105,64,61,125,234,1,212,250,25,149,178,149,208,159,241,249,166,251,214,51,72,127,160,255,177,55,240,114,59,114,1,157,223,123,63,78,95,96,236,45,246,
54,241,207,56,126,174,197,130,121,38,189,127,183,92,161,157,122,255,166,207,201,49,126,101,125,128,202,95,72,94,90,60,180,95,182,5,117,213,169,59,208,232,19,223,122,99,154,108,108,194,59,122,88,58,83,244,37,58,147,253,156,86,254,65,125,126,208,166,106,209,121,127,255,171,109,244,254,149,235,24,49,163,18,222,35,121,47,219,85,245,198,58,206,177,103,202,135,170,159,175,132,56,155,234,109,193,23,177,165,58,98,228,45,207,137,49,195,159,170,77,87,141,58,181,222,249,58,98,15,201,207,162,220,138,87,195,59,198,148,143,33,167,242,34,130,91,203,43,209,106,176,120,102,135,71,77,5,243,33,231,130,172,35,199,108,181,188,150,223,140,100,250,161,136,30,101,227,200,246,171,69,174,46,203,91,209,171,100,92,11,243,216,199,118,192,236,109,209,54,54,143,228,181,228,110,108,126,207,17,245,9,226,179,29,210,220,87,207,239,25,241,103,186,24,27,181,165,28,227,121,157,254,252,158,94,93,163,250,30,163,185,153,212,229,120,241,62,224,212,67,207,159,245,254,185,153,244,89,213,254,240,255,97,245,80,113,127,202,209,3,72,110,254,58,227,
232,12,230,155,7,216,139,151,246,90,191,90,84,139,37,126,83,175,165,116,137,241,85,41,121,51,229,51,233,119,186,166,231,184,153,190,187,91,222,212,241,126,244,225,84,93,166,66,240,35,231,33,187,61,152,77,223,166,71,140,250,19,229,50,101,239,244,193,247,105,228,34,53,138,214,67,69,191,161,245,199,65,199,133,186,59,37,239,251,238,39,10,45,119,84,115,90,18,174,205,170,95,206,11,71,240,221,234,238,184,112,195,97,63,236,63,28,132,233,94,63,172,236,87,47,23,248,187,230,133,235,7,130,240,192,17,63,60,58,232,135,235,143,210,191,213,233,194,221,228,117,169,43,224,126,238,189,238,194,96,56,8,15,13,39,66,198,192,111,229,101,184,247,170,11,143,30,117,225,115,238,173,62,66,111,217,73,63,156,28,176,185,135,61,60,171,118,200,234,106,184,223,11,43,142,5,225,154,17,63,220,124,220,15,91,143,211,187,119,195,158,193,255,142,227,214,111,198,252,189,112,205,48,253,103,99,209,115,39,143,48,150,203,214,115,167,60,99,56,49,96,121,70,141,43,156,236,183,30,60,241,155,205,241,60,255,227,95,22,234,38,98,225,243,126,223,198,164,177,
5,195,62,239,46,142,247,142,23,222,60,230,135,61,35,78,227,152,111,62,226,194,107,199,109,158,225,203,227,6,171,66,221,77,31,28,4,244,135,249,156,211,117,46,252,100,164,120,63,243,24,24,246,233,97,243,194,178,163,244,57,76,250,185,190,135,212,160,80,183,151,249,26,124,220,179,190,197,217,110,106,3,168,123,156,61,120,141,241,171,182,109,216,189,235,51,157,163,126,53,245,112,170,23,206,242,107,33,254,216,251,190,177,98,127,222,131,138,66,221,253,104,62,141,224,234,0,120,234,234,11,194,87,125,86,67,76,15,45,176,238,15,194,231,224,107,20,152,159,25,228,249,204,145,121,46,63,207,96,243,224,168,31,186,33,63,236,28,10,194,227,224,160,14,28,182,220,15,194,151,28,23,94,184,223,96,54,58,64,47,229,19,158,113,137,103,28,137,224,192,188,132,235,232,158,39,177,112,98,56,22,110,52,60,122,225,246,193,8,230,170,101,33,230,52,51,48,110,189,162,133,186,175,188,176,137,181,89,168,109,81,61,139,122,237,194,199,125,208,247,67,225,46,122,238,165,190,152,198,175,231,134,101,140,157,113,133,27,193,197,163,99,130,133,3,39,140,
229,139,24,56,241,195,166,17,163,161,136,198,94,65,19,35,49,112,226,135,23,143,169,111,207,11,107,185,111,2,26,20,109,127,2,61,50,190,240,218,32,116,250,133,131,150,93,120,167,55,0,222,17,46,200,223,170,46,79,56,155,25,164,110,32,123,23,188,88,143,39,189,137,147,190,224,111,56,204,190,68,126,61,241,224,31,224,241,165,120,10,188,61,212,216,205,54,227,93,65,161,238,235,34,158,190,136,195,91,17,12,135,122,25,55,243,223,11,158,252,126,203,205,22,90,190,6,30,71,130,240,12,115,137,120,202,240,45,156,216,181,55,135,160,189,103,208,253,176,61,63,220,55,92,196,239,211,136,94,133,131,231,3,209,61,143,251,120,239,87,206,232,96,188,207,15,203,6,140,22,195,9,241,198,109,240,250,194,11,15,28,141,96,124,17,156,55,176,54,140,224,249,229,16,240,152,116,208,128,11,39,192,249,232,128,122,142,225,173,27,94,56,222,103,120,16,14,195,175,123,37,55,225,229,111,3,245,111,42,78,55,223,252,88,118,180,167,188,168,193,56,29,241,52,57,84,227,69,242,168,208,238,164,23,246,28,85,159,167,199,59,253,176,247,152,248,88,116,3,111,223,246,
132,215,240,179,34,142,206,49,31,222,15,140,192,239,13,131,57,112,21,143,5,194,43,184,74,24,126,6,232,9,29,124,70,95,207,75,100,233,215,192,159,122,153,36,253,78,173,175,224,39,234,104,123,233,143,198,255,153,235,248,134,216,28,182,78,235,55,216,23,39,12,63,162,123,234,251,241,79,209,67,25,122,202,82,143,164,35,253,112,255,97,247,126,224,190,11,239,193,79,221,135,165,107,24,11,191,161,145,48,54,224,135,99,224,73,112,219,206,28,30,177,149,49,238,206,99,177,144,58,241,240,179,145,210,48,197,185,59,224,241,78,159,11,197,147,55,178,126,216,193,86,205,86,206,198,58,64,239,176,1,223,247,142,169,223,84,113,24,111,177,134,156,70,246,43,239,125,134,28,71,175,249,79,170,245,82,95,83,240,14,187,224,29,191,23,107,171,253,169,100,134,190,162,90,239,125,43,53,93,47,232,33,26,37,247,113,166,222,95,236,97,125,136,182,157,140,213,35,151,201,186,67,95,239,166,254,135,26,190,254,125,234,161,54,222,91,220,219,102,254,59,177,13,213,167,122,139,91,218,157,245,185,10,111,240,223,98,208,65,62,136,188,77,213,83,234,25,200,119,
158,239,2,86,71,92,190,234,62,185,147,148,224,16,233,231,154,180,35,247,137,125,35,251,129,122,135,246,168,14,66,189,174,244,104,198,223,241,236,247,237,23,107,163,216,171,226,151,102,71,236,201,141,224,251,245,83,83,54,248,12,59,155,120,93,91,102,43,246,130,98,213,232,98,217,27,138,241,148,90,254,175,168,247,124,242,120,216,215,244,243,53,60,137,226,7,13,153,109,83,85,216,237,178,251,50,170,203,218,195,248,200,237,98,31,211,107,138,77,161,158,26,182,193,137,24,121,173,18,236,147,205,223,101,50,192,150,181,30,170,162,121,139,38,173,222,159,250,192,124,245,245,128,113,219,28,172,15,171,105,148,177,165,169,185,162,119,164,90,121,243,139,214,15,192,243,173,255,67,54,250,59,238,103,204,107,223,68,189,167,150,251,159,170,230,153,196,11,121,110,84,231,220,148,41,93,188,83,73,207,233,51,95,235,120,128,23,183,200,58,40,197,62,83,229,160,173,135,72,246,185,122,92,200,105,209,107,65,221,136,122,196,120,71,193,122,34,145,39,212,69,91,175,152,106,190,176,155,109,93,41,124,94,213,119,9,31,170,215,52,223,118,121,189,
54,249,183,81,189,175,35,79,45,63,87,53,40,172,33,182,6,60,152,109,11,60,173,238,136,184,134,240,34,184,203,38,82,174,202,114,43,91,129,23,49,224,113,249,216,188,191,131,245,208,176,193,5,211,99,143,205,119,226,189,91,232,31,85,31,136,224,160,62,45,167,62,156,200,39,145,223,184,139,251,142,176,55,31,198,124,28,122,66,232,241,196,102,174,37,199,6,143,22,123,146,184,134,186,117,236,16,245,31,169,31,21,123,83,61,62,172,73,33,251,93,246,218,71,27,40,160,110,154,222,198,139,224,135,152,2,246,38,240,8,172,14,126,144,24,83,255,189,82,189,3,248,123,122,182,250,25,243,59,47,149,50,46,245,203,150,83,23,26,207,215,142,211,131,42,31,47,234,59,43,212,226,119,236,193,22,77,82,183,141,45,43,93,68,15,170,213,9,48,175,128,123,213,135,186,153,126,72,124,189,135,192,45,242,199,245,30,193,166,176,31,91,182,225,43,217,209,142,177,49,6,228,136,250,130,134,238,225,199,76,218,115,172,39,85,189,169,61,163,202,99,227,151,200,199,80,45,177,214,116,178,56,29,191,63,230,188,240,149,205,151,149,29,29,197,226,134,50,216,160,138,219,
149,177,153,191,167,222,76,139,239,224,87,186,233,206,137,237,248,42,234,35,42,23,77,171,247,52,55,2,143,245,211,147,59,244,210,96,63,223,48,97,253,46,244,122,248,127,234,67,141,89,189,66,212,191,90,138,95,20,208,255,201,187,228,87,202,246,172,97,191,108,55,83,87,78,255,168,232,167,176,159,24,167,197,214,14,121,239,7,95,193,31,157,226,61,217,188,162,91,236,231,116,25,207,81,63,40,235,201,181,123,225,214,44,207,49,218,114,192,145,235,60,47,108,71,6,142,100,121,142,122,75,177,35,62,199,214,220,255,23,96,249,23,163,125,61,79,125,167,97,252,48,254,13,251,122,236,207,209,195,46,124,133,44,221,212,235,138,125,167,30,54,169,250,85,93,120,158,125,3,58,101,178,55,160,7,213,11,247,35,119,79,247,57,122,80,189,240,1,58,182,178,63,22,190,234,167,54,165,222,11,171,169,231,95,205,190,115,64,253,168,94,120,70,186,159,237,203,1,245,235,240,62,158,147,196,198,75,31,137,250,169,241,221,85,71,19,158,226,152,100,186,67,47,110,99,219,55,136,45,247,185,122,95,141,22,168,39,148,60,116,97,223,160,225,93,190,150,244,182,217,11,
215,6,201,121,81,131,130,174,146,47,27,62,31,140,250,206,180,70,64,203,56,250,227,168,120,217,15,147,232,188,206,163,65,120,12,251,108,130,223,95,179,85,162,75,14,176,157,98,123,54,180,46,188,111,255,99,191,112,77,19,182,149,198,182,234,136,123,135,94,150,30,126,63,132,189,74,190,4,189,81,241,190,255,218,154,119,67,153,224,93,127,38,254,126,240,142,122,98,181,46,71,60,236,202,186,112,146,173,26,152,158,102,91,219,43,24,98,135,179,47,193,14,78,22,97,178,74,58,140,121,175,31,116,225,49,230,124,155,253,70,198,52,192,187,95,178,85,14,201,239,92,238,185,197,214,195,110,136,198,26,48,86,63,76,96,103,125,130,126,196,86,161,158,8,93,114,93,53,186,170,49,242,208,243,230,143,74,46,230,89,103,109,170,14,254,233,133,119,212,143,75,63,121,33,249,20,219,93,117,60,15,201,9,126,33,152,10,62,46,116,140,231,76,191,99,142,54,103,224,198,156,175,173,98,158,177,247,131,99,49,241,48,250,51,128,127,203,194,35,123,93,120,98,111,16,62,102,127,233,227,190,66,176,226,126,255,125,239,45,63,92,5,28,234,138,240,88,11,44,70,216,54,
1,11,236,157,112,61,239,145,109,216,136,253,132,76,22,77,132,49,96,176,123,208,98,220,178,31,133,187,176,1,152,60,98,31,195,118,230,185,211,169,9,135,206,246,195,191,164,176,211,199,93,184,46,229,194,91,135,92,248,77,151,31,222,236,114,97,91,87,44,188,192,239,251,252,254,166,11,155,143,241,141,51,190,62,246,103,216,63,96,79,47,117,184,170,85,118,14,118,98,171,205,247,61,113,122,243,245,91,129,57,58,28,216,149,72,14,190,67,14,96,23,120,90,131,1,120,160,235,158,162,199,95,18,7,248,220,189,39,199,108,122,77,180,166,245,19,232,55,102,29,32,209,170,98,40,170,231,238,137,226,121,226,123,249,204,226,85,213,9,41,79,160,56,128,100,176,114,150,86,187,202,177,143,61,243,252,78,195,195,86,203,143,204,33,190,36,220,245,223,208,90,62,234,67,149,124,89,175,90,20,98,5,230,247,70,121,79,139,91,241,60,143,49,210,11,209,254,18,121,220,47,157,96,50,74,188,47,154,200,13,190,160,174,10,189,115,234,150,250,176,87,135,212,149,133,235,14,197,194,103,228,124,69,243,135,218,225,145,118,248,130,189,224,179,123,159,11,31,176,95,
213,108,246,67,88,207,58,166,208,83,88,210,204,24,169,9,160,54,139,177,88,63,113,216,74,175,165,244,249,41,158,115,182,30,123,155,126,102,116,119,184,189,154,103,176,237,222,138,29,243,8,190,250,4,91,112,35,184,219,224,135,79,86,184,119,192,60,204,172,12,144,179,9,236,39,213,7,174,33,230,226,79,247,63,70,7,12,250,196,58,76,126,33,31,37,159,173,110,187,208,241,156,218,236,71,213,111,168,183,83,15,18,115,11,176,67,20,79,209,154,117,214,55,150,175,189,235,79,15,62,181,218,99,233,64,122,96,163,222,92,122,140,129,175,201,149,66,237,215,145,92,105,203,212,69,248,82,29,152,106,31,45,78,35,92,32,251,77,47,80,91,33,185,45,61,67,220,11,61,102,227,43,234,140,220,49,106,16,233,121,206,245,223,220,152,27,185,43,61,227,164,203,193,215,42,104,74,253,194,188,19,190,46,234,81,198,107,242,93,240,83,63,111,110,144,216,17,235,83,48,6,211,227,196,182,151,123,136,53,102,222,185,227,227,26,19,81,92,195,198,167,216,18,247,164,201,79,203,6,81,92,198,198,71,12,217,214,92,96,237,8,98,46,172,31,81,28,67,140,247,203,70,216,132,254,
85,143,105,0,188,232,93,36,239,80,92,119,66,118,68,97,143,122,76,177,65,121,47,247,110,144,61,194,248,173,246,161,56,47,224,162,120,86,61,124,225,241,126,27,11,255,167,109,141,9,193,95,246,21,190,158,233,111,249,62,162,11,173,63,243,167,158,96,226,78,212,68,70,252,130,141,211,200,253,49,54,211,197,234,59,142,79,103,70,233,87,48,216,39,204,214,236,121,88,15,205,137,6,2,91,55,16,153,76,78,48,202,33,65,187,172,25,129,158,84,238,83,113,69,245,73,201,78,178,90,95,98,75,233,13,102,159,74,174,34,207,229,55,105,140,26,127,209,6,182,120,89,110,72,182,6,125,97,178,157,240,87,25,227,114,15,51,113,182,201,10,228,188,124,221,248,84,93,102,189,158,163,245,8,254,36,171,121,31,245,245,232,168,124,237,35,232,237,33,176,161,150,35,217,238,100,119,70,246,70,148,59,137,104,73,227,132,39,162,94,96,126,203,126,209,177,90,224,161,189,254,87,126,35,202,23,48,191,98,238,163,130,99,178,91,180,37,138,125,195,129,108,69,222,225,249,178,153,216,39,208,97,101,194,27,114,201,207,87,179,62,67,243,23,54,54,250,134,25,19,107,50,33,251,
233,21,94,5,255,248,216,220,30,182,246,10,245,9,211,43,231,242,219,163,56,177,108,33,233,223,98,207,176,193,203,122,115,59,161,117,197,24,251,137,135,235,57,187,38,19,210,29,239,123,190,2,71,214,219,232,194,43,200,249,99,108,95,247,249,225,222,254,18,251,255,203,126,201,242,210,176,10,221,112,21,123,101,63,219,118,100,205,57,182,151,237,101,236,169,223,111,243,37,123,69,51,115,157,143,200,59,209,3,76,140,45,122,254,243,205,248,124,14,95,50,64,167,112,63,186,181,14,189,178,43,242,255,224,49,63,124,149,181,123,229,103,202,38,14,119,245,42,199,128,206,233,181,186,167,215,135,161,21,100,105,120,143,231,48,102,122,75,202,194,42,244,211,254,94,201,32,47,220,221,167,122,119,100,30,186,234,6,199,121,30,186,76,254,101,156,113,177,174,105,86,253,199,140,45,202,157,208,159,236,189,239,197,255,175,85,63,43,241,75,224,65,111,242,26,116,213,90,217,62,224,5,248,125,37,57,226,191,239,143,122,110,177,25,185,118,76,215,58,158,181,106,138,126,107,227,209,168,71,57,134,109,65,222,225,148,108,39,47,95,253,185,197,236,163,
62,180,9,106,199,233,237,236,136,122,86,233,97,161,167,133,152,45,235,30,241,44,245,244,83,31,166,88,52,184,233,192,126,103,253,191,247,3,47,156,197,124,89,211,74,125,48,216,12,190,226,189,214,163,172,53,146,212,231,162,30,229,181,77,190,197,126,169,213,45,246,26,5,197,94,35,213,252,201,255,241,45,30,252,233,33,159,158,23,191,232,3,213,71,60,171,124,150,108,91,233,52,229,211,229,103,244,64,199,105,108,111,243,139,200,3,200,47,146,108,213,58,162,150,235,178,90,46,217,90,202,111,170,158,71,113,95,104,110,185,167,89,181,244,232,125,226,237,248,129,38,83,90,162,124,151,245,81,117,169,62,148,56,67,207,77,234,236,207,209,179,198,122,109,216,65,179,29,87,132,119,233,189,79,200,179,251,196,4,196,15,188,87,107,179,108,99,95,199,166,220,156,228,86,10,188,116,179,79,155,60,206,55,223,143,189,79,93,88,75,63,14,199,52,86,213,248,216,88,75,224,243,152,122,197,52,70,245,135,200,70,248,94,61,206,244,87,78,83,119,79,77,127,44,223,48,202,88,134,169,249,87,110,172,155,124,55,50,68,242,245,143,90,252,74,228,134,226,5,234,
111,246,166,26,176,131,137,191,144,111,75,232,217,240,162,131,23,165,19,163,222,110,224,178,72,126,81,113,106,195,5,126,169,224,3,174,2,213,102,98,19,49,231,171,234,213,243,213,191,58,211,117,18,56,220,198,255,166,55,177,25,186,80,221,117,4,91,249,217,102,203,26,189,68,126,45,124,197,58,41,244,53,191,87,125,149,232,38,3,205,116,80,91,164,248,67,70,122,129,53,68,82,244,176,105,189,114,122,217,37,11,196,151,230,3,195,59,208,92,67,164,11,148,175,98,109,41,114,146,145,223,75,45,18,215,21,97,12,220,211,200,5,116,81,155,106,42,116,141,236,31,229,112,77,230,151,129,123,243,19,149,187,33,118,92,46,59,204,108,50,236,78,108,2,249,165,200,133,139,81,127,51,231,180,6,168,201,7,234,234,13,39,92,151,203,16,235,101,125,111,171,161,36,38,165,122,235,25,96,51,211,65,223,9,107,145,168,246,94,126,19,189,205,94,184,7,253,207,90,111,33,181,84,204,83,242,62,198,49,241,248,234,176,17,126,31,225,247,104,54,22,30,225,55,181,87,28,39,151,191,147,241,250,69,191,76,245,52,86,143,104,118,46,186,208,195,254,71,207,236,242,66,234,
180,34,250,146,78,38,126,223,149,101,254,41,201,47,114,124,90,255,41,93,78,174,211,19,158,193,119,140,158,104,127,41,54,192,253,61,129,122,161,185,206,209,7,13,236,219,156,122,161,151,84,31,133,60,18,76,232,133,182,122,110,193,6,159,42,120,75,252,74,107,35,66,47,193,15,92,67,47,116,236,123,213,33,101,128,163,96,202,57,96,186,78,253,54,248,77,1,124,4,141,168,159,149,152,81,23,181,130,89,214,56,232,86,95,60,181,246,29,228,216,186,239,219,250,57,240,139,233,103,124,49,242,66,244,201,169,31,218,122,132,199,140,6,84,31,160,53,93,36,115,144,25,232,193,243,138,151,152,239,97,189,113,244,226,35,47,188,240,60,113,150,154,238,72,6,121,200,86,214,63,136,114,126,138,103,124,148,21,130,201,218,240,6,112,86,92,239,236,97,224,40,89,161,252,141,116,159,241,159,23,126,101,248,89,142,51,148,34,243,165,7,176,83,205,199,138,133,87,208,5,207,249,127,43,207,16,254,164,103,200,183,240,60,63,60,109,215,196,69,43,196,197,141,142,224,41,124,128,94,229,127,20,147,180,103,153,46,39,110,62,141,156,14,15,67,35,212,60,40,254,68,124,
209,250,166,69,115,172,121,9,252,88,27,175,27,123,31,253,98,252,197,179,102,59,162,94,66,131,59,207,136,224,5,220,20,199,195,159,205,117,97,91,116,223,0,206,178,49,238,58,201,37,198,136,15,57,89,254,63,245,85,147,123,71,143,144,151,54,189,51,154,45,225,58,63,188,149,13,152,111,172,56,55,245,71,139,246,227,202,1,34,147,36,35,24,147,245,123,211,31,125,35,152,97,157,21,173,131,240,166,14,250,192,55,147,159,154,175,191,104,62,97,81,71,211,47,77,156,30,250,126,127,20,63,121,47,243,37,119,94,168,255,150,94,106,98,217,188,19,252,174,123,205,92,196,151,202,147,217,220,168,1,212,187,120,103,96,57,6,106,70,233,157,198,30,38,222,86,91,229,164,139,102,187,213,63,124,137,248,211,55,196,14,239,50,142,49,96,246,208,189,59,42,56,168,151,28,159,180,251,182,229,34,231,219,70,220,84,61,116,228,213,184,252,78,214,250,147,124,161,119,182,216,103,237,10,59,25,207,1,100,25,58,11,88,97,131,16,159,59,154,20,29,250,138,219,25,13,70,244,24,16,183,243,45,110,23,245,202,6,70,139,212,106,168,206,221,100,216,177,78,245,203,74,127,
45,215,170,148,135,43,178,138,239,8,222,162,153,229,62,48,205,21,122,204,90,191,112,120,41,75,237,148,114,213,210,93,213,198,163,145,13,39,29,97,250,78,54,166,122,176,241,107,216,210,182,54,143,35,190,146,32,207,167,231,138,166,125,122,167,145,137,186,94,126,95,131,123,99,235,202,73,14,154,221,30,32,159,2,228,80,137,116,140,96,92,132,239,178,12,82,143,54,253,172,172,201,153,81,47,63,189,175,221,167,129,243,69,232,180,211,242,181,196,227,12,126,194,119,209,182,117,133,14,98,64,205,248,175,189,216,178,29,216,226,70,139,244,101,161,47,115,208,139,250,212,223,15,76,202,111,162,46,71,227,88,203,86,203,166,88,90,163,241,64,164,11,151,101,186,205,23,223,204,116,188,104,196,230,14,157,44,247,157,75,150,111,98,190,234,219,54,217,103,61,76,165,186,94,247,210,179,4,31,242,76,143,222,109,189,135,109,163,83,15,55,250,212,122,179,201,53,123,244,115,243,110,201,82,233,110,236,244,36,182,38,180,33,123,85,56,15,3,122,162,58,136,69,209,31,21,182,31,242,233,241,38,183,121,72,181,4,46,124,68,12,30,186,21,191,211,247,77,
126,4,251,178,150,190,169,181,246,219,87,223,55,61,222,196,85,240,109,83,173,142,94,239,88,120,111,23,107,82,108,245,194,111,118,249,197,158,111,98,16,73,96,223,224,135,231,106,202,103,178,208,112,231,168,111,54,70,251,213,56,52,138,220,59,101,61,223,211,253,47,196,207,102,95,219,58,0,31,123,188,199,232,7,191,5,205,18,215,100,109,46,197,156,213,31,164,190,71,228,119,180,86,153,98,8,196,202,161,17,201,84,139,227,40,166,240,190,203,108,60,179,201,140,198,213,119,188,220,135,129,124,37,239,33,154,198,159,238,119,178,17,176,205,188,240,40,191,69,223,53,221,46,124,58,36,27,13,255,123,216,41,175,16,14,16,71,122,58,84,25,54,13,149,88,46,229,154,197,188,214,114,60,97,121,151,167,67,196,19,124,98,119,67,134,15,104,192,11,179,250,45,93,45,123,9,24,110,27,2,159,138,171,166,36,179,117,173,175,220,89,120,142,77,185,192,182,99,241,112,37,251,163,252,191,131,56,213,53,139,93,113,173,112,175,231,124,140,59,219,90,117,225,49,206,223,102,139,158,225,194,191,112,207,58,242,211,45,199,140,158,101,79,144,7,114,225,229,97,
195,189,61,179,98,88,177,24,79,121,53,226,98,224,117,200,87,143,186,230,39,121,76,95,157,236,253,79,84,31,193,121,226,241,210,31,155,188,112,88,115,17,173,89,252,220,11,79,104,221,145,78,106,59,46,18,199,50,29,11,77,218,154,97,208,118,214,189,131,7,129,187,249,8,204,217,123,159,29,103,222,226,247,143,126,118,5,239,168,32,110,18,103,253,144,32,223,68,173,22,49,136,119,240,45,53,42,178,237,85,199,193,59,186,165,187,221,123,100,190,100,58,250,36,88,174,223,192,182,41,9,135,89,139,20,252,209,59,100,181,23,38,103,241,67,148,187,80,140,77,53,32,225,105,228,218,192,42,234,55,144,153,119,42,37,79,125,122,219,61,189,75,118,221,226,231,21,190,214,106,152,165,215,121,182,131,245,32,209,199,178,81,11,205,99,214,23,95,168,254,92,250,92,253,238,81,174,233,212,74,201,79,100,51,50,0,58,147,78,90,60,180,250,143,126,119,106,66,23,183,174,139,100,107,108,131,175,252,138,209,231,225,173,162,75,173,147,17,173,179,138,63,17,150,247,7,146,215,162,237,176,101,200,122,122,133,87,173,195,103,248,1,79,102,47,144,91,145,173,32,
124,203,46,53,31,131,245,223,200,113,199,176,109,61,238,241,109,61,140,168,183,40,14,61,7,208,114,9,180,76,108,152,24,32,249,63,249,28,118,191,151,169,20,237,73,46,64,211,224,68,116,245,9,219,14,209,3,123,248,28,122,136,112,29,201,43,232,94,114,42,102,116,210,86,47,121,79,174,29,122,91,9,205,54,64,99,157,108,162,97,199,30,158,225,61,162,31,163,121,222,13,13,203,38,145,188,82,222,160,158,109,19,239,151,47,14,207,216,24,60,209,49,241,99,182,227,108,143,216,220,177,18,229,199,237,24,215,104,204,232,107,241,21,116,113,36,146,29,212,19,231,91,111,47,247,249,219,248,195,149,228,165,229,187,234,253,204,3,122,22,47,109,161,183,134,119,74,7,41,167,39,251,136,56,62,112,211,216,162,181,3,46,137,110,161,99,120,19,254,94,0,63,138,211,169,15,93,235,197,105,13,1,93,43,57,74,77,163,225,84,116,170,216,31,117,141,208,248,113,183,64,158,107,129,154,159,5,47,83,69,95,33,252,227,209,71,254,144,90,195,155,232,73,120,44,57,38,27,88,180,241,113,125,38,108,89,173,3,40,191,217,106,97,173,135,158,58,121,243,57,210,102,139,170,
182,215,252,24,245,2,161,223,108,157,26,139,219,34,199,195,68,23,107,9,188,196,94,191,129,157,64,94,252,90,59,107,10,176,222,11,235,236,207,82,211,23,102,137,163,176,110,84,161,134,53,43,119,19,11,184,65,93,15,207,19,253,139,46,45,254,93,92,107,64,116,253,190,139,56,56,53,95,225,29,226,238,194,241,241,225,146,240,83,246,200,17,147,77,47,169,161,25,27,142,27,158,54,14,227,167,198,129,161,244,112,157,201,149,72,78,40,198,169,92,18,249,22,228,147,96,86,212,245,186,70,48,167,223,99,136,154,195,33,114,220,244,171,102,47,114,45,53,205,154,47,254,154,217,222,7,225,111,100,40,244,81,22,86,240,206,219,200,90,213,193,220,135,158,43,100,227,67,219,240,135,230,98,180,243,45,207,163,95,60,151,194,70,178,190,255,243,208,172,104,78,53,174,178,63,188,149,220,91,241,166,6,123,172,207,232,200,250,97,212,43,46,26,100,13,3,241,147,106,3,44,135,97,181,58,228,54,138,99,193,118,222,107,56,192,103,48,26,16,141,177,110,1,48,253,58,170,109,74,223,70,126,210,39,13,189,177,62,59,184,24,43,133,22,109,108,162,43,224,181,158,53,18,
202,4,243,247,89,248,4,187,120,1,61,200,255,204,37,73,207,171,229,140,129,9,125,137,248,94,214,211,64,31,174,213,210,18,107,160,158,54,250,182,133,106,104,169,159,181,126,246,104,13,132,232,219,16,127,192,45,30,82,211,29,98,51,132,25,246,53,41,242,52,232,159,203,159,186,112,75,43,245,29,205,212,103,52,168,31,211,11,111,177,134,11,245,161,97,85,131,214,173,240,228,15,133,19,213,154,39,53,70,53,228,0,62,137,21,233,68,57,101,252,153,113,230,117,9,90,187,14,157,156,80,237,180,214,113,112,170,69,9,251,180,142,15,126,17,117,211,185,131,199,25,63,53,89,187,137,163,67,7,225,9,98,89,3,240,109,180,62,131,201,177,16,124,65,103,146,21,37,250,189,188,126,130,100,148,252,53,225,22,156,56,225,11,222,176,250,87,157,3,31,134,119,232,36,174,255,197,27,212,154,250,54,102,238,177,57,92,163,247,197,214,218,184,109,243,154,161,222,66,114,84,115,157,238,99,125,18,108,95,225,36,223,50,70,108,149,245,175,201,101,23,168,3,156,109,103,77,10,122,36,12,71,169,227,166,11,196,19,102,43,19,155,212,51,196,243,102,107,16,131,149,76,254,
35,46,75,140,72,178,89,118,70,180,214,140,122,181,37,151,125,179,159,163,24,208,178,13,237,225,159,104,93,78,211,145,216,24,149,248,186,113,142,233,255,120,174,171,155,94,13,96,152,61,93,65,110,50,198,177,72,30,160,87,149,83,139,244,178,228,231,22,54,217,155,150,23,129,206,165,99,197,119,178,57,228,67,31,242,177,209,217,171,95,11,185,134,31,77,127,34,113,31,232,43,123,141,28,188,108,11,201,194,6,163,121,233,103,249,100,228,92,255,244,30,47,166,158,11,124,32,91,243,233,13,62,17,176,142,23,215,107,160,14,241,168,228,142,191,128,79,155,111,167,87,140,250,93,91,71,161,7,62,164,158,146,117,228,241,159,31,177,102,60,241,165,118,106,243,37,63,89,175,97,58,75,140,4,30,178,181,25,240,57,22,146,251,205,190,230,155,46,206,234,194,177,195,144,163,193,251,236,103,138,233,44,127,223,71,113,175,24,180,75,44,145,247,181,221,49,217,50,159,36,102,15,94,114,90,143,66,107,100,118,93,14,160,91,114,77,199,241,61,100,3,171,142,64,113,247,114,54,229,147,54,20,231,185,213,230,45,26,82,12,134,103,91,78,5,25,134,109,120,153,99,
141,134,159,247,169,19,252,110,102,147,254,138,236,57,228,25,48,181,245,199,20,199,14,44,166,221,182,193,87,252,73,115,204,243,189,21,214,84,50,31,146,113,8,126,70,59,209,55,35,136,1,119,93,179,30,43,147,119,90,163,50,90,219,65,117,213,188,67,182,255,159,215,24,50,249,21,131,7,131,34,220,75,68,239,242,117,212,23,92,72,62,66,255,140,144,151,164,78,175,165,221,98,96,170,33,80,31,143,245,239,232,187,61,217,139,216,42,172,69,217,58,110,182,153,98,58,232,68,100,150,98,245,55,20,163,87,78,209,190,211,166,252,178,252,86,243,89,145,11,234,185,100,156,234,57,178,245,26,152,239,159,215,121,240,5,107,173,245,192,58,15,43,116,111,49,182,111,117,39,90,79,69,113,125,201,60,98,47,228,81,25,35,57,84,179,235,91,239,105,60,208,140,190,13,193,134,191,155,235,96,253,82,228,2,227,227,251,66,182,214,131,252,214,169,248,76,250,186,0,166,65,233,163,13,106,198,173,192,8,180,38,63,13,232,255,99,209,135,64,197,173,76,204,45,47,254,176,136,225,51,195,226,142,90,0,130,66,109,91,0,98,241,190,179,197,31,22,135,98,30,11,64,216,7,112,
248,112,139,183,188,16,196,98,105,185,167,197,32,100,64,178,32,132,91,60,181,50,250,160,72,253,90,143,197,33,84,72,227,47,242,97,33,140,61,125,100,68,197,52,22,92,146,177,55,195,7,138,48,72,85,72,227,203,208,147,64,197,137,241,173,65,92,206,119,9,78,211,133,181,42,156,137,21,13,59,144,225,89,51,48,198,221,242,130,15,20,21,61,240,254,253,2,71,231,70,135,247,239,254,19,17,48,113,136,254,253,252,186,57,68,133,42,4,217,177,78,239,223,155,89,80,147,128,227,191,39,149,172,176,197,25,21,72,81,96,210,22,255,23,163,0,80,45,226,166,4,172,67,248,212,69,2,69,1,91,5,120,101,232,43,192,36,2,148,1,248,177,233,104,199,114,130,34,55,120,157,4,6,139,235,140,156,44,85,66,128,100,157,18,154,20,88,200,9,208,61,98,18,49,76,45,207,216,192,62,241,231,34,170,178,40,225,71,1,207,136,26,152,143,32,8,110,45,39,91,183,243,28,91,36,154,103,198,69,240,197,5,208,120,31,202,101,144,69,24,51,44,56,156,164,40,103,167,17,114,37,215,41,41,177,17,7,194,156,6,240,29,5,250,40,138,250,14,167,152,196,132,18,186,78,11,249,79,103,229,24,158,95,
54,194,162,5,252,162,34,49,17,162,62,32,160,68,159,22,236,86,16,224,99,225,148,18,164,249,90,26,120,40,156,154,206,220,17,65,122,81,65,212,203,8,198,91,215,49,15,146,37,82,14,95,90,2,210,132,128,125,100,129,66,34,232,32,42,166,146,177,223,214,224,91,145,212,114,129,148,2,196,44,4,240,49,184,226,101,182,21,23,187,2,118,74,102,201,136,73,19,20,144,64,151,192,183,128,199,10,230,22,76,167,110,19,56,174,54,131,60,119,12,161,50,72,147,95,255,56,201,75,138,118,146,44,24,65,129,27,201,212,229,4,36,197,244,74,54,96,208,182,41,136,216,97,201,213,101,163,22,184,91,161,146,18,157,185,99,42,138,35,208,68,146,138,119,47,23,67,73,96,71,201,77,22,149,47,226,93,11,247,87,147,56,99,172,50,242,133,243,114,158,191,158,6,20,22,94,34,185,159,203,168,193,220,139,132,98,173,22,13,240,112,18,59,37,0,204,208,84,50,64,73,94,131,59,139,81,2,219,213,197,36,171,207,115,75,167,85,32,208,182,25,248,95,0,239,23,245,28,131,179,146,210,224,32,70,129,148,146,167,90,116,217,39,33,101,139,114,16,68,89,77,113,79,41,201,133,168,72,171,1,60,
169,209,133,132,172,120,66,2,186,208,64,112,108,255,43,141,35,18,56,127,44,216,175,134,8,146,46,82,24,130,191,148,171,22,3,136,20,106,52,79,5,172,106,4,247,245,185,33,22,227,232,167,177,109,228,44,115,147,66,21,237,139,238,87,176,151,3,77,66,81,73,109,224,75,34,146,15,255,177,16,2,66,158,69,90,40,136,34,136,212,63,170,230,69,10,193,46,68,133,10,209,117,229,185,33,18,219,240,7,11,107,87,44,223,175,196,135,146,32,60,135,68,245,46,240,113,83,137,113,83,130,24,158,137,92,63,5,192,90,152,121,228,91,45,164,251,231,226,42,120,55,169,247,126,194,56,124,238,87,129,217,106,91,76,159,197,187,41,106,178,194,37,206,199,40,92,82,65,19,116,125,220,33,35,13,71,20,49,249,20,47,149,254,255,44,156,31,159,106,208,7,143,40,164,192,152,82,128,64,5,86,42,62,203,13,48,15,2,191,44,124,77,114,219,26,214,85,104,20,57,214,237,227,205,243,109,107,13,38,44,82,36,186,101,225,84,22,118,199,208,160,80,204,230,102,202,179,129,5,1,48,78,148,128,134,63,75,166,56,143,14,136,49,23,21,165,90,146,98,185,152,71,69,130,249,36,198,7,31,90,161,
112,71,248,14,114,199,48,12,6,41,66,235,189,215,88,132,133,232,89,114,103,87,81,241,49,230,29,20,79,208,124,2,126,230,147,195,26,75,57,197,59,86,164,1,157,111,180,196,10,198,169,244,14,206,104,160,198,160,41,120,94,197,45,249,42,10,52,41,112,145,178,35,168,101,5,6,115,77,106,186,33,176,162,15,190,180,211,116,211,137,1,148,84,32,223,131,62,254,112,188,35,190,105,135,151,107,160,23,62,106,0,125,66,75,4,149,210,44,122,108,77,155,124,80,11,126,26,193,184,30,188,183,2,153,167,66,84,201,189,56,99,177,123,34,227,68,242,91,129,127,37,184,181,176,15,50,44,42,46,141,81,80,226,19,84,33,25,180,93,176,230,67,92,42,234,39,144,161,2,10,45,190,127,10,120,53,125,195,88,193,15,52,48,215,254,80,227,37,209,117,29,35,225,194,42,100,224,26,230,28,39,192,239,171,80,69,239,207,87,201,216,195,136,210,71,150,12,102,93,122,135,230,232,243,190,45,246,110,254,103,140,226,239,18,5,220,121,14,137,89,91,52,222,47,116,60,37,208,98,240,6,102,247,129,85,49,177,75,0,121,142,227,56,198,235,48,40,228,16,216,135,83,72,248,233,25,20,46,122,
20,10,240,225,216,61,20,76,214,126,203,162,153,47,148,64,19,172,205,16,212,252,230,246,60,131,254,129,251,129,168,129,108,241,246,49,127,241,249,117,183,40,253,56,57,185,118,113,5,11,169,145,152,90,204,94,146,14,20,206,155,8,128,198,167,123,249,176,84,84,88,41,121,225,231,142,97,148,244,147,20,70,182,206,237,153,192,97,158,72,48,95,241,79,2,154,144,220,193,209,95,109,5,164,31,92,141,37,173,151,241,41,92,74,174,73,46,240,44,43,38,1,167,24,175,221,22,112,203,157,2,238,42,44,58,22,201,36,61,31,216,107,204,20,65,64,79,181,42,18,167,153,155,162,74,100,97,25,112,151,60,55,122,196,177,98,97,96,154,128,160,149,249,36,137,98,18,14,69,57,40,195,20,252,155,28,98,95,38,57,42,185,203,111,79,133,13,204,251,128,104,0,24,94,231,29,15,108,236,124,240,196,130,109,26,47,227,176,49,20,223,205,243,111,234,249,54,55,230,91,10,62,180,168,186,100,143,238,45,3,110,226,123,26,3,208,139,124,220,105,154,2,16,21,66,243,94,151,27,2,118,42,52,204,90,177,174,53,86,205,181,200,8,132,47,218,193,79,23,91,207,132,233,212,57,156,113,222,
195,66,241,42,248,82,176,81,243,208,7,123,77,183,48,110,22,235,50,7,72,178,57,210,41,211,36,109,249,189,6,125,24,227,67,159,235,139,252,82,10,221,96,252,171,17,80,193,9,57,73,10,202,43,144,42,35,222,2,153,252,175,143,202,165,203,145,41,106,38,143,62,216,195,243,229,236,219,24,225,143,104,140,140,203,120,178,71,99,37,224,20,225,41,178,117,100,43,125,194,38,231,194,145,104,121,41,190,43,227,253,62,50,42,193,179,163,66,108,21,110,98,191,146,164,176,166,37,21,147,34,215,40,186,32,201,145,86,33,127,31,58,142,102,135,59,125,182,216,252,124,242,0,52,240,192,228,137,62,8,52,183,135,134,140,77,3,198,91,20,136,146,100,61,98,114,15,249,231,81,252,41,3,189,36,108,162,88,115,205,80,153,224,14,158,12,95,225,167,20,130,65,163,20,43,82,120,74,240,228,62,142,248,190,97,18,221,95,25,14,10,205,52,178,53,243,145,44,228,22,9,110,61,191,148,130,208,88,152,24,244,149,48,80,128,74,247,77,145,0,165,128,18,218,146,253,33,217,37,123,113,43,129,133,99,236,249,136,0,197,100,81,112,79,48,86,17,17,73,130,1,157,147,60,242,139,120,243,
20,72,138,10,185,173,88,102,242,99,129,140,222,31,186,97,55,183,235,91,156,95,248,66,11,228,31,38,177,14,239,133,13,4,245,160,23,53,254,48,190,32,74,210,76,202,49,118,20,253,174,10,199,73,82,210,12,22,110,163,64,148,130,215,112,27,5,144,91,152,43,197,159,124,184,201,116,203,210,166,172,191,52,146,37,105,204,30,71,120,233,112,214,45,165,15,151,44,213,31,182,6,156,165,234,172,22,26,144,45,173,2,81,241,183,130,63,254,235,195,208,198,46,53,156,91,19,187,154,83,215,18,204,137,135,167,9,70,221,30,94,21,222,26,142,171,1,126,106,59,227,191,6,92,91,9,2,33,11,85,8,51,173,160,144,26,68,35,61,179,42,60,57,188,201,10,83,224,47,209,166,28,176,104,145,9,22,2,176,197,95,101,59,43,64,169,15,177,80,116,132,110,137,232,110,23,240,148,163,174,230,5,75,34,16,120,75,39,194,30,198,160,66,220,1,112,219,196,188,143,80,28,58,73,209,16,13,61,225,10,18,179,27,44,153,171,226,28,147,9,42,148,166,16,157,119,19,188,111,190,200,126,95,145,174,133,51,108,212,142,87,236,215,171,72,154,247,80,32,197,156,160,101,232,100,140,227,158,163,
56,199,232,175,88,176,74,83,202,221,205,74,222,188,239,191,91,250,29,11,80,229,171,71,21,152,53,255,37,90,20,101,20,135,14,28,226,252,171,120,194,10,43,70,182,168,224,131,96,251,85,5,205,161,69,138,117,112,12,167,123,174,187,127,19,12,147,99,42,90,136,22,221,190,18,201,9,125,20,160,88,168,99,133,56,20,221,188,195,239,32,177,169,34,156,200,158,94,78,240,4,237,20,21,225,247,168,233,160,152,208,81,160,5,25,191,189,104,123,81,244,46,89,40,91,88,118,218,46,246,31,229,129,224,138,243,15,220,118,101,229,99,202,223,140,18,213,216,93,208,27,254,72,61,247,88,32,152,251,132,47,5,93,164,119,85,200,161,133,67,36,115,76,214,70,133,229,42,108,86,17,239,232,225,178,176,155,223,208,33,207,81,193,142,21,235,32,207,92,168,98,137,174,195,86,144,17,214,145,140,127,213,139,252,108,179,5,49,173,32,73,193,20,75,54,220,163,17,194,228,104,16,37,50,63,51,61,50,171,98,22,22,195,178,68,62,69,195,210,223,122,7,193,35,103,5,90,106,194,91,15,93,140,247,149,216,254,64,47,99,220,224,133,135,15,179,167,0,3,154,47,194,128,255,37,107,211,
37,97,29,247,170,0,89,69,98,226,175,7,20,117,81,112,65,160,47,102,123,138,221,53,230,80,69,94,20,20,40,120,2,188,44,209,173,231,225,171,155,206,142,158,71,210,141,194,102,21,230,41,177,72,128,201,211,61,69,56,169,168,192,22,225,23,28,72,100,106,1,13,2,70,20,88,64,35,92,23,76,247,208,140,181,74,69,5,53,4,156,40,76,81,160,59,210,217,216,105,36,236,88,240,49,95,125,156,133,9,144,21,36,53,197,55,20,15,209,248,71,224,51,203,118,177,61,22,86,147,176,92,197,118,133,173,177,53,250,16,73,177,152,40,108,108,86,161,148,167,224,168,233,129,168,176,200,11,87,34,195,250,217,46,215,107,17,107,225,139,99,53,54,7,225,47,108,170,81,209,145,23,182,112,140,5,73,194,209,45,86,132,21,214,33,23,71,183,70,5,183,213,124,36,145,34,43,205,133,4,40,227,124,0,14,9,16,103,238,122,97,199,6,230,68,144,238,196,6,241,33,139,233,160,43,41,30,226,163,169,10,98,193,11,209,135,19,194,251,171,34,62,136,138,139,204,255,161,72,174,190,40,139,13,46,210,115,145,172,168,1,151,242,89,68,215,31,139,164,249,109,126,188,146,143,44,142,222,32,153,24,
21,15,49,15,228,156,26,31,117,13,155,244,163,10,116,204,126,92,5,92,74,197,159,232,252,200,142,203,16,108,229,90,146,100,6,7,112,229,207,130,147,217,3,151,108,81,82,45,124,157,99,110,209,7,18,104,60,169,166,64,6,250,100,49,3,11,246,104,140,209,199,18,88,104,87,243,163,168,206,108,30,62,156,64,65,17,246,110,171,198,86,34,252,82,16,207,120,85,160,189,172,195,149,60,106,97,126,230,139,185,144,133,54,161,47,254,135,94,199,148,176,148,108,36,129,245,133,2,118,81,147,7,52,230,133,43,78,106,145,132,88,248,205,25,104,245,44,122,118,148,184,205,128,225,124,137,143,41,200,174,176,2,162,221,151,172,128,40,28,178,5,22,60,21,17,9,191,20,18,45,127,80,129,198,139,81,233,69,107,88,147,63,128,190,160,121,99,148,224,250,117,95,69,69,225,39,183,252,240,250,45,247,3,5,7,250,192,66,56,120,207,98,65,20,23,121,225,193,123,146,37,90,24,203,96,30,158,127,44,184,199,194,151,207,131,48,251,34,8,215,125,85,42,91,77,31,31,147,92,164,128,200,18,141,179,221,52,124,178,232,163,228,98,244,145,13,154,3,187,111,178,224,252,5,243,181,248,
40,38,60,65,97,12,190,138,138,131,249,0,195,114,225,145,252,93,255,253,41,236,75,120,2,152,174,167,209,194,15,219,177,57,70,139,77,212,247,224,237,242,190,88,216,65,99,10,60,174,69,100,148,24,7,7,216,12,240,123,103,191,236,40,146,190,130,181,98,57,210,79,146,129,203,182,148,233,37,142,81,168,245,180,95,201,62,249,45,20,125,89,162,176,24,100,22,77,202,110,240,74,225,127,21,24,40,145,37,126,10,40,224,177,133,23,102,41,106,81,33,144,18,9,74,228,134,55,250,162,2,162,231,189,226,17,147,45,242,253,194,114,154,61,185,199,96,40,30,220,101,5,35,54,111,124,19,120,237,58,176,160,240,213,62,70,1,205,217,199,25,158,184,119,167,128,93,55,182,118,135,138,159,129,95,215,151,162,59,21,213,58,224,83,241,63,21,18,209,120,228,24,239,90,182,90,54,209,157,120,73,242,62,197,120,236,99,19,252,223,3,108,116,76,241,1,125,196,65,182,160,10,178,85,128,44,187,71,180,43,95,207,179,198,236,55,117,153,18,230,111,5,72,204,223,18,45,216,136,42,190,215,248,252,60,5,68,179,221,151,192,187,62,192,113,45,80,161,237,76,215,69,225,214,19,14,
245,177,6,217,26,250,96,67,88,126,216,81,132,132,92,232,51,217,1,126,213,64,131,45,73,161,147,154,147,70,177,41,125,100,245,86,112,248,106,192,127,67,161,80,184,229,136,138,131,2,131,159,248,158,166,69,225,65,176,20,124,12,238,192,3,188,136,183,133,167,152,26,0,245,145,47,10,149,24,19,50,185,251,62,50,88,137,160,9,191,176,147,226,184,3,250,32,6,246,196,206,47,172,104,73,252,61,197,187,100,175,161,159,77,86,217,194,10,20,71,230,186,241,191,177,247,237,3,163,20,97,170,16,142,36,74,64,226,196,230,103,5,72,253,123,125,138,143,2,146,39,42,62,82,1,173,98,158,74,244,7,196,201,148,64,9,172,136,214,203,240,209,15,43,152,94,71,50,13,222,87,65,36,69,40,20,119,68,52,218,4,220,229,3,117,154,174,0,111,252,159,142,155,77,116,15,30,80,179,81,251,97,198,110,242,198,244,188,233,49,233,124,209,149,116,24,31,188,80,145,151,252,16,225,130,231,209,212,165,189,236,125,189,207,195,198,194,142,223,73,224,156,216,149,174,229,190,82,112,131,13,198,243,159,31,182,5,25,192,175,209,173,244,199,52,11,57,169,192,70,56,194,119,178,66,
155,240,133,116,27,139,65,211,196,78,33,18,186,129,66,37,22,222,210,120,4,79,209,104,244,129,29,21,103,62,118,226,253,217,110,146,85,44,134,74,97,146,207,135,34,40,86,162,9,190,225,142,197,81,117,95,120,150,13,26,97,158,49,241,59,118,25,176,225,255,180,217,31,101,42,224,132,119,88,72,65,69,131,242,167,54,177,213,178,53,89,129,119,36,103,153,47,215,49,46,116,182,22,92,233,96,30,42,214,196,215,110,219,205,255,86,156,105,99,164,48,9,89,19,125,188,0,56,151,202,119,136,244,137,108,86,37,165,196,23,210,43,106,234,49,221,82,202,152,130,229,2,39,96,98,250,4,58,212,135,41,140,30,194,50,116,119,103,187,21,55,89,145,19,120,81,113,19,73,110,232,139,98,251,230,97,18,133,22,163,34,169,168,248,73,167,111,133,77,159,89,193,149,10,155,62,126,188,162,88,184,68,146,247,211,168,208,233,41,69,77,159,212,200,22,112,225,41,54,21,47,241,209,10,241,134,138,152,68,3,146,239,200,103,241,199,106,22,188,37,62,66,35,255,195,93,20,224,83,144,65,76,95,48,205,87,221,34,118,193,98,229,124,76,116,134,4,232,108,59,186,30,61,47,126,130,
119,44,137,184,168,184,47,182,170,201,239,44,49,156,20,242,167,19,126,32,46,111,124,66,81,147,112,172,194,15,233,147,247,39,34,121,77,194,209,10,156,84,8,169,34,101,107,156,82,204,94,197,122,178,119,197,35,203,241,227,104,1,89,124,30,10,225,182,129,215,24,252,255,128,237,12,114,61,133,111,196,7,68,194,202,35,192,94,49,77,138,107,159,235,183,233,78,236,198,65,154,189,240,33,118,147,176,62,55,132,255,45,27,80,120,19,206,132,47,199,230,41,6,180,21,95,98,37,244,204,71,46,70,177,133,183,169,128,192,189,59,1,28,90,41,166,107,176,66,51,226,69,86,24,28,168,153,239,253,241,39,20,150,98,59,38,105,100,232,96,28,167,144,71,227,108,14,31,118,47,254,202,9,154,216,90,240,93,158,14,90,206,35,220,130,239,118,134,230,181,219,108,20,40,133,71,25,147,18,255,42,140,82,129,212,4,219,193,17,232,111,13,190,22,197,75,215,89,104,65,60,178,147,197,48,146,7,93,120,136,197,48,164,235,78,30,79,132,95,28,15,194,205,39,40,26,56,17,132,27,78,150,224,111,173,201,183,142,193,163,216,3,240,162,198,207,113,232,214,226,202,86,172,161,123,
101,235,112,77,60,220,161,123,89,104,163,133,237,41,9,44,37,205,85,8,209,54,172,230,42,79,57,135,240,75,198,201,216,153,3,182,61,242,149,227,97,140,57,101,153,155,230,248,152,220,3,126,30,243,14,108,222,175,250,3,10,150,34,91,153,248,137,10,12,222,29,231,30,233,33,240,30,54,181,211,116,114,195,96,33,121,76,97,146,83,145,177,138,146,40,94,82,81,146,83,1,147,236,218,249,125,250,80,165,108,45,201,5,62,78,207,71,58,244,145,46,21,29,45,23,45,229,210,162,79,114,23,228,169,68,127,250,232,154,146,116,20,41,249,28,19,253,249,194,223,226,163,141,102,35,88,254,74,31,131,214,98,198,90,200,184,106,103,228,95,169,48,84,31,255,44,202,229,229,241,126,148,207,145,108,182,6,135,112,99,214,87,76,45,60,3,29,174,133,254,78,50,247,149,44,82,112,12,58,43,55,26,227,195,60,178,7,182,177,73,183,74,127,202,246,52,122,220,140,205,169,223,108,242,171,98,156,51,127,106,43,116,23,44,144,95,153,111,91,69,178,249,154,91,120,180,145,156,206,109,195,255,2,5,86,250,224,199,2,57,55,21,86,168,72,93,73,105,37,147,101,95,22,11,115,226,204,
53,138,27,156,120,82,244,3,101,211,80,188,178,9,121,136,191,20,217,191,232,12,138,81,37,247,25,7,77,121,135,85,48,193,111,124,195,24,126,207,110,108,38,21,70,175,135,174,105,238,205,183,95,143,174,195,150,148,108,164,176,139,125,11,227,20,175,81,0,214,168,255,125,217,80,192,187,205,198,107,186,99,12,59,75,180,218,8,157,156,96,27,135,102,42,137,97,104,33,155,43,71,68,163,52,2,31,137,41,134,99,11,96,124,11,141,41,182,145,58,90,18,94,132,95,107,135,98,20,201,4,20,209,89,65,135,108,85,217,166,121,22,156,145,14,87,146,220,252,148,47,143,242,222,139,22,87,214,130,43,246,206,149,131,22,179,145,191,163,70,82,244,189,167,226,35,27,3,227,194,118,160,136,138,185,106,190,106,242,1,30,214,220,131,95,9,12,109,129,253,34,189,74,70,199,145,133,62,5,103,81,193,48,133,16,208,110,108,150,5,190,160,103,229,71,205,230,151,223,54,123,240,6,31,185,160,8,163,126,45,178,145,5,111,120,127,126,247,99,229,83,177,163,145,219,251,136,253,254,233,227,39,38,23,41,168,19,141,22,106,248,80,45,56,151,204,44,236,126,234,248,112,121,68,
179,124,252,69,54,140,45,76,128,12,213,184,100,91,188,78,155,141,163,15,167,250,150,91,253,131,126,37,55,125,139,17,168,0,84,141,57,53,221,1,52,235,27,29,116,163,35,85,140,44,223,118,45,186,252,48,219,38,195,187,11,143,176,191,2,238,31,179,247,193,255,122,232,123,87,31,133,59,125,36,177,85,188,67,206,139,130,166,48,197,241,19,124,168,13,94,211,56,88,0,7,125,28,45,240,67,193,10,250,84,50,85,250,16,217,143,95,29,197,119,228,191,64,99,169,254,173,52,136,7,52,251,198,237,131,47,41,21,54,16,71,73,159,143,67,43,216,166,208,100,106,128,123,229,227,153,124,22,143,196,41,48,138,189,169,129,6,88,24,153,235,98,200,31,243,145,172,152,9,124,170,184,73,77,234,178,67,84,120,49,77,1,93,161,134,24,252,110,252,105,124,125,21,55,9,183,240,146,141,91,31,226,152,165,160,113,246,224,104,4,75,100,80,180,240,223,19,241,153,62,200,2,141,111,112,44,254,135,238,195,38,100,225,99,241,154,230,7,15,70,124,121,148,98,138,42,138,236,104,150,18,94,108,65,192,203,123,76,222,217,130,128,42,248,160,112,241,79,5,77,43,240,245,129,29,176,
151,175,194,184,224,61,154,60,176,99,86,1,115,197,35,224,61,21,88,68,54,246,62,198,32,123,12,91,132,184,9,112,135,62,210,69,30,227,35,106,240,151,193,244,82,159,22,148,68,94,34,43,41,78,162,80,140,230,90,195,9,252,4,173,159,136,154,242,35,158,87,60,168,137,103,9,198,235,224,91,237,205,127,97,225,153,129,74,21,25,1,67,227,89,193,20,248,250,51,41,125,176,228,38,177,216,1,211,45,106,240,23,28,120,182,22,84,35,182,80,196,61,176,215,71,216,66,100,133,125,4,231,32,139,51,61,150,143,83,23,241,27,116,102,250,140,152,81,142,34,153,92,154,28,161,240,207,135,127,88,120,0,93,117,137,162,91,96,67,60,197,248,24,123,179,88,60,165,248,189,21,18,66,3,62,52,80,162,194,237,112,37,246,19,178,64,184,229,127,95,60,206,152,131,112,95,187,47,253,50,147,213,71,12,193,49,241,183,217,118,236,79,226,150,44,224,100,49,226,66,203,35,138,254,140,39,35,26,238,68,55,177,216,22,58,130,56,8,245,19,125,119,77,207,136,199,141,206,153,175,244,153,53,189,16,243,147,239,165,251,149,7,135,103,45,55,3,207,26,159,43,158,39,27,74,124,109,246,17,
69,110,228,93,165,111,34,91,8,123,231,253,25,248,120,121,65,17,252,2,45,20,128,14,242,88,160,193,231,227,27,30,13,2,90,64,19,217,13,222,79,247,202,79,80,65,119,68,7,200,101,248,218,112,44,185,132,31,4,156,41,242,142,98,129,158,22,33,10,211,216,68,119,6,18,97,9,242,246,75,182,149,131,65,174,135,186,134,44,91,23,182,199,190,193,68,232,142,198,88,36,40,30,142,29,13,152,99,228,191,43,214,195,98,203,17,15,175,100,47,57,15,157,243,17,198,200,15,52,63,17,59,185,135,5,184,208,119,90,180,234,218,32,231,88,12,67,13,134,210,215,124,124,253,29,139,254,234,26,197,51,104,154,210,189,54,103,252,23,98,22,250,191,210,96,17,189,199,179,15,94,48,6,187,143,120,155,255,254,179,103,203,197,89,90,124,105,185,153,37,70,44,74,118,2,141,44,196,153,88,164,90,186,177,208,66,177,34,185,215,188,21,185,17,119,165,6,192,10,238,105,2,204,117,93,210,7,180,172,64,139,15,103,25,253,189,251,12,30,86,225,33,69,110,202,19,90,161,86,114,191,201,140,143,58,53,42,64,244,222,159,126,178,26,57,30,188,59,13,124,136,161,11,78,166,27,228,135,200,
14,104,167,184,13,159,200,248,88,252,91,13,46,198,250,225,97,252,253,139,224,225,8,11,65,161,171,194,45,232,183,44,250,9,123,110,62,9,76,38,6,201,5,72,158,146,43,239,178,130,193,64,244,194,51,75,121,126,180,120,44,240,224,157,43,56,30,123,63,242,36,6,28,108,193,55,244,154,138,178,68,207,216,166,151,226,239,200,87,106,161,22,22,226,231,89,42,174,211,162,3,198,107,146,17,254,251,161,135,194,237,242,248,227,216,122,250,216,78,169,22,172,120,63,120,165,12,93,92,6,76,173,201,66,240,21,255,99,79,82,112,213,170,66,52,213,17,144,111,230,3,118,73,53,1,18,195,182,226,43,45,218,174,98,59,91,224,128,6,38,242,135,138,111,227,171,171,240,74,99,83,241,21,249,103,251,224,129,232,223,198,128,140,64,102,40,78,84,50,191,155,56,202,110,120,188,149,218,20,98,7,216,110,202,85,105,97,61,10,190,168,129,224,163,241,115,173,199,224,215,17,10,169,144,19,42,164,82,115,103,150,226,56,236,61,236,93,124,68,10,102,139,252,199,59,120,231,8,31,209,57,122,128,231,71,239,67,38,128,179,183,199,120,73,192,75,244,2,173,194,189,159,64,255,
106,38,89,197,0,61,86,134,154,138,243,214,239,55,253,103,175,247,255,0,175,28,230,88);


programfile__We_Will_Rock_You_mid:array[0..10218] of byte=(
77,84,104,100,0,0,0,6,0,1,0,8,0,120,77,84,114,107,0,0,0,32,0,255,88,4,4,2,24,8,0,255,89,2,1,0,0,255,81,3,11,77,133,248,0,255,89,2,2,0,0,255,47,0,77,84,114,107,0,0,5,218,0,255,33,1,0,0,255,3,5,100,114,117,109,115,0,201,0,0,153,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,
36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,
100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,
0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,
60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,0,255,47,0,77,84,114,107,0,0,5,222,0,255,33,1,0,0,255,3,9,100,114,117,109,32,101,99,104,111,0,201,0,4,153,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,
36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,
39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,
100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,
0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,0,255,47,0,77,84,114,107,0,0,5,223,0,255,33,1,0,0,255,3,10,100,114,117,109,32,101,99,104,111,50,0,201,0,8,153,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,
100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,
0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,
60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,
36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,36,0,0,39,100,60,39,0,60,36,100,60,36,0,0,36,100,60,
36,0,0,39,100,60,39,0,0,255,47,0,77,84,114,107,0,0,4,133,0,255,33,1,0,0,255,3,10,108,101,97,100,32,118,111,99,97,108,0,192,80,143,0,144,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,60,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,81,100,60,81,0,0,79,100,60,79,0,0,79,100,30,79,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,76,100,57,74,100,3,76,0,27,74,0,1,76,100,60,76,0,32,69,100,30,69,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,60,74,100,30,74,0,0,74,100,30,74,0,0,74,100,60,74,0,0,74,100,60,74,0,0,69,100,30,69,0,0,71,100,30,71,0,0,69,100,30,69,0,0,67,100,30,67,0,0,64,100,30,64,0,0,64,100,90,64,0,0,71,100,30,71,0,0,74,100,30,74,0,0,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,130,104,79,100,120,79,0,0,
78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,130,104,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,76,100,60,76,0,0,76,100,30,76,0,0,81,100,60,81,0,0,79,100,60,79,0,0,79,100,30,79,0,0,71,100,30,71,0,0,74,100,60,74,0,0,76,100,30,76,0,0,76,100,60,76,0,0,74,100,30,74,0,0,76,100,60,76,0,30,64,100,30,64,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,60,74,100,30,74,0,0,74,100,30,74,0,0,74,100,60,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,69,100,30,69,0,0,71,100,30,71,0,0,69,100,30,69,0,0,67,100,30,67,0,0,64,100,30,64,0,0,64,100,90,64,0,60,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,130,104,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,
100,60,76,0,130,104,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,30,76,0,0,74,100,30,74,0,0,76,100,60,76,0,0,81,100,60,81,0,0,79,100,60,79,0,0,79,100,30,79,0,0,71,100,30,71,0,0,74,100,60,74,0,0,76,100,30,76,0,0,76,100,60,76,0,0,76,100,30,76,0,0,76,100,60,76,0,60,76,100,60,76,0,0,76,100,60,76,0,0,76,100,60,76,0,0,74,100,60,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,74,100,30,74,0,0,69,100,30,69,0,0,71,100,30,71,0,0,69,100,30,69,0,0,67,100,30,67,0,0,64,100,60,64,0,0,76,100,60,76,0,60,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,30,76,0,0,74,100,30,74,0,0,71,100,60,71,0,129,82,71,100,30,71,0,0,74,100,60,74,0,0,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,
0,0,76,100,60,76,0,129,112,67,100,30,67,0,0,69,100,30,69,0,0,71,100,30,71,0,0,74,100,30,74,0,0,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,129,112,71,100,30,71,0,0,74,100,90,74,0,0,79,100,120,79,0,0,78,100,120,78,0,0,76,100,120,76,0,0,74,100,120,74,0,0,76,100,60,76,0,0,76,100,60,76,0,0,255,47,0,77,84,114,107,0,0,2,102,0,255,33,1,0,0,255,3,13,98,97,99,107,117,112,32,118,111,99,97,108,115,0,193,81,158,0,145,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,145,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,
0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,145,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,130,104,67,100,0,79,100,120,79,0,0,67,0,0,66,100,0,78,100,120,78,0,0,66,0,0,64,100,0,76,100,120,76,0,0,64,0,0,62,100,
0,74,100,120,74,0,0,62,0,0,64,100,0,76,100,60,76,0,0,64,0,0,64,100,0,76,100,60,76,0,0,64,0,0,255,47,0,77,84,114,107,0,0,8,107,0,255,33,1,1,0,255,3,11,76,101,97,100,32,71,117,105,116,97,114,0,207,84,229,2,191,7,2,5,7,3,15,7,4,10,159,64,100,0,191,7,5,15,7,6,10,7,7,10,7,8,15,7,9,10,7,10,15,7,11,10,7,12,10,7,13,15,7,14,10,7,15,15,7,16,10,7,17,10,7,18,15,7,19,10,7,20,15,7,21,10,7,22,10,7,23,15,7,24,10,7,25,15,7,26,10,7,27,10,7,28,15,7,29,10,7,30,15,7,31,10,7,32,10,7,33,15,7,34,10,7,35,10,7,36,15,7,37,10,7,38,15,7,39,10,7,40,10,7,41,15,7,42,10,7,43,15,7,44,10,7,45,10,7,46,15,7,47,10,7,48,15,7,49,10,7,50,10,7,51,15,7,52,10,7,53,15,7,54,10,7,55,10,7,56,15,7,57,10,7,58,15,7,59,10,7,60,10,7,61,15,7,62,10,7,63,10,7,64,15,7,65,10,7,66,15,7,67,10,7,68,10,7,69,15,7,70,10,7,71,15,7,72,10,7,73,10,7,74,15,7,75,10,7,76,15,7,77,10,7,78,10,7,79,15,7,80,10,7,81,15,7,82,10,7,83,10,7,84,15,7,85,10,7,86,15,7,87,10,7,88,10,7,89,15,7,90,10,7,91,15,7,92,10,7,93,10,7,94,15,7,95,10,7,96,10,7,97,15,7,98,10,7,99,15,7,100,10,7,101,
10,7,102,15,7,103,10,7,104,15,7,105,10,7,106,10,7,107,15,7,108,10,7,109,15,7,110,10,7,111,10,7,112,15,7,113,10,7,114,15,7,115,10,7,116,10,7,117,15,7,118,10,7,119,15,7,120,10,7,121,10,7,122,15,7,123,10,7,124,10,7,125,131,86,159,64,0,0,48,100,0,55,100,0,60,100,0,64,100,15,64,0,0,48,0,0,55,0,0,60,0,0,64,100,0,60,100,0,55,100,0,48,100,131,36,48,0,0,64,0,0,60,0,0,55,0,0,61,100,0,45,100,0,52,100,0,57,100,15,57,0,0,61,0,0,45,0,0,52,0,15,45,100,0,52,100,0,57,100,0,61,100,15,61,0,0,45,0,0,52,0,0,57,0,15,45,100,0,52,100,0,57,100,0,61,100,60,61,0,0,45,0,0,52,0,0,57,0,0,43,100,0,50,100,0,55,100,0,59,100,30,59,0,0,43,0,0,50,0,0,55,0,0,45,100,0,52,100,0,57,100,0,61,100,60,61,0,0,45,0,0,52,0,0,57,0,0,52,100,0,57,100,0,61,100,15,61,0,0,57,0,0,52,0,15,52,100,0,57,100,0,61,100,15,61,0,0,57,0,0,52,0,0,41,100,15,41,0,15,57,100,0,61,100,0,52,100,0,45,100,15,45,0,0,57,0,0,61,0,0,52,0,0,45,100,0,52,100,0,57,100,0,61,100,80,61,0,0,45,0,0,52,0,0,57,0,0,45,100,0,52,100,0,57,100,0,61,100,40,61,0,0,45,0,0,52,0,0,57,0,0,43,100,0,
50,100,0,55,100,0,59,100,30,59,0,0,43,0,0,50,0,0,55,0,0,45,100,0,52,100,0,57,100,0,61,100,30,61,0,0,45,0,0,52,0,0,57,0,0,61,100,0,57,100,0,52,100,0,45,100,30,45,0,0,61,0,0,57,0,0,52,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,60,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,30,64,0,0,73,0,0,69,0,0,74,100,0,69,100,0,66,100,30,66,0,0,45,0,0,74,0,0,69,0,0,66,100,0,69,100,0,74,100,0,45,100,60,74,0,0,66,0,0,69,0,0,74,100,0,69,100,0,66,100,30,66,0,0,45,0,0,74,0,0,69,0,0,73,100,0,69,100,0,64,100,0,45,100,129,82,45,0,0,73,0,0,69,0,0,64,0,30,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,69,100,0,73,100,0,64,100,30,64,0,0,73,0,0,66,100,0,74,100,30,74,0,0,66,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,60,73,0,0,64,0,0,69,0,0,73,100,0,
69,100,0,64,100,30,64,0,0,69,0,0,73,0,0,73,100,90,73,0,0,81,100,0,64,100,30,64,0,0,81,0,0,79,100,0,64,100,30,64,0,0,79,0,0,64,100,30,64,0,0,45,100,0,78,100,30,78,0,0,64,100,30,64,0,0,76,100,30,76,0,0,64,100,30,64,0,0,45,0,0,45,100,0,74,100,0,69,100,0,66,100,30,66,0,0,69,0,0,74,0,0,64,100,0,69,100,0,73,100,30,73,0,0,69,0,0,64,0,0,66,100,30,66,0,0,66,100,0,69,100,0,74,100,129,52,74,0,0,69,0,0,66,0,0,73,100,30,73,0,0,71,100,30,71,0,0,69,100,0,64,100,60,64,0,0,69,0,0,64,100,30,64,0,0,76,100,0,69,100,30,69,0,0,76,0,0,69,100,30,69,0,0,69,100,0,76,100,30,76,0,0,73,100,30,45,0,0,45,100,30,73,0,0,69,0,0,76,100,30,76,0,0,45,0,0,78,100,30,78,0,0,78,100,30,78,0,0,76,100,30,76,0,0,73,100,30,73,0,0,73,100,30,73,0,0,71,100,30,71,0,0,69,100,30,69,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,69,100,0,74,100,0,66,100,0,45,100,30,66,0,0,74,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,69,100,0,66,100,0,74,100,0,45,100,30,74,0,0,66,0,0,64,100,0,73,100,30,73,0,0,45,0,0,69,0,0,64,0,0,73,100,0,
69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,64,100,0,69,100,0,73,100,0,45,100,129,52,45,0,0,64,0,0,69,0,0,73,0,30,73,100,0,69,100,0,64,100,0,45,100,10,45,0,0,73,0,0,69,0,0,64,0,20,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,60,64,0,0,73,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,90,45,0,0,73,0,0,69,0,0,64,0,0,74,100,0,69,100,0,66,100,0,45,100,60,45,0,0,74,0,0,69,0,0,66,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,60,64,100,0,69,100,0,73,100,0,45,100,15,45,0,0,64,0,0,69,0,0,73,0,0,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,45,100,0,73,100,0,69,100,0,64,100,60,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,
69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,64,100,30,64,0,0,69,0,0,45,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,74,100,0,69,100,0,66,100,60,66,0,0,45,0,0,74,0,0,69,0,0,45,100,0,73,100,0,64,100,0,69,100,60,69,0,0,45,0,0,73,0,0,64,0,60,45,100,0,73,100,0,69,100,0,64,100,60,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,64,100,30,64,0,0,69,0,0,45,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,74,100,0,69,100,0,66,100,60,66,0,0,45,0,0,74,0,0,69,0,0,73,120,0,69,120,0,64,120,0,45,120,60,45,0,0,73,0,0,69,0,0,64,0,0,255,47,0,77,84,114,107,0,0,6,144,0,255,33,1,0,0,255,3,11,76,101,97,100,32,71,117,
105,116,97,114,0,206,29,0,190,7,86,248,0,158,45,100,0,52,100,0,57,100,0,61,100,60,61,0,0,45,0,0,52,0,0,57,0,0,43,100,0,50,100,0,55,100,0,59,100,30,59,0,0,43,0,0,50,0,0,55,0,0,45,100,0,52,100,0,57,100,0,61,100,60,61,0,0,45,0,0,52,0,0,57,0,0,52,100,0,57,100,0,61,100,15,61,0,0,57,0,0,52,0,15,52,100,0,57,100,0,61,100,15,61,0,0,57,0,0,52,0,0,41,100,15,41,0,15,57,100,0,61,100,0,52,100,0,45,100,15,45,0,0,57,0,0,61,0,0,52,0,0,45,100,0,52,100,0,57,100,0,61,100,80,61,0,0,45,0,0,52,0,0,57,0,0,45,100,0,52,100,0,57,100,0,61,100,40,61,0,0,45,0,0,52,0,0,57,0,0,43,100,0,50,100,0,55,100,0,59,100,30,59,0,0,43,0,0,50,0,0,55,0,0,45,100,0,52,100,0,57,100,0,61,100,30,61,0,0,45,0,0,52,0,0,57,0,0,61,100,0,57,100,0,52,100,0,45,100,30,45,0,0,61,0,0,57,0,0,52,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,60,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,30,64,0,0,73,0,0,69,0,0,74,100,0,69,100,0,66,100,30,66,0,0,45,0,0,74,0,0,69,0,0,66,100,0,69,100,0,74,100,
0,45,100,60,74,0,0,66,0,0,69,0,0,74,100,0,69,100,0,66,100,30,66,0,0,45,0,0,74,0,0,69,0,0,73,100,0,69,100,0,64,100,0,45,100,129,82,45,0,0,73,0,0,69,0,0,64,0,30,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,69,100,0,73,100,0,64,100,30,64,0,0,73,0,0,66,100,0,74,100,30,74,0,0,66,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,64,100,0,73,100,30,73,0,0,64,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,60,73,0,0,64,0,0,69,0,0,73,100,0,69,100,0,64,100,30,64,0,0,69,0,0,73,0,0,73,100,90,73,0,0,81,100,0,64,100,30,64,0,0,81,0,0,79,100,0,64,100,30,64,0,0,79,0,0,64,100,30,64,0,0,45,100,0,78,100,30,78,0,0,64,100,30,64,0,0,76,100,30,76,0,0,64,100,30,64,0,0,45,0,0,45,100,0,74,100,0,69,100,0,66,100,30,66,0,0,69,0,0,74,0,0,64,100,0,69,100,0,73,100,30,73,0,0,69,0,0,64,0,0,66,100,30,66,0,0,66,100,0,69,100,0,74,100,129,52,74,0,0,69,0,0,66,0,0,73,100,30,73,0,0,71,100,30,71,0,0,69,100,0,64,100,60,
64,0,0,69,0,0,64,100,30,64,0,0,76,100,0,69,100,30,69,0,0,76,0,0,69,100,30,69,0,0,69,100,0,76,100,30,76,0,0,73,100,30,45,0,0,45,100,30,73,0,0,69,0,0,76,100,30,76,0,0,45,0,0,78,100,30,78,0,0,78,100,30,78,0,0,76,100,30,76,0,0,73,100,30,73,0,0,73,100,30,73,0,0,71,100,30,71,0,0,69,100,30,69,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,69,100,0,74,100,0,66,100,0,45,100,30,66,0,0,74,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,69,100,0,66,100,0,74,100,0,45,100,30,74,0,0,66,0,0,64,100,0,73,100,30,73,0,0,45,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,64,100,0,69,100,0,73,100,0,45,100,129,52,45,0,0,64,0,0,69,0,0,73,0,30,73,100,0,69,100,0,64,100,0,45,100,10,45,0,0,73,0,0,69,0,0,64,0,20,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,60,64,0,0,73,0,0,69,0,0,69,100,0,74,100,0,66,100,30,66,0,0,74,0,0,64,100,0,73,100,30,73,0,0,64,0,0,
69,0,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,0,73,100,0,69,100,0,64,100,0,45,100,90,45,0,0,73,0,0,69,0,0,64,0,0,74,100,0,69,100,0,66,100,0,45,100,60,45,0,0,74,0,0,69,0,0,66,0,0,73,100,0,69,100,0,64,100,0,45,100,30,45,0,0,73,0,0,69,0,0,64,0,60,64,100,0,69,100,0,73,100,0,45,100,15,45,0,0,64,0,0,69,0,0,73,0,0,73,100,0,69,100,0,64,100,0,45,100,15,45,0,0,73,0,0,69,0,0,64,0,0,45,100,0,73,100,0,69,100,0,64,100,60,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,64,100,30,64,0,0,69,0,0,45,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,74,100,0,69,100,0,66,100,60,66,0,0,45,0,0,74,0,0,69,0,0,45,100,0,73,100,0,64,100,0,69,100,60,69,0,0,45,0,0,73,0,0,64,0,60,45,100,0,73,100,0,69,100,
0,64,100,60,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,66,100,0,74,100,30,74,0,0,66,0,0,73,100,0,64,100,30,64,0,0,45,0,0,69,0,0,73,0,0,45,100,0,69,100,0,64,100,30,64,0,0,69,0,0,45,0,0,45,100,0,73,100,0,69,100,0,64,100,90,64,0,0,45,0,0,73,0,0,69,0,0,45,100,0,74,100,0,69,100,0,66,100,60,66,0,0,45,0,0,74,0,0,69,0,0,73,120,0,69,120,0,64,120,0,45,120,60,45,0,0,73,0,0,69,0,0,64,0,0,255,47,0);


programfile__Roses_Are_Red_mid:array[0..4293] of byte=(
120,1,237,93,255,83,28,71,118,239,217,111,31,52,8,14,228,21,66,32,181,214,24,208,24,115,18,32,132,96,89,177,195,205,106,133,64,8,201,230,194,249,100,89,194,8,27,69,54,178,132,49,194,146,227,27,129,132,192,138,101,114,88,62,40,219,85,247,195,221,47,169,84,157,207,178,239,206,167,170,220,151,92,146,203,151,74,93,126,76,85,254,128,252,150,202,111,249,73,121,61,187,179,187,44,140,4,130,205,174,161,171,166,230,189,126,221,211,253,250,245,235,79,247,204,206,206,235,238,29,58,207,24,243,49,133,21,179,255,238,238,189,114,145,82,79,177,135,223,243,120,92,165,121,236,225,41,183,111,166,156,61,220,207,98,89,5,207,178,135,110,68,174,140,190,49,18,168,103,127,220,201,126,165,234,94,198,92,1,151,23,204,123,154,185,207,48,215,32,115,159,103,46,159,203,61,80,234,122,69,115,251,46,187,6,202,220,175,104,46,223,118,247,192,110,75,114,241,63,190,15,229,36,92,195,112,155,37,240,12,195,107,186,224,59,15,16,201,35,201,22,6,181,1,249,42,182,106,40,224,40,212,240,173,147,40,98,40,230,216,198,241,20,135,159,99,59,71,9,199,14,
13,165,126,236,212,80,198,81,206,177,139,99,55,7,231,216,195,17,224,120,154,163,66,195,51,26,42,253,168,210,80,237,199,222,16,52,142,103,57,106,56,158,227,168,53,183,226,219,231,177,239,42,246,95,69,29,181,92,239,71,3,201,14,112,52,170,56,56,140,166,97,28,50,27,209,28,66,139,138,160,134,86,63,66,13,56,172,162,45,132,48,131,206,209,206,241,29,14,131,35,210,128,35,126,68,53,28,85,209,161,225,24,71,39,71,23,199,241,16,186,57,78,104,232,241,227,164,134,83,126,60,207,241,2,71,175,134,239,114,252,25,71,31,199,247,56,94,228,248,62,199,105,142,151,56,206,112,188,172,225,172,31,231,56,250,57,94,209,48,192,113,158,212,27,84,241,170,31,175,113,12,113,92,8,225,207,57,46,106,120,157,227,13,142,97,142,75,28,111,114,92,230,184,162,97,196,143,183,56,70,57,222,230,24,211,112,149,99,156,227,29,142,107,28,215,57,222,229,248,11,117,190,242,93,255,175,240,222,192,116,229,187,183,142,81,98,140,152,241,13,74,111,183,108,208,142,109,212,1,91,109,191,228,0,111,112,7,151,3,44,7,120,99,175,81,171,133,188,92,45,255,193,150,184,
167,254,218,102,114,85,211,181,234,37,49,105,131,99,210,114,14,210,74,219,100,133,250,157,74,15,199,237,32,228,98,27,157,114,195,244,111,201,27,166,6,243,110,243,124,125,83,235,116,125,147,121,80,50,210,8,210,19,86,49,11,110,143,174,162,240,230,153,95,19,85,210,44,18,73,36,146,60,201,44,144,144,34,183,34,107,217,143,221,248,246,252,94,125,108,122,175,126,227,66,78,48,230,229,39,153,5,155,103,173,148,61,149,243,125,45,243,61,121,91,87,242,115,186,173,243,158,188,208,63,124,137,253,70,97,63,83,203,93,140,185,3,204,139,83,222,211,154,235,204,117,247,32,115,157,103,110,159,235,222,222,15,123,116,86,167,143,253,160,71,87,62,236,32,218,65,180,139,104,23,209,158,184,188,155,104,119,74,190,45,23,229,235,116,38,46,57,169,179,90,74,157,76,41,101,215,114,146,228,181,58,19,89,221,58,219,23,175,43,74,52,74,162,78,162,157,86,214,216,15,246,233,76,52,211,21,211,72,104,96,80,174,65,52,93,51,251,42,59,223,110,75,164,73,35,113,9,213,34,52,18,181,68,136,70,210,106,33,141,68,214,202,52,202,9,27,93,221,103,117,129,145,50,
150,133,166,194,52,88,137,148,176,145,144,91,3,49,113,86,100,217,41,97,100,22,21,182,37,235,83,86,74,202,188,63,254,97,72,216,139,133,245,86,178,52,145,80,72,63,76,118,39,142,133,108,25,113,227,100,69,91,102,115,214,181,84,46,66,229,168,22,139,91,174,156,121,48,94,97,208,174,48,20,76,52,146,144,177,32,53,18,212,89,155,206,218,169,156,205,173,84,70,141,200,158,136,113,178,71,34,103,198,36,238,33,22,177,188,139,56,82,82,120,141,205,89,90,183,39,60,201,226,44,25,185,154,112,6,171,56,113,150,119,81,66,200,40,203,226,110,143,202,129,39,75,228,224,192,75,88,201,165,201,248,191,18,32,5,98,200,121,66,107,124,166,150,95,9,245,43,220,193,200,221,138,181,244,203,201,152,193,201,40,151,223,92,90,126,55,208,140,191,45,119,18,114,39,17,127,90,144,169,157,132,4,47,9,94,153,219,167,74,239,202,37,239,74,62,185,246,252,39,61,185,222,210,113,225,181,161,192,235,131,175,190,197,126,123,128,125,174,86,149,39,159,94,95,115,157,185,154,120,122,253,193,137,217,67,6,235,48,152,97,176,176,193,66,134,255,115,108,245,139,255,101,
248,25,182,49,20,181,160,172,24,187,138,193,43,80,193,16,216,134,202,110,104,221,168,173,192,190,98,212,21,163,129,161,238,25,52,250,197,209,204,208,164,161,217,143,32,67,115,19,130,197,8,49,113,110,99,8,209,249,198,83,102,74,67,108,54,37,49,21,94,148,117,200,80,102,155,13,22,137,235,52,113,214,76,73,41,179,81,131,181,27,172,205,96,65,131,178,82,82,74,90,103,168,218,197,189,219,28,213,246,26,247,195,102,175,241,147,246,217,80,132,133,35,204,136,176,174,200,148,222,28,17,134,140,176,20,161,50,219,22,97,193,8,235,20,89,54,171,204,210,147,111,107,122,147,63,76,233,102,34,149,144,83,97,91,120,99,40,20,25,159,13,149,178,112,233,251,123,76,139,42,179,193,82,214,86,74,133,44,170,100,44,247,129,50,219,123,224,211,247,204,222,3,9,230,51,106,109,205,125,166,142,228,66,247,126,161,124,142,195,26,130,28,205,154,248,187,18,253,119,169,142,254,216,68,127,117,82,81,73,127,123,82,17,240,139,255,66,149,251,81,166,97,135,249,170,248,171,84,25,159,237,221,78,147,184,252,211,139,102,239,118,178,203,118,97,32,139,89,36,189,
203,72,122,151,101,108,108,226,163,78,238,67,62,65,173,144,55,44,231,28,98,8,21,91,49,69,36,132,186,22,179,84,154,4,185,170,147,4,114,158,239,244,143,140,176,223,85,179,159,171,122,99,28,223,94,240,158,126,199,117,230,90,2,223,254,52,250,87,149,122,235,141,74,253,112,156,42,105,116,237,242,0,213,31,160,250,99,84,73,163,75,229,21,84,190,130,202,199,168,146,70,151,202,165,254,98,252,236,113,91,58,94,223,108,251,79,181,75,7,181,38,232,70,29,96,27,16,150,2,129,147,227,74,128,120,244,132,95,45,32,58,217,217,73,46,237,47,237,159,92,112,114,111,254,58,249,173,147,124,47,225,235,94,218,112,196,168,146,70,151,202,51,237,255,78,122,58,201,165,254,98,195,104,111,20,151,110,16,157,236,230,36,127,150,252,225,89,242,135,24,85,210,104,186,252,9,54,40,78,13,59,201,229,0,63,122,128,51,189,224,73,251,175,175,253,51,61,94,153,6,104,169,191,184,163,119,94,248,165,253,229,6,49,151,55,136,114,254,102,119,254,58,237,115,156,228,114,253,93,223,245,215,201,206,78,242,76,219,223,169,93,39,185,220,160,175,243,19,193,76,15,112,
166,1,87,234,191,177,1,66,250,207,163,23,236,204,250,255,63,59,255,244,176,218,129,113,42,239,132,244,78,114,121,135,33,239,48,114,249,14,195,201,111,157,228,153,157,192,171,159,191,78,122,58,201,165,254,114,1,94,203,124,148,254,35,253,39,119,253,39,249,94,85,254,223,196,222,171,26,184,200,126,127,154,125,161,246,119,199,223,171,138,122,79,95,118,157,97,137,247,170,110,220,124,233,135,161,43,133,95,96,171,138,34,47,252,30,248,189,40,241,162,76,197,46,15,184,138,10,47,170,25,42,189,208,10,81,203,80,227,197,62,134,90,58,111,65,131,138,70,31,26,11,208,228,67,144,14,32,228,19,7,189,53,74,239,139,182,81,146,222,26,245,161,109,242,21,232,12,58,160,23,88,7,196,139,164,148,108,243,162,141,46,160,162,177,107,232,236,69,19,189,114,106,93,70,47,164,54,210,123,168,62,212,245,76,132,174,40,63,12,230,188,150,65,210,82,218,114,125,70,92,218,114,253,102,207,55,199,150,173,214,39,47,12,221,251,5,202,24,118,249,176,139,144,200,98,196,153,32,201,7,78,140,87,188,200,30,96,224,94,113,174,240,9,144,138,157,3,150,132,202,240,
124,4,74,80,177,3,149,91,5,120,85,107,168,121,6,53,249,2,185,106,75,176,239,105,212,121,81,71,216,82,132,134,18,52,122,45,32,35,44,171,64,211,110,52,229,11,216,105,46,70,112,7,66,133,2,178,218,1,3,56,226,198,17,143,56,31,45,196,177,82,28,43,68,151,27,93,30,116,21,163,171,4,221,64,143,27,61,192,169,237,120,33,31,223,5,250,60,120,177,20,167,11,113,86,69,63,208,239,22,231,1,21,3,192,96,190,8,17,240,154,138,11,30,92,112,227,34,29,192,27,42,46,1,151,11,48,2,140,184,49,226,193,136,207,58,19,111,37,71,221,16,135,7,163,245,19,182,169,204,251,18,116,214,107,153,249,230,76,20,185,24,174,207,50,35,55,22,235,183,204,8,91,218,168,36,1,124,197,0,158,220,180,239,120,64,155,246,188,23,250,199,2,125,253,99,131,236,239,78,177,251,234,158,87,147,127,248,162,63,68,188,147,216,184,127,100,204,133,142,155,151,38,67,199,149,185,240,241,177,201,48,209,118,162,237,68,13,145,97,44,102,198,44,65,148,74,68,173,140,88,218,190,34,44,174,160,211,229,213,84,106,95,108,80,165,162,53,59,109,171,211,38,42,165,211,170,42,181,43,123,188,
166,137,94,166,23,181,219,79,82,171,115,194,78,113,198,214,212,110,44,68,61,16,134,76,82,42,24,58,62,62,23,234,17,76,15,229,244,80,9,162,6,81,131,104,59,209,118,162,97,162,225,30,234,34,157,200,130,9,73,178,100,148,74,68,19,87,10,99,172,172,206,233,250,149,150,204,68,235,183,91,230,58,134,182,220,199,53,134,107,10,218,234,39,59,134,14,207,25,67,173,147,6,209,14,162,169,233,206,161,250,174,33,117,210,34,29,241,220,80,188,180,119,46,74,165,163,67,193,196,85,17,74,71,82,106,177,211,93,67,141,221,67,152,180,200,145,185,78,42,213,57,212,22,191,90,153,235,162,116,215,80,40,81,139,179,46,141,93,84,75,231,16,145,35,235,174,75,75,215,144,139,58,67,36,188,2,77,54,163,85,54,57,40,173,162,251,233,32,100,167,109,216,138,195,231,248,156,161,19,180,24,39,8,82,78,16,248,156,24,159,139,16,141,36,168,18,79,219,148,46,136,151,107,39,218,78,229,98,148,64,203,74,39,105,172,156,93,239,82,26,107,199,174,55,157,218,237,40,115,81,170,55,74,250,197,232,120,90,154,224,201,169,33,167,142,216,29,72,191,46,189,3,177,52,53,64,159,
181,156,140,232,233,26,62,62,109,156,72,152,54,193,8,27,167,219,66,192,246,57,42,17,58,71,75,193,57,90,10,136,26,68,13,162,237,68,219,137,134,137,134,207,9,48,22,37,195,9,73,178,100,148,74,68,19,87,174,170,78,187,49,39,106,43,97,211,152,50,180,128,101,79,235,100,191,13,161,132,48,149,173,125,204,16,174,185,232,57,243,205,251,214,195,65,5,186,219,122,44,72,139,141,11,109,10,66,121,8,22,162,49,31,13,10,234,232,80,81,183,5,181,10,106,93,168,205,135,150,135,74,15,42,92,168,0,2,30,236,162,27,126,31,202,60,40,85,172,195,133,82,122,144,73,135,2,191,27,219,20,17,147,112,155,11,69,116,16,79,7,49,213,52,20,94,106,92,44,41,114,161,19,107,111,234,162,43,23,186,229,182,34,169,86,89,5,210,219,219,204,244,141,106,18,241,5,96,172,114,163,108,95,108,87,110,167,211,150,15,129,50,98,219,155,251,247,9,114,161,35,128,180,86,238,228,10,189,120,193,163,177,148,11,93,124,181,149,11,157,88,235,86,179,208,153,141,217,220,13,144,239,218,171,191,19,181,135,212,166,25,219,195,16,210,8,72,20,207,44,210,33,217,70,207,36,181,160,121,
245,207,14,30,40,114,95,177,204,205,124,234,10,154,254,24,33,61,189,25,31,43,152,135,228,36,141,225,131,216,184,172,236,230,37,121,95,145,211,55,26,18,127,237,129,218,112,67,155,124,134,159,247,59,241,226,205,243,131,195,255,197,254,224,98,95,170,47,190,39,158,223,43,86,184,17,250,96,219,72,226,249,189,249,65,197,71,241,111,115,233,173,55,109,206,60,184,86,97,196,14,77,113,211,230,168,78,155,109,77,21,82,112,9,10,44,65,225,3,110,218,28,149,164,48,2,113,161,205,173,93,37,187,115,139,186,185,172,74,203,10,109,237,164,158,226,75,171,78,195,177,172,233,150,21,174,212,158,95,174,217,23,229,192,139,217,37,39,146,229,181,203,250,226,178,194,149,58,232,23,71,62,170,188,110,94,186,89,121,93,33,102,140,232,228,139,143,151,220,217,249,248,50,127,58,182,86,24,150,174,47,93,63,22,35,202,105,249,93,139,235,255,58,99,158,159,220,201,40,207,209,78,198,219,215,255,246,224,8,251,251,119,216,87,170,110,150,198,247,50,244,113,70,150,250,18,241,173,226,123,71,116,255,87,226,125,221,58,6,205,58,170,233,75,178,137,164,197,
139,47,204,82,150,197,83,153,26,139,167,175,96,214,20,163,177,56,126,110,124,6,181,244,81,90,191,245,146,49,149,108,18,149,208,7,106,169,0,125,163,182,110,155,85,103,149,56,55,80,110,234,81,33,202,208,209,68,103,122,109,216,42,25,231,253,104,74,59,10,208,92,142,230,50,4,203,17,42,191,215,161,171,95,65,247,67,159,170,184,69,223,11,165,180,121,137,152,137,126,193,189,105,232,55,123,40,165,220,59,42,196,71,244,233,58,10,169,118,239,56,69,15,187,117,84,159,210,143,235,73,147,121,126,66,38,203,63,58,122,225,173,254,43,177,143,246,254,195,78,246,11,245,156,89,31,127,137,99,216,138,57,151,124,251,218,252,227,155,31,91,193,31,90,167,98,49,32,30,153,162,133,132,66,147,77,89,100,124,81,73,243,224,162,228,226,204,241,143,173,248,97,173,83,22,121,84,234,49,213,44,214,84,106,67,187,49,135,113,203,188,109,190,124,244,136,203,161,114,30,156,77,109,155,20,176,250,41,129,213,214,56,88,93,161,207,140,191,197,254,113,39,251,165,90,101,118,198,209,170,111,9,90,245,253,40,102,188,219,22,25,127,100,42,54,7,110,199,208,106,
81,73,243,224,162,100,122,53,49,180,186,29,67,171,31,57,167,30,83,205,98,77,165,54,98,66,44,63,110,153,183,205,151,143,30,113,57,84,206,131,179,169,109,147,130,86,127,32,180,82,173,104,8,49,172,250,167,3,236,107,218,89,13,196,177,170,50,13,171,254,210,183,176,56,98,128,255,235,12,198,67,152,73,9,129,192,22,82,18,83,225,69,89,20,15,97,33,37,2,194,196,217,153,148,148,178,144,18,1,129,178,82,82,74,90,103,168,218,197,189,219,28,213,138,120,8,51,34,30,194,194,146,216,0,51,105,241,16,22,236,32,8,100,72,155,85,22,236,104,0,86,60,132,153,68,42,33,167,194,182,208,138,135,176,16,143,135,48,19,251,228,253,66,60,30,194,76,44,30,66,198,114,31,40,11,34,30,194,12,197,67,176,153,207,148,117,232,243,251,123,114,162,123,63,238,251,26,135,56,158,227,216,219,128,42,191,21,3,193,143,167,205,0,2,81,241,151,211,221,42,202,135,81,102,190,132,242,57,109,65,4,62,152,161,192,7,203,50,119,25,101,221,101,25,27,9,178,186,136,136,49,165,11,15,32,158,28,100,57,87,16,3,70,1,15,102,40,224,129,51,147,4,179,3,79,17,152,33,114,101,244,141,
145,192,1,243,3,125,190,70,111,157,174,209,21,73,165,29,164,31,200,121,32,113,64,226,128,196,1,137,3,18,7,36,14,72,28,200,56,14,76,181,203,137,38,39,154,156,104,25,159,104,242,6,87,222,232,203,7,29,242,65,143,196,1,137,3,18,7,36,14,72,28,144,56,32,113,64,226,128,188,1,151,15,32,228,3,8,249,0,66,62,128,144,56,32,113,64,226,128,196,1,137,3,18,7,36,14,72,28,144,56,32,113,64,226,128,196,1,137,3,18,7,36,14,72,28,144,56,32,113,96,3,226,64,242,175,49,91,126,147,252,107,76,227,191,235,243,218,197,214,105,237,162,34,233,102,181,195,235,52,254,175,211,248,75,154,5,59,76,215,207,87,119,182,78,87,119,78,84,101,129,153,25,204,66,163,137,158,110,230,214,19,70,200,17,102,51,143,197,102,238,251,82,247,251,219,108,0,209,82,53,114,68,146,93,223,88,106,132,228,62,46,239,127,146,251,184,131,226,47,206,45,47,143,77,183,188,252,233,150,249,150,235,196,92,255,232,216,188,214,66,75,123,11,45,237,89,161,159,41,113,77,62,110,153,175,166,155,138,106,253,112,26,85,86,152,182,43,90,215,190,233,187,167,53,186,221,213,178,68,99,131,
148,232,209,82,38,235,227,183,196,234,114,28,151,241,151,180,113,92,127,27,37,60,227,22,77,232,98,154,208,197,228,180,217,162,229,212,126,57,181,159,45,90,69,237,87,81,251,217,162,251,169,253,253,212,126,182,104,86,128,156,250,107,183,107,80,255,13,74,103,139,62,79,237,63,79,237,63,41,237,163,235,251,232,250,39,164,105,147,93,66,244,255,203,246,34,102,245,228,206,71,249,87,218,249,196,163,184,190,61,200,254,229,20,123,160,234,94,156,79,251,64,213,205,191,174,252,68,68,2,189,67,81,69,137,25,179,40,69,23,189,67,209,69,63,161,232,162,119,40,186,232,39,20,93,244,78,184,103,186,62,155,37,205,203,159,68,245,177,59,81,93,89,49,237,208,223,223,115,135,62,153,74,23,76,156,181,174,52,244,119,31,128,172,208,198,172,51,49,94,132,232,80,17,228,8,122,173,131,163,57,140,38,13,244,157,216,198,2,52,212,160,174,6,251,128,90,58,242,80,3,104,133,168,6,42,153,8,230,78,209,222,3,20,249,77,3,223,107,133,137,167,224,111,91,81,234,139,31,37,62,248,125,216,70,71,29,138,10,80,4,20,249,80,164,161,16,226,216,90,0,21,80,125,200,3,
242,10,197,217,199,4,227,3,60,214,225,2,92,230,161,59,244,9,231,135,251,217,255,1,26,9,99,174);


programfile__MARYS_MID
:array[0..2302] of byte=(
120,1,236,90,75,108,84,85,24,62,208,193,129,74,208,152,144,8,193,100,18,77,140,100,154,134,210,244,65,105,59,206,195,201,148,66,131,214,8,11,67,137,183,134,8,1,173,33,82,51,19,58,211,153,166,68,193,62,166,221,184,82,246,134,119,116,97,130,248,216,24,87,110,220,235,206,184,50,49,113,85,191,239,252,119,254,94,238,45,45,119,74,5,177,139,230,254,231,127,191,206,185,231,254,157,131,131,39,28,99,204,19,102,131,217,186,97,236,224,224,200,73,99,54,236,50,11,71,34,13,27,135,54,155,133,243,13,198,188,140,199,38,99,62,216,102,204,194,225,134,232,103,177,242,31,46,80,124,150,136,171,23,228,121,103,95,113,23,215,63,183,202,250,183,81,89,255,245,164,93,111,142,254,46,207,157,207,89,252,230,248,231,178,238,205,203,250,213,47,100,253,246,62,121,126,248,188,224,47,157,148,245,229,237,178,254,242,5,89,255,244,169,60,127,117,229,255,254,209,174,183,60,253,145,229,219,242,226,109,89,247,158,146,231,27,85,193,191,187,95,214,23,78,200,250,242,78,89,127,125,84,158,191,188,36,248,63,47,218,117,227,83,
31,219,117,99,124,183,89,104,54,146,163,77,71,204,66,195,182,193,19,195,177,87,206,156,29,137,29,60,62,50,250,190,185,130,76,222,142,154,43,209,243,230,74,99,222,44,28,221,184,209,76,152,169,30,167,148,31,235,113,34,83,73,167,18,155,74,56,241,177,132,93,196,199,146,142,193,95,4,56,112,16,233,97,5,134,164,12,73,25,0,89,103,50,63,150,181,152,138,96,146,78,113,191,43,14,64,196,65,18,75,126,241,20,245,164,32,158,36,32,70,47,137,209,12,245,208,132,2,125,14,244,244,1,211,71,102,2,57,2,57,1,98,240,37,110,93,201,225,153,67,12,36,100,201,177,162,127,224,161,127,26,167,70,158,116,202,18,76,202,25,130,143,204,77,100,42,133,103,10,250,125,126,131,83,50,168,241,67,173,196,143,144,122,156,226,148,199,194,163,152,244,132,39,215,143,73,210,19,227,17,244,123,196,152,169,52,187,188,86,193,52,42,152,70,5,211,168,166,167,243,220,122,165,217,51,36,105,243,228,216,229,210,78,104,65,182,83,154,221,41,226,90,110,144,88,238,160,184,238,22,37,37,29,180,68,18,9,207,82,15,21,42,208,207,46,239,7,166,159,
110,16,56,64,224,128,0,49,244,60,187,155,216,56,144,198,18,116,31,100,41,124,47,255,220,240,60,205,13,12,27,58,205,46,103,48,25,116,185,228,134,112,28,219,207,216,45,232,241,219,221,15,158,248,93,37,9,134,148,120,28,67,90,60,95,159,58,128,243,117,235,107,195,239,157,29,62,253,214,176,19,75,142,154,171,56,93,191,137,154,171,209,99,230,106,99,74,78,215,11,102,186,5,117,45,182,56,145,233,54,2,109,0,58,9,116,122,49,56,18,246,23,113,238,44,242,172,82,170,157,10,219,161,176,139,64,23,0,197,168,45,37,173,210,214,218,197,165,137,106,98,20,77,136,98,15,129,61,0,90,9,180,122,49,202,172,164,250,164,52,27,154,49,77,148,98,130,57,84,235,221,116,172,27,142,37,8,224,20,152,86,76,144,71,109,45,147,195,32,79,51,53,55,67,115,144,164,152,160,207,74,90,198,150,198,165,60,161,114,168,213,169,207,86,157,82,199,144,13,187,191,8,216,253,69,192,238,175,26,166,135,128,221,95,53,76,11,129,250,165,218,41,110,247,23,1,187,191,106,24,181,213,85,35,173,210,86,27,245,172,73,92,157,212,204,68,53,17,176,251,139,
128,221,95,4,236,254,170,97,148,185,181,70,170,79,74,179,17,42,135,106,189,155,214,237,254,34,96,247,87,13,19,228,81,91,203,228,48,200,211,76,133,118,127,17,184,171,73,148,89,139,171,81,40,105,25,91,218,27,202,19,42,135,123,232,15,171,83,159,173,112,82,60,100,216,117,117,238,74,138,215,255,214,211,147,54,120,142,233,25,165,164,135,226,161,158,144,122,170,43,70,61,84,82,168,83,116,253,253,133,174,211,226,106,39,212,87,229,80,153,127,24,239,47,249,40,89,188,207,116,112,227,116,120,51,160,24,189,81,40,70,91,69,49,154,55,197,44,35,165,253,25,188,162,168,148,146,86,105,75,253,9,229,225,253,72,169,66,189,23,237,101,14,247,34,135,186,37,21,163,204,74,170,79,74,179,17,42,135,106,189,151,30,246,194,67,206,72,138,248,242,154,86,76,144,71,109,45,147,141,32,143,54,115,144,164,24,45,174,70,161,164,101,108,105,111,40,79,168,28,106,45,234,179,181,74,41,141,52,24,187,198,165,164,96,45,254,207,245,210,42,7,75,160,24,205,152,246,70,194,49,56,221,204,116,7,254,186,48,148,192,157,205,224,102,105,
112,200,25,220,156,23,63,169,55,189,206,79,234,228,241,145,145,209,216,224,241,209,83,103,70,204,53,124,82,223,137,154,107,209,179,230,90,35,166,187,50,176,156,225,160,166,132,77,51,147,193,40,103,6,67,184,18,6,112,88,196,75,24,83,224,47,2,28,56,136,244,176,2,67,18,71,134,37,140,12,1,76,214,128,138,0,28,117,185,226,0,68,28,36,177,228,23,231,72,168,132,1,11,236,186,164,20,230,30,86,42,71,61,152,204,204,40,48,128,192,75,3,192,12,144,153,0,103,58,37,204,116,8,196,192,24,183,2,125,120,246,35,6,250,199,81,142,139,244,251,167,142,170,19,65,32,131,81,142,13,38,235,12,185,185,137,204,96,48,10,159,141,223,111,112,50,90,85,235,73,223,52,227,47,94,188,43,147,143,94,210,19,158,92,63,38,73,79,184,243,74,212,12,249,150,230,190,71,1,57,148,43,97,106,7,86,0,236,73,79,119,161,201,165,205,208,68,4,56,94,116,235,239,118,59,6,162,247,18,215,30,84,205,25,54,121,6,249,62,64,61,152,69,46,2,135,169,231,48,48,135,233,6,129,67,4,14,9,16,3,99,220,10,244,227,121,8,77,72,111,56,209,116,145,126,255,212,81,
117,34,8,100,217,228,12,56,135,38,151,230,38,204,205,100,236,222,241,248,173,219,65,227,135,105,158,8,105,231,19,179,24,133,141,43,157,48,214,171,255,110,72,216,183,152,107,235,255,131,26,174,153,235,56,76,191,221,109,174,71,223,169,205,38,103,91,206,85,242,227,248,74,155,109,58,87,202,143,99,0,0,12,0,98,90,9,96,0,48,219,70,0,31,130,179,237,231,38,243,227,152,121,44,41,5,18,165,90,200,35,10,1,80,97,19,49,4,84,188,147,70,49,117,240,26,245,187,209,76,30,124,130,123,121,252,154,213,150,7,240,235,89,15,7,57,244,228,199,159,195,127,177,58,242,161,131,190,66,141,216,87,205,236,43,150,56,216,105,29,36,225,27,104,182,147,205,195,86,89,74,10,36,234,105,37,143,40,4,64,133,205,196,16,80,241,46,26,197,148,206,107,212,239,198,30,242,96,184,226,229,241,107,86,91,10,60,120,19,56,95,17,206,226,206,221,186,221,220,192,206,253,46,106,110,68,143,155,27,141,209,218,238,173,182,224,236,44,99,179,85,219,28,83,237,228,2,64,25,233,10,34,66,176,182,67,89,23,149,1,40,227,58,151,174,242,27,186,140,45,92,
229,5,176,140,196,86,249,109,81,70,174,214,200,133,16,222,54,209,83,250,134,148,85,219,185,0,0,215,151,64,132,96,85,7,112,63,21,173,0,172,86,95,118,34,146,119,230,188,19,172,221,116,0,64,25,3,202,165,16,150,42,20,254,135,217,178,98,44,109,89,239,66,216,2,160,97,81,9,83,181,20,58,64,214,0,66,125,93,185,11,66,100,64,89,87,214,26,194,129,181,97,245,213,100,189,99,237,62,88,239,216,7,113,26,174,119,108,4,231,63,142,170,245,51,246,254,222,180,245,36,235,65,158,177,114,205,194,235,16,53,195,173,168,138,41,139,188,206,1,224,117,190,4,34,4,171,239,29,135,147,54,120,37,224,120,175,188,23,134,66,232,93,27,214,102,230,128,215,149,149,243,27,130,85,125,237,70,102,237,173,11,128,189,117,249,178,195,119,53,28,168,189,197,123,101,97,202,24,251,218,183,184,15,225,97,229,239,114,32,103,202,248,247,166,101,189,11,97,47,25,188,96,208,1,75,161,3,100,13,32,212,215,149,187,32,68,6,148,117,101,173,33,28,80,86,70,177,158,87,219,59,247,216,179,139,31,7,27,230,205,77,124,28,124,191,195,220,140,158,54,
55,27,207,203,199,65,113,222,204,245,20,74,249,10,110,140,115,201,66,37,54,151,40,196,43,104,17,44,226,21,252,170,19,127,17,224,192,65,164,135,21,24,146,50,36,97,54,50,151,45,76,230,43,89,139,169,8,38,89,40,238,119,197,1,136,56,72,98,201,47,158,162,30,140,22,97,215,37,37,10,151,96,52,65,19,16,167,9,5,250,10,208,131,201,231,92,31,153,9,228,8,96,144,74,32,6,95,226,214,149,28,158,152,239,88,66,150,28,43,250,7,30,250,167,113,106,228,201,66,89,130,73,21,134,220,220,68,230,82,208,143,95,117,250,253,6,167,100,80,227,135,90,137,31,33,245,36,138,179,238,196,78,135,46,168,206,45,84,231,135,29,230,86,244,77,115,171,113,163,86,103,158,249,152,64,166,231,51,168,206,60,44,78,32,75,88,196,39,48,194,198,95,4,56,112,16,233,97,5,134,36,230,103,2,249,1,48,89,3,42,2,48,153,174,56,0,17,7,73,44,249,197,153,188,9,36,15,118,93,82,10,213,177,82,57,234,65,230,231,21,24,64,117,38,6,128,25,32,51,129,126,2,24,226,17,136,129,49,110,5,250,240,196,8,219,250,199,250,185,72,191,127,234,168,58,17,4,50,168,142,
13,38,91,24,114,115,19,153,71,23,192,103,227,247,27,156,146,65,141,31,166,37,254,105,198,143,223,220,202,171,81,171,99,158,145,114,140,127,197,39,126,25,250,192,41,255,0,0,0,255,255,3,0,220,240,38,20);


programfile__12DAYS_MID
:array[0..1258] of byte=(
120,1,236,156,77,111,220,84,20,134,207,76,218,100,96,67,105,66,232,130,69,144,44,75,113,36,58,10,137,162,73,77,228,144,79,66,195,103,42,181,171,122,193,2,9,177,225,15,92,13,205,6,9,36,196,2,9,33,129,216,242,43,186,132,95,53,60,247,30,219,227,105,218,33,33,241,208,36,39,139,104,124,239,249,124,125,206,123,239,181,39,57,60,250,242,11,17,153,150,150,76,201,211,195,163,111,190,18,105,125,40,131,135,55,110,180,239,116,100,240,168,205,236,224,211,169,153,63,22,254,242,163,83,140,30,103,197,244,111,229,200,119,165,194,159,39,70,42,153,74,235,251,23,203,84,118,198,200,252,144,21,222,199,200,252,84,198,51,70,230,231,83,216,249,245,20,118,126,127,177,29,25,220,21,133,244,173,53,25,188,221,2,201,169,185,79,62,216,252,232,227,133,209,31,121,42,199,217,143,169,203,83,145,242,183,244,156,172,186,126,182,42,210,99,84,100,211,201,138,203,55,253,7,255,123,37,140,44,35,177,204,39,145,204,73,215,229,89,57,221,21,121,199,201,134,147,45,151,111,137,108,136,236,184,124,135,65,65,76,118,29,242,94,120,
87,10,1,228,87,29,50,88,15,62,87,93,142,103,236,162,179,230,21,114,68,215,130,207,125,71,108,253,140,168,246,131,196,129,147,117,151,31,96,44,8,173,123,87,62,13,52,53,84,130,223,242,50,120,238,103,56,66,130,144,112,71,138,133,187,98,102,49,164,214,147,124,113,8,132,130,226,101,9,28,129,0,197,16,7,117,65,48,24,6,34,188,120,76,2,32,67,52,48,135,83,128,90,244,32,18,92,145,181,98,162,113,43,80,88,7,89,98,67,102,199,61,241,233,163,12,20,76,144,56,163,43,152,39,113,21,87,3,104,128,104,113,183,192,137,252,21,63,180,153,88,115,57,200,49,142,13,210,192,198,190,218,240,215,68,230,4,8,53,143,58,138,33,130,17,20,1,32,0,217,207,20,66,189,105,207,65,177,159,17,52,24,248,202,25,173,42,0,100,138,74,65,23,247,32,214,171,21,21,242,140,212,101,180,178,144,169,42,11,25,130,80,25,110,35,185,170,181,42,215,170,166,72,154,217,186,181,148,188,241,138,40,88,214,39,2,160,190,140,52,177,42,117,132,1,112,3,53,42,24,195,227,213,240,70,164,4,88,198,210,207,10,224,253,205,244,80,170,61,245,131,57,187,27,13,
222,13,187,137,158,165,38,218,82,44,2,61,247,196,251,164,93,233,41,152,155,126,62,8,236,188,231,190,93,216,11,172,64,79,208,71,200,166,238,216,183,99,144,133,212,66,75,162,165,124,8,77,104,111,211,54,74,118,202,176,5,247,147,26,100,186,75,103,210,71,200,46,87,109,10,205,66,105,158,216,145,241,253,92,112,127,209,219,74,57,30,150,176,104,41,57,18,2,107,149,146,38,157,78,233,120,154,133,87,9,15,183,21,141,104,99,47,185,124,41,208,129,245,239,127,234,95,191,150,87,251,2,45,5,43,27,91,132,255,109,17,126,182,108,206,178,128,63,171,107,76,101,251,62,136,125,146,37,103,229,106,11,235,240,104,48,36,164,11,60,166,12,141,178,137,25,127,86,57,177,59,126,89,116,141,153,141,153,47,17,51,159,135,213,207,163,107,109,98,109,98,109,210,232,42,102,45,102,45,102,45,214,104,139,217,10,248,18,159,137,170,215,135,239,126,93,189,62,220,254,236,193,225,231,163,111,15,23,228,111,105,253,18,61,108,197,157,86,146,206,36,210,137,228,94,44,59,254,178,251,74,34,113,146,118,18,153,139,101,59,218,150,32,195,
224,116,36,105,44,115,209,253,186,22,35,183,131,22,242,239,199,242,166,151,63,194,38,151,51,193,230,124,152,197,197,22,146,209,190,90,99,86,173,237,198,157,118,210,157,78,100,41,168,188,22,75,144,247,234,111,120,95,133,119,46,137,176,19,203,94,116,191,29,226,81,251,235,177,204,214,188,207,227,154,164,146,148,104,213,251,173,48,203,37,177,221,9,249,182,131,163,155,145,188,23,75,86,234,38,97,240,86,200,87,179,83,251,100,55,95,230,171,49,224,81,109,114,73,70,228,219,10,249,190,154,8,54,145,175,199,51,107,8,27,194,86,195,161,47,140,37,224,165,231,178,196,237,228,30,172,40,209,131,86,34,119,35,233,198,194,101,55,73,253,37,159,147,52,112,166,60,46,63,139,167,56,121,28,33,166,179,71,39,70,160,113,47,239,201,208,55,160,49,188,24,195,235,250,117,206,53,116,182,177,90,149,198,44,183,108,215,81,238,130,108,95,103,251,58,69,224,76,59,103,235,122,78,19,103,66,204,206,26,148,217,21,59,205,53,185,79,179,115,113,179,79,30,94,111,108,119,113,211,158,42,92,185,78,159,252,115,155,230,234,179,201,
125,245,245,58,93,218,46,200,118,65,250,84,249,58,63,211,110,110,23,212,28,83,53,103,249,186,61,97,51,14,52,14,52,14,52,14,28,125,43,209,220,251,139,235,117,46,190,140,117,101,231,223,171,247,164,203,206,191,167,121,187,218,220,174,242,50,90,182,157,240,69,189,181,111,238,238,219,155,80,251,134,27,223,232,187,192,111,184,93,198,29,75,115,253,101,150,235,231,2,91,17,108,69,176,111,228,94,183,239,60,219,138,80,231,64,91,17,38,131,198,255,177,214,76,250,237,167,189,35,230,73,203,41,254,198,100,210,247,197,255,207,190,127,0,0,0,255,255,3,0,248,125,128,134);


programfile__ROCK_MID
:array[0..41535] of byte=(
120,1,100,189,203,87,27,217,151,239,41,240,11,203,24,147,216,233,119,58,241,27,36,89,150,20,8,164,176,140,141,193,128,193,56,243,231,116,57,51,109,167,141,49,198,188,17,66,8,33,35,5,33,80,174,250,149,171,238,69,118,186,107,212,131,94,53,235,213,107,117,61,126,53,191,183,31,195,187,122,212,255,64,211,61,239,217,189,147,94,213,159,239,137,192,153,183,59,215,114,70,156,115,246,222,103,159,253,62,39,34,196,216,147,233,201,64,32,112,48,208,16,8,6,254,195,216,147,220,28,173,175,3,255,246,211,254,253,141,167,155,2,255,246,167,125,7,78,126,253,239,255,205,249,183,155,1,111,240,196,227,192,191,53,52,45,188,157,95,154,92,111,111,15,252,223,193,190,214,123,109,119,3,78,160,239,63,255,26,248,199,96,79,224,31,15,101,3,255,33,245,107,235,63,62,95,253,187,91,59,247,157,7,155,247,157,83,59,195,142,123,114,115,216,185,66,199,77,58,174,170,227,24,29,201,157,81,199,125,189,57,234,212,38,233,186,77,79,84,61,39,232,185,176,51,92,73,109,14,87,46,168,35,226,117,56,110,14,144,237,130,186,94,210,117,
143,155,39,92,91,119,70,184,142,56,77,162,187,31,144,8,19,185,189,204,212,170,158,199,244,108,61,209,93,144,187,204,206,253,149,142,205,251,43,102,166,38,176,117,51,97,168,12,59,213,13,77,144,209,4,143,255,63,19,188,96,130,0,68,70,128,184,0,253,24,228,175,49,177,219,193,64,135,110,98,220,108,77,105,158,86,96,224,97,254,236,230,253,121,49,233,106,158,110,221,68,185,185,8,72,245,129,38,58,11,157,235,208,73,210,51,75,199,247,66,110,228,230,30,55,15,185,158,22,142,13,206,175,45,244,44,210,243,152,107,146,235,117,141,180,50,18,209,205,21,110,206,10,89,32,158,128,18,116,205,50,166,117,236,9,232,48,32,63,2,209,202,188,221,204,219,46,20,205,115,97,103,228,253,196,230,200,251,109,35,238,70,80,236,157,225,210,197,205,225,82,47,43,91,101,97,15,185,62,229,42,137,86,239,106,150,13,136,151,128,100,129,197,142,205,209,98,23,237,135,180,79,3,185,167,141,61,97,69,153,236,166,100,180,15,18,183,117,115,156,155,237,211,16,211,186,31,239,220,223,104,223,188,191,33,18,110,0,26,247,117,243,13,55,152,
129,83,61,13,200,127,146,78,7,32,115,93,60,31,166,167,139,142,71,116,28,84,71,23,29,39,133,36,83,169,245,50,244,19,67,50,136,103,140,52,209,22,11,215,128,200,1,240,144,235,51,174,154,223,216,84,109,64,184,39,233,146,113,189,224,186,39,50,72,84,158,98,135,7,119,238,115,189,95,49,22,117,1,154,210,226,91,174,219,195,16,151,173,25,98,82,158,49,31,173,194,134,214,32,215,107,154,166,196,72,77,19,75,102,140,108,32,179,13,57,192,235,157,145,117,73,28,153,173,7,145,58,230,90,66,65,235,131,155,247,215,37,75,183,25,81,117,237,140,84,80,247,72,101,251,164,136,217,16,99,81,69,148,88,52,42,219,179,4,143,117,100,246,2,136,255,179,184,51,228,184,7,55,135,28,115,115,133,155,211,59,131,114,145,65,103,96,103,192,169,54,111,14,224,148,119,156,159,55,239,56,91,175,5,124,8,24,247,148,238,4,221,46,232,102,160,175,9,186,23,232,237,152,198,246,51,150,217,25,42,181,111,14,149,186,213,193,141,7,124,114,15,248,52,192,23,32,253,84,164,127,1,166,12,200,195,157,161,185,211,155,67,115,119,133,115,98,15,231,
43,112,146,76,176,221,13,78,245,230,206,3,199,109,216,124,0,135,15,54,46,110,62,64,70,116,4,233,232,214,77,35,55,189,220,84,3,220,68,119,238,57,213,137,205,123,142,251,211,30,144,123,90,119,77,123,224,167,184,233,20,237,1,209,190,166,121,91,152,23,166,223,95,219,28,122,159,218,235,184,168,149,158,129,145,40,192,110,17,224,40,204,191,135,249,234,56,61,73,58,58,118,6,214,99,155,3,235,154,180,196,156,131,59,125,206,252,102,159,243,4,192,103,0,78,238,220,150,71,222,118,126,77,128,241,4,12,97,118,112,29,217,233,171,244,110,246,85,90,192,116,79,129,122,157,129,173,22,70,182,102,197,128,196,233,158,208,93,136,187,86,177,210,1,43,39,129,218,206,3,85,29,230,238,5,55,211,92,31,112,61,195,212,131,76,221,180,115,175,204,148,247,202,246,206,64,249,215,107,155,3,229,103,80,201,139,220,121,110,42,220,12,66,109,3,98,189,160,254,122,2,220,103,146,207,73,196,114,109,231,65,249,234,230,131,242,69,117,180,209,209,177,119,147,225,166,218,78,79,43,12,111,5,37,223,132,198,36,114,180,50,209,188,249,
96,34,181,7,28,209,205,53,67,111,192,169,69,153,193,29,212,82,100,118,247,118,134,150,46,109,14,45,93,80,199,5,58,140,65,221,128,157,51,176,227,206,3,108,236,112,68,88,69,117,237,247,186,138,237,155,3,69,163,173,40,88,45,146,200,101,176,190,213,34,90,1,201,105,210,86,38,189,178,243,128,224,243,160,216,78,71,243,206,192,18,43,92,42,210,31,21,192,126,110,204,90,34,220,156,145,173,172,104,45,223,139,156,12,85,194,50,108,93,83,207,5,122,110,50,65,173,65,220,44,106,44,192,228,153,157,129,5,148,184,208,174,142,175,233,184,1,112,214,96,163,153,70,96,35,32,85,23,133,244,88,75,144,198,47,136,160,116,216,68,79,138,142,147,234,8,209,113,129,142,95,207,209,243,92,28,158,135,177,216,206,131,2,242,43,104,9,83,180,101,192,49,255,234,158,229,70,122,169,234,230,180,212,241,134,37,24,220,67,244,44,139,136,140,93,203,52,2,233,101,162,41,230,105,217,25,200,215,240,239,252,180,248,150,127,98,116,43,55,55,7,86,90,119,134,42,224,12,85,238,239,12,86,86,54,7,43,143,196,191,4,111,188,252,37,55,216,89,
225,233,230,64,1,102,243,131,208,8,236,220,203,203,206,242,15,49,188,69,12,111,12,155,127,141,205,191,193,230,183,215,176,249,255,118,144,72,150,34,138,133,184,198,184,198,184,42,27,40,24,42,59,125,205,117,142,43,112,27,164,166,13,197,70,133,224,105,194,89,148,88,165,208,111,211,190,228,95,187,233,87,246,152,229,250,19,215,23,172,235,5,235,106,222,233,223,168,6,55,251,55,254,28,4,242,30,24,87,119,70,203,61,155,163,101,37,66,85,3,80,122,223,190,57,250,94,185,51,75,123,140,107,31,215,43,92,197,81,1,138,221,80,20,167,74,146,202,255,35,92,21,191,53,147,74,145,37,174,63,48,227,51,111,70,103,59,180,217,239,252,58,3,164,214,240,130,171,120,159,252,195,85,107,86,134,23,165,54,40,40,69,98,5,149,4,2,142,210,198,150,134,9,251,131,228,187,65,231,103,58,94,209,126,73,27,0,16,239,108,108,183,111,222,217,248,245,10,61,41,122,174,0,145,7,66,9,195,228,37,12,210,35,174,44,167,101,43,236,43,185,152,172,247,148,155,234,226,31,112,43,224,14,11,87,137,193,224,14,248,56,82,18,121,176,204,181,44,17,
184,200,206,217,10,128,123,219,159,87,153,234,191,158,87,98,18,108,156,107,152,171,167,232,71,78,181,101,147,255,197,192,253,30,92,165,198,130,143,59,15,100,181,13,208,94,110,58,208,72,23,26,129,132,153,86,154,168,42,13,86,117,55,201,205,75,174,25,174,180,215,152,108,13,157,228,185,230,185,46,112,93,192,154,114,72,56,39,171,210,90,167,153,82,130,51,97,233,138,113,13,111,238,97,137,58,3,19,77,64,184,146,228,193,157,59,149,237,169,205,59,149,218,247,32,75,10,176,81,160,76,40,220,164,61,74,251,238,206,104,229,242,230,104,229,56,237,37,218,67,20,52,76,170,130,166,242,152,254,69,104,38,32,169,201,193,51,166,202,56,90,163,114,161,63,203,85,117,215,16,83,42,182,217,56,7,158,125,199,249,115,5,140,187,64,74,87,194,144,12,127,225,26,231,170,234,230,44,215,28,87,102,52,227,114,2,153,168,40,142,67,49,128,224,144,245,123,100,94,122,176,57,90,58,79,255,75,250,95,113,253,43,174,5,102,124,196,140,109,59,253,149,210,102,127,229,111,206,67,96,17,2,82,159,174,143,185,174,114,213,210,165,60,52,1,
225,81,162,3,230,1,129,182,157,193,247,145,205,193,247,178,80,149,190,15,177,216,113,44,246,37,237,39,180,179,76,240,132,9,90,118,238,148,168,22,238,148,254,58,74,207,83,122,154,129,88,1,226,79,62,197,170,166,222,179,49,217,37,107,174,176,150,138,140,192,88,225,214,117,80,71,65,61,227,163,62,98,68,210,168,94,102,153,8,250,61,226,88,135,196,58,40,171,136,109,21,18,74,111,163,229,45,197,220,239,204,66,135,89,143,124,115,212,89,16,234,87,220,200,196,52,187,12,72,11,84,24,137,237,60,34,105,97,157,91,7,65,29,0,85,149,164,150,168,122,124,90,168,205,152,1,194,45,96,99,198,230,80,111,1,37,21,240,226,85,23,54,86,183,144,222,218,36,214,248,146,30,136,175,98,157,89,32,178,17,174,180,179,180,23,187,55,71,23,81,235,2,76,44,16,187,114,83,88,233,196,206,224,218,200,230,224,218,9,5,229,19,88,103,136,185,205,230,195,218,25,156,58,176,51,92,108,217,28,156,34,67,14,23,67,112,71,158,26,36,78,82,39,93,192,104,254,135,192,78,95,233,209,102,95,233,4,67,63,48,50,199,85,58,136,238,244,47,93,222,236,95,
58,67,187,151,118,199,206,96,25,153,148,223,236,244,23,98,155,253,172,99,16,227,24,52,190,241,134,235,43,218,73,174,238,33,216,120,6,23,68,159,149,240,230,224,202,81,191,125,144,226,242,33,181,229,214,126,32,139,64,62,230,58,204,85,217,75,14,189,37,76,83,139,53,131,122,13,212,54,58,158,64,170,109,15,21,3,50,22,152,231,122,15,20,234,203,10,75,175,108,105,237,89,3,57,184,214,142,44,20,19,31,33,126,81,200,209,111,34,142,194,171,216,236,243,38,165,192,30,172,84,75,154,84,169,155,73,215,224,119,13,126,203,240,95,102,210,202,51,74,224,45,249,54,86,106,194,167,38,21,191,99,92,183,142,113,35,154,136,98,35,189,57,184,113,0,82,79,13,19,94,104,103,210,97,178,35,182,13,160,13,224,85,174,50,201,173,213,157,254,114,223,102,127,89,245,241,67,58,74,92,101,230,161,157,254,149,43,155,253,44,220,91,31,66,119,238,211,191,132,199,117,226,113,183,104,43,202,72,248,143,185,46,114,173,118,115,243,91,243,206,24,22,57,70,72,27,171,112,173,112,45,116,111,142,21,66,59,99,235,201,205,177,245,240,206,216,
90,108,147,127,59,99,171,244,175,118,239,140,45,223,220,28,91,238,219,121,168,114,236,33,83,143,224,195,35,84,143,35,212,155,35,132,169,33,135,253,65,129,205,101,225,37,249,124,144,126,183,155,129,131,96,228,65,216,26,96,202,1,166,188,196,245,174,185,62,132,194,67,188,122,4,253,142,144,9,33,125,149,142,147,66,77,209,115,20,154,223,65,139,154,104,132,132,174,29,238,24,187,129,49,104,142,148,163,155,35,229,46,218,152,240,24,69,244,67,74,248,135,102,214,113,0,229,255,218,90,189,20,169,60,29,29,0,76,136,139,113,80,122,193,96,193,101,22,94,190,178,243,176,50,181,249,176,162,41,60,46,134,43,63,176,163,66,157,171,108,215,70,86,97,34,119,123,115,40,183,189,31,136,71,144,58,14,133,30,40,32,170,202,61,35,186,135,104,237,33,94,63,226,44,51,174,61,176,106,131,101,205,125,149,142,11,204,253,68,115,207,67,147,117,173,34,187,92,102,115,36,71,26,165,218,24,222,192,1,87,200,10,43,161,157,161,13,246,138,67,27,71,119,238,151,111,111,222,47,95,218,233,127,79,126,237,127,95,67,156,249,123,155,35,
249,43,144,24,128,4,229,192,218,173,205,225,53,14,43,86,33,177,202,198,103,163,0,230,35,48,83,30,102,225,25,110,55,238,79,25,221,25,89,76,108,142,44,218,59,35,107,172,106,141,107,9,22,74,196,157,98,12,79,103,203,177,209,13,62,172,108,208,222,48,251,166,147,200,190,141,157,229,53,118,150,61,236,35,171,119,216,72,86,3,220,69,184,177,185,50,21,146,28,170,128,90,137,129,26,1,181,139,245,115,37,102,240,143,43,187,119,210,199,8,65,79,213,203,80,229,4,125,189,192,191,218,25,90,219,186,181,57,180,230,6,209,115,132,185,52,41,148,160,40,136,97,44,101,132,234,203,108,47,25,31,97,124,196,92,217,110,126,105,187,41,132,215,192,224,13,4,168,169,171,242,99,55,207,221,53,110,56,40,48,202,192,166,216,228,140,96,231,15,43,17,212,29,227,154,224,26,221,121,88,166,93,238,166,29,162,205,85,199,32,15,177,229,17,231,18,100,251,184,110,189,227,230,153,111,56,231,119,198,54,82,155,99,44,115,172,20,217,28,43,201,6,251,49,135,171,120,76,39,30,19,247,225,48,143,13,12,109,131,25,181,173,122,232,124,3,37,78,
49,156,9,174,178,44,140,20,211,246,54,171,244,116,209,115,122,231,97,113,99,243,97,113,203,246,137,126,195,85,190,34,34,75,208,24,19,110,19,144,226,115,156,14,67,236,154,71,44,247,12,51,101,175,233,29,112,28,4,117,146,85,55,130,206,108,172,24,95,185,68,67,230,152,3,85,30,218,15,102,39,34,122,129,168,0,118,170,39,12,169,135,101,124,165,188,245,2,20,121,44,75,38,236,140,137,61,227,68,154,130,244,101,220,44,135,169,231,56,8,88,213,1,211,234,193,157,33,204,115,104,85,206,82,25,102,214,179,191,199,17,76,126,12,147,127,184,6,223,107,144,40,146,60,71,138,40,232,61,185,252,189,89,72,15,52,143,1,241,10,8,118,252,35,248,215,8,103,108,35,228,221,145,117,76,21,129,14,111,92,218,25,206,115,246,150,199,228,43,57,236,8,147,55,118,136,179,20,183,206,110,242,191,1,248,3,67,150,87,249,30,10,68,247,50,152,101,40,148,199,184,158,193,242,152,124,8,239,185,159,235,219,188,159,35,142,174,177,135,233,95,251,155,153,47,135,134,206,189,255,28,248,114,178,248,116,85,39,139,239,102,242,175,115,185,183,139,
191,6,254,227,249,192,63,29,154,12,252,83,48,241,235,225,127,122,254,230,67,169,30,118,2,245,132,227,126,229,134,157,131,110,194,217,158,169,247,208,19,115,226,110,143,211,232,198,156,72,189,167,66,123,225,134,27,91,104,114,123,42,145,122,90,227,27,25,55,182,17,116,211,206,153,122,207,58,237,153,235,110,207,122,147,27,155,73,120,248,107,17,55,182,22,128,134,229,181,231,34,220,55,184,177,185,46,112,3,208,232,2,55,0,141,176,135,63,127,5,252,35,110,108,222,199,207,129,159,243,241,129,143,205,128,191,1,254,12,248,235,13,224,135,61,252,117,232,107,254,185,171,224,7,161,159,168,199,86,27,152,243,50,243,53,187,177,213,155,224,6,128,249,157,63,143,127,232,111,52,66,35,86,239,201,54,0,3,126,22,124,195,63,237,213,48,248,135,192,143,212,99,111,192,95,189,225,246,172,194,239,155,46,111,253,102,125,77,224,135,153,155,241,60,244,243,154,31,122,146,207,106,8,220,70,179,254,216,44,252,84,194,46,87,228,231,227,175,50,63,227,105,39,94,143,189,19,127,226,31,250,239,50,127,224,159,245,174,218,30,
253,13,214,179,113,24,250,201,122,90,235,93,187,230,166,215,25,95,75,249,243,127,203,252,200,127,206,246,231,191,198,220,180,87,161,175,249,55,174,49,255,33,104,88,245,88,30,249,175,95,113,99,240,155,94,215,56,243,87,152,191,194,252,179,153,122,231,26,244,43,240,87,105,114,59,215,88,31,242,239,204,117,186,157,185,125,200,44,137,181,208,118,174,96,44,65,183,83,252,3,223,89,185,14,47,13,110,103,37,141,237,104,252,18,99,200,159,241,78,233,111,227,38,184,1,183,115,35,225,225,67,191,147,249,18,14,250,170,52,0,115,133,49,232,87,88,175,230,51,248,200,19,126,13,254,250,101,55,182,222,252,59,62,240,102,254,13,230,215,124,107,223,50,23,252,32,143,78,236,35,230,92,165,13,63,235,106,107,126,236,87,243,175,119,121,243,35,143,4,242,233,20,254,6,243,175,35,31,236,185,115,61,198,122,100,63,167,144,223,73,214,196,56,242,234,129,94,15,244,99,121,248,133,94,218,137,124,177,63,163,255,53,198,215,36,255,46,79,254,185,11,30,124,174,199,215,31,246,193,252,210,79,90,254,100,244,31,112,211,21,244,49,
9,253,28,250,205,65,127,18,251,158,219,179,95,218,115,204,63,45,251,184,136,125,180,184,177,233,132,103,127,171,81,116,11,62,242,237,153,135,222,20,235,157,194,95,230,177,159,37,241,171,249,225,103,9,125,188,147,254,241,47,205,47,251,98,60,93,1,127,233,0,243,99,223,162,191,112,206,237,89,104,131,126,23,17,161,161,158,192,94,19,232,63,140,125,135,209,111,34,127,195,77,96,95,225,181,136,137,24,93,172,191,11,255,13,227,223,97,228,147,216,184,238,38,160,31,206,219,245,48,250,75,160,191,132,115,216,13,111,64,15,121,37,178,151,221,4,254,21,70,254,97,214,223,229,116,130,191,207,13,179,126,67,31,127,77,160,175,240,218,109,108,9,253,85,208,55,246,209,89,185,229,217,227,58,250,195,63,58,215,186,140,61,36,246,236,15,253,117,50,127,108,77,246,199,56,243,119,162,207,152,3,60,252,73,191,70,255,232,39,182,214,136,126,53,46,126,99,140,237,135,231,176,55,190,202,124,171,135,25,79,34,43,240,243,223,32,47,228,151,71,126,242,143,245,155,158,127,206,162,127,249,15,242,67,143,140,35,127,217,151,137,
127,232,107,198,247,255,28,242,86,188,203,221,130,30,227,115,208,159,59,2,77,95,127,140,199,208,183,241,127,209,95,197,126,136,7,177,89,228,39,249,111,184,23,97,14,129,57,219,79,60,139,90,31,244,52,186,222,234,69,172,5,34,84,22,14,23,162,158,69,44,225,177,75,178,8,34,162,44,98,146,136,48,79,4,155,188,85,143,209,238,65,98,38,162,207,167,235,61,242,240,105,44,82,22,187,103,81,38,226,138,163,206,122,207,34,227,111,47,186,177,183,65,183,103,177,219,207,0,68,148,10,244,22,144,128,44,54,79,68,155,36,194,229,137,104,90,97,14,139,34,98,167,145,120,207,2,237,215,72,252,53,22,185,144,241,240,231,66,72,192,139,128,61,57,198,39,207,98,241,68,124,248,35,146,213,99,217,43,94,68,203,18,193,196,223,59,52,32,254,222,221,246,214,191,8,189,69,101,4,248,207,50,62,197,252,178,248,108,183,231,81,11,221,38,67,165,43,23,61,254,199,177,136,241,227,240,127,221,227,103,10,254,166,136,128,11,33,188,77,248,183,104,147,209,114,23,234,105,60,34,54,9,254,100,179,155,94,250,6,222,89,223,28,26,159,35,226,190,
238,68,187,120,16,235,237,201,211,158,9,129,203,184,34,202,212,1,52,122,179,158,150,5,46,38,220,116,30,249,44,94,243,228,147,35,99,228,36,255,168,39,255,117,240,21,225,231,241,120,121,248,70,151,231,145,115,120,32,244,211,178,216,153,175,145,255,121,111,253,19,231,220,216,68,7,50,184,80,239,20,127,235,232,87,30,176,68,68,84,4,201,119,154,8,222,89,137,122,22,157,143,226,161,158,197,43,66,117,174,93,198,91,136,192,235,9,51,30,91,191,196,61,22,142,71,26,143,201,95,197,91,88,79,30,122,68,208,4,30,77,100,39,106,211,94,213,124,200,123,253,144,219,185,154,244,219,194,63,66,27,253,43,226,147,17,129,195,171,252,136,10,127,120,26,52,88,159,230,199,163,58,87,241,8,60,222,68,100,50,140,241,232,245,180,239,209,215,225,15,253,194,95,130,245,116,154,140,16,36,234,32,111,209,199,227,59,85,81,16,113,208,59,94,134,190,23,177,31,50,190,201,232,70,31,204,63,131,254,101,47,75,232,79,246,191,6,190,34,154,241,40,228,63,45,143,102,156,10,36,54,135,189,202,62,5,63,141,62,136,8,138,120,6,127,174,139,113,
225,147,241,76,196,149,190,144,207,244,13,79,255,170,8,180,222,25,63,98,47,64,111,18,126,22,246,240,177,47,131,191,71,31,255,153,198,127,214,186,153,27,126,42,242,31,240,231,136,40,178,167,181,40,99,162,135,60,241,207,180,3,254,252,97,244,223,225,193,255,33,163,120,53,154,69,48,104,64,190,33,34,40,17,98,141,136,12,126,152,138,130,72,76,212,136,48,30,36,170,118,18,173,105,99,159,68,98,108,2,253,176,94,141,39,88,111,152,140,97,34,12,25,40,193,122,194,14,248,200,63,92,185,2,45,240,43,140,43,98,19,81,195,200,63,177,134,253,200,222,136,232,49,7,253,51,110,34,172,244,173,140,45,251,18,252,6,246,199,124,157,170,40,164,207,85,252,175,66,196,93,37,3,43,162,110,92,32,195,30,243,34,178,244,145,39,34,82,129,116,42,195,227,255,9,50,176,244,157,0,223,84,32,204,111,236,131,249,99,121,228,101,42,58,228,149,39,158,225,255,94,70,70,127,196,11,83,209,173,163,63,236,207,84,100,138,119,38,99,162,191,121,50,48,235,255,18,255,214,144,63,254,239,225,67,47,167,138,235,15,25,125,85,254,201,184,145,191,
50,48,25,10,249,246,56,63,18,123,142,33,175,218,25,83,178,244,152,18,25,2,21,12,100,28,0,5,100,74,228,216,56,14,175,20,225,164,96,70,14,118,161,222,67,137,23,155,96,193,19,4,156,119,126,64,205,82,210,86,72,17,89,74,94,74,214,216,20,6,178,10,254,20,11,134,65,175,196,160,157,35,96,45,48,254,150,20,177,128,65,191,77,34,0,9,132,0,175,18,37,139,193,155,128,236,27,36,10,55,41,126,131,246,210,33,2,50,14,164,113,2,104,207,98,43,70,75,219,148,132,240,75,9,28,155,221,51,88,74,180,105,2,170,4,142,195,125,73,113,139,40,212,224,147,48,8,192,177,73,74,180,69,230,39,69,247,96,48,49,198,77,10,156,133,190,74,112,82,164,41,81,247,18,146,74,116,5,108,5,116,37,44,149,32,194,55,10,101,254,69,20,242,18,254,84,194,147,32,98,47,73,8,50,184,69,248,103,62,83,34,189,1,126,137,4,134,131,199,222,252,17,223,155,63,246,22,252,189,20,250,214,55,136,60,248,4,68,147,16,21,64,37,63,228,97,228,39,5,83,2,155,128,60,135,65,189,133,254,234,37,228,143,190,36,95,173,31,135,137,45,122,37,190,151,144,8,96,239,36,31,74,
100,12,194,11,168,42,129,101,192,180,87,113,248,213,147,24,113,200,115,8,28,42,65,194,84,201,105,2,174,9,168,56,132,74,20,193,75,63,200,95,14,99,12,62,139,195,100,113,160,53,198,49,216,4,91,136,78,28,54,33,131,196,30,58,23,8,216,11,158,193,122,14,130,67,18,224,59,41,81,59,149,176,103,177,175,89,232,45,194,31,246,151,96,61,137,85,198,41,81,204,124,57,232,231,40,121,247,18,130,182,4,114,216,13,63,32,155,18,138,146,25,7,241,230,199,161,9,16,162,47,7,81,64,142,173,30,4,31,251,86,2,51,91,22,244,169,18,85,14,7,190,9,104,243,200,95,1,54,11,125,214,147,134,94,143,18,228,91,244,175,45,202,91,244,247,5,159,245,40,32,42,161,26,253,209,158,98,92,1,113,141,130,64,1,114,158,18,74,235,123,35,251,61,128,254,123,60,127,153,166,36,86,201,52,205,184,236,107,28,253,140,171,32,16,125,240,89,31,133,137,161,111,18,254,27,18,200,27,198,115,248,159,73,248,237,216,114,51,54,129,125,170,253,138,241,87,36,136,37,2,186,244,99,18,6,252,43,225,200,94,150,240,183,37,173,87,37,26,242,117,186,77,194,12,43,224,
146,48,194,185,184,27,206,29,118,19,211,215,235,93,4,184,48,1,29,56,183,139,132,99,2,48,242,75,172,169,4,86,0,87,192,196,62,84,225,41,224,42,160,99,175,9,2,98,184,18,242,240,73,136,192,129,79,0,130,94,194,148,200,140,43,129,155,18,23,126,77,137,235,219,223,94,65,128,126,140,254,246,18,250,26,252,195,111,167,244,171,45,143,2,186,214,7,125,19,160,101,127,106,175,97,191,107,190,253,162,239,4,252,119,174,30,96,141,36,68,74,82,19,208,133,175,2,192,4,100,96,166,190,114,19,83,231,137,67,200,25,59,51,114,98,171,109,10,61,18,253,255,111,171,35,59,97,171,208,179,113,200,43,132,76,28,67,175,194,207,98,7,232,161,199,1,31,57,247,176,53,52,129,125,49,132,31,170,48,245,19,179,217,106,3,63,237,149,202,61,206,246,43,128,79,35,108,183,201,15,245,33,58,152,97,45,138,165,176,178,121,60,131,212,218,67,41,99,40,230,72,21,42,85,69,81,145,99,94,165,178,44,147,210,243,75,169,128,165,104,179,172,113,82,149,103,185,148,26,146,212,2,158,183,160,205,51,227,19,140,231,88,1,244,98,19,158,229,245,56,68,114,
173,72,150,173,195,131,5,232,47,28,52,145,203,224,47,146,234,21,217,144,188,177,92,69,166,44,150,204,252,70,130,127,196,23,125,54,79,102,28,250,134,127,74,61,47,178,33,241,47,244,225,255,141,54,255,100,10,214,219,163,204,195,97,138,137,220,57,230,199,243,21,185,189,249,253,82,123,145,249,84,234,26,250,200,235,181,54,171,123,145,153,200,42,207,54,135,19,104,76,165,216,59,218,75,42,85,241,236,37,29,94,224,137,242,156,9,248,87,100,157,160,212,82,100,92,100,220,47,213,77,41,181,23,25,208,152,39,127,44,207,200,31,249,105,254,37,248,133,94,236,53,91,5,225,47,176,57,90,192,19,85,234,43,51,190,131,158,34,175,14,67,216,44,165,137,140,105,149,98,179,204,167,200,48,142,5,46,178,222,113,69,102,224,217,172,74,62,58,156,48,145,113,81,165,35,145,122,49,98,74,225,4,150,111,34,179,50,35,250,236,196,162,98,172,175,211,223,220,155,195,0,181,141,103,64,207,63,140,50,145,92,145,217,247,92,19,25,105,119,46,128,79,41,219,201,214,200,148,206,27,237,68,214,19,120,10,246,165,113,69,222,53,50,65,206,43,
173,19,249,11,120,122,43,227,200,83,227,218,218,8,127,209,59,28,235,204,177,94,54,159,157,57,198,137,156,157,68,70,83,42,225,121,198,179,215,67,148,73,148,242,148,198,198,115,41,197,117,152,164,200,30,99,235,213,147,71,30,249,175,188,173,154,201,116,190,254,56,28,51,145,121,17,249,202,254,214,246,34,43,242,151,252,222,144,249,116,88,150,199,127,242,100,98,14,219,140,124,167,161,175,202,0,254,12,190,214,43,251,151,127,73,255,83,210,31,246,49,69,100,205,33,47,182,122,102,235,51,119,195,179,239,119,204,111,50,191,63,255,60,135,127,200,35,54,127,197,179,175,44,145,60,203,225,195,59,109,149,148,233,3,245,238,215,199,221,238,215,173,208,165,127,222,223,130,169,98,18,157,25,244,166,12,81,193,14,84,129,204,35,103,109,162,23,217,114,45,66,119,54,234,149,184,84,32,9,248,82,132,14,43,162,177,37,75,176,233,14,175,18,97,145,59,135,17,68,99,34,44,37,127,130,12,27,166,100,77,224,39,97,228,108,34,174,201,160,109,68,92,14,65,176,195,4,122,217,27,239,194,110,194,28,194,113,120,225,118,17,233,76,
201,141,29,113,24,130,110,189,67,134,24,91,110,47,66,115,136,161,12,152,69,143,28,130,200,206,204,33,26,91,0,244,73,132,149,95,161,231,37,198,225,183,147,12,228,85,12,148,216,210,131,50,182,252,192,248,21,227,178,3,173,135,10,194,148,220,170,16,20,225,177,19,179,37,115,240,35,14,177,98,75,28,234,104,139,181,68,133,243,197,143,241,155,119,248,161,226,98,30,59,83,133,180,42,63,163,61,71,156,80,5,74,134,139,81,113,126,41,145,23,136,99,178,35,19,185,21,215,124,63,54,21,30,118,128,124,77,28,154,39,195,207,163,15,226,144,201,144,196,138,158,245,237,55,166,204,74,44,181,40,66,31,53,199,109,61,188,184,97,76,188,199,249,31,247,215,45,167,154,114,45,103,176,126,211,201,184,55,57,145,141,58,47,220,168,243,164,30,113,170,121,55,226,188,168,199,157,97,55,206,64,194,121,133,180,126,0,99,171,9,140,151,96,116,129,145,2,227,175,192,120,14,198,246,9,48,170,35,34,122,5,144,41,64,6,0,137,3,242,203,30,209,123,128,184,65,168,102,160,154,130,234,15,80,125,11,74,237,4,40,139,80,105,168,167,156,231,110,
138,253,84,196,169,101,233,8,48,154,96,48,64,199,141,122,132,124,111,205,220,112,35,211,176,129,53,70,138,129,122,50,151,113,35,197,54,55,153,251,170,30,193,58,173,233,171,174,53,221,236,70,230,99,102,92,248,145,98,16,26,151,235,17,188,212,226,72,61,194,126,193,90,136,212,147,180,35,165,144,27,41,181,187,201,133,175,235,22,210,142,172,92,114,35,43,192,115,228,107,230,47,69,92,171,164,249,19,245,8,94,102,45,67,127,153,54,27,152,36,214,27,41,117,131,175,249,79,213,45,234,161,200,202,101,240,27,92,43,123,187,30,41,48,95,249,146,107,149,15,187,145,66,87,61,194,184,181,76,123,121,159,27,161,94,50,248,229,152,27,41,127,11,126,171,199,111,25,250,101,232,23,51,72,42,80,79,149,207,186,41,240,145,90,61,14,126,138,122,51,53,27,116,227,217,174,186,93,14,212,227,197,152,27,47,6,92,187,124,179,158,34,170,199,87,174,187,241,149,128,155,122,109,51,134,64,139,55,25,111,116,83,197,27,140,129,191,12,254,50,248,43,93,134,190,205,250,237,82,51,244,59,235,41,228,23,231,145,64,106,190,193,141,115,164,
153,18,125,172,53,85,110,114,227,212,25,41,228,29,39,43,199,241,142,84,241,118,221,46,209,46,116,184,241,66,51,52,194,245,20,222,246,101,60,127,27,101,54,152,118,138,250,37,206,129,71,124,153,249,11,87,221,84,33,224,198,151,51,62,254,89,240,207,26,124,111,188,161,110,191,56,225,218,47,218,128,131,207,101,244,72,221,99,149,144,139,244,192,209,160,145,43,7,41,22,94,20,41,100,140,158,146,28,132,69,156,86,228,120,17,29,32,231,210,101,224,49,36,214,25,65,14,150,115,17,27,192,46,138,113,15,159,163,95,43,183,31,124,27,29,98,71,68,133,72,105,191,155,92,195,206,88,167,133,30,45,236,32,82,20,190,232,93,135,222,17,218,140,75,175,43,87,193,109,4,198,199,199,43,35,165,67,110,114,9,187,212,252,236,43,176,7,230,103,28,57,90,178,179,50,118,133,156,12,126,14,126,136,138,145,66,183,103,7,78,59,252,159,128,127,198,5,143,156,45,228,28,41,223,246,236,0,25,165,144,115,156,236,28,103,254,20,217,45,69,54,143,195,191,209,67,241,26,122,14,34,71,236,0,187,140,23,145,107,241,48,48,189,245,56,235,75,149,
208,43,242,139,151,110,213,227,140,167,136,154,241,220,65,55,197,190,85,227,118,169,19,220,3,140,199,61,59,219,163,207,70,63,142,94,83,37,236,64,248,200,223,216,81,33,12,63,251,177,163,68,221,150,93,20,152,31,189,218,197,180,111,55,223,98,55,232,47,159,242,240,57,26,247,236,0,124,205,95,196,14,225,55,158,99,126,240,109,124,48,94,108,53,252,171,157,42,99,7,207,176,131,103,71,188,117,148,83,245,16,122,140,59,231,220,144,240,144,67,8,255,136,99,23,240,239,134,240,143,16,235,176,56,48,177,8,32,161,146,85,15,33,167,120,145,117,226,31,33,228,36,127,10,81,69,129,231,201,17,248,80,249,178,27,42,179,142,146,13,174,218,87,104,7,160,129,156,224,35,68,21,23,47,54,185,161,156,205,252,208,43,179,78,198,67,69,214,37,124,236,159,121,60,124,244,22,34,126,132,20,63,202,216,187,240,243,62,62,217,41,36,189,192,95,92,252,81,149,132,140,191,192,31,118,28,210,184,244,14,253,80,185,21,252,78,111,125,206,55,192,51,63,235,243,252,239,130,129,79,21,251,208,9,244,176,195,248,10,254,13,255,54,118,231,249,
35,118,176,114,195,179,3,14,236,68,63,197,254,203,224,23,34,232,73,241,0,127,214,252,84,209,232,3,59,192,31,181,62,99,71,45,232,209,247,103,252,36,158,195,223,229,207,146,39,122,54,126,89,184,233,217,97,1,61,23,218,160,25,171,219,90,95,129,245,41,30,80,69,25,250,197,118,112,137,95,200,203,240,91,188,194,253,62,248,69,126,178,227,34,241,0,253,196,241,99,27,157,199,139,103,24,63,79,60,235,244,236,86,118,240,99,131,107,255,232,219,83,169,219,243,231,50,254,133,222,34,69,203,139,211,69,252,169,136,127,115,176,166,184,157,100,223,22,113,90,220,164,19,245,253,239,91,47,126,148,239,249,109,236,68,241,1,61,89,240,17,193,78,240,115,215,194,78,146,224,71,208,83,196,57,15,62,241,132,113,203,204,167,120,131,63,35,39,11,127,48,241,8,123,87,252,176,176,155,72,105,31,60,129,207,62,51,82,186,64,251,172,155,172,92,247,248,43,125,11,61,249,127,202,107,35,39,171,128,127,99,103,17,214,104,21,190,241,226,131,230,167,74,138,224,47,17,108,53,185,118,206,155,191,112,14,120,197,11,229,5,226,122,233,34,
50,196,110,201,164,169,130,228,166,184,218,136,236,210,158,28,169,130,100,103,118,25,61,200,78,10,232,145,249,82,37,244,40,57,99,247,113,252,51,165,113,163,119,236,0,249,145,47,124,124,217,41,122,212,184,244,94,60,231,141,195,159,137,235,78,15,227,216,141,83,27,134,89,247,46,220,142,83,15,185,57,138,175,40,174,228,146,55,157,19,12,85,24,169,53,194,116,5,4,247,34,210,173,30,67,172,109,144,113,83,138,9,240,50,14,47,181,118,209,97,133,188,35,10,161,42,7,151,78,163,8,221,165,255,32,196,220,22,198,182,231,161,4,184,186,161,20,128,82,187,40,221,165,27,171,114,230,24,170,181,225,58,238,44,62,211,77,253,81,61,72,1,114,150,97,183,139,177,102,134,30,50,82,83,250,99,54,254,247,53,132,220,57,8,225,33,188,232,12,145,211,26,147,108,183,55,196,19,86,198,59,144,226,137,42,141,65,88,81,81,210,162,49,101,157,237,199,130,39,199,57,238,105,49,69,53,192,96,170,228,246,209,127,4,145,87,151,24,219,58,192,212,8,158,39,14,113,182,137,33,78,156,67,148,207,113,202,240,120,150,246,108,79,61,68,130,180,156,
24,180,247,187,161,229,176,9,196,161,89,2,222,44,129,95,129,24,252,208,74,8,252,6,130,12,1,134,130,32,68,160,38,176,152,113,19,192,10,81,19,144,44,138,47,57,88,104,158,241,121,57,24,248,24,74,72,9,188,64,64,33,33,135,40,128,188,0,66,0,226,137,145,193,103,27,66,96,130,135,164,73,216,161,185,139,110,104,14,97,144,176,77,0,197,240,77,64,42,197,234,113,202,213,16,219,216,16,219,131,248,66,183,9,184,22,134,23,42,16,192,216,230,155,0,141,97,134,84,0,144,72,83,56,86,156,130,76,248,41,231,106,61,197,1,84,124,150,0,69,65,147,154,138,212,109,141,151,163,24,67,147,107,171,32,97,155,29,135,62,235,116,83,111,122,61,252,34,235,151,161,238,21,44,139,200,111,145,246,124,151,159,8,49,124,147,8,49,220,103,224,47,98,184,108,67,83,207,252,0,186,66,0,84,192,84,0,68,126,10,128,41,182,7,241,28,137,76,243,23,25,39,224,219,240,159,250,133,54,199,20,169,95,84,16,161,77,2,116,138,3,26,147,200,8,80,41,10,210,248,60,142,131,124,83,211,4,48,179,62,223,241,124,249,167,86,190,113,83,204,23,47,16,120,144,191,
69,64,183,208,127,164,64,32,80,96,249,67,33,147,84,1,202,1,82,132,19,239,228,220,21,130,10,109,10,182,200,50,133,70,153,66,167,4,62,137,211,34,80,69,72,228,17,2,184,133,124,77,155,0,238,21,164,42,100,154,40,36,58,25,3,63,71,96,97,123,101,81,80,90,36,136,8,5,29,120,20,46,204,191,2,189,189,192,70,161,146,68,30,145,66,8,222,40,68,178,23,189,192,136,252,34,200,207,82,161,165,4,85,82,224,36,208,18,24,76,193,189,0,63,11,184,8,7,144,26,79,174,19,184,202,167,221,228,122,167,87,8,81,136,88,20,34,145,21,10,17,35,63,10,17,236,55,78,160,52,133,74,158,54,9,38,14,255,166,16,41,163,223,18,1,191,140,189,112,204,16,103,219,27,231,0,54,197,177,137,41,68,176,47,237,16,84,144,210,143,14,165,63,236,27,251,53,9,140,66,71,5,129,93,188,229,209,135,63,131,175,66,72,5,116,129,66,68,9,59,139,62,85,216,32,255,84,30,253,144,128,109,147,144,209,63,242,177,241,15,195,223,28,243,243,4,43,149,35,97,169,160,230,1,64,138,192,24,47,38,234,41,37,220,92,135,151,64,87,8,188,20,170,42,152,227,28,40,218,249,168,55,78,
33,153,98,67,16,103,253,33,228,29,231,157,6,5,206,16,240,33,173,175,220,142,44,154,221,208,98,18,217,170,128,160,0,88,65,95,42,196,212,102,253,248,169,41,48,76,65,99,10,8,226,67,129,66,10,123,11,21,24,215,122,28,10,24,228,27,98,253,20,66,216,139,95,192,44,159,33,150,136,95,10,36,37,10,14,250,204,252,5,47,222,124,105,47,131,143,189,132,74,196,15,225,227,31,166,128,89,4,31,255,18,190,153,143,13,141,41,152,84,128,105,253,242,111,217,119,145,2,6,126,149,24,67,20,194,86,41,225,21,56,108,96,226,229,35,196,20,79,191,41,146,98,74,27,142,18,133,162,10,6,227,223,251,145,47,242,135,255,47,27,138,50,254,39,249,228,40,160,114,248,55,79,196,189,13,9,246,129,190,82,36,110,51,190,66,252,64,190,41,228,103,244,79,1,22,95,57,140,254,177,31,249,119,22,124,142,249,82,217,187,94,65,178,76,1,35,125,47,247,176,25,98,220,216,7,227,218,144,8,126,229,138,107,43,30,172,16,31,76,129,132,253,152,2,137,248,99,218,232,203,20,206,200,95,246,148,61,7,109,214,67,124,54,246,131,254,226,232,207,222,179,207,101,252,
159,13,99,124,97,192,196,215,72,241,2,254,79,154,43,246,120,27,82,54,68,20,32,108,74,253,141,204,180,82,10,27,137,233,16,177,1,127,52,27,74,252,31,249,89,36,238,136,252,157,248,168,141,140,133,252,34,139,20,46,28,43,89,200,47,201,113,70,132,194,34,82,160,112,89,194,127,53,190,23,63,216,176,26,124,10,1,139,196,31,41,128,47,250,248,15,27,83,67,63,201,113,68,4,253,155,248,177,74,252,64,62,17,244,31,65,255,22,242,177,176,255,8,27,212,8,243,203,62,204,70,7,253,68,100,175,154,31,125,69,240,207,136,67,10,92,196,255,85,40,229,41,92,242,196,11,236,67,246,156,34,54,164,176,135,120,137,120,172,252,199,3,168,56,79,112,83,188,3,101,171,208,224,64,222,248,95,1,253,114,44,22,231,152,46,53,179,143,24,142,189,72,254,139,200,127,145,84,47,123,34,94,166,222,161,127,30,96,165,222,161,127,217,227,50,248,196,75,27,253,197,225,199,243,111,228,207,3,26,83,112,230,183,178,32,211,81,168,182,26,143,179,115,33,172,21,141,229,34,117,107,156,114,115,252,162,107,143,31,118,173,241,30,111,188,96,123,227,133,
243,117,107,146,241,183,28,113,76,2,207,35,43,139,35,1,123,249,6,171,167,189,140,196,120,100,103,191,161,52,157,60,232,218,188,181,102,235,72,98,25,120,182,220,246,188,39,113,59,183,196,92,72,44,255,192,104,192,94,14,131,43,13,119,121,237,124,55,247,108,133,242,103,234,22,18,178,121,103,196,154,61,224,218,60,83,151,198,108,34,140,197,35,29,89,152,142,44,236,183,140,207,137,159,132,137,240,102,61,108,65,108,182,146,22,25,212,126,117,213,181,95,161,97,30,225,73,194,22,21,130,69,134,182,11,237,224,146,1,120,139,198,154,33,226,113,16,174,8,96,231,187,208,238,49,232,179,94,14,176,236,87,140,191,131,254,43,232,155,249,193,103,107,106,231,99,28,183,48,62,69,105,61,77,123,170,207,88,156,77,133,98,19,17,44,182,56,182,142,92,178,200,39,123,200,181,23,110,212,45,52,98,243,12,159,126,215,90,164,244,70,62,54,7,88,22,7,88,54,25,68,22,107,163,65,139,119,56,184,114,92,67,123,154,113,14,166,237,233,123,140,65,15,15,181,86,52,142,124,145,143,197,65,191,197,145,142,205,91,60,202,112,54,30,104,201,
3,177,0,27,254,173,185,118,228,3,60,7,112,202,208,86,137,245,41,67,240,76,223,230,224,221,226,157,4,139,35,37,123,46,90,207,224,209,22,22,40,249,103,178,151,189,245,83,1,89,239,224,111,174,27,217,161,111,135,245,225,161,86,129,245,72,63,120,16,145,3,29,201,67,2,245,76,142,234,144,35,151,12,242,183,57,146,177,102,192,159,1,255,181,143,143,7,217,101,182,10,108,253,141,252,120,75,201,198,3,172,233,222,122,6,15,36,114,26,123,203,172,94,197,22,105,27,254,89,255,248,29,147,145,109,50,134,77,198,176,240,16,35,31,34,168,153,127,1,124,34,128,181,140,61,99,111,153,37,244,47,251,152,193,3,231,152,127,6,254,248,84,132,240,115,156,83,198,234,69,86,162,227,126,42,87,155,218,151,170,22,59,231,64,238,15,67,47,24,153,192,165,33,90,62,239,133,13,194,126,4,183,180,230,219,221,200,76,3,138,187,235,165,125,132,18,41,83,54,104,191,36,165,251,139,142,44,16,230,20,6,138,40,81,251,179,34,231,106,26,95,36,12,17,182,34,48,237,157,191,112,14,86,162,236,89,107,247,202,138,101,132,182,204,254,104,254,14,248,
40,137,180,101,206,1,9,155,50,154,8,97,35,34,161,113,78,165,50,40,185,193,57,31,97,61,201,169,177,140,44,50,79,153,194,139,43,145,121,232,99,20,86,81,231,122,40,173,200,254,17,35,179,246,232,231,238,212,147,162,231,116,16,182,46,184,201,249,51,30,60,97,211,194,41,35,43,18,154,251,130,201,251,37,25,158,103,177,3,176,203,110,27,58,96,159,83,166,218,183,202,71,247,132,182,79,242,196,212,180,243,32,216,37,121,97,53,201,211,199,104,169,179,30,37,52,36,39,47,187,209,73,130,251,100,79,61,138,41,39,215,82,140,31,118,163,203,23,234,81,158,121,37,159,126,227,38,159,54,185,81,158,214,42,24,71,179,29,110,148,226,58,201,11,181,73,92,57,202,211,220,228,155,63,140,23,83,110,180,8,189,213,246,122,18,83,137,78,183,187,209,233,195,110,114,60,85,79,98,218,81,138,255,40,167,121,73,76,55,137,41,70,231,206,184,81,76,33,249,186,215,163,191,146,112,163,156,22,38,87,111,212,147,175,24,127,119,217,77,190,58,228,70,223,129,143,148,162,20,199,81,138,179,36,197,79,146,208,24,125,7,253,119,180,49,69,195,31,
166,26,45,29,53,243,71,75,61,220,227,82,58,37,101,183,171,221,181,157,35,40,203,69,49,113,19,162,120,118,148,209,184,9,113,77,184,8,70,56,69,123,226,164,107,77,112,234,48,117,139,49,92,140,36,105,115,170,107,229,111,122,46,34,107,145,139,82,4,24,23,93,33,4,225,226,25,222,194,176,88,183,189,231,66,227,189,104,150,118,190,131,240,132,117,144,228,45,222,98,176,103,58,8,127,251,113,1,171,158,97,211,98,241,218,154,66,70,102,225,98,221,66,46,246,20,214,249,26,250,60,5,55,33,110,5,23,91,97,19,163,249,39,192,159,195,154,224,209,158,235,168,103,112,41,139,34,217,226,68,46,51,119,174,158,121,10,61,60,194,126,135,73,188,107,113,105,227,238,190,171,102,5,7,221,44,161,2,253,218,178,202,183,20,39,243,132,114,138,193,140,198,87,142,176,14,146,189,198,159,147,220,223,2,255,188,203,75,45,20,155,54,197,166,66,169,9,197,19,103,92,123,34,72,56,98,157,216,87,102,169,19,57,127,133,171,95,245,198,95,126,227,218,47,89,247,187,1,76,19,122,69,228,80,100,243,76,177,110,67,223,66,191,208,33,212,131,175,
80,197,179,29,171,8,207,89,240,37,183,61,57,46,247,146,42,88,87,145,83,65,248,183,56,245,212,233,182,61,119,10,25,180,16,206,51,200,17,122,156,94,171,24,201,44,92,71,198,180,231,207,33,99,248,195,43,85,108,216,101,82,105,153,84,64,49,106,232,83,108,153,208,15,253,140,188,176,132,94,240,250,76,174,195,27,39,21,216,60,19,86,177,97,66,53,94,105,179,89,180,28,244,96,82,7,244,23,208,139,236,64,243,113,234,98,230,71,175,94,106,32,106,40,244,47,167,204,105,148,78,223,109,78,89,117,26,167,83,30,155,211,44,211,230,52,222,172,255,45,243,179,217,203,188,229,212,67,235,161,56,178,121,219,199,162,56,86,49,105,240,25,183,202,74,245,224,175,176,30,157,238,19,53,140,29,152,205,208,121,236,224,162,7,79,42,208,169,175,173,205,22,250,137,240,204,49,146,231,241,70,9,249,49,127,164,192,211,7,78,113,176,31,14,10,104,147,42,146,206,1,54,104,172,95,227,47,143,185,145,151,148,30,133,7,94,20,34,34,113,208,64,20,226,148,139,40,103,113,186,111,78,165,73,189,230,148,139,23,90,77,177,165,205,158,240,225,207,
20,99,108,46,77,177,199,233,159,217,236,177,126,179,217,228,180,206,226,148,40,82,184,235,159,50,17,181,85,108,242,76,209,20,139,200,135,232,200,250,136,154,58,149,42,99,95,122,26,193,250,205,41,151,57,101,163,120,44,233,233,72,3,5,31,155,73,157,186,171,216,195,222,172,210,25,214,170,205,33,250,99,253,150,78,242,40,173,44,54,99,178,119,187,116,154,54,235,103,51,164,195,134,204,36,254,128,126,51,147,196,9,233,83,197,41,197,176,61,195,184,236,183,128,31,202,254,202,126,41,102,228,15,62,167,128,25,149,86,156,38,90,197,147,110,102,158,84,137,125,120,81,157,184,131,125,16,253,137,3,248,15,155,49,75,155,43,217,183,241,235,35,216,23,248,242,227,28,250,167,20,203,204,161,127,225,243,142,129,77,214,176,200,74,210,159,141,126,89,7,243,221,246,226,2,155,41,155,205,148,197,235,112,166,20,32,43,218,58,213,103,51,166,226,223,98,51,96,83,154,89,217,94,226,63,242,225,109,181,168,158,42,112,88,17,197,190,146,188,222,26,37,238,36,231,66,245,40,240,61,235,196,79,224,121,171,199,203,7,51,228,7,82,
119,146,103,192,81,214,159,92,141,17,91,3,110,148,167,59,81,252,47,201,102,48,185,208,64,78,224,217,33,167,132,81,14,11,162,232,175,135,103,210,73,74,177,232,202,183,196,115,178,240,116,180,158,36,174,70,201,114,228,25,55,57,117,219,204,151,228,89,99,146,248,31,229,84,62,201,252,81,178,118,20,249,39,243,55,192,133,62,175,15,39,95,55,66,131,98,158,56,25,197,127,225,131,57,193,71,30,73,74,161,36,155,225,104,137,245,161,191,228,82,59,27,13,248,113,104,139,223,217,51,110,146,195,156,104,121,47,126,32,63,78,29,165,127,79,190,232,151,210,207,94,196,255,37,111,252,155,83,66,55,179,120,217,211,191,201,202,141,70,255,158,253,180,131,11,124,233,142,239,159,196,3,214,111,97,223,158,254,53,222,134,254,241,47,149,126,89,226,7,249,210,82,214,198,127,109,54,67,148,188,192,240,180,74,241,140,210,9,191,160,79,165,18,109,243,116,239,40,241,243,154,95,170,95,52,89,223,166,106,176,176,111,155,167,70,182,57,124,196,254,144,151,173,248,32,122,121,63,126,113,88,161,205,148,41,245,100,79,84,13,148,148,
208,96,62,228,163,195,48,47,126,17,159,140,189,177,126,252,203,158,3,95,109,14,195,180,25,204,204,81,106,170,20,158,193,158,102,224,127,30,123,147,253,27,123,39,30,40,254,96,63,54,31,12,216,188,3,96,177,89,204,40,175,82,213,88,228,255,204,108,183,23,239,216,172,89,28,214,216,248,175,109,14,139,240,119,74,81,91,246,43,249,240,130,189,177,79,228,99,228,207,83,41,139,205,122,102,49,234,229,7,191,42,83,126,48,91,5,252,203,139,255,240,175,120,189,194,252,138,167,194,151,255,241,52,192,226,176,200,248,159,248,89,102,28,253,155,248,173,248,193,41,181,173,205,34,241,194,203,31,60,233,227,245,110,249,135,167,63,242,71,177,1,124,230,23,189,25,242,176,182,34,243,3,200,79,250,66,158,146,63,235,55,241,89,249,5,255,177,208,143,225,223,108,101,14,195,127,135,55,62,195,250,85,106,203,127,169,26,61,253,1,79,213,233,213,5,208,51,117,1,248,42,245,121,26,98,21,208,127,22,253,171,74,84,254,89,57,10,125,244,141,126,190,248,255,28,242,51,117,197,31,240,165,191,5,226,243,2,235,231,157,11,139,183,170,
108,226,157,133,253,41,254,155,170,147,248,101,226,237,138,255,52,56,175,205,57,252,228,169,138,229,79,138,223,37,61,181,164,106,101,171,18,201,177,217,230,109,54,235,29,85,175,226,167,121,90,204,102,95,242,67,254,145,63,196,103,115,216,199,83,188,100,142,42,23,122,102,156,248,100,229,136,239,203,131,102,253,145,252,215,140,17,175,176,127,109,85,35,196,191,136,217,154,81,255,233,41,3,117,150,158,142,39,215,192,103,253,17,226,87,196,248,15,241,159,124,98,145,191,172,60,135,123,5,159,127,83,21,147,15,240,31,243,148,195,108,246,137,31,124,80,98,226,63,79,49,84,239,232,169,165,226,59,91,88,236,27,127,203,15,120,246,155,37,254,103,143,35,51,226,47,245,172,236,55,67,61,43,253,232,240,197,210,86,11,255,177,179,248,187,252,199,151,159,237,200,127,105,115,152,105,23,200,207,185,219,190,254,58,152,15,255,161,190,50,241,151,195,22,99,223,170,31,240,31,43,135,255,203,254,84,135,10,223,175,250,237,130,159,191,57,188,176,248,28,34,195,211,126,47,126,195,175,244,151,191,235,217,171,137,255,
212,47,89,226,189,242,63,79,234,77,188,167,30,54,246,187,140,126,151,101,255,232,15,250,182,252,131,250,195,66,62,138,239,201,245,14,14,66,137,151,249,164,217,101,68,121,90,103,234,109,234,163,40,244,146,111,46,81,207,19,223,89,143,137,199,108,13,77,188,229,112,195,212,223,28,198,67,7,29,131,175,248,142,127,71,23,57,92,153,246,158,26,71,121,90,23,149,254,114,228,7,252,39,57,31,102,7,3,189,121,198,137,175,81,236,51,74,188,72,46,178,223,208,56,254,21,165,190,74,178,21,52,252,241,249,135,242,79,50,107,121,249,101,150,113,182,234,201,89,248,129,191,40,245,25,121,12,250,236,103,176,143,36,187,186,36,254,25,93,185,235,213,255,28,230,68,203,240,195,59,126,38,31,16,63,146,139,172,151,167,149,38,254,190,165,166,127,75,253,163,248,43,255,90,68,222,140,219,224,103,180,53,55,71,25,205,110,230,29,250,83,252,144,127,207,34,63,118,125,70,31,60,37,55,250,100,253,166,254,131,62,121,4,26,126,252,224,221,32,43,167,248,79,253,41,127,212,86,152,173,190,149,165,254,67,254,178,23,61,229,183,121,122,
105,252,215,212,127,94,124,54,241,246,29,246,200,209,134,153,79,246,194,7,142,198,94,244,8,139,183,181,237,9,236,113,22,123,228,29,64,115,148,192,81,132,129,231,237,87,155,163,32,107,154,120,198,231,8,214,52,246,13,255,246,36,245,193,36,246,205,62,199,196,111,242,51,118,76,252,34,126,106,159,179,12,252,148,23,31,77,252,41,119,48,134,15,100,191,246,182,250,211,216,31,159,47,216,236,99,246,234,95,139,252,110,243,22,142,153,95,71,13,239,136,135,124,126,227,213,207,172,191,116,142,252,115,129,167,229,146,31,242,157,103,189,207,192,215,122,76,124,68,222,212,15,54,15,91,44,115,84,66,123,10,249,75,62,123,241,59,127,197,91,207,60,235,101,191,104,79,34,127,179,107,39,63,40,255,202,63,249,160,205,202,226,79,146,87,118,111,31,167,163,160,227,222,252,58,234,96,127,106,189,229,169,225,107,228,175,248,93,138,195,31,248,188,189,99,228,195,219,43,70,191,228,43,115,212,97,248,195,127,87,125,253,153,163,32,240,231,192,87,252,99,31,71,222,37,127,81,143,43,63,72,191,218,31,104,253,70,223,196,239,
44,251,7,30,150,152,250,223,248,55,240,203,119,189,249,87,168,95,217,223,218,60,204,50,241,197,28,149,248,248,216,183,149,37,255,240,240,45,147,35,254,19,223,117,170,97,115,234,96,205,223,245,236,133,195,116,83,255,45,251,251,23,30,158,113,200,111,242,187,177,167,189,252,190,204,254,194,228,7,246,71,138,183,236,111,76,189,110,226,23,241,147,122,209,196,115,243,86,10,241,153,195,79,141,39,231,56,117,144,255,81,127,202,95,34,212,23,196,93,100,174,250,27,126,204,62,211,171,191,69,223,171,239,137,71,208,247,226,119,132,248,77,124,224,109,99,51,110,242,135,236,11,124,233,207,236,79,152,207,212,223,138,247,208,7,94,245,183,217,127,240,246,16,167,43,212,167,216,59,245,69,132,248,105,177,255,137,80,191,120,111,221,208,214,83,114,229,43,201,31,250,230,173,21,242,175,119,88,172,252,117,208,248,191,153,95,241,127,153,248,207,195,34,139,250,195,46,18,47,139,251,161,129,191,72,95,38,190,99,127,170,127,204,126,171,157,88,73,252,92,224,168,76,245,255,158,254,102,208,159,244,111,252,27,248,61,
253,243,176,211,212,79,28,21,26,251,47,112,148,135,188,76,253,101,234,247,223,235,75,91,167,70,28,246,235,109,43,99,191,154,15,253,155,253,153,234,3,226,117,134,183,118,204,252,75,223,122,245,195,94,253,163,113,197,251,130,234,31,228,197,7,133,166,173,250,102,89,249,7,255,48,249,132,122,77,249,28,251,48,246,163,250,147,245,107,127,44,249,70,241,23,115,126,131,253,153,120,207,249,79,114,82,241,94,251,3,244,191,30,37,63,236,39,198,82,127,43,62,191,165,254,159,231,20,139,243,31,83,79,11,159,252,149,196,223,162,200,39,57,126,142,179,23,240,103,6,193,85,124,190,2,62,231,65,188,237,146,196,191,163,188,157,31,229,40,54,57,229,157,106,69,23,201,47,248,75,148,253,143,25,159,57,5,46,231,67,248,127,146,183,223,163,133,78,114,55,231,79,28,101,154,243,31,115,62,133,61,189,66,191,124,30,20,165,190,136,234,84,141,15,52,163,196,183,228,36,249,129,248,156,156,100,125,188,229,16,229,97,79,84,250,39,255,155,124,50,13,127,156,63,69,137,183,38,222,231,209,47,248,54,245,143,241,63,234,65,19,15,178,
196,31,229,123,242,151,78,5,77,254,54,254,200,56,15,107,76,253,170,248,81,32,254,83,31,155,163,78,236,199,158,67,254,170,175,231,238,123,241,195,224,99,63,58,42,149,253,176,191,49,245,195,76,159,231,255,236,87,77,253,173,250,79,248,236,175,128,3,198,175,255,246,240,57,255,48,246,105,242,19,241,147,113,147,207,77,254,215,252,60,28,166,190,179,22,208,47,249,209,98,63,100,226,103,142,245,229,56,7,202,131,175,243,149,189,250,83,245,179,234,95,228,103,226,87,153,250,92,241,147,119,196,201,59,196,80,230,231,29,115,207,191,137,95,19,196,31,115,84,140,61,189,134,62,251,95,19,255,121,152,101,248,95,129,127,228,101,155,252,231,199,47,244,111,81,31,152,163,106,246,143,102,253,11,200,143,253,145,205,249,211,109,213,79,38,126,54,186,183,177,191,219,146,15,241,245,182,217,95,80,191,83,255,89,60,76,55,231,31,188,245,150,81,126,48,252,177,31,230,157,98,51,191,234,127,242,143,197,195,52,19,191,201,47,54,239,244,91,179,156,47,232,156,142,135,145,38,191,41,191,98,191,54,254,109,179,191,180,84,127,
112,126,153,169,132,136,13,208,227,107,173,12,242,73,34,255,204,91,236,115,6,249,49,127,146,253,47,118,236,102,52,255,75,218,188,179,156,124,199,209,249,75,234,43,197,71,252,51,147,199,190,150,24,71,94,73,242,71,102,66,245,73,143,209,127,114,9,255,89,58,136,254,195,156,37,48,206,163,140,228,204,126,206,19,148,31,217,127,195,111,114,30,251,226,252,44,67,253,228,237,95,217,111,76,83,255,193,95,18,249,101,86,169,143,242,62,62,231,155,102,126,242,159,25,103,255,109,198,177,47,195,255,180,248,135,159,105,248,19,254,186,240,105,175,223,52,245,172,252,55,195,57,99,146,71,41,25,252,43,185,22,102,237,251,136,207,49,83,239,36,103,225,143,175,133,50,239,210,245,94,225,243,238,115,146,119,200,123,169,159,50,232,63,57,193,249,238,4,227,175,239,121,244,57,159,72,82,207,103,52,174,245,189,163,254,226,252,46,51,137,255,16,239,146,156,15,39,179,60,170,224,115,219,204,47,180,95,177,255,230,107,154,204,47,131,38,62,38,121,180,69,29,199,250,187,224,15,126,76,253,198,56,47,83,100,176,159,228,26,248,
107,180,241,111,197,211,228,70,156,19,116,228,67,61,153,121,1,252,155,139,110,230,5,235,227,235,31,51,190,68,125,201,215,96,25,234,193,36,250,215,249,99,18,255,206,240,53,143,226,121,146,250,33,57,191,143,120,78,253,136,255,70,249,169,67,146,203,81,10,194,63,183,208,130,98,126,153,198,87,96,121,25,40,234,12,211,38,162,56,199,234,81,78,114,147,79,161,240,180,205,141,242,61,159,190,111,139,242,240,45,74,4,214,9,73,146,10,39,202,7,210,201,103,84,152,120,216,222,9,180,44,44,90,98,28,11,143,190,37,2,177,3,212,9,186,222,174,142,150,57,33,231,4,163,135,10,195,156,176,191,209,9,58,17,244,237,128,23,97,215,186,24,215,123,159,215,137,110,192,179,2,115,98,142,5,152,19,22,42,148,40,239,179,241,97,98,61,137,132,163,68,160,228,47,204,71,132,208,235,18,81,78,32,147,68,132,40,175,43,36,177,240,40,17,32,202,252,73,248,139,114,226,208,131,5,232,251,172,40,15,107,162,178,64,241,247,150,246,244,160,55,191,209,16,244,202,68,96,34,84,148,19,82,115,194,178,192,87,2,138,208,188,158,17,45,31,229,155,
191,176,183,3,64,131,81,158,187,36,177,96,118,126,68,93,52,192,9,86,148,19,28,19,225,197,31,31,88,139,63,125,213,17,93,233,160,90,223,207,99,9,230,151,7,97,193,209,9,225,115,162,67,132,226,100,10,217,195,15,59,108,147,161,120,174,2,31,100,40,239,171,144,40,15,243,180,99,233,81,6,147,7,243,4,193,156,32,105,125,202,96,198,66,149,193,160,79,133,242,101,156,10,196,200,143,8,26,45,241,212,132,15,150,205,9,22,15,179,146,115,251,200,138,68,88,248,179,121,29,192,102,220,98,199,96,50,4,21,131,78,4,236,108,159,23,97,205,9,47,22,71,5,101,78,0,120,15,205,94,0,94,59,90,42,36,155,29,164,93,60,64,21,77,197,168,10,46,119,154,136,124,132,44,140,133,43,163,144,193,189,10,1,124,83,1,243,48,76,39,80,83,218,33,11,159,83,253,162,118,40,126,134,224,4,203,230,39,59,172,57,230,23,62,239,241,169,2,202,240,147,18,102,135,194,235,48,54,30,108,45,14,120,21,54,21,21,145,30,124,191,194,209,14,212,156,0,245,123,248,188,207,105,78,168,121,31,210,156,192,168,194,103,7,110,75,255,120,144,108,168,107,242,152,219,
197,55,113,81,69,58,222,27,55,114,213,147,24,60,93,39,109,250,105,132,40,59,19,118,88,230,235,40,99,231,43,216,25,15,121,147,100,138,36,95,29,68,57,169,138,242,56,47,201,215,37,102,156,74,76,126,147,156,25,240,244,64,36,239,209,147,40,30,219,155,39,65,147,188,162,243,186,129,167,81,195,248,17,248,188,102,96,252,136,147,102,179,211,228,73,64,20,59,72,242,80,210,248,17,95,175,68,217,121,245,172,222,242,244,108,78,250,244,228,234,14,118,142,222,151,208,51,59,243,228,18,59,69,217,1,223,165,38,103,225,159,157,184,214,211,195,73,135,190,214,138,82,9,154,74,129,83,252,36,122,140,230,135,253,15,237,249,186,139,239,88,245,161,189,249,42,131,157,154,249,42,131,72,99,190,218,88,237,224,43,139,125,124,49,208,101,190,138,232,36,19,198,230,14,240,245,14,95,73,144,41,58,23,24,231,33,113,140,157,118,39,153,200,251,250,140,175,145,168,84,245,29,96,39,95,47,233,43,141,196,26,227,200,60,54,247,13,248,140,103,239,99,135,60,105,114,198,188,138,206,84,44,156,0,112,194,104,236,201,156,80,98,143,156,
24,155,12,255,22,253,225,191,246,219,97,47,67,234,9,131,57,161,194,62,240,111,235,29,246,51,141,125,188,187,207,56,25,159,159,52,177,120,9,80,39,24,38,67,206,242,96,93,39,100,243,200,93,17,178,248,11,58,225,9,154,243,231,191,242,74,70,199,125,70,11,143,114,234,19,245,91,128,244,225,38,61,252,170,148,203,111,228,226,135,1,247,150,195,155,11,252,110,7,159,123,132,249,186,67,31,11,70,235,9,158,252,134,41,55,194,188,108,155,88,138,251,31,51,242,169,141,249,152,145,79,109,8,110,97,182,171,97,202,179,196,100,175,247,251,31,164,103,126,5,128,207,105,146,245,48,66,75,240,123,38,9,126,221,33,204,241,132,249,186,157,199,151,93,164,127,243,251,35,132,247,196,235,51,110,226,53,159,242,80,30,75,41,225,53,253,222,136,126,159,132,223,167,97,60,204,246,52,193,39,119,97,182,103,230,99,204,85,62,213,65,105,93,27,40,145,224,22,230,147,179,48,233,35,65,112,210,175,15,132,73,191,250,36,44,204,187,82,97,156,45,65,249,149,192,200,194,185,123,230,107,248,46,248,235,170,64,127,253,134,247,177,231,252,
25,120,211,199,158,119,60,124,142,175,245,177,103,162,194,252,28,39,132,49,138,4,229,67,152,119,61,204,167,70,40,51,156,63,201,167,70,29,204,143,188,8,126,97,62,169,210,252,102,62,210,103,34,219,204,124,124,106,68,242,72,76,93,114,195,51,124,252,203,113,121,23,201,35,188,6,125,30,207,118,241,123,68,230,99,83,202,203,240,92,51,243,179,30,202,193,240,210,69,214,211,6,13,228,139,242,195,148,223,225,233,67,140,167,189,175,251,9,254,97,62,5,234,226,247,94,204,250,9,174,97,140,46,49,151,249,242,49,106,152,245,39,54,186,188,113,222,69,51,159,50,49,110,62,117,226,99,105,243,169,212,250,45,239,83,42,62,211,138,225,104,56,136,155,96,155,16,94,229,211,71,146,36,199,255,38,201,196,244,209,55,114,140,233,163,115,142,105,249,117,12,239,211,63,232,164,209,147,62,105,226,99,111,62,219,226,83,185,89,158,85,43,73,176,206,24,239,224,245,80,6,233,99,210,30,202,252,24,143,67,123,102,91,204,167,101,123,159,14,26,124,125,20,47,30,120,67,38,54,206,99,7,126,213,196,124,250,134,156,122,144,83,140,143,
106,204,167,135,36,49,62,158,231,243,181,219,254,167,135,154,159,143,224,145,179,249,244,146,36,22,155,33,169,242,17,139,62,250,238,89,111,39,193,159,128,95,126,229,67,31,201,155,143,156,245,73,217,222,71,225,194,215,122,244,105,222,121,248,188,239,255,254,77,187,247,49,47,78,143,221,160,127,228,207,241,82,130,227,33,243,235,10,252,94,79,87,229,0,114,66,254,216,119,120,150,113,142,115,18,28,47,37,144,91,120,21,249,42,40,32,95,131,207,113,96,152,119,205,18,60,62,50,246,11,76,98,238,60,250,226,43,42,126,7,169,107,131,79,218,8,30,9,244,152,224,152,41,204,182,140,79,193,160,131,221,80,198,37,54,160,67,48,13,235,83,67,138,18,253,46,143,241,35,222,40,145,94,187,248,136,40,65,208,15,19,12,185,50,87,6,62,104,243,59,75,9,126,245,195,252,78,143,232,243,216,157,79,227,160,143,157,160,159,174,141,14,230,150,190,241,83,253,106,3,239,12,115,197,238,240,35,236,48,189,198,207,214,80,132,164,249,213,11,125,82,151,230,216,44,157,35,88,114,172,168,95,137,73,240,43,36,9,182,137,105,253,142,20,73,
60,61,121,213,77,179,13,77,80,36,25,120,228,160,79,236,210,124,210,150,192,15,210,4,177,52,111,188,36,72,46,90,159,126,183,42,193,167,145,250,244,86,118,156,102,253,105,99,199,208,151,140,40,66,18,252,10,75,154,143,160,205,248,210,55,200,7,248,37,173,15,248,13,125,58,169,249,241,99,209,39,248,38,216,134,164,177,243,4,235,77,179,205,77,112,236,154,150,60,209,83,26,191,74,243,73,94,98,158,207,196,8,222,250,228,48,129,125,233,119,147,18,20,137,105,202,232,180,244,56,238,125,2,152,86,28,34,238,165,245,171,40,226,143,228,33,253,164,73,218,134,62,201,35,45,253,136,62,113,42,77,28,226,215,103,136,85,172,15,125,164,249,157,47,125,26,154,230,229,145,180,226,192,4,58,159,128,30,199,164,178,139,180,228,163,31,37,64,62,105,252,35,193,54,56,193,107,28,105,142,73,205,39,119,235,49,214,135,190,120,76,109,226,236,92,167,231,231,147,41,255,147,199,132,231,199,108,115,180,254,176,89,63,113,84,31,181,179,190,4,252,37,240,191,48,227,198,190,216,38,37,40,242,194,20,3,222,39,145,124,114,136,157,134,
249,52,218,208,39,174,36,38,249,29,39,142,125,18,20,7,233,117,228,111,244,3,125,248,51,242,165,72,73,207,221,243,244,199,71,253,102,92,240,228,129,244,235,111,220,52,191,18,148,152,28,240,228,187,218,206,218,176,123,141,83,36,166,199,89,31,219,144,244,56,248,178,39,99,31,45,192,64,95,227,175,52,142,60,94,249,235,95,123,206,218,249,33,187,181,218,5,18,131,187,70,86,232,168,119,235,21,163,52,167,255,221,142,27,199,127,91,136,217,188,149,175,96,205,208,49,186,219,208,172,123,194,168,53,204,95,70,128,198,33,62,28,4,43,81,105,228,235,65,222,71,74,84,246,35,97,183,200,208,117,13,29,163,187,77,83,32,112,167,85,175,228,243,83,28,206,97,60,164,122,10,23,9,82,51,67,80,191,151,23,171,128,21,227,235,139,46,167,122,6,207,107,162,140,226,77,254,158,13,84,202,111,61,131,222,38,54,206,194,198,65,184,116,239,50,105,245,165,9,51,137,202,214,105,79,175,124,128,17,38,110,38,244,17,36,219,247,48,159,84,43,31,36,248,36,219,203,111,248,245,234,113,38,110,247,226,11,219,231,4,199,45,97,182,191,230,215,
92,204,175,189,16,127,228,23,202,15,178,75,94,99,9,83,212,24,124,138,231,48,113,186,75,126,161,113,142,191,195,224,39,40,186,76,126,34,174,98,255,192,120,126,27,230,199,78,194,20,175,137,183,224,155,252,169,184,114,128,24,231,211,55,241,141,241,105,86,131,222,148,191,204,167,179,60,30,198,158,234,97,226,114,130,252,22,102,115,209,165,250,129,199,19,38,174,241,174,59,121,31,187,36,174,80,188,38,56,62,50,249,125,47,62,242,145,138,177,91,126,143,14,190,160,129,93,155,249,193,231,241,122,23,219,123,217,69,152,205,71,24,191,79,76,224,87,216,117,24,187,86,254,79,200,47,177,203,176,228,195,241,145,228,243,123,125,208,198,250,175,123,245,139,225,31,63,93,242,241,101,183,228,79,217,185,241,11,30,127,38,56,158,12,243,120,200,196,85,195,63,248,124,75,96,232,115,188,151,152,69,222,60,30,255,125,253,172,151,31,95,48,159,18,103,241,27,94,207,8,175,162,31,248,235,98,251,30,230,199,60,186,120,87,221,248,177,137,99,248,33,245,148,126,124,131,223,13,195,96,200,155,108,255,189,79,117,201,171,196,
17,243,169,46,227,95,126,79,145,227,7,147,119,249,61,195,24,155,191,30,190,37,240,224,99,192,242,107,69,171,108,102,85,116,190,237,228,231,6,120,231,78,191,158,69,92,140,45,240,41,240,194,73,226,230,101,239,39,15,56,222,232,161,56,140,189,37,47,234,215,138,190,252,218,18,159,152,147,183,123,86,59,161,165,79,129,249,253,65,197,49,252,158,79,134,193,39,79,18,215,189,159,20,96,156,205,153,54,95,177,133,144,249,100,156,77,40,180,104,191,131,63,30,31,244,228,253,249,201,67,177,28,113,111,157,79,185,137,155,61,212,79,230,199,102,84,31,17,87,18,188,110,144,224,241,17,191,106,100,226,40,241,9,121,161,127,242,182,145,95,5,251,51,245,77,200,243,15,62,133,54,249,148,31,155,49,113,77,245,29,121,207,212,135,170,255,200,107,198,126,84,223,200,126,168,91,68,175,139,227,67,147,127,149,215,56,254,83,254,86,220,86,125,104,234,33,197,109,83,223,130,15,189,4,121,197,179,31,229,111,234,43,253,88,7,244,19,108,90,136,255,216,32,252,163,31,239,199,61,164,111,198,89,127,130,159,36,96,30,104,248,250,87,
94,22,255,28,255,152,249,55,200,187,196,121,253,216,135,137,123,250,49,25,229,69,241,167,188,194,241,159,201,107,60,126,55,121,145,245,155,184,202,230,220,228,85,142,103,76,222,196,63,77,222,129,190,201,107,162,175,184,76,221,147,38,174,39,102,89,31,155,247,116,158,188,68,29,144,208,38,7,255,243,242,26,235,159,34,239,41,238,26,255,61,72,94,35,175,8,159,199,19,9,234,182,180,54,53,202,155,242,143,44,113,89,121,229,37,237,113,242,26,199,195,137,151,140,203,62,246,232,243,184,213,240,199,241,84,154,205,75,2,251,48,248,108,138,76,221,128,125,38,94,1,255,134,113,14,71,18,28,255,154,249,245,169,187,236,99,227,178,71,255,21,227,175,68,255,54,244,225,159,250,57,157,221,143,141,32,31,229,229,151,223,186,233,151,65,242,50,252,107,126,94,111,75,240,184,62,205,227,217,196,11,218,207,208,207,11,218,207,224,199,140,119,49,206,239,33,242,248,61,77,252,72,188,190,196,254,226,152,155,158,136,121,254,152,139,225,139,7,224,1,251,210,254,229,143,121,85,251,143,60,121,149,227,167,46,226,23,117,189,
191,63,225,167,3,84,159,163,239,240,58,252,19,31,21,127,137,155,232,248,34,250,197,158,145,135,177,31,214,23,222,56,132,253,120,191,175,152,200,222,68,30,196,44,39,232,229,69,213,61,108,154,245,147,33,134,95,14,63,210,28,111,154,186,193,212,89,146,15,250,201,177,62,173,255,57,227,207,181,126,228,39,123,225,241,170,177,23,30,175,154,188,203,225,85,154,227,207,4,135,75,232,221,183,71,240,57,188,49,227,202,251,188,89,158,230,215,213,188,95,11,227,167,19,200,203,100,192,131,254,175,209,180,147,140,244,3,143,50,96,21,130,50,0,57,216,239,63,62,27,220,212,143,207,182,175,188,46,182,243,223,175,129,255,169,47,240,207,135,38,2,255,28,124,246,235,241,127,126,158,119,255,187,214,143,119,156,151,213,59,206,161,143,119,157,95,170,119,157,253,31,251,157,167,213,126,167,249,227,125,231,69,149,191,65,244,145,159,69,110,168,14,59,239,1,252,9,192,131,0,190,4,240,224,31,0,135,0,252,250,35,63,200,62,91,229,127,34,249,212,135,124,2,100,43,144,223,67,178,13,146,19,220,55,0,61,70,187,9,210,106,159,
134,250,93,218,45,140,255,196,88,128,190,43,180,123,185,78,50,219,73,238,31,126,204,56,135,160,245,227,71,54,193,213,140,51,93,189,5,156,237,196,63,222,250,33,90,189,245,67,174,106,59,143,63,14,56,153,234,128,115,30,58,83,208,110,132,214,247,208,14,126,28,97,41,35,78,227,199,49,167,122,169,58,230,60,3,240,25,128,135,0,124,10,208,17,128,31,1,216,6,224,93,0,47,127,212,79,247,87,71,157,113,86,242,51,28,52,178,26,173,89,156,189,6,169,17,142,94,250,156,118,112,111,179,246,246,143,195,149,35,44,255,28,247,39,170,252,8,56,112,65,218,143,192,209,138,127,1,110,63,125,189,220,159,253,200,47,48,51,105,107,245,161,243,152,137,3,244,79,194,148,56,30,128,177,179,224,184,139,32,184,205,176,52,14,75,251,193,120,2,116,147,218,31,135,156,38,250,158,131,213,80,229,231,175,193,74,128,49,15,194,99,174,54,215,14,168,255,2,108,19,212,127,230,254,40,240,223,113,47,14,158,1,163,153,34,192,245,176,58,247,34,75,115,152,96,153,9,218,185,70,184,106,226,41,144,46,112,141,113,61,0,145,55,16,136,114,237,134,
72,35,247,146,93,130,251,235,92,143,66,180,2,65,77,16,165,45,59,114,219,76,71,159,211,94,237,51,0,213,111,232,248,47,147,72,181,250,16,145,102,80,230,51,20,249,53,138,124,142,2,127,250,152,114,170,119,171,124,119,25,252,120,27,83,184,141,42,123,157,108,181,215,121,2,202,214,17,80,190,7,229,39,80,142,129,242,19,40,227,66,153,0,101,171,36,170,189,128,60,242,65,90,0,121,188,7,242,114,143,234,83,168,182,64,245,41,84,167,64,169,221,2,229,14,178,119,31,33,248,255,107,63,244,220,128,128,83,88,156,219,130,169,185,7,1,115,19,128,181,50,152,99,172,214,252,49,238,76,86,227,252,184,252,71,190,22,93,173,38,157,83,194,187,193,216,113,134,158,50,84,11,249,192,110,66,132,42,16,146,95,184,41,232,156,102,104,82,116,78,1,252,92,116,158,66,167,26,128,142,166,112,239,210,221,200,248,186,232,28,251,216,237,20,171,84,205,81,214,227,22,88,208,89,132,227,246,178,142,195,12,13,50,84,75,128,240,195,30,29,119,30,58,157,162,115,211,231,103,69,116,78,208,243,132,14,119,84,252,56,127,228,167,137,161,71,226,
39,3,29,179,174,187,226,167,113,143,31,155,177,131,12,185,15,33,244,235,65,102,205,50,107,203,199,52,26,228,171,129,42,191,224,12,91,131,176,245,16,174,242,152,212,214,79,152,212,118,7,56,21,80,90,62,118,57,93,80,108,172,118,225,95,73,231,46,243,165,160,185,129,166,182,22,209,230,118,140,30,163,162,204,71,94,153,15,86,123,4,243,227,133,106,234,199,30,70,182,194,0,111,183,65,173,0,181,131,80,139,65,169,21,138,9,168,13,3,209,13,128,123,0,114,219,87,33,183,149,133,197,89,159,197,94,88,108,128,197,56,44,14,195,98,55,44,186,141,226,81,30,189,29,250,24,223,112,170,241,141,163,226,17,170,45,62,85,241,56,8,213,69,241,56,33,30,83,244,72,107,238,0,60,78,195,162,43,21,87,179,226,237,25,119,110,7,119,1,192,159,2,221,206,76,207,152,105,156,107,181,139,155,234,53,248,176,224,225,144,196,127,1,241,95,194,28,20,38,171,17,110,198,141,121,221,129,5,153,217,29,103,130,235,121,174,179,92,183,126,2,245,30,168,77,66,205,248,154,123,204,72,53,6,136,60,73,160,81,174,39,185,78,250,109,145,168,207,125,
180,156,63,85,249,102,225,45,76,87,155,225,90,81,115,6,98,207,25,25,214,200,79,26,57,204,72,19,35,238,73,134,162,254,218,63,220,219,131,153,146,90,54,128,57,43,24,105,251,28,67,105,161,143,11,189,137,161,54,13,69,12,155,81,152,138,58,31,238,2,243,88,48,47,4,211,230,79,142,43,121,232,150,134,166,53,36,190,154,65,47,50,50,4,210,40,35,85,155,181,184,7,89,68,23,55,114,63,93,115,92,107,179,220,12,114,83,29,228,166,200,141,64,229,88,29,92,231,5,177,206,205,107,65,72,48,202,90,167,63,222,89,69,64,171,151,105,255,137,118,59,215,17,174,191,6,124,128,234,77,110,86,233,185,207,213,226,170,217,134,185,126,60,1,67,15,197,234,132,132,80,132,213,243,176,154,133,213,39,140,216,26,121,169,145,10,35,151,36,131,20,67,71,24,26,99,232,111,175,17,7,187,136,122,21,66,140,77,132,57,167,184,120,139,142,160,79,63,70,135,34,177,219,194,77,183,15,217,252,113,240,197,137,234,224,139,243,96,180,9,227,17,3,77,96,216,112,244,119,10,224,25,15,197,35,106,242,133,102,105,3,68,162,82,234,20,45,67,212,80,15,48,127,
2,106,23,68,77,200,39,0,125,182,71,173,87,176,2,25,97,184,17,48,247,44,61,29,10,139,45,180,82,202,237,49,146,89,147,122,186,233,57,34,50,103,128,217,126,65,178,116,143,147,44,45,110,30,114,189,192,117,156,107,109,141,155,7,220,84,239,9,36,192,93,148,155,97,174,33,174,47,185,18,75,248,75,62,2,185,36,144,54,127,72,84,218,233,120,205,181,86,225,230,103,129,8,201,109,242,65,6,124,16,77,244,241,13,204,140,194,75,1,238,148,62,37,73,119,132,14,73,172,1,87,87,130,147,228,112,93,79,27,238,73,64,91,62,14,190,217,95,29,124,115,9,20,35,193,11,160,200,43,239,10,116,22,80,137,69,68,81,199,59,212,241,238,2,144,70,29,81,6,78,51,80,164,227,39,9,39,132,112,206,210,225,94,163,71,5,79,22,136,106,150,100,248,144,100,88,0,228,22,16,95,209,38,136,82,24,124,236,67,131,125,142,187,66,207,45,58,16,62,127,134,5,16,149,13,176,217,135,22,248,51,25,2,201,211,51,224,19,201,236,65,92,161,227,36,40,89,58,30,145,146,221,118,242,113,135,56,185,66,207,37,17,233,6,164,9,66,63,65,228,13,118,249,30,179,252,32,211,
117,247,115,183,61,174,187,227,186,123,207,157,60,111,187,164,174,160,238,54,184,83,73,85,107,229,102,66,55,231,184,121,163,155,11,220,204,234,38,72,52,154,37,24,213,68,211,192,40,196,41,143,255,249,23,110,242,220,252,94,135,54,255,63,170,67,39,230,183,87,222,230,84,135,254,207,183,3,255,114,104,49,240,47,193,142,95,3,255,242,203,137,214,127,121,94,248,176,254,137,74,233,211,119,206,47,91,223,57,135,182,16,223,255,126,230,19,250,251,132,218,95,109,161,145,230,173,81,231,204,167,91,206,225,79,212,60,91,252,201,152,173,91,78,236,211,160,19,248,196,27,113,91,131,78,195,22,236,31,254,196,247,228,159,248,179,111,163,91,3,64,164,156,252,167,7,116,220,118,70,183,184,110,221,118,218,63,241,183,96,62,245,58,63,111,141,48,222,235,188,240,231,168,222,214,28,231,160,221,192,28,13,204,21,103,142,86,230,184,198,28,13,204,17,103,142,160,230,104,244,231,112,111,50,71,128,57,106,9,152,108,128,80,181,1,34,63,129,123,253,15,124,30,129,70,24,252,6,232,136,198,49,104,172,64,162,69,108,198,124,18,
110,59,60,54,192,235,49,248,59,9,111,17,248,109,133,223,67,180,27,13,191,189,204,69,81,198,52,1,166,219,62,200,84,243,76,229,30,130,78,195,167,239,57,33,219,13,244,53,237,94,184,125,120,247,23,251,240,238,173,158,224,238,186,213,180,251,83,172,105,183,59,178,127,235,123,208,7,156,131,187,43,215,155,119,227,151,155,118,151,46,52,237,142,157,109,218,13,159,108,218,61,124,188,105,183,169,181,105,247,218,209,166,221,3,71,154,118,39,155,154,118,247,29,12,238,54,236,107,218,13,4,6,118,223,28,108,218,61,212,210,180,59,242,117,211,110,203,249,166,221,175,46,29,222,61,126,253,240,110,247,141,166,221,159,153,99,35,221,180,251,242,118,211,238,157,59,192,223,253,63,126,134,163,231,76,230,62,252,68,149,184,133,121,246,194,241,4,204,22,224,243,39,88,169,181,178,220,89,150,231,126,255,169,207,121,189,133,157,223,0,233,9,72,27,8,225,25,139,175,73,62,111,69,229,79,80,153,21,149,54,168,60,214,146,79,64,102,68,100,250,32,51,36,50,223,65,102,84,100,250,192,146,238,221,102,232,124,47,58,103,63,221,
115,238,110,241,231,17,11,40,32,135,2,160,243,192,25,103,168,240,233,145,115,111,235,145,211,196,181,133,107,237,20,228,220,251,208,155,135,92,78,228,46,65,110,18,114,5,80,126,18,181,32,29,143,69,255,39,184,154,23,87,237,112,53,238,175,109,88,76,197,160,50,44,166,126,222,91,91,2,164,1,144,180,182,234,21,145,185,6,83,139,48,213,246,137,63,88,187,197,30,4,222,110,193,219,16,16,15,0,88,252,244,208,169,62,217,122,40,72,40,5,32,215,244,233,174,147,217,186,235,52,67,53,3,111,119,33,58,8,209,41,108,118,107,5,99,221,14,67,84,254,18,128,181,183,176,22,132,171,102,173,60,2,74,131,49,237,17,39,107,12,191,207,57,11,6,166,124,15,122,195,6,235,13,24,1,160,27,193,250,117,136,89,215,152,52,200,164,3,96,183,50,113,140,73,163,76,250,128,73,151,52,105,74,147,190,128,196,52,104,237,254,74,130,172,164,155,149,220,101,37,247,88,201,60,43,217,154,102,37,219,103,247,86,114,22,162,22,68,143,66,180,11,162,189,16,189,5,209,25,17,125,34,162,63,64,84,171,144,165,143,193,79,192,231,205,152,139,92,36,0,232,
168,89,201,16,131,40,42,109,48,188,181,111,237,131,159,160,65,193,81,186,241,181,102,102,144,214,228,173,19,70,16,183,156,251,248,101,128,201,186,96,84,17,226,22,204,54,179,228,113,218,205,180,171,143,104,4,232,116,179,120,111,128,101,101,88,86,0,239,13,126,202,224,189,252,181,186,173,140,115,133,105,134,76,228,26,117,126,52,156,18,185,78,195,118,51,157,41,58,14,19,202,46,210,110,160,157,228,62,64,223,9,191,45,132,6,250,190,249,210,166,48,160,111,235,21,51,202,36,82,254,140,205,204,216,192,140,127,197,140,25,102,76,65,172,5,36,121,67,64,177,82,51,182,208,57,232,83,188,236,183,175,249,51,158,252,195,12,10,164,167,129,149,112,31,51,174,25,255,211,28,141,163,116,190,240,9,84,191,165,33,99,186,79,135,166,56,79,91,83,134,124,128,175,184,215,154,126,241,103,216,131,223,163,184,253,39,34,213,105,5,213,125,62,165,231,96,54,3,93,189,230,163,138,116,27,29,103,125,128,164,63,213,81,198,3,244,189,240,73,127,227,143,255,192,120,144,190,218,34,202,22,111,162,24,68,215,213,83,190,246,251,105,
52,209,121,149,246,17,0,58,12,197,123,142,198,69,117,192,24,6,127,159,144,182,22,35,113,137,64,45,79,163,145,105,94,250,83,86,47,210,144,128,196,163,230,140,248,60,220,240,219,205,140,105,249,125,62,194,53,238,213,119,143,241,22,250,254,251,34,234,235,69,125,21,212,214,139,202,218,104,187,234,104,2,242,41,16,151,232,184,68,219,61,206,141,18,131,43,139,191,11,104,147,64,135,125,208,33,64,255,110,134,158,132,64,154,0,145,1,156,16,136,172,67,102,54,8,72,138,14,67,237,52,55,161,61,208,46,64,191,18,232,125,122,130,128,246,138,154,88,179,4,34,147,26,161,177,15,48,247,14,61,71,232,88,163,241,61,62,224,54,98,251,54,29,89,58,70,69,228,107,225,200,80,36,169,191,242,5,129,54,61,67,185,13,105,153,210,85,218,146,156,36,37,195,185,64,123,79,214,106,11,94,237,140,63,254,235,62,26,82,247,24,131,242,142,170,172,91,234,125,68,135,50,241,37,31,163,157,123,185,203,41,127,252,79,62,133,61,14,212,254,175,236,227,23,3,128,125,92,247,237,195,242,245,31,162,45,109,93,162,125,24,160,227,180,91,105,39,
104,159,160,125,133,182,56,240,102,192,62,28,26,226,241,213,30,143,90,213,49,58,99,116,104,213,73,218,65,218,151,104,43,130,202,93,68,225,14,109,57,156,164,34,139,124,202,125,35,125,31,31,33,81,91,2,109,67,196,99,52,206,73,9,231,233,145,129,12,3,226,78,209,219,37,144,131,128,60,165,209,34,16,41,183,21,16,105,221,125,185,71,69,170,28,101,88,225,215,189,0,200,37,225,208,49,139,42,149,236,198,105,191,164,253,90,0,50,183,19,208,144,57,184,243,62,100,145,184,170,140,125,158,184,234,94,33,156,55,2,222,76,180,60,65,148,108,39,73,185,239,24,189,69,103,5,200,94,160,78,208,118,101,142,65,160,7,5,177,64,207,0,29,75,64,116,3,113,90,16,81,58,90,233,152,160,99,26,25,228,144,193,40,237,37,218,63,11,192,242,39,115,109,104,200,180,7,224,239,239,178,220,52,124,122,204,70,99,183,253,110,112,183,113,32,184,251,190,251,224,214,99,138,152,98,252,32,16,7,119,79,69,155,119,79,221,84,161,19,164,232,105,218,253,182,247,200,238,171,59,71,40,66,182,242,123,216,151,41,139,130,187,189,25,15,115,35,37,204,
166,221,51,86,243,238,106,168,105,55,126,169,217,148,65,51,199,131,148,56,193,221,171,193,230,221,201,195,186,111,218,61,114,242,200,110,235,69,149,57,65,83,78,245,102,130,187,78,175,74,156,45,121,115,163,120,59,15,245,230,221,151,25,21,65,193,221,115,221,205,187,169,184,10,46,205,22,48,51,229,174,54,83,108,5,119,35,103,130,187,154,165,131,66,235,80,75,243,238,224,81,102,57,22,220,157,254,42,184,59,114,34,184,251,144,241,239,219,131,187,39,58,131,172,175,105,55,3,189,11,183,131,187,119,238,4,53,163,102,83,9,233,138,114,3,148,183,75,126,207,123,127,129,30,202,185,238,224,238,207,137,38,196,178,7,120,120,247,235,112,243,110,238,170,71,94,211,60,104,11,238,190,61,18,220,189,116,128,197,52,64,62,96,239,94,218,239,245,169,198,91,250,54,8,78,112,247,89,50,184,123,251,22,117,93,111,51,98,21,27,213,241,61,54,174,195,66,0,86,182,191,247,123,142,83,148,157,162,254,113,143,153,58,116,79,224,231,83,18,201,126,35,138,124,103,243,238,247,23,155,118,143,158,245,120,184,79,173,121,233,64,243,
238,221,64,51,60,156,131,135,35,187,234,11,33,142,155,240,240,4,81,252,108,84,27,68,181,193,61,30,166,247,120,184,193,252,205,18,197,93,191,231,43,120,104,132,135,65,99,49,175,239,201,42,60,221,149,186,36,22,73,54,4,59,158,45,156,142,121,182,208,125,163,121,55,223,217,180,107,93,11,82,26,123,98,186,121,225,200,110,203,55,199,141,230,212,103,88,1,255,27,232,121,165,174,209,138,220,205,216,65,12,86,218,96,229,111,127,161,39,0,59,211,52,26,232,252,125,19,116,48,160,77,208,82,238,221,235,69,115,24,255,191,180,5,254,114,232,231,192,95,130,147,191,182,254,229,249,251,125,127,121,190,241,97,254,183,239,198,2,191,61,29,107,248,237,249,152,107,111,127,55,214,176,253,156,127,79,199,182,71,127,27,102,132,142,223,158,140,213,203,191,61,30,171,117,109,63,30,107,221,30,30,187,245,219,40,189,127,226,254,187,177,173,51,127,105,56,240,215,61,219,163,99,109,62,124,219,246,159,198,62,76,1,22,248,237,7,192,158,142,125,181,253,100,172,182,8,149,198,237,31,232,28,29,107,1,183,17,220,22,166,169,77,
131,186,31,212,22,166,106,4,117,123,2,240,65,70,135,33,17,252,237,103,48,96,136,193,227,144,114,53,101,96,251,103,195,225,97,56,221,190,11,93,141,6,32,241,247,125,160,28,2,226,48,36,238,24,38,159,48,240,167,177,191,221,15,225,0,19,29,52,235,25,30,251,240,28,200,99,16,20,143,134,191,172,192,225,239,168,38,0,69,171,254,74,252,205,128,38,226,71,246,248,155,133,120,11,232,33,32,71,224,173,25,30,197,129,150,234,198,64,9,248,60,54,139,191,126,159,191,6,72,252,187,60,82,252,235,62,95,138,41,102,108,246,37,17,252,109,108,236,111,30,109,143,141,189,134,120,3,51,70,1,15,236,161,194,252,223,20,152,241,10,132,175,0,240,144,153,26,96,92,218,169,189,50,179,253,48,118,140,153,27,32,121,12,44,45,160,246,11,144,39,33,117,216,144,241,116,121,18,82,181,32,3,47,97,60,8,153,70,200,6,88,192,118,201,168,253,103,67,70,66,126,5,3,135,181,100,176,255,155,121,160,54,140,128,190,27,59,10,109,172,102,24,212,81,35,148,6,104,126,40,249,44,53,136,30,244,107,25,104,196,12,202,211,177,35,200,245,160,97,107,12,
22,225,224,45,16,135,64,111,96,197,167,255,192,222,113,177,55,5,169,175,126,235,103,16,161,139,212,45,72,29,101,117,87,183,251,33,51,12,9,173,240,187,177,21,250,155,12,165,225,177,255,248,227,111,47,24,248,158,129,31,199,198,182,127,132,252,247,12,190,24,91,162,191,145,190,0,99,15,233,111,162,63,64,255,228,31,250,171,237,166,243,199,177,32,3,213,255,109,28,45,53,128,34,165,254,253,0,147,220,69,99,158,20,31,141,125,72,108,63,162,227,137,89,122,0,200,15,105,32,174,65,185,5,190,79,34,202,15,87,176,207,107,240,123,18,180,19,134,206,99,140,247,187,177,127,56,11,228,48,157,95,253,246,200,44,226,67,6,90,15,52,27,244,52,219,135,243,64,92,21,45,160,78,51,224,217,255,216,216,135,20,146,26,132,150,231,37,63,143,253,195,9,32,71,128,250,218,8,3,190,46,66,235,17,116,90,64,147,116,62,36,129,184,1,45,241,116,4,251,250,208,9,141,239,197,15,252,9,226,31,238,0,97,67,227,164,81,1,52,210,208,120,8,141,166,61,26,93,64,116,65,227,48,248,50,147,15,221,208,24,246,101,211,8,157,15,89,32,2,208,56,4,148,
251,239,203,88,165,228,32,242,127,255,18,181,55,33,135,131,191,253,100,204,232,111,101,24,129,237,159,198,90,125,99,249,112,10,228,23,38,40,224,158,8,165,30,130,129,95,48,2,47,116,96,221,205,64,204,2,113,152,81,99,213,13,64,204,2,113,204,183,127,183,193,48,240,3,230,136,179,182,98,93,242,67,17,251,96,3,218,9,104,147,15,250,97,17,144,22,152,49,126,206,154,129,208,242,158,192,225,51,195,182,140,179,1,6,127,125,38,30,128,14,110,63,27,171,121,248,248,138,22,53,75,111,19,12,137,78,179,104,204,2,127,8,26,103,246,22,101,65,116,216,16,146,135,178,168,115,240,241,212,231,67,90,174,125,13,196,2,16,26,21,47,219,57,32,196,220,9,160,218,124,58,18,161,20,164,160,41,41,22,105,55,226,22,10,59,65,60,33,194,125,51,125,237,180,3,180,99,126,219,45,208,209,74,199,239,121,96,240,142,242,64,118,230,245,226,146,201,3,255,107,32,240,175,135,158,5,254,53,120,230,215,195,255,250,188,180,239,95,159,191,255,80,252,220,87,108,248,204,145,207,231,254,82,224,51,199,203,251,107,156,221,215,250,75,141,53,58,107,
125,69,247,183,210,103,246,199,159,251,203,129,207,131,206,245,26,123,248,26,137,167,214,95,238,254,60,60,79,223,59,198,158,159,174,245,63,111,173,113,95,27,158,79,127,30,92,11,124,30,6,190,191,24,174,13,174,53,214,250,139,244,151,19,159,135,151,129,95,160,127,33,82,235,95,104,172,13,46,52,212,134,151,233,47,208,255,190,1,22,194,204,28,168,113,95,27,46,208,191,40,120,250,231,161,179,0,141,69,104,205,91,134,31,146,30,244,35,134,23,241,212,95,140,155,121,251,179,204,77,63,87,51,247,112,209,162,31,216,85,241,116,2,62,78,208,15,252,106,242,243,96,94,176,240,179,114,186,198,181,54,152,167,127,101,216,163,47,126,138,39,13,239,131,239,91,89,119,234,243,48,180,251,197,211,50,235,93,68,14,203,71,106,195,217,219,222,90,225,103,208,57,9,63,167,106,108,47,152,39,254,121,152,57,7,151,161,179,116,178,54,188,10,237,37,230,88,126,240,121,24,81,83,181,3,31,2,190,177,54,92,98,204,129,127,214,58,188,196,152,89,175,214,138,28,150,18,192,194,167,224,223,195,59,255,204,122,29,248,95,1,94,252,47,33,
159,21,232,20,53,7,114,51,250,18,125,228,80,134,23,163,51,248,209,188,89,250,115,55,106,131,57,127,222,108,204,200,191,127,85,253,200,51,135,110,87,25,43,208,175,245,78,210,63,5,253,41,248,153,132,86,214,242,100,144,131,167,21,209,1,30,89,12,175,196,61,218,232,120,120,249,6,242,151,110,181,94,248,129,118,191,116,188,194,122,87,154,145,5,180,10,215,224,27,254,153,99,112,225,6,116,161,179,132,76,23,88,175,228,38,221,148,160,159,23,63,135,145,81,39,114,1,126,70,240,178,135,35,158,124,102,58,61,250,200,109,112,30,250,243,162,3,255,171,208,153,130,198,162,248,135,254,34,253,83,208,159,162,95,60,74,143,115,201,218,224,92,19,99,199,107,253,203,217,207,60,231,254,60,186,30,248,252,96,252,68,237,193,120,91,237,190,211,90,27,93,239,248,124,31,25,143,46,70,106,163,172,243,62,246,100,224,42,224,163,211,65,120,125,48,211,80,123,48,115,179,54,90,9,128,19,101,28,248,60,243,210,63,56,3,30,107,184,239,8,143,126,236,202,195,235,164,175,161,54,250,158,126,209,95,185,84,27,93,57,0,125,219,131,19,
253,181,175,177,213,211,208,109,4,54,246,249,126,1,254,230,174,212,70,231,160,87,184,237,193,173,67,111,153,121,150,79,194,107,43,112,221,159,239,227,123,163,75,192,97,111,252,149,110,31,14,122,235,192,173,135,128,19,63,93,94,63,122,148,31,74,166,163,216,196,23,62,69,87,107,123,201,218,94,162,199,85,214,103,240,88,31,33,99,84,242,51,242,148,92,160,103,228,194,188,248,218,224,28,244,230,58,107,163,107,222,60,92,205,92,131,210,47,182,10,12,243,36,141,93,203,143,135,151,195,216,10,241,0,95,232,119,110,152,88,96,108,175,220,129,253,130,163,120,144,237,193,158,209,27,240,253,248,25,79,150,176,107,248,98,29,166,31,91,234,47,225,123,37,250,229,103,242,15,193,195,107,127,57,130,111,64,27,95,24,68,142,253,244,13,34,223,225,197,83,181,193,10,180,23,207,225,231,55,232,103,77,194,41,156,194,254,219,128,197,102,138,221,38,52,26,62,151,232,95,194,7,213,95,130,127,252,201,244,103,163,198,126,189,254,155,244,67,95,116,150,136,43,134,151,43,192,95,53,125,194,25,94,97,189,43,162,193,218,176,11,
3,139,95,114,226,0,157,22,250,14,178,62,241,143,108,86,240,193,242,53,35,135,225,149,125,140,177,94,108,116,88,235,45,119,122,254,189,212,44,189,178,38,201,82,240,151,233,199,7,150,233,175,68,61,91,151,15,46,223,148,189,178,94,226,196,114,236,51,135,181,159,123,241,155,33,226,80,47,62,195,17,103,173,207,73,124,238,163,207,244,175,70,106,67,192,247,46,181,214,250,150,174,146,42,232,39,230,15,57,151,128,61,94,235,37,62,245,21,59,63,247,177,166,33,108,179,119,254,20,125,39,106,67,5,232,32,31,62,34,1,150,254,101,232,96,235,204,87,235,101,94,198,63,247,178,222,190,210,77,224,160,143,239,15,21,226,192,6,188,57,178,55,77,31,243,129,7,60,107,234,197,222,250,86,98,53,174,181,33,236,157,123,236,156,245,98,163,60,145,197,223,101,235,13,181,59,200,77,49,81,62,197,195,106,218,178,77,100,65,126,224,222,216,225,48,118,114,223,105,97,12,223,47,37,62,223,193,22,228,211,195,165,235,181,59,149,253,244,201,110,147,6,94,246,195,31,144,7,246,32,125,162,3,60,176,242,229,225,210,101,159,198,239,240,
242,141,225,101,193,67,7,155,150,95,8,94,246,124,127,245,116,237,254,106,171,161,53,156,237,66,223,13,159,51,162,67,28,149,61,112,143,222,177,31,116,165,248,148,41,198,106,25,229,78,197,174,213,248,231,140,114,170,104,173,70,129,3,158,245,14,175,222,52,52,100,187,195,75,49,99,111,253,172,55,35,58,244,101,196,79,9,251,100,77,166,191,24,53,116,76,76,38,190,138,134,178,253,240,170,252,2,26,200,147,51,224,207,67,207,26,106,67,207,44,232,104,12,152,226,117,232,104,126,141,159,166,95,62,40,89,185,71,63,115,78,254,249,59,20,58,198,149,231,214,148,16,39,107,220,215,120,164,84,251,46,27,254,60,2,226,119,36,171,49,22,208,227,124,91,227,90,27,41,157,5,142,241,149,43,244,5,160,209,240,249,59,224,248,91,238,224,54,130,123,148,241,163,181,239,74,29,95,198,69,255,187,229,111,60,186,36,151,49,148,200,31,103,252,50,254,29,206,50,230,116,27,124,238,129,11,48,126,253,247,113,12,143,191,46,111,120,251,174,112,194,31,191,225,141,99,192,223,161,164,177,34,227,8,125,164,32,222,69,255,191,120,26,228,
121,80,239,231,7,99,23,107,15,198,190,66,133,207,106,163,184,162,76,246,22,51,242,152,176,118,203,249,246,51,7,248,184,237,3,220,180,169,102,59,75,159,121,85,227,51,143,223,226,53,94,109,169,241,52,39,244,153,179,254,207,15,156,129,218,3,2,24,143,221,140,236,122,157,55,148,91,65,248,249,193,24,29,103,147,73,166,56,207,20,110,43,244,229,70,93,204,209,204,28,237,38,92,216,180,57,90,99,142,53,230,104,96,142,173,103,208,15,48,207,214,33,159,134,59,6,141,118,209,104,243,249,76,64,163,1,26,17,159,70,18,124,133,93,247,240,30,163,55,33,112,66,140,94,240,25,77,192,104,0,70,111,248,140,14,193,100,51,204,46,252,145,209,70,38,217,26,241,105,52,124,254,222,153,171,125,239,236,131,84,3,164,106,203,198,1,6,222,99,56,133,142,26,87,216,106,168,101,10,93,159,7,48,244,59,36,135,204,194,181,26,215,26,237,90,102,33,237,193,19,228,50,171,23,254,95,218,206,172,57,170,36,203,243,8,65,130,216,55,65,2,153,172,2,130,64,44,34,64,87,161,88,181,160,134,82,105,42,139,204,172,76,72,146,29,36,16,146,16,66,8,
164,68,97,162,8,172,179,123,158,198,44,48,227,11,204,235,188,181,89,127,129,30,155,239,49,111,243,33,102,126,255,227,126,175,60,66,17,85,213,15,243,128,69,200,239,241,227,103,63,199,143,251,13,170,121,138,133,225,119,91,153,3,60,250,45,49,39,255,2,199,99,156,159,195,169,14,207,229,106,194,45,231,206,83,108,13,18,28,6,103,207,2,207,179,37,96,40,64,134,113,166,18,137,46,255,148,117,72,114,188,118,94,29,158,206,174,206,195,118,7,239,51,239,62,1,64,68,147,112,242,56,104,9,26,134,177,219,252,228,25,214,129,110,18,104,126,178,175,54,76,114,103,109,158,119,85,249,206,56,206,72,225,91,162,104,25,214,58,207,78,87,249,169,192,42,223,171,165,215,57,163,205,248,39,104,15,62,103,157,231,193,58,51,172,67,128,27,38,232,230,31,33,31,18,70,137,192,145,127,20,89,96,26,38,17,231,167,89,135,53,74,36,171,60,116,151,224,103,152,245,243,143,224,135,162,152,159,53,170,14,179,190,201,71,114,123,126,170,202,79,117,25,93,195,115,253,181,146,112,83,12,13,79,3,79,18,70,30,200,160,223,248,231,56,152,160,219,
69,32,151,154,145,245,82,95,109,128,34,125,24,89,22,230,247,86,11,4,172,97,124,109,96,170,80,131,6,219,47,20,72,0,130,213,156,225,119,253,14,158,53,10,11,216,244,2,240,240,32,120,217,250,48,5,193,192,34,248,9,64,195,232,184,80,233,175,21,144,211,0,244,15,147,44,134,95,108,169,22,94,127,85,29,120,1,60,129,216,224,223,30,170,22,150,25,19,254,133,162,225,25,64,247,195,175,142,33,211,141,4,255,175,192,211,27,224,255,134,191,129,95,108,7,62,235,225,241,138,87,39,129,133,223,87,155,120,126,213,141,19,16,135,231,145,39,9,195,241,208,231,198,241,255,225,185,147,232,25,190,240,253,66,197,227,33,201,12,75,207,232,30,89,85,7,222,3,143,189,65,27,118,112,10,253,195,43,133,119,97,41,231,198,137,97,195,239,142,27,252,192,98,7,227,87,192,143,12,136,61,14,94,248,181,54,122,4,143,217,215,27,18,134,108,142,241,225,57,244,136,13,201,150,242,207,246,97,63,123,188,45,5,118,52,139,126,209,137,243,37,244,136,236,205,47,158,49,142,221,149,224,109,120,6,120,225,71,254,121,138,65,201,222,214,152,97,93,
130,60,58,173,229,39,176,7,124,14,93,87,243,19,140,155,252,25,159,66,14,130,167,240,204,79,97,63,178,79,138,239,252,131,189,213,252,131,109,232,108,61,54,90,114,248,177,147,252,204,113,143,155,117,103,243,102,111,102,159,227,93,213,252,56,176,178,57,249,7,182,140,188,240,29,232,148,239,34,187,18,246,99,248,149,240,158,226,103,216,102,73,244,60,69,14,74,238,20,204,249,153,19,213,60,5,10,252,160,55,224,141,126,198,61,191,178,207,210,188,231,87,254,55,137,94,228,123,146,233,164,151,167,252,104,234,148,243,137,87,140,195,151,244,50,12,207,3,179,39,170,3,248,220,48,252,22,216,232,17,72,157,77,96,39,3,243,237,140,177,174,236,86,246,204,191,1,138,31,138,27,198,182,241,172,228,240,200,55,102,247,129,7,251,199,87,11,21,103,255,216,31,60,239,129,87,244,62,135,61,84,202,6,63,32,153,190,194,254,137,71,3,179,248,64,101,160,86,80,188,145,191,204,237,70,254,42,114,24,127,55,104,227,42,202,134,159,163,199,231,208,131,45,14,160,71,193,15,16,15,135,129,231,19,219,17,60,120,40,4,21,11,6,102,247,
128,27,58,217,116,21,150,135,28,188,236,220,236,22,28,178,195,119,248,187,104,225,95,97,249,52,112,192,203,223,103,115,206,198,137,89,92,103,129,62,198,103,182,96,235,25,23,3,100,43,138,75,196,31,179,255,101,47,31,249,246,226,81,124,17,122,94,139,95,249,41,107,162,223,129,55,199,89,115,3,115,54,51,158,97,124,93,109,80,27,34,232,209,70,111,16,253,154,223,65,251,32,188,141,188,62,93,229,179,90,192,135,71,94,131,31,123,230,192,158,141,17,240,52,22,248,142,127,225,143,208,62,168,141,199,204,105,54,24,224,81,156,153,5,30,90,6,161,115,100,118,119,117,112,153,130,126,22,217,189,70,110,196,30,54,138,181,65,228,175,127,218,52,22,94,8,15,241,153,124,52,194,134,16,124,213,145,105,232,159,69,254,208,62,136,156,71,38,247,178,177,1,63,185,167,48,61,234,224,13,255,113,112,111,96,13,173,11,30,109,58,209,215,224,60,184,161,135,191,153,243,71,195,93,96,124,100,246,36,240,140,99,211,131,196,171,193,87,200,152,53,70,38,186,170,35,19,224,199,38,10,211,196,19,209,47,249,80,128,107,243,52,184,212,9,
253,224,23,237,60,27,153,132,167,201,206,42,223,161,191,31,88,116,168,113,226,216,8,249,138,239,204,201,3,199,184,230,188,64,158,248,46,223,153,135,28,128,85,46,27,120,143,253,179,97,40,144,203,134,37,31,224,157,190,78,59,27,97,67,55,60,237,228,169,162,94,113,146,171,99,216,149,214,96,28,220,22,223,204,30,176,157,55,196,195,23,249,90,1,95,28,80,252,124,117,194,252,113,128,186,175,240,138,113,54,241,102,183,207,136,51,207,176,31,108,183,240,12,60,130,23,254,215,140,67,187,214,40,188,98,124,66,240,140,63,135,30,197,237,9,232,121,78,222,161,158,148,206,134,137,15,5,252,151,181,176,81,232,167,41,53,64,78,31,126,182,23,252,224,121,9,158,113,244,37,58,21,255,95,192,175,242,29,27,152,225,23,200,89,248,229,3,227,248,35,241,74,62,83,152,24,181,141,141,116,57,252,2,159,70,102,178,233,194,244,152,131,87,62,122,12,60,77,17,114,19,240,99,182,161,146,220,10,216,219,48,58,47,96,19,3,149,235,181,2,141,29,109,146,134,137,63,5,26,95,195,52,179,6,22,21,15,25,83,252,124,121,140,122,131,241,217,205,
196,39,234,1,233,69,113,108,156,248,44,157,40,94,141,199,241,80,241,147,10,148,70,144,197,208,56,30,170,78,33,30,170,46,34,167,144,7,250,124,252,87,60,60,73,28,100,220,114,0,120,88,83,49,52,255,116,47,240,224,81,61,52,11,61,242,83,104,202,79,43,134,17,251,167,85,119,13,186,120,139,141,10,62,255,148,141,147,214,120,85,176,216,12,78,232,33,71,41,158,47,64,255,210,176,163,31,30,68,63,63,185,7,15,192,99,87,46,31,49,254,172,19,250,200,35,70,79,209,106,147,18,248,135,231,136,219,200,210,213,104,192,171,206,122,142,44,230,200,143,146,3,207,242,207,25,199,135,92,61,227,226,143,242,139,234,25,213,146,202,25,249,25,248,197,239,148,227,75,11,228,35,116,50,12,158,252,175,240,250,43,99,211,232,13,251,65,119,86,187,20,158,130,231,49,250,66,14,3,212,159,138,39,150,223,169,75,7,216,76,73,95,230,215,194,79,30,25,168,64,167,226,146,98,52,249,162,64,140,52,253,210,232,179,218,103,145,56,60,163,120,238,228,57,64,189,100,254,162,57,239,192,15,188,226,109,82,23,97,187,133,25,236,92,113,91,49,61,198,
79,189,55,160,58,68,244,83,147,13,188,161,30,195,174,84,159,12,79,253,209,197,85,252,101,160,66,92,149,175,200,39,43,213,219,53,126,167,153,106,252,7,42,240,93,85,254,195,168,126,219,210,241,31,135,214,74,63,81,173,254,244,97,103,245,82,101,167,165,251,12,83,242,149,167,85,254,83,78,210,253,94,171,225,187,151,190,175,118,19,138,185,113,120,190,198,255,251,196,58,119,170,252,255,73,224,7,21,191,32,193,130,235,106,87,102,14,87,175,204,172,188,173,94,101,231,194,234,76,133,250,202,19,166,253,82,227,127,71,97,150,182,60,111,152,181,171,218,51,247,113,206,225,174,140,67,209,102,128,86,46,213,248,207,166,161,108,101,9,10,78,64,81,123,45,127,107,93,141,223,238,196,16,191,173,230,111,77,65,213,213,90,55,10,237,99,55,193,45,117,102,237,175,118,207,127,124,111,156,243,18,1,184,219,160,108,37,11,69,109,80,182,174,214,123,123,119,181,247,246,135,29,80,210,198,180,141,80,135,78,213,215,238,171,68,53,254,23,73,166,110,134,172,9,166,238,175,246,188,254,248,174,214,203,180,244,194,124,53,141,
53,242,2,68,186,198,111,6,177,145,91,153,99,119,148,174,242,3,39,126,181,63,179,146,166,109,178,25,131,75,191,90,190,226,189,136,46,132,132,211,179,37,44,80,16,64,78,159,23,210,74,137,229,119,178,252,159,61,57,37,168,216,193,234,115,14,229,242,93,71,197,114,117,171,87,217,45,0,58,165,50,118,251,224,228,255,54,155,64,56,135,17,206,183,8,6,253,65,90,249,206,190,106,249,14,158,94,185,142,128,74,53,126,244,21,78,127,100,230,165,106,247,220,199,37,175,178,63,128,27,193,115,205,215,11,103,229,123,40,41,67,209,54,79,205,202,65,230,124,3,57,219,106,61,100,207,66,229,227,44,115,214,85,123,22,216,211,115,145,148,17,4,170,21,23,127,223,94,45,83,192,247,122,35,235,175,124,152,34,123,96,8,68,224,28,145,173,143,223,90,2,217,230,42,127,16,134,49,255,215,31,238,49,234,40,30,158,255,48,8,185,24,39,14,137,230,15,178,227,246,167,14,124,14,210,38,29,124,246,148,118,2,237,33,108,137,83,136,11,126,42,102,191,244,241,28,117,174,154,38,135,52,245,28,79,156,253,21,184,45,83,203,189,249,40,153,110,134,
51,54,182,111,118,67,255,202,25,19,174,180,90,166,17,199,61,225,95,80,228,102,232,135,42,110,27,73,199,59,205,130,69,120,129,180,14,241,41,144,176,131,95,100,159,48,191,21,100,31,92,177,109,38,61,255,225,46,79,55,65,124,7,84,188,180,110,129,218,32,69,254,235,53,136,221,12,209,29,16,255,54,96,247,175,19,64,239,1,122,68,52,151,76,1,18,102,95,229,159,23,109,37,110,60,178,202,127,159,173,157,129,155,126,74,8,165,130,72,219,51,66,68,63,101,104,52,157,170,158,169,160,6,82,89,233,121,91,45,250,101,95,53,250,5,148,108,235,250,73,5,253,132,16,133,193,232,105,170,26,17,182,248,94,237,159,233,171,157,147,200,9,35,106,68,68,239,207,87,35,82,46,223,241,237,158,26,191,98,90,43,77,130,107,252,96,245,92,101,119,53,82,104,166,156,233,159,166,215,69,120,228,87,174,107,17,41,173,127,138,181,30,83,110,63,239,53,95,208,182,192,240,45,158,173,70,164,64,109,67,251,49,156,11,149,3,14,39,120,35,74,247,136,126,48,191,100,78,120,237,51,243,209,60,41,250,12,110,164,86,15,127,51,239,40,124,237,129,126,104,
33,13,69,79,160,255,137,104,231,249,44,116,96,204,253,232,36,162,84,137,72,41,253,10,225,108,97,181,190,140,95,173,162,115,149,131,224,217,15,78,158,209,251,227,117,121,219,66,240,235,127,204,3,159,109,79,160,101,238,74,173,31,185,42,181,68,179,103,170,253,148,205,17,169,189,244,170,15,190,196,147,195,199,219,24,224,81,171,104,189,225,189,80,249,175,143,32,218,51,13,144,122,11,133,103,251,169,81,196,56,12,86,246,0,44,5,109,117,11,136,224,121,237,165,32,152,188,25,205,179,119,199,163,180,120,196,222,206,198,136,217,165,133,62,99,64,248,180,184,99,68,76,168,23,182,29,70,142,24,243,18,66,52,141,64,167,9,123,228,188,126,14,171,212,191,136,168,105,250,231,83,38,20,222,237,78,24,209,30,201,20,196,129,91,68,190,50,133,47,109,69,65,167,107,252,116,168,9,39,154,70,9,182,183,2,223,235,168,78,160,103,16,166,19,168,120,59,8,95,7,106,252,215,220,150,127,251,233,1,244,207,119,146,127,17,208,12,124,129,15,33,214,250,151,78,87,251,213,203,33,47,71,212,14,182,62,181,158,120,59,7,111,5,229,211,
199,61,78,176,102,132,199,224,111,27,244,11,47,188,144,91,251,169,35,34,114,107,9,122,76,241,194,141,2,249,25,93,248,6,47,53,185,20,165,186,1,195,99,141,110,232,100,14,65,70,123,193,11,52,57,251,201,201,166,224,25,20,143,19,32,167,106,255,66,191,83,48,249,247,42,77,78,41,254,234,162,228,241,175,215,140,80,121,157,8,141,42,174,81,36,165,70,52,6,17,132,121,21,191,59,94,139,158,167,171,124,218,230,53,122,126,181,198,255,193,96,68,70,108,94,249,175,134,204,58,75,115,242,56,39,124,135,15,198,41,42,11,47,100,161,138,14,204,7,239,185,202,14,55,95,120,159,157,101,62,235,105,163,254,42,182,120,198,205,226,81,158,89,188,24,247,74,133,113,121,146,54,65,5,58,197,242,34,9,64,130,184,192,105,147,9,84,22,254,2,11,167,144,70,24,208,22,121,3,142,249,100,62,222,89,224,36,12,143,100,174,20,29,206,237,132,119,138,65,9,15,28,209,139,94,167,80,241,252,14,126,37,31,214,47,177,89,84,132,145,241,58,126,193,75,227,172,112,95,188,202,240,132,119,24,163,19,63,109,240,189,14,229,236,70,161,24,16,184,165,
80,140,198,156,35,162,137,97,222,72,218,237,167,121,98,138,246,184,137,90,74,47,100,17,12,154,141,137,25,52,33,51,49,104,57,200,115,162,145,154,92,114,16,54,69,74,143,70,151,69,29,39,39,201,136,122,2,218,206,215,164,211,210,51,228,68,241,89,98,211,17,61,219,130,126,75,142,79,209,185,76,74,181,8,197,51,138,58,126,251,183,86,122,194,58,119,112,0,120,41,61,97,252,206,168,193,43,194,70,52,74,35,157,34,216,28,138,76,26,108,253,143,24,191,131,227,222,129,166,71,204,121,170,72,40,220,130,135,167,113,120,26,135,110,139,200,192,208,212,180,8,79,148,143,238,225,132,106,150,0,19,221,187,110,240,78,206,68,66,147,171,224,113,220,95,193,247,43,248,126,222,91,141,126,134,127,10,218,254,95,199,204,70,4,31,225,36,46,66,139,239,75,53,254,27,174,90,233,17,248,111,2,127,147,141,3,205,194,254,123,5,207,183,244,120,2,188,172,107,17,48,91,139,238,99,119,202,58,207,112,68,50,68,116,127,3,242,194,254,197,135,28,145,226,84,206,103,142,40,57,145,57,162,135,60,83,228,125,200,56,13,206,146,244,44,120,163,
71,167,33,130,23,61,4,10,201,85,122,184,69,6,186,69,70,83,80,101,179,232,228,228,240,175,202,135,200,15,237,165,135,192,255,5,250,255,178,11,185,66,235,195,28,240,177,13,18,72,12,55,178,64,62,166,7,54,116,209,45,244,115,139,117,217,44,150,158,74,111,146,141,104,82,243,21,190,140,38,232,100,179,107,89,241,39,236,66,217,144,205,110,244,211,31,234,232,119,176,146,17,155,42,101,74,241,252,23,240,255,5,253,195,111,255,243,162,135,23,253,196,0,120,42,224,231,171,243,56,53,98,29,104,169,69,63,130,255,71,104,102,163,95,98,19,190,106,31,200,201,108,201,203,9,30,74,108,148,163,219,172,115,27,31,16,31,207,254,96,149,130,230,68,156,62,185,56,64,146,96,83,17,9,94,129,121,22,189,41,203,241,47,154,96,83,4,172,138,184,60,167,130,156,32,89,13,39,62,248,45,92,226,89,27,207,246,50,182,203,252,40,207,109,6,21,78,154,147,175,208,100,199,46,56,13,226,121,214,54,92,189,10,222,207,83,86,133,240,221,154,116,130,215,137,81,201,78,201,24,67,174,189,52,203,248,173,108,11,204,194,175,13,93,47,85,82,126,114,
208,209,98,107,168,64,18,254,111,120,198,169,148,170,19,226,70,47,113,179,151,58,186,244,122,131,53,187,215,226,23,46,232,71,54,170,128,122,223,165,170,189,84,77,170,128,242,207,178,70,191,163,231,184,209,174,53,68,143,225,145,237,189,34,81,19,139,242,84,9,226,43,193,191,124,12,249,139,158,205,140,95,113,227,36,220,18,205,41,37,57,100,200,38,189,207,198,173,41,137,31,104,204,154,140,208,99,120,136,75,165,215,106,218,178,209,36,46,9,191,54,218,253,230,255,20,2,84,78,106,184,90,124,81,108,85,62,152,192,174,39,176,107,197,215,87,222,174,85,56,188,39,62,18,251,172,34,4,191,197,47,154,17,209,4,126,51,129,61,32,211,18,77,40,243,3,139,121,177,253,4,241,11,126,157,253,96,167,170,166,94,184,120,103,213,38,126,32,251,76,240,75,254,170,0,127,233,164,210,4,158,196,220,63,173,56,1,157,162,135,38,190,131,133,126,154,23,86,77,178,41,141,238,17,31,169,250,162,123,208,207,166,116,213,143,177,159,36,158,226,199,178,7,154,200,209,93,240,223,149,159,33,39,242,148,112,155,111,210,108,101,46,107,128,
107,30,252,216,178,85,184,79,168,244,158,236,192,166,225,215,55,181,85,49,71,179,196,69,108,156,239,232,64,205,2,240,76,31,129,22,254,126,61,68,158,161,113,6,238,129,55,135,200,47,27,57,33,215,198,217,249,41,55,125,104,178,186,166,35,107,211,192,145,31,186,125,197,8,123,79,126,93,145,99,49,109,28,93,92,210,141,38,107,88,145,235,134,239,115,75,70,57,75,243,184,101,34,126,7,168,198,71,22,88,91,243,120,54,192,102,94,121,89,205,223,145,57,154,134,58,84,160,57,219,63,63,224,224,217,121,140,188,163,73,135,221,14,44,110,96,158,139,151,106,162,141,188,166,9,168,230,23,205,89,126,193,209,240,140,144,223,7,172,25,77,227,14,189,247,207,3,15,111,52,17,105,116,209,244,148,28,196,223,75,87,41,107,55,60,130,61,115,203,1,30,182,129,135,83,125,221,180,193,95,250,133,135,102,147,26,138,253,52,143,68,63,178,97,43,119,138,157,155,227,107,132,60,175,28,206,77,21,120,160,217,61,71,3,114,30,60,175,217,69,136,95,195,207,238,76,141,193,73,197,95,240,217,90,220,90,80,163,2,187,139,11,213,1,114,231,200,
20,113,147,121,138,89,37,109,241,252,169,123,84,193,23,151,55,99,135,25,158,57,125,247,47,81,47,44,97,127,51,28,190,2,23,33,19,120,195,143,212,172,194,79,144,89,196,237,23,43,8,177,131,210,252,9,87,120,47,59,188,86,156,42,78,233,240,228,217,30,120,100,156,91,7,17,141,63,171,61,150,79,130,31,91,210,186,156,230,27,126,237,166,38,24,159,33,150,78,108,2,127,102,181,176,167,57,170,93,84,105,126,51,107,147,175,145,121,196,142,172,68,189,37,159,82,13,194,255,253,101,133,168,104,42,113,232,212,79,115,218,234,157,69,217,1,54,111,177,77,5,61,176,170,209,168,87,204,94,217,36,68,220,22,160,136,181,24,99,133,52,182,38,30,84,104,23,30,146,71,30,82,184,75,191,52,155,74,175,89,95,245,19,252,69,52,242,11,147,108,74,38,169,189,180,185,208,230,99,137,154,78,49,72,245,32,205,70,21,215,113,92,113,245,17,243,228,207,75,212,85,196,57,249,155,58,64,165,165,255,249,7,187,18,163,235,79,188,50,196,118,86,10,229,92,23,67,144,145,141,34,160,33,186,136,67,36,200,17,28,113,20,71,140,175,203,140,46,157,228,
26,19,227,204,25,226,250,146,93,13,34,176,13,209,205,30,34,201,201,96,71,233,102,235,154,11,47,214,24,126,62,109,191,207,187,41,116,219,61,254,251,167,236,202,210,8,193,100,232,62,120,100,152,252,211,117,22,57,163,205,121,15,60,219,198,81,225,127,176,167,170,127,124,135,166,130,135,119,248,117,61,194,205,201,215,70,49,72,112,214,134,110,129,247,214,49,186,250,208,195,233,164,195,47,120,232,132,30,225,31,161,128,24,65,185,163,36,151,161,239,129,255,158,181,73,240,163,207,232,162,139,126,2,249,208,219,19,118,213,43,230,151,78,59,244,48,254,96,55,244,112,101,76,244,204,149,28,60,202,210,117,142,27,224,184,241,156,235,73,56,145,147,21,252,161,68,5,168,161,23,123,171,163,24,197,16,198,52,242,110,140,171,99,226,27,124,24,198,16,39,97,92,37,131,174,62,227,89,14,57,68,194,48,185,210,185,29,125,197,117,75,209,37,60,111,208,219,155,118,187,166,101,114,197,57,116,29,107,136,211,242,33,146,157,174,99,141,44,123,61,224,80,67,115,200,111,110,135,135,47,18,192,128,23,254,103,240,241,12,135,
199,224,70,231,25,23,126,241,193,169,5,87,231,160,95,119,6,208,67,130,31,122,68,251,50,244,112,154,33,218,141,30,2,13,223,193,15,111,4,172,17,112,216,56,167,145,186,162,199,119,174,118,197,244,56,250,5,207,85,65,158,33,111,120,210,53,186,33,93,207,155,222,110,1,124,244,181,151,171,228,195,38,225,6,65,236,198,204,25,127,181,11,156,36,110,155,135,108,135,232,242,34,99,155,55,52,253,199,85,123,122,139,189,154,174,89,11,123,213,53,55,201,124,136,13,152,241,129,46,70,57,213,208,73,19,112,92,57,59,198,85,51,225,222,204,137,211,21,108,128,107,50,156,254,242,10,23,127,235,74,16,207,150,111,120,120,158,81,24,96,91,60,227,122,14,5,128,225,129,151,235,111,185,154,246,118,11,227,155,225,47,23,224,63,194,24,122,51,248,188,135,103,221,55,199,185,134,38,57,105,206,101,198,145,43,52,93,167,48,211,213,55,94,240,98,60,203,181,28,39,239,65,130,169,100,170,235,164,131,232,199,214,197,94,175,227,207,162,95,180,142,46,247,217,184,174,53,141,178,177,51,120,78,175,215,194,139,126,193,247,219,149,32,
217,234,32,126,34,121,234,58,208,32,137,81,215,76,229,15,131,108,112,77,14,208,63,186,204,117,88,100,131,206,25,175,199,47,27,186,78,135,96,16,122,184,6,201,28,112,189,119,114,208,213,162,81,78,73,71,95,239,133,254,173,60,227,58,41,250,21,158,145,133,221,216,34,207,184,5,50,244,254,146,243,15,243,27,236,139,110,139,116,54,202,45,139,196,159,193,117,131,205,238,141,167,103,177,63,201,9,61,47,114,205,78,246,132,141,15,209,102,227,26,175,205,117,246,202,56,197,194,208,155,83,206,246,44,150,97,199,216,132,217,5,183,63,20,247,116,141,83,167,144,226,67,182,143,111,214,110,80,148,223,152,224,26,30,126,97,241,114,233,178,217,184,249,53,137,145,79,232,102,253,73,230,177,190,93,115,158,193,239,56,209,211,184,217,127,236,23,208,229,124,2,120,110,121,136,38,249,158,243,59,249,28,184,150,124,220,144,159,114,202,109,241,24,157,140,114,250,109,116,129,107,200,252,11,122,144,177,193,19,159,184,166,91,27,122,130,223,209,106,179,120,204,173,153,132,15,78,147,134,56,225,114,244,19,47,21,151,20,
55,238,226,119,119,129,95,224,106,41,29,45,249,53,239,25,113,139,235,132,221,224,226,245,48,104,114,254,171,155,93,55,233,8,221,68,118,186,221,149,140,3,127,147,130,74,87,26,153,203,205,43,23,71,111,34,191,49,236,64,55,189,110,46,111,229,249,101,139,15,55,225,57,190,1,118,115,137,98,10,126,21,151,198,176,241,155,11,223,86,111,146,88,199,40,152,70,22,10,166,3,163,71,248,201,85,99,92,71,187,41,252,200,224,38,186,27,163,35,55,38,255,71,14,55,209,155,100,105,248,177,143,239,176,143,239,104,89,42,222,140,209,76,185,185,228,174,139,66,191,173,245,221,3,158,63,72,243,12,250,204,30,156,253,220,132,22,126,225,128,91,98,103,185,37,134,78,208,225,119,224,184,185,0,253,194,175,231,248,196,216,219,78,158,243,108,185,157,103,91,88,39,166,87,215,163,152,79,75,84,55,228,190,51,154,161,113,249,146,241,41,126,192,199,243,115,60,19,79,146,63,52,232,122,184,248,226,153,155,127,12,190,54,219,218,99,196,142,155,146,31,246,117,19,221,141,97,27,223,189,227,6,30,126,250,29,254,113,147,2,104,228,93,129,
184,142,61,179,1,29,225,154,176,252,102,116,98,27,113,158,120,138,204,205,206,185,17,55,244,134,252,196,105,221,200,82,137,252,128,29,40,230,204,225,175,108,102,120,179,151,124,193,245,105,116,173,171,166,163,51,157,228,107,217,13,237,111,174,247,219,184,224,57,237,149,92,71,95,249,113,226,129,249,210,12,133,48,185,108,116,230,27,226,174,243,111,203,9,175,143,50,127,131,243,47,78,171,71,169,55,204,94,185,77,49,52,75,126,34,7,142,188,34,15,41,78,227,115,67,211,228,57,252,119,148,58,100,132,2,214,198,121,54,68,71,113,136,130,103,132,174,226,40,27,8,91,147,218,98,136,2,89,87,148,237,122,63,27,56,213,14,178,41,197,123,201,214,226,7,121,212,236,94,113,197,231,57,147,17,120,84,251,216,107,11,156,18,114,165,156,98,22,252,20,248,138,125,230,159,228,19,87,11,64,19,241,114,148,230,9,87,163,107,67,119,200,151,119,160,145,57,163,227,222,175,228,159,211,59,160,31,185,145,71,149,95,145,173,241,176,154,127,24,103,67,210,156,30,240,139,126,230,12,113,203,140,186,3,29,66,19,45,114,139,47,200,
223,213,1,172,171,120,193,237,26,171,175,216,216,169,86,178,218,234,1,121,145,83,78,243,127,236,109,136,66,242,6,181,196,13,228,166,220,59,66,190,27,93,74,81,7,33,111,54,109,55,216,180,13,221,97,157,59,123,170,55,168,35,70,158,31,226,10,122,15,183,24,161,67,250,86,44,196,158,85,51,234,10,188,116,127,3,123,189,193,38,64,114,176,90,138,77,223,208,93,201,2,24,78,126,111,112,234,174,249,154,43,28,67,239,185,78,106,113,67,115,15,128,135,235,168,52,223,180,97,185,65,109,53,202,213,235,161,39,60,123,69,158,100,163,63,50,115,205,230,242,147,10,78,7,239,89,159,211,127,116,98,124,223,192,31,84,247,221,192,94,116,251,97,232,1,243,31,48,111,242,80,245,134,106,152,169,139,230,79,70,131,98,255,75,230,211,81,215,101,71,211,11,113,220,248,103,125,214,173,221,152,134,126,214,31,161,134,187,65,125,58,106,175,89,200,79,117,117,248,52,249,85,87,218,21,223,34,203,151,215,104,28,140,177,193,188,6,78,229,203,49,244,163,124,169,107,198,99,108,164,21,115,148,147,175,81,215,217,117,101,244,57,54,7,30,
98,202,53,26,1,99,52,150,237,138,177,135,87,190,215,235,2,99,139,125,181,49,112,131,151,117,186,12,63,127,179,70,126,21,158,235,226,138,193,110,14,240,248,147,93,99,230,84,92,248,199,240,167,107,216,111,130,159,219,127,9,254,183,192,99,15,134,255,237,105,135,159,219,28,215,223,102,45,46,186,57,170,63,68,251,54,232,225,117,0,244,12,78,174,56,159,178,107,240,215,216,240,141,113,251,70,175,33,192,39,124,51,46,250,209,207,24,141,131,49,244,114,141,88,116,157,60,165,235,241,215,104,198,142,77,229,76,62,130,191,6,188,201,210,100,212,239,232,7,255,181,233,147,213,107,156,136,232,181,18,225,31,163,150,0,47,240,162,95,242,7,63,183,243,198,76,54,140,191,64,62,47,184,162,76,14,24,123,73,157,4,252,53,221,0,134,223,177,183,237,188,66,161,250,35,34,94,74,62,192,19,63,248,180,184,121,141,219,97,196,239,4,191,232,185,78,156,29,123,11,60,49,69,215,236,175,209,192,184,70,93,112,157,24,53,54,93,242,182,32,126,177,87,154,184,163,52,122,157,92,101,23,87,236,117,169,49,124,234,218,125,244,195,166,
241,58,114,186,198,62,199,217,144,214,138,245,176,5,248,75,181,49,236,246,154,94,97,129,143,235,248,29,223,171,99,147,185,85,189,189,143,225,145,159,248,32,182,95,187,15,60,113,234,58,249,237,218,125,198,105,0,218,149,116,228,234,248,102,93,114,218,53,244,108,58,166,65,49,54,143,62,105,80,40,87,94,123,73,93,135,222,116,125,222,217,41,186,71,111,130,87,141,102,180,210,144,188,118,219,221,240,190,174,70,16,177,84,113,112,224,253,202,79,214,65,176,139,201,11,255,177,207,181,22,144,198,64,101,10,175,116,135,180,156,199,222,240,61,4,77,91,233,247,79,216,168,86,254,207,123,138,195,117,181,44,130,47,82,28,232,13,52,126,96,165,154,125,123,169,54,72,16,214,187,7,89,186,83,217,95,184,129,140,98,7,217,132,234,202,83,145,37,248,217,83,142,227,215,87,179,56,92,81,197,47,5,64,145,68,152,29,63,89,229,127,61,226,138,84,91,53,59,206,56,5,101,22,5,22,17,94,145,238,218,32,137,48,59,29,213,6,113,192,34,255,178,79,78,85,249,172,14,34,144,236,147,254,90,22,28,162,169,72,209,157,208,195,93,252,65,225,
96,163,152,253,229,116,181,136,50,7,9,10,217,95,84,236,51,38,92,6,175,162,27,250,231,46,114,200,205,24,202,201,254,124,166,202,39,7,222,192,255,76,49,46,122,112,136,226,155,211,85,62,161,135,67,240,55,224,33,240,100,233,232,22,41,22,245,143,239,142,95,241,132,17,21,41,110,196,23,63,73,207,213,50,240,192,47,63,175,207,187,22,224,199,193,179,156,223,14,114,172,54,72,146,42,162,184,44,167,45,124,114,69,141,103,116,43,196,111,246,1,207,184,50,151,125,192,219,126,56,226,32,73,167,136,242,115,252,227,125,149,42,159,200,136,192,79,208,209,251,23,57,37,53,146,102,14,67,44,106,147,78,151,63,135,161,72,254,238,29,21,201,126,125,53,135,177,168,120,200,145,56,138,111,206,84,115,20,232,67,4,181,226,155,222,90,14,103,51,120,222,181,200,17,24,5,175,119,105,128,33,8,243,108,174,19,249,147,248,209,99,78,248,161,157,192,206,28,183,201,203,177,185,41,114,165,144,119,70,160,69,52,117,58,122,94,146,64,232,38,26,253,56,249,16,235,42,153,229,248,87,196,57,134,72,202,69,108,40,247,120,127,53,247,24,
251,129,223,161,241,2,23,8,24,167,184,76,232,199,57,114,111,224,87,56,8,58,185,41,240,16,112,138,4,193,220,20,244,19,28,237,117,201,247,200,153,128,160,164,149,123,115,213,222,151,25,66,158,57,156,59,135,227,41,217,20,57,143,95,133,71,254,216,51,127,51,199,201,211,232,127,132,156,57,209,112,242,204,146,72,219,106,252,2,44,29,245,83,85,126,17,150,110,52,69,23,23,246,203,216,26,87,151,72,196,208,67,50,230,111,174,50,69,14,22,154,120,63,195,174,15,151,9,130,67,200,191,44,250,73,250,249,113,54,9,216,85,153,117,243,227,140,131,159,119,74,236,221,165,1,130,196,0,155,36,189,115,201,123,34,172,119,165,86,198,230,134,56,205,201,223,226,138,214,45,100,244,112,71,181,60,81,180,121,42,240,242,111,193,7,207,90,39,79,48,44,115,146,3,175,181,252,93,214,39,193,139,239,50,87,207,180,142,193,99,71,121,240,187,57,217,90,89,9,21,189,229,31,29,176,107,235,101,222,167,26,122,193,187,84,216,117,89,248,73,10,186,186,85,126,143,108,41,190,202,216,145,222,185,204,115,26,165,171,205,42,252,202,115,232,
147,24,97,114,194,111,116,109,90,178,26,130,30,217,144,174,134,149,241,3,93,107,211,123,136,101,142,167,133,159,142,60,107,236,5,247,46,186,243,20,191,188,59,195,59,153,181,50,9,53,255,156,142,61,126,92,126,121,132,205,217,197,90,22,249,153,223,211,21,149,15,100,145,223,32,201,93,49,72,190,159,125,120,160,154,125,168,56,196,248,52,155,118,252,44,75,82,40,82,12,88,156,96,67,146,101,93,139,43,140,103,159,236,37,158,96,19,188,147,53,72,115,72,215,82,93,220,58,65,204,210,219,182,108,242,185,163,161,107,175,206,191,89,151,130,140,239,196,4,226,22,240,89,130,117,18,87,132,31,57,24,188,98,11,250,47,146,188,248,175,36,128,119,155,234,172,249,166,226,22,176,60,227,247,101,238,212,114,114,50,152,142,94,30,51,39,200,33,160,136,99,159,156,28,68,199,157,79,48,96,29,65,138,88,2,160,28,36,66,112,69,178,187,94,212,210,49,112,142,0,85,68,200,4,130,90,68,53,25,209,245,34,56,84,139,79,243,224,21,44,142,64,91,54,7,3,54,135,182,180,112,231,168,164,34,2,108,196,81,106,142,127,197,39,145,221,51,200,
225,104,69,20,47,167,204,81,213,71,56,14,151,63,76,216,185,169,20,142,199,186,100,192,162,28,156,96,25,201,49,169,234,225,197,90,163,69,218,203,142,30,225,63,9,45,224,16,253,79,115,70,15,129,6,92,93,142,30,130,81,196,46,64,114,160,61,10,93,188,200,166,163,221,41,222,174,121,89,182,177,28,221,194,226,20,244,176,110,142,110,97,4,254,136,108,156,147,160,105,43,231,248,87,68,208,17,199,119,162,19,250,192,143,35,27,157,200,129,187,238,57,224,73,12,204,227,88,148,42,65,73,34,231,225,139,56,77,142,23,57,129,113,120,184,187,43,250,117,132,151,163,155,144,35,216,71,116,22,138,79,163,90,14,227,81,251,184,200,157,124,201,70,52,69,220,197,53,122,20,96,95,112,156,66,27,62,199,46,94,235,10,54,135,126,139,180,127,141,126,58,109,17,23,114,100,184,92,57,32,208,114,108,2,237,50,220,156,232,196,168,12,255,12,244,43,72,211,81,51,120,120,146,28,34,238,60,231,232,164,25,15,236,26,12,183,112,193,175,46,232,24,30,238,220,26,61,38,7,228,195,5,34,214,51,249,228,176,29,221,37,41,190,196,16,49,244,28,137,
85,250,149,13,98,123,204,35,17,200,6,37,11,5,76,241,43,221,79,59,252,216,6,193,17,123,19,61,178,91,201,77,60,9,158,170,177,8,188,173,193,125,25,62,45,249,69,36,244,156,100,134,14,162,103,93,240,187,1,30,192,195,187,59,10,126,145,130,13,119,128,203,216,20,255,183,1,129,12,121,114,204,92,86,32,155,32,208,72,254,28,223,151,31,0,47,251,7,87,89,252,18,124,242,111,182,48,143,227,4,193,130,191,124,31,120,104,137,72,162,229,251,145,193,151,117,201,138,106,82,237,247,60,29,188,242,100,47,239,30,0,107,254,5,60,47,220,202,62,203,79,8,148,216,8,239,114,152,60,121,127,201,100,90,230,142,171,228,105,1,139,192,87,70,95,58,78,148,189,57,88,232,159,56,78,96,110,55,248,60,129,38,82,176,7,79,153,59,210,124,178,118,59,73,194,29,243,234,184,162,76,55,158,224,206,113,5,73,5,251,23,110,201,185,236,241,75,151,121,10,0,249,68,25,187,202,211,125,22,158,178,244,72,53,172,227,98,5,251,136,132,162,139,99,121,5,86,238,108,59,122,120,70,55,74,244,151,37,11,236,138,121,134,63,79,129,161,128,30,241,158,79,249,
69,143,21,89,196,16,244,76,124,144,175,99,15,69,118,59,42,0,34,21,48,178,79,238,14,81,60,152,61,155,30,165,119,142,103,116,236,41,127,148,157,72,183,138,89,209,61,238,98,221,35,254,112,117,162,56,73,28,147,173,9,158,119,172,44,158,200,158,159,99,15,42,166,228,143,15,192,79,146,202,201,191,144,51,137,215,173,253,20,190,72,24,42,86,138,248,151,252,69,5,76,196,29,245,156,236,132,130,173,40,63,197,135,156,159,18,232,25,115,190,234,232,65,46,181,28,239,94,229,120,71,67,50,146,189,9,191,100,154,195,158,93,44,17,126,37,18,197,0,112,113,71,58,34,222,230,184,159,93,164,224,49,218,209,101,142,221,154,236,220,252,81,241,13,218,197,131,226,179,108,39,135,44,138,232,183,40,88,240,71,90,23,123,227,111,248,37,94,17,107,69,107,142,119,222,20,155,249,27,122,57,238,166,0,203,170,152,230,221,129,226,228,142,106,47,71,106,217,153,11,174,216,196,78,122,41,120,20,171,178,200,167,119,42,170,245,178,59,86,177,149,125,121,220,37,170,151,91,170,189,236,142,123,233,66,72,70,89,244,37,95,239,165,19,145,
69,62,189,74,84,208,84,156,34,177,209,41,81,12,234,165,43,194,17,189,75,108,208,163,164,214,75,225,93,228,122,76,175,18,39,120,20,63,249,4,214,233,189,151,93,5,255,223,19,60,156,174,246,210,165,201,18,227,138,20,22,226,169,87,69,51,126,93,100,231,168,132,215,203,41,149,193,227,95,197,39,199,128,223,64,76,135,135,39,92,103,96,131,96,120,176,207,34,56,224,7,92,192,67,191,195,191,31,218,145,129,228,47,249,136,126,139,171,224,135,30,71,19,244,75,110,54,206,177,63,133,43,223,77,95,124,247,120,142,51,222,238,233,244,240,232,172,56,113,132,241,175,224,25,252,19,57,135,95,249,133,248,99,248,167,145,231,50,242,140,229,131,255,58,249,128,31,251,76,228,243,252,40,112,224,209,186,26,55,122,132,159,241,249,141,140,123,252,226,55,148,39,252,42,47,244,106,131,32,121,114,100,152,157,236,168,246,190,222,136,60,242,224,17,45,122,134,126,21,83,95,108,3,223,101,179,183,44,5,127,47,133,55,87,27,170,89,21,253,242,23,108,193,197,91,252,17,95,180,152,203,238,26,217,90,126,140,232,50,231,116,189,234,
73,59,248,157,157,91,110,224,20,202,252,200,219,185,98,143,109,16,56,253,202,241,30,160,100,161,184,97,181,0,241,54,82,61,64,188,85,252,143,200,47,86,183,216,184,242,62,248,137,41,69,242,154,229,118,229,114,186,3,162,71,245,70,142,174,160,226,137,248,138,148,199,193,173,120,18,77,229,45,95,232,58,76,246,77,151,21,117,218,44,233,58,73,47,177,211,228,128,94,122,137,75,38,79,186,84,146,179,109,12,231,145,15,185,162,72,225,40,249,24,60,244,100,167,177,55,222,243,200,106,109,78,57,13,30,255,178,113,213,63,196,159,172,198,137,73,166,151,41,236,132,99,102,195,79,254,50,189,203,174,166,142,153,175,100,95,224,147,239,46,57,60,216,122,150,119,244,84,107,152,205,97,63,20,121,108,208,136,41,108,16,116,125,195,54,105,111,185,82,125,78,201,197,42,251,182,218,217,187,251,170,103,239,242,43,37,84,222,140,85,207,61,185,92,59,167,103,48,30,205,113,14,77,50,57,71,43,136,255,153,193,238,243,217,56,215,199,35,187,201,220,174,123,123,255,247,226,186,177,31,94,77,242,115,105,247,244,51,50,15,31,204,
205,185,255,219,227,63,142,173,251,183,77,83,235,254,109,203,224,167,142,127,251,229,208,191,46,126,62,202,207,211,125,58,90,249,248,248,115,23,87,183,63,117,85,118,127,78,113,201,251,83,170,146,250,124,142,223,122,255,116,174,114,246,243,121,222,50,254,116,190,210,247,153,59,237,251,63,93,170,164,53,242,13,35,39,5,115,21,152,173,154,117,149,89,219,132,39,15,158,246,24,207,25,193,28,3,230,152,102,29,101,214,113,225,201,129,103,227,103,254,195,223,51,159,46,84,14,233,81,55,143,246,10,248,60,192,251,62,159,21,61,103,161,231,76,101,229,212,167,51,149,111,62,159,230,58,54,232,55,126,226,203,25,150,232,20,76,47,48,29,130,41,243,124,61,112,43,5,158,183,137,140,118,96,138,250,82,130,150,237,252,177,178,15,10,143,106,137,60,75,108,208,162,101,104,217,200,194,43,57,254,218,9,77,144,122,190,178,71,48,154,181,9,184,149,179,204,218,173,145,110,254,218,43,145,13,124,62,201,90,124,41,176,104,199,167,147,34,131,213,69,79,9,90,54,66,19,8,61,61,167,120,116,240,243,41,73,245,20,82,133,140,28,180,
108,144,124,202,204,216,5,246,149,115,204,216,248,57,205,127,127,252,41,93,57,162,181,134,89,235,99,62,166,126,147,168,255,6,72,123,86,228,89,155,168,191,10,173,219,36,205,11,80,190,91,35,25,70,182,107,190,132,184,87,107,28,96,86,58,198,179,81,120,114,60,223,169,85,15,1,115,64,179,114,204,218,40,60,71,193,115,188,78,43,87,108,9,16,158,6,248,144,56,236,134,214,189,146,248,69,164,189,71,90,185,12,135,219,181,132,248,49,82,47,3,179,73,48,89,96,54,9,166,100,90,65,10,71,145,194,113,7,140,88,69,143,40,252,90,52,159,97,137,131,162,167,78,43,199,165,149,29,144,97,58,40,0,99,182,117,134,89,135,52,203,73,67,202,64,35,27,208,12,58,192,2,164,149,43,44,186,77,52,247,197,244,116,67,79,167,232,185,192,163,221,210,202,41,232,249,38,150,143,209,115,137,25,95,75,62,223,48,107,171,180,114,22,173,24,133,69,30,181,67,193,74,17,209,154,154,123,1,220,32,132,123,64,120,41,198,35,211,67,44,242,7,128,47,48,195,180,35,57,127,37,57,151,224,242,176,248,58,205,243,175,24,93,201,130,176,67,152,187,152,181,
47,198,99,244,92,4,230,176,232,57,197,44,91,253,2,51,118,9,79,15,56,118,72,95,231,240,162,78,137,46,226,81,135,22,117,110,9,239,229,216,34,83,240,190,79,164,202,88,59,180,196,183,144,217,37,249,200,106,143,194,45,92,156,1,51,48,121,96,218,37,159,78,228,211,29,211,99,246,35,10,15,104,9,167,11,22,149,29,110,21,61,101,72,48,47,234,225,249,86,241,117,21,190,204,139,78,27,95,204,186,2,151,91,99,47,218,34,47,58,141,174,118,106,81,25,73,226,69,123,69,207,9,232,217,182,74,51,244,92,133,30,139,50,125,16,191,89,22,46,171,219,38,249,40,94,152,23,109,71,95,87,68,161,252,252,227,176,168,63,13,244,65,65,159,3,114,191,158,93,226,217,78,137,236,34,116,238,17,245,151,145,230,118,141,156,98,228,27,193,56,90,153,165,136,120,70,120,174,130,199,162,157,240,116,10,38,177,90,249,222,14,225,185,8,158,93,210,74,132,86,58,234,180,34,224,122,47,106,131,67,197,174,149,35,48,111,142,113,158,37,44,254,245,27,63,161,167,237,7,230,172,180,34,47,58,33,122,174,196,244,116,66,207,57,209,115,145,37,204,218,210,
208,115,64,244,156,134,30,243,171,3,140,164,5,147,1,102,155,164,113,138,89,198,169,147,6,202,40,227,65,27,165,149,19,104,229,160,8,59,202,162,39,100,37,137,23,157,175,183,36,232,233,128,158,72,244,148,193,122,24,154,72,20,41,196,203,172,179,112,113,64,94,212,131,86,118,105,245,18,195,155,161,0,209,249,0,127,37,86,243,86,214,186,10,158,5,80,252,143,45,138,32,251,121,116,86,95,114,124,249,74,238,125,4,194,142,127,62,161,24,119,2,65,29,227,39,143,63,29,99,117,190,12,32,155,175,249,99,229,107,232,9,76,234,76,101,154,217,127,6,205,60,159,163,96,185,7,146,54,144,76,129,227,38,83,39,152,117,235,115,119,229,218,167,238,202,18,127,63,224,239,251,124,126,16,58,133,178,41,38,126,47,58,218,249,82,16,29,5,80,180,139,142,8,28,29,192,222,2,116,156,79,56,61,6,167,136,37,13,25,22,110,190,133,175,46,102,255,204,228,113,97,57,192,151,52,114,184,135,64,54,33,134,59,200,227,87,214,255,112,15,2,62,182,9,75,30,44,27,4,219,3,236,78,73,240,28,18,236,4,8,29,119,163,99,96,178,158,58,56,39,68,1,183,114,
134,231,237,192,33,130,238,202,105,17,81,98,100,59,132,172,92,249,124,145,116,163,233,159,123,208,49,255,99,102,215,167,30,2,27,143,186,121,190,87,152,203,192,236,142,97,54,9,102,31,48,167,180,150,11,36,124,233,103,157,54,209,115,145,117,118,107,86,15,51,118,198,48,29,208,180,210,199,243,45,162,231,52,48,59,5,179,29,152,43,49,61,27,69,79,158,181,182,105,173,203,172,211,6,77,48,216,131,115,122,154,13,38,23,210,99,52,239,1,230,236,231,35,162,231,20,75,240,229,60,200,58,92,36,64,62,216,29,38,146,198,21,121,212,199,243,77,66,152,5,198,162,69,158,231,237,34,254,146,17,207,163,34,143,218,68,225,0,107,109,22,61,41,232,217,41,122,186,89,171,179,142,158,11,60,223,14,28,192,144,10,220,50,32,231,98,214,119,138,117,197,217,14,173,16,177,66,135,16,159,97,210,193,24,102,171,96,100,240,38,194,18,48,182,248,97,96,18,117,237,145,120,46,178,76,135,200,233,101,169,221,82,197,5,214,90,15,57,143,121,92,61,44,132,147,32,147,191,172,44,225,48,167,100,44,101,134,15,130,189,151,39,213,203,0,127,216,6,
244,94,76,237,131,236,236,160,99,148,24,10,230,187,194,211,201,132,15,199,192,209,206,140,15,27,192,115,72,120,74,12,119,128,167,44,60,125,194,115,20,28,242,243,15,235,204,163,77,96,167,168,131,248,50,206,240,199,253,8,28,68,39,160,21,201,47,227,20,150,96,203,12,111,229,57,74,57,82,249,248,147,48,29,230,207,141,162,168,19,76,91,99,138,190,2,211,11,158,84,119,136,162,163,80,180,151,181,87,222,66,81,103,204,153,156,143,36,117,172,242,113,82,136,142,129,164,157,41,31,118,128,200,172,76,17,160,29,68,127,181,225,69,217,64,158,117,205,79,47,26,73,152,71,25,237,108,149,157,116,153,13,0,35,91,106,19,217,174,234,147,193,0,179,59,182,37,207,136,60,139,71,178,129,93,178,129,18,138,105,151,98,228,71,86,227,149,97,198,96,138,60,223,33,209,244,0,179,94,48,135,129,233,130,51,102,81,131,136,179,52,204,172,151,161,244,67,198,70,137,33,203,140,77,130,185,200,115,43,125,93,1,21,26,211,89,96,14,64,46,52,99,85,162,231,24,35,155,99,122,182,107,45,249,217,6,214,163,214,235,118,194,239,229,185,4,12,
95,222,247,143,240,252,136,228,83,2,184,67,188,43,104,30,141,253,104,111,204,251,46,193,92,224,185,23,130,106,105,22,205,64,120,135,96,14,65,252,183,49,61,198,251,21,214,217,18,211,99,242,233,103,173,13,130,169,243,181,132,30,147,207,89,96,246,199,242,217,40,249,244,33,31,115,213,171,44,97,102,146,196,61,197,162,77,49,140,201,176,23,24,115,182,147,172,158,208,179,73,164,246,67,75,18,103,214,195,63,226,197,163,68,207,67,158,127,60,226,236,157,194,82,214,85,32,115,31,80,118,58,102,217,155,47,61,252,181,43,134,57,35,152,131,192,88,181,118,9,152,77,171,89,151,71,101,254,146,255,17,248,206,161,93,170,128,190,24,38,203,200,102,225,201,27,99,164,214,50,70,110,251,153,110,140,220,242,85,15,137,34,89,107,167,240,244,128,99,167,232,73,199,120,2,122,40,188,221,90,73,5,126,2,46,136,7,125,216,250,70,173,117,141,231,191,64,211,135,141,224,56,44,122,206,130,231,107,61,82,160,90,208,35,21,149,223,174,62,66,244,25,100,107,85,86,15,200,140,158,34,192,182,173,42,48,178,65,122,82,132,233,80,254,
115,126,197,162,151,12,24,190,142,195,197,81,45,113,139,89,255,164,37,14,178,196,38,150,184,193,226,7,62,95,252,237,192,167,139,191,253,65,16,71,128,88,105,19,136,4,250,181,168,56,1,204,17,33,86,33,191,17,70,48,99,246,28,224,92,57,15,224,122,124,157,130,236,28,225,18,123,62,141,186,15,50,234,181,196,35,205,50,24,73,54,203,26,31,142,241,188,83,235,188,101,214,94,45,177,137,37,250,181,252,33,134,187,84,229,168,180,178,58,247,8,76,88,121,113,156,149,143,9,166,23,24,171,169,85,90,237,137,41,252,150,210,106,129,202,234,134,12,234,40,6,101,251,218,83,140,152,148,175,178,194,86,209,229,118,98,160,185,10,26,27,57,14,154,163,66,211,15,140,237,7,148,76,214,51,211,18,142,249,253,0,28,219,118,86,69,215,70,225,113,165,35,28,43,252,236,230,241,138,54,32,57,17,232,10,4,20,160,224,239,55,96,170,90,146,218,132,71,218,116,110,20,163,231,97,84,251,183,251,159,83,11,39,63,165,22,10,32,55,67,59,18,11,199,109,38,160,166,13,146,202,98,79,241,237,176,74,201,243,140,236,19,233,23,32,221,54,100,142,44,
86,234,69,92,29,90,224,36,11,28,17,125,151,44,40,67,122,4,230,45,82,150,35,157,17,87,164,2,83,0,166,125,117,86,40,237,68,76,174,140,246,34,56,40,134,183,34,202,43,74,123,251,225,170,91,124,158,102,245,131,26,137,24,177,194,209,57,25,179,206,177,250,126,209,220,11,205,166,71,55,146,172,5,205,219,161,57,163,233,101,144,173,7,5,218,58,225,240,56,195,7,79,25,28,230,244,226,61,177,7,211,86,1,122,218,63,31,150,38,14,227,46,223,74,181,223,34,110,202,232,1,84,210,166,122,90,173,8,75,104,135,64,191,79,92,56,204,8,65,197,219,54,4,65,200,73,91,170,6,143,242,25,48,46,66,240,69,27,152,253,140,172,67,142,150,88,180,149,53,195,112,219,48,248,83,43,197,92,193,85,106,144,220,5,204,1,177,53,0,91,95,137,173,20,108,237,214,136,219,101,32,57,69,10,219,162,159,65,6,182,55,73,244,150,67,114,95,73,111,105,76,206,54,59,218,107,41,144,80,178,169,239,130,228,186,153,101,233,249,2,107,153,69,148,120,110,129,47,15,61,237,171,166,11,19,42,123,182,198,244,180,137,30,213,206,155,52,162,173,238,37,113,236,10,
126,150,56,12,158,211,210,155,226,129,188,109,101,47,214,119,190,206,221,206,49,210,41,152,139,192,216,234,206,214,192,163,232,102,219,212,173,224,185,42,152,12,48,219,99,43,182,48,112,158,17,235,57,105,150,111,35,65,15,51,97,80,132,17,230,74,132,57,11,124,3,80,183,67,52,247,32,4,89,32,133,89,218,69,154,20,122,179,118,212,97,196,98,101,88,196,115,219,99,119,50,163,91,124,93,98,100,167,164,113,150,181,14,136,30,37,15,219,198,187,182,11,126,118,16,63,59,35,10,51,240,181,93,48,73,24,113,30,131,190,10,16,102,30,163,16,177,25,233,195,169,140,5,204,46,193,132,126,166,181,190,150,47,186,62,25,192,135,153,113,90,244,148,152,209,34,81,165,108,22,48,74,102,73,82,52,219,79,65,179,173,229,98,161,199,179,87,210,80,252,176,109,175,243,51,184,232,128,139,62,233,75,249,223,26,76,137,190,92,140,129,102,167,175,132,66,118,223,174,133,193,116,117,19,54,130,2,93,168,169,1,204,85,56,221,170,13,117,15,35,59,37,40,193,180,11,38,207,136,245,14,52,210,1,28,192,231,81,28,143,92,175,241,114,165,242,233,
114,101,240,51,255,27,99,223,167,12,186,189,44,221,94,102,18,32,125,160,216,44,196,242,255,13,76,92,249,3,98,254,151,30,133,22,183,189,67,116,87,17,221,86,145,209,16,180,128,41,2,221,38,119,200,2,179,89,48,121,72,216,160,145,75,140,236,18,158,124,172,184,160,205,113,218,54,127,136,238,52,241,21,152,146,225,193,198,84,144,110,149,177,169,63,101,29,25,245,17,15,75,113,46,216,32,186,196,241,165,166,195,40,134,10,142,215,213,99,229,158,52,165,96,68,123,24,37,20,40,104,49,93,150,185,69,107,137,230,245,162,80,251,241,118,176,27,205,198,69,196,95,150,218,19,222,21,82,58,4,35,23,182,6,92,138,226,207,76,203,217,60,34,43,153,10,144,102,100,210,244,250,218,166,69,235,130,232,118,209,179,3,122,204,83,206,130,240,107,209,51,12,61,255,252,155,190,29,227,219,127,59,166,232,57,66,228,252,152,213,183,171,124,219,170,109,247,33,182,221,167,69,182,43,50,168,64,35,40,177,120,236,60,139,145,139,140,236,22,140,83,25,179,14,219,44,133,97,240,180,9,207,1,70,206,2,83,129,171,1,85,189,242,39,235,35,101,
248,203,186,79,71,64,99,85,153,147,7,147,54,50,41,167,112,117,14,221,236,215,172,99,192,88,79,217,45,126,158,205,217,249,202,29,185,174,11,73,200,69,6,189,69,254,153,180,147,68,223,30,113,117,9,106,118,138,154,78,16,159,19,197,46,19,129,88,45,191,211,178,36,231,186,140,156,103,100,175,96,212,226,110,103,150,154,24,15,52,160,170,209,58,4,234,31,127,43,59,86,83,107,183,106,240,43,236,7,44,232,93,66,41,59,53,114,158,145,125,130,41,89,248,226,75,134,89,214,101,43,130,199,182,165,234,213,88,115,76,173,169,77,224,34,200,168,97,10,201,106,179,106,113,76,148,69,161,192,44,220,68,122,150,191,14,172,210,99,102,124,210,21,36,125,60,106,251,124,92,206,120,156,156,2,158,87,224,249,184,67,208,119,64,61,4,45,31,14,176,170,245,203,58,89,209,164,241,128,71,34,243,195,238,152,32,215,107,100,254,47,204,191,6,29,204,58,201,44,240,92,140,73,156,225,81,143,72,124,196,35,245,232,125,77,2,65,79,209,155,122,173,31,190,69,152,150,156,148,228,54,74,165,227,241,163,163,60,82,69,250,140,39,63,105,246,36,
136,175,214,17,40,222,183,67,228,135,19,60,250,235,77,241,115,130,69,191,213,162,50,181,83,154,118,150,103,7,100,35,58,65,176,84,228,74,26,70,214,26,232,113,102,29,21,158,12,120,182,11,207,183,140,156,20,30,133,236,83,194,147,184,156,186,108,237,138,113,23,192,92,111,161,146,134,245,251,251,97,103,163,102,37,157,74,37,102,59,55,216,9,229,151,101,162,174,138,67,187,13,109,99,102,57,167,130,30,53,4,219,161,137,213,79,146,228,160,231,28,244,116,10,115,143,173,14,25,162,39,241,24,139,86,106,189,203,93,223,49,233,186,38,73,139,22,100,148,43,247,59,243,187,72,120,103,241,46,12,242,107,69,225,18,230,233,219,199,138,234,216,106,129,89,199,5,179,223,76,3,60,218,187,27,158,2,56,172,209,37,5,155,137,42,25,246,72,132,34,185,83,36,167,89,221,114,183,220,213,26,57,17,225,212,140,197,69,6,212,158,229,209,102,201,187,140,121,110,96,2,233,230,56,254,202,244,175,192,145,197,16,238,243,135,178,223,79,124,223,42,188,251,248,99,245,152,237,251,255,173,99,182,199,175,230,167,116,206,246,105,221,151,
83,179,235,254,215,186,117,255,190,169,178,238,223,183,12,110,251,253,212,236,202,21,198,226,47,51,124,153,209,200,4,95,38,86,174,126,233,250,109,221,23,44,238,75,79,101,235,239,169,202,186,223,187,126,107,251,157,124,249,239,191,44,28,249,146,2,40,53,209,245,37,117,151,207,187,124,62,230,243,49,159,149,117,95,210,139,219,126,79,47,174,99,14,127,131,53,53,195,231,77,62,111,242,57,206,231,120,215,151,174,183,109,192,110,253,157,79,224,78,126,73,205,49,62,199,243,123,124,222,227,243,5,159,47,248,20,62,158,165,231,60,190,120,221,103,60,127,198,243,39,124,62,1,223,146,199,183,212,128,207,175,151,138,225,133,111,25,124,203,30,223,20,243,167,192,243,128,207,7,124,198,244,189,247,248,222,123,124,241,252,105,224,166,129,123,206,231,115,62,133,175,2,62,228,99,252,242,189,217,103,23,114,116,176,240,92,105,243,240,213,215,95,186,12,193,250,47,61,139,91,108,176,171,178,254,247,158,197,63,127,73,63,2,233,163,31,152,212,198,2,82,128,38,125,255,37,253,144,241,135,63,124,233,154,103,252,37,200,
230,25,127,249,189,41,43,13,19,233,7,82,84,147,121,119,120,118,231,71,183,222,2,223,23,128,11,240,173,89,231,22,48,183,88,231,157,95,231,157,95,71,127,79,176,174,254,158,248,222,209,55,231,233,155,251,254,75,55,246,212,61,235,215,65,104,233,103,126,29,12,36,253,248,111,208,245,114,85,144,93,226,71,235,252,236,215,249,89,235,172,62,79,85,126,248,146,142,249,121,191,170,208,174,247,200,7,131,76,223,253,209,193,39,138,102,28,67,73,63,129,174,6,248,174,57,230,155,76,161,115,78,244,241,119,98,192,63,124,233,198,64,186,167,60,63,49,156,214,55,253,52,161,235,54,235,220,70,110,11,208,63,15,253,11,200,105,30,126,94,243,247,61,254,126,205,223,247,188,220,66,189,254,202,188,95,61,125,222,224,141,31,28,34,125,207,203,109,193,203,121,1,126,160,43,61,197,58,179,224,157,2,239,44,120,167,88,231,13,127,63,231,239,55,252,253,220,175,179,236,231,45,243,124,102,221,151,110,140,184,123,26,126,103,88,15,39,79,99,204,233,231,252,253,27,120,239,243,253,190,151,67,98,216,240,107,116,0,191,4,124,76,223,
82,3,188,183,43,211,143,217,162,135,143,237,77,240,166,159,38,248,205,62,60,60,54,148,158,133,30,224,229,216,233,135,240,131,99,167,31,122,126,22,61,63,139,224,51,61,48,47,208,219,26,187,14,248,143,253,138,96,230,228,70,80,51,185,45,194,215,36,235,78,178,238,162,151,119,168,159,152,31,173,51,15,220,60,112,242,31,179,171,38,240,4,170,244,4,250,153,98,29,217,193,20,235,200,14,8,44,230,63,4,150,196,127,66,250,204,198,60,63,177,220,180,142,173,223,100,157,216,174,23,160,11,189,166,165,87,236,195,5,68,198,224,193,100,103,1,202,219,171,231,83,122,50,191,135,62,139,47,243,208,11,127,242,1,250,197,4,254,142,223,249,221,71,158,137,215,118,130,127,117,87,189,131,143,19,184,42,4,174,113,1,16,184,42,4,46,31,56,214,4,20,111,200,138,132,105,20,104,81,16,5,154,130,127,245,68,254,186,214,96,157,115,122,129,196,134,39,129,16,169,211,227,158,129,80,128,62,208,24,94,2,147,49,79,96,178,117,159,250,117,159,122,65,4,142,30,43,210,224,20,88,21,112,9,68,233,167,172,243,180,201,58,177,162,230,3,131,136,
21,252,152,249,82,240,227,38,235,24,62,207,79,108,232,226,199,130,165,214,1,95,72,87,104,120,1,188,25,210,184,95,103,220,203,45,112,12,231,228,126,29,178,112,122,230,239,24,172,55,176,70,254,149,169,45,160,144,169,147,128,18,58,134,201,65,134,3,220,172,151,219,108,131,220,130,4,145,142,29,93,124,134,252,200,33,159,48,95,14,249,164,137,29,196,1,72,243,66,59,176,68,208,68,63,22,136,225,255,109,176,206,91,111,7,247,60,157,247,252,58,208,109,14,32,186,125,2,177,128,18,58,160,5,104,191,78,24,136,67,125,6,114,182,0,211,200,15,118,101,235,96,87,221,56,97,247,164,215,79,236,184,178,3,31,56,204,127,194,117,98,71,23,255,47,209,231,75,167,79,91,71,118,45,185,197,118,29,6,226,216,78,53,47,12,92,161,93,7,118,19,251,149,233,115,198,203,105,6,185,41,113,198,1,242,253,90,57,116,67,83,247,75,207,143,241,224,237,205,251,189,241,19,174,227,215,151,29,167,198,193,173,181,228,51,216,105,106,156,138,208,87,128,22,144,8,162,221,210,209,148,112,182,81,96,240,28,30,83,11,170,192,176,27,18,160,201,117,
138,241,138,175,192,22,153,35,121,47,2,255,50,30,63,149,4,184,244,50,1,110,185,195,87,130,194,75,128,91,174,206,26,0,191,96,98,21,25,191,112,194,3,87,145,101,8,108,25,42,34,57,104,134,69,244,76,17,52,131,161,101,110,195,56,153,52,30,87,38,149,225,101,48,206,204,29,112,188,117,2,203,120,199,201,160,232,204,47,60,251,197,9,44,153,167,113,91,199,85,48,241,120,74,227,100,230,12,153,89,2,19,30,9,75,120,36,160,100,29,31,209,235,214,33,187,103,158,55,89,135,0,154,241,1,180,14,30,7,205,60,6,94,244,123,62,187,228,56,90,215,7,182,140,5,54,71,135,4,159,97,221,46,42,184,12,74,205,60,133,223,151,46,147,100,168,192,50,148,218,202,148,153,86,235,217,28,214,35,144,38,235,41,144,162,216,140,15,216,25,111,216,241,115,147,187,225,107,194,151,225,107,162,39,147,223,90,120,147,159,241,44,58,155,232,41,150,71,160,119,227,7,131,207,192,167,12,176,78,126,56,73,102,210,5,68,211,147,201,7,126,48,200,140,18,18,6,153,33,33,173,153,71,69,151,81,165,137,163,197,124,170,2,204,152,254,154,172,211,130,127,5,
236,204,35,214,33,96,103,30,249,117,188,227,101,168,108,50,49,125,84,60,201,58,36,226,12,1,38,243,196,175,227,3,182,232,116,240,77,228,38,58,9,120,25,37,22,11,8,171,248,76,63,49,63,146,27,9,45,195,150,208,228,102,115,252,58,62,113,103,168,76,51,49,188,236,46,182,27,217,157,232,52,94,153,239,43,179,58,121,83,1,102,30,173,165,47,99,122,107,34,55,18,109,230,217,90,57,155,125,63,243,126,245,236,111,232,167,145,31,130,93,134,74,111,141,62,67,191,139,249,145,191,202,143,148,40,229,191,36,156,53,243,72,138,25,191,131,74,244,195,188,212,91,2,155,197,17,5,56,214,67,142,41,85,240,208,227,130,158,228,75,160,123,197,248,43,2,99,188,133,142,255,78,2,35,207,23,93,224,212,22,156,245,13,159,240,112,110,224,10,186,56,238,169,160,179,29,129,223,81,129,195,109,117,73,84,113,130,181,121,110,92,250,149,190,92,18,93,213,87,221,14,246,30,176,247,160,91,59,15,228,162,173,184,237,60,90,85,210,126,71,98,5,29,246,98,5,157,118,50,218,33,42,30,105,39,234,227,81,184,78,55,201,174,91,21,173,118,16,170,192,
181,131,32,174,252,221,74,122,22,186,176,87,181,48,186,208,143,237,228,84,104,105,39,103,133,214,234,115,233,193,21,52,206,223,195,194,54,109,197,128,179,11,141,75,206,105,237,88,44,57,194,255,187,85,60,93,239,88,71,133,150,118,114,42,180,216,201,53,22,130,221,224,235,246,250,174,43,128,124,97,96,240,161,126,238,194,3,59,225,174,55,193,58,111,36,55,254,182,162,0,254,222,137,190,213,231,198,79,76,95,48,46,189,174,22,168,208,25,22,38,113,1,40,250,165,31,209,47,253,200,14,140,182,192,14,194,66,61,94,71,133,69,92,152,104,7,143,223,38,157,130,16,62,230,167,81,63,90,87,118,160,117,99,59,8,229,237,237,215,236,59,44,28,61,221,242,191,208,110,226,2,76,241,218,244,73,188,150,222,236,111,197,7,253,109,241,97,149,110,201,109,181,0,98,94,178,129,184,137,78,225,135,157,186,201,217,219,187,201,217,118,221,216,141,214,145,220,132,87,114,19,61,138,223,178,23,31,191,235,232,107,225,119,78,63,77,252,148,216,169,141,210,26,255,81,193,61,201,58,42,28,39,93,28,170,91,199,111,72,140,30,209,39,122,160,
175,206,14,124,252,176,206,148,21,135,216,155,58,4,113,225,172,29,60,241,206,228,161,226,142,194,215,228,29,232,213,117,140,188,28,172,238,234,112,178,240,117,151,139,99,146,159,143,123,196,143,148,226,7,246,89,23,247,200,199,169,151,196,53,242,65,234,145,226,155,224,249,252,51,159,127,14,254,142,199,237,83,5,161,98,222,186,47,252,92,59,60,174,255,157,159,152,103,35,187,210,227,153,248,129,7,219,24,116,14,222,167,64,130,32,250,230,87,50,30,128,150,169,68,212,167,146,76,79,104,149,251,248,193,84,226,72,31,57,203,0,188,12,251,150,215,76,197,155,108,234,66,56,21,83,233,91,110,54,213,54,77,77,87,53,235,110,32,184,142,44,115,51,181,118,141,95,177,133,111,26,193,182,163,8,166,226,84,125,34,24,167,114,4,175,174,42,81,37,83,175,248,205,88,48,21,125,155,48,208,183,19,134,145,213,148,224,120,213,152,215,53,83,205,142,154,78,181,8,29,175,234,172,33,32,43,131,250,49,195,196,221,60,207,86,215,163,231,164,174,39,191,101,126,36,223,254,232,226,116,93,93,97,181,187,195,28,230,97,87,183,55,129,
255,19,120,254,212,4,62,193,223,80,31,249,58,95,186,168,195,79,92,202,60,108,130,191,174,206,161,45,79,140,115,124,208,150,95,188,249,37,51,202,188,209,38,243,172,238,197,144,240,247,12,115,228,239,86,7,90,29,228,252,81,117,169,242,147,213,123,228,153,140,207,51,25,54,166,25,117,148,148,215,173,206,101,221,101,249,9,176,252,235,89,94,185,108,198,180,118,195,100,15,92,211,27,72,171,42,220,44,237,154,116,144,112,115,213,67,99,143,20,133,162,68,20,210,139,117,146,113,21,73,157,198,172,26,20,167,171,146,83,68,117,187,160,38,26,72,36,218,0,111,227,77,224,255,2,215,127,105,130,255,46,227,202,168,90,23,211,74,118,54,247,248,126,175,9,60,45,131,140,122,186,70,167,36,23,104,108,25,141,121,205,40,34,214,89,158,167,215,36,238,163,134,42,228,212,43,224,232,133,242,137,133,120,205,249,76,156,81,207,207,214,105,148,87,117,143,23,180,119,35,87,227,17,99,209,2,223,93,211,238,103,114,196,207,206,118,234,114,64,220,101,7,115,124,204,97,181,0,146,72,223,117,28,199,227,150,211,194,92,235,157,207,
224,173,75,219,4,191,229,122,39,161,164,230,82,173,225,155,3,141,185,162,174,25,24,226,71,98,58,21,89,3,111,244,184,32,106,57,86,60,43,135,37,244,147,155,194,28,246,19,120,126,242,240,62,212,91,205,24,214,36,97,109,225,215,149,166,234,240,135,252,162,65,89,188,214,173,59,29,9,107,17,107,0,253,29,249,224,37,170,189,235,229,89,95,131,196,181,186,44,161,174,70,76,228,211,0,111,181,65,19,249,135,252,134,242,49,190,254,19,240,94,206,107,228,99,181,95,19,125,89,13,225,229,175,88,37,185,169,102,182,60,224,225,105,20,153,60,105,74,185,142,119,19,253,134,242,12,229,143,204,187,231,60,253,113,205,41,123,243,53,146,217,79,168,95,179,195,38,252,134,205,90,111,135,102,255,68,2,219,219,72,254,113,13,36,252,201,222,166,65,254,33,254,208,30,18,125,57,187,138,237,39,217,59,52,226,247,181,87,125,45,207,186,173,106,184,132,30,240,135,181,124,8,239,171,146,180,78,155,194,189,76,114,90,16,143,55,145,103,34,31,240,135,242,140,107,68,209,31,202,191,149,61,132,77,105,31,9,205,127,19,249,128,39,148,127,
40,207,80,254,9,61,13,240,86,131,123,250,67,120,191,55,49,121,122,191,83,15,206,197,31,103,111,41,237,67,146,24,65,86,155,165,232,176,26,116,159,183,167,125,126,143,126,197,50,85,108,15,169,138,254,86,109,10,156,209,11,156,253,125,133,8,238,143,137,19,94,149,45,193,27,195,27,93,171,240,245,250,94,197,235,246,34,49,220,85,203,12,102,219,62,19,51,207,199,127,101,226,234,171,213,212,177,16,20,71,11,31,118,251,7,228,49,155,241,97,95,195,64,82,87,197,16,127,157,75,152,113,68,39,16,141,121,201,144,187,196,39,55,207,84,62,236,5,121,56,96,9,75,41,187,177,216,249,235,171,198,69,156,232,92,121,231,82,27,223,97,45,230,0,27,113,217,250,67,167,227,32,25,72,22,129,62,42,155,164,206,88,254,235,108,227,34,78,142,182,72,29,100,204,137,15,88,153,197,214,156,52,10,97,237,34,49,39,240,140,46,156,100,80,210,194,135,61,13,162,55,93,52,21,23,139,204,7,156,204,175,93,36,224,100,173,194,67,156,173,57,129,62,140,63,41,64,231,91,235,68,218,11,56,89,252,207,113,194,212,68,39,139,255,31,56,73,189,16,191,
208,200,182,32,245,194,185,133,149,182,149,158,47,41,10,184,212,175,184,21,101,68,234,62,159,108,130,82,179,124,18,54,82,207,249,252,141,207,223,248,244,238,251,183,63,175,38,112,205,11,53,182,34,132,181,166,165,127,184,21,73,44,151,150,105,88,64,250,52,103,173,212,187,224,137,11,85,54,74,73,235,213,198,127,128,14,120,14,225,61,30,115,191,196,138,193,159,192,55,20,206,97,97,27,226,103,171,157,249,179,199,239,203,6,59,234,176,130,250,71,103,192,132,253,140,63,60,207,124,207,247,239,155,208,115,155,241,219,63,184,112,224,211,80,102,129,2,255,39,198,127,242,133,111,136,223,198,61,188,15,201,25,90,125,153,31,128,255,193,227,247,105,40,163,86,183,201,211,195,251,80,107,114,107,37,79,127,244,99,242,9,241,147,70,147,150,121,40,79,211,163,231,55,212,215,61,224,109,163,208,32,255,86,240,161,252,61,30,219,232,80,174,103,126,246,248,177,61,231,32,240,213,138,30,202,57,59,210,33,237,102,72,115,25,127,249,39,67,90,204,60,147,124,86,55,52,134,223,240,52,161,63,129,135,254,80,158,182,101,116,
242,76,77,203,86,92,233,38,186,82,211,164,47,108,36,181,120,37,177,127,159,25,174,56,5,91,255,37,12,218,56,130,25,88,19,195,240,14,178,198,80,67,199,9,21,97,10,245,140,132,140,83,87,100,30,52,49,140,80,80,161,97,183,82,68,168,184,16,222,240,120,252,161,161,218,186,77,232,33,175,187,51,132,6,69,216,186,30,62,196,239,215,53,197,249,113,59,35,108,37,159,86,252,154,33,121,71,72,28,173,193,144,66,69,123,57,172,145,127,232,56,56,136,234,85,115,192,80,62,161,161,122,7,180,64,148,224,199,193,19,250,145,3,245,112,134,107,127,218,239,172,158,229,52,200,231,54,48,58,123,109,52,236,4,127,3,124,24,72,67,123,240,114,174,119,4,214,109,37,127,127,118,107,240,158,47,147,127,211,241,15,115,102,232,233,101,101,127,191,241,94,246,27,111,22,112,27,105,10,101,111,40,214,76,253,35,227,127,116,138,209,56,2,119,215,255,136,116,218,160,186,98,206,111,132,84,152,34,136,180,23,68,221,70,154,123,151,233,155,77,224,105,74,165,105,122,73,145,33,254,212,28,127,115,107,129,79,127,11,131,34,23,6,221,161,143,195,
211,237,29,172,219,186,147,122,238,170,26,183,57,109,228,171,126,190,187,29,228,20,22,227,181,13,45,17,86,215,13,215,240,101,27,0,15,111,155,16,191,1,198,80,146,13,127,40,55,43,168,61,95,225,6,198,54,87,107,241,187,67,34,143,127,14,62,94,114,155,201,140,14,62,94,114,248,21,110,148,194,117,188,30,76,126,58,212,149,126,56,44,117,215,18,253,58,172,47,71,176,13,20,14,162,107,117,6,31,210,21,242,145,220,98,0,143,223,128,216,70,222,54,41,158,111,2,99,250,215,181,124,212,53,70,8,8,118,120,37,187,48,60,30,222,235,45,108,128,172,161,199,211,105,122,8,225,113,156,244,29,79,63,14,107,252,106,99,78,6,79,91,6,215,102,136,239,100,118,219,8,183,106,20,132,27,49,79,103,170,242,163,191,146,40,252,224,145,30,116,171,44,214,131,14,33,91,53,36,188,255,24,31,62,51,91,195,38,228,219,7,24,107,36,24,188,215,55,1,32,185,6,219,10,191,201,195,195,91,11,220,235,33,108,240,132,248,77,78,30,126,25,252,254,242,67,124,237,112,141,125,91,227,205,195,123,63,91,211,224,9,252,47,77,128,73,251,75,35,117,254,147,
208,211,224,111,247,128,247,135,37,117,240,97,131,36,176,211,110,116,210,189,232,233,153,71,15,108,116,220,85,71,252,97,25,61,120,255,90,195,71,168,135,105,111,31,211,216,71,184,78,104,79,97,35,192,78,1,188,92,195,70,76,232,111,97,28,8,229,212,74,111,230,39,127,75,174,13,241,54,180,139,80,111,9,191,245,246,221,13,140,139,127,224,9,110,73,153,92,56,84,227,211,14,213,92,44,198,255,30,3,167,219,72,143,25,215,245,102,236,220,96,77,38,226,157,113,181,120,117,91,205,203,195,29,246,51,207,39,84,217,181,230,116,251,102,125,119,203,22,57,173,101,98,70,198,95,255,173,107,45,195,103,134,198,173,252,101,181,74,35,209,37,9,211,141,139,126,171,220,195,132,137,220,147,74,211,18,157,139,43,117,248,201,67,73,66,14,225,177,207,140,191,206,94,7,223,170,64,8,11,64,111,7,70,79,43,252,73,1,66,194,71,126,25,110,199,89,37,107,52,56,59,200,216,46,196,217,153,107,223,123,250,57,212,53,126,57,212,117,213,177,135,15,233,247,114,147,252,235,232,183,241,24,222,249,75,178,93,85,139,223,228,247,119,118,44,240,
39,253,27,127,228,235,140,207,215,25,239,151,106,237,187,139,54,94,111,193,165,40,87,36,121,62,146,66,10,120,219,89,197,116,129,211,55,142,157,12,4,143,156,60,127,38,39,175,79,179,11,108,210,232,193,30,91,238,0,195,29,8,49,35,217,97,154,126,154,224,191,7,140,143,67,241,186,86,216,53,213,51,133,224,119,192,127,231,242,65,221,81,75,130,191,65,15,173,14,211,18,248,6,126,125,65,188,198,15,154,210,179,42,135,53,240,97,97,29,218,169,217,163,151,63,177,34,57,42,250,71,252,44,132,55,185,121,253,134,248,67,121,134,240,201,198,163,129,95,95,152,90,161,236,245,46,249,155,61,223,245,246,127,23,62,237,25,235,221,70,190,15,24,191,141,93,178,81,114,241,42,196,233,252,40,197,235,4,241,229,172,212,140,167,211,199,121,59,178,146,191,36,118,233,240,88,189,72,219,41,169,23,23,200,43,173,234,191,176,206,242,126,98,245,113,171,58,216,240,56,185,199,141,97,203,167,150,15,28,125,117,117,118,152,223,225,61,57,96,193,110,244,26,135,228,83,215,192,198,223,85,175,203,14,234,14,124,66,120,175,167,85,58,61,
61,173,240,135,240,86,15,54,129,247,235,202,111,227,60,254,55,235,172,240,210,137,95,87,240,226,167,219,31,160,116,163,47,87,111,193,147,223,104,181,172,179,176,219,164,254,243,241,193,234,72,63,110,114,242,122,183,241,123,192,203,223,117,201,107,145,239,186,76,165,215,75,66,61,132,117,147,233,161,137,92,91,241,29,54,238,67,185,218,186,77,244,108,235,254,45,185,162,207,127,68,15,86,127,9,127,131,30,90,233,205,234,147,181,151,114,76,15,13,121,188,238,192,206,31,132,153,92,67,186,124,93,107,246,199,56,159,110,95,152,212,41,13,124,216,120,19,190,195,125,71,136,223,143,175,193,223,10,222,234,50,175,183,144,158,86,240,166,207,38,244,180,210,91,176,143,168,151,185,226,15,151,29,193,103,239,31,222,71,31,198,43,121,255,62,151,125,216,103,216,251,129,117,254,11,60,245,165,222,63,76,61,1,222,100,9,60,239,15,186,75,70,193,237,112,111,83,172,233,214,137,231,77,242,106,204,178,106,63,230,77,50,15,219,182,203,148,236,125,82,243,252,205,188,86,239,255,173,61,157,248,27,245,65,171,252,77,220,
203,248,253,127,93,29,98,249,207,233,65,227,178,11,171,39,252,184,236,168,14,222,227,145,158,237,82,136,224,213,25,133,207,228,82,120,16,199,51,232,39,201,223,11,124,143,59,136,97,199,209,219,145,173,235,243,144,225,247,241,194,58,172,173,58,136,241,229,223,160,46,177,250,160,85,190,108,213,161,196,6,50,246,182,78,152,171,168,39,108,220,217,93,93,253,97,116,58,255,140,199,215,52,210,66,121,98,215,174,67,223,128,223,232,108,130,223,244,232,226,81,93,199,221,203,205,228,19,226,103,191,148,153,246,240,161,60,177,213,204,68,19,252,9,191,13,250,13,229,131,77,38,245,159,237,11,154,208,99,235,122,252,216,119,82,175,180,162,199,203,205,234,137,208,30,146,58,191,65,62,161,253,132,244,248,6,164,124,123,85,254,232,203,236,176,9,61,248,187,246,47,107,236,217,236,170,9,124,104,207,97,61,29,202,63,180,207,100,31,129,60,67,251,247,120,214,232,43,148,127,82,231,224,71,33,254,240,196,32,180,255,80,191,173,234,197,16,127,8,111,118,232,249,157,67,38,113,163,212,78,87,136,67,111,137,67,111,21,143,
144,171,215,143,213,249,117,126,192,126,165,238,120,141,198,123,43,253,121,187,95,19,47,90,209,215,74,127,62,46,152,254,66,249,146,239,146,151,38,124,63,205,46,163,89,92,104,162,111,79,167,211,135,250,69,13,7,8,161,222,67,185,121,251,177,121,161,222,67,186,66,248,208,239,66,191,104,197,119,232,119,173,224,67,59,52,62,188,30,67,191,176,184,221,36,46,89,220,110,2,31,238,27,67,250,169,75,155,238,199,147,43,110,13,113,195,228,227,240,167,94,5,182,243,202,231,65,226,129,189,255,254,136,121,188,181,153,122,68,222,248,149,188,106,121,240,148,179,55,207,119,221,123,253,58,21,50,27,39,111,234,253,121,120,85,158,148,30,156,239,235,117,211,205,62,111,1,99,175,155,254,203,37,43,80,87,55,128,241,101,130,5,105,156,131,97,203,66,174,227,188,122,141,147,149,160,70,59,82,179,248,48,147,250,113,203,44,137,196,254,65,120,31,225,141,218,132,67,60,221,36,236,51,111,104,81,225,89,104,24,25,194,76,205,56,18,112,153,55,204,212,161,103,180,202,44,166,169,38,158,209,106,103,27,102,210,144,30,143,103,141,
71,88,196,22,126,228,227,45,211,228,105,240,222,2,189,28,76,158,201,206,25,248,48,226,120,75,182,76,17,202,63,217,57,55,224,111,197,111,130,191,33,50,123,75,54,250,67,121,134,145,124,141,71,52,209,87,43,253,182,146,79,40,207,80,95,97,228,103,93,211,175,142,176,66,248,144,30,227,171,137,60,253,186,245,246,70,102,108,21,145,90,69,110,211,99,147,136,145,208,131,252,189,30,215,232,215,235,125,181,18,107,18,145,188,94,76,254,33,191,73,68,109,192,31,100,18,103,91,234,154,197,209,91,62,171,78,243,191,244,4,161,33,12,239,30,128,95,67,177,208,224,226,72,67,108,34,246,91,141,31,191,0,133,5,175,238,153,137,61,80,102,191,85,130,196,236,69,1,187,213,17,199,34,167,49,139,93,241,30,2,75,181,223,6,33,23,217,111,133,104,79,225,53,152,214,30,36,142,137,212,86,246,155,32,173,240,197,112,72,32,245,16,58,56,207,178,223,70,105,196,231,231,39,47,112,209,207,212,139,13,146,176,253,102,10,17,195,232,139,241,197,252,162,45,219,123,232,167,0,248,110,103,118,122,67,54,198,23,63,111,133,47,134,139,233,138,
255,110,164,15,239,182,55,111,19,121,184,117,215,208,23,207,39,87,166,158,174,198,252,212,45,47,191,91,218,187,34,191,152,174,186,207,213,189,88,55,227,171,63,67,16,254,102,138,14,137,108,131,230,82,64,221,225,91,162,160,213,166,131,8,12,15,59,221,111,90,184,16,151,8,140,38,73,242,219,34,129,225,200,5,234,154,23,33,126,20,106,191,201,82,7,15,30,63,190,102,19,143,194,210,227,206,37,227,117,13,63,46,223,244,48,152,80,150,28,30,122,23,179,230,210,61,198,253,117,146,85,131,132,78,12,59,237,223,136,172,107,130,217,184,75,25,117,240,56,132,222,184,90,35,159,86,240,40,84,63,137,176,6,158,80,208,244,112,210,154,4,77,248,37,84,166,237,141,211,192,96,37,127,195,223,4,222,203,65,97,35,150,155,66,86,124,184,182,134,30,28,56,109,215,91,66,135,229,22,54,6,238,154,95,140,135,135,134,158,175,53,250,50,250,61,191,62,197,91,147,203,26,8,77,228,233,155,55,107,232,9,225,125,202,48,60,173,228,73,105,145,52,33,19,120,248,181,230,151,232,65,14,132,238,228,144,145,128,144,182,205,227,234,184,201,199,
244,235,229,137,243,38,135,158,9,61,192,147,154,221,143,54,129,223,14,218,61,188,31,55,251,52,187,109,194,111,72,127,40,159,68,254,13,250,242,120,214,200,231,31,105,122,133,248,67,122,194,67,76,54,68,238,112,172,193,223,41,158,155,94,158,72,232,89,165,83,111,130,183,124,75,160,149,61,183,178,127,179,243,38,246,28,250,87,162,95,252,151,0,157,246,63,165,224,108,145,12,56,215,65,112,87,162,83,208,36,222,205,85,95,154,3,218,221,197,185,224,126,229,28,93,165,255,66,253,251,95,156,162,234,186,62,220,250,208,171,78,18,124,93,151,40,188,39,231,3,155,117,113,254,4,252,159,154,192,35,128,228,250,84,8,111,185,221,49,26,215,140,86,59,96,32,174,43,211,176,219,8,107,25,95,51,26,60,10,113,93,40,106,7,219,209,250,90,222,240,123,122,194,93,117,43,248,112,55,22,226,71,240,238,52,18,252,190,38,181,218,199,211,105,242,241,134,102,93,43,2,109,114,111,47,228,215,215,104,107,228,233,199,215,212,110,33,124,72,127,82,43,33,159,112,119,232,187,5,107,232,193,65,51,241,105,75,88,203,183,234,162,181,218,
69,27,254,255,132,190,60,158,250,90,158,154,52,193,143,60,201,214,234,54,153,60,9,72,153,233,70,252,31,51,171,41,223,151,34,238,34,109,92,34,184,212,159,89,244,155,60,251,221,0,191,201,75,20,221,96,72,223,177,144,29,23,50,30,42,14,143,111,218,46,13,21,17,110,26,90,109,194,194,34,55,196,223,106,27,237,233,92,99,24,161,162,67,67,106,113,60,151,105,213,30,243,155,21,83,132,23,120,189,163,53,24,118,232,56,33,253,161,99,50,78,180,161,245,199,102,37,52,12,239,32,134,223,227,49,195,14,29,211,111,182,140,223,80,158,137,35,160,151,208,80,67,122,252,143,6,233,183,16,226,251,127,138,122,117,237,183,219,232,49,190,16,236,223,173,206,112,141,98,245,55,89,128,15,29,39,212,87,216,78,74,54,61,13,248,77,14,222,80,195,64,225,55,115,198,175,31,55,195,54,7,108,2,159,216,103,131,35,132,244,132,242,79,2,75,3,124,24,24,151,225,61,254,13,149,86,240,161,60,177,43,244,224,218,255,161,252,67,123,243,114,88,19,88,66,249,132,240,97,211,34,196,31,6,210,208,241,61,157,107,236,63,193,223,192,111,232,143,33,
254,132,254,6,120,195,239,229,31,202,167,21,188,217,103,99,32,194,126,90,193,91,66,108,2,223,42,241,133,254,30,234,55,241,23,236,45,148,167,95,87,242,49,219,170,187,3,157,236,113,121,3,65,111,39,220,197,49,95,160,80,206,231,117,63,200,93,134,5,232,237,234,111,125,174,219,181,142,223,250,252,167,239,143,13,222,58,246,227,15,26,255,127,2,0,0,0,255,255,3,0,137,118,242,151);


programfile__2001_mid
:array[0..9032] of byte=(
120,1,124,155,93,112,28,85,150,231,47,77,117,159,108,54,123,201,238,206,110,18,72,32,129,162,41,35,1,101,81,70,50,46,68,201,146,236,178,85,178,36,171,108,203,182,140,101,91,54,50,200,150,48,54,54,32,200,41,219,96,247,208,17,179,209,254,16,179,68,63,204,71,199,198,206,198,198,204,180,101,137,158,153,142,216,143,217,93,246,109,34,118,31,246,105,99,119,103,191,63,158,232,135,125,99,127,231,100,165,92,184,155,141,112,169,238,247,189,231,127,206,61,247,127,207,45,143,54,231,102,157,115,223,114,247,184,239,223,243,59,163,205,51,111,56,247,141,239,187,47,211,123,157,27,112,95,78,21,10,223,136,60,247,229,254,111,208,232,203,137,123,239,191,124,238,15,244,251,59,127,242,196,239,233,247,223,221,21,183,106,217,119,160,95,87,95,110,37,250,253,215,253,154,189,255,27,189,45,109,197,183,101,183,214,22,53,183,181,102,185,203,231,44,247,249,23,150,251,252,139,113,234,130,251,255,157,230,248,178,220,254,97,203,253,252,144,206,17,252,252,144,229,126,189,221,114,191,222,174,185,239,110,235,42,103,
95,150,251,244,69,203,125,250,162,229,190,88,182,220,23,203,154,251,222,216,239,104,238,123,127,250,140,229,254,244,25,93,104,59,247,253,239,253,141,230,248,210,186,239,191,187,98,185,119,87,52,135,200,55,28,223,185,200,42,212,140,150,183,197,216,90,107,233,184,52,179,214,159,127,209,106,127,235,23,130,24,2,185,92,251,135,23,181,180,45,201,207,15,141,119,228,126,189,93,135,69,32,237,200,87,77,191,218,146,124,250,162,229,50,73,190,251,197,178,230,16,72,91,254,134,92,101,10,115,73,190,247,55,150,203,36,65,46,237,208,254,186,255,243,47,50,185,134,126,245,145,163,24,85,254,88,191,25,207,84,252,195,191,157,177,114,242,238,203,231,93,102,26,110,147,251,242,241,123,48,133,123,101,252,228,177,99,11,243,11,238,159,212,221,159,97,28,255,193,213,220,159,213,28,118,244,111,74,127,111,44,237,30,115,141,102,250,147,90,147,182,235,157,75,121,231,111,141,29,93,56,158,108,116,255,116,200,253,185,140,211,219,253,71,186,255,185,117,239,104,223,147,183,255,230,216,153,215,142,156,118,255,108,155,
251,133,220,239,238,59,160,61,254,19,61,126,97,61,138,63,141,210,127,16,71,157,51,189,159,247,252,206,182,51,199,79,31,155,75,234,11,103,78,39,21,247,207,171,238,214,125,207,210,251,143,138,215,122,211,122,175,107,246,166,63,9,122,221,191,117,213,250,199,126,213,253,222,244,96,218,42,12,186,74,45,157,171,185,70,53,157,174,186,169,222,116,186,215,141,87,210,185,138,155,42,167,179,101,55,213,149,126,88,239,114,205,103,211,75,133,103,93,220,149,94,170,118,185,114,57,93,246,203,29,139,248,246,191,255,173,139,216,104,139,144,29,206,214,225,254,22,49,110,153,24,31,207,203,160,47,91,11,215,170,169,127,75,106,190,244,251,82,13,100,75,32,47,245,201,230,64,250,34,233,173,74,95,44,189,177,244,245,217,95,210,148,84,44,221,170,92,171,186,230,96,250,97,116,75,54,199,215,6,157,187,37,47,197,178,165,36,3,254,181,122,26,222,146,173,177,12,182,102,201,74,173,36,175,4,210,223,45,85,26,196,82,245,229,101,178,190,22,214,2,25,136,173,105,44,67,177,12,39,178,205,151,237,190,212,3,217,225,203,206,64,
70,124,105,4,50,26,200,174,88,198,2,25,247,101,119,32,147,190,52,3,217,235,203,190,64,166,2,57,224,203,193,88,166,3,57,228,203,97,95,102,2,57,18,200,177,88,102,3,57,238,203,9,95,94,11,100,206,87,101,200,201,64,222,8,100,222,151,83,129,156,142,101,33,150,55,125,57,19,200,217,194,181,186,3,135,115,190,156,15,228,130,47,111,91,49,13,143,7,58,242,30,119,109,48,117,181,212,85,211,224,150,174,98,148,117,129,157,43,212,156,55,232,226,91,50,26,203,174,110,25,43,104,187,106,234,94,81,84,117,181,182,212,61,172,118,73,246,92,156,146,166,47,147,177,236,78,100,194,151,241,64,198,124,217,133,120,38,36,162,238,8,164,30,203,182,64,134,125,25,242,101,48,80,104,6,12,38,240,122,217,55,245,4,178,217,151,190,64,94,244,101,83,34,149,146,108,234,147,23,3,233,181,114,244,151,33,11,238,91,109,132,225,64,7,4,83,6,223,153,161,201,164,190,161,25,200,68,7,154,25,148,211,190,188,26,40,136,71,125,57,134,252,192,231,203,92,32,139,129,97,165,66,187,65,231,189,162,26,63,27,201,91,20,131,165,47,39,13,106,58,209,
245,85,95,117,49,29,203,65,95,14,4,178,223,151,41,148,229,203,222,86,73,246,128,8,32,0,77,81,38,106,50,206,223,75,158,140,213,100,215,197,154,52,18,25,45,74,163,136,85,94,94,172,186,198,45,69,104,60,1,212,228,150,76,124,232,99,104,197,91,50,25,72,19,133,169,149,237,137,100,111,172,3,130,39,66,97,43,192,136,152,59,98,21,25,217,183,122,106,220,175,96,223,53,51,56,95,45,18,203,87,107,243,115,107,163,125,201,76,13,197,150,12,156,88,149,55,17,169,254,116,182,200,38,10,84,134,169,72,229,81,155,67,66,179,57,164,61,12,98,158,28,141,228,88,32,179,6,218,137,192,112,139,229,245,162,188,225,203,124,44,167,60,57,29,200,66,73,22,125,121,211,147,51,37,121,203,151,179,190,156,11,212,218,206,79,233,95,208,92,240,48,197,2,166,234,235,72,216,243,193,117,0,145,181,168,246,245,138,154,24,77,20,81,95,246,120,168,4,125,96,135,216,38,5,96,77,31,93,21,202,48,195,165,117,45,245,110,169,74,217,20,186,35,34,253,75,154,245,30,173,203,145,146,204,76,105,243,87,99,57,20,201,116,36,7,43,166,181,88,246,21,101,
47,74,43,74,51,54,165,197,102,185,161,154,15,91,114,52,252,10,228,24,239,246,72,65,29,174,221,129,182,189,139,109,207,160,34,197,181,100,184,154,33,232,214,48,219,80,92,3,3,213,140,167,13,170,47,71,252,14,92,163,182,49,190,238,203,27,69,3,181,168,182,183,16,100,86,201,110,4,150,197,110,121,51,161,76,247,57,40,98,193,140,129,134,24,18,227,70,115,232,175,13,93,164,142,68,109,209,12,104,188,44,99,69,25,191,20,202,46,4,108,57,217,117,217,97,137,151,240,113,123,107,178,111,78,166,202,178,63,210,169,110,201,129,33,48,66,25,108,243,233,162,28,188,236,228,80,81,94,173,170,73,0,62,147,236,195,21,56,48,111,219,123,96,115,168,213,150,113,12,23,171,178,171,85,83,187,165,90,229,199,145,217,186,218,118,133,26,80,6,171,142,101,38,131,128,205,136,71,43,202,137,146,42,111,46,150,147,69,121,189,36,111,84,100,62,146,83,145,156,46,202,66,159,44,134,242,102,73,206,84,212,198,78,169,79,99,1,115,166,104,134,97,72,108,86,133,199,162,77,230,49,239,154,249,52,90,225,131,116,231,68,50,210,118,107,0,217,
64,103,230,163,128,103,79,225,218,64,234,134,213,138,24,1,15,129,113,50,114,102,218,232,2,141,156,140,101,14,208,94,171,200,137,41,57,222,42,203,108,172,30,4,103,204,228,106,92,153,87,200,85,128,187,65,114,240,223,205,246,55,235,192,82,116,211,70,230,251,56,22,106,182,81,109,151,114,32,176,171,89,33,235,196,136,176,62,54,60,138,3,62,221,147,182,69,218,216,49,139,233,122,29,184,246,57,0,106,102,15,106,59,209,181,97,101,156,236,151,249,64,78,249,134,30,46,174,213,45,139,31,15,93,131,71,84,15,181,130,170,11,106,46,232,127,223,13,164,173,168,223,249,3,174,52,120,193,213,46,124,132,153,225,2,199,113,74,218,242,165,96,208,213,212,41,166,222,64,175,235,47,123,53,151,12,186,176,223,5,3,46,194,64,6,199,92,109,230,242,217,154,171,12,58,14,251,190,218,130,27,158,47,84,211,86,223,45,121,45,150,19,145,28,71,179,115,108,197,107,28,38,76,58,76,231,180,192,62,223,158,14,177,103,47,38,50,211,45,135,61,121,53,188,214,239,188,237,58,55,202,57,20,168,43,48,245,77,97,131,158,28,240,100,127,81,14,
212,101,127,104,238,214,83,120,247,120,210,244,100,50,51,181,80,246,78,203,62,106,151,100,50,148,221,161,109,101,192,143,100,87,73,70,19,105,132,50,146,200,206,146,122,207,122,77,182,79,203,182,138,158,201,67,137,29,69,145,12,132,82,243,228,149,72,250,67,121,57,145,170,39,91,66,121,201,147,205,145,244,133,210,27,218,153,228,75,197,147,23,124,233,73,100,163,39,101,79,158,247,229,57,79,158,245,165,219,151,174,80,158,241,100,131,47,37,95,158,246,228,71,158,60,21,73,209,147,39,187,229,9,79,18,95,30,11,229,209,146,60,226,75,236,201,195,21,137,67,77,63,74,121,44,73,34,143,39,218,236,73,95,138,190,60,69,119,27,100,131,39,207,4,210,21,232,248,204,194,92,101,95,167,238,97,37,156,145,158,46,108,179,39,47,5,186,224,151,61,59,32,61,61,6,182,114,18,120,50,28,218,233,136,241,123,210,240,244,60,30,243,100,220,83,112,128,72,183,168,103,54,6,188,153,223,247,20,109,220,228,171,158,121,88,79,142,36,114,52,145,99,137,185,126,79,78,120,249,22,141,228,245,80,222,8,229,84,108,94,202,151,69,79,93,211,
25,28,125,40,103,61,57,231,201,219,145,156,143,213,165,152,77,225,88,222,241,229,93,95,222,11,101,41,145,15,18,73,3,249,224,14,73,253,246,47,114,150,247,237,230,153,115,167,22,143,159,133,215,254,117,159,91,145,103,221,125,37,152,166,251,207,12,180,194,88,247,184,143,231,229,105,95,126,84,184,14,195,91,81,192,158,8,12,224,64,30,237,147,71,2,137,35,121,184,42,113,44,15,199,18,87,237,47,233,62,137,251,44,221,42,95,111,51,188,21,121,36,190,14,195,91,145,71,99,121,172,27,224,175,115,246,174,200,143,98,121,26,134,247,84,32,197,146,234,228,137,110,73,104,128,162,2,121,220,166,83,69,5,242,84,108,77,99,41,197,178,33,145,103,176,130,76,87,129,60,231,171,117,148,3,217,24,168,189,96,53,104,76,201,140,49,156,151,140,240,84,51,74,19,27,89,52,74,51,100,39,251,118,140,244,46,154,184,206,106,80,29,199,85,108,222,21,215,90,184,14,187,91,201,207,23,115,207,236,13,248,215,14,216,105,112,157,125,180,34,155,221,245,70,234,234,105,176,162,107,216,24,208,133,210,114,225,122,195,24,222,138,108,140,165,
167,91,94,40,104,243,122,234,70,20,85,93,173,45,21,198,252,18,190,111,243,197,166,82,51,56,243,139,177,108,10,180,254,5,36,211,241,212,40,145,245,89,68,55,12,116,15,4,166,161,216,32,12,228,9,95,30,15,228,49,204,61,48,253,248,242,80,32,15,198,18,117,203,131,21,77,63,108,229,52,64,147,64,251,20,218,181,17,54,4,237,13,160,214,159,193,201,246,11,12,206,64,151,177,14,103,134,101,13,211,15,100,104,157,24,154,99,197,217,227,139,245,56,82,180,240,49,222,136,43,172,40,221,193,193,114,74,115,6,140,26,181,226,120,167,43,3,176,131,106,145,81,171,64,185,41,188,126,139,15,10,37,227,167,190,78,250,34,228,180,106,20,245,82,65,94,24,146,30,206,189,50,110,161,40,229,34,102,105,20,111,197,150,153,128,106,178,34,155,62,244,177,180,210,138,173,152,117,164,17,138,137,244,102,209,231,201,38,132,50,233,212,161,4,242,108,36,93,190,32,59,94,0,235,86,3,172,233,95,181,56,252,2,240,70,234,104,212,220,112,61,180,47,154,173,161,139,146,142,243,66,172,218,217,20,169,2,225,206,220,119,116,34,110,64,72,18,169,
60,253,129,202,6,86,109,79,1,98,28,69,145,58,139,182,221,101,184,65,252,139,70,83,141,26,1,211,100,41,63,216,75,230,56,178,131,29,94,208,52,94,0,225,96,3,57,111,69,70,61,169,27,25,229,38,212,6,144,37,20,213,192,70,212,198,128,95,17,245,241,94,218,97,196,40,222,138,22,128,53,125,212,127,129,87,187,233,144,26,48,163,162,159,246,105,25,235,153,201,12,219,209,116,67,134,139,50,52,101,151,62,238,20,145,169,174,98,211,114,43,43,202,75,168,173,100,183,62,212,134,237,178,19,35,213,76,79,44,27,35,179,93,219,173,128,222,29,75,87,164,176,110,168,221,217,203,237,141,108,134,14,184,138,108,73,94,196,245,130,44,235,71,138,12,89,206,141,223,6,171,82,113,144,229,250,3,21,135,131,24,147,215,115,30,58,6,172,197,236,214,151,217,101,129,13,185,34,77,35,165,147,182,139,177,75,54,50,99,12,154,79,71,101,253,235,183,37,38,15,109,75,218,78,85,177,202,242,66,73,42,144,188,158,80,94,88,146,158,203,14,83,188,132,161,189,84,147,45,115,82,45,203,203,17,174,15,240,245,202,80,1,95,54,122,173,40,175,192,241,
6,138,202,74,152,0,244,153,99,11,206,64,23,131,124,72,137,172,216,210,38,53,219,50,174,225,98,77,122,90,92,152,51,241,51,87,102,203,162,163,26,150,221,236,84,133,198,119,20,1,52,133,79,43,234,9,60,18,73,3,122,93,212,147,121,172,34,227,145,93,70,74,50,89,177,203,72,73,246,150,213,200,38,218,158,141,205,11,114,216,39,182,202,216,24,211,22,3,158,245,188,224,174,151,83,47,163,121,56,49,115,66,207,197,8,136,119,123,190,112,29,202,129,151,243,174,151,85,96,106,113,87,168,13,119,198,24,91,221,117,56,31,183,217,225,212,109,80,20,176,43,102,210,227,145,219,56,107,195,37,196,210,192,239,141,84,100,231,148,236,128,243,233,21,192,220,51,139,201,212,161,110,194,208,202,76,28,235,197,67,234,194,48,22,243,87,156,6,27,66,115,134,28,20,85,219,185,182,109,217,179,153,89,209,76,55,44,174,204,188,10,104,235,38,181,37,182,177,68,112,219,14,76,154,1,89,231,216,83,151,143,93,192,105,89,180,134,16,50,123,242,174,15,187,194,128,138,59,193,49,81,180,251,93,171,91,154,31,215,178,3,32,220,224,22,235,46,
110,184,194,104,234,118,166,45,127,167,75,70,93,48,150,22,26,233,71,67,13,231,198,220,149,37,165,111,43,70,112,35,57,26,203,145,57,153,81,163,41,246,167,141,21,57,12,101,59,84,210,203,198,193,224,58,196,113,133,75,176,110,211,140,172,113,14,65,90,97,103,137,236,171,203,222,80,125,174,114,52,22,99,164,99,188,218,166,30,147,211,210,164,118,73,198,185,141,112,39,49,7,172,28,173,36,59,19,217,17,74,61,145,237,37,217,198,77,182,38,67,51,50,88,150,173,137,12,36,10,119,155,163,121,234,203,148,163,37,202,128,148,163,177,13,34,59,153,48,126,131,85,57,26,70,145,24,71,243,140,163,129,126,198,209,66,59,159,224,104,120,85,163,93,79,132,242,56,52,173,91,30,243,140,163,133,242,112,183,60,228,201,131,158,68,21,121,48,210,244,195,112,183,4,202,32,143,38,218,44,225,84,195,53,231,172,13,198,167,174,25,149,115,104,121,210,101,196,16,202,134,79,87,53,123,82,49,22,201,58,149,178,65,48,205,217,245,195,58,49,35,79,182,178,89,60,219,41,158,234,86,29,133,167,126,84,117,107,124,22,12,217,23,64,186,119,157,
181,65,141,185,208,194,218,178,139,101,44,135,97,212,137,93,44,61,57,230,201,172,49,112,120,248,107,161,204,133,242,122,108,49,34,207,46,236,220,35,97,109,220,170,184,176,103,172,205,182,142,145,53,44,232,109,79,206,251,114,33,148,119,18,121,47,145,165,64,222,251,144,155,32,190,158,73,67,217,127,135,185,185,167,114,230,86,104,158,59,122,196,72,155,49,182,214,229,190,235,27,210,159,122,27,58,131,121,11,121,227,251,154,103,22,78,29,93,56,173,241,203,127,177,217,221,150,13,237,72,222,127,129,231,221,206,121,222,147,70,30,160,93,143,130,61,60,1,230,80,149,7,125,137,98,121,160,42,81,36,15,192,34,170,246,151,146,62,137,250,44,125,37,150,7,19,121,8,214,87,146,199,99,121,34,145,39,91,51,202,65,146,146,60,198,96,37,85,164,178,67,95,249,8,99,63,230,27,183,131,132,199,242,36,188,29,230,146,24,9,15,148,207,171,70,59,185,93,210,230,118,217,222,229,72,184,67,236,56,12,178,64,160,121,82,252,41,219,119,144,139,70,182,125,237,26,152,157,177,35,120,28,11,144,105,252,143,147,192,120,136,242,20,
98,49,118,103,222,203,182,49,175,68,172,135,83,17,178,3,155,132,7,117,119,43,65,120,174,124,103,13,122,38,225,120,240,86,155,96,105,21,232,17,132,142,211,45,99,102,217,233,102,188,84,253,17,38,106,146,41,185,133,91,128,111,172,102,172,16,67,194,124,165,98,15,249,242,96,32,145,47,63,12,228,7,177,132,221,242,131,62,249,161,47,15,64,218,140,171,41,96,25,19,182,17,216,68,74,215,108,112,238,43,221,198,5,213,193,217,2,88,6,14,46,3,137,35,67,207,120,115,154,236,101,168,22,158,20,191,166,204,195,14,188,54,12,145,58,13,210,24,255,14,142,248,245,195,47,99,19,108,124,72,41,251,200,78,2,221,248,173,162,157,235,230,122,123,74,178,17,50,198,95,168,217,243,67,242,28,212,12,98,10,73,234,142,111,84,211,15,187,171,46,190,109,224,197,55,6,211,226,109,217,248,97,225,198,160,235,190,141,219,184,1,253,189,45,21,88,2,236,201,104,84,230,200,17,9,236,148,25,68,186,201,193,14,74,203,254,199,108,30,173,229,198,99,76,173,24,105,45,196,77,125,1,237,75,198,209,64,164,104,46,63,182,43,1,39,180,121,125,136,
136,78,148,209,88,104,218,58,153,88,63,77,137,144,34,124,164,48,65,77,179,19,64,193,130,0,21,205,71,112,148,102,113,131,146,197,159,176,25,142,82,220,110,230,41,176,165,41,189,44,79,122,55,8,189,221,214,232,2,190,5,99,196,231,224,127,218,0,226,151,138,72,174,23,243,145,148,86,138,168,15,36,64,177,73,59,250,35,46,184,173,7,27,234,3,121,165,143,222,13,187,82,208,184,230,64,209,191,173,148,141,113,53,32,107,113,50,210,131,40,184,161,196,162,54,173,243,245,195,61,217,26,40,175,108,180,130,160,123,209,120,52,156,101,157,144,193,130,35,213,205,115,177,26,121,39,236,92,177,158,142,20,216,167,106,119,54,166,238,74,187,125,115,249,192,224,244,118,156,81,224,140,168,173,111,76,195,150,165,179,143,56,171,219,71,171,241,252,54,182,88,97,206,210,118,226,124,137,212,102,28,133,43,115,196,149,25,48,60,0,108,184,240,182,114,182,49,99,113,32,137,66,32,1,42,156,57,115,181,201,117,182,20,217,29,41,59,137,88,26,251,181,36,101,200,217,115,161,60,191,36,207,93,118,24,227,165,8,92,107,210,59,39,125,
128,18,99,212,55,170,174,114,91,182,84,50,80,171,69,217,2,57,123,185,40,253,101,214,128,22,144,32,51,126,56,25,164,129,109,165,135,29,215,76,135,6,203,183,165,12,57,123,14,114,134,23,160,26,157,161,204,59,68,141,85,198,249,27,5,68,57,67,32,35,106,28,183,37,217,206,209,27,107,200,88,173,171,34,141,72,70,45,132,210,38,106,68,55,97,108,118,90,215,219,22,133,158,25,6,80,213,156,108,54,102,230,176,123,222,187,145,49,179,219,234,179,80,210,51,33,162,121,183,57,23,111,16,203,188,221,14,105,224,34,216,10,155,10,55,134,211,194,128,218,30,99,128,37,182,142,63,208,51,16,202,204,106,112,3,240,199,37,217,94,145,109,83,50,220,170,200,144,237,9,156,43,251,35,195,95,73,88,230,22,76,98,68,215,149,100,87,83,99,93,56,40,13,201,176,77,57,17,178,11,21,142,203,182,169,70,89,216,163,70,218,244,188,198,101,217,173,76,193,227,245,193,134,221,2,229,192,124,50,223,101,122,87,147,207,54,101,100,244,62,139,228,5,55,134,53,162,134,168,234,223,241,97,217,29,106,234,198,166,67,205,219,50,126,213,221,24,82,89,
47,70,155,92,115,200,121,3,174,53,221,159,182,216,107,105,241,70,191,11,7,137,104,111,107,113,75,253,186,183,51,142,71,158,207,188,234,129,105,152,45,108,190,255,192,120,191,115,93,105,92,59,240,97,84,115,33,79,104,213,3,173,241,219,202,4,14,135,242,42,140,173,9,244,216,206,116,114,163,63,157,187,45,7,97,113,251,75,22,74,139,101,111,192,172,83,183,149,88,76,122,250,126,51,89,239,8,160,153,111,129,133,52,170,230,103,160,107,51,26,93,152,224,172,65,186,145,208,84,131,63,34,210,132,1,37,22,226,228,121,172,100,124,173,42,181,25,121,165,44,253,137,197,212,66,227,107,68,172,0,53,139,169,37,26,195,210,205,79,72,43,178,243,138,205,239,233,78,126,54,227,107,196,19,238,138,169,193,215,66,187,17,123,118,106,225,130,61,121,148,80,154,39,113,183,60,12,95,131,27,132,242,64,183,252,208,147,31,120,18,86,228,7,145,166,31,160,60,209,152,195,67,28,252,22,131,123,4,223,237,153,239,94,39,113,161,69,30,224,113,54,169,58,151,156,196,225,149,48,106,182,26,11,110,111,170,78,18,103,209,67,189,241,224,
18,60,59,205,32,113,158,61,243,101,103,60,23,11,11,196,67,226,218,222,25,154,28,42,89,214,8,47,148,138,23,165,4,5,89,116,60,139,190,133,22,125,11,229,88,40,179,161,156,72,236,129,192,147,147,158,188,158,88,116,154,232,27,241,93,79,22,66,89,36,244,230,217,171,75,40,231,18,57,159,200,133,64,206,119,112,180,102,78,187,188,189,39,23,230,79,158,78,122,220,191,44,187,213,251,182,17,88,251,163,224,102,125,167,171,54,27,24,83,221,53,235,51,174,186,240,147,70,221,69,85,247,135,222,72,211,13,78,84,57,11,70,92,189,113,174,48,120,232,39,77,130,180,220,21,238,60,71,255,253,124,236,111,14,30,159,231,37,123,125,224,214,165,226,205,218,137,66,245,165,41,118,60,167,238,192,137,143,47,12,184,226,240,146,27,88,58,187,125,201,13,46,17,72,46,12,187,153,250,146,63,188,68,176,153,16,240,21,111,104,137,56,241,165,96,200,181,252,186,187,218,228,5,121,32,37,92,221,100,99,12,184,15,203,108,12,46,109,181,244,210,20,129,110,162,201,74,88,211,75,181,65,87,102,23,12,206,186,234,236,77,222,215,120,50,186,179,
194,111,125,154,175,48,151,126,163,45,146,107,160,1,224,254,43,123,106,213,40,231,31,44,90,8,196,30,219,178,139,21,214,190,219,2,72,123,141,149,29,224,213,180,112,179,190,192,226,11,141,5,162,233,222,170,134,255,103,120,109,10,111,130,12,1,38,46,160,171,114,172,112,179,225,134,234,243,110,112,70,15,213,106,90,90,149,217,146,28,111,88,40,181,79,78,244,105,112,252,68,85,94,187,56,35,199,9,176,218,139,194,81,94,120,109,48,158,71,94,181,39,184,105,24,119,201,158,118,152,158,227,188,79,95,5,247,232,182,205,159,86,8,250,113,9,200,158,137,121,30,8,44,116,203,227,68,44,140,118,140,39,146,68,31,138,218,175,118,129,190,27,189,206,59,1,143,3,60,110,242,50,192,115,48,143,117,129,62,16,191,13,225,47,32,132,227,168,35,36,99,114,188,235,203,82,73,227,182,231,237,49,143,86,103,35,125,87,230,242,192,48,12,124,152,5,218,59,5,148,131,107,39,108,4,183,13,105,195,127,111,47,202,182,159,45,234,27,137,46,131,214,8,236,155,25,219,147,138,46,163,40,243,21,53,227,197,192,110,33,254,205,145,81,192,59,235,
110,142,205,160,86,127,213,150,133,41,123,55,45,70,84,24,115,193,170,92,40,105,44,249,125,16,78,11,205,148,118,133,85,73,125,13,40,167,69,73,91,101,203,84,36,141,229,3,154,69,42,192,123,196,158,43,242,78,164,47,224,109,73,34,57,27,203,91,145,188,25,233,236,11,60,52,241,178,20,235,211,218,27,200,22,233,139,250,156,173,22,33,89,60,143,84,71,35,69,117,38,146,195,132,200,209,14,239,137,92,132,209,78,89,95,198,72,99,8,135,81,95,246,174,21,221,121,166,103,28,133,61,123,159,231,81,15,121,121,41,109,139,108,224,151,44,92,94,148,11,141,155,252,212,195,2,179,8,74,19,22,197,114,232,173,107,177,103,127,238,117,204,192,252,192,190,223,30,137,212,117,219,47,8,136,95,128,63,212,5,21,236,180,208,17,143,29,59,150,51,23,196,61,18,138,157,133,242,50,142,152,5,69,109,8,6,66,132,67,182,126,44,16,125,29,231,57,149,112,191,77,12,20,250,216,139,211,159,191,56,39,167,107,178,80,148,197,154,188,57,141,215,65,9,174,190,20,175,234,11,47,166,113,206,187,105,68,41,90,149,183,195,155,245,67,110,98,222,141,
166,133,225,249,198,170,188,59,167,26,120,55,238,248,203,144,231,49,188,146,156,171,200,217,134,122,176,51,104,196,204,18,148,16,94,213,193,236,64,80,212,183,122,214,211,86,71,22,157,48,180,85,29,165,14,117,240,222,106,167,219,126,20,132,80,217,139,113,104,63,159,224,201,21,109,198,182,35,114,83,84,59,68,53,60,54,218,140,24,195,155,182,140,183,188,155,19,132,74,116,55,183,247,7,2,57,108,237,124,225,230,176,243,70,207,80,241,142,187,57,145,34,60,27,228,61,12,45,144,247,177,64,119,115,242,88,97,108,9,207,144,182,135,104,27,104,85,11,154,135,10,19,231,130,49,29,54,245,111,78,186,143,166,246,190,95,216,185,16,78,56,175,233,90,115,59,93,43,193,174,167,210,120,47,169,41,167,232,237,79,189,134,107,85,71,93,120,48,45,140,165,201,126,247,81,113,204,213,167,210,194,65,140,37,157,26,77,61,107,226,77,185,241,177,212,29,76,189,81,23,237,119,31,86,109,5,7,157,127,40,45,76,164,204,201,134,74,113,202,135,156,63,153,22,14,167,222,132,107,233,210,234,146,70,108,156,153,155,135,157,99,67,205,104,
64,40,154,132,152,80,23,75,218,176,191,30,45,198,37,229,225,230,34,123,171,36,41,127,179,77,199,115,78,36,239,243,174,3,8,177,66,193,238,188,64,252,160,42,231,120,12,234,214,39,161,51,4,26,18,125,36,226,176,58,157,40,210,243,158,237,179,80,78,90,108,130,8,5,113,138,227,156,117,68,46,208,109,73,142,152,157,31,230,117,144,83,17,77,134,22,122,200,108,222,211,167,43,14,82,60,243,4,156,196,162,36,252,190,129,4,87,102,66,78,132,72,166,104,233,229,175,238,54,136,110,77,158,180,248,53,3,126,145,224,72,40,199,215,13,156,224,136,173,7,115,59,197,175,25,34,126,172,96,193,17,86,158,200,91,158,89,118,34,111,227,137,178,160,72,40,239,70,237,167,172,247,121,199,2,7,112,9,13,16,254,146,6,45,254,81,206,63,74,192,106,189,112,154,147,193,205,184,176,243,55,93,247,62,145,31,81,247,13,46,156,62,123,230,200,209,35,111,189,229,254,85,217,173,201,128,187,111,150,83,218,253,55,14,169,53,59,164,220,114,212,123,117,138,154,79,231,237,122,88,183,171,86,107,73,134,187,53,102,166,161,214,170,236,168,203,206,
166,140,16,65,224,38,83,145,93,137,140,13,201,120,195,126,162,48,101,209,86,206,145,110,217,219,109,103,74,93,246,197,178,191,91,14,180,10,234,209,244,212,201,189,11,39,13,14,166,105,87,114,208,229,167,35,28,137,184,18,253,145,132,5,32,213,217,240,178,218,170,91,192,174,42,67,101,25,36,154,60,164,177,120,174,87,3,23,23,229,149,68,31,86,95,129,219,183,130,229,200,141,71,189,203,72,86,171,217,111,164,44,74,172,23,71,243,88,140,214,96,240,236,226,69,192,176,97,55,218,86,67,9,20,215,215,93,28,49,217,172,198,182,119,212,236,160,225,202,89,146,97,187,21,240,119,91,153,57,10,107,178,189,33,117,22,214,236,8,59,243,27,152,154,140,49,88,89,38,98,96,44,175,201,120,11,247,73,20,218,226,15,200,165,30,212,14,177,157,28,98,246,130,58,108,15,36,42,19,119,177,218,229,33,70,159,141,32,209,107,242,242,141,62,50,115,143,164,63,189,176,38,123,46,151,151,43,22,85,238,90,90,124,196,241,51,57,66,13,179,253,169,219,148,210,116,95,43,92,238,85,226,18,110,114,94,191,251,168,208,235,226,26,84,61,117,149,
116,188,226,146,46,99,51,155,82,30,231,43,155,92,185,150,22,122,83,175,43,245,251,221,101,127,205,30,104,171,203,53,87,237,117,62,191,121,169,164,229,103,63,240,187,92,11,20,15,242,52,222,45,7,91,222,114,133,58,23,108,73,11,61,105,169,235,125,255,89,119,177,180,38,211,173,198,242,22,231,122,211,66,57,245,123,156,43,206,123,93,238,119,179,33,167,136,36,38,22,168,229,231,34,60,43,178,125,0,34,212,176,44,191,19,81,156,185,6,246,233,243,241,142,170,145,89,98,226,23,157,140,37,218,2,192,148,205,242,27,165,110,217,195,40,60,9,37,50,197,175,107,98,57,144,24,155,13,229,80,162,158,153,91,136,158,137,229,246,15,175,212,253,38,198,4,74,26,149,60,89,177,183,100,78,222,162,156,194,59,20,150,185,215,244,58,36,91,192,99,36,248,141,229,98,7,153,251,230,119,243,157,34,205,119,78,45,30,57,125,210,125,254,188,251,76,183,137,146,89,247,223,217,38,159,217,54,249,147,232,147,114,26,149,157,215,147,70,61,46,68,252,178,243,123,210,176,199,5,229,52,96,18,43,247,202,105,152,167,253,142,52,112,81,78,95,
218,103,229,206,218,83,158,141,73,121,214,55,43,239,28,39,235,203,248,89,27,218,211,38,200,230,237,65,17,46,43,103,61,197,114,90,44,187,241,174,180,200,239,32,45,221,236,74,187,187,92,195,210,252,64,178,212,229,198,45,61,109,233,172,205,172,165,185,5,210,151,52,125,23,203,105,179,236,46,47,125,102,206,48,163,1,101,25,89,110,2,65,252,85,177,195,14,145,128,35,238,113,217,114,239,74,175,139,151,193,135,120,153,24,64,73,154,49,127,19,190,172,77,86,190,62,38,88,123,42,185,66,9,142,160,128,252,153,216,217,210,167,109,180,117,241,146,178,3,2,182,3,229,164,103,76,188,245,52,229,179,86,78,95,210,243,229,180,82,118,63,27,50,93,69,38,88,166,103,132,100,38,157,79,193,206,177,255,42,16,153,45,208,38,211,127,6,4,66,174,11,118,151,144,25,16,8,150,233,31,32,92,158,102,210,130,154,152,218,87,38,48,186,101,94,26,80,232,122,220,149,248,171,72,131,238,111,118,214,137,243,129,178,69,172,183,137,173,60,51,90,22,186,94,222,185,136,245,190,106,180,157,227,228,233,117,3,206,198,225,14,136,48,229,178,
187,90,172,164,81,197,181,152,132,141,116,52,249,164,236,90,245,174,244,242,217,46,55,103,2,92,234,235,34,94,129,187,73,138,218,98,160,251,147,162,187,132,30,0,34,48,208,233,137,156,164,1,157,101,144,206,64,103,25,204,149,41,6,92,178,54,172,25,208,179,190,157,105,48,161,13,237,25,135,114,210,180,201,148,196,56,217,152,235,109,24,159,116,54,126,54,23,243,122,101,7,206,152,91,98,155,61,43,103,109,148,179,6,188,31,229,164,139,214,166,104,109,178,246,164,179,117,210,151,52,109,18,107,79,95,202,179,113,232,155,173,45,147,145,181,41,206,182,6,214,166,138,207,215,156,25,10,50,174,239,188,204,200,50,89,50,28,178,116,134,3,105,228,205,118,79,54,102,214,38,75,103,125,59,211,89,95,218,51,239,157,91,174,91,191,227,127,107,240,157,83,71,143,204,187,127,237,220,47,101,214,221,23,170,95,252,31,248,197,95,154,95,252,227,226,239,111,76,47,87,54,186,127,212,220,156,94,156,219,236,254,113,247,230,244,82,55,63,19,153,35,223,216,236,110,204,147,159,218,220,57,118,152,57,221,255,201,32,127,97,131,
116,204,219,174,251,95,212,253,229,215,212,253,111,234,254,234,107,234,254,15,117,191,90,175,131,161,190,195,231,2,228,249,60,244,245,92,8,249,238,230,114,193,247,25,62,111,38,171,176,200,85,104,228,42,60,114,21,34,185,10,147,92,133,74,174,114,138,172,66,38,87,57,83,86,121,240,90,133,79,174,66,40,185,118,83,127,140,244,209,210,42,236,111,149,179,104,149,31,157,113,109,167,255,33,202,167,105,115,144,252,1,202,247,243,217,71,122,15,159,73,210,187,249,76,80,63,70,126,23,233,209,82,150,222,205,237,172,73,217,94,62,83,148,239,231,251,32,223,211,124,44,36,192,216,135,73,207,80,174,115,30,165,253,49,190,103,25,235,56,223,175,81,55,199,71,215,251,58,121,93,255,60,159,83,164,79,179,166,5,190,23,169,123,147,207,25,198,122,139,252,89,202,207,145,126,155,177,206,211,246,2,117,239,240,121,151,242,247,248,94,162,238,125,234,62,160,46,37,157,82,166,87,104,251,214,60,99,216,71,203,242,242,10,233,206,186,233,143,32,167,31,193,78,63,250,10,61,253,191,252,87,133,78,102,186,230,156,177,83,168,105,
246,159,90,148,167,230,12,117,141,255,217,112,135,162,194,243,96,27,91,235,107,176,84,190,91,75,107,240,212,53,184,34,4,141,79,189,186,6,87,93,131,172,174,193,86,215,160,171,107,240,213,53,8,235,26,140,21,122,214,88,131,179,174,201,110,8,239,36,229,77,234,247,208,127,47,159,125,125,124,211,119,31,101,251,201,195,94,225,67,52,158,102,160,131,190,210,38,42,249,236,37,191,135,239,102,196,32,124,239,38,63,65,122,156,239,49,242,187,116,82,242,13,210,35,124,118,50,6,132,54,91,229,112,117,13,78,203,242,139,44,159,21,13,208,112,43,31,136,237,26,204,118,13,106,203,55,189,32,183,87,32,183,136,190,12,123,169,213,104,194,184,218,116,136,218,109,204,181,157,239,29,124,116,14,157,107,151,206,79,253,56,83,76,52,88,23,243,78,182,72,140,83,57,70,229,46,190,215,23,70,126,39,249,29,12,92,231,123,59,29,183,209,97,24,84,134,72,235,247,182,50,43,0,132,237,13,218,168,16,205,76,152,17,234,13,89,202,118,209,127,140,250,241,50,147,222,33,193,204,76,163,9,6,206,81,25,37,189,142,8,147,215,145,83,37,24,38,
173,18,25,32,151,85,212,203,67,76,59,187,188,78,138,201,205,45,127,133,21,47,67,116,151,225,197,87,32,198,87,96,198,87,160,198,203,112,227,229,78,114,188,12,59,190,2,61,190,162,252,248,10,4,249,10,12,217,122,194,145,233,149,92,129,37,211,171,64,175,128,17,42,52,46,211,169,0,179,246,150,33,203,116,204,216,50,182,80,165,115,149,65,124,6,40,64,204,203,203,80,102,6,200,56,51,13,186,177,145,150,199,176,62,67,5,203,240,230,101,136,243,50,204,249,202,58,117,190,2,117,102,112,56,41,131,115,238,46,67,159,25,35,227,207,107,50,229,97,95,9,246,5,50,123,64,79,141,115,146,178,221,138,36,101,227,124,118,241,49,21,98,62,35,125,168,131,250,29,232,123,39,40,142,208,30,70,141,62,24,68,27,43,252,187,105,48,73,69,147,5,238,209,193,75,217,36,83,21,12,154,242,3,148,29,228,51,77,251,67,124,191,74,253,97,210,51,244,61,130,78,143,242,125,140,207,44,109,143,83,127,130,244,107,180,153,163,205,73,198,120,157,239,55,168,155,103,65,167,72,159,46,92,129,244,128,148,83,202,189,6,231,94,195,207,94,233,36,221,
223,250,135,250,95,149,114,190,253,25,155,95,57,55,132,59,219,252,202,190,115,222,253,217,61,46,35,222,87,57,32,63,225,100,187,202,17,249,9,240,145,247,201,135,228,3,242,1,249,66,187,222,35,31,118,228,253,187,242,133,118,94,199,211,254,121,189,107,247,215,250,168,61,159,214,231,227,229,245,121,62,159,47,31,79,243,121,123,237,175,237,131,124,125,164,11,148,229,245,186,254,34,243,20,249,30,255,4,86,122,21,198,222,206,55,201,119,147,111,180,243,83,228,75,228,199,219,249,233,118,62,111,63,219,206,79,181,235,53,175,227,45,146,111,50,126,198,227,63,147,93,222,103,92,71,63,147,70,249,179,156,203,83,123,55,138,97,91,138,28,21,173,143,145,34,151,242,183,229,115,169,20,245,92,75,138,82,142,130,106,77,243,49,245,57,106,119,163,152,183,207,235,59,231,83,13,123,138,100,123,124,93,155,34,171,136,230,40,230,82,79,183,231,233,68,41,161,157,162,154,128,138,214,107,126,166,141,82,103,94,235,103,219,245,58,158,230,231,201,87,104,255,179,33,18,42,96,212,6,40,55,67,5,76,23,147,45,10,21,183,243,185,
89,222,13,112,158,207,1,86,129,115,128,21,176,28,128,175,3,44,7,88,1,202,205,84,1,118,29,121,93,91,129,50,93,175,206,151,3,168,102,167,235,211,182,170,52,71,254,74,220,177,128,188,131,85,126,205,128,182,192,142,9,242,5,119,46,32,110,215,231,251,82,5,236,172,191,123,193,122,185,206,23,108,251,178,35,127,247,124,249,62,84,0,242,241,19,198,215,124,25,129,174,22,63,225,6,114,85,175,32,148,216,29,132,210,86,29,133,94,62,139,70,231,40,85,57,47,245,81,114,49,162,164,149,124,210,190,138,92,213,171,8,245,10,108,0,46,138,131,142,162,237,53,175,138,214,181,106,62,87,180,130,173,235,200,13,67,193,206,219,171,156,170,232,124,188,187,243,58,126,110,40,58,190,214,107,94,219,231,134,162,227,231,243,117,182,215,249,53,159,207,159,175,71,215,231,209,95,245,170,187,38,33,159,43,94,215,175,242,104,189,174,215,111,215,107,190,216,110,95,108,183,207,251,107,62,151,79,199,211,188,182,79,218,253,117,60,173,207,231,215,249,52,223,137,87,110,168,249,122,85,30,51,76,198,203,229,205,13,91,241,82,79,145,
203,159,111,148,60,159,227,155,231,115,124,53,175,248,229,158,196,236,168,61,190,206,151,231,243,241,238,206,231,227,105,127,109,223,113,41,57,194,129,149,223,131,126,201,121,165,119,33,46,66,217,121,165,183,162,252,62,244,203,123,92,251,66,244,99,189,17,253,190,94,137,126,172,119,34,82,151,186,73,93,159,211,178,6,169,27,243,90,54,69,170,99,162,167,153,232,59,199,22,22,223,57,115,242,181,185,179,201,211,155,95,104,79,146,223,149,254,66,255,159,239,250,255,221,221,64,243,251,71,79,30,155,59,114,124,62,217,182,112,102,54,73,146,118,135,252,2,245,151,95,233,192,175,235,238,253,59,52,26,56,115,108,238,228,219,199,223,106,55,206,111,84,127,245,155,141,123,54,110,74,250,250,54,111,238,173,84,218,141,243,43,214,175,190,210,248,190,118,237,157,197,253,127,75,254,159,0,0,0,0,255,255,3,0,22,47,158,17);



programfile__ABATAKEACHANCEONME_MID
:array[0..16872] of byte=(
120,1,236,189,105,112,28,217,157,224,151,226,148,170,185,53,52,2,171,69,116,112,48,220,90,44,9,82,24,8,2,27,232,86,77,169,10,69,36,146,197,2,81,40,18,32,136,139,184,8,162,209,108,52,154,66,67,32,72,161,41,144,156,4,216,100,55,155,77,178,0,18,5,2,32,55,194,225,113,132,35,236,13,169,117,159,225,251,182,63,216,223,252,105,125,140,237,245,177,177,254,100,127,177,229,223,255,159,239,21,142,166,102,36,205,174,70,218,73,69,180,94,230,123,255,251,124,249,50,81,60,211,59,53,233,56,78,212,249,156,243,247,62,247,79,206,244,206,189,203,221,119,156,127,254,249,91,183,255,206,231,254,111,231,23,231,254,96,255,141,90,231,23,131,145,200,190,131,251,157,95,92,216,231,56,255,143,220,238,227,246,158,107,230,63,59,179,252,111,252,139,2,250,44,237,207,206,56,191,56,238,4,162,239,95,119,126,241,7,175,156,159,159,123,103,230,237,171,206,47,254,225,231,28,231,23,53,252,223,183,94,249,134,243,173,152,235,252,187,85,143,24,155,157,111,253,225,109,231,91,195,109,206,183,70,157,127,158,120,156,190,24,249,
22,64,255,196,113,11,127,150,118,235,30,167,59,134,24,227,143,189,225,220,159,121,110,243,99,175,107,134,177,226,113,186,43,199,124,227,227,116,126,146,241,224,99,175,48,196,60,112,231,100,61,246,56,125,206,172,255,181,240,155,31,167,11,211,208,175,120,236,13,121,1,255,129,73,198,131,143,211,25,35,95,151,200,119,248,177,119,190,155,249,186,199,94,159,225,63,208,205,60,242,171,124,85,143,189,129,66,176,222,191,192,24,121,156,238,243,88,71,223,83,34,63,235,19,70,126,165,95,245,56,125,70,228,135,63,250,164,209,199,27,237,7,15,62,67,211,140,232,127,78,248,55,64,223,216,103,212,216,7,190,34,71,250,180,240,183,246,65,254,65,67,63,111,240,187,250,89,7,174,211,224,143,27,249,71,123,193,143,67,223,200,127,78,224,224,107,232,122,29,162,191,200,103,214,59,205,250,37,193,111,68,78,131,127,222,200,119,218,232,55,105,228,191,40,248,213,143,211,185,157,246,65,190,73,177,111,226,177,119,198,172,247,137,254,232,119,206,224,15,25,249,10,134,127,89,255,113,224,176,159,210,37,14,250,205,122,191,
161,95,48,242,161,175,218,79,225,144,223,232,157,110,95,32,102,42,161,33,114,87,27,58,21,143,83,23,135,254,44,229,214,62,78,229,38,25,197,63,121,214,209,143,121,241,127,170,207,172,227,95,93,159,52,246,237,155,99,61,250,56,53,220,27,224,23,102,24,241,159,218,183,129,56,25,103,29,250,125,227,204,199,31,167,242,102,125,50,144,219,27,53,244,129,211,245,46,75,223,240,239,26,3,191,234,113,10,187,167,240,75,170,207,172,15,9,94,45,241,103,214,187,10,172,55,0,103,214,47,26,255,168,125,225,159,234,102,189,238,113,234,188,197,23,185,176,159,230,87,236,113,10,255,235,250,153,5,70,199,216,5,59,0,175,252,207,136,254,34,255,52,35,254,83,255,19,255,237,102,157,120,81,252,142,249,0,127,64,228,194,190,3,18,255,206,227,212,144,177,79,126,241,177,55,86,9,140,200,71,254,246,79,49,194,31,125,212,254,39,167,24,43,137,15,163,191,250,31,249,79,138,220,213,143,83,196,163,242,159,52,242,171,253,136,95,236,146,102,61,200,63,137,175,121,165,235,157,21,249,200,159,62,19,31,253,243,192,69,144,95,242,19,255,
96,47,15,126,105,226,72,234,74,26,123,5,249,105,226,239,156,216,25,186,26,151,172,231,133,206,242,207,186,153,9,51,85,45,21,102,42,17,66,165,8,51,21,59,252,174,101,234,246,254,228,31,60,101,127,18,241,46,93,221,222,156,124,206,249,246,43,239,56,223,102,115,242,239,125,241,145,142,223,102,115,242,237,225,42,231,219,163,113,255,65,190,120,100,40,250,109,118,39,255,189,227,214,249,71,220,238,226,145,145,4,99,75,241,200,85,127,132,139,234,226,241,203,254,9,255,184,219,44,23,167,185,168,43,30,25,200,177,210,204,216,204,152,43,30,153,242,123,184,136,23,143,191,235,71,129,152,46,30,159,242,107,185,96,233,156,128,38,13,85,175,120,100,220,127,131,137,22,129,56,0,196,164,224,8,249,134,226,145,254,22,86,0,25,54,84,71,96,119,4,118,128,26,170,239,250,53,128,34,243,72,146,21,168,15,55,48,22,138,71,222,222,6,53,84,223,246,147,128,34,99,175,80,5,116,84,168,66,253,178,149,181,44,192,12,34,9,104,188,63,231,199,17,45,94,104,102,204,21,227,51,80,141,35,64,253,184,191,207,175,119,103,138,245,147,
126,63,23,85,197,248,112,55,43,141,197,248,72,11,163,91,140,79,34,89,28,73,234,167,253,106,32,250,139,245,51,8,80,47,84,167,10,172,48,78,8,40,212,71,97,39,23,245,189,74,117,170,88,63,234,159,5,52,94,140,247,244,178,2,213,11,9,198,178,0,181,197,250,9,255,85,32,134,132,234,105,46,14,23,227,183,133,154,87,140,119,27,1,102,253,65,38,170,138,245,125,24,171,30,23,212,139,183,20,116,196,168,53,102,4,16,99,197,93,168,246,224,130,122,92,0,249,19,92,52,20,227,215,12,213,41,35,192,53,36,139,35,25,138,27,208,89,164,175,71,250,35,51,98,87,151,48,17,87,48,206,66,245,8,84,143,79,98,129,227,88,224,184,240,209,112,153,20,80,80,222,54,227,160,63,206,68,229,14,199,190,237,55,2,218,82,60,138,61,143,162,249,209,201,2,99,67,241,232,187,4,225,81,64,155,198,81,171,9,181,154,250,152,105,114,43,138,71,145,245,40,22,56,122,89,70,80,223,246,103,139,77,19,17,110,252,215,128,104,41,54,141,161,86,147,168,245,174,81,75,71,92,48,73,12,196,221,131,197,250,183,213,174,227,197,250,41,223,67,173,186,98,252,166,199,
10,32,80,213,113,216,199,148,83,49,110,252,47,0,209,43,56,98,215,186,226,209,22,35,192,112,34,16,100,82,101,173,40,54,13,3,218,132,93,155,46,0,218,132,183,142,94,237,6,164,177,120,116,220,200,58,128,0,71,177,107,211,20,2,52,225,216,166,183,137,172,38,137,172,219,34,0,17,53,101,4,24,211,112,105,22,39,137,0,120,235,154,10,64,12,88,111,205,26,208,192,177,135,69,155,67,128,106,184,72,16,22,36,148,71,138,71,187,196,171,30,140,231,138,71,251,196,90,93,117,220,248,167,139,71,207,199,96,46,50,250,135,138,71,47,32,202,81,68,105,234,158,100,214,255,66,177,169,7,35,28,237,175,228,174,87,96,14,20,143,14,76,154,139,110,255,50,87,177,98,211,25,127,150,117,7,56,193,246,107,138,71,7,117,41,82,108,234,29,18,58,175,22,155,206,193,244,232,144,56,18,130,71,134,133,187,100,37,75,212,133,235,68,76,76,238,46,19,10,14,203,121,185,57,86,60,50,129,60,71,144,231,56,76,143,11,247,227,195,240,82,152,73,89,241,171,41,8,5,185,168,165,154,193,226,120,111,92,238,122,138,71,46,84,2,39,245,204,127,141,10,0,229,
35,110,164,120,188,71,233,124,65,10,218,116,64,103,132,56,151,82,115,180,103,74,132,223,87,60,122,206,191,194,21,194,23,68,230,222,42,100,22,223,33,15,166,59,205,213,97,236,211,45,154,212,20,155,6,253,43,160,70,184,27,23,152,74,96,212,8,213,98,76,67,231,12,23,77,16,60,218,107,151,122,116,201,193,188,189,134,206,168,240,26,17,95,64,240,200,80,12,98,189,34,252,1,52,17,189,46,88,189,250,164,32,74,101,245,81,25,107,96,146,90,238,18,204,98,204,227,0,7,122,81,166,128,193,134,195,187,128,123,44,157,225,24,112,146,149,126,125,241,72,31,121,35,169,124,252,108,78,232,188,38,118,54,25,44,23,98,159,154,161,41,191,198,245,247,23,107,38,96,218,208,27,147,187,203,197,154,241,136,223,128,238,220,28,96,105,134,139,197,98,205,48,250,213,160,113,195,8,33,220,64,170,54,244,66,166,1,50,135,6,22,253,67,238,124,241,144,104,85,135,194,135,92,127,156,187,152,95,71,20,114,243,106,241,208,208,140,92,236,43,30,26,23,152,225,74,185,171,101,221,43,214,77,80,63,234,40,10,53,23,84,154,125,197,154,110,8,215,
64,184,65,108,81,51,92,13,23,10,114,141,155,128,104,1,204,230,226,161,201,73,198,138,98,221,32,16,241,169,74,8,72,149,39,211,199,167,24,43,165,112,78,23,107,200,116,170,55,152,56,17,5,208,113,168,74,238,38,138,53,35,21,162,132,220,212,20,107,70,243,230,226,109,85,50,86,108,24,128,97,131,219,45,34,244,115,81,93,60,212,39,28,253,168,209,114,44,46,119,61,197,67,189,194,187,69,110,106,141,116,114,49,228,215,51,149,19,229,6,89,175,42,30,29,150,120,163,20,14,53,7,227,172,47,53,145,154,209,139,57,155,176,67,211,16,118,104,34,247,142,162,35,153,68,104,153,242,50,106,203,139,116,91,45,133,23,64,110,146,22,51,44,221,40,81,140,159,17,237,233,31,163,82,223,136,52,234,91,61,170,123,197,250,126,210,164,30,183,197,71,77,41,236,50,237,240,109,178,37,78,102,214,139,170,245,168,74,87,184,162,160,71,251,165,170,80,131,199,141,0,98,185,166,1,137,95,45,219,227,34,116,80,223,142,190,43,160,46,149,93,100,166,194,79,16,234,77,67,9,110,22,144,48,87,108,234,215,170,77,41,158,77,194,142,74,120,214,200,
113,251,158,180,71,10,89,252,246,210,21,174,102,40,13,18,187,236,89,6,165,9,209,236,223,245,111,208,85,34,220,248,41,137,108,73,241,17,46,34,236,85,60,102,123,205,214,33,33,123,150,17,38,28,233,87,199,128,24,146,126,37,91,6,182,55,103,12,85,221,136,208,183,222,37,157,142,184,209,226,241,49,58,246,113,248,178,35,25,231,130,34,53,33,245,171,223,236,46,216,101,76,106,162,80,171,134,180,11,66,117,130,153,227,56,233,72,143,164,32,123,149,81,169,71,200,58,161,2,176,105,26,195,156,218,48,3,208,131,197,35,231,69,128,33,138,162,233,173,19,196,223,241,62,45,142,82,208,216,52,141,42,213,104,49,222,43,27,17,162,88,71,140,214,71,34,213,95,184,197,100,28,215,208,174,250,200,207,248,152,132,181,152,179,27,72,233,2,96,12,64,180,126,56,206,141,246,246,28,55,234,249,138,98,60,35,59,6,64,49,171,130,246,249,108,104,250,170,184,89,128,14,1,211,43,94,160,40,214,83,114,100,219,19,39,242,226,112,139,143,163,148,198,8,57,196,42,45,104,16,54,241,119,133,191,132,17,68,187,101,36,2,133,91,28,195,64,204,
132,211,5,127,144,222,28,1,84,248,14,193,223,80,31,64,219,56,201,11,49,211,216,134,113,64,61,46,137,179,105,148,72,136,119,47,189,86,172,103,91,136,54,178,87,67,155,11,196,190,238,84,6,100,147,136,53,7,26,25,241,209,148,250,8,195,79,217,157,202,20,217,113,28,106,71,206,137,225,9,146,81,1,157,148,210,58,194,6,181,138,27,245,252,152,4,137,236,86,233,56,116,125,5,57,39,133,23,170,87,81,71,187,203,101,127,63,16,11,66,222,227,2,207,143,10,85,130,100,82,130,37,47,91,208,193,226,241,25,41,205,205,0,80,227,0,149,45,40,81,121,77,24,19,208,11,130,162,161,55,205,5,161,23,110,194,199,213,177,225,38,156,29,96,184,9,15,55,225,225,38,156,45,67,184,9,15,55,225,236,198,195,77,56,59,220,112,19,174,71,124,225,38,60,220,132,203,118,249,55,221,132,47,53,132,143,145,225,99,228,239,243,99,100,24,193,28,226,132,7,33,191,199,7,33,97,4,135,17,252,251,125,148,199,209,221,213,79,228,184,111,251,229,124,197,104,249,139,193,125,206,167,175,116,59,159,242,82,254,223,63,247,136,177,206,249,148,151,242,159,14,
183,56,159,242,197,224,107,43,233,130,243,233,231,142,70,255,7,199,157,92,226,251,147,149,244,201,110,198,186,21,239,116,239,18,95,68,173,120,173,11,140,17,230,11,204,55,172,164,51,11,43,222,137,40,215,121,230,129,203,201,122,180,140,151,78,7,116,188,76,55,243,135,89,159,100,172,94,17,120,190,168,91,73,159,144,245,138,21,47,221,31,224,159,25,11,214,149,239,97,232,203,122,229,138,215,41,243,241,21,175,96,240,161,199,151,116,43,233,182,113,198,170,21,15,120,229,223,46,235,34,183,161,159,158,99,221,129,239,16,243,200,175,235,21,43,233,86,193,135,127,235,16,227,193,21,239,140,224,55,178,30,251,244,115,159,203,113,205,232,212,173,116,230,239,39,150,58,221,241,149,78,20,235,68,241,142,83,11,75,29,16,108,47,248,55,150,218,185,232,200,251,151,153,137,174,116,118,222,111,0,132,153,212,164,78,180,183,249,179,128,128,211,225,95,87,164,206,211,15,22,3,144,236,82,5,51,145,21,47,229,143,192,12,164,147,0,11,25,175,13,122,58,147,155,81,164,92,122,113,41,39,11,167,253,233,96,193,83,80,148,202,
44,69,236,76,32,3,228,102,131,153,147,254,120,64,46,163,12,16,226,164,8,30,93,201,181,250,7,160,7,118,171,101,20,176,214,25,131,221,54,21,192,126,85,88,235,194,117,200,66,36,235,95,81,161,64,54,194,16,16,98,143,92,98,155,236,149,64,132,156,26,6,29,219,64,242,68,199,19,139,70,132,133,128,108,26,33,37,90,58,2,141,34,43,157,39,0,85,27,230,85,199,200,74,123,126,105,17,35,206,172,180,119,221,155,228,194,255,111,147,43,217,1,255,250,74,231,185,131,75,89,222,201,172,116,244,199,64,241,175,172,116,14,85,65,222,239,89,201,22,14,203,76,118,165,59,223,34,48,30,48,181,75,221,178,212,57,32,118,71,48,97,146,29,184,151,99,253,191,73,132,110,254,29,114,243,122,131,230,85,152,121,191,99,153,247,143,223,160,214,69,86,122,242,201,165,30,151,214,241,197,195,146,204,159,198,254,164,106,165,227,52,243,167,43,63,141,125,169,238,211,88,35,255,189,22,95,57,157,115,86,206,229,98,2,11,28,240,175,51,255,21,254,75,198,87,186,79,69,150,206,145,247,237,167,152,79,69,150,78,187,181,159,198,50,172,181,30,38,
77,161,233,85,16,3,213,159,198,178,204,181,215,173,116,181,1,215,17,91,105,111,139,127,26,43,196,89,139,44,117,9,220,89,214,207,57,43,93,25,10,69,6,26,231,185,239,87,92,214,193,25,164,48,165,157,149,179,105,230,135,249,111,148,74,159,166,222,164,99,159,198,198,85,254,165,179,2,55,113,152,4,128,222,91,135,169,222,140,111,3,59,45,213,164,74,10,215,167,177,43,220,191,71,29,76,81,2,83,240,249,122,93,48,63,31,1,134,251,235,177,21,47,73,129,75,34,223,251,113,214,160,255,205,24,107,220,223,146,53,240,146,45,220,199,88,163,203,124,133,251,175,180,112,29,101,174,121,197,123,131,251,55,26,185,151,234,212,194,181,192,54,98,99,255,233,108,88,238,254,149,238,106,97,185,147,77,201,239,212,70,35,116,73,232,146,112,59,206,118,255,47,221,142,255,163,43,178,79,43,255,133,218,223,107,224,11,240,104,255,123,111,94,186,178,253,13,248,31,56,223,121,229,134,243,29,30,55,255,131,63,122,164,227,119,120,220,252,14,143,155,223,25,253,252,7,249,213,244,213,232,119,248,4,252,127,116,220,177,101,30,243,86,
51,115,51,203,25,55,178,218,250,117,255,198,114,171,235,172,122,183,151,11,203,60,208,173,182,223,254,96,104,153,237,255,196,106,238,118,203,114,206,109,89,205,45,46,48,58,171,217,107,254,244,114,214,141,9,108,15,176,177,213,214,217,15,90,192,94,170,88,77,207,205,65,215,89,205,92,189,5,93,103,181,117,209,159,53,116,151,14,2,235,23,192,250,160,142,171,165,131,171,233,197,233,0,248,61,127,95,0,125,203,159,183,208,9,129,62,38,208,135,3,232,204,215,23,2,160,107,11,10,227,222,246,175,44,187,42,242,82,74,128,223,88,205,221,92,58,140,136,114,245,117,255,16,87,67,76,33,172,72,157,121,207,160,47,192,76,52,5,127,214,226,199,4,95,69,171,22,102,135,182,161,223,187,101,129,167,45,240,34,32,51,88,3,133,224,117,98,53,247,13,255,13,174,186,133,215,149,128,215,187,86,212,109,94,151,65,199,82,223,80,123,248,211,171,173,183,239,94,135,244,135,206,106,250,166,152,33,182,154,65,49,245,197,66,217,102,160,35,206,152,56,163,95,156,49,187,154,187,145,131,69,243,106,238,218,12,99,100,53,123,27,199,101,
213,10,254,1,1,238,94,205,222,194,133,89,92,216,58,167,132,34,24,209,159,96,45,182,154,254,198,66,96,241,27,134,213,181,50,171,91,130,60,8,232,221,55,184,242,15,172,166,111,77,2,75,136,124,205,192,222,244,69,96,66,228,134,239,9,240,225,178,43,145,253,214,20,178,163,223,117,113,78,212,26,87,88,207,8,236,2,81,132,151,176,215,49,174,230,184,184,197,232,247,112,113,112,53,3,146,6,203,55,118,25,59,42,114,39,5,187,78,56,181,136,88,55,86,51,183,13,48,42,236,113,163,31,21,224,73,97,117,76,88,165,184,154,148,139,3,150,87,21,129,105,208,23,22,119,10,74,164,222,196,139,196,240,107,120,230,206,21,185,202,195,107,62,16,76,181,138,136,86,55,108,20,68,68,156,30,4,251,164,158,171,143,94,93,205,220,52,192,215,182,157,46,1,166,230,191,34,208,179,64,127,116,154,171,135,83,171,201,5,255,242,114,82,226,242,218,24,60,226,171,153,133,37,73,69,73,153,229,113,213,44,243,254,82,150,153,229,232,106,242,6,129,165,192,87,187,153,105,88,205,124,211,2,127,115,121,40,0,94,92,106,97,137,172,202,220,12,52,76,
92,199,183,9,8,166,23,115,56,178,101,53,125,123,138,209,223,71,192,205,7,81,176,184,60,169,44,211,55,31,57,204,124,208,189,154,188,142,147,149,211,215,140,88,243,126,13,48,221,171,25,66,39,112,210,114,127,192,241,27,203,181,194,177,97,53,249,77,43,222,181,28,51,45,68,195,82,47,23,21,152,114,121,36,0,254,230,210,4,51,254,117,19,229,206,106,98,6,91,170,120,183,19,240,246,16,79,74,199,45,70,137,187,138,213,204,226,242,101,80,144,255,246,221,168,72,87,201,85,55,23,117,171,233,27,139,140,152,74,82,88,67,114,17,177,61,102,218,111,47,53,144,40,203,181,36,198,2,73,48,183,154,189,129,2,89,183,159,180,200,49,54,176,48,196,24,151,204,25,225,162,138,76,190,69,144,40,238,49,112,239,28,102,169,155,149,58,198,49,198,106,198,69,198,153,213,236,162,160,10,109,25,15,50,90,18,223,44,147,232,133,68,197,106,246,27,254,23,0,153,4,228,78,150,11,66,144,171,19,92,221,29,225,106,82,166,190,32,248,146,169,194,200,99,76,48,182,48,182,200,194,44,23,78,185,230,182,223,94,174,182,122,249,251,89,154,178,138,
21,0,206,51,209,136,130,189,140,66,204,63,203,69,124,53,183,32,5,59,98,141,226,17,26,115,106,209,86,196,53,185,51,191,43,158,71,36,158,165,254,127,56,189,157,104,90,111,53,165,165,134,73,56,47,57,18,206,151,37,156,197,236,31,68,232,43,166,88,132,253,68,236,19,246,147,219,97,63,249,237,245,147,143,246,75,41,12,54,112,25,217,22,5,101,147,25,169,146,201,107,254,184,105,53,82,158,147,148,129,37,83,7,110,219,86,115,123,89,26,11,237,53,41,232,218,0,190,41,253,196,165,12,111,3,155,194,127,115,105,81,128,7,203,205,52,113,149,77,86,80,203,11,176,76,80,168,41,186,105,138,110,80,212,233,114,55,104,4,129,84,159,180,176,114,47,46,156,166,3,78,215,135,88,170,131,147,109,53,215,76,39,253,166,21,239,22,93,14,142,179,171,201,247,173,120,215,243,204,52,83,165,150,130,30,70,171,49,109,243,214,114,146,165,165,47,172,38,174,217,22,115,83,120,74,7,164,118,166,41,228,105,154,131,110,83,111,43,97,233,49,31,73,75,241,235,185,202,115,65,143,49,32,24,86,118,3,82,246,230,169,117,82,77,239,228,41,197,254,
45,41,180,175,82,104,199,229,162,145,11,143,6,129,10,89,186,37,51,151,185,136,176,241,176,157,225,206,126,176,150,82,178,100,26,82,112,145,103,70,90,213,130,172,92,225,130,170,127,107,209,118,36,105,39,85,59,113,238,244,0,34,188,161,151,117,239,105,19,41,75,97,153,219,246,37,29,175,89,176,69,152,24,116,131,29,60,221,68,246,246,75,52,17,237,116,244,14,246,8,6,244,0,23,210,183,44,13,151,251,164,165,129,66,183,230,119,55,149,64,122,182,133,244,9,105,193,112,147,199,3,217,189,45,231,152,169,230,226,81,55,23,119,119,244,148,5,217,231,235,134,74,246,240,218,83,116,67,37,13,232,129,110,248,199,194,158,18,62,163,232,227,80,248,140,98,159,84,63,243,140,114,159,71,186,112,231,21,62,201,115,128,19,102,201,47,205,146,237,51,179,63,234,228,204,236,64,207,212,123,147,111,93,173,233,126,231,210,204,123,229,15,53,34,206,119,249,80,227,187,156,156,253,135,145,71,58,126,151,147,179,239,114,114,246,221,209,234,15,186,159,180,142,56,79,210,189,145,239,126,206,113,254,39,199,157,191,195,246,225,14,
207,80,79,92,230,51,231,23,238,176,185,185,195,105,148,194,165,206,57,79,18,231,252,105,0,162,119,248,253,153,59,236,141,158,164,1,244,134,157,39,237,163,0,205,44,15,9,246,29,26,38,148,162,119,56,216,99,210,0,13,57,79,58,135,238,165,204,162,176,137,222,225,245,249,147,116,63,64,57,168,92,152,211,53,33,0,242,147,52,20,189,119,88,67,12,67,244,73,246,60,162,241,23,237,34,147,202,74,71,126,146,190,224,60,201,246,178,112,17,246,194,150,205,134,10,237,93,2,187,11,14,195,176,149,5,75,38,221,183,240,36,211,175,218,61,105,237,15,52,226,2,126,253,144,224,117,218,19,175,79,81,212,24,58,33,171,34,169,7,154,53,82,166,47,32,145,130,121,107,47,100,192,84,195,192,7,10,206,147,28,255,101,250,32,41,102,228,97,92,41,101,6,88,224,63,111,0,22,25,48,130,5,32,59,172,68,170,240,19,254,140,119,54,208,163,127,121,92,81,58,6,160,197,91,80,80,162,79,58,144,38,39,194,11,62,175,80,237,196,172,37,40,144,59,212,220,75,180,215,170,218,123,207,69,176,29,160,3,6,116,208,242,31,132,127,7,86,206,93,0,167,204,14,
135,230,134,118,242,39,12,114,252,225,236,110,254,35,70,41,70,49,139,59,98,136,182,142,64,139,24,120,210,58,250,209,107,92,16,140,30,177,20,4,100,217,198,42,88,16,140,56,25,26,89,148,181,65,217,46,193,75,80,42,94,16,152,54,246,28,98,143,200,248,155,9,206,93,49,40,177,113,17,57,197,116,59,99,208,213,192,68,169,75,203,227,229,136,109,189,100,130,81,67,87,110,4,69,210,73,108,247,107,133,173,162,5,201,69,200,74,228,19,182,68,35,46,224,94,242,7,51,146,251,18,186,18,214,240,146,240,181,128,97,248,6,233,243,43,132,47,105,44,222,201,92,154,87,147,182,14,46,234,189,59,237,223,8,210,247,235,203,61,216,54,242,196,155,89,51,153,118,209,128,14,248,251,2,216,119,252,249,0,246,250,114,191,248,225,137,183,248,84,60,184,92,255,36,41,101,128,103,215,39,153,193,57,169,23,140,75,83,134,19,161,163,172,47,124,208,173,51,73,126,143,32,128,29,50,176,67,22,118,200,194,14,221,233,9,200,12,7,153,153,144,148,213,82,62,58,39,225,70,214,4,113,199,133,230,225,147,204,8,184,26,45,35,79,186,53,140,146,82,26,
118,203,4,78,32,156,201,119,106,198,30,217,248,101,139,223,92,182,97,35,155,20,127,21,18,233,53,160,183,101,187,127,152,153,127,243,196,19,151,166,145,225,191,236,59,192,210,32,68,116,53,110,90,186,137,46,124,144,215,148,11,130,29,141,223,102,129,255,178,111,83,138,178,64,7,11,91,149,79,50,83,70,29,70,177,180,59,133,18,210,16,189,41,91,62,167,62,137,225,168,143,18,79,50,51,6,150,81,97,103,44,236,215,44,236,215,30,222,0,86,50,89,91,237,147,76,175,184,9,230,231,151,130,20,247,222,178,160,111,210,46,249,175,253,205,187,167,165,143,74,171,4,117,230,73,238,205,57,10,108,244,73,110,108,65,10,237,19,190,98,155,23,153,137,174,229,17,37,222,218,115,47,139,0,168,245,235,183,57,143,166,18,180,186,114,9,166,102,4,122,5,181,2,155,74,157,176,61,48,172,19,191,114,157,248,164,18,175,248,179,97,155,123,18,182,57,42,131,217,246,253,222,236,210,254,37,181,185,149,96,195,221,58,142,73,164,106,102,228,66,155,205,37,46,164,196,39,229,66,155,205,37,211,212,46,217,166,38,123,39,69,154,176,13,144,159,
245,9,96,39,12,236,132,133,157,176,176,151,108,3,188,20,212,181,132,112,212,6,56,110,154,204,184,109,50,23,77,147,185,8,174,202,116,209,54,64,126,233,40,224,67,211,212,190,199,239,208,152,11,211,5,70,45,191,81,43,219,103,113,172,108,159,129,77,8,172,202,52,102,100,26,179,50,81,247,197,42,153,49,43,211,216,125,1,249,243,153,223,160,241,101,105,122,65,243,211,61,184,125,166,162,241,101,105,120,218,85,24,165,99,101,165,241,5,19,182,67,253,90,141,143,226,199,203,181,233,176,243,97,203,214,96,67,254,183,231,1,47,236,124,100,142,110,27,195,206,71,25,249,221,234,124,114,38,177,253,64,28,156,65,4,15,204,90,247,56,66,176,103,22,65,253,211,67,10,106,32,125,135,146,198,147,154,76,140,106,136,203,196,223,142,13,94,240,136,36,234,235,233,1,39,63,229,67,182,240,180,226,37,5,254,183,117,216,22,6,179,60,227,255,74,39,198,28,202,233,137,177,28,133,73,121,14,78,21,216,233,112,28,198,194,184,212,235,32,227,129,108,189,200,246,171,156,241,118,34,60,156,211,93,241,103,247,51,191,95,225,190,46,231,
207,82,187,119,188,82,249,11,94,169,84,120,151,222,124,247,218,108,77,240,53,114,77,249,165,202,231,157,239,189,50,224,124,143,151,42,255,209,23,30,49,78,57,223,227,165,202,247,134,187,157,239,141,86,59,79,189,247,35,223,227,125,202,95,240,62,229,3,78,108,158,122,167,155,25,115,79,189,43,57,198,196,83,239,230,45,198,169,167,94,119,11,163,247,212,155,119,25,147,79,189,235,6,110,202,220,47,250,251,88,128,192,155,11,140,254,62,3,209,242,212,155,170,99,162,247,41,95,146,30,10,46,174,23,24,27,158,122,151,147,140,238,83,239,150,127,128,139,201,167,222,121,143,17,158,87,12,237,91,34,67,51,20,12,224,109,191,158,137,130,96,68,185,152,126,234,93,205,51,54,62,245,102,69,58,120,221,178,82,44,154,133,43,118,97,17,128,121,35,62,36,223,52,243,239,27,210,99,150,133,168,187,0,161,185,96,188,106,224,250,204,120,115,134,121,127,255,83,111,209,76,148,57,47,176,48,135,36,162,131,104,157,8,198,155,6,238,146,25,223,239,22,2,53,24,86,16,224,164,134,198,160,151,4,1,3,223,86,107,140,97,30,67,73,85,192,
42,101,51,205,10,9,171,180,44,24,217,167,100,190,14,202,254,171,92,12,177,96,88,92,53,11,101,99,88,131,95,53,158,184,106,12,175,206,70,137,155,230,222,26,254,125,35,188,181,6,159,205,192,161,127,219,76,22,97,222,0,222,178,34,92,55,148,174,26,25,111,91,251,89,200,33,241,53,65,112,211,248,252,74,35,247,121,209,214,42,33,30,65,166,121,145,21,207,93,110,96,36,6,110,47,50,226,81,235,128,43,198,126,86,233,89,19,1,111,26,6,101,153,85,25,204,166,34,17,233,129,93,49,248,251,198,224,99,66,73,130,201,106,109,68,187,229,239,103,129,16,183,172,109,12,188,41,34,117,139,225,143,113,1,201,33,131,121,189,108,142,3,44,192,98,216,68,244,188,33,57,111,204,114,213,220,95,213,28,17,215,249,111,128,129,148,87,140,1,109,252,4,206,197,244,103,69,63,226,198,234,189,104,13,166,11,24,106,86,44,137,26,214,105,243,34,37,1,246,190,58,143,116,155,215,48,128,217,144,33,53,107,50,245,166,42,202,194,176,177,225,172,136,167,10,74,222,129,250,166,232,1,115,197,192,91,154,70,72,59,43,250,192,243,125,37,141,169,222,
151,16,4,161,79,66,80,202,138,241,94,144,193,176,232,43,176,0,5,181,4,82,47,10,2,245,102,72,56,32,237,148,32,128,104,77,57,47,50,114,255,190,218,26,202,87,53,229,161,116,86,42,17,129,161,213,3,25,52,193,132,146,176,70,214,121,19,32,55,253,74,38,198,159,122,3,198,25,170,29,36,111,10,1,88,94,181,134,146,8,91,64,36,137,64,156,167,249,5,161,75,70,135,197,178,253,132,3,178,171,23,209,229,166,46,192,97,74,236,183,211,21,194,81,92,34,246,100,126,94,69,33,136,173,153,46,9,37,236,120,73,124,167,6,223,199,5,188,207,203,2,152,234,84,145,85,204,52,135,178,98,62,230,173,210,215,69,7,185,23,51,137,46,162,131,84,99,181,43,14,25,19,66,40,161,85,25,66,139,90,74,177,227,5,161,68,85,86,14,176,190,229,87,51,129,61,199,36,136,145,233,170,144,100,129,15,236,184,192,224,111,10,134,104,97,22,2,167,35,236,101,99,216,41,209,2,30,87,68,40,120,90,195,6,20,224,25,48,95,250,201,180,233,22,216,78,211,153,226,118,91,217,19,231,215,77,12,94,182,249,173,198,5,249,188,85,85,140,137,170,218,45,144,83,139,22,99,
208,45,160,176,187,91,136,59,202,105,41,214,133,249,111,212,45,176,178,22,130,91,112,152,131,14,110,212,84,163,152,189,188,91,176,160,156,177,132,22,41,220,183,171,91,48,175,221,2,56,205,118,238,95,222,45,224,188,187,91,224,140,203,98,13,172,160,53,30,29,119,119,11,204,97,13,123,203,84,183,221,221,130,96,181,133,243,151,119,11,227,137,171,194,10,22,218,45,22,25,165,68,113,175,45,15,17,118,117,11,230,131,202,139,199,172,153,52,209,208,206,246,128,160,214,19,56,218,45,192,184,42,50,18,56,47,239,22,168,95,238,22,146,138,0,6,20,132,133,228,42,97,62,47,178,194,226,165,221,2,3,95,49,133,202,42,173,221,2,206,218,45,196,179,54,200,85,25,17,73,16,148,211,1,46,144,117,87,183,128,147,118,11,40,107,110,67,33,232,22,152,231,182,105,96,218,45,0,180,221,226,182,22,46,162,111,214,166,139,241,140,202,68,84,217,146,167,253,200,114,128,242,155,54,19,102,144,196,143,194,74,114,218,63,100,100,0,66,89,45,145,204,97,147,192,50,132,69,216,36,194,38,17,54,137,176,73,4,213,32,108,18,82,13,202,77,34,220,
97,125,230,121,28,243,132,59,172,96,239,30,238,176,254,210,29,86,152,60,97,242,148,31,100,244,48,139,218,17,62,158,200,243,248,95,253,120,18,38,79,152,60,97,242,200,57,133,61,107,254,236,179,253,35,57,101,219,126,217,243,249,47,243,178,231,243,187,255,112,38,234,124,255,149,62,231,251,188,227,249,143,247,61,98,204,59,223,231,29,207,247,135,235,156,239,143,214,249,255,223,254,181,166,150,200,247,121,203,243,63,243,150,103,45,121,210,89,75,119,57,107,94,107,100,205,237,203,221,117,221,232,221,164,27,185,203,251,193,187,156,34,188,186,230,181,56,107,201,60,64,231,4,96,185,254,110,147,155,0,42,206,106,53,80,7,129,174,94,107,74,47,174,37,219,0,58,19,85,4,247,124,11,235,49,214,29,96,35,192,248,53,107,94,38,26,80,58,239,172,185,231,151,23,88,201,1,81,9,100,213,90,162,163,10,202,2,89,88,75,229,35,107,252,164,234,90,230,84,254,46,191,94,193,122,244,110,202,29,91,75,181,66,61,227,172,101,58,150,199,239,38,220,41,22,5,57,194,98,116,45,113,122,106,45,5,135,76,1,101,78,76,10,81,214,101,109,
122,45,149,3,41,7,209,182,59,135,152,172,102,49,6,129,42,22,99,88,131,111,219,177,64,26,249,189,182,200,90,50,213,109,172,16,200,143,21,14,96,38,193,142,34,55,128,3,203,113,100,245,15,1,22,83,254,252,88,204,90,83,107,12,225,39,215,146,3,209,181,52,70,245,210,104,217,62,196,156,53,131,192,250,152,160,15,128,83,44,118,2,212,50,3,165,229,36,148,14,26,83,196,214,18,133,128,146,119,194,89,75,157,142,173,101,218,68,211,24,194,138,182,83,107,222,105,230,59,208,40,191,60,107,204,32,164,157,178,25,60,52,73,181,138,157,186,65,148,121,71,88,31,91,203,12,193,82,176,251,151,163,96,250,61,44,137,149,4,189,123,173,48,17,89,235,190,24,93,235,27,120,248,234,221,62,183,246,110,183,123,248,110,193,125,212,184,118,254,178,179,214,201,127,103,47,63,236,185,203,207,5,222,237,116,235,238,158,119,31,69,215,10,83,206,90,95,191,3,30,43,221,172,20,32,216,39,43,103,199,193,25,143,173,157,31,191,247,26,56,85,224,44,247,131,180,252,225,12,38,95,8,3,47,12,188,223,110,224,109,23,205,253,215,40,154,127,55,251,
206,213,249,247,230,230,223,121,111,166,166,253,218,59,243,151,230,202,47,201,95,113,126,240,74,214,249,1,5,244,63,137,63,210,241,7,20,208,31,80,64,127,192,63,39,247,255,70,75,173,249,200,15,40,160,255,139,195,239,231,148,220,66,226,30,31,199,159,45,117,244,127,124,160,148,113,19,247,92,183,165,212,218,222,120,47,227,230,75,153,147,181,172,54,220,235,112,31,52,151,90,59,242,76,250,111,148,220,225,42,193,185,82,234,232,254,232,85,112,226,224,244,151,90,219,92,150,147,165,76,107,29,171,147,165,214,211,113,238,135,74,153,108,5,247,15,22,184,73,64,232,31,131,223,235,148,210,131,209,82,226,84,254,94,26,140,244,153,42,40,68,238,37,160,146,104,109,102,174,165,148,158,112,74,110,255,24,215,181,165,116,87,140,181,195,192,20,74,137,63,173,98,110,172,148,30,65,17,87,240,107,89,139,149,210,167,187,225,114,184,148,72,86,50,55,85,114,207,57,165,100,87,21,107,147,247,248,132,153,249,40,248,78,169,53,219,194,92,11,176,200,208,238,239,19,107,148,178,133,90,144,252,228,61,254,104,165,68,137,41,
181,247,136,204,211,247,248,251,143,82,43,250,120,238,65,238,155,209,60,86,234,24,142,150,178,195,31,55,10,48,36,151,27,81,106,61,91,106,205,69,74,94,118,186,148,110,117,1,141,131,18,47,101,189,104,201,61,85,7,237,92,41,157,157,3,163,50,16,2,178,94,54,206,188,192,70,75,233,76,4,248,91,165,86,47,198,28,236,187,103,74,110,171,83,234,240,34,136,80,13,76,47,76,162,165,246,52,226,164,197,88,189,204,33,202,137,168,138,232,158,88,64,228,24,110,139,0,39,60,92,230,227,165,204,169,74,224,102,74,158,55,132,245,43,80,5,94,133,60,188,102,152,79,150,178,157,145,146,219,89,13,207,49,100,139,149,188,116,12,92,92,230,86,1,131,46,195,21,224,141,151,146,109,17,96,22,48,36,248,56,47,225,205,96,196,72,41,121,42,170,242,226,102,224,226,106,186,76,123,133,194,189,222,135,3,250,38,161,19,41,181,158,114,74,217,211,49,96,238,246,192,216,129,217,221,19,247,94,199,13,73,215,43,29,239,139,148,222,232,123,56,117,239,13,33,121,33,90,122,253,194,193,123,199,221,123,13,165,227,3,78,233,141,129,40,144,17,32,151,
71,74,77,99,48,31,171,96,53,10,244,114,161,148,36,76,94,159,168,64,154,232,189,38,247,225,105,97,13,120,172,116,252,34,68,47,62,152,3,172,17,112,127,188,212,4,104,178,231,1,33,210,30,83,176,38,194,40,121,86,66,100,186,148,200,11,135,153,82,166,51,90,74,22,226,204,141,149,82,167,43,153,147,160,174,43,37,187,99,247,82,172,39,58,4,119,186,148,60,239,148,50,231,15,42,110,138,240,76,98,65,154,85,41,233,85,26,56,177,194,100,41,121,46,90,202,104,248,250,151,153,64,250,193,15,14,131,85,9,244,193,82,114,44,138,74,15,4,148,149,83,113,84,24,66,36,1,152,44,37,206,10,251,177,82,70,34,121,184,154,185,153,82,10,7,67,22,228,88,41,121,166,26,86,192,157,210,57,216,32,250,160,17,169,67,230,16,51,39,98,139,225,167,74,137,54,161,135,72,195,136,222,45,106,251,227,76,192,184,235,206,117,238,170,129,242,255,89,129,132,240,111,132,101,33,44,11,97,89,8,203,130,41,11,219,155,143,234,159,201,47,30,156,127,127,102,126,170,198,187,116,245,106,77,83,121,223,177,223,249,225,43,139,206,15,217,119,252,167,199,
30,49,54,56,63,100,223,241,67,246,29,63,28,173,91,254,142,179,158,29,137,252,144,125,199,255,234,184,181,31,242,163,70,235,217,243,13,140,133,245,206,174,134,15,59,101,60,215,194,216,178,158,187,208,240,97,206,205,173,231,206,231,24,147,235,237,67,45,31,182,51,223,126,193,101,76,174,103,7,19,224,181,48,182,48,122,224,37,192,107,94,239,60,159,100,4,175,223,5,15,58,231,10,140,205,224,37,2,252,254,128,78,182,63,7,94,243,122,118,32,192,47,64,191,224,38,214,11,23,100,244,214,115,221,194,159,241,124,11,163,11,190,224,33,7,124,219,153,207,246,8,30,252,207,117,51,214,173,23,144,163,192,125,129,245,130,240,103,93,228,222,198,111,4,47,87,214,35,11,93,197,31,106,102,204,175,119,246,212,33,55,122,244,230,24,19,235,29,231,189,15,249,85,241,245,142,190,22,198,28,235,205,204,187,172,203,216,143,222,34,127,221,122,118,56,207,216,188,222,141,252,221,240,235,30,112,25,91,192,107,6,207,91,239,64,142,14,193,235,105,4,79,248,8,126,97,61,219,107,236,215,155,4,31,250,231,197,126,73,51,34,255,96,115,
160,127,159,216,209,67,255,134,64,126,244,20,63,4,118,195,15,3,129,254,157,200,41,114,119,118,123,58,230,176,179,218,175,79,252,151,0,63,169,120,237,192,183,139,221,145,151,95,39,68,14,193,111,94,47,244,39,177,27,35,116,196,142,57,228,217,182,191,248,189,57,224,143,191,218,209,39,192,135,78,119,63,248,13,216,189,17,60,119,189,192,186,250,175,71,240,197,255,38,126,172,255,47,120,74,167,3,251,171,125,225,223,33,254,27,104,6,47,103,248,231,214,179,253,247,142,65,248,91,151,215,211,133,150,15,249,151,78,214,211,157,147,140,149,235,94,151,251,33,95,98,172,123,249,60,99,203,122,58,159,99,222,3,78,214,43,214,61,40,243,102,118,221,107,19,184,198,245,116,135,224,231,128,235,102,60,184,238,97,25,93,207,203,122,243,122,58,231,49,15,157,51,178,126,120,221,235,73,50,239,174,123,89,129,19,250,130,47,244,123,25,227,235,222,84,48,239,181,154,117,52,12,214,5,191,106,157,111,245,2,252,147,50,38,215,211,93,178,238,26,254,213,235,222,136,193,63,29,232,145,62,227,6,248,157,121,70,214,137,116,225,
235,41,62,252,7,12,126,161,159,117,228,215,117,244,51,124,210,5,225,139,158,103,198,24,225,143,167,21,191,144,99,68,191,14,67,191,96,214,137,120,94,196,172,123,167,60,198,4,114,53,131,135,126,170,63,250,13,55,4,235,93,5,198,134,245,212,104,238,195,20,235,169,147,99,140,216,127,212,200,119,74,232,183,172,167,176,119,10,253,82,39,251,25,193,239,23,124,228,83,251,130,119,209,172,187,102,125,76,248,163,223,197,64,255,212,64,2,188,220,122,10,254,41,34,193,27,145,117,193,15,248,4,248,172,183,245,178,94,187,238,141,37,88,199,255,217,64,191,20,118,72,17,31,169,22,193,103,157,72,211,117,244,22,253,131,117,240,91,205,250,144,172,195,63,35,250,35,247,132,209,239,68,30,252,70,244,55,235,167,2,59,166,136,104,149,175,93,214,133,190,200,69,124,168,253,147,224,27,249,149,62,254,155,52,246,109,19,56,248,78,154,245,33,163,223,176,209,175,67,228,199,190,106,31,224,220,73,232,199,160,111,214,219,141,252,163,130,7,159,182,25,198,200,186,215,103,252,139,60,106,127,197,47,24,251,224,159,9,177,127,97,
221,35,158,52,254,169,204,26,255,157,18,39,200,175,114,163,63,191,8,170,241,169,241,39,249,81,96,29,255,169,125,172,255,136,63,42,67,144,63,18,159,18,31,38,63,212,63,146,23,38,191,108,126,12,155,248,32,175,52,190,168,40,26,95,121,201,31,236,51,110,214,53,190,225,75,199,9,232,75,156,67,159,74,160,246,85,251,193,223,174,119,202,186,181,63,242,103,141,252,84,170,52,250,166,137,55,126,228,111,71,252,200,250,210,159,31,160,231,213,81,74,194,94,151,13,123,93,216,235,200,17,114,42,236,117,216,65,106,89,216,235,180,23,134,189,142,94,241,251,222,235,252,19,225,38,57,220,36,7,155,212,112,147,172,9,237,133,155,100,236,192,67,232,95,186,73,14,11,7,79,49,225,211,117,248,116,29,62,93,151,79,159,126,165,167,235,176,112,132,133,35,60,150,11,143,229,254,202,99,57,118,32,28,235,242,89,69,249,159,186,123,147,127,79,253,15,62,159,157,187,246,181,237,127,233,238,239,56,63,122,101,193,249,17,111,175,254,51,231,145,142,63,226,237,213,143,248,189,238,31,141,58,254,131,220,179,83,93,251,62,58,229,238,
123,86,223,224,252,136,183,88,255,212,113,247,125,84,239,70,204,245,204,179,83,127,106,214,143,202,252,226,179,218,175,57,207,234,147,206,179,83,9,153,119,152,115,62,170,117,103,159,157,58,34,247,215,159,213,127,145,181,211,118,237,250,179,83,77,114,29,121,86,223,41,248,192,101,130,251,99,111,67,231,43,50,231,124,116,76,230,255,129,193,255,19,240,21,70,104,131,175,252,193,111,48,248,202,55,242,172,246,61,240,191,26,224,43,255,195,130,63,247,236,212,235,50,238,223,134,215,123,240,243,2,123,229,217,169,84,176,126,76,244,128,118,153,255,49,131,175,242,238,127,214,200,216,40,240,127,34,243,200,97,240,106,167,183,241,106,101,253,31,154,245,172,140,216,177,90,104,2,95,47,247,240,109,219,203,119,31,250,2,247,134,204,79,149,237,118,170,213,224,55,203,60,122,28,151,123,244,248,226,110,124,213,59,41,115,98,119,248,215,8,28,252,212,230,208,181,248,95,50,248,237,2,123,217,216,116,255,179,99,211,194,31,185,176,177,218,195,202,111,253,220,40,243,240,87,127,66,175,206,220,171,221,247,7,118,
199,166,101,254,234,55,252,167,252,145,215,226,127,217,232,211,97,248,224,235,83,110,197,51,181,187,242,22,191,35,151,226,47,62,171,175,199,239,158,192,24,191,227,239,109,63,162,231,78,254,26,163,70,255,67,2,7,127,181,127,197,179,250,215,12,63,226,85,241,53,238,172,254,240,23,255,97,235,192,239,208,141,27,124,227,223,122,252,173,250,171,93,208,167,101,167,252,232,191,3,95,237,175,242,99,127,104,170,255,173,189,44,254,25,131,175,242,97,127,137,187,19,59,248,43,62,242,171,253,225,167,190,197,254,26,63,220,163,183,250,207,198,223,123,251,240,59,254,195,86,234,63,139,175,252,129,87,223,128,175,246,195,127,170,63,247,154,83,134,191,234,36,246,71,255,63,22,185,145,223,214,1,141,75,224,53,126,192,87,89,185,55,241,81,107,249,43,93,240,213,254,224,171,124,192,171,253,169,3,103,241,167,250,64,252,9,190,241,159,234,143,172,229,188,251,251,194,159,117,155,63,26,63,224,183,130,175,57,16,196,67,237,204,118,93,80,253,137,55,173,39,170,63,240,175,179,174,50,154,248,209,188,197,78,26,127,214,
190,145,103,90,119,144,181,204,127,39,190,218,208,224,147,119,154,191,10,59,171,113,111,227,83,249,171,254,208,213,248,65,126,173,27,232,175,246,199,30,22,95,229,196,78,74,27,251,75,221,82,159,154,186,167,249,11,190,214,41,240,109,254,170,255,185,215,26,185,109,159,218,175,25,255,231,140,255,109,254,91,251,147,119,219,249,75,60,228,141,157,212,190,232,47,241,187,147,191,213,63,181,199,126,154,255,216,15,189,212,206,42,191,169,187,229,252,67,127,19,63,245,205,224,171,13,246,216,95,235,207,236,179,99,226,63,99,223,99,82,215,52,206,177,139,225,31,248,31,126,198,126,74,79,107,136,208,19,251,27,189,79,66,71,99,41,152,47,247,157,215,152,215,26,100,248,171,44,208,67,111,193,151,184,179,125,69,235,159,198,57,242,91,254,154,31,192,19,115,170,175,198,18,247,248,65,249,139,252,134,175,250,95,237,15,254,222,190,163,182,101,94,253,105,249,163,167,250,199,248,95,121,27,255,239,234,59,248,91,227,63,242,236,203,232,251,229,114,255,193,94,26,7,215,131,56,44,203,1,188,205,67,211,127,203,117,88,
235,16,124,213,14,224,171,94,220,27,61,143,189,109,250,208,57,209,111,219,15,236,3,202,118,146,62,86,127,130,251,114,94,225,255,183,196,15,248,227,194,30,123,244,25,187,237,178,7,242,105,254,64,167,5,120,181,137,248,135,120,54,241,122,236,45,226,81,101,16,123,144,55,187,236,65,31,70,191,237,62,236,59,207,164,16,212,11,115,37,32,196,76,35,176,141,204,20,218,32,192,112,132,38,18,142,208,66,102,29,177,239,217,177,73,211,8,173,1,172,1,53,72,17,220,22,66,12,39,133,189,86,4,53,133,179,118,135,2,181,23,76,96,218,66,111,19,82,131,17,58,154,44,40,252,165,128,78,224,72,235,8,2,98,218,200,1,157,151,53,228,70,18,184,81,248,89,249,212,249,200,179,183,16,104,32,163,175,242,165,17,218,4,211,36,34,0,52,32,104,132,218,136,119,240,29,20,190,219,141,56,40,114,192,107,32,35,167,105,196,181,147,232,175,65,104,236,173,114,208,16,7,152,87,231,191,172,33,67,199,234,175,205,192,6,196,14,253,53,16,241,143,13,100,45,168,232,97,18,166,145,2,174,250,91,255,170,252,232,63,35,118,135,254,73,145,159,141,148,
77,100,245,223,1,227,43,230,109,35,214,194,2,95,19,31,218,8,52,137,77,35,180,246,211,96,135,174,202,131,221,53,126,144,91,27,27,9,128,191,106,197,94,70,190,122,245,27,243,163,50,15,125,75,71,229,192,206,26,103,208,81,59,18,224,154,128,251,158,125,249,146,36,56,122,219,184,217,213,136,247,63,251,18,118,249,146,208,211,184,1,207,200,165,27,240,29,201,23,196,63,246,50,241,81,159,32,55,52,6,246,20,66,248,107,33,20,63,14,3,163,114,4,249,163,137,167,114,207,61,171,39,1,241,153,89,167,224,72,195,216,85,4,196,207,204,247,48,255,25,57,144,115,111,1,80,255,83,0,164,193,188,172,0,216,60,28,11,228,179,5,160,81,10,145,22,47,7,255,67,87,27,58,163,41,28,65,124,75,67,50,118,183,241,161,254,197,95,170,7,124,143,67,71,125,184,167,240,216,184,211,248,199,206,54,191,212,111,224,115,175,133,74,243,159,56,223,241,192,162,126,54,114,212,246,10,127,252,168,57,0,157,189,249,143,220,74,71,253,72,92,65,127,215,134,220,234,111,227,223,234,97,252,221,72,221,210,2,104,229,179,249,175,122,239,136,31,245,159,
205,127,248,236,221,136,219,248,215,252,177,113,9,190,198,239,222,252,71,127,224,84,110,187,145,212,122,98,27,0,122,90,57,180,33,64,103,88,224,153,215,13,33,114,168,31,144,67,107,38,241,175,249,111,239,225,167,241,135,28,214,15,182,14,239,205,127,213,31,124,99,23,137,255,160,134,73,28,66,207,230,143,234,79,124,88,255,157,52,242,43,30,250,216,141,149,137,15,205,127,213,93,242,31,250,214,126,54,255,109,221,178,249,175,181,2,253,241,215,118,254,87,60,171,237,37,15,76,3,219,206,127,250,75,94,234,58,246,80,121,144,211,202,179,167,14,232,134,88,125,111,228,216,85,7,144,219,240,253,210,192,206,122,112,227,89,189,198,45,242,136,61,212,23,98,143,29,117,64,54,196,59,234,64,189,108,144,76,62,73,99,63,70,29,176,53,64,55,68,26,191,224,27,59,106,29,41,215,136,160,14,216,141,128,198,187,198,19,27,1,234,192,54,127,27,7,208,217,91,7,144,69,55,20,191,108,35,96,243,64,125,2,62,249,171,15,6,42,243,222,141,128,173,3,230,129,84,109,107,250,143,205,31,27,127,228,169,110,232,212,143,200,167,113,128,
95,76,254,126,38,254,108,158,89,191,233,62,0,248,157,117,192,108,224,126,173,58,96,243,64,235,0,126,197,103,154,47,54,15,164,46,171,141,76,28,88,61,52,30,247,153,141,16,113,106,229,179,249,103,235,128,198,9,114,218,56,86,223,19,119,234,39,240,116,31,0,223,95,86,7,94,186,15,0,94,237,7,190,198,45,244,168,227,193,38,80,234,41,252,172,28,182,14,216,60,222,85,7,118,236,71,254,170,58,96,235,232,222,58,128,62,59,247,1,159,169,3,106,59,171,255,142,58,160,125,27,249,213,158,200,175,117,13,184,114,29,48,251,47,252,173,250,88,251,217,58,160,243,224,219,58,160,250,125,182,14,212,159,195,46,218,11,140,93,148,206,222,58,128,29,108,157,127,89,29,216,89,143,246,214,129,49,145,47,242,108,111,29,40,63,24,13,110,231,161,198,187,141,19,141,3,226,94,115,132,188,210,124,226,94,235,57,15,70,236,107,119,213,1,173,227,59,234,128,28,246,237,172,3,82,55,212,54,146,111,59,232,106,28,96,23,233,147,42,171,169,71,123,235,128,198,41,254,33,14,245,1,219,230,151,230,163,244,3,240,39,68,87,201,131,151,212,1,234,
253,246,3,129,173,3,59,246,195,54,126,108,254,216,58,160,249,6,61,91,7,212,30,196,129,173,3,95,51,113,112,201,196,129,181,31,254,215,131,36,27,55,90,7,228,121,96,79,223,55,116,106,169,211,106,23,181,1,244,247,238,7,246,214,1,155,183,182,14,76,27,57,108,63,181,122,152,120,44,63,16,89,249,108,254,217,58,96,229,183,113,108,235,128,250,219,214,1,242,192,230,59,122,137,126,229,58,248,210,253,0,240,86,78,179,31,40,63,127,168,62,232,105,229,0,95,251,178,210,97,255,189,167,14,52,50,175,254,211,58,128,63,172,222,118,31,96,253,183,43,255,43,182,31,4,173,61,84,110,252,240,82,189,119,228,191,250,217,230,63,245,76,243,143,123,19,23,218,127,77,188,106,191,182,118,83,123,147,175,117,38,30,76,254,7,253,159,184,87,255,108,63,7,212,98,119,245,187,245,155,165,99,227,135,113,123,63,133,61,109,157,180,250,203,193,160,218,76,226,30,123,254,177,248,5,61,186,2,255,52,98,23,181,155,246,15,121,16,150,147,164,177,157,73,191,103,3,144,99,77,157,47,5,137,141,240,25,238,53,249,131,123,73,52,155,216,186,1,
208,192,217,78,252,96,13,69,181,1,208,232,247,38,190,26,146,121,161,163,206,55,5,65,141,9,157,93,137,111,3,136,121,155,248,214,0,54,1,109,0,88,252,99,162,56,142,82,153,217,0,252,178,196,215,7,65,235,16,12,103,3,196,20,248,160,169,162,191,216,67,157,40,250,67,247,165,124,193,183,137,101,29,247,69,19,0,154,248,232,209,137,237,73,210,90,61,169,6,94,233,152,7,97,181,161,216,129,249,93,137,15,30,190,208,6,163,14,20,58,114,255,146,141,176,210,216,161,135,6,226,175,176,1,176,120,54,240,108,226,43,95,244,181,27,0,229,11,125,155,248,182,240,169,221,247,62,8,236,144,219,38,190,45,124,248,99,215,6,96,210,36,190,210,217,155,248,208,81,127,35,135,221,0,104,65,178,250,115,50,191,163,113,104,2,196,197,255,196,139,218,151,2,0,190,38,128,245,239,222,2,160,124,209,75,245,223,81,0,236,70,94,241,144,67,11,2,112,182,0,200,193,142,226,154,196,179,246,179,5,192,110,152,52,118,240,243,37,224,85,119,241,243,75,10,192,94,63,216,56,210,2,138,254,118,35,101,253,160,5,128,141,66,143,41,252,86,15,83,0,190,
36,121,167,69,192,225,64,0,249,181,112,35,191,198,209,141,103,77,208,229,71,58,130,122,192,38,36,208,75,98,92,228,91,30,123,86,175,2,45,93,126,118,156,12,59,78,37,56,142,167,248,219,225,169,103,95,197,20,95,149,61,5,166,15,234,168,176,0,165,246,235,232,168,118,18,26,228,78,187,248,154,135,0,41,82,225,219,63,99,91,124,96,99,209,214,154,234,192,78,229,77,70,155,201,17,83,35,142,105,174,209,132,116,211,67,142,236,170,53,204,219,135,84,91,107,108,237,177,53,70,106,190,230,205,203,106,204,14,124,141,13,98,69,253,102,115,140,38,79,221,10,223,254,137,79,76,174,239,170,49,216,203,30,214,168,95,185,183,155,27,83,43,195,183,127,102,147,99,107,151,110,238,182,55,225,225,219,63,147,255,228,173,62,220,216,158,111,122,64,248,246,79,242,142,188,210,26,182,163,87,107,253,100,15,167,189,150,126,35,111,19,191,44,54,148,62,198,30,243,61,19,119,127,43,222,254,177,71,208,195,110,236,68,221,209,190,75,221,223,222,99,219,135,24,236,103,251,135,221,235,213,153,126,99,246,204,191,157,183,126,87,158,125,
185,32,47,51,120,105,176,107,207,207,75,142,54,250,21,189,75,234,237,151,217,115,127,121,192,192,233,51,0,122,106,95,3,142,151,122,187,223,4,10,60,117,101,215,51,0,112,244,47,125,105,98,235,143,218,73,30,134,216,152,52,17,28,245,187,2,196,97,99,36,141,146,77,164,49,84,253,23,49,164,26,43,120,8,42,159,134,40,65,224,116,51,102,62,19,80,227,75,192,50,111,54,149,245,225,231,73,56,19,199,133,27,20,138,19,9,202,102,126,251,33,200,156,70,235,3,135,217,160,237,57,253,8,63,79,18,123,217,135,32,91,200,184,223,121,10,162,155,46,179,65,219,117,10,2,188,110,156,129,215,13,46,247,39,12,61,243,144,92,110,20,182,64,132,27,20,226,20,123,105,67,192,94,166,193,134,159,39,153,13,154,62,32,133,159,39,217,67,44,221,160,106,142,153,190,183,167,1,135,159,39,73,220,216,124,218,251,86,82,54,34,225,231,73,24,104,199,235,24,61,245,178,59,125,54,82,186,249,218,241,58,80,119,249,52,82,221,185,114,82,97,158,180,203,39,21,122,218,197,188,110,192,22,205,55,194,192,235,235,28,232,154,211,180,240,243,36,105,132,
156,2,234,201,244,246,169,100,248,121,146,125,138,12,78,50,247,62,161,4,159,167,241,196,25,126,158,20,108,104,57,169,216,245,86,130,179,98,61,49,180,27,42,123,226,169,27,46,10,32,27,48,61,149,183,79,162,246,53,160,125,98,215,147,242,189,249,79,254,134,159,39,5,27,97,181,39,27,51,123,242,107,78,146,195,207,147,120,80,215,135,2,217,136,112,50,212,39,113,185,227,65,92,62,115,52,235,122,66,194,103,138,187,62,75,208,141,110,248,121,146,61,97,249,43,63,83,212,135,174,29,15,86,182,191,218,7,179,240,243,164,29,113,72,61,219,243,230,160,145,125,77,248,121,82,248,121,210,47,253,74,129,55,127,250,121,136,214,49,226,199,246,81,173,247,118,63,75,125,211,183,204,212,187,147,82,239,128,51,39,164,193,155,67,230,47,153,121,219,111,205,155,133,242,103,109,122,48,23,126,158,20,126,158,100,246,113,246,205,49,113,19,126,158,36,27,137,49,179,145,216,245,170,130,4,212,7,85,18,80,95,77,0,167,159,171,236,72,192,183,119,126,158,1,220,174,147,145,240,243,164,224,187,68,54,16,182,48,237,125,16,176,133,75,
31,228,177,159,30,4,96,119,70,61,17,214,131,0,54,194,246,65,195,30,4,80,56,117,3,168,126,123,201,65,128,226,227,39,61,8,216,81,248,236,131,135,149,131,7,25,253,46,81,233,132,159,39,149,191,19,183,13,68,227,31,255,153,3,149,178,31,116,3,24,126,158,36,223,98,134,111,255,76,174,134,111,255,130,195,146,240,237,31,181,123,251,176,177,252,246,205,147,56,161,38,219,90,111,107,140,62,148,219,26,99,107,61,247,246,33,83,62,47,12,223,254,97,187,61,95,29,200,223,114,169,13,205,87,11,246,243,34,253,180,66,62,143,97,29,155,203,231,50,186,201,211,30,74,143,213,135,84,236,27,190,253,219,245,233,123,240,121,13,123,188,240,237,95,144,167,230,33,225,87,123,251,71,60,133,159,39,253,250,159,39,133,223,77,75,83,48,159,197,236,58,253,160,17,84,203,26,223,123,217,211,143,54,211,64,108,96,234,67,0,112,225,119,211,60,12,109,63,4,133,191,154,36,77,143,135,72,253,158,148,194,164,241,99,79,211,194,141,73,248,171,73,18,31,47,249,26,193,254,109,150,214,23,234,10,135,15,122,8,161,135,23,196,79,94,238,217,64,
233,233,108,248,171,73,178,177,212,67,24,173,191,216,69,55,246,212,107,221,184,179,145,226,129,80,237,165,111,133,185,39,15,245,187,237,223,234,175,38,133,27,147,99,248,233,215,254,110,58,220,152,72,176,134,27,147,237,95,47,217,113,58,187,247,51,141,14,177,21,79,246,122,58,27,254,156,163,254,245,248,137,32,126,62,251,215,227,225,198,36,248,204,135,147,211,240,231,28,117,35,82,254,85,37,243,153,79,249,53,165,253,76,50,220,152,96,39,226,229,95,169,159,115,12,55,38,225,198,68,119,208,52,214,189,175,141,57,154,213,239,39,245,72,205,254,37,45,127,72,36,63,187,199,110,58,220,152,152,141,153,125,149,96,95,27,135,27,19,98,131,194,162,39,105,108,52,236,235,110,243,61,81,184,49,33,127,120,101,82,126,149,242,247,229,36,0,123,153,198,27,110,76,196,54,216,67,79,204,56,1,97,67,175,247,225,198,36,120,133,182,235,15,137,169,219,230,179,150,112,99,98,78,92,235,36,94,120,16,212,87,139,212,31,61,1,226,222,156,8,253,203,249,125,233,223,222,95,154,7,127,71,19,121,214,196,171,84,254,136,188,252,143,
108,68,151,248,71,54,162,237,215,222,153,191,52,87,254,55,226,99,206,143,95,249,186,243,227,152,235,252,231,127,244,72,199,31,243,175,108,252,152,127,101,227,199,163,117,254,47,156,141,100,87,228,199,252,235,26,255,155,227,58,27,233,174,216,134,219,245,241,236,125,215,173,186,159,118,253,3,247,147,174,63,177,225,117,57,27,41,150,50,93,31,207,223,231,95,25,190,159,114,15,222,207,184,75,205,32,199,64,138,128,244,32,2,146,3,82,29,56,75,185,13,175,59,178,145,234,142,110,100,186,63,74,129,83,1,124,28,188,15,96,216,202,236,57,112,206,223,235,101,182,14,60,255,53,144,156,141,76,231,194,70,178,101,129,201,200,70,235,201,133,13,55,87,197,124,244,126,171,59,182,145,204,204,0,88,189,145,105,243,247,109,180,158,142,0,52,189,145,105,117,54,220,214,56,0,247,69,160,40,16,174,176,95,220,104,109,119,54,18,94,116,35,61,244,240,4,66,57,247,19,176,111,5,223,133,115,122,84,22,61,230,91,54,210,167,14,130,21,101,189,119,35,145,174,99,174,150,235,134,141,68,11,164,209,59,61,80,96,174,121,35,157,59,200,
124,181,112,216,72,164,162,204,45,108,164,251,157,141,214,108,140,249,102,67,107,76,121,36,82,17,238,135,152,175,218,112,251,163,27,201,147,115,224,197,84,199,214,54,120,183,202,90,53,176,208,63,227,71,55,90,11,206,70,22,0,76,126,246,62,23,27,94,135,179,209,222,31,3,98,106,163,53,29,189,223,14,100,54,31,193,144,30,115,49,96,14,99,157,232,70,182,181,106,163,227,244,157,55,238,119,232,164,3,155,251,181,27,238,73,108,217,17,217,72,22,30,52,24,179,84,136,89,134,54,18,121,44,123,26,174,19,247,22,224,86,133,24,17,8,98,82,239,12,186,136,78,153,58,145,11,78,221,27,217,20,54,56,21,7,176,159,249,10,136,87,195,121,104,195,203,3,219,38,243,99,192,65,45,83,9,206,65,133,19,157,218,7,102,144,184,98,163,227,164,248,14,26,56,35,247,122,236,126,14,152,14,183,31,58,147,27,29,50,159,95,224,30,248,62,164,202,139,247,22,54,50,45,21,224,140,131,143,21,218,90,16,191,121,163,53,3,143,115,21,240,242,79,176,88,9,163,216,70,246,52,33,212,127,11,32,49,71,12,228,49,226,161,10,160,105,28,92,5,34,65,211,34,
97,60,173,134,79,15,69,54,18,238,12,26,75,148,226,148,44,70,106,153,4,174,106,35,195,181,87,56,8,92,63,248,8,147,19,115,11,141,59,13,48,20,6,75,255,215,89,73,149,48,69,194,20,9,83,228,229,41,178,221,137,34,231,232,68,127,120,234,202,91,111,214,236,105,71,127,232,252,228,149,156,243,147,152,235,252,23,127,252,72,199,159,208,142,126,50,220,237,252,100,180,110,233,159,142,108,82,159,127,66,59,250,223,105,71,155,9,207,217,76,143,122,31,83,167,55,169,211,31,83,167,63,166,78,111,82,167,153,171,229,186,97,147,58,189,73,157,222,164,78,51,215,188,73,157,102,190,26,88,119,147,58,205,220,194,38,117,122,147,58,205,124,179,161,53,246,49,189,128,245,8,247,67,204,87,109,82,167,55,169,211,224,197,62,166,23,109,82,167,55,169,211,74,139,26,182,41,117,122,147,58,189,73,173,1,201,63,251,49,23,155,237,80,246,58,98,80,155,218,164,78,127,76,157,222,164,78,127,76,157,102,46,6,204,225,77,234,244,38,117,122,83,234,244,199,212,105,38,29,216,252,235,131,155,212,220,77,106,238,38,1,5,180,3,86,247,38,53,119,
147,154,11,139,126,230,43,0,172,6,97,72,229,241,242,50,63,6,28,242,100,42,193,57,168,112,34,31,53,23,238,21,155,212,92,161,181,73,205,221,164,230,126,76,205,133,105,63,116,38,55,169,181,155,212,92,238,129,239,139,108,82,115,153,95,216,164,230,130,51,14,126,108,147,154,251,49,53,119,147,154,187,73,205,133,151,127,130,197,74,24,197,54,169,185,24,234,22,64,162,69,12,228,177,77,106,46,64,211,56,170,10,196,177,77,106,46,176,211,106,68,106,238,38,53,23,35,58,204,97,224,172,3,179,73,224,170,54,61,108,153,201,30,4,174,31,124,132,201,137,233,132,198,157,6,24,10,131,229,255,46,37,241,16,198,193,223,242,56,216,46,44,159,159,166,176,84,116,191,119,229,253,154,243,239,207,204,79,213,116,95,154,44,111,117,15,56,63,125,229,29,231,167,212,150,255,114,232,17,227,152,243,83,106,203,79,135,235,156,159,142,214,45,127,122,101,43,123,38,242,83,106,203,255,225,184,254,236,86,231,185,186,7,89,215,239,217,202,157,173,122,208,233,250,35,91,237,189,85,15,114,174,15,92,71,213,131,118,226,126,171,179,175,
65,96,206,110,229,0,6,230,244,86,251,133,152,192,204,66,171,66,96,122,182,10,3,213,2,211,191,149,235,172,126,80,80,58,131,74,103,124,43,155,175,21,152,211,91,133,190,184,225,213,27,19,152,241,173,246,17,165,115,29,94,74,231,236,86,103,87,115,0,211,113,246,176,240,130,251,153,218,7,29,66,57,219,89,41,51,253,91,221,103,98,2,51,187,213,209,91,247,160,91,4,235,204,71,4,102,144,245,170,173,108,14,202,157,231,107,5,102,4,189,26,4,43,133,94,21,70,175,246,131,34,79,118,171,179,71,229,17,24,229,53,200,186,179,213,62,236,207,35,115,60,208,189,48,160,116,208,171,167,210,200,60,80,41,116,46,91,153,209,189,79,97,198,129,169,19,24,120,13,170,94,55,144,80,121,157,221,42,12,55,139,132,167,89,119,182,178,103,239,29,19,233,246,109,121,189,240,242,34,15,60,119,158,137,200,150,151,91,216,234,232,7,162,191,142,185,161,173,92,71,148,249,94,80,171,213,31,57,119,114,203,59,29,97,110,122,171,227,116,108,43,123,46,14,220,228,86,174,91,76,50,6,92,116,43,91,16,69,129,83,92,232,117,65,175,189,10,56,127,4,
32,7,166,31,84,112,215,140,165,30,8,169,74,208,152,205,47,108,101,79,197,88,152,99,46,138,40,115,91,29,231,65,61,93,205,220,140,98,230,58,12,139,83,17,88,44,192,162,146,249,169,173,142,51,192,245,8,11,129,139,34,118,30,154,113,112,197,14,243,91,94,187,136,55,179,149,29,136,108,117,156,171,4,206,31,103,34,182,229,245,45,207,114,87,1,244,242,159,167,8,39,108,31,134,164,134,109,24,146,127,227,33,185,93,113,171,227,84,220,88,207,123,111,190,91,211,53,247,246,165,153,114,181,253,215,156,159,189,114,197,249,25,213,246,191,250,194,35,198,131,206,207,168,182,63,99,39,247,179,209,106,231,121,186,55,242,51,106,237,255,73,173,253,194,39,105,183,251,121,58,147,99,108,121,158,78,180,48,38,158,179,161,58,192,197,228,243,116,170,192,216,252,60,253,21,179,144,147,209,123,158,110,74,48,38,65,244,107,184,232,125,158,238,242,223,8,86,6,27,24,11,207,211,105,129,0,114,220,175,230,162,255,121,186,221,101,4,165,173,153,49,247,60,61,232,87,114,49,254,60,157,51,11,199,13,102,78,132,129,103,206,80,232,
241,107,153,128,228,224,20,163,191,239,121,58,239,113,129,184,93,6,162,87,197,29,3,197,136,123,82,72,9,143,73,193,56,240,60,221,106,48,94,23,12,48,51,162,7,99,170,44,204,1,38,80,120,112,72,48,94,69,76,3,209,108,32,122,212,86,240,104,21,241,208,35,41,11,238,243,116,207,45,198,185,231,233,147,102,62,97,230,207,8,75,108,217,154,12,224,6,199,25,253,74,16,12,139,68,190,238,147,4,214,79,188,222,194,216,242,60,49,136,26,9,132,72,160,95,2,212,68,42,201,232,62,79,76,220,98,156,123,158,232,49,128,175,155,245,139,230,190,173,145,245,60,112,74,96,250,121,98,124,136,9,120,37,218,12,36,126,83,22,111,233,194,171,207,19,57,187,32,35,188,223,90,100,156,121,158,232,50,128,25,179,62,98,68,232,50,247,19,152,33,225,142,61,79,140,204,48,226,140,68,62,199,69,243,243,68,210,64,246,249,251,153,152,122,158,56,105,80,242,134,164,213,194,222,167,204,252,184,25,187,12,129,158,113,161,140,240,35,221,114,81,243,60,113,198,64,180,88,123,216,5,101,129,244,127,106,0,70,140,122,233,148,137,140,180,241,226,153,
110,49,126,45,17,34,222,216,233,248,57,238,111,225,61,3,248,154,65,132,165,194,233,61,240,35,254,33,38,134,200,157,5,70,220,141,15,20,64,51,67,1,94,101,130,76,72,155,56,56,105,194,186,215,38,0,166,213,128,104,145,145,204,56,101,88,96,7,157,239,241,235,185,32,206,199,253,70,46,160,137,191,131,108,43,147,18,30,228,107,46,207,40,233,103,164,237,89,228,158,232,61,37,66,17,147,170,141,164,144,97,129,225,2,130,254,62,46,36,133,20,99,218,8,65,166,116,73,198,64,185,71,33,100,193,240,204,27,22,93,154,74,146,124,38,61,79,154,56,239,21,30,240,82,30,80,234,245,163,76,204,67,74,44,133,80,121,193,4,160,93,16,212,82,34,196,20,85,70,156,194,2,49,166,82,15,10,194,12,128,70,139,188,32,160,165,142,104,165,25,135,225,6,69,2,255,4,172,132,53,94,77,156,145,4,32,147,94,147,56,200,61,79,92,156,99,92,32,129,204,125,175,89,31,68,182,132,75,130,104,208,54,16,238,205,220,23,8,53,1,228,126,80,82,114,136,123,255,85,46,200,7,13,90,194,93,67,176,17,128,6,230,199,201,151,73,70,56,104,98,145,122,23,109,10,78,
51,79,197,9,18,137,180,160,70,37,240,118,98,194,134,232,225,128,192,200,66,64,96,92,70,178,5,215,105,174,119,9,161,94,24,8,33,114,94,67,27,9,181,88,48,63,49,195,252,173,237,90,144,23,129,160,175,89,68,173,232,53,69,101,4,71,34,201,126,40,105,182,68,41,6,34,2,160,189,162,52,86,154,152,18,8,82,88,149,144,5,161,5,175,9,87,22,94,35,42,36,8,240,233,120,29,163,84,224,25,198,69,92,107,60,246,186,120,176,238,121,26,161,118,101,209,235,2,79,52,33,148,186,60,119,152,17,252,139,139,1,220,136,127,130,139,165,159,72,137,54,165,58,45,36,137,142,160,95,128,171,81,64,116,104,191,200,3,104,11,48,165,75,33,181,95,16,14,47,239,23,80,24,156,6,112,129,248,17,45,0,212,118,161,17,42,197,158,150,100,211,104,119,187,216,79,205,54,24,218,46,36,207,140,30,218,46,136,68,169,212,60,72,115,161,181,156,6,163,237,130,149,221,237,130,232,215,118,129,94,26,188,140,154,120,100,135,182,11,238,181,93,208,38,180,93,64,64,219,5,247,65,187,120,21,132,93,237,2,183,237,110,23,196,40,250,37,200,147,4,69,47,240,171,180,
11,230,203,237,194,172,151,219,133,184,89,252,175,237,130,32,214,118,65,76,181,9,32,113,160,241,64,44,5,221,130,96,222,213,45,192,212,110,65,26,105,183,160,81,237,234,22,212,99,226,70,37,154,160,199,107,71,211,110,1,135,114,179,16,81,137,180,62,155,144,84,75,197,208,230,0,69,205,59,68,219,213,44,152,223,213,44,224,212,51,6,158,127,232,101,205,194,38,158,134,63,69,66,155,5,194,107,70,145,153,65,179,160,39,208,102,181,14,105,179,32,62,130,102,81,79,124,152,218,87,222,37,72,179,16,223,153,112,176,205,65,155,5,97,98,239,131,102,193,94,65,155,5,21,77,155,5,206,213,102,1,224,184,228,139,148,225,51,18,104,18,5,66,145,133,17,173,178,149,196,172,4,57,97,208,96,210,162,203,84,93,165,64,86,104,38,106,33,183,17,56,104,72,181,11,41,114,173,151,18,22,54,139,176,89,132,205,66,18,44,108,22,7,40,148,97,179,8,155,133,62,15,239,106,22,253,225,174,43,220,117,233,129,67,184,235,250,107,237,186,194,68,10,31,95,232,178,225,227,203,95,247,241,37,76,164,48,145,194,68,146,151,5,191,193,57,192,39,114,84,
176,253,150,40,242,23,188,37,250,187,231,231,231,222,153,121,187,230,212,204,213,183,190,54,113,229,173,154,166,242,203,162,10,231,231,175,116,59,63,231,101,209,127,253,218,35,29,127,206,203,162,159,243,21,234,207,71,99,254,67,247,69,226,79,157,23,173,105,231,69,250,68,228,231,188,54,250,103,142,251,111,47,62,132,195,67,190,101,121,145,98,33,115,226,187,238,195,12,19,41,38,210,39,129,78,62,210,213,135,124,92,34,144,47,248,24,244,133,123,194,121,145,116,89,224,19,158,135,124,143,250,194,203,8,58,19,160,61,228,187,153,23,46,19,201,182,29,16,41,208,188,214,135,61,16,175,2,162,250,69,6,8,133,202,84,128,245,124,78,185,66,239,69,250,43,206,139,4,139,173,173,21,208,102,65,228,19,238,34,99,18,25,93,145,51,253,194,81,12,184,139,20,47,90,191,10,38,255,37,190,250,188,222,202,10,70,238,69,186,3,172,246,232,139,214,147,15,47,191,112,207,85,51,249,96,17,20,255,242,139,214,19,17,149,62,121,242,131,42,184,76,202,108,246,69,186,51,246,34,217,18,123,241,198,201,42,96,151,147,172,212,189,72,181,
67,186,173,226,69,166,173,250,225,27,110,12,200,229,24,252,43,95,36,197,70,94,236,69,250,92,12,53,170,96,253,112,226,133,123,38,6,234,39,213,160,250,133,23,25,239,225,220,11,239,84,236,69,170,173,10,126,21,32,63,156,192,6,209,23,201,28,218,116,214,129,248,112,240,5,95,234,188,72,121,162,179,144,255,164,146,89,97,17,5,210,31,121,193,71,90,47,210,64,180,122,255,78,224,15,245,69,27,40,46,30,19,179,227,181,23,124,130,133,127,159,223,128,123,96,51,129,58,219,21,221,225,120,208,197,160,127,137,195,31,30,123,120,214,29,218,97,196,208,233,127,35,78,63,241,226,108,62,254,155,59,30,167,255,166,49,243,47,8,245,222,107,4,210,159,119,151,227,45,243,242,112,253,183,60,13,87,210,76,98,174,252,157,189,115,140,98,247,71,153,95,246,63,83,244,142,59,103,122,231,222,117,28,231,139,64,87,215,212,212,28,174,233,189,244,238,91,53,109,53,39,167,46,205,188,249,86,77,215,76,205,153,183,106,14,239,5,63,10,248,65,192,119,254,207,123,63,85,83,211,230,121,109,101,224,255,95,0,0,0,0,255,255,3,0,120,141,92,
94);


programfile__AMINOR_MID
:array[0..2128] of byte=(
120,1,236,89,223,79,27,217,25,61,247,142,7,27,10,11,187,192,226,16,126,69,4,214,193,76,48,206,128,103,96,152,181,19,102,199,216,227,53,16,72,194,54,43,37,219,86,106,181,81,43,237,75,251,150,62,244,15,176,100,203,79,243,47,172,180,85,86,251,210,60,84,106,213,167,254,79,244,140,7,131,67,108,199,120,213,135,149,140,132,100,152,123,206,189,223,119,239,253,190,227,51,165,147,223,255,22,192,16,4,127,255,82,58,249,238,91,254,229,224,252,89,68,145,241,24,206,207,36,255,62,63,82,134,14,95,226,124,104,234,203,223,253,121,233,228,187,151,191,249,118,233,234,135,255,87,15,255,240,242,143,127,226,135,104,227,195,82,26,231,27,8,201,134,255,138,243,59,130,28,202,84,248,236,10,24,124,194,63,161,86,178,5,252,144,125,45,43,218,78,198,177,149,44,164,134,37,7,19,249,135,210,202,8,61,35,77,243,211,31,178,28,103,65,232,144,38,159,96,216,217,55,45,19,94,65,152,38,244,109,233,224,54,159,154,128,142,153,98,57,234,97,165,136,169,66,81,38,62,31,39,181,94,73,192,176,147,66,95,19,70,250,22,185,148,138,29,
112,9,3,191,182,147,112,247,68,129,159,19,82,79,204,218,144,6,164,142,51,23,145,108,17,137,29,149,248,116,101,223,83,19,24,207,98,217,61,144,246,3,232,105,97,108,143,239,227,35,29,176,193,213,67,84,12,124,188,239,197,92,152,182,14,35,129,130,43,245,212,228,62,134,109,140,112,213,6,198,242,133,241,2,50,121,8,231,145,170,237,204,147,119,177,162,97,79,95,131,181,44,204,141,121,43,88,61,99,248,136,116,249,138,195,5,174,195,250,76,154,91,115,141,39,12,252,140,24,81,201,150,161,61,220,114,242,81,13,76,214,178,3,85,183,133,149,22,230,174,200,31,220,38,69,35,19,147,121,12,57,197,29,107,83,232,91,194,1,76,75,57,42,127,76,234,88,152,71,78,52,227,29,143,30,193,42,187,74,218,100,202,102,200,190,80,73,195,50,103,97,175,168,185,137,91,12,205,132,154,195,227,92,66,181,53,148,10,210,92,139,149,49,158,131,176,17,99,182,73,247,188,82,130,240,142,149,196,214,40,241,41,102,58,82,124,58,236,225,190,119,160,232,105,216,91,48,204,72,17,113,14,149,204,58,140,32,202,73,15,138,251,249,158,125,15,198,93,
89,200,64,95,83,93,204,112,79,12,40,58,102,243,57,165,145,169,168,99,72,205,224,230,191,94,101,166,44,115,93,209,19,176,230,111,155,80,26,41,113,244,21,88,75,138,169,113,243,201,170,152,24,115,16,156,149,92,197,57,193,230,131,95,17,57,89,217,196,226,209,179,121,158,144,195,39,34,179,33,179,58,204,221,232,17,166,51,193,89,2,15,214,33,166,143,78,119,203,174,204,38,21,51,45,143,128,204,237,41,178,240,100,6,156,50,131,105,175,44,202,112,74,199,106,122,59,226,97,154,188,203,204,148,153,139,195,230,14,205,205,49,176,92,64,119,196,109,207,109,8,115,93,218,233,104,9,147,12,41,135,104,152,169,211,74,1,112,15,68,98,51,200,212,70,165,116,34,18,152,114,177,226,29,75,99,23,250,186,176,239,171,165,96,27,120,154,120,176,140,32,203,51,30,80,122,182,87,40,42,118,10,250,166,52,146,164,157,182,161,52,50,53,225,230,71,10,176,188,47,34,218,182,226,226,14,121,227,204,212,174,174,169,214,42,76,253,150,14,149,147,91,240,172,148,212,239,73,146,153,155,179,86,112,192,185,216,67,206,52,90,113,75,98,125,
47,184,37,201,138,247,165,92,71,212,69,138,187,82,44,75,110,121,118,77,245,16,227,184,49,158,239,8,163,204,226,147,34,70,189,135,59,5,71,102,83,48,214,132,157,156,240,48,194,21,49,97,6,62,113,93,149,43,114,10,82,219,21,46,130,72,201,123,24,209,144,41,150,133,101,240,166,242,168,193,188,131,236,244,52,23,66,234,104,37,27,156,179,145,34,98,158,187,151,223,83,179,235,194,186,199,93,229,212,211,204,133,21,108,194,104,112,156,31,101,221,130,146,120,48,66,82,201,11,114,63,95,146,60,110,46,12,215,131,193,0,31,40,118,34,146,191,92,47,163,84,152,193,125,119,196,197,230,62,215,254,72,177,87,193,35,100,36,23,26,199,144,119,247,211,253,71,209,44,246,246,33,157,47,20,45,19,220,129,21,102,112,135,59,168,107,138,21,63,229,254,147,198,66,220,1,147,132,87,131,106,53,168,86,131,106,53,168,86,191,136,106,213,162,195,254,214,93,135,253,87,224,109,244,149,234,83,139,189,101,117,245,187,104,177,183,44,244,126,127,90,140,212,186,223,170,197,200,165,248,189,107,49,226,211,126,119,45,70,70,225,223,84,
139,145,119,209,111,171,197,72,151,247,219,106,49,98,132,255,115,180,24,169,99,97,30,219,104,49,178,47,248,55,210,98,164,123,238,95,106,49,226,83,204,116,123,45,198,161,146,89,239,71,139,145,119,149,153,234,85,139,113,166,156,31,106,49,34,39,253,254,180,24,89,120,50,59,104,49,242,46,51,83,55,208,98,164,59,245,47,181,24,241,27,126,39,45,198,161,194,239,79,139,145,55,206,76,245,170,197,56,211,168,31,106,49,34,147,126,39,45,198,113,99,60,223,253,104,177,144,183,179,22,35,117,212,191,169,22,35,169,228,5,233,168,197,46,214,219,143,22,35,245,10,51,216,94,139,145,247,213,160,90,93,211,98,76,202,160,90,5,223,177,47,190,57,242,4,13,170,85,79,223,28,153,169,65,181,66,236,255,88,173,174,180,216,208,223,175,105,177,205,119,76,49,252,11,120,19,253,70,125,195,202,90,213,118,44,13,233,75,31,236,13,59,97,181,169,189,142,45,51,180,191,104,29,209,205,226,119,232,51,250,93,132,233,213,86,141,69,140,82,109,209,88,242,93,167,235,107,122,92,196,100,136,209,155,214,214,124,232,107,17,41,170,6,142,27,
142,22,237,44,218,28,161,151,117,70,255,138,152,197,106,91,205,68,216,65,245,125,243,138,0,81,213,30,50,158,100,211,176,154,107,186,85,143,67,159,202,180,166,8,142,133,17,82,21,125,147,54,23,8,91,168,118,86,66,180,164,102,46,253,40,130,95,84,233,68,17,147,98,60,118,211,128,154,227,3,201,72,2,179,78,199,227,208,119,210,215,24,79,232,56,125,77,151,137,152,85,198,211,139,178,89,38,93,174,74,127,137,152,201,234,38,158,53,109,165,185,166,167,244,52,180,146,232,35,113,168,90,109,106,151,23,233,237,91,196,44,51,158,247,245,202,227,166,113,68,19,242,194,53,34,248,73,149,126,209,69,60,187,77,155,40,136,71,84,155,186,228,105,211,26,98,60,161,47,244,149,182,125,151,152,56,227,233,168,63,90,141,32,210,141,85,233,2,17,163,85,215,145,49,238,70,26,230,207,88,227,1,213,6,85,129,141,175,154,134,15,23,24,186,61,167,218,46,135,188,222,224,60,134,101,12,95,186,58,132,69,171,13,37,113,210,52,115,102,185,226,134,147,115,74,3,135,152,52,247,199,106,154,54,12,144,11,104,24,175,161,99,179,219,163,93,
67,162,21,78,222,94,34,144,244,213,224,14,13,238,208,224,14,117,181,60,63,116,135,174,26,151,114,28,54,174,127,79,127,175,254,200,155,85,187,214,157,126,100,173,171,117,239,78,132,233,181,214,238,68,140,82,235,222,157,136,201,16,115,189,59,17,41,106,157,186,19,49,139,181,182,221,137,176,131,218,251,221,137,0,81,251,96,119,34,56,22,70,120,209,157,8,91,168,245,216,157,8,126,81,99,119,34,38,197,120,174,186,19,31,72,70,210,173,59,17,179,202,120,122,234,78,164,203,213,216,157,136,153,172,117,239,78,28,170,214,90,187,19,49,203,140,167,167,238,68,240,147,26,187,211,69,60,87,221,137,15,68,173,123,119,34,38,206,120,122,234,78,164,27,171,177,59,17,163,213,90,187,83,227,65,247,238,68,204,6,231,121,167,59,17,22,173,117,233,78,196,164,185,63,87,221,233,98,158,203,239,176,189,118,39,18,173,112,242,246,221,137,164,87,55,43,242,143,240,102,253,103,248,123,181,78,15,238,39,222,174,122,23,15,238,39,238,91,189,121,211,38,110,244,62,148,212,122,189,245,6,146,75,169,183,220,192,15,188,15,37,62,93,
239,238,193,145,81,212,111,234,193,145,119,177,222,246,198,146,46,95,111,235,193,17,35,234,63,199,131,35,117,44,204,99,27,15,142,236,11,245,206,119,187,205,251,80,210,61,175,95,122,112,196,167,152,233,246,30,28,135,74,102,189,31,15,142,188,171,204,84,47,181,32,120,31,202,153,114,245,208,131,35,114,178,222,159,7,71,22,158,204,14,30,28,121,151,153,169,247,171,70,199,247,161,164,59,173,95,122,112,196,111,212,59,121,112,28,42,234,122,95,239,67,201,27,103,166,58,86,153,107,239,67,57,211,104,61,244,224,136,76,214,59,121,112,28,55,198,243,221,143,7,23,242,118,246,224,72,29,173,55,106,211,13,222,135,146,84,242,130,116,244,224,46,214,123,89,191,110,240,62,148,212,43,204,96,251,18,70,222,160,132,253,15,0,0,255,255,3,0,186,109,240,176);



programfile__HOTCAL_MID
:array[0..16824] of byte=(
120,1,236,125,235,115,27,87,150,223,33,209,205,55,197,151,248,16,197,247,3,162,64,145,32,64,8,15,130,128,90,13,2,32,41,138,166,104,81,52,12,209,180,33,8,54,12,153,18,69,170,45,219,227,65,129,146,53,169,74,213,196,36,55,169,242,135,249,148,143,91,149,154,217,217,77,101,226,84,165,42,95,146,127,97,171,246,19,255,133,173,202,206,110,146,154,252,238,61,13,160,65,81,30,239,204,100,50,227,165,62,180,26,183,207,57,247,220,243,186,231,62,121,251,238,71,105,34,170,161,42,106,163,231,183,239,62,205,225,215,37,250,77,162,250,159,136,126,115,199,86,227,252,25,253,230,29,69,169,238,169,163,223,56,137,1,26,7,233,55,54,245,222,227,7,31,60,162,223,40,45,139,143,247,31,62,26,138,124,240,40,155,121,252,116,103,90,253,249,103,160,65,52,68,84,251,49,37,137,182,136,26,52,84,240,191,223,254,90,95,111,250,185,150,111,252,90,167,113,125,171,91,167,214,159,107,212,249,181,190,243,190,78,61,218,110,159,70,67,225,253,225,48,93,214,50,55,53,242,233,153,131,29,157,158,234,153,62,157,134,244,173,126,157,6,
245,244,188,150,178,233,116,77,163,37,109,99,68,163,94,45,85,248,92,163,131,247,180,236,180,70,203,90,182,80,163,209,180,150,26,211,168,71,79,165,117,186,168,109,93,214,104,88,75,37,53,234,215,54,238,107,212,23,78,204,133,169,90,203,172,107,100,215,210,139,26,205,104,217,180,70,23,195,41,71,152,218,181,141,71,26,53,133,215,93,97,106,12,166,14,212,32,21,146,122,98,80,167,126,125,115,72,167,62,61,147,213,169,69,91,115,104,212,30,222,154,14,211,133,112,238,237,48,26,148,6,28,29,168,225,93,95,152,110,234,153,140,14,90,105,167,70,205,225,204,80,24,181,230,14,54,194,116,96,211,178,243,26,205,107,153,187,26,141,105,105,183,70,13,225,77,119,24,34,202,172,106,228,208,54,123,68,121,182,128,22,22,158,235,217,128,78,55,244,76,74,167,174,88,98,60,70,221,122,238,0,172,28,60,59,151,228,31,70,146,133,47,35,155,245,176,201,246,175,35,52,28,89,191,20,161,209,72,162,51,66,87,34,59,213,48,206,94,20,223,143,236,11,171,189,136,215,54,20,197,191,142,108,182,71,200,33,1,242,126,148,142,160,180,239,235,
72,166,47,66,67,209,108,7,96,191,128,5,125,29,165,222,72,238,54,32,81,80,245,117,36,61,8,176,77,128,87,235,187,14,157,94,126,172,103,251,241,101,16,206,208,140,47,206,175,77,35,203,214,162,116,69,84,173,83,163,150,18,102,166,101,94,118,106,20,209,118,240,99,85,219,149,246,188,255,80,163,142,112,238,114,152,134,195,251,47,242,176,172,230,63,181,150,236,74,183,206,246,107,52,168,229,94,246,106,20,142,100,66,17,10,70,182,132,164,34,185,77,136,92,223,238,209,105,76,223,125,217,10,171,222,63,183,234,63,140,85,159,199,135,63,84,164,61,143,15,255,239,34,221,121,124,56,207,31,254,156,51,177,121,116,89,191,212,126,206,41,110,21,82,94,153,232,150,210,228,78,31,210,228,186,232,244,208,90,246,131,157,199,200,148,107,162,31,124,248,232,225,158,250,139,207,36,236,16,18,228,135,50,65,158,161,134,187,72,144,95,36,15,245,101,10,47,82,240,6,57,215,201,187,248,162,235,23,90,62,116,232,165,102,39,85,133,169,86,167,170,32,189,216,12,173,145,71,35,72,206,161,213,252,66,163,175,166,180,252,200,161,
131,170,230,168,198,67,181,33,42,44,160,244,210,33,192,2,43,164,109,208,212,234,139,251,32,100,63,68,22,30,34,10,80,213,20,189,152,159,152,39,45,68,126,15,5,23,200,227,36,160,188,186,117,232,17,53,212,249,73,1,232,4,125,232,139,209,228,42,133,55,41,184,250,50,7,18,206,195,32,217,38,169,6,233,179,143,10,97,224,108,29,134,117,10,132,201,189,64,222,192,171,119,188,84,5,242,110,106,12,83,50,178,78,65,157,52,80,95,32,159,246,82,5,254,246,97,132,170,52,178,129,138,143,84,15,29,172,105,155,228,141,209,92,140,92,1,114,232,13,130,139,217,195,57,170,66,115,92,212,224,165,106,141,158,157,11,229,92,40,231,150,242,59,187,79,36,67,225,29,242,237,82,48,243,242,131,160,240,92,10,147,45,66,211,190,28,5,183,73,124,206,117,6,69,128,81,125,84,133,241,78,56,101,150,251,178,237,168,181,6,78,15,140,26,31,213,68,232,34,60,244,71,135,122,150,2,73,242,38,200,189,73,225,204,171,21,248,60,60,95,167,234,48,145,155,158,196,210,180,148,33,0,133,182,200,155,122,249,99,16,25,61,12,81,179,151,46,199,168,102,9,
35,32,42,124,8,66,117,135,193,52,233,162,126,114,102,94,205,57,73,13,147,18,36,69,167,207,254,248,76,35,18,69,208,240,4,197,183,200,135,8,187,241,114,29,124,47,34,36,214,72,161,161,241,54,12,214,227,116,208,24,75,145,142,150,109,80,104,157,230,150,235,68,208,250,8,65,171,38,70,132,16,141,160,21,162,248,121,208,58,15,90,223,43,104,137,174,249,210,225,239,99,239,61,22,255,124,11,198,232,208,242,221,191,197,69,151,0,54,162,229,213,195,74,87,253,106,248,148,151,34,1,193,92,91,126,234,141,142,234,0,192,180,150,31,254,131,53,96,149,107,236,250,45,13,24,5,216,140,150,239,63,124,205,109,191,234,125,221,99,171,0,221,32,40,134,210,52,151,32,71,234,213,7,33,170,150,41,19,146,170,141,115,95,61,247,213,179,124,245,197,189,67,88,11,108,198,155,38,45,67,49,244,105,57,114,16,185,136,52,162,57,34,47,117,204,137,238,138,96,77,72,107,189,162,11,232,213,178,164,239,8,51,139,101,201,155,65,31,216,142,100,26,253,2,178,90,128,121,201,22,131,235,229,72,223,165,88,142,230,64,92,152,37,38,117,209,187,
0,29,96,160,134,78,228,32,252,47,206,44,49,45,138,97,0,6,3,24,18,104,155,114,48,224,62,100,73,179,212,189,84,80,160,2,103,22,89,135,144,91,60,167,35,122,190,192,194,65,219,97,28,19,233,34,179,80,157,164,120,169,199,153,19,194,143,239,80,24,234,200,245,120,69,110,65,248,164,147,18,167,183,157,137,105,32,94,56,4,153,56,84,177,51,232,196,100,62,169,58,213,196,169,112,13,209,162,238,48,148,18,53,32,62,234,105,63,96,189,72,96,26,189,212,27,35,204,84,222,2,68,179,150,119,29,58,18,243,250,198,176,142,188,102,7,249,142,205,65,211,32,17,163,47,245,36,33,73,88,74,21,70,98,212,176,36,106,45,136,161,26,90,147,163,64,154,66,59,228,217,161,169,76,33,3,202,7,55,64,26,230,131,145,147,19,48,85,135,129,29,10,238,144,182,227,195,199,21,36,95,213,1,82,49,160,243,144,50,69,205,129,20,133,178,164,229,16,169,25,39,15,156,182,67,79,142,180,4,249,49,228,74,61,1,90,33,126,136,136,135,84,202,79,133,30,0,216,14,253,243,20,198,215,53,210,214,189,2,224,218,33,146,64,116,28,126,178,97,208,136,197,134,4,192,
122,14,39,211,228,78,11,153,249,50,20,204,62,21,144,13,135,110,154,113,103,218,125,52,142,113,155,27,9,228,90,39,6,163,62,44,214,236,82,96,71,180,11,61,192,23,135,1,145,254,125,17,204,9,212,112,6,195,196,1,57,204,195,96,177,0,1,82,189,150,7,195,182,67,119,134,2,50,57,12,167,158,11,242,93,64,28,8,164,33,126,200,17,77,173,13,111,245,133,105,72,219,153,5,83,85,129,28,198,157,212,124,24,205,137,44,81,223,25,0,74,246,16,66,14,139,97,38,68,86,29,165,22,64,172,9,9,248,210,200,113,41,2,81,228,10,16,75,190,64,135,192,141,208,93,232,24,254,27,201,142,131,129,136,48,128,194,194,202,238,5,153,214,85,163,245,43,84,16,253,102,221,161,240,70,200,55,231,2,114,63,198,221,213,72,234,48,158,238,157,91,167,208,38,233,9,207,156,200,237,234,161,77,151,190,65,177,164,72,0,189,137,106,224,78,162,182,78,240,213,16,195,108,246,22,45,193,114,82,176,133,234,24,213,35,223,13,145,234,165,8,192,62,57,60,55,223,115,243,253,115,54,223,243,9,170,243,9,170,239,53,107,23,220,162,232,174,8,167,78,116,161,57,90,202,
189,120,255,23,149,83,165,47,219,208,185,33,255,86,162,162,199,86,17,39,157,216,116,80,220,101,48,245,111,48,125,90,143,233,211,248,179,236,254,7,79,213,191,170,152,53,117,200,109,5,215,48,107,250,95,147,71,238,173,131,89,55,93,119,39,159,186,49,5,186,85,88,242,208,21,239,122,225,19,228,90,158,205,131,219,30,186,236,78,229,220,212,236,218,56,120,226,162,39,174,197,3,143,139,60,174,196,174,139,106,221,155,133,5,55,93,3,214,29,15,13,122,18,243,126,125,220,67,221,193,133,218,191,210,242,182,35,63,185,61,91,211,65,186,224,15,14,131,78,48,134,14,211,131,41,210,240,198,221,48,141,121,214,73,91,1,32,197,16,254,63,57,242,96,95,0,53,226,103,161,233,200,185,125,128,89,85,143,51,149,118,210,69,23,246,6,184,168,211,189,93,184,227,166,65,183,54,239,93,40,120,2,27,157,168,162,253,200,75,253,110,106,8,80,97,36,188,62,138,117,171,94,65,96,244,200,179,57,239,91,232,7,79,193,245,122,31,205,250,22,208,251,118,123,52,188,119,1,173,255,200,183,208,233,161,126,192,54,28,5,19,85,62,10,250,98,85,248,
208,122,20,36,59,38,87,67,91,248,69,193,163,192,178,13,165,13,71,33,234,198,239,158,35,111,172,62,64,151,80,212,123,20,240,215,120,105,26,165,181,71,152,192,9,111,206,7,99,98,243,133,79,171,15,146,10,136,233,35,76,13,251,104,20,16,42,168,94,212,211,99,40,237,57,210,54,219,117,236,168,160,250,208,198,44,122,195,96,186,15,16,67,71,90,18,3,209,58,64,92,62,18,9,239,202,188,182,118,89,71,58,140,41,233,141,43,33,234,212,231,104,110,131,180,100,19,160,15,180,35,232,93,35,101,142,14,148,32,186,86,116,239,217,102,57,9,133,92,201,129,52,69,199,204,82,178,73,206,120,99,102,170,96,15,110,32,17,67,94,33,122,109,100,114,216,2,130,36,5,54,166,167,90,100,218,135,121,235,194,72,112,157,144,121,133,115,45,160,36,103,163,28,225,36,5,147,72,205,154,48,129,37,103,150,10,3,152,226,9,3,111,91,224,201,162,43,162,100,27,37,173,72,42,24,104,208,187,66,115,232,222,83,173,176,33,153,184,79,120,145,3,108,211,220,54,74,192,53,114,244,194,144,119,83,14,40,211,173,152,85,71,238,63,71,118,1,148,98,32,27,178,
248,57,1,148,196,111,192,181,73,74,72,5,236,144,66,40,65,222,245,118,204,153,1,19,64,195,152,74,147,196,185,8,53,218,189,107,52,7,242,219,23,36,26,136,21,134,66,73,10,36,72,75,53,135,72,65,226,163,209,85,224,96,30,78,75,129,1,148,96,0,81,232,15,128,3,0,37,5,79,178,232,170,64,219,4,208,5,100,33,18,173,48,24,0,7,219,164,109,183,131,71,168,94,163,9,224,72,74,0,50,41,13,202,186,0,199,64,32,110,23,16,24,208,228,58,36,26,212,87,232,11,195,33,96,102,208,235,38,75,175,202,47,56,155,240,39,132,220,145,113,106,201,139,72,3,53,49,131,40,146,209,75,97,100,160,72,84,151,41,184,217,33,245,141,161,20,112,174,132,177,84,1,28,124,202,180,35,45,213,132,150,107,37,194,178,252,176,73,254,181,118,148,74,28,32,216,81,179,150,36,63,214,38,146,109,72,101,229,39,85,34,160,210,148,76,133,19,29,82,161,104,159,68,224,26,128,179,221,129,18,73,72,32,244,250,144,23,111,195,38,58,48,253,9,245,195,175,81,2,19,9,110,183,249,68,133,54,216,223,128,239,6,133,55,96,112,45,62,100,168,2,110,28,188,98,158,48,156,105,
133,183,248,4,90,225,178,111,65,2,37,208,100,56,14,236,246,10,108,219,183,66,97,81,130,37,15,65,169,23,203,41,40,10,138,34,204,197,162,153,99,190,85,72,3,203,44,16,8,128,4,165,94,239,188,208,117,120,11,234,175,13,136,162,81,160,193,186,2,219,23,229,26,11,196,89,24,244,162,186,77,10,108,192,36,161,89,1,4,8,48,30,216,186,24,144,22,41,41,233,168,30,202,237,224,73,90,240,4,194,176,220,240,102,43,236,3,214,5,160,1,12,184,4,165,68,153,18,86,143,4,177,24,48,47,0,19,163,13,8,25,227,175,33,207,34,249,32,244,173,54,143,92,196,9,210,168,103,131,124,144,86,234,162,71,52,72,108,152,186,228,89,38,31,164,149,104,199,130,146,143,234,130,52,44,74,128,150,128,144,73,78,208,20,46,123,98,178,104,19,64,140,55,234,89,97,32,140,53,48,42,17,148,122,61,144,150,208,49,23,97,196,50,38,24,16,150,210,10,50,80,6,128,186,225,170,240,151,208,118,151,76,217,149,16,13,9,247,17,190,8,105,169,24,162,195,125,186,197,124,237,22,66,80,167,244,40,56,240,216,28,218,40,208,218,1,129,66,0,93,134,220,49,254,12,109,194,
91,145,252,171,2,8,41,62,40,37,65,9,174,138,18,0,193,49,225,213,27,168,78,8,102,142,182,121,18,59,152,251,202,141,248,119,229,8,6,130,241,60,56,91,71,172,107,59,66,198,139,126,112,46,243,50,143,175,222,35,12,42,36,98,97,14,95,151,143,48,24,20,163,194,220,203,61,124,93,67,160,198,32,72,184,242,35,124,109,58,210,118,9,195,172,96,150,252,169,87,34,190,183,32,18,219,252,210,157,52,114,1,228,249,145,8,132,152,224,207,124,117,203,172,28,210,196,52,186,160,222,169,229,239,105,52,42,64,48,135,17,200,126,229,5,200,0,186,28,155,24,104,65,188,128,89,60,194,44,60,134,78,168,201,147,121,185,11,128,9,212,81,37,165,219,4,62,246,1,51,116,132,54,139,249,51,52,27,65,96,231,96,95,6,69,120,22,2,31,218,90,24,159,222,247,79,35,48,238,204,79,239,215,206,209,245,185,157,170,105,154,156,163,214,233,157,137,105,186,232,204,250,48,187,239,218,247,185,72,117,231,127,226,113,139,129,124,134,162,185,9,228,194,81,186,128,113,122,36,59,27,161,218,56,133,145,53,44,125,58,181,68,20,165,66,237,210,14,69,211,254,
40,85,45,209,13,1,148,246,196,73,137,144,38,144,119,11,215,209,63,68,105,206,187,251,213,91,96,195,177,251,220,251,57,102,245,146,88,103,152,194,96,58,175,78,161,35,117,82,147,43,127,208,230,66,18,240,121,97,216,77,29,158,207,11,61,30,234,243,238,123,189,164,155,204,84,69,83,180,156,26,141,82,205,50,93,90,222,169,138,103,111,160,158,101,114,226,61,154,9,68,169,118,153,92,203,57,138,102,209,227,230,131,152,169,57,90,166,250,40,117,198,83,162,55,182,31,69,51,85,113,26,136,210,64,120,183,26,242,42,44,195,6,10,73,68,75,12,61,35,217,139,17,17,209,234,49,238,236,70,104,138,96,226,34,211,33,139,84,20,245,97,192,26,199,144,62,243,130,228,18,131,24,158,222,153,219,21,161,86,207,118,98,114,9,162,6,197,129,57,49,197,64,90,186,3,61,27,226,23,186,141,1,44,238,206,9,168,3,44,69,3,6,150,88,24,14,231,41,152,47,52,159,204,222,108,35,237,106,147,174,222,141,55,45,69,85,210,122,155,116,229,217,109,37,177,86,143,231,67,93,33,109,240,93,173,142,180,3,47,120,189,25,164,145,80,158,180,125,111,136,106,
52,242,158,132,35,234,240,189,170,163,121,24,103,222,118,98,127,172,228,243,139,250,35,85,77,40,83,139,182,163,121,82,79,72,107,63,130,32,66,152,196,218,45,180,156,84,105,234,147,133,214,238,5,212,52,241,80,87,151,162,205,79,22,68,29,85,154,82,179,132,138,155,251,110,43,221,162,228,18,96,34,43,10,173,213,93,121,11,196,0,223,55,181,168,244,221,110,146,239,109,35,49,165,113,93,209,239,183,62,190,171,126,17,3,124,115,56,162,68,86,212,199,119,155,19,107,202,72,172,22,245,46,69,235,166,22,175,225,43,42,34,237,99,120,84,93,8,125,216,142,113,2,26,160,218,184,94,231,190,163,124,124,11,92,40,225,136,96,4,4,220,119,218,86,87,47,61,187,13,170,54,210,190,234,130,167,173,6,243,20,254,116,54,72,232,187,174,7,63,199,58,89,245,9,88,203,111,43,249,199,202,202,143,209,102,79,203,23,202,237,29,229,157,247,65,83,80,35,173,30,206,129,229,237,122,76,116,248,247,11,79,78,32,91,160,60,187,125,33,178,98,147,45,30,184,27,199,79,53,177,214,252,241,45,69,74,254,18,164,45,101,208,6,54,208,86,136,132,180,
174,135,122,227,236,205,17,249,62,4,176,237,165,186,154,37,21,173,39,45,142,180,51,30,164,96,112,63,23,196,140,79,214,17,160,213,240,167,228,251,244,203,147,135,122,179,196,184,143,150,79,45,182,65,232,80,224,131,35,31,12,143,150,125,48,143,207,107,133,12,66,111,171,250,125,219,252,3,85,201,42,208,221,252,158,186,254,169,114,243,71,202,120,94,249,113,30,205,250,16,141,243,126,174,236,236,171,239,60,81,244,71,202,86,182,102,40,163,220,126,79,81,19,4,98,234,9,171,230,93,193,40,65,203,3,225,220,83,88,84,195,187,90,13,105,35,80,35,84,164,38,90,32,100,210,58,183,151,20,232,202,247,174,208,143,84,136,6,141,181,221,82,86,87,133,165,65,56,80,148,100,180,14,172,143,196,192,119,221,221,184,104,41,228,41,237,240,160,14,22,184,164,237,188,167,81,175,158,123,87,167,1,4,196,200,254,211,19,88,74,205,82,11,208,103,111,194,80,29,0,238,187,45,12,132,180,43,120,130,120,122,189,25,156,64,164,164,141,130,89,112,66,107,224,173,89,188,104,195,12,211,184,222,132,214,160,94,210,250,161,133,174,187,74,
107,18,150,0,128,130,126,20,193,60,30,205,232,114,43,82,36,119,15,155,57,245,60,197,118,94,124,20,35,177,209,182,16,56,143,236,127,228,200,126,239,115,177,36,28,221,253,228,30,53,110,236,134,138,17,94,152,95,51,180,12,19,130,217,76,45,54,195,132,164,39,20,126,116,180,65,7,29,63,168,248,159,224,117,42,111,226,85,98,78,236,130,65,254,242,95,18,255,210,45,241,96,229,228,254,156,114,119,88,217,175,87,143,116,131,78,144,123,76,216,212,79,107,149,222,102,37,219,166,166,59,149,233,1,229,217,132,146,242,194,213,155,48,192,236,136,26,158,40,213,197,141,217,56,213,47,26,99,136,158,34,46,33,88,101,147,74,67,74,249,44,83,139,248,136,240,215,240,84,233,220,87,183,62,179,237,125,169,230,243,133,251,71,139,52,187,104,244,44,210,88,241,89,208,78,208,19,60,187,93,79,90,29,190,94,214,140,121,221,184,168,209,21,209,241,26,31,107,116,33,100,124,85,31,162,3,95,216,152,215,12,228,86,215,117,3,179,246,200,80,170,81,18,52,144,102,7,2,6,198,160,94,188,7,232,157,32,245,75,72,36,242,147,200,17,117,137,
37,135,213,23,117,227,185,102,52,98,45,36,108,32,250,138,19,6,113,227,163,56,181,46,27,243,113,163,10,35,167,101,163,58,78,72,168,107,226,198,124,212,176,197,233,189,40,117,47,24,7,254,5,122,20,49,122,34,52,182,108,184,208,13,136,62,203,247,174,226,250,64,105,205,41,15,158,162,129,220,169,21,30,254,56,175,206,239,41,235,31,42,16,4,194,40,105,109,200,103,26,226,134,43,78,141,192,93,166,198,184,17,140,83,213,178,113,109,153,90,227,6,178,174,186,168,241,20,25,217,156,102,4,79,134,239,137,94,37,159,191,126,180,104,96,44,53,184,72,13,55,69,3,46,223,164,17,228,10,234,199,183,16,174,71,208,111,52,161,141,161,12,186,203,25,12,25,195,70,13,114,37,236,97,175,69,184,87,67,134,59,132,37,27,163,48,34,14,93,24,1,76,205,235,185,249,136,81,139,213,148,8,117,158,84,15,42,68,85,71,218,190,239,228,71,54,165,167,69,217,190,164,222,25,85,30,95,83,26,253,96,120,226,40,178,139,148,231,102,132,188,145,221,121,61,135,141,43,179,58,213,105,217,17,116,34,225,156,56,189,161,101,145,168,85,133,211,242,84,
199,110,193,163,167,128,48,166,83,119,36,23,0,218,9,236,4,149,28,97,33,238,228,86,29,42,139,189,93,13,219,82,194,237,138,218,15,59,82,91,61,82,48,98,197,40,155,136,211,96,60,55,175,111,213,65,242,90,22,71,80,54,209,43,234,59,31,235,208,78,42,21,167,174,165,92,226,196,235,83,86,174,168,222,30,176,219,22,110,87,63,31,83,166,67,160,97,247,250,154,175,221,128,81,218,142,150,104,248,100,51,172,124,50,173,160,234,206,54,212,14,67,70,251,136,58,171,144,180,95,84,110,58,129,208,125,20,53,144,230,53,69,169,63,106,140,67,185,186,81,123,50,63,43,8,126,208,173,180,119,168,61,45,117,189,205,245,145,11,138,191,11,30,1,78,85,96,40,72,201,64,144,186,144,134,70,141,225,40,93,214,141,182,147,15,221,202,168,93,77,244,67,126,109,112,158,158,105,208,87,143,226,6,22,187,46,199,169,47,110,12,225,169,27,24,9,228,47,1,185,62,110,244,197,113,220,198,160,184,209,29,39,44,168,41,200,103,7,129,64,186,209,3,32,224,138,73,187,30,89,208,27,167,26,113,38,70,64,247,72,104,164,195,24,181,200,143,87,37,96,83,204,
240,137,108,18,185,194,231,247,154,134,239,137,68,7,73,3,76,115,39,141,188,163,46,254,80,253,252,158,232,194,187,23,154,97,138,173,73,229,65,170,30,38,11,203,236,186,91,15,75,187,188,85,125,20,163,234,147,201,143,84,251,227,166,108,78,89,220,128,40,59,142,98,6,22,215,122,217,185,99,134,56,28,195,109,89,50,62,56,65,174,217,117,23,9,108,23,82,18,153,181,117,161,195,239,76,139,180,46,254,172,249,193,83,5,217,14,200,32,79,65,164,216,94,2,164,72,126,80,107,103,186,254,65,10,76,136,156,78,230,38,205,72,118,144,53,124,124,171,30,145,67,146,26,134,18,239,159,188,59,175,54,123,133,53,66,225,95,142,40,144,47,212,222,222,161,68,46,168,48,166,9,161,209,22,232,100,252,36,95,165,140,212,170,67,245,74,127,163,242,184,89,121,212,34,244,215,218,9,205,53,67,151,64,130,93,195,222,96,14,147,67,42,20,4,27,255,124,76,29,181,43,67,19,202,128,67,93,152,18,198,242,241,140,218,225,86,96,144,129,235,117,48,91,216,217,182,191,174,110,174,222,21,172,123,119,30,70,166,194,166,144,71,31,105,70,75,148,6,17,
141,116,3,123,47,17,153,38,112,174,41,100,12,132,176,196,102,228,48,71,112,210,57,35,236,83,40,232,100,92,181,17,93,115,84,41,171,53,42,152,131,53,105,173,42,172,31,54,53,211,167,172,142,171,97,151,114,237,6,148,85,11,149,183,196,141,119,96,23,113,163,254,196,22,86,63,158,81,62,181,43,249,33,209,238,153,190,129,59,163,130,61,97,183,113,106,63,25,112,192,178,85,225,188,113,99,14,198,173,194,169,96,234,179,189,192,81,3,215,1,7,115,34,117,217,152,92,166,54,214,89,220,184,18,167,206,152,225,198,114,105,212,112,70,169,121,193,72,157,200,202,125,112,33,72,0,50,1,83,31,116,55,193,220,81,59,156,170,110,78,93,185,162,220,191,172,124,40,164,222,220,112,73,89,186,170,216,194,136,208,35,234,188,26,155,20,189,1,127,66,179,236,99,64,105,59,90,160,203,39,8,31,224,29,82,71,131,87,107,170,193,100,245,137,163,10,252,206,194,255,33,10,112,139,47,96,56,120,81,109,238,86,106,47,139,70,78,140,216,192,115,245,9,186,151,176,75,204,168,86,193,2,80,149,64,127,27,65,19,86,223,203,175,181,96,91,121,234,
16,21,64,168,247,8,134,80,143,47,238,147,42,82,239,40,34,192,104,173,16,177,208,57,216,232,112,195,150,219,65,186,109,217,8,46,83,21,34,250,10,156,137,52,164,59,72,160,145,100,171,28,190,17,187,243,152,123,93,161,218,183,12,247,91,212,176,98,68,197,168,76,102,224,147,71,203,134,186,66,8,213,1,112,37,164,140,64,178,212,80,117,180,138,152,112,71,81,239,81,47,172,16,149,143,171,176,69,229,86,29,155,163,218,219,172,102,219,20,216,34,120,133,253,65,70,48,56,200,26,230,69,90,235,209,91,134,178,74,93,111,209,200,154,97,95,163,174,59,198,236,29,170,127,219,240,188,77,117,171,134,123,149,26,86,141,249,219,70,213,42,93,185,77,23,87,161,47,184,19,124,9,190,199,153,63,50,52,232,66,118,67,162,29,151,183,154,144,123,203,129,64,63,6,74,31,223,106,0,219,213,232,166,26,16,14,0,229,190,211,44,243,116,17,8,238,198,109,240,181,200,10,70,27,213,71,171,84,127,210,118,139,157,181,87,142,148,68,47,254,236,246,40,252,31,221,150,8,123,46,176,108,31,83,209,96,58,9,183,87,191,93,93,43,213,169,162,181,80,
2,4,14,93,194,236,217,207,164,147,137,88,10,101,126,50,173,166,188,104,237,14,106,105,184,99,140,221,161,158,85,99,65,132,232,15,221,2,4,190,176,219,168,200,0,29,2,72,239,170,113,249,4,25,7,44,10,233,6,76,99,122,64,248,44,0,135,38,84,216,253,229,107,8,176,194,62,65,180,110,14,116,61,240,95,24,33,156,140,168,13,157,216,151,35,92,95,255,182,95,133,250,97,95,90,107,61,42,17,22,233,135,184,6,110,58,213,137,17,48,90,7,72,88,26,105,63,18,213,158,120,2,34,138,67,173,171,53,160,212,140,134,206,139,110,99,168,30,74,20,237,67,29,233,78,117,251,146,136,35,96,200,62,86,191,58,14,12,68,39,14,34,194,151,31,122,132,102,225,27,24,124,130,104,211,170,209,191,74,131,119,140,153,59,226,125,29,126,13,158,5,123,136,51,0,71,67,16,222,96,201,8,68,104,32,252,14,14,5,39,6,183,31,118,168,8,101,183,234,46,8,50,39,240,22,41,120,124,248,114,164,166,115,70,80,129,68,189,62,21,2,222,28,132,251,212,1,25,229,176,6,248,70,171,7,121,124,19,48,219,87,141,192,42,217,86,140,192,9,152,242,246,192,5,231,17,18,81,53,
34,4,250,75,88,34,156,90,196,145,101,67,89,161,232,9,156,9,129,245,51,85,152,47,154,13,113,194,75,17,77,33,22,24,49,80,97,199,8,18,69,17,8,71,0,239,104,193,194,148,32,6,194,104,25,194,39,34,0,228,169,138,192,137,170,62,131,13,205,44,27,61,203,34,109,234,92,166,43,197,119,46,233,93,166,145,101,163,123,153,198,151,141,129,37,145,127,245,35,98,44,33,20,98,176,106,224,124,166,45,108,204,98,62,32,38,58,200,151,93,24,51,78,198,168,176,180,130,12,12,86,190,189,84,189,186,90,139,225,248,123,9,197,190,45,186,29,239,199,170,152,80,120,34,6,229,241,103,54,239,231,42,6,229,72,58,187,225,219,67,43,198,229,21,26,151,207,225,21,227,210,10,225,137,18,60,251,87,168,249,228,199,249,250,149,31,215,245,126,105,59,90,49,170,78,62,250,162,25,99,120,4,134,245,79,65,169,10,248,117,39,157,251,117,232,221,92,187,232,42,107,36,144,254,168,187,53,167,226,91,211,9,58,219,201,143,26,80,106,59,249,44,211,22,127,168,204,63,0,33,4,181,7,41,21,19,28,152,245,216,223,66,111,43,146,99,112,11,56,58,185,246,142,232,
26,209,15,167,215,235,1,106,59,129,147,38,196,196,205,133,103,183,235,34,43,109,240,195,237,165,122,244,143,95,196,234,225,176,79,22,192,5,200,99,22,0,147,77,114,246,224,2,199,166,75,144,217,50,178,13,26,88,49,38,86,232,226,178,81,104,92,166,171,43,6,166,124,235,150,141,169,101,209,193,136,236,51,142,144,181,25,174,129,47,33,234,74,83,67,66,166,194,194,161,112,196,206,113,21,86,226,192,19,157,236,82,67,221,110,163,26,107,18,221,42,219,2,32,225,8,48,7,248,2,112,225,241,176,87,181,95,133,17,194,29,68,191,36,60,83,197,48,66,246,151,183,241,222,225,190,36,29,239,6,98,112,143,232,213,225,137,32,70,212,42,82,179,184,225,71,2,127,34,186,137,8,98,21,204,17,94,129,190,7,243,6,72,193,145,43,17,146,114,164,233,113,178,45,139,76,189,49,106,208,18,82,94,3,147,154,88,208,28,9,81,75,68,80,193,0,0,251,135,49,219,55,134,9,29,208,141,26,243,1,3,185,85,99,148,134,3,116,65,51,40,98,204,251,196,128,161,9,123,172,125,212,13,154,186,52,43,175,72,212,176,125,105,208,99,204,187,13,204,202,6,93,6,246,
88,7,92,216,138,99,248,220,56,69,97,204,123,13,204,150,99,116,129,73,108,236,159,170,13,26,46,76,81,69,140,139,39,48,183,124,190,27,204,54,157,236,111,85,161,65,34,86,94,65,150,215,134,92,29,167,162,195,134,88,240,211,140,187,39,152,43,131,206,49,76,152,124,142,17,144,29,131,131,203,91,34,202,98,208,141,185,20,216,5,198,71,249,252,48,156,111,254,129,242,246,102,253,59,239,219,90,190,64,201,136,40,223,174,195,48,42,159,191,130,81,5,40,192,96,100,94,85,131,252,63,22,53,48,169,122,73,182,175,32,166,167,223,69,33,230,111,39,208,95,118,35,91,65,179,7,80,138,195,206,10,62,212,226,244,45,4,8,54,81,86,184,14,62,109,81,106,7,232,8,58,208,139,40,187,14,37,21,90,37,174,116,183,17,1,247,12,217,33,242,113,172,77,146,3,73,161,137,174,139,156,17,7,181,81,58,12,108,148,138,165,201,91,32,0,121,22,122,150,12,138,25,98,37,50,43,176,151,232,185,84,37,173,26,215,87,197,254,32,155,212,61,148,171,194,251,209,239,47,19,150,34,107,165,82,160,77,7,178,94,57,197,15,107,5,12,176,198,1,176,138,222,155,26,
138,136,227,152,63,198,118,32,204,18,23,177,198,48,134,66,9,22,34,139,88,232,176,177,223,172,110,21,140,10,35,1,169,81,24,21,12,110,25,135,202,5,203,40,52,233,32,192,20,177,102,86,137,150,49,170,5,125,19,11,28,214,193,129,100,40,98,44,59,167,222,88,178,41,97,137,241,93,185,34,112,139,236,191,13,189,103,177,34,136,229,26,6,80,24,244,97,93,180,136,117,121,153,108,82,32,189,16,44,100,182,98,56,87,16,234,132,196,170,80,187,44,20,89,120,72,114,27,51,170,192,252,18,14,242,136,249,216,234,24,169,69,44,63,54,54,34,124,20,81,0,115,37,70,29,69,44,8,138,150,104,74,170,177,174,136,130,149,210,57,0,200,159,112,37,116,0,182,24,181,198,168,241,4,93,42,122,222,112,59,33,17,87,78,122,90,170,49,147,107,59,65,28,56,2,135,39,253,141,36,122,163,117,163,247,4,185,118,107,167,138,12,17,61,42,250,103,116,206,24,93,33,227,10,92,183,113,47,224,10,138,46,64,14,205,10,143,143,214,201,179,68,141,171,116,95,58,49,218,138,17,45,60,85,180,91,214,143,165,134,43,75,98,175,28,156,219,6,214,228,87,15,6,182,24,101,
98,229,160,136,53,43,151,46,176,169,172,186,136,126,21,91,27,176,132,161,81,107,17,203,171,137,18,165,136,130,197,40,84,13,34,162,149,69,44,59,96,36,41,36,240,92,151,219,172,26,144,166,54,102,129,2,226,22,172,171,81,177,212,128,67,22,205,69,44,87,17,171,186,132,181,68,53,43,162,186,18,135,147,160,131,157,4,75,229,118,93,199,66,48,134,228,69,20,44,198,160,31,194,42,12,94,134,22,76,187,67,188,110,88,16,163,12,50,75,200,9,243,1,157,5,44,155,74,158,23,196,0,4,235,120,117,11,84,91,196,114,2,5,102,14,203,42,34,226,128,88,93,17,30,232,240,191,43,8,6,216,27,2,58,37,44,248,220,50,169,40,41,98,13,105,232,51,168,126,1,240,194,48,105,205,56,216,88,161,214,53,177,136,180,47,163,46,28,202,11,95,198,170,10,140,220,44,161,153,48,53,161,50,179,68,28,120,153,194,138,26,206,165,225,14,134,34,22,166,59,176,22,131,245,31,225,29,178,240,170,112,91,106,46,33,98,182,1,40,65,121,20,174,136,229,71,69,194,125,202,117,97,230,1,221,68,35,34,127,17,209,141,197,98,20,2,178,136,117,29,116,100,132,41,213,101,
7,135,146,20,34,57,243,9,44,112,40,98,78,17,11,117,149,224,81,5,34,198,68,152,90,139,240,104,20,132,128,118,169,17,177,82,88,93,196,26,0,123,232,185,150,197,204,128,176,236,101,49,63,6,159,69,148,195,44,149,8,29,81,3,60,99,135,107,117,64,86,141,121,135,40,141,4,48,143,35,182,92,212,22,177,48,211,98,134,181,168,1,51,2,58,176,154,138,40,136,114,192,26,12,136,112,135,105,47,225,245,178,46,183,92,235,67,71,41,68,36,11,209,251,0,6,20,218,37,0,2,233,193,173,101,106,94,37,140,98,63,131,158,37,223,30,136,15,30,134,70,162,121,178,208,137,230,193,57,176,86,239,51,72,22,218,161,9,152,185,15,215,104,152,88,51,104,39,236,23,113,176,136,5,155,66,227,177,48,218,90,196,114,4,1,47,214,158,107,138,88,184,174,3,214,7,48,211,30,35,6,99,97,71,76,99,17,107,70,86,141,37,127,181,136,229,150,86,111,197,66,237,88,194,133,9,87,23,177,176,135,8,166,141,93,179,165,186,252,48,50,201,146,173,200,225,56,58,106,108,67,133,178,139,88,65,185,120,94,143,67,24,144,151,12,133,206,24,212,128,85,183,98,192,93,162,105,
217,209,97,97,186,102,206,32,89,238,18,239,132,222,175,20,112,177,212,14,53,215,22,177,16,30,174,97,103,42,66,87,17,5,179,77,67,216,31,130,141,45,152,240,41,214,229,130,29,8,48,179,46,68,163,193,152,0,64,93,42,166,163,196,132,5,114,45,164,255,75,13,36,122,94,4,202,85,163,11,17,89,228,226,24,50,96,8,133,84,11,235,44,251,136,212,173,171,4,46,190,44,246,44,231,253,236,121,63,91,236,92,206,251,217,243,126,246,188,159,61,239,103,35,216,85,113,222,207,138,201,165,223,187,159,221,21,179,121,88,22,26,112,216,142,176,107,8,91,151,176,123,10,107,106,152,182,172,237,105,193,164,97,23,186,109,116,222,152,25,137,77,138,9,49,210,94,140,253,213,169,253,217,125,24,129,35,89,68,70,84,222,150,141,35,70,191,177,93,184,249,224,241,179,189,253,210,222,236,95,126,70,226,223,16,81,45,110,180,152,161,45,228,210,31,145,184,209,226,216,137,51,213,216,8,154,186,240,75,45,127,255,24,105,36,246,82,123,55,20,39,245,121,169,47,152,152,247,38,113,246,28,187,237,186,194,91,34,51,215,115,24,132,174,96,211,148,
119,101,56,78,216,115,87,8,134,183,194,97,154,211,210,88,33,108,249,37,54,107,28,99,207,158,3,187,209,214,40,182,136,211,76,228,74,210,82,162,3,228,221,199,216,99,133,161,39,70,82,24,92,226,214,12,23,82,174,117,108,8,67,14,215,225,221,156,215,215,175,121,49,130,76,32,49,194,88,179,121,41,233,93,34,61,182,129,21,217,177,24,152,162,131,73,144,47,216,142,167,54,200,195,123,102,183,196,177,159,232,214,4,136,95,57,198,92,78,128,90,177,21,76,12,139,92,216,101,219,17,165,171,129,109,36,67,181,30,156,69,221,190,142,244,46,186,37,246,128,197,51,24,118,212,120,214,167,176,33,60,154,208,163,228,245,44,204,121,104,126,138,170,181,13,108,184,29,208,104,27,85,61,61,246,64,56,98,139,44,45,64,68,25,84,159,215,33,34,140,151,144,42,170,126,29,163,38,79,120,117,94,91,199,121,43,108,82,70,134,139,157,127,13,30,186,186,176,208,35,54,66,110,93,89,192,14,180,196,126,156,62,244,80,161,25,36,159,31,251,176,191,44,29,0,165,27,199,193,196,5,156,242,15,167,130,98,220,144,24,141,208,165,104,110,62,156,193,
192,179,61,72,216,71,142,187,195,148,200,154,40,199,94,205,120,90,5,126,28,115,49,199,225,77,172,220,189,21,79,205,71,215,49,180,112,99,5,61,178,101,199,199,145,99,56,40,70,19,56,8,134,67,92,122,226,121,32,209,142,138,90,142,177,146,168,47,66,111,173,203,235,216,120,58,130,77,248,209,4,210,124,96,214,234,201,91,144,182,158,196,5,33,207,3,107,152,166,9,232,155,147,152,127,138,110,143,68,169,7,219,145,245,181,1,236,247,9,167,112,157,73,45,182,232,163,26,199,241,196,6,97,144,168,101,158,123,214,108,168,160,243,88,92,137,183,142,241,112,87,36,11,89,95,247,36,219,157,132,101,238,118,109,203,7,65,57,23,231,177,159,206,73,215,227,52,227,12,188,227,196,221,98,201,57,92,214,230,161,166,9,186,13,138,43,199,56,10,40,182,131,202,61,228,184,83,13,68,91,143,231,104,28,22,133,25,153,185,197,166,16,20,184,57,39,78,119,173,119,97,163,115,44,53,63,183,222,131,205,159,216,146,28,195,121,106,106,95,74,20,220,75,212,59,39,247,192,182,130,102,161,234,220,180,207,77,251,220,180,207,163,54,130,201,121,
212,62,143,218,231,9,201,121,66,242,255,57,33,153,196,193,123,156,5,73,225,196,204,0,230,126,229,69,79,213,147,84,141,8,117,231,24,7,48,130,33,28,232,233,149,57,56,146,184,161,201,205,254,73,28,47,196,117,71,226,22,39,228,132,152,172,197,105,29,59,206,208,227,128,77,56,211,133,83,56,242,180,221,240,228,102,207,36,150,46,61,20,14,144,239,58,206,233,225,48,144,226,163,171,124,83,148,111,189,75,76,197,138,25,244,173,240,0,5,29,228,155,193,225,38,252,20,151,4,76,174,93,158,164,97,156,16,19,135,170,210,109,88,11,144,144,35,40,193,241,48,223,2,112,113,232,9,192,239,225,112,37,206,27,249,66,221,192,149,37,151,144,103,53,28,7,182,201,157,186,134,54,76,29,187,197,153,182,193,240,20,233,179,151,228,117,13,3,238,25,242,206,225,2,186,22,55,213,97,159,108,0,107,154,184,156,41,131,75,101,49,239,61,38,46,169,218,32,119,162,155,207,62,225,212,201,101,212,169,39,123,49,233,140,251,6,188,215,201,237,167,128,38,78,221,185,197,145,152,148,216,99,187,221,45,191,142,121,177,157,102,141,220,242,152,
30,240,221,152,97,95,6,46,86,248,65,218,174,227,196,216,102,179,152,7,167,117,176,217,122,28,242,144,56,60,132,109,155,27,24,158,12,131,223,6,164,152,88,217,169,146,35,145,58,72,37,52,76,115,14,242,206,182,200,115,68,224,119,200,177,134,99,37,157,14,170,113,209,48,142,5,138,131,70,219,23,145,134,202,211,72,163,56,0,40,14,45,165,249,88,19,22,196,70,92,200,70,55,59,176,246,235,192,49,194,25,10,225,170,12,173,97,142,144,191,2,101,76,30,24,4,145,78,164,169,178,222,109,199,108,131,131,220,197,35,76,56,231,4,34,128,180,207,205,11,177,133,22,112,125,9,32,9,37,152,51,118,172,227,148,140,130,225,18,238,46,17,71,156,182,48,252,194,81,68,0,44,162,133,93,199,238,85,114,130,163,228,0,218,118,3,186,168,199,173,132,94,106,195,182,165,112,178,7,227,2,28,33,1,187,206,141,94,156,157,66,18,142,185,235,240,66,51,12,37,72,147,184,103,35,184,213,45,97,70,5,76,226,18,148,229,132,42,113,217,225,60,142,239,97,95,236,184,48,38,84,188,77,206,212,69,57,8,170,151,48,93,208,88,80,71,9,108,113,60,56,139,251,
17,219,165,5,59,194,105,113,157,5,142,87,58,183,65,25,95,209,140,42,39,109,9,250,48,104,28,252,220,104,147,28,138,53,8,12,151,192,131,19,183,134,0,43,9,10,98,144,37,249,188,136,182,45,31,159,187,206,255,71,215,209,86,41,146,32,207,182,56,134,233,219,236,129,121,169,24,106,138,49,48,148,138,72,128,193,109,171,128,217,36,28,184,198,108,130,79,28,62,172,150,11,60,152,78,0,196,21,205,69,145,133,86,140,143,35,116,213,151,36,15,148,188,117,9,159,60,226,235,104,4,199,83,87,112,6,11,75,50,227,62,29,87,187,193,52,154,229,201,68,216,236,53,243,132,97,10,39,12,1,143,42,199,53,92,182,189,66,30,31,249,188,20,212,154,228,241,68,80,174,214,196,236,197,67,65,77,220,15,39,2,26,78,56,74,44,177,170,134,56,166,209,251,56,218,233,193,233,196,77,14,158,216,151,49,164,233,20,217,192,149,226,64,127,15,182,102,59,198,1,67,196,22,28,99,12,109,142,161,173,213,199,224,210,75,227,242,68,221,181,80,24,243,17,152,238,232,148,107,56,40,31,22,151,232,109,226,62,161,9,172,114,195,194,113,166,206,145,68,144,233,
114,137,27,172,198,196,113,99,33,187,46,56,54,124,213,67,91,224,76,28,211,19,103,47,197,122,78,136,198,225,17,98,244,187,77,168,190,95,248,174,116,121,184,246,165,16,142,73,174,226,166,209,110,89,57,200,15,187,112,61,86,166,19,119,111,58,168,31,135,130,69,80,74,216,101,220,80,189,212,226,74,147,35,123,209,69,53,14,26,17,199,152,113,95,74,82,92,129,4,79,13,81,23,200,199,207,71,197,231,163,226,243,81,241,249,168,24,129,237,124,84,252,231,51,42,182,228,63,221,80,93,237,177,101,252,240,246,159,254,208,1,61,15,29,191,54,126,104,67,75,218,121,252,144,248,211,28,58,248,193,184,93,203,43,167,70,15,56,56,255,195,24,56,184,208,190,81,49,18,42,142,29,182,126,40,195,6,172,9,9,205,181,190,105,228,240,167,239,52,183,208,130,142,178,211,192,87,224,66,230,200,123,84,14,186,255,68,157,102,16,140,123,181,124,243,113,229,184,161,255,7,57,100,184,139,198,54,31,123,229,173,143,184,71,200,145,126,133,224,128,201,4,140,12,196,85,255,53,231,235,171,231,235,171,63,196,245,213,39,90,190,173,52,150,252,
248,247,217,55,128,169,67,120,144,70,151,17,225,198,206,220,60,16,253,61,247,13,24,168,1,23,128,54,191,190,115,224,173,63,232,166,129,66,3,42,154,192,223,12,59,181,113,224,19,158,206,250,29,246,12,136,254,57,136,131,191,188,109,224,249,63,115,199,192,243,179,118,10,44,34,12,131,106,29,54,50,136,73,102,8,93,61,46,110,23,24,254,67,236,20,192,230,6,170,2,117,108,23,192,174,4,88,137,101,187,64,207,239,177,83,64,68,90,183,150,239,56,181,89,0,187,2,126,235,62,1,236,82,160,225,227,210,102,1,204,207,120,119,196,190,20,121,101,84,159,11,39,150,196,212,77,191,99,131,92,219,152,129,236,193,198,20,135,152,135,29,246,126,74,174,125,114,236,140,3,6,55,85,57,112,235,243,121,64,63,15,232,63,196,128,142,13,51,216,133,195,151,129,226,42,231,96,122,6,206,59,138,189,67,88,137,193,65,10,252,137,35,120,64,151,30,160,160,151,194,97,220,28,137,114,44,29,244,121,23,177,164,208,9,231,112,226,110,158,57,10,207,83,240,58,174,110,196,54,116,76,234,59,196,130,141,32,134,229,32,113,26,3,119,17,224,82,60,231,
70,55,174,99,20,203,11,14,210,93,20,156,105,144,139,69,0,184,38,238,180,19,87,122,99,9,2,51,201,192,18,83,170,152,185,69,117,78,42,116,96,237,76,82,196,134,43,38,23,22,213,175,95,198,66,72,112,81,220,163,167,175,227,18,241,46,249,21,56,35,98,205,66,92,47,9,134,176,132,129,146,36,34,129,122,44,86,79,48,47,187,37,166,119,71,143,145,169,201,241,92,97,100,78,19,247,90,134,18,67,168,78,108,190,199,9,82,76,205,134,48,95,139,221,83,184,85,18,171,51,13,34,72,172,92,150,127,255,8,127,244,148,230,48,77,188,53,45,167,103,177,111,173,96,155,11,146,190,76,161,149,17,20,201,157,248,107,2,2,140,37,180,57,106,196,126,189,16,174,93,195,238,56,36,140,233,73,156,225,65,9,22,122,192,85,131,232,52,166,112,235,35,190,96,119,219,134,216,4,117,237,88,94,8,9,94,58,176,55,205,131,211,16,216,160,5,112,29,23,6,96,165,13,51,214,125,83,152,47,223,108,157,18,123,220,198,53,224,225,190,188,13,220,255,136,197,50,28,94,176,227,238,186,64,150,180,172,152,125,198,237,2,26,221,199,180,246,212,58,110,38,197,93,229,
163,226,82,201,77,210,182,0,95,35,191,38,113,95,182,248,155,84,201,65,73,1,51,252,151,48,91,61,181,54,36,225,123,196,253,146,184,28,61,109,71,213,16,143,70,111,225,174,116,81,146,233,197,38,59,73,33,130,150,180,30,99,19,34,120,193,202,165,39,43,22,6,29,199,114,103,28,166,238,59,196,93,230,184,225,113,1,106,153,247,164,177,99,14,151,78,66,147,93,184,187,213,143,221,130,226,38,65,113,162,3,75,3,126,186,136,128,237,199,213,139,169,103,64,247,108,192,216,176,189,14,144,131,2,82,220,48,24,245,139,195,24,104,231,164,39,115,217,67,195,2,30,115,254,169,251,242,4,8,40,220,195,181,141,146,108,63,166,75,80,232,167,21,240,135,174,15,183,168,99,21,22,151,34,166,105,50,19,6,139,3,162,59,148,107,21,189,98,59,36,214,57,214,113,149,186,58,137,101,47,97,229,232,41,235,113,239,250,100,230,18,214,33,39,177,118,134,165,80,92,47,185,142,139,76,113,92,8,235,163,227,88,213,16,139,104,153,62,44,181,194,250,125,212,55,185,78,238,181,110,220,199,62,73,163,190,32,225,98,77,44,120,21,7,112,141,56,108,51,
185,217,138,85,81,252,185,46,177,160,11,244,52,54,13,50,238,16,214,113,177,176,33,205,216,41,108,24,107,192,27,188,0,44,118,247,225,182,65,240,30,206,92,6,53,89,215,125,236,42,148,181,131,2,150,126,1,115,95,160,128,102,10,53,162,4,107,205,125,178,229,110,185,130,23,72,10,203,31,195,26,33,172,2,253,220,53,220,90,15,129,120,211,240,99,44,164,66,149,133,110,55,150,87,249,222,85,233,188,240,8,185,200,90,232,17,94,134,59,226,241,199,133,210,216,161,8,35,7,13,200,106,83,172,220,110,218,229,234,107,151,27,151,92,38,71,96,131,110,92,246,34,224,61,178,188,14,50,12,164,96,62,40,239,194,10,160,158,233,7,58,86,122,193,155,255,24,130,199,194,16,90,6,51,136,164,133,86,226,24,240,162,49,176,252,15,113,191,39,76,55,24,195,238,78,156,79,197,38,75,136,24,10,27,199,218,184,7,24,66,237,20,217,238,142,136,114,88,38,214,164,96,68,239,137,235,61,177,91,116,187,19,171,64,32,5,31,129,80,0,236,193,109,243,88,206,74,119,131,8,242,33,200,81,162,220,199,118,69,172,89,122,54,1,15,226,32,50,6,48,109,99,0,231,
146,112,129,4,174,19,197,118,80,79,2,82,70,45,88,203,25,134,220,61,88,209,207,72,150,19,168,29,75,76,108,70,248,235,105,114,199,103,205,49,47,237,232,169,17,52,200,131,37,103,220,88,143,64,116,9,43,209,8,46,161,229,155,144,172,44,156,193,117,151,88,181,14,37,113,208,71,220,41,136,92,12,75,56,34,80,164,214,228,79,156,217,28,68,114,34,22,146,17,97,32,189,205,126,185,250,43,168,121,179,136,129,195,161,97,44,75,93,65,12,68,32,195,66,106,40,9,96,113,120,83,130,225,239,35,211,220,130,64,148,68,80,8,39,198,215,1,47,110,8,196,242,19,66,107,10,68,16,142,80,14,154,98,217,92,59,239,19,206,251,132,243,62,225,188,79,56,239,19,206,251,132,82,159,112,62,4,62,31,2,255,64,135,192,231,166,125,110,218,63,80,211,22,127,195,3,127,155,13,127,188,44,71,110,28,224,219,121,241,254,47,147,68,91,132,131,128,226,95,131,246,242,18,230,66,196,8,20,67,31,252,241,46,108,206,196,216,161,244,7,95,232,43,113,178,48,142,83,133,177,167,15,247,135,86,31,103,247,30,226,175,102,55,76,188,245,100,63,251,120,231,131,
71,87,213,255,88,62,103,184,70,201,40,109,245,80,67,35,200,255,235,218,127,119,243,201,167,55,233,167,245,214,255,126,86,241,171,242,219,193,255,60,235,99,153,153,170,86,48,211,120,251,217,254,195,226,223,159,249,155,138,186,243,180,149,167,134,52,234,254,95,201,127,27,204,98,252,95,21,220,17,79,253,33,134,156,184,63,190,31,127,40,54,27,251,176,31,23,47,196,30,136,167,254,64,124,144,207,131,108,224,163,126,140,118,249,169,101,251,49,56,196,205,242,81,96,104,79,196,15,109,79,60,227,59,32,82,181,178,135,171,191,14,178,190,79,251,49,240,244,61,17,207,112,174,31,3,227,200,30,86,60,15,178,252,35,188,39,138,36,145,170,229,189,254,229,50,169,29,65,74,223,177,112,229,125,208,143,97,184,247,137,120,134,118,250,49,211,162,103,241,249,179,191,129,170,160,176,6,237,171,191,95,171,84,92,89,46,157,107,144,139,162,127,176,183,167,254,117,89,32,31,9,60,96,227,54,13,113,232,243,47,70,211,175,30,141,210,221,129,245,87,235,3,180,51,156,248,201,133,97,114,79,36,95,61,159,160,197,193,237,87,207,6,
233,150,125,227,213,93,59,61,154,216,250,73,235,4,205,12,108,188,154,28,160,66,231,239,140,232,76,93,114,210,168,51,233,116,82,179,99,99,198,65,77,206,204,56,102,244,90,70,179,83,163,212,226,216,24,113,80,175,51,53,229,164,150,209,196,149,81,234,116,108,23,236,14,42,232,142,212,128,131,6,28,41,236,90,175,114,197,166,93,56,8,154,153,194,177,211,218,233,224,220,52,85,187,98,78,23,254,112,241,230,60,182,105,139,221,145,216,249,152,46,60,4,162,109,56,221,55,76,67,195,25,255,48,110,165,219,180,79,80,215,84,246,26,254,224,192,194,112,214,55,76,234,84,198,61,69,13,195,153,161,97,234,155,72,21,234,39,168,176,61,145,189,60,65,195,19,89,239,4,102,39,19,147,78,28,81,204,141,98,28,127,219,153,118,224,15,16,122,182,197,95,30,114,38,192,119,247,68,174,240,14,80,90,39,211,131,147,212,63,153,14,78,194,101,98,215,49,119,226,203,94,193,223,94,95,114,39,166,220,212,226,75,78,249,168,197,157,196,153,203,222,201,76,225,249,36,121,38,19,254,73,82,236,233,231,83,155,170,29,76,209,176,59,225,192,206,
247,216,212,230,240,20,254,8,194,250,53,55,181,78,37,193,106,171,125,173,208,101,167,1,123,122,206,78,213,238,13,65,208,158,152,176,211,197,137,148,100,116,61,48,65,54,123,98,198,142,131,148,217,9,176,211,52,145,115,78,80,243,104,210,61,74,13,19,201,153,9,106,234,75,95,233,163,78,180,48,131,239,213,142,181,33,7,245,57,54,230,167,231,177,194,49,59,77,117,174,237,73,23,21,162,142,228,180,131,46,76,111,79,77,67,25,155,19,14,186,56,158,158,30,167,229,129,116,161,101,128,62,56,87,223,159,181,250,38,179,133,79,38,233,198,100,106,106,18,38,180,238,178,83,227,96,162,16,24,36,223,96,102,124,144,222,30,76,225,221,54,153,240,77,146,58,152,17,239,246,244,123,118,42,172,218,211,243,195,155,138,157,252,246,205,170,97,42,248,196,91,118,212,78,27,246,237,249,225,116,181,157,188,194,187,210,87,38,224,176,169,194,83,7,206,79,36,230,199,215,177,255,97,124,156,90,6,54,11,145,1,154,26,200,141,12,208,189,129,157,192,0,206,69,108,206,143,111,97,29,109,116,156,46,142,102,10,249,81,154,26,221,29,26,165,
119,70,211,61,163,52,54,186,91,232,29,165,222,241,92,161,115,156,6,237,217,235,118,138,252,49,152,159,216,241,79,144,50,154,116,141,82,227,196,134,112,171,190,172,167,143,10,243,125,185,241,62,122,123,98,119,124,2,207,157,143,39,232,194,104,210,51,74,117,19,201,200,4,93,119,36,11,141,136,53,195,142,140,199,65,117,227,219,129,113,178,13,100,181,1,242,243,115,60,59,239,72,85,143,147,31,171,137,227,105,207,56,213,13,228,222,29,160,129,115,119,250,179,118,167,115,245,253,89,171,239,143,17,80,254,37,70,195,129,157,87,187,3,244,214,121,142,248,131,206,17,29,217,0,118,203,140,103,174,140,163,207,207,77,97,75,76,240,60,30,254,89,199,195,115,245,157,171,239,124,104,125,62,180,62,159,25,57,159,25,249,23,54,177,53,238,204,250,157,24,248,103,95,188,255,215,149,83,170,47,199,254,98,212,50,249,221,146,16,243,170,183,178,15,114,234,175,202,243,170,121,74,62,40,205,171,254,99,238,155,177,188,50,70,251,150,231,139,161,177,188,58,70,62,249,220,147,207,130,211,242,3,31,128,33,160,240,159,223,242,
161,12,85,250,240,98,80,126,255,30,180,190,95,141,86,40,84,82,152,41,242,93,250,112,186,70,19,10,223,185,41,167,185,199,119,110,252,239,70,11,116,79,215,136,162,178,36,152,47,84,82,150,106,69,141,111,228,171,244,225,13,180,64,5,178,175,160,197,63,184,70,60,79,243,133,207,162,141,37,194,101,73,148,80,202,218,46,17,102,5,11,90,40,42,213,8,140,50,95,165,15,167,219,104,66,189,145,86,137,21,65,139,161,152,21,188,151,105,49,20,87,82,194,40,41,19,37,111,104,232,25,213,150,168,67,229,120,63,93,109,5,173,18,63,111,128,58,197,144,213,196,193,28,127,197,243,13,126,194,212,75,52,222,208,4,48,116,186,161,53,99,228,45,10,11,232,167,53,106,54,129,9,151,42,41,67,85,212,104,133,50,197,113,70,141,37,20,110,214,119,210,42,161,127,63,161,9,40,70,41,85,242,6,75,195,119,118,211,211,246,88,81,227,247,163,245,70,168,210,135,114,27,81,84,246,147,18,147,172,148,50,247,12,133,103,89,143,208,211,83,169,39,65,203,202,61,222,203,182,93,250,240,253,107,44,161,156,150,4,127,0,19,101,217,151,140,165,92,35,190,
151,185,47,161,176,245,150,101,127,6,20,96,203,53,226,59,139,165,164,148,18,169,146,193,162,68,84,203,60,156,65,176,68,163,236,34,76,4,207,178,56,240,227,116,181,111,164,133,15,103,52,161,196,104,9,175,172,81,230,161,244,161,44,57,254,128,202,191,253,209,169,80,193,60,150,190,23,30,89,212,203,210,56,45,236,51,218,131,162,51,160,208,208,18,245,211,98,124,35,167,192,56,45,32,38,130,103,89,140,37,116,33,32,171,74,42,160,42,104,149,126,128,149,10,168,82,219,207,104,194,25,214,126,48,97,105,214,105,67,3,225,211,234,7,249,178,30,74,76,148,21,139,34,14,223,76,139,185,179,218,225,119,18,172,96,158,169,51,65,60,203,204,191,17,234,12,230,128,120,186,70,43,93,96,156,214,165,85,254,111,38,88,226,129,219,86,102,142,169,227,115,89,38,92,201,25,77,48,161,152,86,5,84,233,71,217,122,172,108,155,180,126,11,20,62,151,163,96,9,253,12,113,148,185,7,202,217,254,119,6,247,40,18,180,24,165,196,138,160,197,63,126,27,173,18,10,123,86,153,175,210,135,50,173,10,238,153,112,5,20,148,134,128,206,31,76,190,
24,133,161,240,44,75,130,161,240,20,26,226,31,128,61,173,199,55,66,225,67,153,86,5,95,165,31,236,1,167,161,206,168,177,130,86,69,141,86,90,120,63,45,9,147,22,67,225,7,27,49,123,27,155,12,251,95,233,9,200,178,128,241,131,89,60,133,192,228,74,207,50,194,235,53,148,128,74,181,161,228,180,57,48,26,131,226,189,196,12,191,155,8,165,207,204,12,235,129,77,162,68,187,2,161,244,131,65,185,37,108,181,37,52,38,106,214,96,69,192,123,169,209,165,154,173,140,157,54,10,43,2,19,178,62,43,106,96,208,210,211,74,181,244,110,34,148,170,6,51,111,66,96,152,51,106,64,81,169,209,204,76,137,28,139,225,180,30,24,193,10,196,104,165,231,233,88,101,101,233,117,52,148,156,109,26,37,122,165,230,150,74,202,98,101,218,160,241,61,162,206,155,248,96,158,4,31,247,127,85,57,202,46,111,92,170,237,198,0,91,125,123,231,131,167,15,255,207,218,55,246,60,54,29,188,184,95,250,15,59,101,94,36,237,249,239,241,223,119,225,157,249,237,204,194,239,81,81,37,136,73,197,44,60,147,38,10,15,210,178,13,123,246,107,0,244,113,235,134,
78,55,171,18,185,242,23,208,14,162,246,33,252,119,73,162,249,236,55,75,148,252,246,188,205,78,207,100,249,193,149,18,85,147,0,192,132,4,223,244,11,84,241,7,102,169,87,66,248,237,211,120,7,189,210,115,191,68,213,36,96,254,103,82,173,36,254,93,223,206,68,168,44,44,255,218,51,219,40,248,56,152,40,181,168,12,96,177,137,202,74,43,127,85,34,152,223,206,4,65,161,208,17,254,219,47,234,72,32,15,190,161,238,55,145,130,52,39,240,13,210,132,70,2,246,32,104,64,219,165,39,218,37,42,122,83,139,94,163,250,223,242,118,252,249,92,144,115,130,4,20,143,119,86,206,139,178,241,84,34,153,191,4,239,101,183,169,4,49,191,85,22,158,249,11,144,133,156,133,125,110,202,203,183,79,11,165,18,185,178,110,252,130,80,174,1,164,104,98,226,189,100,98,248,204,202,22,134,123,38,29,179,208,164,106,249,5,221,72,74,189,248,228,179,219,229,123,89,66,111,20,178,73,232,77,255,177,138,192,31,0,94,119,38,179,122,11,23,175,185,22,240,190,155,198,155,106,182,40,236,12,26,103,86,249,38,118,10,143,236,110,124,243,219,103,64,201,
103,31,144,79,183,124,134,228,179,44,39,214,132,144,86,153,24,156,30,230,123,240,208,170,103,83,75,15,74,112,160,195,237,52,99,155,201,126,25,14,0,175,149,157,85,71,69,25,126,152,126,88,152,49,3,211,12,202,96,59,32,87,112,218,111,200,31,115,248,81,116,7,51,162,162,4,230,41,216,190,90,98,17,176,111,104,138,89,77,5,139,103,149,1,224,0,77,174,128,171,44,227,58,76,92,252,87,217,119,129,99,118,221,97,124,42,53,66,232,166,215,174,129,16,26,33,3,133,104,99,201,39,240,94,238,30,135,142,209,61,214,47,46,14,69,30,61,222,123,152,166,111,28,121,220,49,252,204,145,199,94,186,61,203,243,224,129,35,143,43,130,95,220,47,253,7,128,23,73,9,241,198,255,42,17,190,235,151,73,204,4,169,36,125,102,225,153,8,149,144,149,245,157,73,19,32,126,135,87,62,69,131,205,70,22,30,201,70,238,59,124,248,178,47,155,232,115,132,241,221,103,190,207,50,134,252,234,41,193,236,57,174,91,222,157,252,142,167,223,177,96,193,213,100,137,144,229,190,227,70,9,102,223,17,1,12,4,46,75,204,119,137,53,205,184,18,75,192,251,77,
165,184,44,184,215,44,184,206,210,187,223,225,103,92,249,20,109,1,174,196,210,74,48,251,142,89,203,251,60,191,75,120,65,179,216,94,243,93,226,6,74,48,123,21,60,79,114,185,172,197,148,168,124,15,201,39,155,211,180,164,192,60,4,75,240,251,142,80,137,166,79,190,23,235,21,114,192,187,196,186,102,193,245,150,224,247,28,126,46,151,144,190,18,188,223,225,230,119,9,25,182,224,206,88,222,173,245,10,58,44,31,191,67,232,174,40,43,221,2,111,149,149,75,82,22,237,242,57,110,150,234,242,57,102,248,93,98,77,90,112,173,50,191,97,193,181,202,217,90,239,156,5,215,180,67,89,34,236,129,29,179,84,151,172,209,228,65,194,8,91,45,58,175,73,71,150,8,251,129,61,227,233,119,8,57,176,45,249,28,166,141,73,24,83,38,18,210,172,75,190,155,250,149,117,153,178,149,20,34,76,71,194,152,50,145,239,86,59,177,218,164,208,69,81,206,243,165,247,125,199,77,137,197,186,54,237,68,242,99,190,35,40,5,28,166,205,72,30,24,210,172,69,226,150,53,229,119,8,105,251,164,109,248,29,65,174,69,150,204,201,167,208,163,207,225,146,52,
89,26,12,47,248,172,212,102,64,226,242,87,193,73,145,243,41,249,206,62,101,182,66,226,234,242,41,100,232,115,184,45,245,50,174,176,7,191,131,113,217,114,68,196,240,203,184,81,169,17,230,83,180,200,239,16,214,194,94,224,119,176,244,132,159,250,138,81,69,194,112,116,98,95,171,168,87,66,122,228,83,120,77,209,179,216,234,216,86,77,120,73,135,189,96,65,190,115,237,204,167,136,114,197,56,86,182,52,191,131,97,88,194,66,131,69,139,226,26,133,237,85,202,159,37,204,244,205,40,42,185,18,122,132,196,228,147,181,99,181,82,142,99,44,43,46,103,30,24,82,88,102,81,62,44,1,246,35,174,157,249,231,200,16,150,26,191,206,122,151,88,215,229,147,245,91,238,7,96,27,146,115,150,140,181,94,214,53,235,157,219,200,244,89,35,236,71,220,70,209,141,6,28,220,70,214,166,136,96,69,251,97,158,249,89,142,204,126,135,240,32,244,53,18,210,236,53,228,59,243,207,150,195,186,96,57,48,159,108,87,229,30,106,79,70,161,98,148,40,247,56,126,135,41,43,212,178,231,176,70,39,193,97,49,98,152,222,42,57,97,206,173,54,32,234,221,
151,61,11,224,229,187,53,26,151,123,177,82,4,150,252,151,121,216,119,88,35,210,20,215,43,233,136,72,82,236,109,203,209,219,87,193,179,217,11,72,172,114,36,220,115,8,93,48,63,136,222,146,115,230,185,28,229,246,100,121,177,141,66,182,165,119,75,189,102,15,34,41,148,123,109,43,125,68,170,82,93,251,69,57,203,54,154,246,38,223,203,61,224,190,244,119,110,215,94,69,143,47,108,143,121,240,89,114,16,95,49,94,73,174,204,222,77,190,91,123,46,107,175,103,70,96,201,51,91,130,104,123,137,103,249,126,131,235,146,116,76,153,75,120,83,62,146,103,211,127,37,140,41,79,137,101,141,204,34,190,21,229,108,245,151,178,143,236,59,172,49,89,216,127,169,237,140,203,62,40,107,52,125,185,244,190,47,229,192,61,212,190,67,68,137,34,174,240,68,46,63,21,39,25,87,82,46,203,100,207,33,244,88,212,175,136,78,69,92,43,207,102,60,151,144,194,175,139,245,154,178,146,229,101,91,245,57,216,199,217,174,172,25,145,153,1,162,93,207,100,230,80,228,217,196,149,28,138,8,86,148,27,107,71,196,94,46,217,183,88,166,207,193,148,
57,34,89,35,48,71,60,238,89,38,57,130,73,202,236,209,28,49,172,145,129,35,42,199,28,209,111,22,35,36,107,153,109,213,26,177,185,231,18,182,225,115,112,84,228,150,50,46,219,24,211,228,114,150,36,71,72,107,15,203,184,220,215,112,116,98,45,51,46,199,19,83,146,146,127,214,2,199,82,107,94,193,125,4,199,243,114,100,43,122,7,251,41,75,137,249,225,119,150,146,25,181,88,242,242,233,177,90,157,108,35,67,114,171,205,118,177,60,229,147,219,197,210,102,254,185,15,226,120,206,81,250,117,57,48,22,151,179,108,89,47,92,11,211,97,89,113,123,173,158,203,17,146,165,109,149,39,219,0,75,210,244,50,214,145,228,147,229,108,218,137,44,97,143,230,158,209,26,205,216,18,152,19,31,254,140,131,215,204,3,25,151,33,43,122,28,73,141,107,20,88,7,87,36,130,24,0,226,215,235,67,62,128,191,62,56,52,11,77,132,74,144,239,241,13,32,126,71,185,219,60,72,203,186,11,57,147,117,54,11,238,146,173,105,180,153,70,72,108,51,29,151,34,99,83,99,227,51,59,36,89,110,42,67,190,91,147,51,118,45,118,42,179,147,150,48,55,228,147,141,
128,19,38,83,181,82,172,108,184,12,195,166,192,106,102,211,41,119,42,62,51,17,100,87,100,30,24,222,41,233,176,232,173,46,196,37,108,100,214,161,29,151,48,253,178,180,138,201,4,243,99,186,138,148,9,243,195,53,154,38,34,203,217,220,89,158,28,8,152,31,134,97,250,214,16,195,46,196,37,86,185,49,29,230,182,28,40,145,16,200,90,152,19,51,17,145,37,92,35,83,99,110,185,94,110,35,107,144,19,113,150,51,183,145,13,253,245,68,129,67,134,53,228,49,77,214,187,149,206,13,89,59,83,179,154,254,13,169,95,182,22,43,60,211,225,167,53,4,48,29,166,96,237,80,153,127,254,106,13,49,44,49,150,128,208,47,119,24,230,228,67,49,131,230,177,47,55,190,34,115,151,76,115,57,71,23,22,150,25,119,229,87,51,94,90,154,199,20,22,184,223,144,205,99,179,99,245,88,141,128,33,185,217,175,103,166,172,66,167,165,255,97,177,50,39,76,147,249,97,35,99,53,152,244,101,189,172,30,83,148,178,132,149,202,102,193,226,179,198,75,22,28,155,35,99,49,60,199,72,86,191,169,12,217,94,230,135,71,0,204,173,201,143,172,203,228,74,66,50,29,230,
141,41,152,70,35,33,57,64,240,215,32,199,75,89,110,186,141,164,80,158,159,40,58,27,215,110,117,78,174,145,91,199,109,103,126,152,50,75,219,116,54,73,147,251,46,214,11,83,51,219,43,107,103,248,160,69,143,236,150,44,37,171,241,113,189,229,248,93,28,249,177,229,176,132,173,118,194,253,0,75,204,26,76,89,50,92,47,215,197,252,48,207,172,133,242,252,129,79,102,127,197,17,140,201,191,228,156,223,111,200,247,105,139,253,4,228,59,135,0,205,210,46,110,11,59,21,215,206,114,227,236,222,28,129,89,244,200,60,176,51,155,114,150,95,25,158,157,217,156,95,145,60,112,184,225,214,49,87,220,46,182,97,150,167,105,87,204,179,164,230,150,28,90,243,38,166,195,220,178,204,153,14,227,114,171,185,118,46,231,224,200,22,98,245,95,206,167,184,59,49,131,184,172,151,225,89,14,214,32,206,242,103,57,152,89,191,228,144,219,114,67,190,71,44,242,228,112,195,88,214,81,157,181,165,102,112,151,245,114,6,193,53,90,219,197,20,216,114,172,65,211,106,39,86,121,178,252,77,253,74,202,44,7,182,28,230,223,218,25,251,165,175,
177,196,204,56,32,177,216,38,217,74,173,126,193,60,48,164,41,55,217,118,182,7,134,180,210,97,201,51,125,107,158,200,29,24,91,32,183,145,237,141,97,94,31,121,179,141,177,246,77,126,36,159,44,79,150,143,213,78,216,119,248,105,237,252,184,69,44,13,51,158,72,58,28,217,184,118,43,29,142,129,166,183,178,126,101,123,185,237,92,187,25,111,101,57,247,11,28,217,204,78,90,150,51,5,166,108,182,87,150,179,30,57,110,88,253,197,228,68,214,104,237,236,153,50,243,111,198,31,201,63,107,150,181,99,218,185,164,207,118,197,124,90,227,9,219,57,151,88,227,170,41,25,137,203,48,108,63,166,101,202,186,172,113,149,99,5,71,105,51,190,73,24,214,59,91,154,213,143,216,54,248,171,85,143,220,94,174,209,180,31,201,3,247,140,214,222,153,237,196,218,95,188,222,15,178,84,173,118,197,114,96,57,155,240,146,62,71,0,246,32,171,94,24,134,163,55,123,55,215,203,254,101,106,65,182,148,203,89,179,252,213,26,103,88,71,86,111,98,120,150,60,183,212,76,122,36,53,246,35,214,163,53,206,51,15,236,71,172,77,214,139,85,110,214,184,
196,61,11,107,202,234,191,220,70,198,50,227,128,148,3,235,145,41,176,151,49,159,28,139,88,95,214,248,195,18,96,239,176,218,27,219,15,91,130,105,159,210,134,67,50,206,112,137,201,191,108,239,13,249,100,185,113,45,92,47,243,204,95,185,46,46,103,125,177,196,88,155,44,7,134,100,41,241,59,195,115,139,216,43,185,213,12,207,28,114,100,48,147,90,41,7,246,101,246,56,171,60,217,191,152,130,53,62,48,111,172,71,147,79,73,135,75,24,222,90,206,253,14,151,91,7,27,108,111,44,97,171,95,176,239,84,204,176,74,250,204,33,219,39,243,198,237,226,119,150,12,127,229,114,230,129,57,55,249,145,146,103,121,178,53,154,253,166,44,103,123,224,126,196,202,63,247,89,108,21,214,56,192,150,192,88,214,188,209,148,131,228,153,235,226,153,90,142,24,44,7,107,254,195,156,191,110,183,12,201,229,102,28,147,124,178,142,152,79,171,220,172,20,172,124,178,173,178,148,76,61,178,190,228,147,181,111,245,47,166,201,218,49,229,35,33,217,206,25,222,140,111,146,31,174,203,148,191,132,100,249,223,148,246,207,30,103,202,71,194,179,
124,216,242,173,250,98,155,228,26,189,156,15,75,106,44,127,166,99,230,219,178,156,125,150,229,111,237,143,184,132,159,175,219,45,75,222,170,95,107,15,107,198,7,233,191,108,153,28,159,173,253,38,123,22,71,21,51,94,73,126,24,134,219,101,246,35,86,125,201,119,171,61,176,47,112,47,105,245,95,150,15,247,182,166,126,37,125,150,21,75,155,177,216,223,77,62,37,140,213,206,153,79,211,186,100,237,12,207,52,217,42,204,121,62,249,149,237,141,249,103,30,24,158,117,205,90,96,171,227,114,110,11,199,49,211,158,37,15,204,33,107,196,218,63,50,46,123,129,53,14,240,59,183,215,42,79,238,191,184,165,172,77,182,43,46,97,127,52,203,37,255,76,159,165,97,230,21,146,31,230,141,233,139,242,242,214,4,90,197,214,132,90,108,77,120,235,201,195,157,127,88,248,102,58,175,78,147,79,62,255,193,38,255,43,252,242,11,249,255,175,185,148,159,223,114,217,158,252,114,240,31,30,76,231,149,105,11,213,170,172,216,15,24,121,250,193,222,71,133,191,127,255,27,87,94,113,209,207,126,228,202,171,46,250,219,47,228,175,111,241,203,
44,196,127,127,203,223,190,229,111,2,178,140,240,51,20,2,239,245,255,0,242,213,138,132,220,151,16,123,242,189,92,132,239,248,112,6,148,13,136,183,139,40,32,125,26,145,139,240,252,234,86,145,60,211,50,139,74,223,255,213,236,153,244,43,170,172,224,130,49,185,200,228,162,68,185,204,69,137,62,138,204,42,75,84,184,169,63,101,65,89,212,248,239,133,192,23,135,238,62,254,228,229,55,61,191,106,200,211,55,51,249,170,95,53,104,202,55,51,152,71,60,85,240,173,237,84,65,225,175,247,204,18,101,134,252,51,121,126,22,241,255,211,230,105,240,156,165,192,134,26,254,115,211,169,130,194,163,83,5,101,86,171,126,46,88,189,45,88,253,199,39,191,106,32,250,102,202,228,116,138,126,13,54,74,5,182,111,166,232,167,138,165,64,17,5,95,252,179,10,4,141,95,239,159,70,65,243,43,107,249,145,165,224,181,90,4,141,255,254,206,41,136,23,131,167,10,42,24,19,40,127,185,88,134,184,41,136,126,237,44,23,104,178,113,191,181,218,194,79,252,167,112,126,117,241,84,65,97,198,44,192,223,132,184,199,146,20,180,239,89,192,68,229,
191,234,176,20,8,128,51,240,4,220,134,5,76,252,46,235,141,254,78,232,109,69,232,237,159,62,146,218,189,42,245,102,251,230,42,253,26,108,194,228,184,64,65,193,79,111,88,10,4,196,79,209,214,74,8,40,178,84,240,26,4,19,189,154,87,5,169,171,121,69,16,224,95,95,200,255,254,71,135,252,239,224,129,181,240,47,27,229,175,175,115,103,32,20,94,49,162,79,126,251,86,147,144,223,114,89,185,141,234,91,104,163,178,158,77,63,124,241,119,67,223,204,230,149,89,42,124,59,63,155,87,103,105,79,254,218,47,190,91,75,0,133,242,55,61,25,210,10,255,221,37,214,175,252,110,155,165,103,103,209,183,210,180,214,254,122,249,235,52,173,48,175,127,253,221,168,89,105,50,5,46,177,242,111,125,183,194,188,142,251,221,60,88,113,223,4,105,165,249,125,234,101,120,235,211,90,139,149,154,21,230,245,114,43,63,214,119,43,150,149,178,245,221,10,243,187,189,191,94,163,149,190,245,253,76,206,95,220,255,30,38,126,144,62,11,232,20,189,131,7,69,163,253,142,134,252,51,129,172,236,91,27,138,247,50,79,167,62,88,125,86,84,103,229,230,
76,122,130,146,149,6,35,192,130,94,110,84,126,120,29,8,160,167,171,96,108,107,69,21,64,175,211,40,129,158,45,155,210,103,68,164,51,40,89,171,43,209,46,203,230,245,207,92,98,82,58,69,156,171,56,21,250,74,84,75,65,207,74,20,239,47,223,150,98,18,97,245,255,10,0,0,0,255,255,3,0,237,109,173,127);



programfile__ILLTAKEUHOMEAGAINKATHLEEN_MID
:array[0..1974] of byte=(
120,1,236,89,77,108,84,85,20,190,208,129,146,6,203,191,137,202,162,18,194,79,154,98,105,90,145,50,144,153,150,150,82,91,203,148,154,128,98,180,241,53,64,168,160,141,96,48,77,152,55,12,73,131,73,67,135,106,76,140,75,55,110,44,208,224,202,196,31,22,44,140,113,167,137,11,87,234,94,221,215,239,187,247,189,111,222,116,218,201,12,78,77,213,46,38,247,204,189,231,156,251,157,159,123,207,157,57,253,67,231,60,99,204,90,179,202,172,93,149,238,31,26,187,96,204,170,86,51,119,42,22,91,253,218,58,51,119,173,198,152,36,134,53,198,188,83,111,204,92,170,102,253,171,237,217,31,3,194,143,113,226,230,199,254,58,142,159,183,185,241,151,122,59,62,182,245,89,55,30,253,194,141,87,102,220,248,233,14,55,254,188,195,202,215,111,123,96,191,215,191,176,221,141,19,113,55,62,56,108,199,13,171,157,158,13,29,9,247,61,123,217,141,15,127,183,227,198,13,63,88,61,27,79,31,117,223,63,121,197,141,127,30,179,227,166,238,70,55,126,228,244,108,250,227,3,251,125,243,64,218,141,159,237,181,242,91,54,127,111,191,111,121,
247,158,27,127,123,202,142,91,79,189,232,198,239,102,237,184,173,119,218,141,223,190,108,199,199,135,174,152,185,103,140,243,93,109,187,153,171,217,124,124,247,232,104,195,208,240,133,145,134,211,151,46,55,244,92,122,99,196,204,192,203,95,238,49,51,181,215,204,76,93,194,204,157,94,61,103,222,55,183,226,94,102,60,29,247,98,183,186,188,108,60,221,101,9,223,17,221,30,136,110,204,116,146,232,4,209,235,101,182,167,123,65,28,243,206,164,143,97,236,241,110,62,151,238,241,214,65,58,16,146,26,9,117,112,169,35,170,166,139,106,184,85,39,212,80,111,210,187,217,156,78,122,27,129,6,188,85,68,211,73,163,184,67,15,21,247,128,232,37,225,76,0,65,27,138,208,200,168,136,16,212,80,72,51,242,141,12,239,166,81,244,86,145,111,36,212,71,52,125,81,16,90,146,190,78,170,33,226,110,248,134,234,186,232,226,174,5,93,44,91,4,66,132,208,44,174,70,190,81,164,36,29,153,9,34,149,55,106,98,220,250,177,135,121,67,135,42,224,146,142,216,2,23,47,109,222,0,77,18,32,132,166,135,46,118,176,176,183,203,177,0,68,146,145,
39,243,17,186,248,8,136,36,92,204,137,94,15,106,24,222,62,178,204,11,208,162,250,34,246,6,145,79,64,95,194,234,69,200,146,8,89,181,211,89,190,86,128,86,14,87,120,176,87,14,87,254,140,86,233,82,94,166,135,43,128,85,181,195,58,201,59,36,95,65,215,236,70,5,173,79,158,29,62,127,177,225,249,225,183,207,141,142,140,92,52,119,80,61,191,106,54,119,80,61,239,212,109,11,171,231,20,171,167,143,122,53,197,147,233,227,186,1,225,59,130,183,160,143,11,124,138,103,213,199,45,56,197,234,233,227,154,153,66,160,124,84,158,41,22,26,31,213,51,47,36,53,18,226,1,247,81,61,243,106,88,175,236,86,168,158,86,47,171,167,143,234,9,52,224,173,34,26,86,8,187,3,203,20,128,210,4,16,206,4,16,180,161,8,141,140,138,8,65,13,133,52,35,223,68,188,5,163,232,173,34,223,72,136,7,220,199,229,156,7,161,37,233,99,245,180,136,81,246,172,58,86,79,56,107,33,23,203,22,129,16,193,234,105,197,23,87,35,223,40,82,146,142,204,4,145,202,27,53,49,110,253,200,122,101,9,5,92,210,17,91,224,226,165,205,27,160,65,253,67,92,2,52,172,158,
1,44,236,205,116,150,45,172,158,150,153,213,211,71,245,156,66,245,180,19,172,158,54,188,60,144,243,3,180,168,190,136,189,129,175,81,61,125,84,79,232,125,207,193,26,74,221,24,247,135,48,51,152,2,190,65,16,3,36,6,64,164,82,224,73,129,24,34,65,158,200,76,57,82,1,207,73,110,113,210,234,145,20,8,238,53,72,205,36,164,121,128,51,220,189,143,82,204,196,20,241,16,134,128,245,147,167,63,202,163,165,8,51,196,169,71,75,253,212,83,32,53,200,45,184,251,163,57,33,69,113,2,235,39,65,205,82,120,130,51,39,48,35,30,45,105,166,36,207,36,53,231,175,203,77,191,226,186,92,127,114,228,173,203,35,23,95,31,241,26,58,174,154,187,184,44,191,126,194,220,173,125,211,220,173,59,239,46,75,147,139,123,38,215,236,249,137,92,27,242,36,211,230,197,114,7,245,13,107,153,102,124,14,226,195,149,246,144,183,149,188,173,152,225,221,150,193,221,150,179,51,88,183,252,92,129,204,60,189,226,197,6,113,171,211,233,174,154,94,107,1,177,82,47,241,98,4,102,216,86,136,183,61,196,75,62,218,88,41,94,212,165,146,182,97,61,240,91,
101,24,150,3,222,18,113,91,150,254,85,254,42,198,7,152,94,7,194,24,135,57,204,24,55,34,110,135,152,15,45,100,105,193,140,120,237,12,214,51,135,240,225,10,99,129,140,141,228,142,120,237,78,209,220,41,198,128,172,139,103,148,103,81,12,75,197,91,34,110,69,231,173,146,252,173,228,204,87,194,75,188,251,11,252,123,152,62,59,12,215,11,239,126,196,226,32,38,90,193,155,32,111,176,18,203,137,55,136,186,201,36,192,27,158,227,166,130,24,31,161,94,148,198,80,218,100,154,2,189,45,208,139,10,154,200,205,103,137,185,25,172,103,120,150,41,12,25,102,75,36,31,132,193,162,162,206,3,129,94,96,1,63,120,197,162,220,177,51,196,74,126,26,11,25,228,37,120,149,147,200,208,56,210,80,201,105,50,204,75,38,116,9,94,43,205,253,201,203,252,45,206,51,97,176,62,139,230,100,113,174,23,230,111,52,215,75,228,217,178,188,31,104,91,185,53,160,18,222,18,126,80,254,210,111,204,223,74,206,155,226,86,73,61,22,175,18,217,206,132,245,56,172,221,251,152,103,37,120,247,1,47,121,113,7,230,146,47,45,200,27,36,167,59,23,76,210,
71,194,171,187,90,111,2,59,19,226,13,207,113,225,187,68,188,127,203,191,37,226,102,61,131,245,149,247,3,46,160,208,15,149,230,239,191,205,191,202,95,229,228,226,247,228,202,251,161,242,251,172,146,55,65,37,188,204,179,149,247,67,201,55,65,144,200,101,189,31,138,120,43,57,23,172,155,133,111,229,149,247,67,228,247,177,126,7,240,61,0,191,234,157,186,20,245,77,113,83,157,71,185,12,170,62,247,118,111,146,121,191,231,197,251,255,124,63,216,247,78,224,165,200,143,129,130,183,78,27,124,247,207,190,119,130,103,78,240,39,75,24,55,254,217,210,133,255,246,50,93,232,22,135,237,229,154,159,248,111,79,199,240,216,216,85,244,151,175,142,94,26,51,247,240,111,207,55,79,155,123,181,32,195,191,198,63,52,183,247,122,55,198,175,239,245,98,183,27,241,239,226,245,70,16,59,73,236,4,161,37,17,205,100,110,198,146,8,45,21,19,229,40,108,164,66,110,42,66,154,119,114,137,48,180,164,153,38,46,53,97,73,68,57,60,187,40,181,11,82,130,186,135,51,123,48,35,66,122,68,8,143,8,137,151,99,160,164,68,72,188,152,16,79,
11,129,225,71,219,109,17,178,93,68,177,184,102,170,14,172,28,133,242,152,8,153,35,204,90,210,140,34,40,162,28,158,255,106,40,75,134,123,146,231,52,114,196,31,154,89,28,233,7,199,205,108,237,89,51,91,247,164,251,3,55,115,63,49,205,31,70,89,220,11,211,108,91,100,209,31,0,129,25,18,108,91,100,209,192,153,102,199,32,139,182,197,52,219,93,89,180,125,166,209,253,200,162,85,52,205,206,80,22,237,174,188,144,212,72,136,237,174,44,218,93,121,53,108,48,217,29,58,161,134,122,217,238,202,162,221,85,117,52,108,233,216,29,216,87,2,80,154,0,194,153,0,130,54,20,161,145,81,17,33,168,161,144,102,228,155,136,183,96,20,189,85,228,27,9,177,221,149,69,147,33,15,66,75,210,199,118,151,69,140,62,149,85,199,118,23,156,181,144,139,101,139,64,136,96,187,203,138,47,174,70,190,81,164,36,29,153,9,34,149,55,106,98,220,250,145,13,38,75,40,224,146,142,216,2,23,47,109,222,0,13,218,93,136,75,128,134,237,174,0,22,246,102,22,203,22,182,187,44,51,219,93,89,252,45,135,180,59,99,39,216,238,178,225,101,187,107,126,128,
22,213,23,177,55,240,53,218,93,89,180,187,160,55,128,85,53,125,147,52,147,231,249,47,0,0,0,255,255,3,0,132,193,106,74);


programfile__D_2PRE_MID
:array[0..7103] of byte=(
120,1,236,153,81,83,99,201,117,199,239,181,174,44,17,68,33,106,68,16,145,48,26,207,236,44,12,32,144,144,16,18,146,184,66,72,128,16,195,48,59,177,157,84,170,92,235,196,101,187,28,123,93,91,78,165,252,100,57,207,122,232,15,112,62,132,63,128,43,149,60,228,45,223,105,243,251,119,79,102,215,118,242,9,146,125,25,212,231,118,247,57,167,79,159,115,250,183,15,239,127,250,15,81,20,125,59,138,163,76,244,111,15,239,191,252,121,20,125,235,223,163,175,126,144,36,223,42,231,163,175,158,50,127,241,31,127,27,125,245,55,223,226,163,175,226,210,237,231,95,254,170,81,251,227,255,52,254,83,198,155,127,60,92,211,248,47,62,255,242,103,191,248,209,231,127,36,97,60,255,244,79,63,251,245,231,95,54,219,252,253,237,183,63,251,252,151,95,180,248,107,229,33,124,221,104,242,99,119,252,197,175,126,243,229,207,126,242,211,95,215,246,198,251,181,70,183,219,168,253,232,55,181,239,125,241,155,31,255,250,203,207,107,239,255,255,147,255,67,126,41,189,249,241,63,215,222,127,249,249,223,255,252,27,145,68,4,252,47,227,
199,81,8,228,191,252,215,232,171,231,49,129,155,41,253,224,55,255,248,197,175,126,250,197,47,127,252,205,5,254,237,39,177,107,30,157,46,154,233,75,215,220,59,228,223,162,155,156,214,70,103,217,102,35,179,152,164,219,110,216,207,45,70,105,161,153,230,221,228,42,89,12,211,170,27,165,9,162,200,53,15,55,17,229,220,112,88,98,98,118,152,38,110,54,173,77,135,153,230,193,218,98,198,74,227,211,220,98,154,38,205,180,228,166,173,100,49,78,203,12,197,12,101,92,179,81,226,247,138,75,251,207,152,27,165,252,57,62,173,48,148,119,233,121,212,60,218,89,164,124,53,104,22,145,22,220,184,17,47,6,105,101,204,14,41,170,29,108,33,77,220,224,100,19,105,206,77,88,123,144,238,184,81,83,42,99,208,254,139,225,65,130,106,101,169,52,57,206,243,213,166,27,53,114,205,122,129,15,10,110,56,216,64,186,218,100,211,167,225,42,54,149,221,195,56,63,100,153,167,180,252,128,101,179,180,196,104,222,61,60,36,24,130,19,78,162,217,109,126,241,144,150,102,104,53,153,110,32,205,185,217,67,150,229,170,110,122,153,116,62,205,
248,15,199,151,25,204,219,232,48,119,54,203,97,142,164,81,231,84,203,148,166,105,214,141,135,207,22,72,199,168,249,120,189,55,31,102,250,71,197,197,35,190,186,77,179,139,121,186,218,231,207,249,56,191,184,69,227,254,126,134,161,200,221,14,202,252,78,220,184,183,177,232,167,185,49,203,220,14,95,48,20,187,73,59,215,62,218,70,139,156,27,125,82,92,180,217,247,22,95,141,210,218,45,19,39,167,153,118,187,140,52,239,70,103,146,22,220,195,77,94,82,215,219,143,103,87,69,44,90,119,211,65,1,237,178,61,254,156,113,194,211,116,103,198,220,233,40,211,57,169,234,248,220,120,80,68,231,130,123,188,202,123,139,250,135,201,124,90,64,235,146,187,29,23,80,41,154,163,237,252,54,135,74,101,119,123,157,120,173,187,199,210,26,21,199,91,139,46,26,60,221,202,249,120,250,109,52,236,20,241,116,209,205,238,228,211,252,144,63,31,174,243,40,177,249,128,123,103,215,81,179,94,229,87,226,166,115,157,255,138,123,247,38,143,38,85,52,200,180,206,147,197,59,150,153,63,172,160,193,106,43,93,115,143,248,107,158,110,185,
249,155,152,161,140,59,105,87,131,223,38,165,197,9,122,191,127,40,161,73,201,61,189,137,219,151,235,139,247,252,249,240,54,143,6,165,54,123,60,61,73,137,178,107,117,162,135,119,43,140,62,115,183,183,89,121,166,165,248,64,122,155,86,220,195,83,212,108,72,186,229,102,111,18,164,220,8,188,249,46,196,199,236,62,115,114,226,151,145,235,38,55,69,191,239,195,187,60,22,151,92,189,153,204,238,10,204,41,186,41,46,156,165,249,58,115,181,140,108,154,206,226,163,211,117,70,139,110,212,211,208,218,145,162,7,175,141,248,119,58,72,14,136,229,89,186,113,192,175,241,80,225,85,118,211,11,221,166,146,219,175,103,199,103,154,179,165,171,49,60,47,44,246,25,157,114,94,242,233,222,167,201,184,33,105,89,215,170,143,130,123,146,158,150,56,178,188,123,249,34,30,55,229,86,230,198,46,109,173,47,94,74,193,230,6,119,107,93,199,62,57,139,247,143,42,33,122,234,107,172,156,147,66,147,179,231,163,150,238,89,226,142,78,139,94,199,254,73,121,113,148,70,125,134,70,157,231,12,101,92,253,69,60,220,171,248,59,212,219,
47,44,234,233,74,143,209,209,113,13,105,226,78,142,162,254,65,21,45,18,215,107,203,87,197,30,110,75,207,246,252,181,222,223,75,250,175,37,205,186,238,94,153,216,97,217,79,119,253,196,254,97,208,189,123,82,242,49,213,63,216,233,158,101,248,116,187,203,13,104,183,74,104,25,181,153,216,111,188,96,52,114,221,78,246,148,108,161,53,218,205,146,191,31,125,238,139,236,239,214,147,197,41,74,53,79,183,253,90,103,207,119,251,164,138,179,180,172,137,39,135,113,151,12,72,234,234,114,86,103,47,118,46,27,57,201,78,210,228,18,113,253,48,233,158,86,253,186,103,159,86,135,39,107,200,138,117,118,57,58,201,96,53,27,227,147,46,138,156,53,43,136,228,253,18,62,202,203,228,131,231,113,175,85,89,244,248,179,179,87,90,112,174,29,254,28,54,119,152,152,113,189,211,164,126,88,69,154,117,29,110,80,135,161,225,69,13,15,70,67,142,169,215,142,78,14,52,55,239,58,220,108,77,76,209,95,185,178,71,32,156,176,115,147,91,235,215,110,84,189,252,170,89,59,61,143,122,205,4,99,162,171,180,236,231,246,194,220,49,30,59,77,
11,10,128,250,113,102,120,178,29,78,172,93,25,87,19,22,41,215,217,231,228,32,186,60,140,9,183,221,75,118,235,50,67,183,121,140,245,76,59,145,3,15,147,97,163,204,76,206,171,25,238,250,213,105,109,113,197,87,7,187,241,240,19,121,177,38,159,244,246,203,94,179,241,110,77,115,201,170,154,149,115,189,163,146,183,104,88,127,206,111,44,65,243,30,242,206,145,44,192,126,226,250,64,201,156,37,218,73,155,219,237,237,59,14,246,13,27,193,113,23,157,168,213,140,57,226,221,11,52,57,111,86,134,157,252,226,60,221,110,49,237,162,167,83,161,50,212,183,22,94,218,173,32,82,86,172,201,43,238,162,175,114,193,169,179,243,5,255,158,159,215,210,243,13,62,89,151,71,47,218,241,241,65,14,39,111,35,200,240,193,206,57,163,195,198,214,226,88,201,139,67,175,71,125,102,234,112,187,71,53,252,195,125,58,126,198,121,23,82,45,250,10,105,45,72,207,20,51,72,201,232,39,88,222,108,196,253,97,194,202,21,63,183,183,115,213,206,240,193,206,21,211,250,125,57,46,118,45,238,160,151,158,239,92,147,251,186,233,174,235,83,79,48,
235,154,175,218,31,238,81,183,183,137,136,90,216,41,251,40,79,7,201,73,93,229,105,75,42,244,207,118,88,131,202,213,175,177,111,236,70,167,153,102,67,201,105,67,151,245,226,248,249,100,47,135,93,101,249,34,237,104,90,228,90,135,101,127,29,47,78,131,207,174,79,42,139,107,124,118,116,24,167,173,93,237,175,26,220,167,6,83,147,220,228,117,141,89,88,118,154,81,232,167,124,216,39,111,117,211,146,238,241,237,113,14,111,80,161,91,81,151,195,188,77,183,228,237,33,39,41,247,77,219,242,89,52,101,104,124,28,119,62,249,208,6,96,153,116,159,178,3,81,160,140,212,222,79,38,68,154,114,207,232,117,137,19,35,29,157,203,222,2,22,198,251,173,85,68,155,178,179,59,244,43,98,111,150,140,80,113,251,151,241,176,147,67,74,16,197,238,130,40,189,96,141,113,165,134,52,113,123,157,36,61,82,132,151,125,207,113,82,163,155,64,250,201,54,249,146,186,250,58,122,245,82,133,175,48,162,30,12,207,182,208,57,235,102,151,149,197,43,246,157,116,146,230,65,76,126,222,154,48,58,58,172,62,96,31,78,85,35,213,60,139,166,56,
158,154,230,77,107,213,238,57,107,90,2,121,249,164,29,221,182,243,139,251,116,211,23,106,210,149,124,126,223,82,92,36,247,252,57,59,75,234,100,7,95,5,185,151,211,116,149,161,50,121,32,235,122,175,50,163,51,213,236,162,146,233,176,31,122,149,89,186,194,189,216,114,189,227,120,124,145,67,74,214,39,59,224,159,20,155,111,79,118,187,36,8,242,172,223,239,188,234,247,187,58,175,221,190,202,114,85,183,148,33,167,199,49,71,147,33,43,149,217,15,15,224,235,177,84,121,245,114,122,172,26,84,156,226,129,241,89,229,145,18,50,166,240,222,143,214,41,184,52,117,131,44,150,60,115,143,237,2,71,149,29,243,231,236,34,238,53,86,37,85,69,28,159,87,31,125,201,218,118,119,163,140,180,112,221,182,234,247,51,55,25,230,23,119,105,73,177,243,56,120,161,56,120,68,58,31,196,157,206,22,85,60,239,238,250,59,239,40,104,119,124,59,191,140,219,244,120,157,52,82,7,112,71,181,156,83,64,159,232,95,88,129,90,254,164,153,253,168,69,247,48,103,189,59,110,249,29,118,60,14,171,132,43,221,220,85,220,172,75,167,77,55,235,
174,114,46,27,190,155,195,127,205,52,241,77,210,32,110,147,185,116,39,134,23,202,77,20,193,171,26,241,21,185,209,165,122,94,50,246,235,109,159,41,134,231,187,55,248,147,118,88,57,120,116,26,117,201,61,55,105,197,159,200,217,243,59,170,210,144,124,209,59,210,29,160,242,181,100,165,191,109,195,211,231,179,174,164,107,61,76,26,93,145,208,228,219,77,182,204,176,116,213,77,216,138,185,234,77,70,125,122,71,21,219,170,95,119,88,157,118,37,43,171,147,76,207,146,238,97,130,51,42,110,128,38,105,90,86,212,78,6,181,250,126,236,247,76,71,49,51,67,76,15,55,137,233,85,58,200,151,170,36,142,91,176,223,95,213,25,202,198,110,247,197,232,188,200,28,175,195,1,117,145,42,250,161,123,238,93,84,211,97,150,19,171,28,48,175,223,137,142,78,11,236,85,114,237,110,204,197,127,33,223,92,118,171,11,106,3,45,128,171,31,68,61,114,156,242,115,187,85,27,210,114,112,57,85,69,186,231,9,117,29,221,55,125,165,238,108,15,187,146,149,41,91,25,53,56,236,136,205,106,18,90,231,59,195,70,129,3,91,63,144,110,253,232,136,
172,135,140,200,112,173,179,117,242,200,134,59,250,36,51,32,158,90,105,117,192,57,119,123,185,87,120,130,116,219,37,62,207,142,85,113,25,109,87,48,137,12,213,9,25,170,59,222,81,74,237,226,225,203,43,233,94,86,61,235,247,106,151,189,60,191,42,238,106,148,197,140,45,247,154,253,94,145,172,142,198,153,197,235,180,116,197,77,238,77,242,44,79,109,189,216,238,164,57,204,227,100,231,171,248,126,195,13,103,190,82,186,222,163,206,180,234,134,215,254,26,170,88,141,59,170,145,220,208,78,117,124,231,109,112,211,71,101,146,178,235,92,239,246,238,95,14,238,245,52,137,125,118,243,253,247,120,86,157,63,20,249,34,30,168,23,155,147,70,212,218,150,220,152,93,166,105,81,175,176,199,89,88,98,122,155,16,202,145,27,28,215,198,151,89,37,8,205,153,223,108,50,125,213,77,105,162,143,75,204,229,241,132,70,211,52,167,126,245,110,94,64,74,207,249,189,104,48,72,136,200,170,27,211,153,78,217,97,62,215,35,138,86,64,251,198,205,147,28,115,55,217,215,191,103,154,172,248,56,211,92,250,199,135,120,208,202,177,53,
247,30,183,48,87,113,55,159,104,95,250,213,105,210,108,60,11,251,94,105,229,172,230,222,241,92,208,190,253,97,52,97,31,237,123,245,102,133,232,164,155,190,79,240,126,65,94,158,204,162,38,217,64,119,225,234,94,217,218,247,216,247,79,101,18,20,153,246,58,82,221,187,215,220,161,34,123,93,111,165,25,169,135,244,69,220,199,205,70,232,162,175,198,186,170,107,218,247,118,148,71,90,166,96,70,19,30,62,122,158,92,221,235,25,178,162,154,53,187,217,64,170,125,51,205,139,44,251,34,125,250,122,223,119,165,32,189,139,250,125,101,234,109,119,117,171,10,83,162,57,207,162,243,186,180,106,54,146,201,96,155,185,137,187,186,212,202,28,25,207,162,150,180,250,212,245,246,162,241,137,146,170,207,197,195,131,93,221,12,149,160,241,113,181,121,152,153,182,84,117,42,62,215,166,107,132,2,222,29,235,90,150,121,4,197,189,67,223,157,115,28,242,9,13,52,214,222,172,227,210,53,42,75,230,241,65,85,167,242,200,198,179,185,230,174,187,199,169,62,172,186,119,143,73,231,68,193,177,237,158,254,110,125,241,46,77,252,
235,141,243,123,34,96,155,23,153,135,27,61,148,42,110,206,243,229,65,158,122,54,39,144,102,247,207,189,29,100,232,206,225,14,135,68,191,144,134,151,223,221,213,154,55,124,126,157,52,121,211,223,165,101,77,184,155,111,176,239,170,155,63,174,48,84,113,143,147,152,131,231,6,183,107,243,187,13,118,72,230,105,174,37,5,91,219,119,248,152,196,50,227,233,121,227,51,62,84,160,120,131,39,38,36,105,37,255,86,61,25,83,91,61,19,232,172,115,181,139,169,191,66,106,21,105,2,26,254,77,232,95,208,221,117,118,37,74,47,86,188,167,238,134,153,86,205,199,33,207,35,197,86,81,111,194,57,141,218,24,7,208,156,222,53,21,203,60,154,120,11,221,165,43,88,139,84,87,98,203,221,13,178,45,94,238,146,78,104,1,201,208,45,206,116,126,169,214,168,236,154,237,204,221,153,238,31,183,132,156,124,167,88,126,38,109,230,23,47,111,187,209,25,105,107,158,22,111,137,250,73,79,221,15,46,60,45,251,110,127,218,141,154,62,171,111,139,117,140,235,219,232,146,163,186,235,186,151,238,241,200,164,145,156,189,208,187,61,227,174,218,
59,196,10,207,94,210,35,15,140,153,124,66,123,198,11,72,245,230,138,55,192,21,217,158,250,77,86,80,121,86,247,208,161,251,209,77,13,29,116,150,55,221,46,201,40,241,109,6,165,136,23,128,242,206,136,14,70,181,108,202,179,75,162,14,59,40,139,142,119,85,215,19,119,217,42,79,121,241,92,166,85,63,177,30,183,43,62,167,73,215,97,83,189,153,186,47,205,37,96,97,17,202,245,173,243,112,32,131,227,157,41,189,234,32,173,181,212,185,209,104,28,2,65,212,107,100,221,224,160,34,95,15,84,167,16,116,84,164,232,84,177,68,157,200,224,244,197,100,223,75,93,122,20,181,246,116,149,51,237,180,234,137,78,107,103,124,153,83,30,226,12,229,233,225,121,174,201,170,170,82,23,157,154,239,218,70,175,94,14,95,127,203,27,214,34,22,113,168,164,131,157,50,211,160,60,148,149,150,244,175,71,109,206,110,36,233,134,187,104,84,70,104,116,145,230,85,114,142,62,9,221,254,176,163,151,3,53,230,249,214,104,255,59,124,251,109,188,163,52,223,250,171,252,128,215,197,0,91,58,36,51,209,156,148,233,45,21,83,61,75,50,3,186,4,85,158,
94,163,146,18,213,60,214,58,220,191,65,43,219,174,235,157,176,161,140,216,165,111,215,75,41,221,223,196,115,176,44,140,61,86,237,164,78,115,22,117,189,192,48,147,134,187,94,104,62,207,95,224,112,92,16,94,31,165,246,119,162,33,71,115,46,120,86,160,19,16,140,26,156,69,45,250,67,156,227,206,143,202,233,203,146,196,186,94,195,163,184,205,241,164,122,101,241,242,121,81,30,61,47,32,91,109,83,13,235,47,118,91,7,59,190,232,235,230,182,210,77,69,68,227,40,57,122,29,227,59,176,199,119,159,49,138,161,29,133,16,135,119,156,105,193,138,180,75,135,104,86,119,51,224,205,135,91,26,105,190,165,194,196,145,182,163,14,61,150,239,150,91,101,26,17,62,223,76,211,156,142,25,192,215,219,219,109,0,238,120,104,10,85,181,210,23,35,122,5,89,218,29,100,22,141,116,219,247,254,195,93,90,31,220,95,246,191,6,177,48,17,121,217,141,6,229,201,181,26,33,90,66,30,104,221,100,246,182,236,211,210,228,78,157,127,76,182,219,229,119,214,61,188,87,193,133,182,80,7,71,148,235,225,216,55,248,10,240,209,120,133,188,86,115,
215,127,253,233,205,176,58,163,30,220,232,98,37,238,225,174,132,96,5,190,183,251,64,37,166,163,229,13,133,2,138,130,183,239,3,7,122,248,44,191,120,75,38,126,251,24,144,205,103,20,172,183,56,234,237,104,101,241,25,57,227,1,181,223,166,207,69,170,222,141,95,62,246,214,72,176,171,74,195,243,193,246,19,169,90,201,228,205,245,170,207,181,247,215,235,139,55,220,211,183,115,53,200,80,36,138,207,91,229,241,113,140,30,101,247,72,19,161,178,51,191,17,78,219,160,78,174,50,127,195,189,241,69,178,226,238,39,5,230,175,185,91,26,23,21,190,135,39,61,158,40,64,20,222,135,116,115,134,173,55,253,242,124,182,142,129,69,178,153,118,39,51,98,62,41,218,221,223,168,120,239,128,22,87,153,93,246,141,255,164,61,131,104,77,210,223,253,144,60,28,159,79,50,163,81,116,124,17,181,175,139,191,79,127,59,226,65,187,122,158,102,219,233,22,184,242,70,174,121,239,70,55,209,236,46,58,186,140,57,189,230,40,106,167,27,191,79,163,74,250,219,148,240,89,107,167,171,163,52,158,165,223,119,119,111,226,116,150,105,13,11,72,
107,233,111,245,254,34,186,117,97,238,210,213,163,244,119,60,247,175,162,217,52,131,183,155,147,104,50,138,94,93,109,243,233,247,211,223,254,139,40,82,204,195,255,149,186,240,136,94,156,42,129,40,250,234,127,160,216,254,127,149,124,131,96,235,207,232,63,51,177,65,177,151,80,108,131,98,243,111,209,62,82,236,37,20,219,160,216,203,64,177,13,138,189,164,81,51,58,106,68,145,65,177,17,229,12,138,205,68,81,108,251,72,177,151,68,136,65,177,151,36,50,18,141,65,177,151,84,103,134,98,134,50,6,197,230,247,138,65,177,153,27,65,177,17,85,24,202,91,234,41,246,146,59,98,80,108,164,5,131,98,47,3,197,182,64,177,145,38,6,197,70,154,51,40,54,210,29,27,53,51,232,133,65,158,98,163,154,40,182,65,177,249,106,211,2,197,230,131,130,65,177,145,138,98,27,20,27,155,202,22,40,246,50,80,108,227,12,25,205,27,20,27,67,112,130,167,216,203,64,177,13,138,141,52,103,80,108,150,171,90,160,216,254,67,40,54,230,137,98,27,20,27,115,36,21,197,70,42,138,109,80,236,101,160,216,246,145,98,47,161,216,6,197,94,6,138,109,80,
236,37,20,219,160,216,12,69,6,197,230,119,98,80,236,101,160,216,6,197,102,40,182,64,177,209,34,103,163,79,138,75,40,182,65,177,49,174,70,204,114,146,162,216,72,243,6,197,70,90,48,40,182,164,22,40,54,22,173,27,20,27,237,212,69,27,20,27,245,69,177,45,80,108,29,159,65,177,209,185,96,80,108,111,81,160,216,104,93,50,40,54,42,69,52,188,6,197,70,165,178,65,177,189,214,80,236,160,226,120,107,73,54,55,40,54,154,224,105,79,177,241,116,209,160,216,104,32,138,109,80,108,148,16,197,182,64,177,249,149,24,20,155,179,91,49,40,54,154,84,209,64,20,123,201,27,214,160,216,104,32,138,109,80,108,118,220,50,40,54,67,25,131,98,7,191,77,74,75,40,182,65,177,209,164,100,129,98,47,161,216,40,145,71,3,189,124,13,78,141,18,101,11,20,155,209,103,6,197,150,103,160,216,94,10,197,182,64,177,145,110,25,248,25,105,65,113,9,197,70,207,109,11,20,91,203,200,117,80,108,191,47,20,27,139,75,22,40,54,210,162,65,177,153,32,138,237,151,145,77,129,98,51,90,52,40,54,102,138,98,27,20,155,115,202,115,56,162,216,72,69,177,137,
30,133,87,217,160,216,156,68,201,2,197,102,72,20,219,160,125,75,40,54,115,138,196,103,209,2,197,214,4,93,43,40,246,18,138,109,80,108,142,44,111,129,98,135,185,177,65,177,151,80,108,131,98,115,183,68,177,45,80,236,16,61,245,53,86,22,197,102,84,20,155,209,196,160,216,94,71,40,246,146,42,7,106,51,40,54,67,25,11,20,219,223,33,40,246,50,80,108,131,98,35,77,44,80,108,180,72,12,138,141,175,138,112,13,110,246,158,191,214,129,98,35,205,26,20,155,216,97,217,79,119,253,68,40,182,215,29,138,237,99,42,80,108,134,68,177,13,138,141,150,228,217,172,65,177,25,141,44,80,108,191,6,20,219,223,15,40,118,88,163,158,44,161,216,6,197,246,107,5,138,189,12,20,219,2,197,38,248,68,177,45,80,108,201,2,197,182,64,177,253,186,129,98,35,19,197,54,40,54,86,179,49,62,129,98,27,20,27,145,188,95,194,71,162,216,22,40,246,146,247,140,65,177,151,129,98,27,20,155,137,25,11,20,27,105,214,160,216,220,187,140,65,177,241,32,165,54,198,93,162,216,72,243,6,197,70,154,24,20,219,231,74,40,54,158,36,43,159,84,195,218,141,170,
151,127,164,216,24,19,5,138,109,157,94,152,11,197,198,7,5,250,99,11,20,59,156,152,167,216,44,34,138,109,129,98,19,110,162,216,6,197,246,222,130,98,51,20,67,177,41,3,162,216,204,228,188,154,225,174,67,177,151,80,108,11,20,155,141,107,242,9,20,219,107,6,197,214,92,178,170,102,229,12,138,237,45,130,98,7,23,160,57,20,219,160,216,193,126,226,58,80,108,236,23,197,246,171,116,142,131,125,80,108,63,43,80,108,142,88,20,219,2,197,94,6,138,109,80,108,190,161,50,212,183,150,94,218,173,32,82,86,172,201,43,6,197,38,190,34,131,98,35,143,44,80,108,62,17,197,182,64,177,113,242,54,130,12,31,136,98,27,20,123,25,40,182,5,138,77,84,225,159,163,26,254,225,62,29,63,227,188,11,169,22,245,20,59,72,207,170,65,74,70,135,98,83,5,69,177,89,89,20,219,186,158,98,243,193,14,20,219,64,46,232,22,27,20,59,204,245,20,27,233,174,241,154,95,210,21,210,129,25,20,59,72,123,155,136,168,133,157,178,143,242,64,177,185,166,162,216,6,197,230,171,140,65,177,217,55,182,64,177,145,138,171,89,160,216,216,37,138,109,80,108,4,
145,65,177,81,44,49,40,182,247,25,20,123,9,197,182,64,177,181,191,164,80,108,86,102,223,215,53,102,97,183,167,216,76,36,228,201,91,129,98,27,20,27,111,80,161,61,197,38,25,139,98,27,20,155,83,33,203,183,229,51,222,66,145,5,138,77,116,208,6,96,153,116,135,98,43,10,148,145,2,197,102,31,50,194,235,18,39,70,58,58,151,189,5,44,20,197,70,36,138,109,80,108,173,136,189,89,50,66,197,2,197,70,42,138,109,80,108,44,162,174,85,106,72,19,11,20,155,77,69,252,232,42,106,116,19,72,63,217,38,95,82,87,61,197,70,90,128,98,27,20,27,157,179,6,197,94,66,177,241,183,40,54,249,89,20,219,70,158,98,163,24,111,205,162,5,138,77,222,23,197,182,177,167,216,172,35,138,77,141,18,197,94,6,138,109,19,210,149,124,14,197,230,124,68,177,45,80,108,22,198,63,39,219,164,233,85,134,202,228,129,172,5,138,173,138,161,100,10,197,70,35,42,70,186,194,189,216,178,64,177,145,138,156,208,76,233,20,99,11,20,155,15,34,223,24,156,87,253,126,129,98,115,85,69,177,13,138,205,209,100,200,74,101,246,195,3,220,106,158,146,22,40,182,246,
131,98,91,160,216,8,214,12,138,77,193,165,169,27,100,177,228,153,65,177,57,42,81,108,11,20,91,82,85,196,64,177,153,179,109,48,18,105,97,80,108,164,207,12,138,189,12,20,219,160,216,58,53,208,156,5,138,77,21,207,91,160,216,124,243,204,2,197,102,139,72,29,0,20,155,15,170,6,197,214,10,129,98,219,220,83,108,4,177,65,177,17,36,6,197,38,92,233,230,60,197,102,215,77,131,98,115,46,162,216,196,136,186,87,81,108,27,121,138,173,227,35,231,42,55,81,4,175,106,196,87,100,80,108,60,70,198,126,189,141,156,216,245,20,155,79,68,177,185,79,162,216,203,64,177,137,17,81,108,100,219,164,54,221,129,12,129,47,43,253,109,11,20,27,169,40,182,5,138,141,111,55,217,50,195,210,85,131,98,107,174,122,147,64,177,217,88,20,155,62,91,20,27,153,40,54,229,82,20,27,103,84,12,138,205,33,139,98,91,160,216,126,79,40,54,51,67,76,15,55,137,233,85,58,200,151,170,36,198,45,128,98,235,12,101,99,160,216,204,241,58,64,177,85,69,63,116,207,129,98,115,98,162,216,22,40,54,123,149,12,138,205,197,23,197,54,40,246,50,80,108,11,20,
155,207,185,172,158,98,235,114,170,138,4,138,141,238,162,216,214,246,20,27,89,217,2,197,214,142,129,98,91,160,216,28,152,40,182,5,138,45,127,232,62,67,177,201,35,27,22,40,54,223,136,98,147,55,69,177,149,110,161,216,6,197,166,226,50,218,174,96,18,25,170,19,50,84,160,216,12,85,13,138,141,238,162,216,22,40,54,191,42,6,197,198,140,45,131,98,115,181,119,12,138,189,12,20,219,160,216,44,79,109,245,20,27,243,56,217,249,42,190,223,48,40,54,191,177,227,81,39,94,53,40,54,191,183,84,239,160,216,184,152,115,243,20,91,54,24,20,155,161,178,125,164,216,74,241,31,41,182,5,138,205,23,162,216,116,191,164,17,181,182,37,4,234,12,69,177,13,138,237,151,128,98,19,202,145,5,138,173,4,161,57,80,108,164,171,22,40,54,115,121,60,161,81,160,216,6,197,70,74,207,233,41,54,17,89,53,40,54,210,146,65,177,9,145,2,108,140,125,99,40,54,115,55,217,215,191,103,96,149,236,171,185,244,143,158,98,235,102,27,20,91,115,21,119,80,108,164,244,171,158,98,135,125,175,180,178,40,182,65,177,253,190,129,98,251,125,161,216,68,39,
221,244,125,130,247,11,87,236,27,40,182,191,11,80,108,164,5,245,216,80,108,18,20,153,214,83,108,242,76,213,160,216,72,69,177,13,138,173,244,69,220,139,98,43,71,25,20,27,169,40,182,65,177,145,150,41,152,162,216,36,183,178,65,177,145,138,98,27,20,27,169,246,21,197,102,46,210,167,175,247,125,87,10,82,79,177,217,119,219,160,216,204,45,209,156,103,209,89,20,155,10,46,138,205,220,196,160,216,72,57,50,158,69,45,105,245,169,5,138,173,125,125,28,28,236,234,102,168,4,125,164,216,184,69,20,219,184,138,132,2,222,29,235,90,150,121,4,137,98,227,191,45,142,67,111,6,81,108,52,94,103,104,141,202,34,138,205,168,40,182,65,177,153,187,110,80,108,134,170,22,40,54,39,180,109,80,108,94,75,162,216,254,252,160,216,196,176,40,54,210,138,65,177,201,130,31,40,54,39,241,220,219,17,40,54,135,68,110,76,195,203,15,138,237,13,15,20,27,145,40,54,209,180,193,190,171,6,197,102,168,98,80,108,14,62,99,129,98,179,195,7,138,109,31,41,54,235,215,12,138,205,231,31,40,182,65,177,89,154,54,199,83,108,108,95,161,3,89,231,
106,139,98,115,133,212,42,210,4,120,138,173,112,178,113,119,157,93,137,210,139,21,239,169,64,177,17,113,75,232,165,2,197,54,40,54,210,109,53,167,80,108,212,226,209,212,144,84,20,27,169,174,196,150,5,138,237,165,80,108,164,162,216,148,25,189,219,202,22,40,54,82,110,9,57,249,35,197,182,143,20,27,153,40,182,65,177,153,65,165,60,45,251,110,63,80,108,172,21,197,54,40,54,186,228,168,238,34,17,162,216,20,124,81,108,230,100,12,138,77,172,240,236,221,75,152,43,138,173,119,59,20,27,41,65,197,27,0,138,173,250,77,86,80,121,86,247,0,197,102,197,226,135,14,58,203,155,110,151,100,36,138,13,69,17,197,70,74,245,160,131,81,45,131,98,99,45,179,216,65,89,20,138,237,229,129,98,147,243,68,177,209,82,20,91,57,77,186,66,177,73,88,234,190,52,151,128,133,69,40,215,67,177,153,171,172,35,138,77,198,168,209,8,42,128,3,197,166,52,100,45,80,108,100,162,216,156,166,138,20,157,42,150,168,19,9,20,91,82,11,20,91,94,8,20,219,6,158,98,43,15,5,138,77,153,21,197,70,19,250,80,66,65,93,91,160,216,222,48,40,182,28,42,
41,20,155,105,80,158,110,158,216,65,127,79,177,249,74,20,219,2,197,102,186,40,54,213,35,116,251,80,108,191,114,160,216,124,251,129,98,91,160,216,172,199,27,172,225,121,141,65,177,89,87,80,142,103,137,40,54,82,158,99,158,98,115,169,69,177,209,94,20,27,35,69,177,121,9,168,254,208,199,238,111,226,57,250,74,79,177,145,138,98,27,20,27,175,96,38,13,247,127,83,108,100,162,216,60,50,62,80,108,30,32,95,83,108,170,188,40,182,156,99,129,98,75,12,197,182,64,177,153,205,43,139,151,143,167,216,200,68,177,121,136,139,98,251,162,15,197,198,4,81,108,11,20,27,223,129,61,190,251,140,81,12,237,40,132,56,60,79,177,253,46,80,108,134,240,45,111,190,111,82,108,11,20,155,13,177,202,83,108,62,255,64,177,5,248,2,197,198,43,162,216,22,40,54,123,208,243,13,50,203,64,177,233,101,68,177,113,191,40,54,64,78,20,155,64,88,161,7,19,197,214,193,249,142,204,83,108,159,150,160,216,124,16,147,237,118,249,157,53,40,182,143,80,40,54,95,239,24,20,27,121,89,1,14,197,38,175,213,236,35,197,166,51,19,197,54,40,54,130,21,
122,101,81,108,150,249,154,98,27,20,27,25,124,234,179,252,18,138,109,80,108,126,23,13,138,205,239,178,65,177,151,80,108,186,72,253,22,197,182,64,177,73,176,162,216,244,172,162,216,62,153,64,177,65,69,27,6,197,94,66,177,13,138,77,1,129,34,81,124,160,216,20,144,216,239,5,197,70,9,96,214,77,129,116,185,65,157,92,101,254,134,65,177,73,55,21,131,98,51,127,205,160,216,190,240,65,177,73,1,20,32,10,111,160,216,22,40,54,6,22,201,102,218,157,204,136,249,164,104,131,98,115,119,119,64,139,171,204,22,197,182,137,167,216,248,233,119,63,36,15,255,17,197,254,3,20,155,7,237,159,82,108,251,115,138,253,135,64,177,9,159,175,41,182,125,164,216,72,69,177,137,125,162,251,27,20,219,254,156,98,243,169,167,216,156,223,159,82,108,68,162,216,255,37,0,0,0,0,255,255,3,0,179,214,47,21);


programfile__D_4INV_MID
:array[0..9506] of byte=(
120,1,236,154,223,111,27,201,150,223,201,203,214,146,90,211,144,12,75,176,188,150,247,202,215,210,140,108,73,20,69,55,69,81,162,200,226,143,22,91,84,211,164,100,122,134,134,53,176,156,241,96,60,184,222,157,201,228,6,59,23,200,34,226,189,79,65,36,161,235,189,187,254,143,5,18,96,243,158,228,111,201,123,30,38,159,211,197,209,108,128,100,223,130,188,172,1,67,172,83,167,206,57,245,163,171,206,143,111,127,244,241,67,42,149,250,139,84,154,255,255,216,31,253,248,251,84,42,243,31,83,63,143,157,204,111,150,114,169,159,79,51,127,241,87,151,169,159,223,252,6,166,159,211,11,47,191,249,187,149,209,143,239,191,254,253,202,175,255,254,57,250,232,236,117,127,232,141,126,101,230,151,240,15,143,155,47,7,255,27,213,210,255,31,203,127,222,254,254,135,63,254,248,221,183,31,255,176,178,222,126,182,178,83,173,238,172,252,171,63,174,124,241,253,31,191,249,195,143,239,87,70,223,124,253,241,111,191,255,244,253,183,223,125,243,111,176,242,95,184,255,101,77,254,63,159,147,237,148,253,36,115,255,51,245,243,
147,116,58,245,115,102,225,236,155,175,191,255,241,195,55,63,86,118,127,253,126,82,255,24,164,194,250,225,169,106,63,186,172,171,90,216,236,59,151,74,141,155,106,38,108,247,190,245,122,206,101,91,13,61,90,71,173,175,47,143,84,46,60,244,206,143,234,119,47,15,85,16,122,190,3,233,93,216,86,206,165,167,206,195,102,87,184,223,52,225,82,157,15,205,238,28,146,206,155,234,34,244,122,23,48,244,195,30,127,123,48,182,189,119,194,24,30,159,92,92,30,35,32,224,111,160,222,135,189,147,183,193,233,42,44,123,97,255,245,60,36,191,175,82,225,224,248,195,233,89,243,114,160,30,156,98,199,217,224,226,242,76,101,195,99,255,226,172,91,100,184,27,158,246,231,33,29,135,131,230,131,203,83,212,244,143,239,195,237,246,213,66,24,180,191,233,143,242,72,26,134,189,227,236,101,31,165,193,171,251,104,240,195,254,151,162,97,20,14,152,69,95,5,3,229,132,167,47,199,8,88,96,174,95,157,182,238,48,183,32,28,212,31,67,82,97,63,184,131,204,247,97,48,156,131,187,19,48,199,158,250,155,160,37,178,154,129,202,132,190,119,
209,235,45,94,250,170,141,134,121,168,175,195,254,89,22,13,253,62,189,131,163,79,12,207,133,44,211,224,120,158,197,240,194,254,201,18,36,63,12,94,231,145,248,142,197,17,59,131,30,51,246,213,191,238,169,7,200,106,134,193,209,3,100,41,209,215,15,206,123,39,57,120,95,135,65,63,15,245,36,192,230,126,240,111,219,251,25,168,127,250,169,173,38,62,99,199,61,175,204,216,205,48,232,137,29,39,161,127,180,36,146,195,222,209,60,244,142,104,8,188,143,144,210,97,115,247,79,153,203,166,154,48,231,206,159,211,94,63,203,164,223,120,234,109,216,238,94,176,69,99,196,189,57,234,44,51,172,27,122,167,107,244,186,97,27,147,60,12,111,54,101,187,71,161,194,152,166,26,43,140,105,6,95,181,187,15,104,141,56,19,161,215,90,135,49,29,182,15,127,11,99,42,244,10,15,105,103,194,246,254,138,87,73,67,90,14,219,149,44,164,31,218,106,54,108,214,246,24,184,141,73,63,241,119,24,250,141,11,212,158,135,126,91,254,126,19,246,14,62,103,54,185,208,223,89,165,237,132,189,23,203,180,243,161,255,185,152,55,19,246,214,101,165,
232,223,93,163,157,13,123,165,199,180,239,132,254,250,67,218,153,176,183,241,132,246,92,232,63,122,76,59,21,246,220,77,219,255,100,133,54,242,14,182,104,35,111,237,41,109,182,119,119,137,246,221,208,255,171,71,182,93,122,56,229,23,253,179,97,111,103,157,118,54,244,139,178,218,200,43,109,211,70,255,74,145,54,242,182,229,36,179,153,235,123,182,63,209,71,255,162,216,135,61,85,233,119,66,127,243,9,109,236,221,20,123,232,127,42,167,136,254,162,204,15,253,191,91,178,253,174,216,131,125,235,211,249,110,74,63,250,63,155,218,191,179,98,251,159,203,46,163,127,71,250,145,183,62,249,116,116,32,50,70,236,200,99,182,240,32,108,55,87,88,118,21,54,27,249,233,22,230,88,243,115,217,66,191,252,77,125,87,86,160,22,42,245,152,59,161,17,182,154,243,124,201,163,22,194,218,251,99,175,42,219,62,246,152,218,81,251,131,23,108,218,67,81,151,59,224,13,135,226,17,189,157,80,157,202,161,232,43,38,82,239,126,56,106,204,34,233,109,88,171,45,195,237,135,245,206,202,101,77,52,240,45,212,57,220,232,109,190,124,
221,238,222,97,204,135,208,27,174,32,99,47,236,246,239,33,51,232,202,36,134,95,247,78,101,94,253,48,24,201,62,215,2,182,188,127,54,226,224,207,133,157,151,23,253,87,43,151,29,102,20,156,46,64,226,172,15,102,57,224,175,56,251,11,112,239,201,134,118,187,159,252,179,165,203,46,95,85,247,108,1,89,131,176,231,75,187,19,250,47,23,225,58,9,187,47,69,135,234,34,219,243,190,237,4,11,162,63,244,248,219,97,84,103,48,71,123,24,182,58,210,246,90,44,190,58,28,215,203,51,172,206,215,117,230,80,219,185,168,55,238,50,179,110,157,141,82,189,175,90,39,15,232,27,134,157,96,245,178,133,4,239,108,142,145,220,167,14,171,242,81,108,99,246,204,83,172,105,118,89,43,175,253,161,195,87,235,177,87,173,78,30,222,126,162,229,224,162,213,188,139,164,32,236,112,199,181,84,167,131,4,175,247,166,235,223,135,215,147,145,190,255,190,213,187,131,156,49,215,233,34,60,237,176,215,95,101,13,106,161,143,252,30,86,216,89,51,59,249,52,127,232,28,230,24,59,238,176,50,94,231,162,235,201,137,104,134,254,217,163,100,69,122,
126,30,89,35,110,154,52,99,207,3,230,234,53,63,246,135,107,112,85,194,224,236,33,171,220,225,194,190,143,134,62,202,147,123,208,231,115,235,6,31,78,79,31,35,163,29,14,191,90,228,238,28,132,47,135,11,151,67,110,188,32,112,46,95,114,10,228,190,14,212,159,150,88,254,52,12,219,61,85,230,250,148,83,156,13,187,141,101,14,47,195,151,228,12,119,15,23,253,142,180,150,195,174,154,131,97,194,45,210,158,129,80,241,212,106,232,237,78,124,153,3,215,234,248,168,38,211,57,61,146,165,216,251,84,119,197,124,191,206,105,106,117,223,176,26,111,67,175,49,130,225,167,240,168,57,110,55,229,24,178,29,253,167,28,52,55,60,26,201,70,251,24,113,15,122,55,236,121,14,163,127,144,175,77,117,82,171,106,243,114,85,61,196,90,187,153,62,219,223,99,242,71,157,187,112,33,152,229,61,162,221,110,203,39,240,30,99,238,35,117,193,83,147,165,176,239,159,7,156,91,185,179,251,103,114,191,95,244,213,239,167,151,43,87,127,255,79,207,160,157,35,250,109,112,38,215,85,59,236,243,120,4,234,184,207,182,12,130,243,211,51,121,202,
142,79,153,213,217,233,7,94,185,52,15,223,199,179,87,143,120,248,58,225,233,80,30,190,62,47,164,60,124,65,216,31,204,195,93,235,99,119,112,242,177,63,186,139,164,47,251,172,143,125,120,47,194,118,48,121,143,109,53,33,28,243,254,201,153,15,252,187,8,27,132,94,247,9,236,138,71,121,192,52,230,143,81,213,235,189,235,6,51,112,53,186,170,24,246,2,177,48,19,30,55,159,244,142,51,140,89,12,143,95,102,33,77,130,99,185,255,94,239,241,27,182,147,177,223,17,209,65,120,228,207,178,66,124,64,175,31,177,66,190,92,25,237,238,121,211,155,199,6,191,201,221,118,228,95,28,158,202,94,212,194,250,48,131,83,113,17,170,129,124,20,188,46,95,228,147,3,223,238,45,112,41,212,88,80,190,158,55,189,19,121,47,62,133,77,30,75,20,115,131,124,33,221,65,88,239,203,247,81,171,243,128,212,79,254,188,131,136,212,207,191,184,64,115,255,227,214,5,26,126,247,254,111,191,255,213,251,73,126,165,254,203,111,82,218,186,64,19,92,32,141,11,52,177,46,144,182,46,208,196,186,64,26,23,104,130,11,164,173,11,52,193,5,210,184,64,144,
222,105,158,187,9,111,187,198,5,130,91,92,32,157,184,64,119,74,135,34,236,117,73,101,180,139,92,188,33,93,62,77,121,189,153,137,171,94,233,202,105,142,97,185,178,242,116,175,231,76,42,112,85,189,241,164,170,210,188,28,122,191,247,229,100,95,57,122,231,48,141,199,132,92,72,163,252,100,71,245,245,241,73,182,122,226,208,59,210,149,94,122,114,172,238,84,213,176,2,111,112,146,42,183,253,73,89,221,213,110,247,206,132,3,231,50,172,220,78,247,78,6,80,243,26,7,107,210,83,174,174,54,29,124,44,24,150,171,106,19,55,75,39,110,86,186,94,169,176,8,179,214,217,210,56,91,19,156,45,125,236,167,220,103,23,152,156,210,56,93,168,115,245,105,223,169,20,242,244,174,86,212,154,198,245,154,224,122,233,254,177,115,88,158,155,12,212,202,161,90,192,1,211,137,3,150,45,21,102,208,116,82,82,51,26,55,108,130,27,166,131,87,217,250,70,30,83,86,235,106,85,227,140,193,48,212,229,174,131,63,6,195,94,89,45,224,146,105,92,50,4,47,176,246,233,202,206,91,86,40,173,113,205,88,243,64,15,234,185,106,101,145,222,71,85,44,
192,65,67,237,185,222,47,205,224,163,33,97,101,95,173,226,54,233,196,77,203,20,139,243,232,90,46,170,53,156,53,141,179,86,107,165,240,215,38,190,90,175,169,71,88,35,221,175,117,255,44,227,214,29,76,217,113,213,50,142,155,198,113,67,108,78,115,118,203,187,99,86,208,97,161,230,217,52,79,247,79,50,149,218,34,189,143,42,106,75,227,198,161,244,75,93,109,228,240,228,144,224,86,213,146,236,34,190,203,126,53,143,63,135,174,242,190,186,163,43,245,52,94,157,108,66,69,229,113,225,116,245,200,233,7,175,247,7,25,54,222,209,248,120,8,26,237,51,211,160,159,169,53,102,225,236,214,148,35,156,253,32,87,175,143,216,160,37,237,238,164,241,251,224,28,186,106,94,215,221,62,212,188,174,85,222,78,224,213,251,141,11,206,75,90,87,17,186,175,198,28,40,93,225,244,86,152,73,181,158,74,124,68,167,220,118,80,184,229,171,167,50,171,74,99,6,127,17,93,39,21,49,250,40,93,173,63,96,22,170,202,144,253,35,7,223,17,251,197,119,212,129,55,131,204,172,174,29,158,195,144,214,205,221,12,58,115,186,180,51,154,148,196,134,
221,243,253,122,14,146,219,84,207,116,181,35,22,124,172,50,240,168,147,171,236,142,203,172,78,69,141,68,167,219,59,79,206,84,177,62,158,20,69,194,129,184,160,108,110,179,164,230,180,219,158,101,157,153,94,86,151,91,78,187,27,176,250,57,93,233,228,153,217,72,206,58,94,223,86,185,49,217,82,139,136,206,86,94,200,110,54,100,138,222,105,186,92,91,69,206,118,153,19,199,169,197,101,69,212,158,172,84,179,153,46,53,50,34,162,132,73,170,239,20,15,114,124,150,199,69,53,167,32,148,54,156,102,48,102,30,51,186,221,205,20,246,22,232,11,10,42,39,31,95,113,207,193,165,69,80,90,227,210,38,223,35,46,45,237,140,182,46,45,164,101,141,75,11,105,89,175,190,200,49,169,0,215,86,227,218,34,102,155,149,114,158,213,22,38,171,202,127,134,249,27,245,68,248,6,226,182,84,198,111,140,11,236,60,175,222,150,26,21,68,91,207,241,219,231,136,72,235,18,187,232,171,15,122,189,145,238,29,100,48,110,21,199,78,227,8,11,187,238,161,104,157,117,47,177,232,60,89,26,135,24,58,95,218,186,28,50,248,118,211,12,113,116,241,112,
5,122,86,227,24,67,191,163,253,245,89,164,103,117,161,57,11,61,163,113,144,161,207,105,255,209,226,164,0,125,171,155,134,158,210,56,202,150,255,201,10,107,205,225,65,229,129,179,81,126,6,21,109,107,79,225,114,54,132,186,155,222,106,137,206,187,26,167,25,42,31,95,105,150,49,119,116,161,51,51,149,33,54,207,234,222,206,111,209,49,163,139,53,7,122,86,227,68,91,93,165,71,216,228,232,210,161,28,69,108,95,41,138,116,221,219,94,114,189,89,166,145,73,62,169,245,61,203,237,46,148,143,29,142,208,66,194,187,184,6,149,121,84,31,114,82,50,122,195,149,245,224,152,108,62,129,206,188,55,101,30,200,124,154,158,108,48,47,110,24,203,95,92,134,142,205,191,91,74,164,186,103,217,158,235,32,2,169,204,111,125,186,154,155,15,74,141,52,186,156,196,222,207,100,45,177,107,103,133,177,233,146,44,231,115,167,184,159,159,82,69,34,154,214,55,11,181,123,76,232,132,19,164,183,218,231,71,7,14,203,225,232,194,94,242,53,9,181,184,147,195,43,231,172,110,20,209,182,117,224,224,155,115,126,220,45,86,167,208,200,226,
161,115,170,84,129,190,98,53,167,250,114,86,135,112,226,50,107,191,236,60,223,121,143,183,142,210,154,198,91,231,10,104,104,188,117,94,28,241,214,57,149,238,228,57,183,43,46,187,28,120,86,68,94,41,62,196,246,107,86,32,163,183,26,121,252,119,116,175,111,193,93,104,59,109,238,62,174,182,2,211,217,168,204,226,203,51,172,186,33,103,161,238,224,209,163,187,182,133,37,133,214,12,42,50,26,207,158,93,68,94,195,89,47,207,160,253,173,198,195,71,158,175,241,240,185,1,176,138,203,178,174,20,231,83,44,182,78,62,98,62,104,111,152,122,214,88,65,254,252,51,181,174,113,245,81,44,174,190,246,135,153,242,129,124,235,11,26,151,159,169,121,186,116,148,195,235,103,73,87,74,106,25,199,159,107,122,196,205,55,167,183,189,84,231,229,214,100,91,189,208,4,0,19,2,0,222,183,212,102,99,129,222,229,77,85,212,132,1,220,81,3,189,94,117,240,182,145,176,180,174,86,228,96,118,187,223,109,213,51,196,3,147,174,172,245,172,222,244,28,252,99,212,13,54,153,209,214,105,138,216,128,190,154,222,238,230,252,151,178,109,247,
184,135,183,153,68,247,101,170,152,220,134,138,56,65,123,94,182,212,90,98,143,203,114,103,149,27,14,81,3,83,89,150,183,214,221,91,230,192,112,31,5,169,114,117,1,243,238,149,89,89,119,111,9,234,93,221,25,164,202,251,115,240,62,76,120,11,79,19,222,86,39,93,222,191,15,239,82,66,221,126,50,105,169,12,167,78,171,195,124,249,217,22,235,130,220,181,251,68,29,108,193,156,75,171,252,66,168,89,237,62,95,96,169,29,93,219,153,71,210,188,46,23,214,161,231,180,91,156,39,42,145,103,193,21,11,11,207,160,114,247,238,101,225,206,107,213,91,72,244,150,43,34,5,235,138,179,68,45,200,206,187,204,174,124,112,144,112,119,130,148,123,184,138,41,179,201,117,220,216,132,202,220,121,45,247,242,216,250,56,161,182,55,153,76,74,132,215,187,105,183,180,97,229,214,132,23,125,245,100,7,234,106,65,86,164,92,181,212,110,223,113,171,178,201,75,9,181,246,132,37,207,104,175,157,99,12,150,151,86,173,140,178,204,36,165,59,61,199,45,229,101,117,147,121,23,133,234,232,86,199,113,119,114,88,1,149,89,151,100,197,178,194,
174,14,114,238,139,53,187,22,197,167,173,166,124,211,8,221,73,51,187,167,137,132,221,199,157,166,168,98,241,14,115,12,91,75,230,161,150,16,230,104,143,231,48,177,252,96,19,25,172,69,99,129,120,235,151,41,186,123,235,214,182,214,189,196,102,223,23,238,148,118,247,167,220,199,43,173,158,200,206,200,29,234,50,3,217,196,114,75,230,205,27,122,146,114,213,34,26,31,36,212,222,170,187,159,22,94,77,204,198,129,101,167,208,119,36,243,19,211,28,34,56,206,238,124,178,70,201,62,65,61,152,158,87,246,137,51,80,91,147,225,132,118,218,107,57,110,69,78,24,107,113,32,123,125,95,187,79,115,68,123,88,94,116,213,58,1,159,246,58,67,245,215,243,196,124,208,214,149,122,168,9,251,152,69,71,247,252,92,125,205,97,63,70,56,31,105,116,102,234,234,13,193,159,246,154,185,218,198,5,135,40,165,9,2,25,86,209,193,153,115,176,187,200,151,198,176,147,251,88,157,58,192,43,171,238,166,137,6,25,137,231,144,38,32,212,73,64,232,212,91,15,81,208,144,243,73,88,136,211,118,162,213,137,67,100,56,25,138,5,143,53,193,225,132,
224,16,191,50,221,244,230,144,246,177,169,190,210,245,214,43,130,68,216,9,18,221,58,79,33,111,52,161,34,6,102,181,13,21,145,42,161,162,182,161,34,173,101,77,168,40,39,74,241,85,187,234,29,43,145,226,68,205,208,37,65,163,248,63,222,238,249,86,55,135,243,115,174,11,137,7,158,222,82,175,10,8,41,86,83,222,222,144,143,57,151,92,147,181,116,169,50,230,58,203,136,171,224,239,57,47,218,31,39,47,248,89,119,157,231,101,121,171,9,48,211,250,69,183,198,45,251,185,116,180,186,60,5,3,251,218,162,177,165,94,137,91,227,53,156,66,45,224,166,116,136,171,244,150,247,241,168,153,230,62,225,133,218,27,17,138,162,160,184,161,238,105,162,81,174,67,87,31,141,82,27,120,9,158,234,200,163,186,229,49,225,123,240,236,37,119,116,55,75,112,138,230,126,65,61,208,171,42,165,112,135,200,111,16,159,178,119,242,217,14,181,223,73,109,184,114,94,242,27,106,15,207,232,46,236,99,222,153,12,129,42,114,86,138,44,2,177,42,10,222,227,214,230,203,92,4,73,184,186,167,43,129,156,225,161,238,179,228,73,44,210,26,7,167,206,
1,10,241,2,241,52,245,225,145,51,57,96,202,196,178,236,208,201,33,63,235,108,97,159,27,214,245,211,56,76,92,41,167,114,74,235,47,197,63,242,57,68,51,135,254,28,212,225,33,203,115,64,252,121,192,18,84,123,111,42,221,44,66,103,3,245,86,92,250,158,159,41,123,85,116,255,150,83,37,222,73,3,63,218,33,20,70,203,124,85,85,137,134,117,18,13,167,234,213,251,120,220,235,117,245,132,152,88,19,19,19,129,164,137,79,28,119,183,203,78,63,214,196,198,196,39,29,125,58,116,42,174,196,39,203,21,181,131,207,46,241,137,175,15,235,14,65,50,18,150,14,213,42,113,50,31,34,113,178,83,194,213,12,84,151,16,109,158,205,75,145,64,74,62,181,151,78,175,55,170,244,101,133,157,178,248,156,60,169,65,138,99,179,207,97,173,18,202,237,176,30,251,234,49,17,53,241,91,102,191,55,38,56,195,159,199,113,218,103,186,68,216,140,60,209,129,159,170,120,119,177,202,169,210,42,119,83,94,119,150,245,93,10,212,139,228,54,247,210,196,220,108,135,196,220,34,167,204,115,227,178,101,149,94,170,139,162,178,68,131,68,224,235,226,152,
87,143,114,196,225,136,205,104,27,135,35,118,81,19,135,67,250,65,111,13,229,84,143,8,199,53,225,56,164,103,114,204,10,93,199,6,229,16,240,101,121,175,125,241,248,136,94,95,103,138,199,75,156,9,79,23,252,12,22,164,112,122,23,56,254,29,249,24,154,94,106,107,56,47,219,72,168,206,152,76,226,186,108,248,69,124,135,103,250,240,244,254,126,127,150,177,238,190,236,247,48,67,60,140,121,189,83,12,200,106,150,138,64,158,125,223,147,69,43,31,231,8,231,57,156,68,117,196,165,253,44,65,189,248,18,60,254,186,124,38,147,229,11,149,224,62,83,25,36,30,74,89,125,210,205,94,186,218,203,72,200,34,129,190,86,95,164,182,146,85,159,111,42,37,78,8,17,63,18,137,248,55,244,103,135,142,4,253,168,187,243,217,63,137,251,115,63,75,220,79,245,49,179,240,127,140,251,255,107,38,245,159,254,50,149,138,108,236,127,69,236,31,17,251,95,217,216,63,178,177,255,149,141,253,35,98,255,43,98,255,200,198,254,87,196,254,17,177,63,164,119,17,177,255,21,177,127,68,236,15,183,196,254,145,45,127,32,73,202,31,17,229,15,24,250,
17,73,151,43,114,105,17,193,188,48,70,148,63,174,40,127,68,1,127,41,127,68,182,252,1,203,94,68,104,14,73,202,31,145,45,127,92,217,136,60,34,34,191,34,34,143,108,249,131,225,110,68,58,13,210,113,68,12,126,69,12,30,81,254,128,91,202,31,145,45,127,32,105,24,17,119,95,17,119,71,148,63,208,224,71,68,220,208,71,17,225,54,116,41,127,68,196,218,8,88,96,174,82,254,96,110,65,68,249,3,146,138,136,174,145,249,62,34,180,134,91,202,31,145,45,127,32,171,73,68,29,217,242,199,21,229,15,52,204,67,125,29,81,254,64,131,148,63,34,162,104,134,231,34,91,254,96,49,188,136,242,7,36,63,34,110,70,226,59,22,39,15,119,128,123,31,217,242,7,178,154,17,129,50,178,148,232,179,229,15,120,95,71,148,63,160,74,249,3,170,148,63,160,218,242,7,99,165,252,193,216,205,136,112,86,184,34,202,31,34,57,34,132,133,46,33,108,68,249,3,82,58,146,242,199,149,148,63,162,105,249,131,73,75,249,35,162,252,193,22,141,17,39,229,15,134,117,35,202,31,244,186,17,177,36,19,240,35,202,31,176,140,34,202,31,136,144,242,71,100,203,31,180,164,
252,17,121,173,117,24,211,17,177,34,140,169,136,88,145,118,38,178,177,34,164,229,136,88,17,146,148,63,34,98,68,6,110,99,210,79,252,29,70,126,227,2,181,231,145,223,150,191,223,68,148,63,152,77,46,34,234,163,237,68,148,63,104,231,35,162,61,218,51,17,209,158,237,223,93,163,157,141,136,242,104,223,137,40,127,208,206,68,68,119,180,231,34,202,31,180,83,17,81,157,237,127,178,66,27,121,7,91,180,145,183,246,148,54,219,187,187,68,251,110,68,36,103,219,165,135,83,126,209,63,27,81,254,160,157,141,136,220,104,35,175,180,77,27,251,86,138,180,145,183,189,74,155,205,92,223,179,253,137,62,250,23,197,62,236,169,74,191,19,17,157,209,198,222,77,177,135,254,167,139,182,191,40,243,67,255,239,150,108,191,43,246,96,223,250,116,190,155,210,143,254,207,166,246,239,172,216,254,231,178,203,232,223,145,126,228,217,242,7,180,17,59,242,152,45,60,136,8,177,88,118,21,17,92,77,183,48,199,154,75,249,35,178,229,15,184,107,17,94,9,119,66,35,34,160,226,75,150,128,138,173,147,242,7,99,164,252,17,217,242,135,61,20,
117,185,3,222,112,40,30,209,219,137,8,150,144,40,229,143,200,150,63,144,244,54,34,56,130,219,143,8,142,174,8,142,34,130,35,232,65,114,116,146,242,7,99,62,68,148,63,144,177,23,17,19,33,83,98,162,200,150,63,176,170,31,17,8,49,47,41,127,240,129,141,56,248,115,145,45,127,92,17,253,68,148,63,32,113,214,7,179,28,240,87,156,253,5,184,165,252,17,217,242,199,21,229,143,136,64,7,89,131,136,16,135,118,39,162,252,1,215,73,68,249,3,186,132,53,145,45,127,136,254,136,242,7,178,155,17,229,15,218,195,136,242,7,109,15,39,59,178,229,15,86,71,202,31,145,45,127,48,51,41,127,68,182,252,65,223,48,162,252,113,69,249,35,162,252,193,72,41,127,176,42,82,254,144,217,51,79,177,166,137,227,31,217,242,7,90,70,104,201,195,43,229,143,72,37,229,15,36,5,17,229,15,36,73,249,131,91,85,202,31,240,74,249,35,178,229,15,228,140,185,78,23,225,105,71,184,210,172,65,45,194,121,102,118,195,233,172,153,157,124,154,82,254,96,172,148,63,34,91,254,160,213,140,240,131,147,21,161,252,129,172,17,55,77,154,177,82,254,136,108,249,
3,174,74,68,249,131,85,238,112,97,223,71,67,31,229,114,167,54,241,118,35,91,254,64,70,59,194,207,229,238,28,68,56,185,87,148,63,34,60,220,43,60,220,228,190,150,242,7,203,159,134,65,202,31,92,159,114,138,179,145,245,105,25,46,62,109,100,125,90,90,203,17,62,45,12,19,110,145,246,12,4,241,100,35,41,127,200,28,184,86,165,252,193,79,41,127,68,182,252,1,183,148,63,34,202,31,172,198,219,136,242,7,12,63,69,182,252,193,49,100,59,250,79,57,104,110,68,249,131,46,31,35,238,65,239,70,120,152,140,150,242,7,15,153,148,63,174,112,47,177,246,65,178,153,148,63,152,108,135,27,243,46,92,8,102,121,41,127,68,184,148,72,121,143,49,247,145,154,148,63,34,91,254,96,173,228,53,144,251,93,202,31,211,203,149,171,159,242,7,180,115,68,75,249,3,169,237,8,159,15,146,148,63,34,91,254,224,145,144,242,71,132,171,199,43,151,230,225,147,242,7,15,95,39,162,252,1,169,207,11,41,15,95,16,225,217,193,45,229,15,206,128,148,63,144,36,229,143,233,195,123,17,73,249,3,219,106,66,192,57,67,225,73,68,249,3,97,131,136,242,7,236,
138,71,121,192,52,196,21,131,75,202,31,112,73,249,35,194,237,226,103,38,178,110,23,99,22,35,220,46,72,73,249,35,194,223,226,55,108,73,249,131,159,65,132,155,197,10,241,1,189,126,36,159,189,92,25,182,252,129,13,226,83,193,32,229,15,250,106,17,14,20,78,197,69,132,215,196,71,193,235,242,69,62,57,240,120,74,92,10,82,254,224,235,145,242,7,198,125,138,40,127,136,98,110,144,47,164,59,136,112,134,96,151,242,71,36,158,16,34,126,45,127,228,254,225,159,119,131,254,91,58,245,159,255,242,223,255,135,84,92,58,124,115,77,134,45,118,251,31,202,167,51,215,20,40,226,202,233,252,117,89,29,19,12,196,20,38,174,9,233,98,170,18,215,84,37,226,157,195,11,170,17,215,59,106,20,83,138,128,52,138,43,189,60,44,82,135,136,41,66,48,240,110,236,118,127,143,160,20,237,33,237,15,113,181,89,132,101,114,47,166,208,112,93,87,147,124,76,97,1,142,143,113,165,80,188,174,168,201,221,248,176,188,125,125,200,155,28,151,10,67,236,249,20,215,55,138,194,138,208,174,66,200,100,38,166,20,0,239,69,92,173,36,210,242,241,126,201,
197,130,201,114,92,44,110,94,23,213,36,23,215,90,135,215,53,53,97,54,245,50,242,39,247,99,242,247,140,62,143,43,170,38,138,156,184,218,240,177,229,239,227,253,234,152,193,119,226,74,61,160,99,62,174,30,189,33,25,79,215,133,204,179,214,24,34,104,62,38,241,142,21,75,177,187,51,66,30,109,183,79,59,31,147,114,167,223,137,247,27,239,201,182,35,72,178,237,49,217,118,100,229,226,106,253,156,60,187,172,10,169,132,184,210,184,128,154,134,250,37,164,92,188,127,244,21,3,178,113,237,240,2,25,185,152,20,58,51,70,102,146,66,135,244,85,76,254,28,22,242,231,185,216,38,207,17,32,201,243,152,228,121,178,178,36,207,153,49,99,15,142,25,59,23,187,237,55,208,179,113,185,37,43,206,168,142,232,156,141,73,149,95,111,169,229,184,242,98,148,180,203,181,87,244,207,196,174,26,192,127,47,46,53,190,100,188,19,23,15,78,145,55,23,151,54,206,105,231,226,194,222,197,53,137,202,184,72,206,149,156,182,172,174,138,73,99,95,219,52,118,188,81,191,184,38,135,29,111,169,183,133,147,60,42,36,123,29,23,123,23,112,166,227,
210,224,219,245,134,131,160,115,82,128,113,169,254,218,234,56,20,155,179,113,161,121,138,236,108,188,213,29,51,48,23,111,148,207,145,53,19,111,97,59,105,227,184,208,57,167,127,38,46,214,222,194,239,112,66,63,144,6,70,196,32,38,241,139,217,95,145,244,136,55,220,239,24,197,25,83,99,247,236,14,147,26,51,153,52,189,67,89,143,226,254,5,73,88,134,75,18,54,222,106,95,32,217,97,86,35,59,171,157,33,93,249,120,235,64,44,152,137,11,141,87,208,243,113,177,42,246,47,196,207,119,254,92,187,126,174,254,29,74,222,160,36,19,111,177,133,98,106,161,221,135,241,78,188,81,249,10,58,83,224,240,16,150,196,133,214,39,232,78,188,94,254,211,15,215,235,106,50,138,159,53,138,215,207,212,100,62,38,173,137,113,223,197,165,163,6,83,224,0,110,123,91,215,219,114,52,55,97,217,148,83,187,94,45,202,160,123,136,27,32,110,54,222,244,190,165,39,21,111,157,142,182,187,178,186,99,82,144,113,241,232,156,164,35,6,74,210,49,46,55,92,228,242,37,237,45,51,233,92,92,174,174,209,190,67,123,137,246,221,184,188,191,110,251,11,
79,105,207,210,222,176,237,237,85,218,216,245,108,203,182,215,62,167,157,143,73,40,210,206,198,238,243,117,219,95,144,241,185,216,45,62,161,141,190,194,51,218,156,192,61,225,71,95,69,248,209,199,183,71,226,138,121,30,216,254,195,45,218,156,196,198,166,29,191,247,204,182,219,210,230,228,149,54,236,248,154,180,145,87,151,241,98,255,148,191,42,250,105,39,253,232,47,137,189,180,203,98,15,252,37,233,199,222,226,212,190,157,233,124,160,39,246,190,88,163,159,249,21,63,183,237,164,31,254,93,89,31,230,247,139,125,106,170,255,96,106,127,67,248,101,126,83,253,173,85,218,169,152,212,30,242,152,223,177,200,231,102,193,14,210,119,124,105,50,158,126,228,36,237,36,157,7,105,35,225,62,18,110,209,54,149,150,172,22,237,3,177,22,107,106,211,221,170,200,110,201,41,145,213,189,31,187,79,21,237,73,42,86,127,61,190,86,242,163,190,118,206,141,243,49,38,17,199,213,112,17,31,236,126,186,38,229,22,87,119,71,220,38,127,136,235,173,49,253,31,98,117,162,24,240,247,113,211,251,187,107,146,104,208,39,114,215,
166,99,164,52,232,153,197,210,119,200,230,254,172,75,34,140,193,231,113,225,116,150,211,37,89,48,206,190,124,19,179,113,137,155,77,110,4,210,94,215,47,248,251,188,124,74,174,139,175,129,92,23,95,54,247,70,114,95,180,229,91,230,224,215,2,14,254,66,76,126,11,65,78,188,177,55,89,225,203,248,24,111,212,198,252,117,232,56,166,131,47,135,143,157,236,85,188,170,58,220,33,204,107,195,21,198,201,227,184,184,83,65,212,100,49,46,239,189,34,23,197,50,156,38,47,79,235,156,28,20,86,142,99,18,80,76,121,76,226,41,174,15,191,118,125,135,121,145,58,78,197,237,110,202,245,171,76,42,23,147,123,186,230,129,141,109,238,9,6,201,61,197,228,158,24,201,229,158,228,158,16,54,205,61,197,73,238,105,254,154,88,69,246,176,236,145,248,151,13,248,109,140,75,2,181,193,51,33,153,168,235,219,76,84,124,155,137,186,190,205,68,197,184,39,215,184,39,113,146,137,186,127,77,6,70,172,114,119,83,199,190,139,85,143,99,156,22,168,157,216,230,165,224,149,188,84,140,235,114,77,94,42,182,121,41,228,77,243,82,241,109,94,10,189,
25,210,0,100,165,226,82,187,67,130,138,69,151,236,84,92,126,57,174,208,178,121,169,216,38,165,152,214,69,76,82,138,23,227,156,135,122,204,235,204,51,215,77,211,126,27,87,188,123,244,159,240,138,206,242,0,156,36,55,134,247,129,100,19,246,141,121,187,29,100,125,36,199,196,251,55,25,147,73,130,121,82,38,127,196,134,77,246,216,177,113,92,60,254,170,224,63,96,139,36,63,20,111,13,167,27,237,23,217,190,90,188,223,63,68,207,29,86,248,148,161,89,222,89,121,104,48,244,56,64,50,174,64,255,91,146,61,40,227,9,30,136,178,191,129,53,3,203,164,19,147,218,97,204,112,75,142,195,103,135,127,86,215,255,52,143,99,241,27,255,247,60,206,127,207,164,140,205,225,220,144,195,49,228,112,110,108,14,199,216,28,206,141,205,225,24,114,56,55,228,112,140,205,225,220,144,195,49,228,112,32,189,51,196,235,55,36,39,12,57,28,184,37,135,99,110,241,27,8,19,252,134,1,191,113,67,58,199,88,252,198,13,238,145,1,191,193,48,193,111,24,240,27,55,28,86,131,155,116,131,3,192,113,50,120,74,55,120,16,198,226,55,144,11,105,148,
191,1,191,97,44,126,131,222,145,1,191,113,115,139,223,48,65,130,223,184,97,189,12,248,141,27,60,102,206,145,177,248,13,168,121,3,126,227,134,92,184,177,248,13,24,166,248,13,115,139,223,96,17,166,248,13,67,182,232,134,108,145,177,248,13,76,78,25,240,27,168,115,141,197,111,208,43,248,13,67,238,232,134,220,145,177,248,141,155,91,252,134,185,197,111,160,73,240,27,134,60,210,13,121,36,99,241,27,152,34,248,13,67,54,9,134,161,177,248,13,24,166,248,13,67,78,9,193,11,172,189,224,55,88,161,180,33,183,196,154,7,198,226,55,232,21,252,134,33,195,132,218,115,99,241,27,72,152,226,55,204,45,126,3,93,83,252,134,185,197,111,220,88,252,6,214,204,211,253,218,88,252,6,166,76,241,27,134,204,19,98,115,6,231,27,255,143,21,116,88,168,121,54,205,51,22,191,65,175,224,55,12,121,40,148,126,105,44,126,3,9,83,252,134,185,197,111,160,75,240,27,198,226,55,100,19,44,126,195,220,226,55,216,120,199,128,223,64,144,224,55,140,197,111,192,57,197,111,48,73,193,111,176,65,75,198,226,55,224,20,252,134,193,153,132,154,
55,56,147,55,56,147,6,252,6,231,37,109,240,40,57,36,226,81,26,60,74,150,47,103,168,95,220,226,55,80,56,197,111,24,139,223,64,151,224,55,140,197,111,48,11,193,111,24,139,223,192,126,73,126,25,240,27,200,204,26,240,27,48,164,13,248,13,116,230,12,206,231,13,206,167,177,206,39,36,193,111,24,252,79,184,5,191,97,110,241,27,216,33,46,168,193,5,77,206,20,46,232,13,46,168,177,248,13,54,183,137,91,98,192,111,176,206,130,223,48,22,191,193,234,231,12,248,13,102,38,248,13,86,86,240,27,55,224,55,16,45,248,13,44,20,252,134,177,248,13,228,8,126,195,112,106,201,185,33,74,240,27,198,226,55,68,4,87,162,177,248,13,62,203,41,126,195,88,252,6,243,152,49,22,191,65,223,20,191,97,44,126,3,65,105,67,78,46,249,30,201,201,209,206,24,155,147,131,180,108,200,201,65,90,54,248,186,76,42,32,55,103,200,205,33,102,155,149,18,252,198,141,117,124,13,248,13,17,142,239,107,184,37,45,126,131,25,76,241,27,198,226,55,16,145,54,224,55,232,248,96,44,126,3,227,4,191,97,200,228,9,187,1,191,113,131,115,108,192,111,176,125,
121,67,70,15,58,95,218,250,3,218,240,237,166,25,226,24,240,27,208,179,134,204,30,244,59,6,252,6,210,179,6,252,6,244,140,33,195,7,125,206,128,223,184,193,169,54,224,55,160,167,12,153,62,203,255,100,133,181,22,252,134,177,248,13,168,104,91,123,10,151,224,55,140,197,111,64,189,107,200,250,65,205,161,107,150,49,119,12,248,141,169,12,177,121,214,128,223,64,199,140,1,191,1,61,107,200,2,90,93,165,71,216,228,24,240,27,208,177,125,165,40,210,141,197,111,48,13,193,111,96,249,158,229,78,240,27,28,33,193,111,24,50,131,80,153,71,245,33,39,37,99,192,111,32,131,99,178,249,4,58,243,222,148,121,192,247,52,125,131,187,111,64,8,88,254,226,50,116,108,254,221,82,34,213,226,55,16,33,248,13,116,77,87,51,193,111,160,75,240,27,134,172,33,188,216,181,179,194,88,138,118,44,103,130,223,152,82,69,34,154,18,252,6,19,146,208,193,88,252,6,203,225,24,240,27,48,242,10,230,140,197,111,112,86,5,191,97,44,126,131,243,35,248,13,99,241,27,156,42,193,111,24,139,223,224,200,76,241,27,230,22,191,129,172,154,33,221,200,
21,208,48,164,27,121,113,70,164,27,57,149,238,13,248,13,67,206,81,14,60,43,34,175,20,31,98,251,53,43,144,49,22,191,129,110,193,111,24,139,223,128,65,240,27,198,226,55,24,38,248,13,99,241,27,232,22,252,134,1,191,129,138,140,33,53,201,46,34,47,193,111,160,253,173,33,69,137,60,223,144,162,228,6,192,42,46,203,91,252,134,177,248,13,196,124,48,22,191,129,124,193,111,24,114,149,40,14,200,85,26,139,223,144,229,55,224,55,152,154,103,44,126,131,37,157,226,55,184,166,71,220,124,115,198,226,55,110,192,111,152,254,171,149,27,50,152,188,111,130,223,160,87,240,27,134,60,38,119,212,192,88,252,6,18,166,248,13,115,139,223,184,177,248,13,99,241,27,168,27,16,46,25,139,223,160,175,102,44,126,131,109,155,226,55,140,197,111,192,41,137,78,99,241,27,236,177,132,82,198,226,55,152,138,224,55,12,1,21,7,134,251,40,193,111,96,158,224,55,160,46,65,189,107,44,126,3,94,193,111,24,183,240,52,225,181,248,13,120,5,191,97,220,237,39,55,22,191,97,44,126,131,117,129,154,224,55,216,2,193,111,24,194,45,168,89,3,126,
131,165,118,12,248,13,36,205,27,240,27,208,115,198,226,55,228,89,32,248,130,250,12,42,119,239,94,22,238,188,1,191,145,232,37,8,131,142,117,9,126,3,217,130,223,48,132,98,9,183,197,111,96,138,224,55,152,229,38,84,230,158,224,55,176,85,240,27,56,25,155,76,70,240,27,28,12,193,111,88,185,53,225,69,95,130,223,64,165,224,55,12,33,90,66,181,248,13,214,82,240,27,166,92,123,194,146,103,12,248,13,122,177,188,180,106,101,148,101,38,41,99,241,27,178,186,201,188,139,66,117,140,197,111,96,133,224,55,12,248,13,204,20,252,134,177,248,13,187,22,9,126,195,10,221,73,51,59,193,111,152,114,130,223,128,202,226,29,230,24,38,248,13,238,133,37,132,57,6,252,70,34,223,61,216,68,6,107,145,224,55,126,153,34,193,157,181,173,117,47,177,25,252,6,220,41,67,144,103,185,19,252,6,36,193,111,24,66,61,168,14,15,153,204,155,55,52,193,111,160,81,240,27,166,156,4,124,194,107,72,58,115,96,5,191,97,192,111,64,18,211,4,191,193,217,21,252,134,177,251,4,53,193,111,176,114,130,223,96,229,214,100,56,185,105,99,241,27,104,99,
45,14,100,175,239,27,139,223,192,242,41,126,195,220,226,55,160,9,126,195,144,183,102,22,29,99,241,27,72,29,225,124,164,209,57,197,111,24,139,223,224,16,165,12,248,13,134,85,140,197,111,240,165,49,236,228,62,86,11,126,195,88,252,6,35,167,248,13,115,139,223,64,129,224,55,12,121,109,156,182,19,99,241,27,55,22,191,97,200,110,223,144,221,198,175,20,252,6,210,4,191,97,44,126,3,246,41,126,131,91,78,240,27,24,152,53,54,215,141,84,201,117,27,155,235,166,181,108,200,117,203,137,34,80,229,237,127,199,74,164,56,81,51,116,73,214,91,252,31,139,223,192,249,57,55,224,55,152,204,20,191,193,21,43,248,13,62,102,193,111,152,163,4,191,193,117,38,248,13,99,241,27,55,192,52,240,182,4,191,129,14,193,111,24,98,90,110,89,193,111,24,139,223,176,175,45,26,45,126,195,88,252,6,55,165,224,55,140,197,111,112,159,240,66,37,248,13,20,8,126,195,144,78,231,58,116,141,197,111,96,149,224,55,96,23,252,6,60,130,223,48,133,4,191,129,230,62,17,176,177,248,13,214,90,240,27,236,221,3,14,246,208,88,252,6,84,193,111,224,
25,221,133,125,204,59,35,248,13,228,8,126,195,144,108,71,193,123,220,90,193,111,160,150,124,251,158,33,102,230,188,12,13,248,13,27,139,252,130,223,96,169,4,191,97,8,159,111,192,111,112,255,230,217,33,193,111,24,240,27,28,129,129,177,248,13,190,111,193,111,24,98,104,132,250,28,34,193,111,64,149,24,218,16,67,51,124,222,216,24,26,161,211,24,26,211,5,191,129,238,223,114,170,196,59,105,224,71,75,212,140,150,41,126,195,220,70,205,120,220,83,252,134,33,106,38,2,73,19,159,8,126,131,157,126,108,136,147,137,79,58,198,198,201,244,74,156,140,207,46,241,137,111,108,156,140,132,105,156,204,135,56,197,111,160,169,75,136,54,207,230,77,241,27,134,208,214,226,55,48,104,138,223,48,183,248,13,172,191,48,132,202,56,183,130,223,32,126,19,252,6,193,153,99,8,152,161,166,12,37,2,70,158,152,32,193,111,96,149,224,55,8,113,4,191,193,250,78,241,27,198,77,240,27,108,135,20,13,68,14,122,153,202,152,200,78,240,27,172,10,209,224,20,191,65,172,32,248,13,196,102,140,45,36,32,118,209,80,72,128,244,131,33,234,198,
46,193,111,24,234,9,144,4,191,193,161,153,226,55,32,8,126,195,80,88,224,76,16,189,38,248,13,206,132,103,192,111,96,65,10,167,119,129,227,47,241,185,177,248,13,217,70,106,13,140,201,36,174,11,248,13,124,135,103,198,226,55,24,43,248,13,78,65,134,120,56,197,206,158,98,64,214,224,133,83,137,96,223,5,191,97,44,126,131,195,41,248,13,22,89,240,27,226,75,240,248,27,66,122,251,133,254,130,223,16,51,192,111,24,139,223,144,144,69,42,21,198,226,55,16,62,197,111,24,74,22,72,20,252,134,153,226,55,80,55,197,111,252,47,1,0,0,0,255,255,3,0,217,12,151,244);


programfile__CUM_ON_FEEL_THE_NOISE_MID
:array[0..1303] of byte=(
120,1,236,87,221,79,27,71,16,159,108,40,165,180,141,20,201,170,42,229,122,28,9,178,34,144,107,64,46,132,117,101,93,176,40,20,25,140,109,74,233,35,237,89,33,74,50,68,182,65,65,170,28,29,110,165,170,79,109,42,85,234,75,223,250,208,183,124,60,229,173,31,79,253,83,250,87,184,51,187,94,251,28,31,228,64,49,80,181,15,12,227,223,206,206,206,238,254,102,102,111,101,125,219,3,128,65,184,64,127,15,86,214,43,119,232,215,67,104,110,14,12,136,119,135,160,249,153,160,223,205,194,197,193,111,175,64,115,112,40,251,201,74,126,245,163,133,5,210,103,179,59,247,247,43,183,111,109,215,156,95,157,169,185,185,15,156,15,75,59,120,203,185,185,91,219,222,169,56,171,91,247,202,153,183,111,222,189,235,20,217,166,234,20,203,213,114,101,175,236,209,212,43,139,101,44,87,182,106,101,207,249,124,223,89,221,169,149,63,221,169,212,182,247,157,169,247,39,161,153,4,29,198,208,29,104,142,94,160,213,47,14,46,238,222,174,109,85,224,55,27,30,191,254,16,30,15,187,240,221,4,194,52,250,197,105,128,9,176,167,17,230,16,50,
232,59,25,128,57,128,105,136,37,17,102,16,210,216,168,167,1,102,0,146,96,159,96,74,2,33,197,190,37,57,77,1,36,64,156,45,98,54,42,205,62,197,249,64,60,19,79,204,196,115,54,136,186,98,169,72,33,250,161,27,86,73,67,42,17,134,200,36,132,226,154,145,71,207,125,185,205,117,197,201,52,178,31,226,228,117,16,97,136,60,4,103,62,255,187,230,154,140,243,139,38,9,117,38,195,44,229,251,44,39,59,149,128,54,239,26,117,67,69,251,196,19,251,193,156,160,207,48,206,244,222,123,191,89,164,25,194,50,64,9,226,82,7,215,122,239,104,47,114,92,203,19,95,205,137,39,170,152,193,69,233,2,168,196,209,187,62,51,196,212,201,243,82,201,21,63,77,63,29,87,205,213,161,204,26,135,24,85,151,36,181,209,36,151,154,70,61,154,93,119,175,61,212,157,61,137,156,197,69,202,226,73,176,41,45,90,63,168,89,171,139,246,139,170,233,118,123,155,70,143,250,187,57,191,64,203,63,30,116,112,201,20,138,206,147,67,228,204,147,227,205,92,121,203,115,90,239,142,223,223,131,39,244,238,120,50,236,254,226,126,159,66,153,226,148,33,153,9,232,
199,69,26,241,25,58,212,25,104,204,235,255,223,108,164,208,75,129,255,150,250,23,83,114,45,176,202,87,118,183,253,163,122,9,189,18,196,74,120,48,94,2,81,194,61,146,5,180,10,32,242,104,229,89,151,74,151,164,175,162,181,106,112,173,231,208,202,49,46,21,222,177,209,30,122,237,143,139,27,255,188,174,209,121,45,173,47,163,181,12,98,153,110,126,25,252,119,50,72,73,32,84,106,138,44,202,44,136,69,244,99,139,32,50,104,209,192,34,90,164,47,161,181,100,244,5,180,22,88,151,132,231,241,224,82,30,108,109,164,253,106,221,24,241,228,94,61,139,22,173,179,128,155,228,72,143,234,149,231,209,154,7,138,130,71,181,238,162,229,118,116,42,31,20,41,35,58,184,52,90,105,163,27,220,191,79,204,106,63,99,197,85,195,169,129,249,173,106,21,254,184,10,79,137,76,79,135,221,31,221,71,113,244,226,16,139,46,71,80,142,128,136,46,175,161,188,6,34,186,180,80,90,32,250,39,71,233,202,71,193,30,161,206,61,194,251,110,212,227,96,135,130,209,247,168,45,163,239,81,91,246,111,143,218,115,232,166,194,192,0,83,70,12,83,6,115,
244,101,245,69,21,254,188,1,207,136,43,207,134,221,159,31,252,80,66,169,82,156,211,250,104,189,119,84,213,138,181,28,74,74,250,13,244,54,184,110,112,245,48,69,194,119,242,208,184,161,231,173,211,29,173,131,29,52,40,208,125,21,224,192,61,194,160,81,47,80,42,247,174,172,87,232,197,117,193,210,184,142,78,235,253,137,142,195,247,151,242,200,133,78,203,2,110,182,75,101,142,182,151,131,53,83,67,247,212,1,251,78,137,166,152,0,249,232,75,100,166,206,204,43,240,249,49,148,199,61,242,168,231,127,237,25,227,16,51,62,224,131,47,201,67,177,4,118,1,131,30,120,200,95,50,231,196,183,210,190,129,150,181,95,44,4,10,202,27,127,27,154,188,230,85,118,239,85,225,175,203,240,156,88,242,156,62,139,127,26,107,247,208,49,176,233,199,28,197,76,207,230,49,136,169,145,70,157,90,173,30,105,181,218,80,179,143,199,128,62,159,228,68,36,121,121,150,63,173,35,26,71,119,219,101,153,64,47,1,49,45,147,168,95,198,44,19,40,213,55,185,30,181,148,206,50,137,22,141,106,153,192,14,62,129,150,218,20,75,51,151,61,104,159,
116,68,244,84,153,66,111,138,31,62,124,104,113,70,60,210,169,74,171,81,169,112,17,212,255,51,54,231,238,100,198,145,174,67,156,250,249,51,7,226,188,174,213,150,134,57,210,48,135,24,34,41,137,78,61,182,243,204,213,255,249,163,249,16,206,159,41,100,242,16,103,52,115,136,81,113,148,241,87,140,4,125,118,116,181,80,23,159,195,184,125,130,170,216,218,169,206,211,96,205,12,234,42,71,78,213,242,133,221,181,207,249,5,92,133,173,111,132,186,0,71,104,50,186,195,228,151,245,133,83,221,215,217,158,106,132,213,233,220,58,21,210,84,111,34,185,48,12,225,154,249,42,112,221,199,123,215,106,221,99,96,197,206,205,70,136,191,197,129,232,150,65,110,31,166,147,55,53,212,34,213,24,55,23,126,126,208,23,228,63,0,0,0,255,255,3,0,12,22,139,16);


programfile__Diva_mid
:array[0..5067] of byte=(
120,1,236,93,111,112,27,199,117,255,137,48,76,10,38,139,138,145,201,208,164,37,82,20,41,4,20,69,138,2,137,128,56,1,231,59,29,15,4,16,254,57,217,149,203,27,133,177,114,30,215,149,233,54,238,180,180,211,177,53,71,152,166,164,196,116,154,216,142,147,218,238,36,241,76,166,211,153,142,147,56,137,147,184,73,90,39,109,166,206,180,211,246,83,59,211,153,118,38,211,105,63,53,159,154,246,147,250,110,129,35,15,32,15,56,72,7,241,143,246,203,222,222,238,219,247,222,189,125,239,237,219,189,189,189,143,61,248,91,6,128,187,113,0,191,126,224,223,62,246,224,83,151,233,238,37,220,184,18,2,244,254,38,4,112,6,184,17,248,181,11,143,63,153,125,100,105,233,209,167,122,207,61,186,244,59,184,209,119,128,138,31,190,235,174,166,15,183,224,198,111,54,81,163,27,243,129,187,127,214,115,245,203,86,166,249,43,189,133,79,88,215,255,185,135,93,91,180,63,47,94,223,61,206,174,7,79,252,248,95,44,184,150,210,189,93,111,195,83,251,207,91,237,9,33,110,140,160,200,86,147,225,194,72,225,183,127,220,20,124,187,121,1,33,
241,192,61,87,238,210,141,194,231,194,159,19,166,131,163,58,50,198,192,40,58,51,104,18,16,17,150,88,137,190,58,151,65,155,128,240,40,140,228,116,112,68,135,106,12,140,160,83,69,83,18,145,228,18,43,209,87,31,87,17,24,65,40,137,133,196,116,112,88,135,98,12,12,163,83,65,83,2,145,196,18,43,33,76,10,218,18,8,15,195,136,79,7,135,116,200,198,192,16,58,101,52,197,17,137,47,177,18,194,36,35,48,132,80,28,11,19,211,193,168,14,201,24,136,162,83,66,211,4,34,19,75,172,132,128,36,4,162,8,77,96,229,253,251,28,172,119,9,104,203,160,187,58,235,93,73,180,169,232,174,206,122,87,2,109,10,186,171,179,222,21,71,155,140,238,234,172,119,77,160,77,66,119,85,214,115,2,144,65,235,40,194,85,88,207,37,1,21,173,35,8,87,97,61,151,0,20,180,14,35,92,133,245,92,28,144,209,58,132,112,21,214,115,19,128,132,214,40,194,54,235,47,206,79,32,24,181,74,87,254,113,249,237,103,174,108,234,218,65,50,129,109,149,254,249,192,95,158,8,126,163,249,73,91,215,240,31,159,252,163,136,97,62,24,193,74,235,205,94,251,168,125,31,181,
119,187,246,83,125,63,213,187,93,221,218,217,229,110,237,236,242,90,124,219,112,110,215,90,237,107,213,219,124,186,93,221,232,218,229,110,237,236,114,27,206,237,90,139,191,90,245,54,29,183,235,81,234,191,163,212,127,110,215,227,84,127,156,234,221,174,110,237,236,242,202,118,149,207,89,201,151,221,206,190,86,194,215,123,95,75,62,181,234,43,249,171,188,175,197,79,37,124,125,247,61,69,246,222,44,93,247,175,25,223,106,55,216,234,226,118,173,84,195,202,123,183,118,118,121,37,124,101,183,87,118,171,221,206,190,86,194,215,123,95,75,62,181,234,43,249,171,188,175,197,79,37,124,189,247,181,248,171,69,191,86,251,90,245,181,248,173,69,191,86,251,234,245,37,243,53,255,125,215,219,113,245,231,168,237,127,106,201,177,86,63,213,170,175,197,95,45,250,181,218,87,175,183,186,239,96,4,143,209,37,25,193,87,79,125,195,25,150,5,158,118,11,203,122,254,106,52,248,205,102,195,14,203,140,47,77,125,190,71,71,132,66,242,101,168,203,130,108,69,154,102,76,190,12,245,242,198,205,18,212,37,251,70,90,134,178,
44,72,86,172,105,198,164,37,40,75,219,222,136,203,132,80,16,173,104,211,140,137,75,144,151,74,55,167,123,128,8,2,71,117,208,52,64,93,70,118,89,80,129,44,65,169,151,145,189,188,113,179,132,236,146,125,163,44,35,179,44,40,86,164,108,198,148,37,100,150,182,189,41,127,2,7,211,167,143,2,67,8,244,233,160,249,73,102,25,249,101,33,3,228,9,89,230,50,242,151,55,110,150,144,95,178,111,202,89,115,114,163,58,111,92,89,59,221,7,12,35,208,175,131,38,78,146,142,188,142,243,250,171,98,78,63,156,199,218,221,57,180,208,188,166,31,160,152,254,60,174,190,219,198,251,160,212,33,13,239,131,151,144,211,143,228,177,126,206,209,1,225,28,204,127,120,206,209,7,150,138,48,69,37,253,37,131,96,186,82,170,182,44,195,82,154,242,234,175,45,124,211,105,127,205,191,225,102,127,227,239,247,7,191,181,105,127,201,95,8,95,72,94,44,140,39,113,68,158,54,71,100,164,229,11,159,21,101,204,37,47,20,206,38,17,21,180,194,188,128,246,164,86,24,76,34,77,151,243,73,28,78,76,155,241,4,70,18,218,245,161,4,214,91,18,212,62,129,35,
18,181,151,144,150,168,189,132,185,4,181,79,32,74,45,230,147,104,79,80,251,4,210,116,57,159,192,225,56,181,143,99,36,78,237,227,212,222,59,253,82,123,162,20,151,48,34,81,123,201,141,190,68,244,37,68,101,162,47,163,93,34,250,22,111,68,95,194,97,145,218,139,24,17,169,189,136,171,147,241,25,115,33,78,51,238,7,77,33,129,225,228,5,115,36,137,148,176,184,10,1,51,130,94,80,5,226,88,51,181,56,122,19,23,204,7,8,68,208,205,132,128,184,96,20,210,2,70,147,250,243,66,18,133,3,130,102,10,2,198,82,154,25,75,97,76,92,184,174,137,120,88,212,76,69,196,176,164,153,115,18,6,68,189,112,66,68,42,245,224,234,227,41,152,57,81,55,143,137,152,146,116,115,88,66,74,54,214,243,36,120,249,226,213,103,100,68,37,125,165,67,130,38,26,43,39,69,156,147,244,151,122,233,81,231,229,75,102,74,70,130,208,145,0,4,249,162,41,203,136,73,139,133,123,37,76,137,139,171,195,34,122,100,221,76,202,16,8,105,66,66,92,94,180,26,140,75,151,10,103,72,98,4,210,47,162,79,210,11,125,18,38,197,75,228,26,145,74,235,133,123,211,36,27,
227,11,33,9,230,156,66,36,20,36,100,34,65,104,20,34,161,32,38,19,9,153,56,37,18,18,122,20,34,161,16,121,34,33,35,174,16,9,5,227,50,145,144,169,83,136,132,132,62,153,72,200,152,148,136,4,61,26,61,247,189,34,169,22,145,32,127,252,144,247,14,175,67,225,120,135,239,186,14,159,147,141,194,253,50,100,201,120,41,77,170,21,221,23,218,59,151,50,214,199,83,200,144,245,159,33,115,79,234,215,218,147,88,57,40,94,90,121,74,196,225,148,246,80,10,33,193,184,214,41,160,47,165,155,114,10,253,194,197,194,57,242,33,201,197,107,119,19,228,253,178,177,242,113,25,97,201,32,143,208,43,26,215,255,144,92,17,149,61,34,35,36,233,139,18,186,200,47,25,34,25,185,254,82,187,132,127,126,98,79,75,109,15,171,128,57,65,14,76,214,87,14,202,248,106,231,183,156,163,107,120,194,109,116,157,126,167,183,41,248,147,193,224,59,205,15,225,158,43,65,221,248,69,228,229,216,180,28,195,120,76,211,98,24,220,139,249,196,180,156,192,120,66,211,18,24,108,68,62,57,45,39,49,158,212,180,36,6,27,145,111,4,207,78,156,141,224,217,137,
179,209,58,227,164,213,136,124,163,249,111,52,126,103,95,55,34,223,8,153,59,113,54,130,103,39,78,39,173,70,228,27,221,191,141,198,239,148,85,35,242,241,105,57,142,241,184,70,19,148,193,70,228,133,105,89,192,184,160,105,2,6,27,145,111,4,207,78,156,245,242,92,175,14,215,219,167,78,222,188,228,235,229,103,151,193,255,239,158,12,122,156,78,161,222,14,174,23,190,209,29,86,47,63,245,194,55,154,127,103,95,236,197,124,189,242,172,23,222,139,19,185,21,152,122,29,104,189,240,183,194,155,151,182,245,242,83,175,62,55,186,191,234,229,103,151,193,175,254,89,246,29,231,236,57,241,172,219,236,249,177,159,206,7,191,221,28,47,206,156,11,63,15,191,34,210,107,33,122,75,99,189,189,40,190,190,41,174,133,11,226,60,228,179,80,231,145,87,203,203,207,178,114,21,249,179,229,229,126,225,89,132,188,8,117,17,249,197,114,252,83,144,115,80,207,54,140,110,163,249,87,247,56,255,251,87,254,10,189,49,180,245,159,189,129,164,119,65,150,254,43,103,145,177,245,127,179,252,44,43,183,245,127,179,156,182,69,250,130,103,
17,202,34,50,182,254,111,226,159,130,146,67,198,214,255,205,114,191,232,250,133,199,141,127,117,123,254,211,236,213,41,137,46,167,11,105,107,251,33,189,117,70,14,66,122,30,18,137,122,30,57,181,188,252,44,43,87,145,59,91,94,238,23,158,69,72,236,17,114,139,229,248,167,32,229,172,174,111,20,221,70,243,175,110,207,63,249,127,127,244,214,47,60,110,250,179,79,245,159,203,159,237,211,16,124,147,131,155,254,184,248,31,30,255,176,189,15,150,252,253,137,3,221,226,55,30,255,88,123,76,4,113,167,226,231,237,229,111,254,210,191,158,111,180,6,237,223,8,212,31,203,227,242,47,90,88,253,30,136,71,64,150,103,106,116,4,231,50,2,243,25,64,105,198,195,103,0,182,253,222,81,51,96,223,236,174,209,246,187,127,103,96,124,252,45,250,127,127,228,80,231,248,203,253,255,142,251,127,127,250,157,199,159,246,248,181,253,27,140,237,103,96,124,254,101,191,113,106,180,254,184,203,159,199,255,60,254,223,124,243,192,223,0,20,253,24,127,3,118,115,114,168,127,5,154,251,159,29,244,63,190,173,124,55,122,252,226,235,159,
69,123,220,169,21,244,253,41,127,243,125,30,129,238,124,4,202,103,96,59,184,2,193,87,224,118,246,29,60,95,1,218,241,21,32,30,129,238,108,4,202,229,191,179,242,231,227,239,14,142,191,220,255,239,184,255,231,250,191,131,250,207,87,32,118,124,15,34,31,127,119,112,252,229,254,127,199,253,63,215,255,29,212,127,190,254,176,179,235,15,183,48,254,142,209,249,151,108,240,162,83,215,222,58,244,109,231,71,152,67,247,185,124,132,185,138,191,78,7,191,211,60,87,250,8,243,131,63,120,213,98,64,133,170,102,216,105,154,132,112,84,60,3,249,12,212,51,142,18,122,125,77,31,106,86,135,241,130,199,11,140,95,180,188,224,241,2,227,23,207,126,209,242,139,31,255,240,40,42,50,76,55,104,40,201,48,253,81,206,32,195,244,167,84,66,219,111,233,3,197,234,48,180,133,176,38,30,47,48,126,209,242,130,199,3,140,21,96,48,251,42,126,97,72,246,149,62,3,137,217,215,102,9,125,32,199,236,107,179,228,230,96,188,208,242,2,227,133,31,159,240,88,3,80,205,126,247,32,103,79,120,110,39,45,47,60,123,129,241,139,103,191,104,249,197,
143,127,120,248,248,85,109,236,246,203,207,239,207,241,203,252,229,40,143,128,124,136,236,188,104,135,23,24,47,218,234,5,198,47,90,222,240,240,17,140,60,144,91,244,199,35,32,178,175,42,145,157,167,200,101,191,142,222,126,61,151,23,60,94,96,188,68,37,94,96,252,162,229,13,15,143,128,170,68,64,220,255,212,244,63,92,127,170,232,143,111,241,161,183,88,162,118,95,240,248,167,250,74,146,55,159,233,79,204,230,129,22,247,63,53,253,143,63,125,225,101,92,246,2,227,161,79,125,139,217,246,34,173,221,38,195,219,233,15,111,39,45,47,227,133,23,24,191,120,246,139,150,95,252,248,131,199,124,159,175,0,249,241,110,207,139,118,120,129,241,210,171,94,96,252,162,229,13,15,31,193,248,10,208,77,191,219,243,45,154,240,50,50,123,129,217,139,81,137,23,158,189,192,120,145,143,23,24,191,104,121,195,83,123,214,232,205,143,213,198,179,219,124,175,135,231,226,51,176,154,51,176,218,253,238,65,206,158,86,74,246,160,254,120,122,46,47,242,241,2,227,69,62,94,96,252,162,229,13,15,143,127,120,252,195,227,159,155,217,
247,230,109,124,247,199,190,252,162,181,219,227,31,51,34,86,186,173,183,142,124,199,185,67,54,160,185,237,144,237,250,155,15,5,191,219,44,108,252,194,126,229,159,102,190,152,160,7,46,253,97,97,237,163,10,90,232,38,171,99,70,111,205,32,64,63,92,63,158,69,40,1,204,234,129,56,121,102,6,152,213,195,51,8,42,88,59,169,234,225,12,214,238,155,165,223,76,91,127,162,15,140,150,16,133,85,172,157,146,17,216,6,215,104,117,92,244,175,230,224,22,116,68,221,194,120,154,254,7,175,234,135,70,17,32,162,39,233,135,244,140,239,67,35,8,80,229,201,33,139,189,67,244,227,120,98,236,254,89,4,233,167,180,197,255,199,211,79,88,102,244,166,12,194,67,88,127,52,143,80,78,95,255,212,8,251,37,2,237,48,158,193,33,250,131,249,127,63,199,165,96,73,193,150,41,253,181,102,237,152,130,35,219,244,223,112,141,254,155,69,23,211,5,75,99,42,213,97,140,117,153,67,187,130,163,88,187,119,22,33,210,177,45,10,214,52,198,186,178,164,99,181,245,130,180,182,164,26,71,179,104,179,159,196,161,29,164,58,76,59,10,249,168,165,17,225,
89,52,15,161,144,29,177,116,227,112,20,235,159,40,234,198,99,42,41,142,165,21,129,25,172,188,255,204,119,157,150,213,252,184,155,101,141,253,236,76,240,93,218,123,30,18,15,220,115,229,46,221,120,237,200,107,49,102,47,170,190,58,71,27,96,21,125,84,181,116,114,181,219,10,184,244,41,201,122,184,66,39,217,20,169,103,86,239,137,225,8,123,77,183,218,193,148,122,52,139,160,74,192,236,251,193,41,197,210,248,66,39,233,40,251,161,74,79,156,126,121,111,237,143,95,237,96,141,71,243,8,102,8,152,181,156,82,17,200,18,112,146,246,176,50,228,121,189,135,126,113,207,54,176,188,122,48,167,71,243,120,225,211,68,93,69,147,172,133,68,45,160,106,93,57,188,177,32,105,109,138,214,148,68,64,208,58,232,31,207,42,214,245,164,214,33,96,45,154,214,58,68,188,240,180,132,110,5,65,6,22,20,52,136,90,71,18,161,52,137,45,169,129,64,4,64,196,250,12,149,201,90,155,170,5,169,148,64,36,180,164,209,172,96,61,77,21,146,214,158,212,186,101,172,13,164,181,20,161,188,108,73,164,196,67,43,253,61,154,33,195,250,147,54,141,
186,249,40,177,59,64,184,175,148,51,18,38,46,36,132,21,188,113,78,69,75,18,205,50,218,69,252,202,96,92,130,152,200,91,130,8,206,106,47,199,50,218,36,73,54,170,106,227,150,204,69,139,109,146,76,241,145,145,177,158,26,36,159,89,75,130,235,15,179,103,135,170,33,167,53,231,17,102,66,160,125,226,235,31,45,74,139,201,9,69,4,25,13,121,214,154,182,203,144,227,201,97,117,92,214,226,164,4,31,81,52,250,25,253,245,199,100,141,122,169,32,177,187,231,47,137,104,207,163,99,131,63,129,232,105,193,188,134,89,237,176,130,38,58,85,141,124,160,156,209,14,145,235,235,80,181,14,162,121,94,68,75,30,212,133,65,81,107,73,106,161,89,172,63,65,60,62,77,170,98,63,194,64,178,158,110,189,51,197,249,194,211,138,214,154,214,72,102,237,172,95,59,242,228,241,44,113,183,48,3,93,159,19,181,162,194,180,204,106,193,52,90,201,40,114,104,145,72,25,72,109,82,25,109,213,216,84,29,210,21,91,244,100,13,150,246,120,82,157,14,133,126,196,110,217,207,237,82,29,61,143,102,226,149,61,96,59,249,69,21,191,250,212,238,115,95,235,
211,57,189,59,79,190,132,60,180,100,105,185,211,112,67,57,188,28,45,179,221,54,114,1,91,205,215,83,7,144,137,181,222,150,14,216,5,202,214,152,103,221,112,82,166,53,76,48,197,106,35,119,239,112,105,214,32,145,215,204,143,151,87,127,109,234,93,231,128,59,245,144,219,128,59,247,189,230,43,246,104,43,92,27,250,82,212,160,49,156,134,246,135,182,92,222,206,71,34,66,4,66,100,136,165,49,150,158,118,228,227,44,63,233,72,69,150,47,166,18,203,103,28,37,206,218,82,121,60,130,96,68,220,146,78,59,74,138,249,140,163,228,172,35,95,108,187,21,126,43,206,173,37,78,204,78,12,110,144,78,90,22,255,232,22,208,175,33,42,98,98,16,137,185,177,40,48,1,36,16,234,6,250,33,76,12,142,77,96,234,84,26,19,39,198,78,89,85,83,19,131,145,147,225,208,4,34,39,113,196,209,182,216,144,183,42,74,146,75,131,235,6,183,20,238,55,184,63,188,253,254,240,38,71,177,19,210,86,86,113,162,145,35,32,167,216,136,184,130,75,149,75,149,69,179,117,199,96,92,115,184,230,220,33,154,83,156,232,217,179,60,51,118,42,77,179,187,39,79,134,
199,28,147,58,178,159,98,248,194,171,185,88,162,34,87,135,189,102,37,55,191,162,195,71,66,62,18,222,33,35,33,45,112,178,37,207,58,102,234,220,58,184,117,144,117,148,199,80,111,156,115,44,134,243,37,8,215,151,5,220,120,184,241,240,161,197,237,85,26,183,14,110,29,119,136,117,148,15,159,124,141,129,175,49,240,53,6,236,55,51,224,75,16,213,54,206,240,209,158,143,246,119,200,104,207,151,89,182,221,58,199,61,0,247,0,204,3,240,21,35,190,98,68,193,146,115,45,154,111,62,186,213,45,198,220,187,114,239,74,222,181,124,165,161,230,66,125,167,181,227,189,180,152,207,246,189,151,189,31,98,181,21,138,101,237,18,100,229,209,77,248,41,218,84,207,10,67,180,139,222,17,228,77,21,33,173,45,247,155,192,22,76,177,124,43,230,50,60,155,77,202,240,59,94,61,56,61,72,9,39,127,22,135,168,203,228,198,251,101,2,33,210,222,91,209,177,232,49,75,207,153,141,184,90,77,180,111,19,102,171,134,59,49,84,244,148,163,97,165,29,57,91,109,181,38,71,195,169,173,20,45,248,77,182,25,230,114,203,114,52,183,106,221,236,203,129,
100,159,63,123,36,66,187,163,169,151,139,175,201,193,190,168,34,25,90,37,86,62,70,222,204,206,159,70,180,207,206,83,57,107,101,193,196,29,240,147,14,120,202,111,192,139,14,120,202,111,224,167,189,217,27,248,51,30,224,169,109,53,248,224,254,253,98,203,140,177,129,196,76,57,124,155,153,170,179,204,161,239,91,39,38,123,138,2,233,109,241,187,54,199,71,109,69,237,101,223,244,197,74,99,180,165,159,165,175,2,173,40,156,188,34,211,88,6,51,233,128,41,126,39,104,125,43,103,195,20,191,7,148,28,48,165,175,2,183,192,80,43,43,72,96,152,75,48,177,8,90,238,228,47,7,43,60,51,251,228,144,79,123,248,180,199,138,192,171,79,93,184,230,84,151,143,195,251,243,157,109,101,95,43,115,205,225,154,179,67,214,177,53,150,242,244,125,61,215,88,174,177,59,164,177,52,143,163,51,31,248,8,194,71,16,58,12,100,87,71,230,229,139,188,102,172,56,133,165,82,251,35,183,183,126,255,123,206,195,101,90,126,226,118,184,140,241,183,167,131,223,223,60,95,198,120,173,253,203,71,117,244,46,141,29,69,168,23,235,231,60,221,28,
238,149,230,122,129,82,26,99,249,8,75,123,119,40,45,82,255,8,163,30,101,233,16,75,79,178,116,216,145,158,98,249,17,150,142,178,244,52,75,199,28,105,156,229,39,89,154,98,233,3,44,85,88,154,97,233,60,75,47,176,244,226,102,122,84,39,73,254,231,76,239,253,172,232,8,75,143,178,180,40,154,62,150,63,198,210,126,150,30,103,233,0,75,139,76,23,89,244,147,173,255,2,103,8,189,213,58,206,146,80,174,23,193,222,35,44,61,202,210,94,150,246,177,244,24,75,251,89,122,156,165,3,44,29,98,233,41,150,158,102,233,152,35,141,179,252,36,75,83,44,125,128,165,10,75,51,44,157,103,233,5,150,94,44,166,150,50,108,104,18,43,218,45,108,237,58,57,113,134,44,173,173,166,73,171,115,147,199,133,73,172,156,76,140,11,9,218,132,153,28,207,37,49,60,57,183,56,137,171,243,62,87,189,125,96,151,153,209,123,187,205,174,119,157,190,126,176,219,36,244,245,201,239,59,99,153,166,159,186,197,50,207,126,16,11,254,160,217,176,207,202,51,190,120,254,143,119,223,209,142,142,147,105,91,84,116,209,153,128,214,169,204,191,151,49,62,187,
156,53,232,140,105,243,217,140,209,157,197,218,135,85,163,135,14,62,61,149,55,232,52,193,235,159,158,49,226,121,20,148,188,209,58,131,130,154,53,250,242,248,76,83,198,8,103,177,110,100,141,78,130,148,178,64,222,88,155,152,49,66,121,188,57,53,67,88,199,27,130,85,165,227,40,21,235,136,79,118,112,178,196,110,178,154,117,136,182,200,14,209,110,147,173,74,100,181,48,29,93,201,206,206,214,172,179,179,79,209,169,217,236,100,80,251,200,108,207,45,233,68,228,46,106,92,68,155,215,168,253,27,151,232,204,107,73,11,170,90,136,142,131,125,194,58,206,88,91,127,156,117,118,64,66,7,157,56,27,103,39,17,143,111,119,12,241,182,103,16,175,210,73,181,189,254,158,65,108,31,226,57,77,71,3,179,158,166,211,135,205,255,123,248,7,78,101,198,138,139,50,191,208,241,243,209,224,123,205,11,27,202,124,253,95,213,215,99,70,83,100,33,36,26,175,31,139,33,17,177,206,245,53,15,14,47,64,49,2,9,227,197,193,97,76,39,208,164,192,12,141,44,52,37,13,168,198,139,203,35,104,162,83,146,147,120,54,97,180,42,70,120,120,225,
245,15,37,144,83,208,60,140,63,13,189,87,198,201,39,221,56,201,252,221,72,240,135,142,41,194,43,169,55,135,140,213,39,135,112,173,125,200,48,127,119,76,47,60,55,4,186,210,253,48,149,15,99,237,216,48,149,71,169,124,152,202,163,248,204,43,163,63,44,35,37,184,145,122,228,239,151,131,63,114,144,186,250,218,163,127,34,139,215,210,50,10,127,17,249,81,17,199,255,11,0,0,0,255,255,3,0,118,64,115,201);


programfile__Classical_MID
:array[0..15049] of byte=(
120,1,116,156,91,108,220,89,158,215,221,221,153,233,102,232,221,94,13,35,24,70,116,122,38,27,28,59,238,120,188,118,28,183,157,82,217,149,74,85,170,171,92,46,219,113,156,216,202,197,137,226,164,147,109,122,122,153,69,42,33,33,181,115,103,95,232,248,146,248,133,23,36,158,144,16,176,11,59,143,92,23,30,16,66,2,30,17,15,160,21,143,60,241,178,15,195,231,251,253,253,78,37,158,89,158,78,157,115,126,247,219,57,231,127,142,221,93,251,226,238,208,208,208,119,135,222,25,250,222,208,255,233,174,253,205,223,165,247,143,135,126,121,237,216,177,119,127,248,193,208,47,87,222,251,222,253,205,161,95,174,125,103,129,241,161,157,255,242,53,35,127,241,253,255,184,227,246,127,254,55,183,31,254,241,180,219,223,248,31,191,237,246,163,119,103,220,254,214,63,188,225,246,251,189,111,220,254,224,63,253,209,243,5,40,191,247,222,73,83,254,75,223,255,207,255,117,2,122,127,245,171,223,125,244,5,45,253,167,203,204,127,55,231,191,243,243,191,242,232,23,63,100,226,59,127,246,223,13,240,221,127,112,203,237,251,191,
247,119,220,126,240,183,79,14,253,242,167,67,33,245,119,254,239,208,47,223,251,78,243,203,191,245,251,219,67,255,242,243,161,127,242,254,141,157,255,189,240,109,123,115,231,235,111,218,11,67,223,174,222,30,249,102,149,118,229,250,200,55,43,234,223,143,126,111,243,163,111,122,244,151,238,127,244,205,18,109,143,214,253,159,183,232,191,247,109,239,122,159,126,255,219,206,118,255,155,14,243,237,245,17,211,107,93,27,249,166,69,191,121,115,228,155,38,109,3,186,13,218,58,253,58,237,5,250,23,212,191,182,236,126,131,113,205,55,161,19,240,253,232,67,79,253,250,229,192,107,223,8,250,237,235,59,103,205,168,183,89,9,129,0,144,128,237,171,1,176,130,0,82,100,229,6,128,250,177,118,163,242,205,26,237,234,173,212,12,4,105,178,142,36,235,158,31,137,121,56,216,18,16,178,37,238,102,127,59,250,189,59,129,215,187,33,205,177,204,205,62,140,251,223,174,222,217,249,33,136,31,188,49,33,132,69,168,187,49,242,77,151,182,3,33,155,40,85,232,108,69,191,139,138,154,239,49,47,130,221,77,36,54,194,253,202,81,4,
8,138,64,11,130,97,219,185,111,219,107,239,98,159,223,8,155,175,125,228,241,246,237,143,162,191,189,243,1,3,239,124,219,220,120,244,133,173,216,94,220,249,107,76,29,251,182,139,114,230,73,43,158,203,144,92,150,12,180,150,225,74,202,188,146,50,99,44,133,73,39,69,232,50,110,17,75,159,121,211,75,252,14,58,90,84,230,37,106,27,247,30,193,191,152,248,56,195,112,216,64,112,133,126,241,98,107,41,198,47,49,127,137,249,75,235,125,183,173,107,196,173,17,54,118,62,134,2,129,8,132,37,95,78,202,41,193,128,18,125,75,130,68,146,164,85,36,195,11,150,12,9,237,29,220,235,62,173,250,93,240,164,89,115,53,2,113,21,62,242,106,143,248,50,191,180,100,231,65,226,35,161,233,95,235,155,95,147,190,2,184,189,158,1,187,184,114,252,155,69,17,166,21,225,197,107,155,238,247,174,31,55,193,165,205,205,200,180,141,232,175,92,249,200,113,216,187,26,153,183,178,145,253,237,79,129,127,231,219,165,235,153,153,91,57,191,25,113,218,78,151,173,225,42,197,253,250,218,247,34,206,111,127,47,250,219,217,127,176,115,138,129,
247,190,93,189,249,131,8,252,219,63,136,192,199,34,214,52,45,187,142,111,157,40,88,206,137,68,223,137,146,137,177,138,165,220,135,161,18,167,71,12,201,66,81,34,72,20,74,133,18,165,125,115,231,19,76,244,206,183,61,36,21,192,10,129,239,76,195,148,38,64,80,188,157,121,173,13,162,182,69,212,46,97,115,23,33,124,102,196,204,241,94,233,227,51,33,54,175,134,205,91,216,94,62,111,108,68,49,169,95,223,116,177,233,221,8,211,174,34,128,25,34,169,37,70,3,251,20,13,29,205,189,232,119,16,204,177,81,36,95,68,117,249,112,9,134,22,40,77,52,208,228,94,16,110,221,216,180,0,107,87,143,135,205,215,63,10,19,226,67,251,100,59,251,15,178,79,181,181,137,183,183,153,63,70,21,62,30,2,110,29,183,128,197,5,171,15,131,126,15,75,73,224,213,7,253,128,163,38,89,145,235,36,124,111,225,234,160,250,127,255,127,81,253,191,219,187,243,179,237,31,255,206,208,191,186,56,244,79,223,127,48,244,146,144,252,122,135,88,125,217,234,244,119,176,211,203,230,237,202,14,177,250,178,177,85,217,161,24,191,233,223,201,254,86,159,
249,254,203,218,181,254,78,141,249,58,240,20,243,151,141,235,57,79,107,252,171,209,111,220,207,241,187,49,222,130,174,249,100,191,249,101,194,23,184,223,11,250,221,91,253,29,236,255,178,190,209,55,253,222,118,127,7,53,95,54,110,37,61,224,197,167,5,29,211,67,62,245,155,201,191,117,37,198,219,180,214,15,57,5,87,224,219,15,99,188,3,62,126,125,217,190,23,253,246,70,180,221,205,138,249,175,194,151,248,120,57,128,187,153,244,144,195,124,151,83,126,248,200,94,117,240,101,143,218,21,217,167,255,178,139,189,164,71,151,106,229,31,181,197,48,92,119,51,39,174,231,68,11,77,69,177,139,101,141,129,38,106,123,88,82,154,119,225,168,126,7,11,90,226,27,41,9,173,240,218,192,73,211,38,243,246,0,154,89,34,232,216,67,151,179,223,75,9,211,131,221,155,59,103,131,17,162,155,17,166,50,163,98,154,187,125,19,238,177,140,26,96,5,78,132,216,75,214,221,64,216,14,132,69,116,37,37,94,174,176,48,27,96,245,90,197,198,91,193,104,70,128,178,57,160,170,56,172,62,12,227,174,222,140,182,121,21,68,201,222,94,79,221,104,
109,101,56,104,124,69,86,52,165,27,17,14,221,194,154,86,172,187,200,44,202,139,184,211,125,224,186,184,161,69,56,217,72,24,81,70,90,196,104,49,159,240,72,166,254,34,248,30,47,198,167,181,196,132,155,232,254,26,191,251,73,31,62,166,159,97,181,8,188,233,224,12,203,147,116,7,227,41,119,15,203,152,126,246,187,201,167,71,56,107,124,133,214,250,50,174,126,129,111,34,255,17,39,67,199,78,126,208,15,167,195,207,97,8,158,211,244,62,134,243,192,239,241,163,182,176,243,53,222,59,30,172,105,37,226,160,191,177,74,255,131,151,139,87,143,135,10,119,98,126,121,189,191,195,254,224,37,21,213,170,94,98,143,178,195,130,252,178,69,220,88,247,116,218,37,188,238,241,116,94,27,219,58,5,145,81,112,151,128,247,252,90,244,123,232,98,27,144,74,18,164,67,120,41,192,187,224,171,223,198,7,194,47,129,223,133,142,225,208,209,137,0,158,233,131,39,250,131,132,41,54,6,78,244,151,31,84,172,64,47,109,185,204,184,20,234,21,31,167,175,58,36,138,233,22,185,87,83,110,98,199,114,3,103,61,160,163,126,3,58,78,180,171,89,
170,174,71,108,246,238,96,106,49,174,51,32,219,247,8,123,59,49,38,42,47,151,209,220,18,32,169,45,144,18,15,138,13,28,172,57,227,146,168,20,181,46,22,180,5,208,200,150,34,74,108,41,198,5,207,114,107,122,107,20,47,214,152,151,171,55,142,59,15,151,111,109,6,191,155,233,250,27,155,65,103,11,87,154,16,38,52,161,135,136,110,206,100,168,38,74,220,93,194,39,182,65,230,83,215,249,37,223,20,10,69,148,187,73,161,117,147,31,173,133,202,203,30,102,179,146,165,142,161,156,72,183,73,33,187,143,106,34,179,54,73,93,133,54,199,137,156,79,247,2,175,249,65,56,1,231,62,116,133,95,86,174,238,141,71,95,88,137,69,100,85,14,150,248,41,253,22,5,80,136,37,238,154,15,179,234,52,112,199,219,53,188,129,114,234,119,57,164,5,69,34,219,20,127,165,138,180,50,178,87,105,181,88,52,85,82,157,158,56,196,20,9,37,167,39,133,78,253,142,34,192,202,99,46,43,15,128,149,193,1,86,134,152,18,129,178,12,93,84,237,189,200,64,125,37,19,27,68,39,54,203,136,40,119,36,163,41,162,181,41,34,163,41,46,102,31,217,221,207,249,178,80,
54,202,178,0,65,23,8,98,199,245,97,149,115,161,181,97,129,8,245,219,105,233,193,26,154,107,102,39,195,179,172,217,203,119,162,82,244,180,180,217,229,185,8,118,168,142,225,242,144,105,16,231,101,49,30,68,81,6,120,41,131,165,172,119,16,242,109,179,117,144,64,253,110,198,109,153,47,225,218,197,90,78,148,132,107,103,66,181,144,216,198,200,210,210,76,115,15,82,159,190,140,88,232,183,128,19,124,23,205,68,175,137,113,229,158,22,242,4,157,227,97,244,187,199,163,191,157,253,123,59,223,103,224,24,8,218,214,144,137,183,211,168,43,104,232,194,94,138,15,28,223,150,180,139,187,156,137,233,174,18,172,101,127,210,202,226,217,100,222,145,86,98,149,190,240,26,205,136,188,38,238,52,99,178,76,161,89,163,72,41,110,138,198,3,75,32,185,195,230,94,106,112,63,251,183,119,62,68,131,239,189,108,42,100,155,11,127,250,195,151,171,189,212,161,205,14,194,86,98,69,176,87,216,243,152,6,81,46,171,52,189,87,36,1,137,81,141,119,129,179,142,200,42,248,214,229,128,43,117,177,20,147,21,230,101,155,85,232,123,239,181,
146,244,47,37,125,116,48,125,206,180,136,196,90,214,205,13,69,217,37,246,240,147,43,45,91,23,183,202,14,253,88,133,148,72,118,215,66,148,193,46,140,98,35,209,186,77,0,245,99,21,25,204,27,94,214,141,214,186,49,110,143,167,238,124,172,176,125,139,236,237,171,16,120,3,136,108,181,207,195,226,245,102,100,106,189,149,109,47,219,46,24,202,188,38,0,114,85,237,98,32,212,144,85,174,170,97,38,183,27,0,218,119,203,1,56,143,61,231,1,168,178,165,172,210,86,170,253,157,138,250,248,92,253,26,123,122,195,99,127,17,174,174,65,192,128,32,86,100,183,22,144,214,38,61,212,160,85,125,42,81,179,72,95,5,175,129,39,61,254,43,218,54,192,247,248,237,224,80,236,222,200,58,87,34,96,5,56,121,116,17,56,111,139,240,139,172,220,70,53,25,107,149,190,172,93,22,174,55,21,23,71,46,122,183,2,166,28,184,166,141,140,214,180,21,68,114,144,32,162,80,11,139,30,227,2,92,33,36,52,95,60,189,136,206,102,141,35,197,186,108,183,219,56,84,34,12,84,97,222,9,5,188,84,171,115,142,138,194,120,235,233,178,205,217,157,71,4,145,104,
204,164,246,179,137,130,167,141,130,3,93,74,211,145,13,60,173,241,22,14,118,220,166,163,235,11,1,215,94,205,216,2,78,243,139,23,82,84,250,226,211,196,175,22,137,214,244,241,183,233,119,83,162,213,37,36,146,17,218,68,134,148,233,156,207,168,133,131,131,145,204,52,103,48,69,169,141,4,26,31,100,36,126,112,70,54,2,174,199,188,140,88,230,87,152,183,177,201,64,103,5,146,57,43,106,73,31,186,166,127,249,241,22,12,250,47,87,17,196,94,161,53,34,130,184,191,20,253,30,4,196,96,9,2,156,158,95,246,16,208,125,98,94,253,21,90,225,21,133,90,203,120,193,28,186,105,11,8,217,22,16,112,242,208,183,102,180,214,24,73,5,223,94,71,162,54,18,173,32,162,37,41,182,234,33,154,3,69,71,96,243,202,96,92,83,158,57,196,138,214,151,139,121,211,81,235,87,24,224,144,78,41,12,181,214,8,26,111,180,178,191,66,117,48,179,171,112,183,222,76,104,160,148,186,37,82,83,122,182,145,74,226,22,253,155,232,45,53,90,168,33,241,27,8,105,53,215,113,181,244,236,33,147,164,238,17,107,110,219,217,174,32,146,6,86,137,123,113,44,174,
235,102,188,119,225,168,96,234,170,64,233,71,41,133,29,234,145,125,73,212,217,114,68,173,45,87,143,126,19,215,72,164,46,162,10,175,45,229,13,104,25,31,125,241,178,62,26,62,168,255,78,182,228,133,100,173,159,5,210,206,153,12,18,181,115,89,201,72,24,87,52,2,218,45,95,195,163,82,157,13,192,121,0,93,217,240,162,11,214,233,172,108,132,145,43,219,116,86,182,204,164,234,103,16,48,32,136,149,5,100,90,213,166,69,118,40,37,166,131,239,172,38,234,88,122,12,233,128,218,10,150,37,210,74,189,232,0,231,148,192,115,130,235,225,25,217,183,139,71,100,134,21,234,131,93,12,156,248,244,20,70,2,88,131,176,99,1,64,187,30,51,217,245,216,207,4,4,40,10,203,80,246,238,63,3,177,131,50,226,216,195,33,6,196,17,54,120,198,72,23,194,234,119,168,88,150,140,16,144,100,29,60,110,205,202,183,156,46,162,10,176,14,128,204,95,84,41,42,150,210,215,132,176,60,219,0,78,65,214,20,1,39,17,171,163,108,84,22,181,26,186,202,79,23,145,216,155,80,36,121,59,24,187,4,161,37,195,150,150,132,152,179,141,169,205,182,49,248,166,139,
96,30,167,239,113,36,183,0,180,142,114,52,19,221,178,226,205,179,140,56,12,238,134,219,231,105,221,103,49,176,183,193,139,5,143,236,96,96,240,173,235,47,52,7,223,186,38,135,254,245,197,161,127,246,254,23,127,255,131,221,86,175,255,8,182,187,237,149,202,35,196,216,101,15,21,253,245,232,119,104,17,127,151,3,230,35,212,217,237,44,103,255,122,244,249,194,18,120,55,18,239,74,246,55,162,207,161,252,17,234,236,114,142,120,132,58,187,156,100,220,111,93,139,121,182,218,30,111,211,23,255,14,112,226,215,222,78,58,119,147,206,157,190,241,170,55,251,143,208,106,183,194,62,250,81,101,161,191,219,98,192,10,220,78,2,41,48,39,156,16,108,51,9,0,39,65,218,27,125,143,47,222,169,60,98,237,219,237,110,133,34,139,48,84,191,205,184,13,1,156,232,242,1,39,224,152,151,1,122,240,33,18,119,217,126,187,63,192,219,20,221,127,244,91,88,16,201,132,201,71,249,71,156,11,119,249,78,171,129,202,110,7,145,172,91,178,96,171,239,126,139,111,224,198,104,98,100,201,120,145,163,230,35,130,106,183,254,128,31,44,137,72,
21,82,115,222,63,234,14,204,105,146,152,205,82,67,193,188,49,191,121,47,69,191,131,121,223,54,235,192,204,197,74,105,230,34,51,59,0,211,171,175,246,225,63,208,1,165,174,167,82,151,195,60,189,219,125,155,163,197,110,210,74,94,130,162,57,115,216,13,81,128,8,51,4,198,60,34,18,176,187,85,12,106,79,94,237,227,72,88,112,156,11,4,0,140,16,36,225,137,43,60,176,157,60,58,64,88,27,90,107,77,16,74,235,95,11,182,47,65,112,244,97,62,71,159,236,217,196,21,173,130,129,55,13,112,63,195,115,253,209,23,30,88,192,0,11,144,172,109,50,64,158,239,182,50,142,26,56,207,164,52,33,212,1,36,183,140,1,137,84,146,166,1,15,65,214,110,230,68,137,221,121,182,79,54,65,19,154,34,81,7,67,86,110,172,133,152,53,10,181,73,85,9,62,219,72,166,208,238,116,183,173,95,225,233,48,39,135,150,208,0,115,90,46,52,177,70,15,178,255,80,113,255,226,179,221,230,114,36,0,159,166,194,88,100,188,0,75,191,93,140,153,161,48,136,86,8,155,33,138,219,200,224,155,1,173,25,50,110,37,192,179,18,36,154,198,91,28,235,2,129,237,105,96,144,34,
129,33,73,158,46,239,242,17,200,40,232,123,214,250,206,195,203,177,193,132,244,102,207,109,204,42,209,230,254,189,95,37,165,220,106,46,252,217,214,32,175,169,252,142,141,14,166,83,140,116,112,189,219,135,24,221,65,3,45,233,211,190,146,173,19,151,62,223,72,60,209,80,12,88,78,190,172,154,125,169,25,58,239,121,160,65,106,55,228,142,42,220,36,216,252,66,223,130,207,55,179,93,202,150,61,90,104,212,10,192,234,231,217,2,40,196,234,231,0,152,2,148,172,58,5,89,253,74,55,210,162,202,2,228,1,142,64,17,19,108,214,2,130,220,172,44,124,75,76,176,23,179,228,236,148,66,60,13,72,131,58,1,85,151,156,61,33,169,108,181,64,146,23,187,104,175,114,214,21,121,253,88,68,98,215,67,21,86,13,52,129,116,124,172,50,32,148,26,134,82,38,12,82,98,129,179,102,36,201,218,211,101,166,126,241,227,93,78,216,97,161,250,124,184,118,126,169,24,128,77,39,98,247,119,151,80,144,109,222,27,145,22,25,16,231,37,206,208,158,97,239,111,117,184,163,254,250,17,219,132,221,54,198,179,203,120,41,16,138,34,172,100,91,149,162,108,
40,118,123,56,68,234,177,3,49,70,239,124,244,151,182,147,217,21,184,187,108,183,67,239,18,38,3,219,213,9,11,133,111,93,150,210,143,11,228,11,87,241,187,245,107,40,167,1,246,34,17,73,165,69,110,71,214,85,84,116,100,45,166,152,23,178,5,32,34,13,0,253,104,212,248,225,200,98,115,103,5,218,200,169,153,38,155,181,112,221,156,34,235,209,23,187,243,51,25,65,167,178,133,168,226,99,254,116,49,40,33,231,8,106,100,11,41,247,103,1,112,68,49,224,136,202,137,202,185,140,168,18,64,181,106,70,212,5,152,59,230,48,78,101,97,119,107,183,131,38,210,168,117,25,90,45,5,16,91,188,136,138,30,35,50,125,179,252,104,172,48,98,165,216,110,135,82,153,97,245,101,6,100,185,26,134,80,228,204,67,196,18,225,62,243,131,141,74,127,85,22,172,138,13,187,42,67,214,129,176,205,9,122,155,22,155,203,78,124,104,143,154,130,53,36,69,3,10,230,141,159,213,47,145,210,66,103,23,171,107,9,71,56,190,73,8,36,2,207,18,17,89,150,40,211,113,158,197,200,253,201,148,48,23,167,234,85,130,0,145,7,187,169,31,254,9,187,169,15,214,31,252,
236,203,7,95,113,119,248,111,70,134,254,240,253,238,208,94,155,197,255,49,130,238,181,182,250,143,17,96,175,185,84,121,140,96,123,141,78,229,49,2,236,241,109,42,250,180,238,223,237,211,239,239,213,54,250,143,17,104,175,126,173,242,24,197,247,26,55,115,126,59,225,55,163,223,160,111,188,28,231,51,107,240,185,27,112,205,2,127,63,225,238,7,125,182,173,143,201,234,189,250,213,190,233,179,110,63,38,31,246,216,151,5,189,135,129,207,106,16,244,24,151,220,205,43,57,222,140,113,190,119,134,126,201,151,187,75,195,179,109,242,56,95,7,31,227,176,61,246,111,238,243,109,206,109,247,122,197,252,57,138,61,38,97,247,216,251,4,92,161,151,116,154,87,131,31,119,167,150,139,165,209,242,18,24,216,167,191,199,17,206,116,186,212,102,255,168,45,133,225,186,55,115,98,43,39,90,104,42,15,116,183,203,68,72,208,131,179,52,239,34,177,44,194,247,209,144,228,86,106,70,95,120,109,224,228,201,38,125,123,144,121,91,190,72,200,188,250,117,60,41,143,213,110,165,32,124,176,53,97,238,92,130,209,106,50,194,20,54,13,128,
34,220,19,160,36,225,187,231,99,202,220,30,223,51,143,72,182,8,32,133,113,111,69,128,2,88,133,162,140,199,13,88,32,208,90,21,156,41,85,184,239,246,252,42,78,23,92,243,10,136,146,157,205,176,89,178,137,9,239,18,29,26,95,97,249,76,74,17,14,220,229,153,18,119,114,102,221,125,144,125,148,149,40,221,47,197,169,191,215,34,156,108,164,116,239,34,146,121,158,48,145,36,236,138,221,31,208,185,29,227,61,140,104,137,9,19,193,177,139,14,248,175,18,159,116,16,253,53,188,201,129,17,39,132,173,214,239,245,31,243,113,97,111,64,15,205,133,223,35,173,76,47,229,44,78,45,78,94,129,143,77,75,120,11,142,143,224,110,7,105,130,156,118,34,225,231,180,195,114,238,3,111,167,210,58,45,185,34,140,129,175,248,161,187,128,61,238,6,131,53,173,69,41,253,141,85,250,31,236,113,87,24,38,185,19,243,220,21,62,230,104,187,71,9,179,233,116,87,248,152,109,237,94,73,57,46,120,237,36,238,10,99,156,190,109,140,237,92,82,50,229,184,43,140,249,181,152,31,132,205,114,216,132,187,66,199,25,119,133,22,172,56,159,179,67,140,67,
71,2,15,82,16,60,211,7,79,252,6,113,155,177,80,108,201,93,161,21,224,174,208,138,115,87,24,125,130,203,62,128,190,233,94,206,56,47,114,19,255,162,123,9,223,91,223,76,245,75,208,81,159,187,194,176,121,41,77,215,35,22,117,87,104,194,108,19,109,123,62,20,185,159,19,149,61,238,10,67,2,36,181,4,41,241,64,51,56,72,51,46,99,172,57,119,133,150,132,187,194,144,20,141,148,145,37,106,74,177,226,147,171,233,113,87,232,40,228,174,208,249,196,93,97,240,187,153,174,191,177,25,116,148,160,38,132,9,101,130,54,7,184,224,252,176,239,137,18,119,220,21,134,13,72,109,217,164,148,101,221,21,30,21,133,227,83,122,157,31,156,30,41,23,169,36,102,180,153,81,206,229,132,144,181,251,74,110,19,242,202,109,238,10,115,62,221,11,252,145,112,2,206,125,232,10,159,187,66,227,233,59,179,25,20,217,184,35,116,32,151,56,42,125,238,12,77,160,196,159,238,12,77,161,172,41,188,251,136,164,162,88,40,169,6,148,23,137,112,85,139,54,170,136,53,47,15,220,47,139,25,119,134,81,191,56,23,4,69,40,57,45,145,49,86,199,160,168,59,195,
80,146,122,96,35,0,96,165,112,132,149,34,182,100,12,238,12,173,147,238,12,31,115,178,222,227,206,48,242,25,68,39,248,102,196,152,238,12,131,34,90,155,34,50,154,226,98,246,145,221,253,156,231,206,48,68,36,234,45,34,4,93,57,136,33,215,137,117,213,88,213,174,53,28,165,154,182,138,35,92,197,105,93,213,113,132,251,68,163,251,95,169,122,247,247,150,137,29,21,140,65,30,20,135,116,50,108,203,26,59,232,67,80,34,119,100,54,135,99,198,57,223,44,34,63,0,112,232,124,153,161,67,117,51,2,18,24,30,63,120,62,25,12,170,117,25,7,223,33,71,62,217,54,232,106,91,228,242,210,100,222,161,135,181,13,7,93,211,79,122,92,25,26,190,75,53,23,31,206,174,134,231,202,48,232,220,59,30,116,191,60,30,125,90,243,121,176,243,3,6,222,221,107,226,37,49,88,229,75,64,216,12,78,174,239,80,114,5,160,125,91,195,46,219,47,245,185,228,52,37,46,79,13,199,103,171,160,156,53,148,203,203,240,34,173,188,88,163,82,40,44,74,165,104,224,109,141,55,239,164,0,108,239,228,179,178,109,43,154,15,182,67,219,41,249,195,212,164,104,246,213,
206,95,222,107,222,122,23,109,118,190,130,227,223,157,216,211,91,99,203,194,91,227,208,233,250,72,196,193,253,232,243,214,216,50,243,214,248,49,7,167,61,222,26,71,255,231,45,250,239,237,69,181,234,191,73,248,245,145,208,237,218,136,173,200,91,227,208,13,186,142,80,250,138,80,222,26,63,230,128,195,150,115,57,147,42,230,185,190,75,248,72,178,38,244,100,116,222,26,27,142,183,198,166,175,183,198,254,193,155,167,16,8,0,9,200,219,82,143,243,214,216,138,232,173,177,127,240,214,56,50,224,86,106,6,130,188,198,91,227,200,16,40,59,67,104,157,17,16,114,70,220,205,254,118,244,121,107,108,60,222,26,7,99,118,11,60,161,220,211,91,99,16,63,216,227,185,118,32,210,138,16,111,141,35,44,32,228,192,76,21,120,107,28,129,143,138,10,19,222,26,155,160,222,26,7,66,137,248,130,0,65,17,224,173,113,218,118,142,61,255,187,216,231,55,194,230,107,31,121,156,183,198,209,231,173,49,3,239,236,233,173,177,173,168,183,198,76,29,219,227,173,113,240,164,149,17,120,107,28,233,78,235,80,190,146,50,175,164,204,24,203,
201,148,34,240,214,56,68,44,125,230,173,67,226,243,214,56,68,101,222,73,138,219,143,224,95,76,124,156,97,149,176,129,224,120,107,236,126,241,34,111,141,61,206,91,99,47,93,124,34,140,37,76,59,112,35,240,214,24,12,2,17,8,75,190,156,148,83,130,1,37,250,81,46,66,18,222,26,71,31,47,88,50,36,180,119,112,175,251,180,234,243,214,216,154,53,87,35,16,121,107,108,175,242,214,56,248,165,37,121,107,28,248,72,40,252,214,181,88,100,121,107,28,166,231,59,171,39,120,107,28,91,51,90,153,140,183,198,238,243,214,216,4,121,107,28,153,182,17,125,222,26,59,156,120,107,236,121,222,26,71,127,251,83,250,239,236,241,214,56,224,183,114,126,51,194,143,183,198,230,199,91,99,199,53,111,141,35,206,111,127,47,250,219,217,231,173,49,3,239,237,241,214,56,2,255,246,15,34,126,177,136,226,183,88,150,135,174,65,0,203,57,81,232,59,81,50,49,120,107,28,125,24,186,44,18,67,242,72,217,208,240,214,216,137,162,183,198,72,246,14,155,216,0,224,133,110,48,196,148,38,72,80,188,157,121,122,107,140,175,142,237,241,214,56,85,77,
196,204,241,30,62,20,167,21,124,38,68,222,26,219,230,101,183,203,91,227,40,62,215,55,93,68,120,107,108,120,222,26,7,67,36,181,196,104,224,24,66,67,71,115,47,250,188,53,14,223,22,201,121,107,108,159,241,214,56,4,202,224,27,104,114,47,8,243,214,216,65,198,91,227,176,249,250,71,97,66,124,40,19,174,111,103,255,65,246,169,182,94,173,183,183,153,63,198,106,29,123,191,149,173,227,22,176,184,128,183,198,22,156,183,198,161,72,158,189,120,168,17,138,92,39,225,123,124,201,217,211,219,16,131,242,54,196,225,208,33,30,29,231,87,50,78,41,95,202,11,94,6,68,156,178,202,41,126,203,89,151,203,45,195,243,54,196,112,101,31,92,246,3,133,37,111,67,204,167,179,146,244,47,37,253,60,9,103,13,226,236,194,219,144,176,46,165,222,241,193,178,230,150,227,150,91,237,130,244,131,11,81,147,228,6,208,8,188,13,137,22,68,185,71,111,67,252,131,183,33,193,27,94,214,141,214,57,200,184,115,62,117,47,139,75,145,93,111,67,222,2,68,54,222,134,196,142,172,25,59,50,222,134,56,98,234,189,108,121,27,226,1,222,134,216,92,124,
24,53,2,111,67,162,197,76,90,187,107,218,120,233,7,95,190,13,200,219,144,199,124,220,217,227,109,200,99,190,229,236,241,54,228,49,159,159,246,120,27,226,62,111,67,2,62,119,25,122,27,18,128,32,234,235,251,30,111,67,66,155,244,16,111,67,98,91,192,184,150,72,222,134,56,40,121,27,18,227,185,148,22,109,121,80,17,227,28,216,5,207,219,16,155,153,183,33,49,158,17,192,195,13,7,17,111,67,162,80,249,88,204,202,138,106,178,42,111,67,108,237,146,215,111,118,214,16,212,219,144,189,242,125,71,111,67,28,231,188,13,49,201,85,68,116,134,39,11,222,134,88,4,222,134,120,190,120,154,183,33,193,26,71,202,211,92,144,134,234,56,84,34,12,84,97,94,170,240,73,220,42,232,109,136,221,83,227,109,136,205,169,183,33,38,193,219,144,208,114,54,81,240,180,55,36,56,208,91,230,116,36,111,67,60,206,219,16,179,44,142,230,34,204,112,124,31,142,144,1,78,177,197,219,144,16,149,190,68,229,109,72,136,68,107,250,248,219,244,121,27,98,137,244,54,196,70,224,246,215,148,120,27,18,81,11,7,71,45,153,233,140,4,83,202,241,54,196,
227,131,140,196,15,138,242,86,35,224,120,27,98,35,150,121,222,134,132,177,201,64,25,187,131,100,206,138,90,210,135,174,233,243,54,4,6,236,92,16,196,94,161,117,221,69,16,247,249,186,229,178,8,1,229,35,111,67,162,218,33,160,251,196,188,182,92,188,13,49,92,81,72,111,67,130,67,55,109,1,33,219,2,2,178,69,147,190,53,163,181,198,72,234,60,229,51,61,3,253,61,222,134,132,36,197,86,188,13,137,64,225,198,32,120,101,48,234,109,72,132,88,209,154,175,242,97,222,116,148,222,134,184,168,242,54,196,19,188,13,49,70,233,243,54,36,152,93,133,187,245,6,208,122,19,117,214,147,212,244,214,18,169,36,46,111,67,60,206,141,135,213,224,109,136,197,231,109,72,168,201,219,16,235,201,219,16,3,242,54,36,218,118,182,124,172,246,64,249,32,89,92,199,219,16,7,17,111,67,162,85,129,82,84,149,82,200,219,144,240,37,81,103,203,17,181,182,92,61,250,188,13,177,72,188,13,49,158,222,134,4,160,101,100,65,224,109,136,101,227,109,72,180,228,133,124,162,183,33,254,209,156,12,18,188,13,113,188,214,72,24,87,52,2,218,45,215,7,
254,209,60,27,128,188,13,137,202,134,23,93,217,78,103,101,35,140,212,175,77,103,101,203,146,169,183,33,1,8,162,222,134,176,243,96,68,150,47,37,134,183,33,161,38,234,88,77,12,233,144,221,10,150,37,210,74,189,224,65,69,164,4,158,19,28,111,67,108,95,46,14,108,6,110,102,194,197,192,137,143,222,134,24,128,183,33,17,11,0,30,9,121,236,39,215,235,134,202,20,120,27,18,27,228,12,68,238,99,204,145,183,33,1,136,35,228,40,222,15,89,98,222,134,184,63,88,62,9,1,73,198,213,79,104,38,194,82,141,183,33,6,228,109,136,205,95,84,41,42,150,210,199,219,16,123,150,183,33,14,50,189,13,137,36,98,117,52,33,106,163,36,136,143,213,67,123,188,13,137,143,13,72,34,7,151,96,228,109,72,72,134,45,143,44,150,212,102,219,24,91,57,57,17,204,182,167,239,113,36,119,173,165,117,50,195,207,133,13,250,138,11,222,134,68,24,220,13,183,243,54,36,250,44,35,14,11,240,180,224,205,93,39,59,230,222,186,205,248,205,250,91,183,25,147,67,255,118,100,232,143,222,255,124,104,191,201,5,206,19,24,238,215,136,225,39,112,216,175,174,247,
159,64,105,159,237,157,39,230,110,246,159,64,104,191,186,25,227,115,151,163,63,191,218,127,194,82,187,95,89,233,63,129,227,126,131,113,36,222,199,50,65,231,90,194,211,23,126,147,75,70,19,100,111,244,4,147,236,179,152,27,176,1,35,35,94,137,126,243,86,2,150,137,230,70,72,194,206,228,9,182,223,167,34,152,16,127,36,245,4,219,236,87,32,32,9,230,152,23,167,10,156,213,231,11,246,19,108,186,207,197,197,19,108,188,207,201,61,250,119,163,207,55,68,11,210,189,92,49,93,46,54,162,207,184,248,240,53,44,240,192,55,29,240,223,166,195,159,28,89,142,6,120,82,160,249,32,250,124,130,55,60,23,57,30,47,252,11,253,210,111,221,14,56,222,132,4,157,251,73,7,254,114,73,245,90,197,158,168,32,135,244,169,210,202,51,149,171,209,159,163,149,190,179,120,98,150,150,119,50,71,245,67,62,25,154,143,72,71,229,78,207,242,226,196,227,124,155,123,194,183,186,125,46,112,172,247,226,173,232,243,39,7,129,7,188,244,95,188,222,15,56,228,148,125,248,230,244,132,244,221,239,162,191,250,188,183,241,124,123,43,232,242,108,60,
224,240,139,224,22,240,11,15,46,246,107,208,81,164,113,31,107,255,241,128,222,112,45,224,196,167,201,226,18,6,233,69,100,20,0,46,25,35,98,32,224,136,89,206,136,201,0,169,19,89,10,8,54,54,22,132,211,97,56,98,45,225,147,113,151,11,36,115,100,75,251,132,130,52,176,92,147,190,44,207,159,64,132,231,144,80,30,175,35,153,8,47,64,216,26,32,177,52,168,241,88,193,63,22,238,230,4,187,106,6,30,125,177,127,241,243,254,19,190,66,238,115,27,111,25,40,20,244,251,251,85,90,57,145,51,246,19,62,141,239,159,7,238,60,227,122,93,99,64,158,194,120,162,197,45,61,3,149,253,206,149,116,227,122,184,163,132,45,0,103,141,193,155,24,75,125,145,141,160,121,22,195,86,113,156,120,157,199,78,231,105,121,242,99,117,120,42,20,129,190,20,142,227,126,44,2,133,192,117,128,67,80,142,184,68,98,72,70,174,47,220,231,101,88,192,101,34,116,122,217,47,129,146,112,151,174,125,13,222,7,251,60,170,8,243,97,3,153,175,197,183,220,32,140,35,76,24,193,196,136,77,174,35,36,141,80,217,191,132,36,6,224,43,96,96,80,28,60,128,10,194,
152,7,64,213,167,10,107,231,4,230,140,156,79,163,92,66,39,35,200,40,86,6,159,189,69,18,187,150,244,72,187,150,242,192,109,96,4,1,105,232,180,150,147,29,21,196,117,228,185,7,42,3,187,52,31,38,6,173,1,238,60,250,194,24,11,232,165,120,169,240,105,40,196,195,242,18,134,39,70,1,121,187,64,162,151,33,217,91,167,34,9,153,197,165,182,197,132,235,51,89,46,141,231,120,204,18,133,21,19,72,188,58,144,178,50,231,112,211,174,61,192,20,194,152,199,157,178,85,141,58,99,10,40,110,155,41,228,116,232,217,215,223,103,56,17,116,202,112,102,12,106,20,70,144,192,124,93,141,208,161,198,169,166,148,220,230,246,206,227,124,53,181,16,29,52,214,124,147,119,89,33,21,142,145,84,5,128,191,188,8,130,88,64,177,54,136,189,18,67,120,67,12,185,149,54,62,87,16,1,95,138,241,74,244,121,181,120,36,22,185,88,8,60,198,237,44,232,133,47,210,58,40,109,235,220,15,235,240,185,35,178,135,107,232,0,228,66,39,48,211,126,197,4,60,164,11,149,105,189,44,100,57,237,64,73,170,14,50,151,219,145,212,25,23,137,151,30,61,133,7,72,12,
71,107,250,174,71,171,138,88,42,250,28,214,245,26,41,63,88,250,123,25,106,97,198,63,219,26,228,82,89,61,59,228,182,184,243,8,42,90,5,142,6,216,210,216,176,252,249,73,180,153,132,109,197,160,44,174,199,79,161,49,251,94,115,107,67,75,51,77,110,164,130,61,78,211,227,167,253,234,133,8,182,249,139,177,216,207,47,102,219,201,182,5,45,107,6,87,197,20,207,184,162,93,202,150,119,31,30,152,229,184,226,85,106,78,236,165,108,149,170,224,64,230,112,17,235,24,165,113,118,225,239,245,247,245,98,39,4,202,149,190,161,1,121,147,215,78,88,22,193,244,218,41,74,70,214,87,94,59,217,59,218,75,250,7,175,157,114,85,203,1,94,59,89,185,150,54,34,10,49,94,59,217,59,122,237,228,31,122,237,20,245,157,215,78,30,209,193,214,212,56,216,134,205,102,115,133,160,108,91,32,12,99,87,211,42,183,56,216,122,156,131,109,132,35,173,147,115,33,224,56,216,90,51,30,229,122,158,131,109,72,73,95,193,197,193,54,60,64,107,250,24,220,244,57,216,154,129,14,182,78,213,226,103,14,182,225,119,56,184,120,99,8,39,16,152,226,204,193,
214,227,156,126,204,161,131,135,28,182,141,128,227,96,107,67,150,121,14,182,79,56,151,237,175,94,138,181,145,131,109,208,175,37,125,232,154,62,7,91,24,244,247,57,216,90,160,21,90,35,34,136,22,213,21,28,160,62,127,244,96,6,28,108,159,112,192,219,231,96,23,125,156,171,62,7,91,195,21,133,116,176,13,14,188,52,11,227,205,135,17,244,210,44,162,141,35,44,177,211,223,231,165,89,208,44,225,192,75,51,219,83,47,205,60,83,12,174,151,102,193,166,21,122,180,121,105,22,65,134,156,50,148,94,154,89,112,94,154,89,64,206,51,161,0,22,86,182,242,210,44,21,128,187,55,62,237,52,41,41,230,212,43,113,91,22,96,189,52,179,251,120,105,246,132,139,152,125,189,52,243,0,39,27,163,12,218,180,114,71,249,98,90,152,89,238,108,19,32,110,1,112,123,5,0,253,208,19,178,8,201,54,76,236,233,220,173,52,23,115,160,129,102,2,219,159,255,235,153,174,231,178,37,154,149,181,243,191,93,12,202,132,211,55,243,189,138,202,238,207,2,160,31,179,226,166,77,230,156,14,12,78,95,52,112,250,242,125,48,210,183,171,244,133,219,155,16,197,
179,18,181,3,85,235,68,146,168,223,194,159,14,33,22,11,11,158,186,117,9,57,37,65,169,109,45,146,76,112,61,240,109,111,34,75,243,131,72,203,16,29,20,3,30,181,153,81,75,129,162,71,109,251,156,16,35,175,138,77,122,200,96,90,240,116,53,71,83,201,196,71,129,224,77,101,115,122,76,5,239,226,160,54,223,36,3,16,165,132,88,199,165,202,204,1,64,42,91,54,124,77,242,75,202,53,96,232,133,168,156,180,218,9,216,69,123,17,226,217,191,51,251,34,222,210,142,177,14,130,9,211,183,213,50,129,91,48,180,213,176,243,17,194,149,180,34,240,182,46,248,134,3,207,112,8,226,82,2,31,151,18,248,123,91,0,188,75,55,53,85,142,156,39,47,221,7,95,253,10,22,242,177,74,49,139,199,7,15,227,126,115,133,163,228,119,244,48,238,246,208,191,27,29,250,231,239,95,28,58,168,81,118,159,66,149,31,125,183,149,141,254,83,176,15,230,174,247,159,130,124,80,189,214,127,10,213,131,218,205,152,231,88,233,241,58,213,255,41,98,29,212,56,246,25,115,14,72,97,20,72,14,158,198,156,219,138,241,121,177,66,208,131,10,215,83,230,81,101,171,108,
16,14,0,65,11,166,22,70,196,245,131,239,194,70,121,3,224,137,254,65,3,102,24,231,128,127,200,241,20,99,29,112,102,139,254,131,232,183,186,149,167,24,243,128,179,224,83,140,123,192,61,118,244,239,70,159,251,237,192,235,37,222,122,246,175,70,159,7,18,33,17,173,4,169,111,69,159,219,102,243,169,221,143,241,38,165,3,66,125,204,144,162,243,214,220,24,173,181,190,57,242,39,172,238,243,241,201,128,124,242,54,103,158,251,153,67,235,182,224,250,7,156,2,13,207,233,217,28,218,16,228,107,223,1,59,53,107,192,169,217,240,124,108,15,201,176,128,36,91,0,158,29,232,1,159,66,130,95,218,144,21,221,182,229,148,109,99,243,47,80,12,207,25,201,244,43,204,203,209,53,250,162,83,165,208,6,130,188,226,25,36,214,12,23,69,33,25,28,100,243,162,106,147,13,118,168,2,9,133,2,219,102,139,82,34,128,255,42,98,2,21,230,69,176,130,42,110,249,162,229,31,213,123,41,227,157,156,248,202,19,143,190,56,152,110,246,159,78,139,23,210,75,134,233,207,213,239,31,76,99,61,143,167,54,211,104,161,254,12,112,51,180,117,198,37,10,
71,168,136,172,213,180,154,98,78,19,37,146,234,41,115,141,205,84,8,153,129,95,18,161,170,24,84,228,115,242,115,123,30,237,56,141,29,84,54,43,22,254,60,161,224,254,114,244,171,55,42,134,155,39,100,20,230,85,224,132,63,191,20,125,62,7,4,222,181,196,91,57,74,103,246,74,229,41,149,250,96,102,41,84,57,79,254,152,126,58,176,142,53,223,86,173,134,41,100,154,121,76,224,180,186,144,14,77,147,113,44,183,219,216,123,25,175,2,93,89,255,34,243,212,171,131,65,64,241,6,192,0,53,4,51,65,0,68,240,34,182,52,96,218,148,43,22,19,188,8,67,143,103,214,214,107,193,96,30,6,22,36,35,139,3,77,196,11,112,162,91,67,16,181,172,178,193,175,140,179,125,101,130,28,202,80,172,111,145,67,118,214,74,66,114,102,50,106,5,157,164,67,157,63,220,8,136,237,95,133,160,218,8,98,78,52,92,192,178,12,205,223,103,64,226,205,255,60,197,76,187,242,89,195,180,155,68,167,74,73,9,111,253,169,7,19,59,95,31,112,34,139,24,41,129,93,33,87,205,68,32,98,194,253,96,224,102,149,156,135,166,120,233,59,228,209,9,108,162,9,30,206,133,252,
105,195,194,92,95,15,34,217,56,65,135,245,144,95,86,107,66,90,226,241,120,54,0,168,27,206,198,20,159,239,127,14,183,18,38,188,127,49,94,201,32,62,34,68,29,73,155,22,111,22,157,184,106,139,112,229,173,152,69,228,175,128,60,80,161,16,73,217,42,241,174,120,174,80,10,67,249,168,235,165,190,151,149,161,16,42,42,214,112,145,221,47,141,106,11,127,48,114,80,39,82,29,201,151,130,101,165,147,28,8,12,118,135,7,165,196,13,74,24,145,110,142,100,162,172,205,18,110,124,118,103,79,47,8,62,85,226,230,4,19,81,50,81,93,69,255,2,125,118,111,131,249,70,59,76,86,2,182,73,224,122,241,88,212,184,28,13,33,137,90,108,89,97,66,140,217,208,132,205,153,151,205,155,43,203,70,172,95,29,177,32,5,111,158,8,151,119,171,156,149,172,9,23,160,65,48,53,229,59,182,17,26,173,36,52,21,18,92,100,222,41,133,196,178,76,141,242,39,65,56,183,69,184,208,106,156,103,250,244,89,44,114,113,225,82,37,130,0,124,193,55,22,146,238,210,78,235,160,190,248,46,82,14,7,65,84,53,65,52,176,132,8,230,101,29,2,26,231,3,122,104,148,245,178,
5,156,214,79,46,248,194,68,152,94,154,95,0,78,38,109,48,174,126,117,109,217,116,154,43,35,1,135,96,26,47,81,200,55,223,24,135,174,241,237,50,230,147,79,41,74,85,198,37,207,5,162,216,244,9,133,35,240,185,234,113,78,139,113,230,237,218,44,138,109,198,189,206,19,74,150,27,122,114,109,61,13,199,230,45,66,2,190,127,46,125,224,93,113,18,254,2,122,152,190,60,89,103,119,124,80,235,240,203,54,230,156,99,25,106,28,162,99,100,53,71,154,156,94,204,182,172,124,37,82,75,127,190,94,2,4,64,47,14,232,33,127,212,180,143,176,35,88,10,37,120,115,235,105,196,216,220,229,39,203,68,253,7,131,165,176,194,95,126,56,42,107,28,123,141,51,216,196,149,181,126,154,93,179,151,197,178,139,155,99,47,232,212,153,91,123,114,205,63,202,50,55,160,54,189,6,53,45,165,211,18,69,63,102,169,52,90,144,42,216,204,233,71,90,41,253,102,9,82,141,235,174,3